# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from azure.identity import DefaultAzureCredential
from azure.mgmt.sql import SqlManagementClient

"""
# PREREQUISITES
    pip install azure-identity
    pip install azure-mgmt-sql
# USAGE
    python sql_vulnerability_assessment_baseline_add.py

    Before run the sample, please set the values of the client ID, tenant ID and client secret
    of the AAD application as environment variables: AZURE_CLIENT_ID, AZURE_TENANT_ID,
    AZURE_CLIENT_SECRET. For more info about how to get the value, please see:
    https://docs.microsoft.com/azure/active-directory/develop/howto-create-service-principal-portal
"""


def main():
    client = SqlManagementClient(
        credential=DefaultAzureCredential(),
        subscription_id="00000000-1111-2222-3333-444444444444",
    )

    response = client.sql_vulnerability_assessment_baselines.create_or_update(
        resource_group_name="vulnerabilityaseessmenttest-4711",
        server_name="vulnerabilityaseessmenttest-6411",
        vulnerability_assessment_name="default",
        baseline_name="default",
        parameters={
            "properties": {
                "latestScan": False,
                "results": {
                    "VA2063": [["AllowAll", "0.0.0.0", "255.255.255.255"]],
                    "VA2065": [["AllowAll", "0.0.0.0", "255.255.255.255"]],
                },
            }
        },
    )
    print(response)


# x-ms-original-file: specification/sql/resource-manager/Microsoft.Sql/preview/2022-02-01-preview/examples/SqlVulnerabilityAssessmentBaselineAdd.json
if __name__ == "__main__":
    main()
