// Copyright 2025 Specter Ops, Inc.
//
// Licensed under the Apache License, Version 2.0
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//
// SPDX-License-Identifier: Apache-2.0

// Code generated by MockGen. DO NOT EDIT.
// Source: github.com/specterops/bloodhound/cmd/api/src/services/saml (interfaces: Service)
//
// Generated by this command:
//
//	mockgen -copyright_file=../../../../../LICENSE.header -destination=./mocks/saml.go -package=mocks . Service
//

// Package mocks is a generated GoMock package.
package mocks

import (
	http "net/http"
	reflect "reflect"

	saml "github.com/crewjam/saml"
	gomock "go.uber.org/mock/gomock"
)

// MockService is a mock of Service interface.
type MockService struct {
	ctrl     *gomock.Controller
	recorder *MockServiceMockRecorder
	isgomock struct{}
}

// MockServiceMockRecorder is the mock recorder for MockService.
type MockServiceMockRecorder struct {
	mock *MockService
}

// NewMockService creates a new mock instance.
func NewMockService(ctrl *gomock.Controller) *MockService {
	mock := &MockService{ctrl: ctrl}
	mock.recorder = &MockServiceMockRecorder{mock}
	return mock
}

// EXPECT returns an object that allows the caller to indicate expected use.
func (m *MockService) EXPECT() *MockServiceMockRecorder {
	return m.recorder
}

// MakeAuthenticationRequest mocks base method.
func (m *MockService) MakeAuthenticationRequest(serviceProvider saml.ServiceProvider, idpURL, binding, resultBinding string) (*saml.AuthnRequest, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "MakeAuthenticationRequest", serviceProvider, idpURL, binding, resultBinding)
	ret0, _ := ret[0].(*saml.AuthnRequest)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// MakeAuthenticationRequest indicates an expected call of MakeAuthenticationRequest.
func (mr *MockServiceMockRecorder) MakeAuthenticationRequest(serviceProvider, idpURL, binding, resultBinding any) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "MakeAuthenticationRequest", reflect.TypeOf((*MockService)(nil).MakeAuthenticationRequest), serviceProvider, idpURL, binding, resultBinding)
}

// ParseResponse mocks base method.
func (m *MockService) ParseResponse(serviceProvider saml.ServiceProvider, req *http.Request, possibleRequestIDs []string) (*saml.Assertion, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ParseResponse", serviceProvider, req, possibleRequestIDs)
	ret0, _ := ret[0].(*saml.Assertion)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// ParseResponse indicates an expected call of ParseResponse.
func (mr *MockServiceMockRecorder) ParseResponse(serviceProvider, req, possibleRequestIDs any) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ParseResponse", reflect.TypeOf((*MockService)(nil).ParseResponse), serviceProvider, req, possibleRequestIDs)
}
