#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2017 Mopi
# SPDX-FileCopyrightText: © 2017 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# The Even More Incredible Machine
# send your bug reports to contact@dotslashplay.it
###

script_version=20240604.2

PLAYIT_COMPATIBILITY_LEVEL='2.29'

GAME_ID='the-even-more-incredible-machine'
GAME_NAME='The Even More Incredible Machine'

ARCHIVE_BASE_0_NAME='setup_the_even_more_incredible_machine_2.1.0.24.exe'
ARCHIVE_BASE_0_MD5='0486b8d5e65ea49ebf59b62a06cb9edd'
ARCHIVE_BASE_0_TYPE='innosetup'
ARCHIVE_BASE_0_SIZE='21000'
ARCHIVE_BASE_0_VERSION='1.0-gog2.1.0.24'
ARCHIVE_BASE_0_URL='https://www.gog.com/game/the_incredible_machine_mega_pack'

CONTENT_PATH_DEFAULT='app'
CONTENT_GAME_MAIN_FILES='
install.exe
tim.exe
install*
resource*
*.tim
*.drv'

USER_PERSISTENT_FILES='
*.cfg
*.CFG
*.tim
*.TIM'

APP_MAIN_EXE='tim.exe'
APP_MAIN_ICON='goggame-1207664023.ico'

# Load common functions

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
# shellcheck source=libplayit2.sh
. "$PLAYIT_LIB2"

# Extract game data

archive_extraction_default

# Include game data

content_inclusion_icons
content_inclusion_default

# Write launchers

launchers_generation

# Build packages

packages_generation
print_instructions

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

exit 0
