/* do not edit automatically generated by mc from MemUtils.  */
/* MemUtils.mod provides some basic memory utilities.

Copyright (C) 2001-2026 Free Software Foundation, Inc.
Contributed by Gaius Mulley <gaius.mulley@southwales.ac.uk>.

This file is part of GNU Modula-2.

GNU Modula-2 is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 3, or (at your option)
any later version.

GNU Modula-2 is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

Under Section 7 of GPL version 3, you are granted additional
permissions described in the GCC Runtime Library Exception, version
3.1, as published by the Free Software Foundation.

You should have received a copy of the GNU General Public License and
a copy of the GCC Runtime Library Exception along with this program;
see the files COPYING3 and COPYING.RUNTIME respectively.  If not, see
<http://www.gnu.org/licenses/>.  */

#include "config.h"
#include "system.h"
#include <stdbool.h>
#   if !defined (PROC_D)
#      define PROC_D
       typedef void (*PROC_t) (void);
       typedef struct { PROC_t proc; } PROC;
#   endif

#define _MemUtils_C

#include "GMemUtils.h"
#   include "GSYSTEM.h"


/*
   MemCopy - copys a region of memory to the required destination.
*/

extern "C" void MemUtils_MemCopy (void * from, unsigned int length, void * to);

/*
   MemZero - sets a region of memory: a..a+length to zero.
*/

extern "C" void MemUtils_MemZero (void * a, unsigned int length);


/*
   MemCopy - copys a region of memory to the required destination.
*/

extern "C" void MemUtils_MemCopy (void * from, unsigned int length, void * to)
{
  typedef unsigned int *MemCopy__T1;

  typedef unsigned char *MemCopy__T2;

  MemCopy__T1 pwb;
  MemCopy__T1 pwa;
  MemCopy__T2 pbb;
  MemCopy__T2 pba;

  while (length >= sizeof (unsigned int ))
    {
      pwa = static_cast<MemCopy__T1> (from);
      pwb = static_cast<MemCopy__T1> (to);
      (*pwb) = (*pwa);
      from = reinterpret_cast<void *> (reinterpret_cast<char *> (from)+sizeof (unsigned int ));
      to = reinterpret_cast<void *> (reinterpret_cast<char *> (to)+sizeof (unsigned int ));
      length -= sizeof (unsigned int );
    }
  while (length > 0)
    {
      pba = static_cast<MemCopy__T2> (from);
      pbb = static_cast<MemCopy__T2> (to);
      (*pbb) = (*pba);
      from = reinterpret_cast<void *> (reinterpret_cast<char *> (from)+sizeof (unsigned char ));
      to = reinterpret_cast<void *> (reinterpret_cast<char *> (to)+sizeof (unsigned char ));
      length -= sizeof (unsigned char );
    }
}


/*
   MemZero - sets a region of memory: a..a+length to zero.
*/

extern "C" void MemUtils_MemZero (void * a, unsigned int length)
{
  typedef unsigned int *MemZero__T3;

  typedef unsigned char *MemZero__T4;

  MemZero__T3 pwa;
  MemZero__T4 pba;

  pwa = static_cast<MemZero__T3> (a);
  while (length >= sizeof (unsigned int ))
    {
      (*pwa) = (unsigned int ) (0);
      pwa += sizeof (unsigned int );
      length -= sizeof (unsigned int );
    }
  pba = static_cast<MemZero__T4> ((void *) (pwa));
  while (length >= sizeof (unsigned char ))
    {
      (*pba) = (unsigned char ) (0);
      pba += sizeof (unsigned char );
      length -= sizeof (unsigned char );
    }
}

extern "C" void _M2_MemUtils_init (__attribute__((unused)) int argc, __attribute__((unused)) char *argv[], __attribute__((unused)) char *envp[])
{
}

extern "C" void _M2_MemUtils_fini (__attribute__((unused)) int argc, __attribute__((unused)) char *argv[], __attribute__((unused)) char *envp[])
{
}
