; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=i686-unknown-unknown -mattr=+avx2,+fma | FileCheck %s --check-prefixes=CHECK,X86
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx2,+fma | FileCheck %s --check-prefixes=CHECK,X64

declare <8 x float> @llvm.fma.v8f32(<8 x float>, <8 x float>, <8 x float>)
declare <4 x float> @llvm.fma.v4f32(<4 x float>, <4 x float>, <4 x float>)
declare float @llvm.fma.f32(float, float, float)
declare <2 x double> @llvm.fma.v2f64(<2 x double>, <2 x double>, <2 x double>)
declare <4 x double> @llvm.fma.v4f64(<4 x double>, <4 x double>, <4 x double>)

; This test checks combinations of FNEG and FMA intrinsics

define <8 x float> @test1(<8 x float> %a, <8 x float> %b, <8 x float> %c)  {
; CHECK-LABEL: test1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vfmsub213ps {{.*#+}} ymm0 = (ymm1 * ymm0) - ymm2
; CHECK-NEXT:    ret{{[l|q]}}
  %sub.i = fsub <8 x float> <float -0.0, float -0.0, float -0.0, float -0.0, float -0.0, float -0.0, float -0.0, float -0.0>, %c
  %r = tail call nsz <8 x float> @llvm.fma.v8f32(<8 x float> %a, <8 x float> %b, <8 x float> %sub.i) #2
  ret <8 x float> %r
}

define <4 x float> @test2(<4 x float> %a, <4 x float> %b, <4 x float> %c) {
; CHECK-LABEL: test2:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vfnmsub213ps {{.*#+}} xmm0 = -(xmm1 * xmm0) - xmm2
; CHECK-NEXT:    ret{{[l|q]}}
  %t0 = tail call nsz <4 x float> @llvm.fma.v4f32(<4 x float> %a, <4 x float> %b, <4 x float> %c) #2
  %sub.i = fsub <4 x float> <float -0.0, float -0.0, float -0.0, float -0.0>, %t0
  ret <4 x float> %sub.i
}

define <4 x float> @test3(<4 x float> %a, <4 x float> %b, <4 x float> %c)  {
; CHECK-LABEL: test3:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vfnmadd213ss {{.*#+}} xmm0 = -(xmm1 * xmm0) + xmm2
; CHECK-NEXT:    vbroadcastss {{.*#+}} xmm1 = [-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0]
; CHECK-NEXT:    vxorps %xmm1, %xmm0, %xmm0
; CHECK-NEXT:    ret{{[l|q]}}
  %a0 = extractelement <4 x float> %a, i64 0
  %b0 = extractelement <4 x float> %b, i64 0
  %c0 = extractelement <4 x float> %c, i64 0
  %negb0 = fneg float %b0
  %t0 = tail call nsz float @llvm.fma.f32(float %a0, float %negb0, float %c0) #2
  %i = insertelement <4 x float> %a, float %t0, i64 0
  %sub.i = fsub <4 x float> <float -0.0, float -0.0, float -0.0, float -0.0>, %i
  ret <4 x float> %sub.i
}

define <8 x float> @test4(<8 x float> %a, <8 x float> %b, <8 x float> %c) {
; CHECK-LABEL: test4:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vfnmadd213ps {{.*#+}} ymm0 = -(ymm1 * ymm0) + ymm2
; CHECK-NEXT:    ret{{[l|q]}}
  %negc = fneg <8 x float> %c
  %t0 = tail call nsz <8 x float> @llvm.fma.v8f32(<8 x float> %a, <8 x float> %b, <8 x float> %negc) #2
  %sub.i = fsub <8 x float> <float -0.0, float -0.0, float -0.0, float -0.0, float -0.0, float -0.0, float -0.0, float -0.0>, %t0
  ret <8 x float> %sub.i
}

define <8 x float> @test5(<8 x float> %a, <8 x float> %b, <8 x float> %c) {
; CHECK-LABEL: test5:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vfmadd213ps {{.*#+}} ymm0 = (ymm1 * ymm0) + ymm2
; CHECK-NEXT:    ret{{[l|q]}}
  %sub.c = fsub <8 x float> <float -0.0, float -0.0, float -0.0, float -0.0, float -0.0, float -0.0, float -0.0, float -0.0>, %c
  %negsubc = fneg <8 x float> %sub.c
  %t0 = tail call nsz <8 x float> @llvm.fma.v8f32(<8 x float> %a, <8 x float> %b, <8 x float> %negsubc) #2
  ret <8 x float> %t0
}

define <2 x double> @test6(<2 x double> %a, <2 x double> %b, <2 x double> %c) {
; CHECK-LABEL: test6:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vfnmsub213pd {{.*#+}} xmm0 = -(xmm1 * xmm0) - xmm2
; CHECK-NEXT:    ret{{[l|q]}}
  %t0 = tail call nsz <2 x double> @llvm.fma.v2f64(<2 x double> %a, <2 x double> %b, <2 x double> %c) #2
  %sub.i = fsub <2 x double> <double -0.0, double -0.0>, %t0
  ret <2 x double> %sub.i
}

define <8 x float> @test7(float %a, <8 x float> %b, <8 x float> %c)  {
; X86-LABEL: test7:
; X86:       # %bb.0:
; X86-NEXT:    vbroadcastss {{[0-9]+}}(%esp), %ymm2
; X86-NEXT:    vfnmadd213ps {{.*#+}} ymm0 = -(ymm2 * ymm0) + ymm1
; X86-NEXT:    retl
;
; X64-LABEL: test7:
; X64:       # %bb.0:
; X64-NEXT:    vbroadcastss %xmm0, %ymm0
; X64-NEXT:    vfnmadd213ps {{.*#+}} ymm0 = -(ymm1 * ymm0) + ymm2
; X64-NEXT:    retq
  %t0 = insertelement <8 x float> undef, float %a, i32 0
  %t1 = fsub <8 x float> <float -0.0, float undef, float undef, float undef, float undef, float undef, float undef, float undef>, %t0
  %t2 = shufflevector <8 x float> %t1, <8 x float> undef, <8 x i32> zeroinitializer
  %t3 = tail call nsz <8 x float> @llvm.fma.v8f32(<8 x float> %t2, <8 x float> %b, <8 x float> %c)
  ret <8 x float> %t3

}

define <8 x float> @test8(float %a, <8 x float> %b, <8 x float> %c)  {
; X86-LABEL: test8:
; X86:       # %bb.0:
; X86-NEXT:    vbroadcastss {{[0-9]+}}(%esp), %ymm2
; X86-NEXT:    vfnmadd213ps {{.*#+}} ymm0 = -(ymm2 * ymm0) + ymm1
; X86-NEXT:    retl
;
; X64-LABEL: test8:
; X64:       # %bb.0:
; X64-NEXT:    vbroadcastss %xmm0, %ymm0
; X64-NEXT:    vfnmadd213ps {{.*#+}} ymm0 = -(ymm1 * ymm0) + ymm2
; X64-NEXT:    retq
  %t0 = fsub float -0.0, %a
  %t1 = insertelement <8 x float> undef, float %t0, i32 0
  %t2 = shufflevector <8 x float> %t1, <8 x float> undef, <8 x i32> zeroinitializer
  %t3 = tail call nsz <8 x float> @llvm.fma.v8f32(<8 x float> %t2, <8 x float> %b, <8 x float> %c)
  ret <8 x float> %t3
}

define <4 x double> @test9(<4 x double> %a) {
; CHECK-LABEL: test9:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vbroadcastsd {{.*#+}} ymm1 = [-5.0E-1,-5.0E-1,-5.0E-1,-5.0E-1]
; CHECK-NEXT:    vfnmadd213pd {{.*#+}} ymm0 = -(ymm1 * ymm0) + ymm1
; CHECK-NEXT:    ret{{[l|q]}}
  %t = tail call <4 x double> @llvm.fma.v4f64(<4 x double> %a, <4 x double> <double 5.000000e-01, double 5.000000e-01, double 5.000000e-01, double 5.000000e-01>, <4 x double> <double -5.000000e-01, double -5.000000e-01, double -5.000000e-01, double -5.000000e-01>)
  ret <4 x double> %t
}

define <4 x double> @test10(<4 x double> %a, <4 x double> %b) {
; CHECK-LABEL: test10:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vmovapd {{.*#+}} ymm2 = [-9.5E+0,u,-5.5E+0,-2.5E+0]
; CHECK-NEXT:    vmovapd %ymm2, %ymm3
; CHECK-NEXT:    vfmadd213pd {{.*#+}} ymm3 = (ymm0 * ymm3) + ymm1
; CHECK-NEXT:    vfnmadd213pd {{.*#+}} ymm2 = -(ymm0 * ymm2) + ymm1
; CHECK-NEXT:    vaddpd %ymm2, %ymm3, %ymm0
; CHECK-NEXT:    ret{{[l|q]}}
  %t0 = tail call <4 x double> @llvm.fma.v4f64(<4 x double> %a, <4 x double> <double -95.00000e-01, double undef, double -55.00000e-01, double -25.00000e-01>, <4 x double> %b)
  %t1 = tail call <4 x double> @llvm.fma.v4f64(<4 x double> %a, <4 x double> <double 95.00000e-01, double undef, double 55.00000e-01, double 25.00000e-01>, <4 x double> %b)
  %t2 = fadd <4 x double> %t0, %t1
  ret <4 x double> %t2
}

define <4 x double> @test11(<4 x double> %a) {
; CHECK-LABEL: test11:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vbroadcastf128 {{.*#+}} ymm1 = [5.0E-1,2.5E+0,5.0E-1,2.5E+0]
; CHECK-NEXT:    # ymm1 = mem[0,1,0,1]
; CHECK-NEXT:    vaddpd %ymm1, %ymm0, %ymm0
; CHECK-NEXT:    vfmsub213pd {{.*#+}} ymm0 = (ymm1 * ymm0) - ymm1
; CHECK-NEXT:    ret{{[l|q]}}
  %t0 = fadd <4 x double> %a, <double 5.000000e-01, double 25.00000e-01, double 5.000000e-01, double 25.00000e-01>
  %t1 = tail call <4 x double> @llvm.fma.v4f64(<4 x double> %t0, <4 x double> <double 5.000000e-01, double 25.00000e-01, double 5.000000e-01, double 25.00000e-01>, <4 x double> <double -5.000000e-01, double -25.00000e-01, double -5.000000e-01, double -25.00000e-01>)
  ret <4 x double> %t1
}

define <4 x double> @test12(<4 x double> %a, <4 x double> %b) {
; CHECK-LABEL: test12:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vmovapd {{.*#+}} ymm2 = [-7.5E+0,-2.5E+0,-5.5E+0,-9.5E+0]
; CHECK-NEXT:    vfnmadd213pd {{.*#+}} ymm0 = -(ymm2 * ymm0) + mem
; CHECK-NEXT:    vfmadd132pd {{.*#+}} ymm1 = (ymm1 * mem) + ymm2
; CHECK-NEXT:    vaddpd %ymm1, %ymm0, %ymm0
; CHECK-NEXT:    ret{{[l|q]}}
  %t0 = tail call <4 x double> @llvm.fma.v4f64(<4 x double> %a, <4 x double> <double 75.00000e-01, double 25.00000e-01, double 55.00000e-01, double 95.00000e-01>, <4 x double> <double -75.00000e-01, double undef, double -55.00000e-01, double -95.00000e-01>)
  %t1 = tail call <4 x double> @llvm.fma.v4f64(<4 x double> %b, <4 x double> <double undef, double 25.00000e-01, double 55.00000e-01, double 95.00000e-01>, <4 x double> <double -75.00000e-01, double -25.00000e-01, double -55.00000e-01, double -95.00000e-01>)
  %t2 = fadd <4 x double> %t0, %t1
  ret <4 x double> %t2
}
