; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mattr=+sve | FileCheck %s -check-prefixes=CHECK,SVE
; RUN: llc < %s -mattr=+sve,+sme2 | FileCheck %s -check-prefixes=CHECK,SVE
; RUN: llc < %s -mattr=+sme2 -force-streaming | FileCheck %s -check-prefixes=CHECK,SME2,SME-ALL
; RUN: llc < %s -mattr=+sme2 -force-streaming -aarch64-sve-vector-bits-min=256 | FileCheck %s -check-prefixes=CHECK,SME2,SME2-256

target triple = "aarch64-unknown-linux-gnu"

define <vscale x 4 x half> @interleave2_nxv4f16(<vscale x 2 x half> %vec0, <vscale x 2 x half> %vec1) {
; SVE-LABEL: interleave2_nxv4f16:
; SVE:       // %bb.0:
; SVE-NEXT:    zip2 z2.d, z0.d, z1.d
; SVE-NEXT:    zip1 z0.d, z0.d, z1.d
; SVE-NEXT:    uzp1 z0.s, z0.s, z2.s
; SVE-NEXT:    ret
;
; SME2-LABEL: interleave2_nxv4f16:
; SME2:       // %bb.0:
; SME2-NEXT:    zip { z0.d, z1.d }, z0.d, z1.d
; SME2-NEXT:    uzp1 z0.s, z0.s, z1.s
; SME2-NEXT:    ret
  %retval = call <vscale x 4 x half> @llvm.vector.interleave2.nxv4f16(<vscale x 2 x half> %vec0, <vscale x 2 x half> %vec1)
  ret <vscale x 4 x half> %retval
}

define <vscale x 8 x half> @interleave2_nxv8f16(<vscale x 4 x half> %vec0, <vscale x 4 x half> %vec1) {
; SVE-LABEL: interleave2_nxv8f16:
; SVE:       // %bb.0:
; SVE-NEXT:    zip2 z2.s, z0.s, z1.s
; SVE-NEXT:    zip1 z0.s, z0.s, z1.s
; SVE-NEXT:    uzp1 z0.h, z0.h, z2.h
; SVE-NEXT:    ret
;
; SME2-LABEL: interleave2_nxv8f16:
; SME2:       // %bb.0:
; SME2-NEXT:    zip { z0.s, z1.s }, z0.s, z1.s
; SME2-NEXT:    uzp1 z0.h, z0.h, z1.h
; SME2-NEXT:    ret
  %retval = call <vscale x 8 x half> @llvm.vector.interleave2.nxv8f16(<vscale x 4 x half> %vec0, <vscale x 4 x half> %vec1)
  ret <vscale x 8 x half> %retval
}

define <vscale x 16 x half> @interleave2_nxv16f16(<vscale x 8 x half> %vec0, <vscale x 8 x half> %vec1) {
; SVE-LABEL: interleave2_nxv16f16:
; SVE:       // %bb.0:
; SVE-NEXT:    zip1 z2.h, z0.h, z1.h
; SVE-NEXT:    zip2 z1.h, z0.h, z1.h
; SVE-NEXT:    mov z0.d, z2.d
; SVE-NEXT:    ret
;
; SME2-LABEL: interleave2_nxv16f16:
; SME2:       // %bb.0:
; SME2-NEXT:    zip { z0.h, z1.h }, z0.h, z1.h
; SME2-NEXT:    ret
  %retval = call <vscale x 16 x half> @llvm.vector.interleave2.nxv16f16(<vscale x 8 x half> %vec0, <vscale x 8 x half> %vec1)
  ret <vscale x 16 x half> %retval
}

define <vscale x 4 x float> @interleave2_nxv4f32(<vscale x 2 x float> %vec0, <vscale x 2 x float> %vec1) {
; SVE-LABEL: interleave2_nxv4f32:
; SVE:       // %bb.0:
; SVE-NEXT:    zip2 z2.d, z0.d, z1.d
; SVE-NEXT:    zip1 z0.d, z0.d, z1.d
; SVE-NEXT:    uzp1 z0.s, z0.s, z2.s
; SVE-NEXT:    ret
;
; SME2-LABEL: interleave2_nxv4f32:
; SME2:       // %bb.0:
; SME2-NEXT:    zip { z0.d, z1.d }, z0.d, z1.d
; SME2-NEXT:    uzp1 z0.s, z0.s, z1.s
; SME2-NEXT:    ret
  %retval = call <vscale x 4 x float> @llvm.vector.interleave2.nxv4f32(<vscale x 2 x float> %vec0, <vscale x 2 x float> %vec1)
  ret <vscale x 4 x float> %retval
}

define <vscale x 8 x float> @interleave2_nxv8f32(<vscale x 4 x float> %vec0, <vscale x 4 x float> %vec1) {
; SVE-LABEL: interleave2_nxv8f32:
; SVE:       // %bb.0:
; SVE-NEXT:    zip1 z2.s, z0.s, z1.s
; SVE-NEXT:    zip2 z1.s, z0.s, z1.s
; SVE-NEXT:    mov z0.d, z2.d
; SVE-NEXT:    ret
;
; SME2-LABEL: interleave2_nxv8f32:
; SME2:       // %bb.0:
; SME2-NEXT:    zip { z0.s, z1.s }, z0.s, z1.s
; SME2-NEXT:    ret
  %retval = call <vscale x 8 x float> @llvm.vector.interleave2.nxv8f32(<vscale x 4 x float> %vec0, <vscale x 4 x float> %vec1)
  ret <vscale x 8 x float> %retval
}

define <vscale x 4 x double> @interleave2_nxv4f64(<vscale x 2 x double> %vec0, <vscale x 2 x double> %vec1) {
; SVE-LABEL: interleave2_nxv4f64:
; SVE:       // %bb.0:
; SVE-NEXT:    zip1 z2.d, z0.d, z1.d
; SVE-NEXT:    zip2 z1.d, z0.d, z1.d
; SVE-NEXT:    mov z0.d, z2.d
; SVE-NEXT:    ret
;
; SME2-LABEL: interleave2_nxv4f64:
; SME2:       // %bb.0:
; SME2-NEXT:    zip { z0.d, z1.d }, z0.d, z1.d
; SME2-NEXT:    ret
  %retval = call <vscale x 4 x double>@llvm.vector.interleave2.nxv4f64(<vscale x 2 x double> %vec0, <vscale x 2 x double> %vec1)
  ret <vscale x 4 x double> %retval
}

define <vscale x 4 x bfloat> @interleave2_nxv4bf16(<vscale x 2 x bfloat> %vec0, <vscale x 2 x bfloat> %vec1) {
; SVE-LABEL: interleave2_nxv4bf16:
; SVE:       // %bb.0:
; SVE-NEXT:    zip2 z2.d, z0.d, z1.d
; SVE-NEXT:    zip1 z0.d, z0.d, z1.d
; SVE-NEXT:    uzp1 z0.s, z0.s, z2.s
; SVE-NEXT:    ret
;
; SME2-LABEL: interleave2_nxv4bf16:
; SME2:       // %bb.0:
; SME2-NEXT:    zip { z0.d, z1.d }, z0.d, z1.d
; SME2-NEXT:    uzp1 z0.s, z0.s, z1.s
; SME2-NEXT:    ret
  %retval = call <vscale x 4 x bfloat> @llvm.vector.interleave2.nxv4bf16(<vscale x 2 x bfloat> %vec0, <vscale x 2 x bfloat> %vec1)
  ret <vscale x 4 x bfloat> %retval
}

define <vscale x 8 x bfloat> @interleave2_nxv8bf16(<vscale x 4 x bfloat> %vec0, <vscale x 4 x bfloat> %vec1) {
; SVE-LABEL: interleave2_nxv8bf16:
; SVE:       // %bb.0:
; SVE-NEXT:    zip2 z2.s, z0.s, z1.s
; SVE-NEXT:    zip1 z0.s, z0.s, z1.s
; SVE-NEXT:    uzp1 z0.h, z0.h, z2.h
; SVE-NEXT:    ret
;
; SME2-LABEL: interleave2_nxv8bf16:
; SME2:       // %bb.0:
; SME2-NEXT:    zip { z0.s, z1.s }, z0.s, z1.s
; SME2-NEXT:    uzp1 z0.h, z0.h, z1.h
; SME2-NEXT:    ret
  %retval = call <vscale x 8 x bfloat> @llvm.vector.interleave2.nxv8bf16(<vscale x 4 x bfloat> %vec0, <vscale x 4 x bfloat> %vec1)
  ret <vscale x 8 x bfloat> %retval
}

define <vscale x 16 x bfloat> @interleave2_nxv16bf16(<vscale x 8 x bfloat> %vec0, <vscale x 8 x bfloat> %vec1) {
; SVE-LABEL: interleave2_nxv16bf16:
; SVE:       // %bb.0:
; SVE-NEXT:    zip1 z2.h, z0.h, z1.h
; SVE-NEXT:    zip2 z1.h, z0.h, z1.h
; SVE-NEXT:    mov z0.d, z2.d
; SVE-NEXT:    ret
;
; SME2-LABEL: interleave2_nxv16bf16:
; SME2:       // %bb.0:
; SME2-NEXT:    zip { z0.h, z1.h }, z0.h, z1.h
; SME2-NEXT:    ret
  %retval = call <vscale x 16 x bfloat> @llvm.vector.interleave2.nxv16bf16(<vscale x 8 x bfloat> %vec0, <vscale x 8 x bfloat> %vec1)
  ret <vscale x 16 x bfloat> %retval
}

; Integers

define <vscale x 32 x i8> @interleave2_nxv32i8(<vscale x 16 x i8> %vec0, <vscale x 16 x i8> %vec1) {
; SVE-LABEL: interleave2_nxv32i8:
; SVE:       // %bb.0:
; SVE-NEXT:    zip1 z2.b, z0.b, z1.b
; SVE-NEXT:    zip2 z1.b, z0.b, z1.b
; SVE-NEXT:    mov z0.d, z2.d
; SVE-NEXT:    ret
;
; SME2-LABEL: interleave2_nxv32i8:
; SME2:       // %bb.0:
; SME2-NEXT:    zip { z0.b, z1.b }, z0.b, z1.b
; SME2-NEXT:    ret
  %retval = call <vscale x 32 x i8> @llvm.vector.interleave2.nxv32i8(<vscale x 16 x i8> %vec0, <vscale x 16 x i8> %vec1)
  ret <vscale x 32 x i8> %retval
}

define <vscale x 16 x i16> @interleave2_nxv16i16(<vscale x 8 x i16> %vec0, <vscale x 8 x i16> %vec1) {
; SVE-LABEL: interleave2_nxv16i16:
; SVE:       // %bb.0:
; SVE-NEXT:    zip1 z2.h, z0.h, z1.h
; SVE-NEXT:    zip2 z1.h, z0.h, z1.h
; SVE-NEXT:    mov z0.d, z2.d
; SVE-NEXT:    ret
;
; SME2-LABEL: interleave2_nxv16i16:
; SME2:       // %bb.0:
; SME2-NEXT:    zip { z0.h, z1.h }, z0.h, z1.h
; SME2-NEXT:    ret
  %retval = call <vscale x 16 x i16> @llvm.vector.interleave2.nxv16i16(<vscale x 8 x i16> %vec0, <vscale x 8 x i16> %vec1)
  ret <vscale x 16 x i16> %retval
}

define <vscale x 8 x i32> @interleave2_nxv8i32(<vscale x 4 x i32> %vec0, <vscale x 4 x i32> %vec1) {
; SVE-LABEL: interleave2_nxv8i32:
; SVE:       // %bb.0:
; SVE-NEXT:    zip1 z2.s, z0.s, z1.s
; SVE-NEXT:    zip2 z1.s, z0.s, z1.s
; SVE-NEXT:    mov z0.d, z2.d
; SVE-NEXT:    ret
;
; SME2-LABEL: interleave2_nxv8i32:
; SME2:       // %bb.0:
; SME2-NEXT:    zip { z0.s, z1.s }, z0.s, z1.s
; SME2-NEXT:    ret
  %retval = call <vscale x 8 x i32> @llvm.vector.interleave2.nxv8i32(<vscale x 4 x i32> %vec0, <vscale x 4 x i32> %vec1)
  ret <vscale x 8 x i32> %retval
}

define <vscale x 4 x i64> @interleave2_nxv4i64(<vscale x 2 x i64> %vec0, <vscale x 2 x i64> %vec1) {
; SVE-LABEL: interleave2_nxv4i64:
; SVE:       // %bb.0:
; SVE-NEXT:    zip1 z2.d, z0.d, z1.d
; SVE-NEXT:    zip2 z1.d, z0.d, z1.d
; SVE-NEXT:    mov z0.d, z2.d
; SVE-NEXT:    ret
;
; SME2-LABEL: interleave2_nxv4i64:
; SME2:       // %bb.0:
; SME2-NEXT:    zip { z0.d, z1.d }, z0.d, z1.d
; SME2-NEXT:    ret
  %retval = call <vscale x 4 x i64> @llvm.vector.interleave2.nxv4i64(<vscale x 2 x i64> %vec0, <vscale x 2 x i64> %vec1)
  ret <vscale x 4 x i64> %retval
}

define <vscale x 64 x i8> @interleave4_nxv16i8(<vscale x 16 x i8> %vec0, <vscale x 16 x i8> %vec1, <vscale x 16 x i8> %vec2, <vscale x 16 x i8> %vec3) {
; SVE-LABEL: interleave4_nxv16i8:
; SVE:       // %bb.0:
; SVE-NEXT:    zip1 z4.b, z1.b, z3.b
; SVE-NEXT:    zip1 z5.b, z0.b, z2.b
; SVE-NEXT:    zip2 z3.b, z1.b, z3.b
; SVE-NEXT:    zip2 z6.b, z0.b, z2.b
; SVE-NEXT:    zip1 z0.b, z5.b, z4.b
; SVE-NEXT:    zip2 z1.b, z5.b, z4.b
; SVE-NEXT:    zip1 z2.b, z6.b, z3.b
; SVE-NEXT:    zip2 z3.b, z6.b, z3.b
; SVE-NEXT:    ret
;
; SME2-LABEL: interleave4_nxv16i8:
; SME2:       // %bb.0:
; SME2-NEXT:    // kill: def $z3 killed $z3 killed $z0_z1_z2_z3 def $z0_z1_z2_z3
; SME2-NEXT:    // kill: def $z2 killed $z2 killed $z0_z1_z2_z3 def $z0_z1_z2_z3
; SME2-NEXT:    // kill: def $z1 killed $z1 killed $z0_z1_z2_z3 def $z0_z1_z2_z3
; SME2-NEXT:    // kill: def $z0 killed $z0 killed $z0_z1_z2_z3 def $z0_z1_z2_z3
; SME2-NEXT:    zip { z0.b - z3.b }, { z0.b - z3.b }
; SME2-NEXT:    ret
  %retval = call <vscale x 64 x i8> @llvm.vector.interleave4.nxv16i8(<vscale x 16 x i8> %vec0, <vscale x 16 x i8> %vec1, <vscale x 16 x i8> %vec2, <vscale x 16 x i8> %vec3)
  ret <vscale x 64 x i8> %retval
}

define <vscale x 32 x i16> @interleave4_nxv8i16(<vscale x 8 x i16> %vec0, <vscale x 8 x i16> %vec1, <vscale x 8 x i16> %vec2, <vscale x 8 x i16> %vec3) {
; SVE-LABEL: interleave4_nxv8i16:
; SVE:       // %bb.0:
; SVE-NEXT:    zip1 z4.h, z1.h, z3.h
; SVE-NEXT:    zip1 z5.h, z0.h, z2.h
; SVE-NEXT:    zip2 z3.h, z1.h, z3.h
; SVE-NEXT:    zip2 z6.h, z0.h, z2.h
; SVE-NEXT:    zip1 z0.h, z5.h, z4.h
; SVE-NEXT:    zip2 z1.h, z5.h, z4.h
; SVE-NEXT:    zip1 z2.h, z6.h, z3.h
; SVE-NEXT:    zip2 z3.h, z6.h, z3.h
; SVE-NEXT:    ret
;
; SME2-LABEL: interleave4_nxv8i16:
; SME2:       // %bb.0:
; SME2-NEXT:    // kill: def $z3 killed $z3 killed $z0_z1_z2_z3 def $z0_z1_z2_z3
; SME2-NEXT:    // kill: def $z2 killed $z2 killed $z0_z1_z2_z3 def $z0_z1_z2_z3
; SME2-NEXT:    // kill: def $z1 killed $z1 killed $z0_z1_z2_z3 def $z0_z1_z2_z3
; SME2-NEXT:    // kill: def $z0 killed $z0 killed $z0_z1_z2_z3 def $z0_z1_z2_z3
; SME2-NEXT:    zip { z0.h - z3.h }, { z0.h - z3.h }
; SME2-NEXT:    ret
  %retval = call <vscale x 32 x i16> @llvm.vector.interleave4.nxv8i16(<vscale x 8 x i16> %vec0, <vscale x 8 x i16> %vec1, <vscale x 8 x i16> %vec2, <vscale x 8 x i16> %vec3)
  ret <vscale x 32 x i16> %retval
}

define <vscale x 16 x i32> @interleave4_nxv4i32(<vscale x 4 x i32> %vec0, <vscale x 4 x i32> %vec1, <vscale x 4 x i32> %vec2, <vscale x 4 x i32> %vec3) {
; SVE-LABEL: interleave4_nxv4i32:
; SVE:       // %bb.0:
; SVE-NEXT:    zip1 z4.s, z1.s, z3.s
; SVE-NEXT:    zip1 z5.s, z0.s, z2.s
; SVE-NEXT:    zip2 z3.s, z1.s, z3.s
; SVE-NEXT:    zip2 z6.s, z0.s, z2.s
; SVE-NEXT:    zip1 z0.s, z5.s, z4.s
; SVE-NEXT:    zip2 z1.s, z5.s, z4.s
; SVE-NEXT:    zip1 z2.s, z6.s, z3.s
; SVE-NEXT:    zip2 z3.s, z6.s, z3.s
; SVE-NEXT:    ret
;
; SME2-LABEL: interleave4_nxv4i32:
; SME2:       // %bb.0:
; SME2-NEXT:    // kill: def $z3 killed $z3 killed $z0_z1_z2_z3 def $z0_z1_z2_z3
; SME2-NEXT:    // kill: def $z2 killed $z2 killed $z0_z1_z2_z3 def $z0_z1_z2_z3
; SME2-NEXT:    // kill: def $z1 killed $z1 killed $z0_z1_z2_z3 def $z0_z1_z2_z3
; SME2-NEXT:    // kill: def $z0 killed $z0 killed $z0_z1_z2_z3 def $z0_z1_z2_z3
; SME2-NEXT:    zip { z0.s - z3.s }, { z0.s - z3.s }
; SME2-NEXT:    ret
  %retval = call <vscale x 16 x i32> @llvm.vector.interleave4.nxv4i32(<vscale x 4 x i32> %vec0, <vscale x 4 x i32> %vec1, <vscale x 4 x i32> %vec2, <vscale x 4 x i32> %vec3)
  ret <vscale x 16 x i32> %retval
}

define <vscale x 8 x i64> @interleave4_nxv8i64(<vscale x 2 x i64> %vec0, <vscale x 2 x i64> %vec1, <vscale x 2 x i64> %vec2, <vscale x 2 x i64> %vec3) {
; SVE-LABEL: interleave4_nxv8i64:
; SVE:       // %bb.0:
; SVE-NEXT:    zip1 z4.d, z1.d, z3.d
; SVE-NEXT:    zip1 z5.d, z0.d, z2.d
; SVE-NEXT:    zip2 z3.d, z1.d, z3.d
; SVE-NEXT:    zip2 z6.d, z0.d, z2.d
; SVE-NEXT:    zip1 z0.d, z5.d, z4.d
; SVE-NEXT:    zip2 z1.d, z5.d, z4.d
; SVE-NEXT:    zip1 z2.d, z6.d, z3.d
; SVE-NEXT:    zip2 z3.d, z6.d, z3.d
; SVE-NEXT:    ret
;
; SME-ALL-LABEL: interleave4_nxv8i64:
; SME-ALL:       // %bb.0:
; SME-ALL-NEXT:    zip { z4.d, z5.d }, z1.d, z3.d
; SME-ALL-NEXT:    zip { z2.d, z3.d }, z0.d, z2.d
; SME-ALL-NEXT:    zip { z0.d, z1.d }, z2.d, z4.d
; SME-ALL-NEXT:    zip { z2.d, z3.d }, z3.d, z5.d
; SME-ALL-NEXT:    ret
;
; SME2-256-LABEL: interleave4_nxv8i64:
; SME2-256:       // %bb.0:
; SME2-256-NEXT:    // kill: def $z3 killed $z3 killed $z0_z1_z2_z3 def $z0_z1_z2_z3
; SME2-256-NEXT:    // kill: def $z2 killed $z2 killed $z0_z1_z2_z3 def $z0_z1_z2_z3
; SME2-256-NEXT:    // kill: def $z1 killed $z1 killed $z0_z1_z2_z3 def $z0_z1_z2_z3
; SME2-256-NEXT:    // kill: def $z0 killed $z0 killed $z0_z1_z2_z3 def $z0_z1_z2_z3
; SME2-256-NEXT:    zip { z0.d - z3.d }, { z0.d - z3.d }
; SME2-256-NEXT:    ret
  %retval = call <vscale x 8 x i64> @llvm.vector.interleave4.nxv8i64(<vscale x 2 x i64> %vec0, <vscale x 2 x i64> %vec1, <vscale x 2 x i64> %vec2, <vscale x 2 x i64> %vec3)
  ret <vscale x 8 x i64> %retval
}

define <vscale x 16 x i64> @interleave8_nxv16i64(<vscale x 2 x i64> %vec0, <vscale x 2 x i64> %vec1, <vscale x 2 x i64> %vec2, <vscale x 2 x i64> %vec3, <vscale x 2 x i64> %vec4, <vscale x 2 x i64> %vec5, <vscale x 2 x i64> %vec6, <vscale x 2 x i64> %vec7) {
; SVE-LABEL: interleave8_nxv16i64:
; SVE:       // %bb.0:
; SVE-NEXT:    zip1 z24.d, z3.d, z7.d
; SVE-NEXT:    zip1 z25.d, z1.d, z5.d
; SVE-NEXT:    zip1 z26.d, z2.d, z6.d
; SVE-NEXT:    zip1 z27.d, z0.d, z4.d
; SVE-NEXT:    zip2 z3.d, z3.d, z7.d
; SVE-NEXT:    zip2 z1.d, z1.d, z5.d
; SVE-NEXT:    zip2 z2.d, z2.d, z6.d
; SVE-NEXT:    zip2 z0.d, z0.d, z4.d
; SVE-NEXT:    zip1 z4.d, z25.d, z24.d
; SVE-NEXT:    zip2 z6.d, z25.d, z24.d
; SVE-NEXT:    zip1 z5.d, z27.d, z26.d
; SVE-NEXT:    zip2 z7.d, z27.d, z26.d
; SVE-NEXT:    zip1 z24.d, z1.d, z3.d
; SVE-NEXT:    zip1 z25.d, z0.d, z2.d
; SVE-NEXT:    zip2 z26.d, z1.d, z3.d
; SVE-NEXT:    zip2 z27.d, z0.d, z2.d
; SVE-NEXT:    zip1 z0.d, z5.d, z4.d
; SVE-NEXT:    zip2 z1.d, z5.d, z4.d
; SVE-NEXT:    zip1 z2.d, z7.d, z6.d
; SVE-NEXT:    zip2 z3.d, z7.d, z6.d
; SVE-NEXT:    zip1 z4.d, z25.d, z24.d
; SVE-NEXT:    zip2 z5.d, z25.d, z24.d
; SVE-NEXT:    zip1 z6.d, z27.d, z26.d
; SVE-NEXT:    zip2 z7.d, z27.d, z26.d
; SVE-NEXT:    ret
;
; SME-ALL-LABEL: interleave8_nxv16i64:
; SME-ALL:       // %bb.0:
; SME-ALL-NEXT:    zip { z24.d, z25.d }, z3.d, z7.d
; SME-ALL-NEXT:    zip { z26.d, z27.d }, z1.d, z5.d
; SME-ALL-NEXT:    zip { z28.d, z29.d }, z26.d, z24.d
; SME-ALL-NEXT:    zip { z6.d, z7.d }, z2.d, z6.d
; SME-ALL-NEXT:    zip { z4.d, z5.d }, z0.d, z4.d
; SME-ALL-NEXT:    zip { z2.d, z3.d }, z4.d, z6.d
; SME-ALL-NEXT:    zip { z0.d, z1.d }, z2.d, z28.d
; SME-ALL-NEXT:    zip { z2.d, z3.d }, z3.d, z29.d
; SME-ALL-NEXT:    zip { z24.d, z25.d }, z27.d, z25.d
; SME-ALL-NEXT:    zip { z6.d, z7.d }, z5.d, z7.d
; SME-ALL-NEXT:    zip { z4.d, z5.d }, z6.d, z24.d
; SME-ALL-NEXT:    zip { z6.d, z7.d }, z7.d, z25.d
; SME-ALL-NEXT:    ret
;
; SME2-256-LABEL: interleave8_nxv16i64:
; SME2-256:       // %bb.0:
; SME2-256-NEXT:    zip { z26.d, z27.d }, z3.d, z7.d
; SME2-256-NEXT:    zip { z6.d, z7.d }, z2.d, z6.d
; SME2-256-NEXT:    zip { z24.d, z25.d }, z1.d, z5.d
; SME2-256-NEXT:    zip { z0.d, z1.d }, z0.d, z4.d
; SME2-256-NEXT:    mov z28.d, z0.d
; SME2-256-NEXT:    mov z29.d, z24.d
; SME2-256-NEXT:    mov z30.d, z6.d
; SME2-256-NEXT:    mov z31.d, z26.d
; SME2-256-NEXT:    mov z24.d, z1.d
; SME2-256-NEXT:    mov z26.d, z7.d
; SME2-256-NEXT:    zip { z0.d - z3.d }, { z28.d - z31.d }
; SME2-256-NEXT:    zip { z4.d - z7.d }, { z24.d - z27.d }
; SME2-256-NEXT:    ret
  %retval = call <vscale x 16 x i64> @llvm.vector.interleave8.nxv16i64(<vscale x 2 x i64> %vec0, <vscale x 2 x i64> %vec1, <vscale x 2 x i64> %vec2, <vscale x 2 x i64> %vec3, <vscale x 2 x i64> %vec4, <vscale x 2 x i64> %vec5, <vscale x 2 x i64> %vec6, <vscale x 2 x i64> %vec7)
  ret <vscale x 16 x i64> %retval
}

; Predicated

define <vscale x 32 x i1> @interleave2_nxv32i1(<vscale x 16 x i1> %vec0, <vscale x 16 x i1> %vec1) {
; CHECK-LABEL: interleave2_nxv32i1:
; CHECK:       // %bb.0:
; CHECK-NEXT:    zip1 p2.b, p0.b, p1.b
; CHECK-NEXT:    zip2 p1.b, p0.b, p1.b
; CHECK-NEXT:    mov p0.b, p2.b
; CHECK-NEXT:    ret
  %retval = call <vscale x 32 x i1> @llvm.vector.interleave2.nxv32i1(<vscale x 16 x i1> %vec0, <vscale x 16 x i1> %vec1)
  ret <vscale x 32 x i1> %retval
}

define <vscale x 16 x i1> @interleave2_nxv16i1(<vscale x 8 x i1> %vec0, <vscale x 8 x i1> %vec1) {
; CHECK-LABEL: interleave2_nxv16i1:
; CHECK:       // %bb.0:
; CHECK-NEXT:    zip2 p2.h, p0.h, p1.h
; CHECK-NEXT:    zip1 p0.h, p0.h, p1.h
; CHECK-NEXT:    uzp1 p0.b, p0.b, p2.b
; CHECK-NEXT:    ret
  %retval = call <vscale x 16 x i1> @llvm.vector.interleave2.nxv16i1(<vscale x 8 x i1> %vec0, <vscale x 8 x i1> %vec1)
  ret <vscale x 16 x i1> %retval
}

define <vscale x 8 x i1> @interleave2_nxv8i1(<vscale x 4 x i1> %vec0, <vscale x 4 x i1> %vec1) {
; CHECK-LABEL: interleave2_nxv8i1:
; CHECK:       // %bb.0:
; CHECK-NEXT:    zip2 p2.s, p0.s, p1.s
; CHECK-NEXT:    zip1 p0.s, p0.s, p1.s
; CHECK-NEXT:    uzp1 p0.h, p0.h, p2.h
; CHECK-NEXT:    ret
  %retval = call <vscale x 8 x i1> @llvm.vector.interleave2.nxv8i1(<vscale x 4 x i1> %vec0, <vscale x 4 x i1> %vec1)
  ret <vscale x 8 x i1> %retval
}

define <vscale x 4 x i1> @interleave2_nxv4i1(<vscale x 2 x i1> %vec0, <vscale x 2 x i1> %vec1) {
; CHECK-LABEL: interleave2_nxv4i1:
; CHECK:       // %bb.0:
; CHECK-NEXT:    zip2 p2.d, p0.d, p1.d
; CHECK-NEXT:    zip1 p0.d, p0.d, p1.d
; CHECK-NEXT:    uzp1 p0.s, p0.s, p2.s
; CHECK-NEXT:    ret
  %retval = call <vscale x 4 x i1> @llvm.vector.interleave2.nxv4i1(<vscale x 2 x i1> %vec0, <vscale x 2 x i1> %vec1)
  ret <vscale x 4 x i1> %retval
}

; Split illegal type size

define <vscale x 16 x i32> @interleave2_nxv16i32(<vscale x 8 x i32> %vec0, <vscale x 8 x i32> %vec1) {
; SVE-LABEL: interleave2_nxv16i32:
; SVE:       // %bb.0:
; SVE-NEXT:    zip1 z4.s, z1.s, z3.s
; SVE-NEXT:    zip1 z5.s, z0.s, z2.s
; SVE-NEXT:    zip2 z2.s, z0.s, z2.s
; SVE-NEXT:    zip2 z3.s, z1.s, z3.s
; SVE-NEXT:    mov z0.d, z5.d
; SVE-NEXT:    mov z1.d, z2.d
; SVE-NEXT:    mov z2.d, z4.d
; SVE-NEXT:    ret
;
; SME2-LABEL: interleave2_nxv16i32:
; SME2:       // %bb.0:
; SME2-NEXT:    zip { z4.s, z5.s }, z0.s, z2.s
; SME2-NEXT:    zip { z2.s, z3.s }, z1.s, z3.s
; SME2-NEXT:    mov z0.d, z4.d
; SME2-NEXT:    mov z1.d, z5.d
; SME2-NEXT:    ret
  %retval = call <vscale x 16 x i32>@llvm.vector.interleave2.nxv16i32(<vscale x 8 x i32> %vec0, <vscale x 8 x i32> %vec1)
  ret <vscale x 16 x i32> %retval
}

define <vscale x 8 x i64> @interleave2_nxv8i64(<vscale x 4 x i64> %vec0, <vscale x 4 x i64> %vec1) {
; SVE-LABEL: interleave2_nxv8i64:
; SVE:       // %bb.0:
; SVE-NEXT:    zip1 z4.d, z1.d, z3.d
; SVE-NEXT:    zip1 z5.d, z0.d, z2.d
; SVE-NEXT:    zip2 z2.d, z0.d, z2.d
; SVE-NEXT:    zip2 z3.d, z1.d, z3.d
; SVE-NEXT:    mov z0.d, z5.d
; SVE-NEXT:    mov z1.d, z2.d
; SVE-NEXT:    mov z2.d, z4.d
; SVE-NEXT:    ret
;
; SME2-LABEL: interleave2_nxv8i64:
; SME2:       // %bb.0:
; SME2-NEXT:    zip { z4.d, z5.d }, z0.d, z2.d
; SME2-NEXT:    zip { z2.d, z3.d }, z1.d, z3.d
; SME2-NEXT:    mov z0.d, z4.d
; SME2-NEXT:    mov z1.d, z5.d
; SME2-NEXT:    ret
  %retval = call <vscale x 8 x i64> @llvm.vector.interleave2.nxv8i64(<vscale x 4 x i64> %vec0, <vscale x 4 x i64> %vec1)
  ret <vscale x 8 x i64> %retval
}

; Promote illegal type size

define <vscale x 16 x i8> @interleave2_nxv8i8(<vscale x 8 x i8> %vec0, <vscale x 8 x i8> %vec1) {
; SVE-LABEL: interleave2_nxv8i8:
; SVE:       // %bb.0:
; SVE-NEXT:    zip2 z2.h, z0.h, z1.h
; SVE-NEXT:    zip1 z0.h, z0.h, z1.h
; SVE-NEXT:    uzp1 z0.b, z0.b, z2.b
; SVE-NEXT:    ret
;
; SME2-LABEL: interleave2_nxv8i8:
; SME2:       // %bb.0:
; SME2-NEXT:    zip { z0.h, z1.h }, z0.h, z1.h
; SME2-NEXT:    uzp1 z0.b, z0.b, z1.b
; SME2-NEXT:    ret
  %retval = call <vscale x 16 x i8> @llvm.vector.interleave2.nxv16i8(<vscale x 8 x i8> %vec0, <vscale x 8 x i8> %vec1)
  ret <vscale x 16 x i8> %retval
}

define <vscale x 8 x i16> @interleave2_nxv4i16(<vscale x 4 x i16> %vec0, <vscale x 4 x i16> %vec1) {
; SVE-LABEL: interleave2_nxv4i16:
; SVE:       // %bb.0:
; SVE-NEXT:    zip2 z2.s, z0.s, z1.s
; SVE-NEXT:    zip1 z0.s, z0.s, z1.s
; SVE-NEXT:    uzp1 z0.h, z0.h, z2.h
; SVE-NEXT:    ret
;
; SME2-LABEL: interleave2_nxv4i16:
; SME2:       // %bb.0:
; SME2-NEXT:    zip { z0.s, z1.s }, z0.s, z1.s
; SME2-NEXT:    uzp1 z0.h, z0.h, z1.h
; SME2-NEXT:    ret
  %retval = call <vscale x 8 x i16> @llvm.vector.interleave2.nxv8i16(<vscale x 4 x i16> %vec0, <vscale x 4 x i16> %vec1)
  ret <vscale x 8 x i16> %retval
}

define <vscale x 4 x i32> @interleave2_nxv2i32(<vscale x 2 x i32> %vec0, <vscale x 2 x i32> %vec1) {
; SVE-LABEL: interleave2_nxv2i32:
; SVE:       // %bb.0:
; SVE-NEXT:    zip2 z2.d, z0.d, z1.d
; SVE-NEXT:    zip1 z0.d, z0.d, z1.d
; SVE-NEXT:    uzp1 z0.s, z0.s, z2.s
; SVE-NEXT:    ret
;
; SME2-LABEL: interleave2_nxv2i32:
; SME2:       // %bb.0:
; SME2-NEXT:    zip { z0.d, z1.d }, z0.d, z1.d
; SME2-NEXT:    uzp1 z0.s, z0.s, z1.s
; SME2-NEXT:    ret
  %retval = call <vscale x 4 x i32> @llvm.vector.interleave2.nxv4i32(<vscale x 2 x i32> %vec0, <vscale x 2 x i32> %vec1)
  ret <vscale x 4 x i32> %retval
}

; Float declarations
declare <vscale x 4 x half> @llvm.vector.interleave2.nxv4f16(<vscale x 2 x half>, <vscale x 2 x half>)
declare <vscale x 8 x half> @llvm.vector.interleave2.nxv8f16(<vscale x 4 x half>, <vscale x 4 x half>)
declare <vscale x 16 x half> @llvm.vector.interleave2.nxv16f16(<vscale x 8 x half>, <vscale x 8 x half>)
declare <vscale x 4 x float> @llvm.vector.interleave2.nxv4f32(<vscale x 2 x float>, <vscale x 2 x float>)
declare <vscale x 8 x float> @llvm.vector.interleave2.nxv8f32(<vscale x 4 x float>, <vscale x 4 x float>)
declare <vscale x 4 x double> @llvm.vector.interleave2.nxv4f64(<vscale x 2 x double>, <vscale x 2 x double>)

; Integer declarations
declare <vscale x 32 x i8> @llvm.vector.interleave2.nxv32i8(<vscale x 16 x i8>, <vscale x 16 x i8>)
declare <vscale x 16 x i16> @llvm.vector.interleave2.nxv16i16(<vscale x 8 x i16>, <vscale x 8 x i16>)
declare <vscale x 8 x i32> @llvm.vector.interleave2.nxv8i32(<vscale x 4 x i32>, <vscale x 4 x i32>)
declare <vscale x 4 x i64> @llvm.vector.interleave2.nxv4i64(<vscale x 2 x i64>, <vscale x 2 x i64>)

; Predicated
declare <vscale x 32 x i1> @llvm.vector.interleave2.nxv32i1(<vscale x 16 x i1>, <vscale x 16 x i1>)
declare <vscale x 16 x i1> @llvm.vector.interleave2.nxv16i1(<vscale x 8 x i1>, <vscale x 8 x i1>)
declare <vscale x 8 x i1> @llvm.vector.interleave2.nxv8i1(<vscale x 4 x i1>, <vscale x 4 x i1>)
declare <vscale x 4 x i1> @llvm.vector.interleave2.nxv4i1(<vscale x 2 x i1>, <vscale x 2 x i1>)

; Illegal type size
declare <vscale x 16 x i32> @llvm.vector.interleave2.nxv16i32(<vscale x 8 x i32>, <vscale x 8 x i32>)
declare <vscale x 8 x i64> @llvm.vector.interleave2.nxv8i64(<vscale x 4 x i64>, <vscale x 4 x i64>)

declare <vscale x 16 x i8> @llvm.vector.interleave2.nxv16i8(<vscale x 8 x i8>, <vscale x 8 x i8>)
declare <vscale x 8 x i16> @llvm.vector.interleave2.nxv8i16(<vscale x 4 x i16>, <vscale x 4 x i16>)
declare <vscale x 4 x i32> @llvm.vector.interleave2.nxv4i32(<vscale x 2 x i32>, <vscale x 2 x i32>)
