
# NOTE: Assertions have been autogenerated by utils/update_mca_test_checks.py
# RUN: llvm-mca -mtriple=riscv64 -mcpu=sifive-p470 -iterations=1 < %s | FileCheck %s

# These instructions only work with e64

vsetvli zero, zero, e64, m1, tu, mu
vclmul.vv v4, v8, v12
vclmul.vx v4, v8, a0
vclmulh.vv v4, v8, v12
vclmulh.vx v4, v8, a0

vsetvli zero, zero, e64, m2, tu, mu
vclmul.vv v4, v8, v12
vclmul.vx v4, v8, a0
vclmulh.vv v4, v8, v12
vclmulh.vx v4, v8, a0

vsetvli zero, zero, e64, m4, tu, mu
vclmul.vv v4, v8, v12
vclmul.vx v4, v8, a0
vclmulh.vv v4, v8, v12
vclmulh.vx v4, v8, a0

vsetvli zero, zero, e64, m8, tu, mu
vclmul.vv  v8, v12, v24
vclmul.vx  v8, v12, a0
vclmulh.vv v8, v12, v24
vclmulh.vx v8, v12, a0

# CHECK:      Iterations:        1
# CHECK-NEXT: Instructions:      20
# CHECK-NEXT: Total Cycles:      58
# CHECK-NEXT: Total uOps:        20

# CHECK:      Dispatch Width:    3
# CHECK-NEXT: uOps Per Cycle:    0.34
# CHECK-NEXT: IPC:               0.34
# CHECK-NEXT: Block RThroughput: 60.0

# CHECK:      Instruction Info:
# CHECK-NEXT: [1]: #uOps
# CHECK-NEXT: [2]: Latency
# CHECK-NEXT: [3]: RThroughput
# CHECK-NEXT: [4]: MayLoad
# CHECK-NEXT: [5]: MayStore
# CHECK-NEXT: [6]: HasSideEffects (U)

# CHECK:      [1]    [2]    [3]    [4]    [5]    [6]    Instructions:
# CHECK-NEXT:  1      1     1.00                  U     vsetvli zero, zero, e64, m1, tu, mu
# CHECK-NEXT:  1      2     1.00                        vclmul.vv v4, v8, v12
# CHECK-NEXT:  1      2     1.00                        vclmul.vx v4, v8, a0
# CHECK-NEXT:  1      2     1.00                        vclmulh.vv  v4, v8, v12
# CHECK-NEXT:  1      2     1.00                        vclmulh.vx  v4, v8, a0
# CHECK-NEXT:  1      1     1.00                  U     vsetvli zero, zero, e64, m2, tu, mu
# CHECK-NEXT:  1      2     2.00                        vclmul.vv v4, v8, v12
# CHECK-NEXT:  1      2     2.00                        vclmul.vx v4, v8, a0
# CHECK-NEXT:  1      2     2.00                        vclmulh.vv  v4, v8, v12
# CHECK-NEXT:  1      2     2.00                        vclmulh.vx  v4, v8, a0
# CHECK-NEXT:  1      1     1.00                  U     vsetvli zero, zero, e64, m4, tu, mu
# CHECK-NEXT:  1      2     4.00                        vclmul.vv v4, v8, v12
# CHECK-NEXT:  1      2     4.00                        vclmul.vx v4, v8, a0
# CHECK-NEXT:  1      2     4.00                        vclmulh.vv  v4, v8, v12
# CHECK-NEXT:  1      2     4.00                        vclmulh.vx  v4, v8, a0
# CHECK-NEXT:  1      1     1.00                  U     vsetvli zero, zero, e64, m8, tu, mu
# CHECK-NEXT:  1      2     8.00                        vclmul.vv v8, v12, v24
# CHECK-NEXT:  1      2     8.00                        vclmul.vx v8, v12, a0
# CHECK-NEXT:  1      2     8.00                        vclmulh.vv  v8, v12, v24
# CHECK-NEXT:  1      2     8.00                        vclmulh.vx  v8, v12, a0

# CHECK:      Resources:
# CHECK-NEXT: [0]   - SiFiveP400Div
# CHECK-NEXT: [1]   - SiFiveP400FEXQ0
# CHECK-NEXT: [2]   - SiFiveP400FloatDiv
# CHECK-NEXT: [3]   - SiFiveP400IEXQ0
# CHECK-NEXT: [4]   - SiFiveP400IEXQ1
# CHECK-NEXT: [5]   - SiFiveP400IEXQ2
# CHECK-NEXT: [6]   - SiFiveP400Load
# CHECK-NEXT: [7]   - SiFiveP400Store
# CHECK-NEXT: [8]   - SiFiveP400VDiv
# CHECK-NEXT: [9]   - SiFiveP400VEXQ0
# CHECK-NEXT: [10]  - SiFiveP400VFloatDiv
# CHECK-NEXT: [11]  - SiFiveP400VLD
# CHECK-NEXT: [12]  - SiFiveP400VST

# CHECK:      Resource pressure per iteration:
# CHECK-NEXT: [0]    [1]    [2]    [3]    [4]    [5]    [6]    [7]    [8]    [9]    [10]   [11]   [12]
# CHECK-NEXT:  -      -      -      -     4.00    -      -      -      -     60.00   -      -      -

# CHECK:      Resource pressure by instruction:
# CHECK-NEXT: [0]    [1]    [2]    [3]    [4]    [5]    [6]    [7]    [8]    [9]    [10]   [11]   [12]   Instructions:
# CHECK-NEXT:  -      -      -      -     1.00    -      -      -      -      -      -      -      -     vsetvli  zero, zero, e64, m1, tu, mu
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     1.00    -      -      -     vclmul.vv  v4, v8, v12
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     1.00    -      -      -     vclmul.vx  v4, v8, a0
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     1.00    -      -      -     vclmulh.vv v4, v8, v12
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     1.00    -      -      -     vclmulh.vx v4, v8, a0
# CHECK-NEXT:  -      -      -      -     1.00    -      -      -      -      -      -      -      -     vsetvli  zero, zero, e64, m2, tu, mu
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     2.00    -      -      -     vclmul.vv  v4, v8, v12
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     2.00    -      -      -     vclmul.vx  v4, v8, a0
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     2.00    -      -      -     vclmulh.vv v4, v8, v12
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     2.00    -      -      -     vclmulh.vx v4, v8, a0
# CHECK-NEXT:  -      -      -      -     1.00    -      -      -      -      -      -      -      -     vsetvli  zero, zero, e64, m4, tu, mu
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     4.00    -      -      -     vclmul.vv  v4, v8, v12
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     4.00    -      -      -     vclmul.vx  v4, v8, a0
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     4.00    -      -      -     vclmulh.vv v4, v8, v12
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     4.00    -      -      -     vclmulh.vx v4, v8, a0
# CHECK-NEXT:  -      -      -      -     1.00    -      -      -      -      -      -      -      -     vsetvli  zero, zero, e64, m8, tu, mu
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     8.00    -      -      -     vclmul.vv  v8, v12, v24
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     8.00    -      -      -     vclmul.vx  v8, v12, a0
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     8.00    -      -      -     vclmulh.vv v8, v12, v24
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     8.00    -      -      -     vclmulh.vx v8, v12, a0

