; NOTE: Assertions have been autogenerated by utils/update_test_checks.py UTC_ARGS: --version 5
; RUN: opt < %s -passes=instcombine -S | FileCheck %s

define double @fdim_double() {
; CHECK-LABEL: define double @fdim_double() {
; CHECK-NEXT:    ret double 2.500000e+00
;
  %dim = call double @fdim(double 10.5, double 8.0)
  ret double %dim
}

define double @fdim_double1() {
; CHECK-LABEL: define double @fdim_double1() {
; CHECK-NEXT:    ret double 0.000000e+00
;
  %dim = call double @fdim(double 7.0, double 8.0)
  ret double %dim
}

define float @fdim_float() {
; CHECK-LABEL: define float @fdim_float() {
; CHECK-NEXT:    ret float 0.000000e+00
;
  %dim = call float @fdimf(float 1.500000e+00, float 8.0)
  ret float %dim
}

define float @fdim_float1() {
; CHECK-LABEL: define float @fdim_float1() {
; CHECK-NEXT:    ret float 2.000000e+00
;
  %dim = call float @fdimf(float 1.000000e+01, float 8.0)
  ret float %dim
}

define double @fdim_poison1() {
; CHECK-LABEL: define double @fdim_poison1() {
; CHECK-NEXT:    ret double poison
;
  %dim = call double @fdim(double poison, double 1.0)
  ret double %dim
}

define double @fdim_poison2() {
; CHECK-LABEL: define double @fdim_poison2() {
; CHECK-NEXT:    ret double poison
;
  %dim = call double @fdim(double 1.0, double poison)
  ret double %dim
}

define double @fdim_poison3() {
; CHECK-LABEL: define double @fdim_poison3() {
; CHECK-NEXT:    ret double poison
;
  %dim = call double @fdim(double poison, double poison)
  ret double %dim
}

; undef folding is not implemented yet
define double @fdim_undef1() {
; CHECK-LABEL: define double @fdim_undef1() {
; CHECK-NEXT:    [[DIM:%.*]] = call double @fdim(double undef, double 1.000000e+00)
; CHECK-NEXT:    ret double [[DIM]]
;
  %dim = call double @fdim(double undef, double 1.0)
  ret double %dim
}

define double @fdim_inf_ninf() {
; CHECK-LABEL: define double @fdim_inf_ninf() {
; CHECK-NEXT:    ret double 0x7FF0000000000000
;
  %dim = call double @fdim(double 0x7FF0000000000000, double 0x8000000000000000 )
  ret double %dim
}

define double @fdim_inf() {
; CHECK-LABEL: define double @fdim_inf() {
; CHECK-NEXT:    ret double 0x7FF8000000000000
;
  %dim = call double @fdim(double 0x7FF0000000000000, double 0x7FF0000000000000)
  ret double %dim
}

define double @fdim_nzero() {
; CHECK-LABEL: define double @fdim_nzero() {
; CHECK-NEXT:    ret double 0.000000e+00
;
  %dim = call double @fdim(double -0.0, double +0.0)
  ret double %dim
}

define double @fdim_strictfp() {
; CHECK-LABEL: define double @fdim_strictfp() {
; CHECK-NEXT:    [[DIM:%.*]] = call double @fdim(double 1.000000e+01, double 8.000000e+00) #[[ATTR1:[0-9]+]]
; CHECK-NEXT:    ret double [[DIM]]
;
  %dim = call double @fdim(double 10.0, double 8.0) strictfp
  ret double %dim
}

define double @fdim_nan1() {
; CHECK-LABEL: define double @fdim_nan1() {
; CHECK-NEXT:    ret double 0x7FF8000000000000
;
  %dim = call double @fdim(double 10.0, double 0x7FF8000000000000)
  ret double %dim
}


define double @fdim_nan2() {
; CHECK-LABEL: define double @fdim_nan2() {
; CHECK-NEXT:    ret double 0x7FF8000000000000
;
  %dim = call double @fdim(double 0x7FF8000000000000, double 1.4)
  ret double %dim
}

define double @fdim_snan1() {
; CHECK-LABEL: define double @fdim_snan1() {
; CHECK-NEXT:    ret double 0x7FFC000000000000
;
  %dim = call double @fdim(double 0x7FF4000000000000, double 1.4)
  ret double %dim
}

define double @fdim_snan2() {
; CHECK-LABEL: define double @fdim_snan2() {
; CHECK-NEXT:    ret double 0x7FFC000000000000
;
  %dim = call double @fdim(double 1.7, double 0x7FF4000000000000)
  ret double %dim
}

declare double @fdim(double, double) #0
declare float @fdimf(float, float) #0

attributes #0 = { memory(none) }
