; NOTE: Assertions have been autogenerated by utils/update_analyze_test_checks.py UTC_ARGS: --version 2
; RUN: opt -passes="print<cost-model>" 2>&1 -disable-output -cost-kind=all -mtriple=aarch64 < %s | FileCheck %s

target datalayout = "e-m:e-i8:8:32-i16:16:32-i64:64-i128:128-n32:64-S128"
target triple = "aarch64-linux-gnu"

define i8 @test1(ptr %p) {
; CHECK-LABEL: 'test1'
; CHECK-NEXT:  Cost Model: Found costs of 0 for: %a = getelementptr inbounds i8, ptr %p, i32 1
; CHECK-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:1 for: %v = load i8, ptr %a, align 1
; CHECK-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i8 %v
;
  %a = getelementptr inbounds i8, ptr %p, i32 1
  %v = load i8, ptr %a
  ret i8 %v
}

define i16 @test2(ptr %p) {
; CHECK-LABEL: 'test2'
; CHECK-NEXT:  Cost Model: Found costs of 0 for: %a = getelementptr inbounds i16, ptr %p, i32 1
; CHECK-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:1 for: %v = load i16, ptr %a, align 2
; CHECK-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i16 %v
;
  %a = getelementptr inbounds i16, ptr %p, i32 1
  %v = load i16, ptr %a
  ret i16 %v
}

define i32 @test3(ptr %p) {
; CHECK-LABEL: 'test3'
; CHECK-NEXT:  Cost Model: Found costs of 0 for: %a = getelementptr inbounds i32, ptr %p, i32 1
; CHECK-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:1 for: %v = load i32, ptr %a, align 4
; CHECK-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 %v
;
  %a = getelementptr inbounds i32, ptr %p, i32 1
  %v = load i32, ptr %a
  ret i32 %v
}

define i64 @test4(ptr %p) {
; CHECK-LABEL: 'test4'
; CHECK-NEXT:  Cost Model: Found costs of 0 for: %a = getelementptr inbounds i64, ptr %p, i32 1
; CHECK-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:1 for: %v = load i64, ptr %a, align 8
; CHECK-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i64 %v
;
  %a = getelementptr inbounds i64, ptr %p, i32 1
  %v = load i64, ptr %a
  ret i64 %v
}

define i8 @test5(ptr %p) {
; CHECK-LABEL: 'test5'
; CHECK-NEXT:  Cost Model: Found costs of 0 for: %a = getelementptr inbounds i8, ptr %p, i32 1024
; CHECK-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:1 for: %v = load i8, ptr %a, align 1
; CHECK-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i8 %v
;
  %a = getelementptr inbounds i8, ptr %p, i32 1024
  %v = load i8, ptr %a
  ret i8 %v
}

define i16 @test6(ptr %p) {
; CHECK-LABEL: 'test6'
; CHECK-NEXT:  Cost Model: Found costs of 0 for: %a = getelementptr inbounds i16, ptr %p, i32 1024
; CHECK-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:1 for: %v = load i16, ptr %a, align 2
; CHECK-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i16 %v
;
  %a = getelementptr inbounds i16, ptr %p, i32 1024
  %v = load i16, ptr %a
  ret i16 %v
}

define i32 @test7(ptr %p) {
; CHECK-LABEL: 'test7'
; CHECK-NEXT:  Cost Model: Found costs of 0 for: %a = getelementptr inbounds i32, ptr %p, i32 1024
; CHECK-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:1 for: %v = load i32, ptr %a, align 4
; CHECK-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 %v
;
  %a = getelementptr inbounds i32, ptr %p, i32 1024
  %v = load i32, ptr %a
  ret i32 %v
}

define i64 @test8(ptr %p) {
; CHECK-LABEL: 'test8'
; CHECK-NEXT:  Cost Model: Found costs of 0 for: %a = getelementptr inbounds i64, ptr %p, i32 1024
; CHECK-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:1 for: %v = load i64, ptr %a, align 8
; CHECK-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i64 %v
;
  %a = getelementptr inbounds i64, ptr %p, i32 1024
  %v = load i64, ptr %a
  ret i64 %v
}

define i8 @test9(ptr %p) {
; CHECK-LABEL: 'test9'
; CHECK-NEXT:  Cost Model: Found costs of 1 for: %a = getelementptr inbounds i8, ptr %p, i32 4096
; CHECK-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:1 for: %v = load i8, ptr %a, align 1
; CHECK-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i8 %v
;
  %a = getelementptr inbounds i8, ptr %p, i32 4096
  %v = load i8, ptr %a
  ret i8 %v
}

define i16 @test10(ptr %p) {
; CHECK-LABEL: 'test10'
; CHECK-NEXT:  Cost Model: Found costs of 1 for: %a = getelementptr inbounds i16, ptr %p, i32 4096
; CHECK-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:1 for: %v = load i16, ptr %a, align 2
; CHECK-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i16 %v
;
  %a = getelementptr inbounds i16, ptr %p, i32 4096
  %v = load i16, ptr %a
  ret i16 %v
}

define i32 @test11(ptr %p) {
; CHECK-LABEL: 'test11'
; CHECK-NEXT:  Cost Model: Found costs of 1 for: %a = getelementptr inbounds i32, ptr %p, i32 4096
; CHECK-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:1 for: %v = load i32, ptr %a, align 4
; CHECK-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 %v
;
  %a = getelementptr inbounds i32, ptr %p, i32 4096
  %v = load i32, ptr %a
  ret i32 %v
}

define i64 @test12(ptr %p) {
; CHECK-LABEL: 'test12'
; CHECK-NEXT:  Cost Model: Found costs of 1 for: %a = getelementptr inbounds i64, ptr %p, i32 4096
; CHECK-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:1 for: %v = load i64, ptr %a, align 8
; CHECK-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i64 %v
;
  %a = getelementptr inbounds i64, ptr %p, i32 4096
  %v = load i64, ptr %a
  ret i64 %v
}

define i8 @test13(ptr %p) {
; CHECK-LABEL: 'test13'
; CHECK-NEXT:  Cost Model: Found costs of 0 for: %a = getelementptr inbounds i8, ptr %p, i32 -64
; CHECK-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:1 for: %v = load i8, ptr %a, align 1
; CHECK-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i8 %v
;
  %a = getelementptr inbounds i8, ptr %p, i32 -64
  %v = load i8, ptr %a
  ret i8 %v
}

define i16 @test14(ptr %p) {
; CHECK-LABEL: 'test14'
; CHECK-NEXT:  Cost Model: Found costs of 0 for: %a = getelementptr inbounds i16, ptr %p, i32 -64
; CHECK-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:1 for: %v = load i16, ptr %a, align 2
; CHECK-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i16 %v
;
  %a = getelementptr inbounds i16, ptr %p, i32 -64
  %v = load i16, ptr %a
  ret i16 %v
}

define i32 @test15(ptr %p) {
; CHECK-LABEL: 'test15'
; CHECK-NEXT:  Cost Model: Found costs of 0 for: %a = getelementptr inbounds i32, ptr %p, i32 -64
; CHECK-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:1 for: %v = load i32, ptr %a, align 4
; CHECK-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 %v
;
  %a = getelementptr inbounds i32, ptr %p, i32 -64
  %v = load i32, ptr %a
  ret i32 %v
}

define i64 @test16(ptr %p) {
; CHECK-LABEL: 'test16'
; CHECK-NEXT:  Cost Model: Found costs of 1 for: %a = getelementptr inbounds i64, ptr %p, i32 -64
; CHECK-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:1 for: %v = load i64, ptr %a, align 8
; CHECK-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i64 %v
;
  %a = getelementptr inbounds i64, ptr %p, i32 -64
  %v = load i64, ptr %a
  ret i64 %v
}

define i8 @test17(ptr %p) {
; CHECK-LABEL: 'test17'
; CHECK-NEXT:  Cost Model: Found costs of 1 for: %a = getelementptr inbounds i8, ptr %p, i32 -1024
; CHECK-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:1 for: %v = load i8, ptr %a, align 1
; CHECK-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i8 %v
;
  %a = getelementptr inbounds i8, ptr %p, i32 -1024
  %v = load i8, ptr %a
  ret i8 %v
}

define i16 @test18(ptr %p) {
; CHECK-LABEL: 'test18'
; CHECK-NEXT:  Cost Model: Found costs of 1 for: %a = getelementptr inbounds i16, ptr %p, i32 -1024
; CHECK-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:1 for: %v = load i16, ptr %a, align 2
; CHECK-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i16 %v
;
  %a = getelementptr inbounds i16, ptr %p, i32 -1024
  %v = load i16, ptr %a
  ret i16 %v
}

define i32 @test19(ptr %p) {
; CHECK-LABEL: 'test19'
; CHECK-NEXT:  Cost Model: Found costs of 1 for: %a = getelementptr inbounds i32, ptr %p, i32 -1024
; CHECK-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:1 for: %v = load i32, ptr %a, align 4
; CHECK-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 %v
;
  %a = getelementptr inbounds i32, ptr %p, i32 -1024
  %v = load i32, ptr %a
  ret i32 %v
}

define i64 @test20(ptr %p) {
; CHECK-LABEL: 'test20'
; CHECK-NEXT:  Cost Model: Found costs of 1 for: %a = getelementptr inbounds i64, ptr %p, i32 -1024
; CHECK-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:1 for: %v = load i64, ptr %a, align 8
; CHECK-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i64 %v
;
  %a = getelementptr inbounds i64, ptr %p, i32 -1024
  %v = load i64, ptr %a
  ret i64 %v
}

define i8 @test21(ptr %p, i32 %i) {
; CHECK-LABEL: 'test21'
; CHECK-NEXT:  Cost Model: Found costs of 0 for: %a = getelementptr inbounds i8, ptr %p, i32 %i
; CHECK-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:1 for: %v = load i8, ptr %a, align 1
; CHECK-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i8 %v
;
  %a = getelementptr inbounds i8, ptr %p, i32 %i
  %v = load i8, ptr %a
  ret i8 %v
}

define i16 @test22(ptr %p, i32 %i) {
; CHECK-LABEL: 'test22'
; CHECK-NEXT:  Cost Model: Found costs of 0 for: %a = getelementptr inbounds i16, ptr %p, i32 %i
; CHECK-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:1 for: %v = load i16, ptr %a, align 2
; CHECK-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i16 %v
;
  %a = getelementptr inbounds i16, ptr %p, i32 %i
  %v = load i16, ptr %a
  ret i16 %v
}

define i32 @test23(ptr %p, i32 %i) {
; CHECK-LABEL: 'test23'
; CHECK-NEXT:  Cost Model: Found costs of 0 for: %a = getelementptr inbounds i32, ptr %p, i32 %i
; CHECK-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:1 for: %v = load i32, ptr %a, align 4
; CHECK-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 %v
;
  %a = getelementptr inbounds i32, ptr %p, i32 %i
  %v = load i32, ptr %a
  ret i32 %v
}

define i64 @test24(ptr %p, i32 %i) {
; CHECK-LABEL: 'test24'
; CHECK-NEXT:  Cost Model: Found costs of 0 for: %a = getelementptr inbounds i64, ptr %p, i32 %i
; CHECK-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:1 for: %v = load i64, ptr %a, align 8
; CHECK-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i64 %v
;
  %a = getelementptr inbounds i64, ptr %p, i32 %i
  %v = load i64, ptr %a
  ret i64 %v
}

define i8 @test25(ptr %p) {
; CHECK-LABEL: 'test25'
; CHECK-NEXT:  Cost Model: Found costs of 0 for: %a = getelementptr inbounds i8, ptr %p, i32 -128
; CHECK-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:1 for: %v = load i8, ptr %a, align 1
; CHECK-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i8 %v
;
  %a = getelementptr inbounds i8, ptr %p, i32 -128
  %v = load i8, ptr %a
  ret i8 %v
}

define i16 @test26(ptr %p) {
; CHECK-LABEL: 'test26'
; CHECK-NEXT:  Cost Model: Found costs of 0 for: %a = getelementptr inbounds i16, ptr %p, i32 -128
; CHECK-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:1 for: %v = load i16, ptr %a, align 2
; CHECK-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i16 %v
;
  %a = getelementptr inbounds i16, ptr %p, i32 -128
  %v = load i16, ptr %a
  ret i16 %v
}

define i32 @test27(ptr %p) {
; CHECK-LABEL: 'test27'
; CHECK-NEXT:  Cost Model: Found costs of 1 for: %a = getelementptr inbounds i32, ptr %p, i32 -128
; CHECK-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:1 for: %v = load i32, ptr %a, align 4
; CHECK-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 %v
;
  %a = getelementptr inbounds i32, ptr %p, i32 -128
  %v = load i32, ptr %a
  ret i32 %v
}

define i64 @test28(ptr %p) {
; CHECK-LABEL: 'test28'
; CHECK-NEXT:  Cost Model: Found costs of 1 for: %a = getelementptr inbounds i64, ptr %p, i32 -128
; CHECK-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:1 for: %v = load i64, ptr %a, align 8
; CHECK-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i64 %v
;
  %a = getelementptr inbounds i64, ptr %p, i32 -128
  %v = load i64, ptr %a
  ret i64 %v
}

define i8 @test29(ptr %p) {
; CHECK-LABEL: 'test29'
; CHECK-NEXT:  Cost Model: Found costs of 0 for: %a = getelementptr inbounds i8, ptr %p, i32 -256
; CHECK-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:1 for: %v = load i8, ptr %a, align 1
; CHECK-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i8 %v
;
  %a = getelementptr inbounds i8, ptr %p, i32 -256
  %v = load i8, ptr %a
  ret i8 %v
}

define i16 @test30(ptr %p) {
; CHECK-LABEL: 'test30'
; CHECK-NEXT:  Cost Model: Found costs of 1 for: %a = getelementptr inbounds i16, ptr %p, i32 -256
; CHECK-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:1 for: %v = load i16, ptr %a, align 2
; CHECK-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i16 %v
;
  %a = getelementptr inbounds i16, ptr %p, i32 -256
  %v = load i16, ptr %a
  ret i16 %v
}

define i32 @test31(ptr %p) {
; CHECK-LABEL: 'test31'
; CHECK-NEXT:  Cost Model: Found costs of 1 for: %a = getelementptr inbounds i32, ptr %p, i32 -256
; CHECK-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:1 for: %v = load i32, ptr %a, align 4
; CHECK-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 %v
;
  %a = getelementptr inbounds i32, ptr %p, i32 -256
  %v = load i32, ptr %a
  ret i32 %v
}

define i64 @test32(ptr %p) {
; CHECK-LABEL: 'test32'
; CHECK-NEXT:  Cost Model: Found costs of 1 for: %a = getelementptr inbounds i64, ptr %p, i32 -256
; CHECK-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:1 for: %v = load i64, ptr %a, align 8
; CHECK-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i64 %v
;
  %a = getelementptr inbounds i64, ptr %p, i32 -256
  %v = load i64, ptr %a
  ret i64 %v
}

define i8 @test33(ptr %p) {
; CHECK-LABEL: 'test33'
; CHECK-NEXT:  Cost Model: Found costs of 1 for: %a = getelementptr inbounds i8, ptr %p, i32 -512
; CHECK-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:1 for: %v = load i8, ptr %a, align 1
; CHECK-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i8 %v
;
  %a = getelementptr inbounds i8, ptr %p, i32 -512
  %v = load i8, ptr %a
  ret i8 %v
}

define i16 @test34(ptr %p) {
; CHECK-LABEL: 'test34'
; CHECK-NEXT:  Cost Model: Found costs of 1 for: %a = getelementptr inbounds i16, ptr %p, i32 -512
; CHECK-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:1 for: %v = load i16, ptr %a, align 2
; CHECK-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i16 %v
;
  %a = getelementptr inbounds i16, ptr %p, i32 -512
  %v = load i16, ptr %a
  ret i16 %v
}

define i32 @test35(ptr %p) {
; CHECK-LABEL: 'test35'
; CHECK-NEXT:  Cost Model: Found costs of 1 for: %a = getelementptr inbounds i32, ptr %p, i32 -512
; CHECK-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:1 for: %v = load i32, ptr %a, align 4
; CHECK-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 %v
;
  %a = getelementptr inbounds i32, ptr %p, i32 -512
  %v = load i32, ptr %a
  ret i32 %v
}

define i64 @test36(ptr %p) {
; CHECK-LABEL: 'test36'
; CHECK-NEXT:  Cost Model: Found costs of 1 for: %a = getelementptr inbounds i64, ptr %p, i32 -512
; CHECK-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:1 for: %v = load i64, ptr %a, align 8
; CHECK-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i64 %v
;
  %a = getelementptr inbounds i64, ptr %p, i32 -512
  %v = load i64, ptr %a
  ret i64 %v
}
