; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 5
; RUN: llc -mtriple=x86_64 -verify-machineinstrs -relocation-model=pic < %s | FileCheck %s

; Passing a pointer to thread-local storage to a function can be problematic
; since computing such addresses requires a function call that is introduced
; very late in instruction selection. We need to ensure that we don't introduce
; nested call sequence markers if this function call happens in a call sequence.

@TLS = internal thread_local global i64 zeroinitializer, align 8
declare void @bar(ptr)
define internal void @foo() {
; CHECK-LABEL: foo:
; CHECK:       # %bb.0:
; CHECK-NEXT:    pushq %rbx
; CHECK-NEXT:    .cfi_def_cfa_offset 16
; CHECK-NEXT:    .cfi_offset %rbx, -16
; CHECK-NEXT:    leaq TLS@TLSLD(%rip), %rdi
; CHECK-NEXT:    callq __tls_get_addr@PLT
; CHECK-NEXT:    leaq TLS@DTPOFF(%rax), %rbx
; CHECK-NEXT:    movq %rbx, %rdi
; CHECK-NEXT:    callq bar@PLT
; CHECK-NEXT:    movq %rbx, %rdi
; CHECK-NEXT:    callq bar@PLT
; CHECK-NEXT:    popq %rbx
; CHECK-NEXT:    .cfi_def_cfa_offset 8
; CHECK-NEXT:    retq
  call void @bar(ptr @TLS)
  call void @bar(ptr @TLS)
  ret void
}
