; NOTE: Assertions have been autogenerated by utils/update_mir_test_checks.py
; RUN: llc -O0 -mtriple=aarch64-linux-gnu -global-isel -stop-after=irtranslator %s -o - | FileCheck %s

declare i64 @llvm.get.fpenv.i64()
declare void @llvm.set.fpenv.i64(i64 %fpenv)
declare void @llvm.reset.fpenv()
declare i32 @llvm.get.fpmode.i32()
declare void @llvm.set.fpmode.i32(i32 %fpmode)
declare void @llvm.reset.fpmode()

define i64 @func_get_fpenv() #0 {
  ; CHECK-LABEL: name: func_get_fpenv
  ; CHECK: bb.1.entry:
  ; CHECK-NEXT:   [[GET_FPENV:%[0-9]+]]:_(s64) = G_GET_FPENV
  ; CHECK-NEXT:   $x0 = COPY [[GET_FPENV]](s64)
  ; CHECK-NEXT:   RET_ReallyLR implicit $x0
entry:
  %fpenv = call i64 @llvm.get.fpenv.i64()
  ret i64 %fpenv
}

define void @func_set_fpenv(i64 %fpenv) #0 {
  ; CHECK-LABEL: name: func_set_fpenv
  ; CHECK: bb.1.entry:
  ; CHECK-NEXT:   liveins: $x0
  ; CHECK-NEXT: {{  $}}
  ; CHECK-NEXT:   [[COPY:%[0-9]+]]:_(s64) = COPY $x0
  ; CHECK-NEXT:   G_SET_FPENV [[COPY]](s64)
  ; CHECK-NEXT:   RET_ReallyLR
entry:
  call void @llvm.set.fpenv.i64(i64 %fpenv)
  ret void
}

define void @func_reset_fpenv() #0 {
  ; CHECK-LABEL: name: func_reset_fpenv
  ; CHECK: bb.1.entry:
  ; CHECK-NEXT:   G_RESET_FPENV
  ; CHECK-NEXT:   RET_ReallyLR
entry:
  call void @llvm.reset.fpenv()
  ret void
}

define i32 @func_get_fpmode() #0 {
  ; CHECK-LABEL: name: func_get_fpmode
  ; CHECK: bb.1.entry:
  ; CHECK-NEXT:   [[GET_FPMODE:%[0-9]+]]:_(s32) = G_GET_FPMODE
  ; CHECK-NEXT:   $w0 = COPY [[GET_FPMODE]](s32)
  ; CHECK-NEXT:   RET_ReallyLR implicit $w0
entry:
  %fpmode = call i32 @llvm.get.fpmode.i32()
  ret i32 %fpmode
}

define void @func_set_fpmode(i32 %fpmode) #0 {
  ; CHECK-LABEL: name: func_set_fpmode
  ; CHECK: bb.1.entry:
  ; CHECK-NEXT:   liveins: $w0
  ; CHECK-NEXT: {{  $}}
  ; CHECK-NEXT:   [[COPY:%[0-9]+]]:_(s32) = COPY $w0
  ; CHECK-NEXT:   G_SET_FPMODE [[COPY]](s32)
  ; CHECK-NEXT:   RET_ReallyLR
entry:
  call void @llvm.set.fpmode.i32(i32 %fpmode)
  ret void
}


define void @func_reset() #0 {
  ; CHECK-LABEL: name: func_reset
  ; CHECK: bb.1.entry:
  ; CHECK-NEXT:   G_RESET_FPMODE
  ; CHECK-NEXT:   RET_ReallyLR
entry:
  call void @llvm.reset.fpmode()
  ret void
}

attributes #0 = { nounwind "use-soft-float"="true" }
