; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 5
; RUN: llc -mtriple=amdgcn < %s | FileCheck -enable-var-scope -check-prefixes=SI,SI-SDAG %s
; RUN: llc -mtriple=amdgcn -mcpu=tonga < %s | FileCheck -enable-var-scope -check-prefixes=VI-SDAG %s
; RUN: llc -mtriple=amdgcn -mcpu=gfx900 < %s | FileCheck -enable-var-scope -check-prefixes=GFX9,GFX9-SDAG %s
; RUN: llc -mtriple=amdgcn -mcpu=gfx1100 -mattr=-real-true16 < %s | FileCheck -enable-var-scope -check-prefixes=GFX11,GFX11-SDAG,GFX11-SDAG-FAKE16 %s
; RUN: llc -mtriple=amdgcn -mcpu=gfx1100 -mattr=+real-true16 < %s | FileCheck -enable-var-scope -check-prefixes=GFX11,GFX11-SDAG,GFX11-SDAG-TRUE16 %s

define bfloat @v_test_fmed3_r_i_i_bf16_minimumnum_maximumnum(bfloat %a) #1 {
; SI-LABEL: v_test_fmed3_r_i_i_bf16_minimumnum_maximumnum:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_mul_f32_e32 v0, 1.0, v0
; SI-NEXT:    v_and_b32_e32 v0, 0xffff0000, v0
; SI-NEXT:    v_max_f32_e32 v0, 2.0, v0
; SI-NEXT:    v_and_b32_e32 v0, 0xffff0000, v0
; SI-NEXT:    v_min_f32_e32 v0, 4.0, v0
; SI-NEXT:    v_and_b32_e32 v0, 0xffff0000, v0
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-SDAG-LABEL: v_test_fmed3_r_i_i_bf16_minimumnum_maximumnum:
; VI-SDAG:       ; %bb.0:
; VI-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-SDAG-NEXT:    v_lshlrev_b32_e32 v1, 16, v0
; VI-SDAG-NEXT:    v_mov_b32_e32 v2, 0x4000
; VI-SDAG-NEXT:    v_cmp_o_f32_e32 vcc, v1, v1
; VI-SDAG-NEXT:    v_cndmask_b32_e32 v0, v2, v0, vcc
; VI-SDAG-NEXT:    v_lshlrev_b32_e32 v1, 16, v0
; VI-SDAG-NEXT:    v_cmp_lt_f32_e32 vcc, 2.0, v1
; VI-SDAG-NEXT:    v_cndmask_b32_e32 v0, v2, v0, vcc
; VI-SDAG-NEXT:    v_lshlrev_b32_e32 v1, 16, v0
; VI-SDAG-NEXT:    v_mov_b32_e32 v2, 0x4080
; VI-SDAG-NEXT:    v_cmp_gt_f32_e32 vcc, 4.0, v1
; VI-SDAG-NEXT:    v_cndmask_b32_e32 v0, v2, v0, vcc
; VI-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: v_test_fmed3_r_i_i_bf16_minimumnum_maximumnum:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_lshlrev_b32_e32 v1, 16, v0
; GFX9-NEXT:    v_mov_b32_e32 v2, 0x4000
; GFX9-NEXT:    v_cmp_o_f32_e32 vcc, v1, v1
; GFX9-NEXT:    v_cndmask_b32_e32 v0, v2, v0, vcc
; GFX9-NEXT:    v_lshlrev_b32_e32 v1, 16, v0
; GFX9-NEXT:    v_cmp_lt_f32_e32 vcc, 2.0, v1
; GFX9-NEXT:    v_cndmask_b32_e32 v0, v2, v0, vcc
; GFX9-NEXT:    v_lshlrev_b32_e32 v1, 16, v0
; GFX9-NEXT:    v_mov_b32_e32 v2, 0x4080
; GFX9-NEXT:    v_cmp_gt_f32_e32 vcc, 4.0, v1
; GFX9-NEXT:    v_cndmask_b32_e32 v0, v2, v0, vcc
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-FAKE16-LABEL: v_test_fmed3_r_i_i_bf16_minimumnum_maximumnum:
; GFX11-SDAG-FAKE16:       ; %bb.0:
; GFX11-SDAG-FAKE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-FAKE16-NEXT:    v_lshlrev_b32_e32 v1, 16, v0
; GFX11-SDAG-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_1)
; GFX11-SDAG-FAKE16-NEXT:    v_cmp_o_f32_e32 vcc_lo, v1, v1
; GFX11-SDAG-FAKE16-NEXT:    v_cndmask_b32_e32 v0, 0x4000, v0, vcc_lo
; GFX11-SDAG-FAKE16-NEXT:    v_lshlrev_b32_e32 v1, 16, v0
; GFX11-SDAG-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_1)
; GFX11-SDAG-FAKE16-NEXT:    v_cmp_lt_f32_e32 vcc_lo, 2.0, v1
; GFX11-SDAG-FAKE16-NEXT:    v_cndmask_b32_e32 v0, 0x4000, v0, vcc_lo
; GFX11-SDAG-FAKE16-NEXT:    v_lshlrev_b32_e32 v1, 16, v0
; GFX11-SDAG-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-SDAG-FAKE16-NEXT:    v_cmp_gt_f32_e32 vcc_lo, 4.0, v1
; GFX11-SDAG-FAKE16-NEXT:    v_cndmask_b32_e32 v0, 0x4080, v0, vcc_lo
; GFX11-SDAG-FAKE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-TRUE16-LABEL: v_test_fmed3_r_i_i_bf16_minimumnum_maximumnum:
; GFX11-SDAG-TRUE16:       ; %bb.0:
; GFX11-SDAG-TRUE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-TRUE16-NEXT:    v_lshlrev_b32_e32 v1, 16, v0
; GFX11-SDAG-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_1)
; GFX11-SDAG-TRUE16-NEXT:    v_cmp_o_f32_e32 vcc_lo, v1, v1
; GFX11-SDAG-TRUE16-NEXT:    v_cndmask_b16 v0.l, 0x4000, v0.l, vcc_lo
; GFX11-SDAG-TRUE16-NEXT:    v_mov_b16_e32 v1.l, v0.l
; GFX11-SDAG-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-SDAG-TRUE16-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; GFX11-SDAG-TRUE16-NEXT:    v_cmp_lt_f32_e32 vcc_lo, 2.0, v1
; GFX11-SDAG-TRUE16-NEXT:    v_cndmask_b16 v0.l, 0x4000, v0.l, vcc_lo
; GFX11-SDAG-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-SDAG-TRUE16-NEXT:    v_mov_b16_e32 v1.l, v0.l
; GFX11-SDAG-TRUE16-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; GFX11-SDAG-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-SDAG-TRUE16-NEXT:    v_cmp_gt_f32_e32 vcc_lo, 4.0, v1
; GFX11-SDAG-TRUE16-NEXT:    v_cndmask_b16 v0.l, 0x4080, v0.l, vcc_lo
; GFX11-SDAG-TRUE16-NEXT:    s_setpc_b64 s[30:31]
  %max = call bfloat @llvm.maximumnum.bf16(bfloat %a, bfloat 2.0)
  %med = call bfloat @llvm.minimumnum.bf16(bfloat %max, bfloat 4.0)
  ret bfloat %med
}

define <2 x bfloat> @v_test_fmed3_r_i_i_v2bf16_minimumnum_maximumnum(<2 x bfloat> %a) #1 {
; SI-LABEL: v_test_fmed3_r_i_i_v2bf16_minimumnum_maximumnum:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_mul_f32_e32 v1, 1.0, v1
; SI-NEXT:    v_mul_f32_e32 v0, 1.0, v0
; SI-NEXT:    v_and_b32_e32 v0, 0xffff0000, v0
; SI-NEXT:    v_and_b32_e32 v1, 0xffff0000, v1
; SI-NEXT:    v_max_f32_e32 v0, 2.0, v0
; SI-NEXT:    v_max_f32_e32 v1, 2.0, v1
; SI-NEXT:    v_and_b32_e32 v1, 0xffff0000, v1
; SI-NEXT:    v_and_b32_e32 v0, 0xffff0000, v0
; SI-NEXT:    v_min_f32_e32 v1, 4.0, v1
; SI-NEXT:    v_min_f32_e32 v0, 4.0, v0
; SI-NEXT:    v_and_b32_e32 v0, 0xffff0000, v0
; SI-NEXT:    v_and_b32_e32 v1, 0xffff0000, v1
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-SDAG-LABEL: v_test_fmed3_r_i_i_v2bf16_minimumnum_maximumnum:
; VI-SDAG:       ; %bb.0:
; VI-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-SDAG-NEXT:    v_and_b32_e32 v1, 0xffff0000, v0
; VI-SDAG-NEXT:    v_cmp_o_f32_e32 vcc, v1, v1
; VI-SDAG-NEXT:    v_mov_b32_e32 v1, 0x4000
; VI-SDAG-NEXT:    v_cndmask_b32_sdwa v2, v1, v0, vcc dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-SDAG-NEXT:    v_lshlrev_b32_e32 v3, 16, v2
; VI-SDAG-NEXT:    v_cmp_lt_f32_e32 vcc, 2.0, v3
; VI-SDAG-NEXT:    v_lshlrev_b32_e32 v3, 16, v0
; VI-SDAG-NEXT:    v_cndmask_b32_e32 v2, v1, v2, vcc
; VI-SDAG-NEXT:    v_cmp_o_f32_e32 vcc, v3, v3
; VI-SDAG-NEXT:    v_cndmask_b32_e32 v0, v1, v0, vcc
; VI-SDAG-NEXT:    v_lshlrev_b32_e32 v3, 16, v0
; VI-SDAG-NEXT:    v_cmp_lt_f32_e32 vcc, 2.0, v3
; VI-SDAG-NEXT:    v_cndmask_b32_e32 v0, v1, v0, vcc
; VI-SDAG-NEXT:    v_lshlrev_b32_e32 v1, 16, v2
; VI-SDAG-NEXT:    v_cmp_gt_f32_e32 vcc, 4.0, v1
; VI-SDAG-NEXT:    v_mov_b32_e32 v1, 0x4080
; VI-SDAG-NEXT:    v_lshlrev_b32_e32 v3, 16, v0
; VI-SDAG-NEXT:    v_cndmask_b32_sdwa v2, v1, v2, vcc dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; VI-SDAG-NEXT:    v_cmp_gt_f32_e32 vcc, 4.0, v3
; VI-SDAG-NEXT:    v_cndmask_b32_e32 v0, v1, v0, vcc
; VI-SDAG-NEXT:    v_or_b32_sdwa v0, v0, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: v_test_fmed3_r_i_i_v2bf16_minimumnum_maximumnum:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_and_b32_e32 v1, 0xffff0000, v0
; GFX9-NEXT:    v_cmp_o_f32_e32 vcc, v1, v1
; GFX9-NEXT:    v_mov_b32_e32 v1, 0x4000
; GFX9-NEXT:    v_cndmask_b32_sdwa v2, v1, v0, vcc dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX9-NEXT:    v_lshlrev_b32_e32 v3, 16, v2
; GFX9-NEXT:    v_cmp_lt_f32_e32 vcc, 2.0, v3
; GFX9-NEXT:    v_lshlrev_b32_e32 v3, 16, v0
; GFX9-NEXT:    v_cndmask_b32_e32 v2, v1, v2, vcc
; GFX9-NEXT:    v_cmp_o_f32_e32 vcc, v3, v3
; GFX9-NEXT:    v_cndmask_b32_e32 v0, v1, v0, vcc
; GFX9-NEXT:    v_lshlrev_b32_e32 v3, 16, v0
; GFX9-NEXT:    v_cmp_lt_f32_e32 vcc, 2.0, v3
; GFX9-NEXT:    v_cndmask_b32_e32 v0, v1, v0, vcc
; GFX9-NEXT:    v_lshlrev_b32_e32 v1, 16, v2
; GFX9-NEXT:    v_mov_b32_e32 v3, 0x4080
; GFX9-NEXT:    v_cmp_gt_f32_e32 vcc, 4.0, v1
; GFX9-NEXT:    v_cndmask_b32_e32 v1, v3, v2, vcc
; GFX9-NEXT:    v_lshlrev_b32_e32 v2, 16, v0
; GFX9-NEXT:    v_cmp_gt_f32_e32 vcc, 4.0, v2
; GFX9-NEXT:    v_cndmask_b32_e32 v0, v3, v0, vcc
; GFX9-NEXT:    s_mov_b32 s4, 0x5040100
; GFX9-NEXT:    v_perm_b32 v0, v1, v0, s4
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-FAKE16-LABEL: v_test_fmed3_r_i_i_v2bf16_minimumnum_maximumnum:
; GFX11-SDAG-FAKE16:       ; %bb.0:
; GFX11-SDAG-FAKE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-FAKE16-NEXT:    v_and_b32_e32 v1, 0xffff0000, v0
; GFX11-SDAG-FAKE16-NEXT:    v_lshrrev_b32_e32 v2, 16, v0
; GFX11-SDAG-FAKE16-NEXT:    v_lshlrev_b32_e32 v3, 16, v0
; GFX11-SDAG-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_3)
; GFX11-SDAG-FAKE16-NEXT:    v_cmp_o_f32_e32 vcc_lo, v1, v1
; GFX11-SDAG-FAKE16-NEXT:    v_cndmask_b32_e32 v1, 0x4000, v2, vcc_lo
; GFX11-SDAG-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-SDAG-FAKE16-NEXT:    v_cmp_o_f32_e32 vcc_lo, v3, v3
; GFX11-SDAG-FAKE16-NEXT:    v_lshlrev_b32_e32 v2, 16, v1
; GFX11-SDAG-FAKE16-NEXT:    v_cndmask_b32_e32 v0, 0x4000, v0, vcc_lo
; GFX11-SDAG-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-SDAG-FAKE16-NEXT:    v_cmp_lt_f32_e32 vcc_lo, 2.0, v2
; GFX11-SDAG-FAKE16-NEXT:    v_lshlrev_b32_e32 v3, 16, v0
; GFX11-SDAG-FAKE16-NEXT:    v_cndmask_b32_e32 v1, 0x4000, v1, vcc_lo
; GFX11-SDAG-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-SDAG-FAKE16-NEXT:    v_cmp_lt_f32_e32 vcc_lo, 2.0, v3
; GFX11-SDAG-FAKE16-NEXT:    v_lshlrev_b32_e32 v2, 16, v1
; GFX11-SDAG-FAKE16-NEXT:    v_cndmask_b32_e32 v0, 0x4000, v0, vcc_lo
; GFX11-SDAG-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-SDAG-FAKE16-NEXT:    v_cmp_gt_f32_e32 vcc_lo, 4.0, v2
; GFX11-SDAG-FAKE16-NEXT:    v_lshlrev_b32_e32 v3, 16, v0
; GFX11-SDAG-FAKE16-NEXT:    v_cndmask_b32_e32 v1, 0x4080, v1, vcc_lo
; GFX11-SDAG-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_1) | instid1(VALU_DEP_1)
; GFX11-SDAG-FAKE16-NEXT:    v_cmp_gt_f32_e32 vcc_lo, 4.0, v3
; GFX11-SDAG-FAKE16-NEXT:    v_cndmask_b32_e32 v0, 0x4080, v0, vcc_lo
; GFX11-SDAG-FAKE16-NEXT:    v_perm_b32 v0, v1, v0, 0x5040100
; GFX11-SDAG-FAKE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-TRUE16-LABEL: v_test_fmed3_r_i_i_v2bf16_minimumnum_maximumnum:
; GFX11-SDAG-TRUE16:       ; %bb.0:
; GFX11-SDAG-TRUE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-TRUE16-NEXT:    v_and_b32_e32 v1, 0xffff0000, v0
; GFX11-SDAG-TRUE16-NEXT:    v_lshlrev_b32_e32 v2, 16, v0
; GFX11-SDAG-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-SDAG-TRUE16-NEXT:    v_cmp_o_f32_e32 vcc_lo, v1, v1
; GFX11-SDAG-TRUE16-NEXT:    v_cmp_o_f32_e64 s0, v2, v2
; GFX11-SDAG-TRUE16-NEXT:    v_cndmask_b16 v1.l, 0x4000, v0.h, vcc_lo
; GFX11-SDAG-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-SDAG-TRUE16-NEXT:    v_cndmask_b16 v0.l, 0x4000, v0.l, s0
; GFX11-SDAG-TRUE16-NEXT:    v_mov_b16_e32 v2.l, v1.l
; GFX11-SDAG-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-SDAG-TRUE16-NEXT:    v_mov_b16_e32 v3.l, v0.l
; GFX11-SDAG-TRUE16-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; GFX11-SDAG-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-SDAG-TRUE16-NEXT:    v_lshlrev_b32_e32 v3, 16, v3
; GFX11-SDAG-TRUE16-NEXT:    v_cmp_lt_f32_e32 vcc_lo, 2.0, v2
; GFX11-SDAG-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX11-SDAG-TRUE16-NEXT:    v_cmp_lt_f32_e64 s0, 2.0, v3
; GFX11-SDAG-TRUE16-NEXT:    v_cndmask_b16 v1.l, 0x4000, v1.l, vcc_lo
; GFX11-SDAG-TRUE16-NEXT:    v_cndmask_b16 v0.l, 0x4000, v0.l, s0
; GFX11-SDAG-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-SDAG-TRUE16-NEXT:    v_mov_b16_e32 v2.l, v1.l
; GFX11-SDAG-TRUE16-NEXT:    v_mov_b16_e32 v3.l, v0.l
; GFX11-SDAG-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-SDAG-TRUE16-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; GFX11-SDAG-TRUE16-NEXT:    v_lshlrev_b32_e32 v3, 16, v3
; GFX11-SDAG-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-SDAG-TRUE16-NEXT:    v_cmp_gt_f32_e32 vcc_lo, 4.0, v2
; GFX11-SDAG-TRUE16-NEXT:    v_cmp_gt_f32_e64 s0, 4.0, v3
; GFX11-SDAG-TRUE16-NEXT:    v_cndmask_b16 v0.h, 0x4080, v1.l, vcc_lo
; GFX11-SDAG-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX11-SDAG-TRUE16-NEXT:    v_cndmask_b16 v0.l, 0x4080, v0.l, s0
; GFX11-SDAG-TRUE16-NEXT:    s_setpc_b64 s[30:31]
  %max = call <2 x bfloat> @llvm.maximumnum.v2bf16(<2 x bfloat> %a, <2 x bfloat> splat (bfloat 2.0))
  %med = call <2 x bfloat> @llvm.minimumnum.v2bf16(<2 x bfloat> %max, <2 x bfloat> splat (bfloat 4.0))
  ret <2 x bfloat> %med
}

attributes #0 = { nounwind readnone }
attributes #1 = { nounwind "unsafe-fp-math"="false" "no-nans-fp-math"="false" }
attributes #2 = { nounwind "unsafe-fp-math"="false" "no-nans-fp-math"="true" }
;; NOTE: These prefixes are unused and the list is autogenerated. Do not add tests below this line:
; GFX11: {{.*}}
; GFX11-SDAG: {{.*}}
; GFX9-SDAG: {{.*}}
; SI-SDAG: {{.*}}
