; NOTE: Assertions have been autogenerated by utils/update_test_checks.py UTC_ARGS: --version 2
; RUN: opt -aa-pipeline=basic-aa -passes=attributor -attributor-manifest-internal -S < %s | FileCheck %s --check-prefixes=CHECK,TUNIT

declare float @llvm.fptrunc.round.f32.f64(double, metadata)

define float @ret_fptrunc(double %arg0) {
; CHECK-LABEL: define float @ret_fptrunc
; CHECK-SAME: (double [[ARG0:%.*]]) #[[ATTR1:[0-9]+]] {
; CHECK-NEXT:    [[EXT:%.*]] = fptrunc double [[ARG0]] to float
; CHECK-NEXT:    ret float [[EXT]]
;
  %ext = fptrunc double %arg0 to float
  ret float %ext
}

define float @ret_fptrunc_nonan(double nofpclass(nan) %arg0) {
; CHECK-LABEL: define nofpclass(nan) float @ret_fptrunc_nonan
; CHECK-SAME: (double nofpclass(nan) [[ARG0:%.*]]) #[[ATTR1]] {
; CHECK-NEXT:    [[EXT:%.*]] = fptrunc double [[ARG0]] to float
; CHECK-NEXT:    ret float [[EXT]]
;
  %ext = fptrunc double %arg0 to float
  ret float %ext
}

define float @ret_fptrunc_noqnan(double nofpclass(qnan) %arg0) {
; CHECK-LABEL: define float @ret_fptrunc_noqnan
; CHECK-SAME: (double nofpclass(qnan) [[ARG0:%.*]]) #[[ATTR1]] {
; CHECK-NEXT:    [[EXT:%.*]] = fptrunc double [[ARG0]] to float
; CHECK-NEXT:    ret float [[EXT]]
;
  %ext = fptrunc double %arg0 to float
  ret float %ext
}

define float @ret_fptrunc_nosnan(double nofpclass(snan) %arg0) {
; CHECK-LABEL: define nofpclass(snan) float @ret_fptrunc_nosnan
; CHECK-SAME: (double nofpclass(snan) [[ARG0:%.*]]) #[[ATTR1]] {
; CHECK-NEXT:    [[EXT:%.*]] = fptrunc double [[ARG0]] to float
; CHECK-NEXT:    ret float [[EXT]]
;
  %ext = fptrunc double %arg0 to float
  ret float %ext
}

define float @ret_fptrunc_noinf(double nofpclass(inf) %arg0) {
; CHECK-LABEL: define float @ret_fptrunc_noinf
; CHECK-SAME: (double nofpclass(inf) [[ARG0:%.*]]) #[[ATTR1]] {
; CHECK-NEXT:    [[EXT:%.*]] = fptrunc double [[ARG0]] to float
; CHECK-NEXT:    ret float [[EXT]]
;
  %ext = fptrunc double %arg0 to float
  ret float %ext
}

define float @ret_fptrunc_nopinf(double nofpclass(pinf) %arg0) {
; CHECK-LABEL: define float @ret_fptrunc_nopinf
; CHECK-SAME: (double nofpclass(pinf) [[ARG0:%.*]]) #[[ATTR1]] {
; CHECK-NEXT:    [[EXT:%.*]] = fptrunc double [[ARG0]] to float
; CHECK-NEXT:    ret float [[EXT]]
;
  %ext = fptrunc double %arg0 to float
  ret float %ext
}

define float @ret_fptrunc_noninf(double nofpclass(ninf) %arg0) {
; CHECK-LABEL: define float @ret_fptrunc_noninf
; CHECK-SAME: (double nofpclass(ninf) [[ARG0:%.*]]) #[[ATTR1]] {
; CHECK-NEXT:    [[EXT:%.*]] = fptrunc double [[ARG0]] to float
; CHECK-NEXT:    ret float [[EXT]]
;
  %ext = fptrunc double %arg0 to float
  ret float %ext
}

define float @ret_fptrunc_nozero(double nofpclass(zero) %arg0) {
; CHECK-LABEL: define float @ret_fptrunc_nozero
; CHECK-SAME: (double nofpclass(zero) [[ARG0:%.*]]) #[[ATTR1]] {
; CHECK-NEXT:    [[EXT:%.*]] = fptrunc double [[ARG0]] to float
; CHECK-NEXT:    ret float [[EXT]]
;
  %ext = fptrunc double %arg0 to float
  ret float %ext
}

define float @ret_fptrunc_nopzero(double nofpclass(pzero) %arg0) {
; CHECK-LABEL: define float @ret_fptrunc_nopzero
; CHECK-SAME: (double nofpclass(pzero) [[ARG0:%.*]]) #[[ATTR1]] {
; CHECK-NEXT:    [[EXT:%.*]] = fptrunc double [[ARG0]] to float
; CHECK-NEXT:    ret float [[EXT]]
;
  %ext = fptrunc double %arg0 to float
  ret float %ext
}

define float @ret_fptrunc_nonzero(double nofpclass(nzero) %arg0) {
; CHECK-LABEL: define float @ret_fptrunc_nonzero
; CHECK-SAME: (double nofpclass(nzero) [[ARG0:%.*]]) #[[ATTR1]] {
; CHECK-NEXT:    [[EXT:%.*]] = fptrunc double [[ARG0]] to float
; CHECK-NEXT:    ret float [[EXT]]
;
  %ext = fptrunc double %arg0 to float
  ret float %ext
}

define float @ret_fptrunc_nonan_noinf(double nofpclass(nan inf) %arg0) {
; CHECK-LABEL: define nofpclass(nan) float @ret_fptrunc_nonan_noinf
; CHECK-SAME: (double nofpclass(nan inf) [[ARG0:%.*]]) #[[ATTR1]] {
; CHECK-NEXT:    [[EXT:%.*]] = fptrunc double [[ARG0]] to float
; CHECK-NEXT:    ret float [[EXT]]
;
  %ext = fptrunc double %arg0 to float
  ret float %ext
}

define float @ret_fptrunc_nosub(double nofpclass(sub) %arg0) {
; CHECK-LABEL: define float @ret_fptrunc_nosub
; CHECK-SAME: (double nofpclass(sub) [[ARG0:%.*]]) #[[ATTR1]] {
; CHECK-NEXT:    [[EXT:%.*]] = fptrunc double [[ARG0]] to float
; CHECK-NEXT:    ret float [[EXT]]
;
  %ext = fptrunc double %arg0 to float
  ret float %ext
}

define float @ret_fptrunc_nonorm(double nofpclass(norm) %arg0) {
; CHECK-LABEL: define float @ret_fptrunc_nonorm
; CHECK-SAME: (double nofpclass(norm) [[ARG0:%.*]]) #[[ATTR1]] {
; CHECK-NEXT:    [[EXT:%.*]] = fptrunc double [[ARG0]] to float
; CHECK-NEXT:    ret float [[EXT]]
;
  %ext = fptrunc double %arg0 to float
  ret float %ext
}

define float @ret_fptrunc_posonly(double nofpclass(ninf nnorm nsub nzero) %arg0) {
; CHECK-LABEL: define nofpclass(ninf nsub nnorm) float @ret_fptrunc_posonly
; CHECK-SAME: (double nofpclass(ninf nzero nsub nnorm) [[ARG0:%.*]]) #[[ATTR1]] {
; CHECK-NEXT:    [[EXT:%.*]] = fptrunc double [[ARG0]] to float
; CHECK-NEXT:    ret float [[EXT]]
;
  %ext = fptrunc double %arg0 to float
  ret float %ext
}

define float @ret_fptrunc_posonly_zero(double nofpclass(ninf nnorm nsub) %arg0) {
; CHECK-LABEL: define nofpclass(ninf nsub nnorm) float @ret_fptrunc_posonly_zero
; CHECK-SAME: (double nofpclass(ninf nsub nnorm) [[ARG0:%.*]]) #[[ATTR1]] {
; CHECK-NEXT:    [[EXT:%.*]] = fptrunc double [[ARG0]] to float
; CHECK-NEXT:    ret float [[EXT]]
;
  %ext = fptrunc double %arg0 to float
  ret float %ext
}

define float @ret_fptrunc_posonly_zero_nan(double nofpclass(ninf nnorm nsub nan) %arg0) {
; CHECK-LABEL: define nofpclass(nan ninf nsub nnorm) float @ret_fptrunc_posonly_zero_nan
; CHECK-SAME: (double nofpclass(nan ninf nsub nnorm) [[ARG0:%.*]]) #[[ATTR1]] {
; CHECK-NEXT:    [[EXT:%.*]] = fptrunc double [[ARG0]] to float
; CHECK-NEXT:    ret float [[EXT]]
;
  %ext = fptrunc double %arg0 to float
  ret float %ext
}

define float @ret_fptrunc_posonly_nan(double nofpclass(ninf nnorm nsub nzero nan) %arg0) {
; CHECK-LABEL: define nofpclass(nan ninf nsub nnorm) float @ret_fptrunc_posonly_nan
; CHECK-SAME: (double nofpclass(nan ninf nzero nsub nnorm) [[ARG0:%.*]]) #[[ATTR1]] {
; CHECK-NEXT:    [[EXT:%.*]] = fptrunc double [[ARG0]] to float
; CHECK-NEXT:    ret float [[EXT]]
;
  %ext = fptrunc double %arg0 to float
  ret float %ext
}

define float @ret_fptrunc_negonly(double nofpclass(pinf pnorm psub pzero) %arg0) {
; CHECK-LABEL: define float @ret_fptrunc_negonly
; CHECK-SAME: (double nofpclass(pinf pzero psub pnorm) [[ARG0:%.*]]) #[[ATTR1]] {
; CHECK-NEXT:    [[EXT:%.*]] = fptrunc double [[ARG0]] to float
; CHECK-NEXT:    ret float [[EXT]]
;
  %ext = fptrunc double %arg0 to float
  ret float %ext
}

define float @ret_fptrunc_negonly_zero(double nofpclass(pinf pnorm psub) %arg0) {
; CHECK-LABEL: define float @ret_fptrunc_negonly_zero
; CHECK-SAME: (double nofpclass(pinf psub pnorm) [[ARG0:%.*]]) #[[ATTR1]] {
; CHECK-NEXT:    [[EXT:%.*]] = fptrunc double [[ARG0]] to float
; CHECK-NEXT:    ret float [[EXT]]
;
  %ext = fptrunc double %arg0 to float
  ret float %ext
}

define float @ret_fptrunc_negonly_zero_nan(double nofpclass(pinf pnorm psub nan) %arg0) {
; CHECK-LABEL: define nofpclass(nan) float @ret_fptrunc_negonly_zero_nan
; CHECK-SAME: (double nofpclass(nan pinf psub pnorm) [[ARG0:%.*]]) #[[ATTR1]] {
; CHECK-NEXT:    [[EXT:%.*]] = fptrunc double [[ARG0]] to float
; CHECK-NEXT:    ret float [[EXT]]
;
  %ext = fptrunc double %arg0 to float
  ret float %ext
}

define float @ret_fptrunc_round(double %arg0) {
; CHECK-LABEL: define float @ret_fptrunc_round
; CHECK-SAME: (double [[ARG0:%.*]]) #[[ATTR1]] {
; CHECK-NEXT:    [[EXT:%.*]] = call float @llvm.fptrunc.round.f32.f64(double [[ARG0]], metadata !"round.downward") #[[ATTR2:[0-9]+]]
; CHECK-NEXT:    ret float [[EXT]]
;
  %ext = call float @llvm.fptrunc.round.f32.f64(double %arg0, metadata !"round.downward")
  ret float %ext
}

define float @ret_fptrunc_round_nonan(double nofpclass(nan) %arg0) {
; CHECK-LABEL: define nofpclass(nan) float @ret_fptrunc_round_nonan
; CHECK-SAME: (double nofpclass(nan) [[ARG0:%.*]]) #[[ATTR1]] {
; CHECK-NEXT:    [[EXT:%.*]] = call nofpclass(nan) float @llvm.fptrunc.round.f32.f64(double nofpclass(nan) [[ARG0]], metadata !"round.downward") #[[ATTR2]]
; CHECK-NEXT:    ret float [[EXT]]
;
  %ext = call float @llvm.fptrunc.round.f32.f64(double %arg0, metadata !"round.downward")
  ret float %ext
}

define float @ret_fptrunc_round_noqnan(double nofpclass(qnan) %arg0) {
; CHECK-LABEL: define float @ret_fptrunc_round_noqnan
; CHECK-SAME: (double nofpclass(qnan) [[ARG0:%.*]]) #[[ATTR1]] {
; CHECK-NEXT:    [[EXT:%.*]] = call float @llvm.fptrunc.round.f32.f64(double nofpclass(qnan) [[ARG0]], metadata !"round.downward") #[[ATTR2]]
; CHECK-NEXT:    ret float [[EXT]]
;
  %ext = call float @llvm.fptrunc.round.f32.f64(double %arg0, metadata !"round.downward")
  ret float %ext
}

define float @ret_fptrunc_round_nosnan(double nofpclass(snan) %arg0) {
; CHECK-LABEL: define nofpclass(snan) float @ret_fptrunc_round_nosnan
; CHECK-SAME: (double nofpclass(snan) [[ARG0:%.*]]) #[[ATTR1]] {
; CHECK-NEXT:    [[EXT:%.*]] = call nofpclass(snan) float @llvm.fptrunc.round.f32.f64(double nofpclass(snan) [[ARG0]], metadata !"round.downward") #[[ATTR2]]
; CHECK-NEXT:    ret float [[EXT]]
;
  %ext = call float @llvm.fptrunc.round.f32.f64(double %arg0, metadata !"round.downward")
  ret float %ext
}

define float @ret_fptrunc_round_noinf(double nofpclass(inf) %arg0) {
; CHECK-LABEL: define float @ret_fptrunc_round_noinf
; CHECK-SAME: (double nofpclass(inf) [[ARG0:%.*]]) #[[ATTR1]] {
; CHECK-NEXT:    [[EXT:%.*]] = call float @llvm.fptrunc.round.f32.f64(double nofpclass(inf) [[ARG0]], metadata !"round.downward") #[[ATTR2]]
; CHECK-NEXT:    ret float [[EXT]]
;
  %ext = call float @llvm.fptrunc.round.f32.f64(double %arg0, metadata !"round.downward")
  ret float %ext
}

define float @ret_fptrunc_round_nopinf(double nofpclass(pinf) %arg0) {
; CHECK-LABEL: define float @ret_fptrunc_round_nopinf
; CHECK-SAME: (double nofpclass(pinf) [[ARG0:%.*]]) #[[ATTR1]] {
; CHECK-NEXT:    [[EXT:%.*]] = call float @llvm.fptrunc.round.f32.f64(double nofpclass(pinf) [[ARG0]], metadata !"round.downward") #[[ATTR2]]
; CHECK-NEXT:    ret float [[EXT]]
;
  %ext = call float @llvm.fptrunc.round.f32.f64(double %arg0, metadata !"round.downward")
  ret float %ext
}

define float @ret_fptrunc_round_noninf(double nofpclass(ninf) %arg0) {
; CHECK-LABEL: define float @ret_fptrunc_round_noninf
; CHECK-SAME: (double nofpclass(ninf) [[ARG0:%.*]]) #[[ATTR1]] {
; CHECK-NEXT:    [[EXT:%.*]] = call float @llvm.fptrunc.round.f32.f64(double nofpclass(ninf) [[ARG0]], metadata !"round.downward") #[[ATTR2]]
; CHECK-NEXT:    ret float [[EXT]]
;
  %ext = call float @llvm.fptrunc.round.f32.f64(double %arg0, metadata !"round.downward")
  ret float %ext
}

define float @ret_fptrunc_round_nozero(double nofpclass(zero) %arg0) {
; CHECK-LABEL: define float @ret_fptrunc_round_nozero
; CHECK-SAME: (double nofpclass(zero) [[ARG0:%.*]]) #[[ATTR1]] {
; CHECK-NEXT:    [[EXT:%.*]] = call float @llvm.fptrunc.round.f32.f64(double nofpclass(zero) [[ARG0]], metadata !"round.downward") #[[ATTR2]]
; CHECK-NEXT:    ret float [[EXT]]
;
  %ext = call float @llvm.fptrunc.round.f32.f64(double %arg0, metadata !"round.downward")
  ret float %ext
}

define float @ret_fptrunc_round_nopzero(double nofpclass(pzero) %arg0) {
; CHECK-LABEL: define float @ret_fptrunc_round_nopzero
; CHECK-SAME: (double nofpclass(pzero) [[ARG0:%.*]]) #[[ATTR1]] {
; CHECK-NEXT:    [[EXT:%.*]] = call float @llvm.fptrunc.round.f32.f64(double nofpclass(pzero) [[ARG0]], metadata !"round.downward") #[[ATTR2]]
; CHECK-NEXT:    ret float [[EXT]]
;
  %ext = call float @llvm.fptrunc.round.f32.f64(double %arg0, metadata !"round.downward")
  ret float %ext
}

define float @ret_fptrunc_round_nonzero(double nofpclass(nzero) %arg0) {
; CHECK-LABEL: define float @ret_fptrunc_round_nonzero
; CHECK-SAME: (double nofpclass(nzero) [[ARG0:%.*]]) #[[ATTR1]] {
; CHECK-NEXT:    [[EXT:%.*]] = call float @llvm.fptrunc.round.f32.f64(double nofpclass(nzero) [[ARG0]], metadata !"round.downward") #[[ATTR2]]
; CHECK-NEXT:    ret float [[EXT]]
;
  %ext = call float @llvm.fptrunc.round.f32.f64(double %arg0, metadata !"round.downward")
  ret float %ext
}

define float @ret_fptrunc_round_nonan_noinf(double nofpclass(nan inf) %arg0) {
; CHECK-LABEL: define nofpclass(nan) float @ret_fptrunc_round_nonan_noinf
; CHECK-SAME: (double nofpclass(nan inf) [[ARG0:%.*]]) #[[ATTR1]] {
; CHECK-NEXT:    [[EXT:%.*]] = call nofpclass(nan) float @llvm.fptrunc.round.f32.f64(double nofpclass(nan inf) [[ARG0]], metadata !"round.downward") #[[ATTR2]]
; CHECK-NEXT:    ret float [[EXT]]
;
  %ext = call float @llvm.fptrunc.round.f32.f64(double %arg0, metadata !"round.downward")
  ret float %ext
}

define float @ret_fptrunc_round_nosub(double nofpclass(sub) %arg0) {
; CHECK-LABEL: define float @ret_fptrunc_round_nosub
; CHECK-SAME: (double nofpclass(sub) [[ARG0:%.*]]) #[[ATTR1]] {
; CHECK-NEXT:    [[EXT:%.*]] = call float @llvm.fptrunc.round.f32.f64(double nofpclass(sub) [[ARG0]], metadata !"round.downward") #[[ATTR2]]
; CHECK-NEXT:    ret float [[EXT]]
;
  %ext = call float @llvm.fptrunc.round.f32.f64(double %arg0, metadata !"round.downward")
  ret float %ext
}

define float @ret_fptrunc_round_nonorm(double nofpclass(norm) %arg0) {
; CHECK-LABEL: define float @ret_fptrunc_round_nonorm
; CHECK-SAME: (double nofpclass(norm) [[ARG0:%.*]]) #[[ATTR1]] {
; CHECK-NEXT:    [[EXT:%.*]] = call float @llvm.fptrunc.round.f32.f64(double nofpclass(norm) [[ARG0]], metadata !"round.downward") #[[ATTR2]]
; CHECK-NEXT:    ret float [[EXT]]
;
  %ext = call float @llvm.fptrunc.round.f32.f64(double %arg0, metadata !"round.downward")
  ret float %ext
}

;; NOTE: These prefixes are unused and the list is autogenerated. Do not add tests below this line:
; TUNIT: {{.*}}
