; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: sed 's/iXLen/i32/g' %s | llc -mcpu=pwr7 -ppc-asm-full-reg-names \
; RUN:   -ppc-vsr-nums-as-vr -mtriple=powerpc64-unknown-unknown \
; RUN:   -verify-machineinstrs | FileCheck %s --check-prefixes=BE
; RUN: sed 's/iXLen/i32/g' %s | llc -mcpu=pwr8 -ppc-asm-full-reg-names \
; RUN:   -ppc-vsr-nums-as-vr -mtriple=powerpc64le-unknown-unknown \
; RUN:   -verify-machineinstrs | FileCheck %s
; RUN: sed 's/iXLen/i32/g' %s | llc -mcpu=pwr8 -ppc-asm-full-reg-names \
; RUN:   -ppc-vsr-nums-as-vr -mtriple=powerpc64le-unknown-unknown \
; RUN:   -verify-machineinstrs --enable-unsafe-fp-math | \
; RUN:   FileCheck %s --check-prefixes=FAST
; RUN: sed 's/iXLen/i64/g' %s | llc -mcpu=pwr7 -ppc-asm-full-reg-names \
; RUN:   -ppc-vsr-nums-as-vr -mtriple=powerpc64-unknown-unknown \
; RUN:   -verify-machineinstrs | FileCheck %s --check-prefixes=BE
; RUN: sed 's/iXLen/i64/g' %s | llc -mcpu=pwr8 -ppc-asm-full-reg-names \
; RUN:   -ppc-vsr-nums-as-vr -mtriple=powerpc64le-unknown-unknown \
; RUN:   -verify-machineinstrs | FileCheck %s --check-prefixes=CHECK
; RUN: sed 's/iXLen/i64/g' %s | llc -mcpu=pwr8 -ppc-asm-full-reg-names \
; RUN:   -ppc-vsr-nums-as-vr -mtriple=powerpc64le-unknown-unknown \
; RUN:   -verify-machineinstrs --enable-unsafe-fp-math | \
; RUN:   FileCheck %s --check-prefixes=FAST

define <1 x i64> @lrint_v1f16(<1 x half> %x) {
; BE-LABEL: lrint_v1f16:
; BE:       # %bb.0:
; BE-NEXT:    mflr r0
; BE-NEXT:    stdu r1, -112(r1)
; BE-NEXT:    std r0, 128(r1)
; BE-NEXT:    .cfi_def_cfa_offset 112
; BE-NEXT:    .cfi_offset lr, 16
; BE-NEXT:    bl __gnu_f2h_ieee
; BE-NEXT:    nop
; BE-NEXT:    clrldi r3, r3, 48
; BE-NEXT:    bl __gnu_h2f_ieee
; BE-NEXT:    nop
; BE-NEXT:    bl lrintf
; BE-NEXT:    nop
; BE-NEXT:    addi r1, r1, 112
; BE-NEXT:    ld r0, 16(r1)
; BE-NEXT:    mtlr r0
; BE-NEXT:    blr
;
; CHECK-LABEL: lrint_v1f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    mflr r0
; CHECK-NEXT:    stdu r1, -32(r1)
; CHECK-NEXT:    std r0, 48(r1)
; CHECK-NEXT:    .cfi_def_cfa_offset 32
; CHECK-NEXT:    .cfi_offset lr, 16
; CHECK-NEXT:    bl __gnu_f2h_ieee
; CHECK-NEXT:    nop
; CHECK-NEXT:    clrldi r3, r3, 48
; CHECK-NEXT:    bl __gnu_h2f_ieee
; CHECK-NEXT:    nop
; CHECK-NEXT:    bl lrintf
; CHECK-NEXT:    nop
; CHECK-NEXT:    addi r1, r1, 32
; CHECK-NEXT:    ld r0, 16(r1)
; CHECK-NEXT:    mtlr r0
; CHECK-NEXT:    blr
;
; FAST-LABEL: lrint_v1f16:
; FAST:       # %bb.0:
; FAST-NEXT:    mflr r0
; FAST-NEXT:    stdu r1, -32(r1)
; FAST-NEXT:    std r0, 48(r1)
; FAST-NEXT:    .cfi_def_cfa_offset 32
; FAST-NEXT:    .cfi_offset lr, 16
; FAST-NEXT:    bl __gnu_f2h_ieee
; FAST-NEXT:    nop
; FAST-NEXT:    clrldi r3, r3, 48
; FAST-NEXT:    bl __gnu_h2f_ieee
; FAST-NEXT:    nop
; FAST-NEXT:    fctid f0, f1
; FAST-NEXT:    mffprd r3, f0
; FAST-NEXT:    addi r1, r1, 32
; FAST-NEXT:    ld r0, 16(r1)
; FAST-NEXT:    mtlr r0
; FAST-NEXT:    blr
  %a = call <1 x i64> @llvm.lrint.v1i64.v1f16(<1 x half> %x)
  ret <1 x i64> %a
}
declare <1 x i64> @llvm.lrint.v1i64.v1f16(<1 x half>)

define <2 x i64> @lrint_v2f16(<2 x half> %x) {
; BE-LABEL: lrint_v2f16:
; BE:       # %bb.0:
; BE-NEXT:    mflr r0
; BE-NEXT:    stdu r1, -160(r1)
; BE-NEXT:    std r0, 176(r1)
; BE-NEXT:    .cfi_def_cfa_offset 160
; BE-NEXT:    .cfi_offset lr, 16
; BE-NEXT:    .cfi_offset r30, -24
; BE-NEXT:    .cfi_offset f31, -8
; BE-NEXT:    stfd f31, 152(r1) # 8-byte Folded Spill
; BE-NEXT:    fmr f31, f1
; BE-NEXT:    fmr f1, f2
; BE-NEXT:    std r30, 136(r1) # 8-byte Folded Spill
; BE-NEXT:    bl __gnu_f2h_ieee
; BE-NEXT:    nop
; BE-NEXT:    fmr f1, f31
; BE-NEXT:    mr r30, r3
; BE-NEXT:    bl __gnu_f2h_ieee
; BE-NEXT:    nop
; BE-NEXT:    clrldi r3, r3, 48
; BE-NEXT:    bl __gnu_h2f_ieee
; BE-NEXT:    nop
; BE-NEXT:    clrldi r3, r30, 48
; BE-NEXT:    fmr f31, f1
; BE-NEXT:    bl __gnu_h2f_ieee
; BE-NEXT:    nop
; BE-NEXT:    bl lrintf
; BE-NEXT:    nop
; BE-NEXT:    fmr f1, f31
; BE-NEXT:    std r3, 120(r1)
; BE-NEXT:    bl lrintf
; BE-NEXT:    nop
; BE-NEXT:    std r3, 112(r1)
; BE-NEXT:    addi r3, r1, 112
; BE-NEXT:    ld r30, 136(r1) # 8-byte Folded Reload
; BE-NEXT:    lfd f31, 152(r1) # 8-byte Folded Reload
; BE-NEXT:    lxvd2x v2, 0, r3
; BE-NEXT:    addi r1, r1, 160
; BE-NEXT:    ld r0, 16(r1)
; BE-NEXT:    mtlr r0
; BE-NEXT:    blr
;
; CHECK-LABEL: lrint_v2f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    mflr r0
; CHECK-NEXT:    stdu r1, -96(r1)
; CHECK-NEXT:    std r0, 112(r1)
; CHECK-NEXT:    .cfi_def_cfa_offset 96
; CHECK-NEXT:    .cfi_offset lr, 16
; CHECK-NEXT:    .cfi_offset r30, -24
; CHECK-NEXT:    .cfi_offset f31, -8
; CHECK-NEXT:    .cfi_offset v31, -48
; CHECK-NEXT:    li r3, 48
; CHECK-NEXT:    std r30, 72(r1) # 8-byte Folded Spill
; CHECK-NEXT:    stfd f31, 88(r1) # 8-byte Folded Spill
; CHECK-NEXT:    fmr f31, f2
; CHECK-NEXT:    stvx v31, r1, r3 # 16-byte Folded Spill
; CHECK-NEXT:    bl __gnu_f2h_ieee
; CHECK-NEXT:    nop
; CHECK-NEXT:    fmr f1, f31
; CHECK-NEXT:    mr r30, r3
; CHECK-NEXT:    bl __gnu_f2h_ieee
; CHECK-NEXT:    nop
; CHECK-NEXT:    clrldi r3, r3, 48
; CHECK-NEXT:    bl __gnu_h2f_ieee
; CHECK-NEXT:    nop
; CHECK-NEXT:    clrldi r3, r30, 48
; CHECK-NEXT:    fmr f31, f1
; CHECK-NEXT:    bl __gnu_h2f_ieee
; CHECK-NEXT:    nop
; CHECK-NEXT:    bl lrintf
; CHECK-NEXT:    nop
; CHECK-NEXT:    fmr f1, f31
; CHECK-NEXT:    mtvsrd v31, r3
; CHECK-NEXT:    bl lrintf
; CHECK-NEXT:    nop
; CHECK-NEXT:    mtfprd f0, r3
; CHECK-NEXT:    li r3, 48
; CHECK-NEXT:    lfd f31, 88(r1) # 8-byte Folded Reload
; CHECK-NEXT:    ld r30, 72(r1) # 8-byte Folded Reload
; CHECK-NEXT:    xxmrghd v2, vs0, v31
; CHECK-NEXT:    lvx v31, r1, r3 # 16-byte Folded Reload
; CHECK-NEXT:    addi r1, r1, 96
; CHECK-NEXT:    ld r0, 16(r1)
; CHECK-NEXT:    mtlr r0
; CHECK-NEXT:    blr
;
; FAST-LABEL: lrint_v2f16:
; FAST:       # %bb.0:
; FAST-NEXT:    mflr r0
; FAST-NEXT:    .cfi_def_cfa_offset 48
; FAST-NEXT:    .cfi_offset lr, 16
; FAST-NEXT:    .cfi_offset f30, -16
; FAST-NEXT:    .cfi_offset f31, -8
; FAST-NEXT:    stfd f30, -16(r1) # 8-byte Folded Spill
; FAST-NEXT:    stfd f31, -8(r1) # 8-byte Folded Spill
; FAST-NEXT:    stdu r1, -48(r1)
; FAST-NEXT:    fmr f31, f1
; FAST-NEXT:    fmr f1, f2
; FAST-NEXT:    std r0, 64(r1)
; FAST-NEXT:    bl __gnu_f2h_ieee
; FAST-NEXT:    nop
; FAST-NEXT:    clrldi r3, r3, 48
; FAST-NEXT:    bl __gnu_h2f_ieee
; FAST-NEXT:    nop
; FAST-NEXT:    fmr f30, f1
; FAST-NEXT:    fmr f1, f31
; FAST-NEXT:    bl __gnu_f2h_ieee
; FAST-NEXT:    nop
; FAST-NEXT:    clrldi r3, r3, 48
; FAST-NEXT:    bl __gnu_h2f_ieee
; FAST-NEXT:    nop
; FAST-NEXT:    fctid f0, f1
; FAST-NEXT:    fctid f1, f30
; FAST-NEXT:    mffprd r3, f0
; FAST-NEXT:    mtfprd f0, r3
; FAST-NEXT:    mffprd r3, f1
; FAST-NEXT:    mtfprd f1, r3
; FAST-NEXT:    xxmrghd v2, vs1, vs0
; FAST-NEXT:    addi r1, r1, 48
; FAST-NEXT:    ld r0, 16(r1)
; FAST-NEXT:    lfd f31, -8(r1) # 8-byte Folded Reload
; FAST-NEXT:    lfd f30, -16(r1) # 8-byte Folded Reload
; FAST-NEXT:    mtlr r0
; FAST-NEXT:    blr
  %a = call <2 x i64> @llvm.lrint.v2i64.v2f16(<2 x half> %x)
  ret <2 x i64> %a
}
declare <2 x i64> @llvm.lrint.v2i64.v2f16(<2 x half>)

define <4 x i64> @lrint_v4f16(<4 x half> %x) {
; BE-LABEL: lrint_v4f16:
; BE:       # %bb.0:
; BE-NEXT:    mflr r0
; BE-NEXT:    stdu r1, -208(r1)
; BE-NEXT:    std r0, 224(r1)
; BE-NEXT:    .cfi_def_cfa_offset 208
; BE-NEXT:    .cfi_offset lr, 16
; BE-NEXT:    .cfi_offset r28, -56
; BE-NEXT:    .cfi_offset r29, -48
; BE-NEXT:    .cfi_offset r30, -40
; BE-NEXT:    .cfi_offset f29, -24
; BE-NEXT:    .cfi_offset f30, -16
; BE-NEXT:    .cfi_offset f31, -8
; BE-NEXT:    stfd f29, 184(r1) # 8-byte Folded Spill
; BE-NEXT:    fmr f29, f1
; BE-NEXT:    fmr f1, f2
; BE-NEXT:    std r28, 152(r1) # 8-byte Folded Spill
; BE-NEXT:    std r29, 160(r1) # 8-byte Folded Spill
; BE-NEXT:    std r30, 168(r1) # 8-byte Folded Spill
; BE-NEXT:    stfd f30, 192(r1) # 8-byte Folded Spill
; BE-NEXT:    stfd f31, 200(r1) # 8-byte Folded Spill
; BE-NEXT:    fmr f31, f4
; BE-NEXT:    fmr f30, f3
; BE-NEXT:    bl __gnu_f2h_ieee
; BE-NEXT:    nop
; BE-NEXT:    fmr f1, f29
; BE-NEXT:    mr r30, r3
; BE-NEXT:    bl __gnu_f2h_ieee
; BE-NEXT:    nop
; BE-NEXT:    fmr f1, f31
; BE-NEXT:    mr r29, r3
; BE-NEXT:    bl __gnu_f2h_ieee
; BE-NEXT:    nop
; BE-NEXT:    fmr f1, f30
; BE-NEXT:    mr r28, r3
; BE-NEXT:    bl __gnu_f2h_ieee
; BE-NEXT:    nop
; BE-NEXT:    clrldi r3, r3, 48
; BE-NEXT:    bl __gnu_h2f_ieee
; BE-NEXT:    nop
; BE-NEXT:    clrldi r3, r28, 48
; BE-NEXT:    fmr f31, f1
; BE-NEXT:    bl __gnu_h2f_ieee
; BE-NEXT:    nop
; BE-NEXT:    clrldi r3, r29, 48
; BE-NEXT:    fmr f30, f1
; BE-NEXT:    bl __gnu_h2f_ieee
; BE-NEXT:    nop
; BE-NEXT:    clrldi r3, r30, 48
; BE-NEXT:    fmr f29, f1
; BE-NEXT:    bl __gnu_h2f_ieee
; BE-NEXT:    nop
; BE-NEXT:    bl lrintf
; BE-NEXT:    nop
; BE-NEXT:    fmr f1, f29
; BE-NEXT:    std r3, 120(r1)
; BE-NEXT:    bl lrintf
; BE-NEXT:    nop
; BE-NEXT:    fmr f1, f30
; BE-NEXT:    std r3, 112(r1)
; BE-NEXT:    bl lrintf
; BE-NEXT:    nop
; BE-NEXT:    fmr f1, f31
; BE-NEXT:    std r3, 136(r1)
; BE-NEXT:    bl lrintf
; BE-NEXT:    nop
; BE-NEXT:    std r3, 128(r1)
; BE-NEXT:    addi r3, r1, 112
; BE-NEXT:    ld r30, 168(r1) # 8-byte Folded Reload
; BE-NEXT:    lfd f31, 200(r1) # 8-byte Folded Reload
; BE-NEXT:    lfd f30, 192(r1) # 8-byte Folded Reload
; BE-NEXT:    lfd f29, 184(r1) # 8-byte Folded Reload
; BE-NEXT:    lxvd2x v2, 0, r3
; BE-NEXT:    addi r3, r1, 128
; BE-NEXT:    ld r29, 160(r1) # 8-byte Folded Reload
; BE-NEXT:    ld r28, 152(r1) # 8-byte Folded Reload
; BE-NEXT:    lxvd2x v3, 0, r3
; BE-NEXT:    addi r1, r1, 208
; BE-NEXT:    ld r0, 16(r1)
; BE-NEXT:    mtlr r0
; BE-NEXT:    blr
;
; CHECK-LABEL: lrint_v4f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    mflr r0
; CHECK-NEXT:    stdu r1, -144(r1)
; CHECK-NEXT:    std r0, 160(r1)
; CHECK-NEXT:    .cfi_def_cfa_offset 144
; CHECK-NEXT:    .cfi_offset lr, 16
; CHECK-NEXT:    .cfi_offset r28, -56
; CHECK-NEXT:    .cfi_offset r29, -48
; CHECK-NEXT:    .cfi_offset r30, -40
; CHECK-NEXT:    .cfi_offset f29, -24
; CHECK-NEXT:    .cfi_offset f30, -16
; CHECK-NEXT:    .cfi_offset f31, -8
; CHECK-NEXT:    .cfi_offset v30, -96
; CHECK-NEXT:    .cfi_offset v31, -80
; CHECK-NEXT:    li r3, 48
; CHECK-NEXT:    std r28, 88(r1) # 8-byte Folded Spill
; CHECK-NEXT:    std r29, 96(r1) # 8-byte Folded Spill
; CHECK-NEXT:    std r30, 104(r1) # 8-byte Folded Spill
; CHECK-NEXT:    stfd f29, 120(r1) # 8-byte Folded Spill
; CHECK-NEXT:    fmr f29, f2
; CHECK-NEXT:    stfd f30, 128(r1) # 8-byte Folded Spill
; CHECK-NEXT:    fmr f30, f3
; CHECK-NEXT:    stvx v30, r1, r3 # 16-byte Folded Spill
; CHECK-NEXT:    li r3, 64
; CHECK-NEXT:    stfd f31, 136(r1) # 8-byte Folded Spill
; CHECK-NEXT:    fmr f31, f4
; CHECK-NEXT:    stvx v31, r1, r3 # 16-byte Folded Spill
; CHECK-NEXT:    bl __gnu_f2h_ieee
; CHECK-NEXT:    nop
; CHECK-NEXT:    fmr f1, f29
; CHECK-NEXT:    mr r30, r3
; CHECK-NEXT:    bl __gnu_f2h_ieee
; CHECK-NEXT:    nop
; CHECK-NEXT:    fmr f1, f30
; CHECK-NEXT:    mr r29, r3
; CHECK-NEXT:    bl __gnu_f2h_ieee
; CHECK-NEXT:    nop
; CHECK-NEXT:    fmr f1, f31
; CHECK-NEXT:    mr r28, r3
; CHECK-NEXT:    bl __gnu_f2h_ieee
; CHECK-NEXT:    nop
; CHECK-NEXT:    clrldi r3, r3, 48
; CHECK-NEXT:    bl __gnu_h2f_ieee
; CHECK-NEXT:    nop
; CHECK-NEXT:    clrldi r3, r28, 48
; CHECK-NEXT:    fmr f31, f1
; CHECK-NEXT:    bl __gnu_h2f_ieee
; CHECK-NEXT:    nop
; CHECK-NEXT:    clrldi r3, r29, 48
; CHECK-NEXT:    fmr f30, f1
; CHECK-NEXT:    bl __gnu_h2f_ieee
; CHECK-NEXT:    nop
; CHECK-NEXT:    clrldi r3, r30, 48
; CHECK-NEXT:    fmr f29, f1
; CHECK-NEXT:    bl __gnu_h2f_ieee
; CHECK-NEXT:    nop
; CHECK-NEXT:    bl lrintf
; CHECK-NEXT:    nop
; CHECK-NEXT:    fmr f1, f29
; CHECK-NEXT:    mtvsrd v31, r3
; CHECK-NEXT:    bl lrintf
; CHECK-NEXT:    nop
; CHECK-NEXT:    fmr f1, f30
; CHECK-NEXT:    mtfprd f0, r3
; CHECK-NEXT:    xxmrghd v31, vs0, v31
; CHECK-NEXT:    bl lrintf
; CHECK-NEXT:    nop
; CHECK-NEXT:    fmr f1, f31
; CHECK-NEXT:    mtvsrd v30, r3
; CHECK-NEXT:    bl lrintf
; CHECK-NEXT:    nop
; CHECK-NEXT:    mtfprd f0, r3
; CHECK-NEXT:    li r3, 64
; CHECK-NEXT:    vmr v2, v31
; CHECK-NEXT:    lfd f31, 136(r1) # 8-byte Folded Reload
; CHECK-NEXT:    lfd f30, 128(r1) # 8-byte Folded Reload
; CHECK-NEXT:    lfd f29, 120(r1) # 8-byte Folded Reload
; CHECK-NEXT:    ld r30, 104(r1) # 8-byte Folded Reload
; CHECK-NEXT:    ld r29, 96(r1) # 8-byte Folded Reload
; CHECK-NEXT:    lvx v31, r1, r3 # 16-byte Folded Reload
; CHECK-NEXT:    li r3, 48
; CHECK-NEXT:    ld r28, 88(r1) # 8-byte Folded Reload
; CHECK-NEXT:    xxmrghd v3, vs0, v30
; CHECK-NEXT:    lvx v30, r1, r3 # 16-byte Folded Reload
; CHECK-NEXT:    addi r1, r1, 144
; CHECK-NEXT:    ld r0, 16(r1)
; CHECK-NEXT:    mtlr r0
; CHECK-NEXT:    blr
;
; FAST-LABEL: lrint_v4f16:
; FAST:       # %bb.0:
; FAST-NEXT:    mflr r0
; FAST-NEXT:    .cfi_def_cfa_offset 64
; FAST-NEXT:    .cfi_offset lr, 16
; FAST-NEXT:    .cfi_offset f28, -32
; FAST-NEXT:    .cfi_offset f29, -24
; FAST-NEXT:    .cfi_offset f30, -16
; FAST-NEXT:    .cfi_offset f31, -8
; FAST-NEXT:    stfd f28, -32(r1) # 8-byte Folded Spill
; FAST-NEXT:    stfd f29, -24(r1) # 8-byte Folded Spill
; FAST-NEXT:    stfd f30, -16(r1) # 8-byte Folded Spill
; FAST-NEXT:    stfd f31, -8(r1) # 8-byte Folded Spill
; FAST-NEXT:    stdu r1, -64(r1)
; FAST-NEXT:    fmr f29, f1
; FAST-NEXT:    fmr f1, f4
; FAST-NEXT:    std r0, 80(r1)
; FAST-NEXT:    fmr f31, f3
; FAST-NEXT:    fmr f30, f2
; FAST-NEXT:    bl __gnu_f2h_ieee
; FAST-NEXT:    nop
; FAST-NEXT:    clrldi r3, r3, 48
; FAST-NEXT:    bl __gnu_h2f_ieee
; FAST-NEXT:    nop
; FAST-NEXT:    fmr f28, f1
; FAST-NEXT:    fmr f1, f31
; FAST-NEXT:    bl __gnu_f2h_ieee
; FAST-NEXT:    nop
; FAST-NEXT:    clrldi r3, r3, 48
; FAST-NEXT:    bl __gnu_h2f_ieee
; FAST-NEXT:    nop
; FAST-NEXT:    fmr f31, f1
; FAST-NEXT:    fmr f1, f30
; FAST-NEXT:    bl __gnu_f2h_ieee
; FAST-NEXT:    nop
; FAST-NEXT:    clrldi r3, r3, 48
; FAST-NEXT:    bl __gnu_h2f_ieee
; FAST-NEXT:    nop
; FAST-NEXT:    fmr f30, f1
; FAST-NEXT:    fmr f1, f29
; FAST-NEXT:    bl __gnu_f2h_ieee
; FAST-NEXT:    nop
; FAST-NEXT:    clrldi r3, r3, 48
; FAST-NEXT:    bl __gnu_h2f_ieee
; FAST-NEXT:    nop
; FAST-NEXT:    fctid f0, f30
; FAST-NEXT:    fctid f2, f31
; FAST-NEXT:    mffprd r3, f0
; FAST-NEXT:    fctid f1, f1
; FAST-NEXT:    mtfprd f0, r3
; FAST-NEXT:    mffprd r3, f2
; FAST-NEXT:    mtfprd f2, r3
; FAST-NEXT:    mffprd r3, f1
; FAST-NEXT:    mtfprd f1, r3
; FAST-NEXT:    xxmrghd v2, vs0, vs1
; FAST-NEXT:    fctid f0, f28
; FAST-NEXT:    mffprd r3, f0
; FAST-NEXT:    mtfprd f0, r3
; FAST-NEXT:    xxmrghd v3, vs0, vs2
; FAST-NEXT:    addi r1, r1, 64
; FAST-NEXT:    ld r0, 16(r1)
; FAST-NEXT:    lfd f31, -8(r1) # 8-byte Folded Reload
; FAST-NEXT:    lfd f30, -16(r1) # 8-byte Folded Reload
; FAST-NEXT:    mtlr r0
; FAST-NEXT:    lfd f29, -24(r1) # 8-byte Folded Reload
; FAST-NEXT:    lfd f28, -32(r1) # 8-byte Folded Reload
; FAST-NEXT:    blr
  %a = call <4 x i64> @llvm.lrint.v4i64.v4f16(<4 x half> %x)
  ret <4 x i64> %a
}
declare <4 x i64> @llvm.lrint.v4i64.v4f16(<4 x half>)

define <8 x i64> @lrint_v8f16(<8 x half> %x) {
; BE-LABEL: lrint_v8f16:
; BE:       # %bb.0:
; BE-NEXT:    mflr r0
; BE-NEXT:    stdu r1, -304(r1)
; BE-NEXT:    std r0, 320(r1)
; BE-NEXT:    .cfi_def_cfa_offset 304
; BE-NEXT:    .cfi_offset lr, 16
; BE-NEXT:    .cfi_offset r24, -120
; BE-NEXT:    .cfi_offset r25, -112
; BE-NEXT:    .cfi_offset r26, -104
; BE-NEXT:    .cfi_offset r27, -96
; BE-NEXT:    .cfi_offset r28, -88
; BE-NEXT:    .cfi_offset r29, -80
; BE-NEXT:    .cfi_offset r30, -72
; BE-NEXT:    .cfi_offset f25, -56
; BE-NEXT:    .cfi_offset f26, -48
; BE-NEXT:    .cfi_offset f27, -40
; BE-NEXT:    .cfi_offset f28, -32
; BE-NEXT:    .cfi_offset f29, -24
; BE-NEXT:    .cfi_offset f30, -16
; BE-NEXT:    .cfi_offset f31, -8
; BE-NEXT:    stfd f25, 248(r1) # 8-byte Folded Spill
; BE-NEXT:    fmr f25, f1
; BE-NEXT:    fmr f1, f2
; BE-NEXT:    std r24, 184(r1) # 8-byte Folded Spill
; BE-NEXT:    std r25, 192(r1) # 8-byte Folded Spill
; BE-NEXT:    std r26, 200(r1) # 8-byte Folded Spill
; BE-NEXT:    std r27, 208(r1) # 8-byte Folded Spill
; BE-NEXT:    std r28, 216(r1) # 8-byte Folded Spill
; BE-NEXT:    std r29, 224(r1) # 8-byte Folded Spill
; BE-NEXT:    std r30, 232(r1) # 8-byte Folded Spill
; BE-NEXT:    stfd f26, 256(r1) # 8-byte Folded Spill
; BE-NEXT:    stfd f27, 264(r1) # 8-byte Folded Spill
; BE-NEXT:    stfd f28, 272(r1) # 8-byte Folded Spill
; BE-NEXT:    stfd f29, 280(r1) # 8-byte Folded Spill
; BE-NEXT:    stfd f30, 288(r1) # 8-byte Folded Spill
; BE-NEXT:    stfd f31, 296(r1) # 8-byte Folded Spill
; BE-NEXT:    fmr f31, f8
; BE-NEXT:    fmr f30, f7
; BE-NEXT:    fmr f29, f6
; BE-NEXT:    fmr f28, f5
; BE-NEXT:    fmr f27, f4
; BE-NEXT:    fmr f26, f3
; BE-NEXT:    bl __gnu_f2h_ieee
; BE-NEXT:    nop
; BE-NEXT:    fmr f1, f25
; BE-NEXT:    mr r30, r3
; BE-NEXT:    bl __gnu_f2h_ieee
; BE-NEXT:    nop
; BE-NEXT:    fmr f1, f27
; BE-NEXT:    mr r29, r3
; BE-NEXT:    bl __gnu_f2h_ieee
; BE-NEXT:    nop
; BE-NEXT:    fmr f1, f26
; BE-NEXT:    mr r28, r3
; BE-NEXT:    bl __gnu_f2h_ieee
; BE-NEXT:    nop
; BE-NEXT:    fmr f1, f29
; BE-NEXT:    mr r27, r3
; BE-NEXT:    bl __gnu_f2h_ieee
; BE-NEXT:    nop
; BE-NEXT:    fmr f1, f28
; BE-NEXT:    mr r26, r3
; BE-NEXT:    bl __gnu_f2h_ieee
; BE-NEXT:    nop
; BE-NEXT:    fmr f1, f31
; BE-NEXT:    mr r25, r3
; BE-NEXT:    bl __gnu_f2h_ieee
; BE-NEXT:    nop
; BE-NEXT:    fmr f1, f30
; BE-NEXT:    mr r24, r3
; BE-NEXT:    bl __gnu_f2h_ieee
; BE-NEXT:    nop
; BE-NEXT:    clrldi r3, r3, 48
; BE-NEXT:    bl __gnu_h2f_ieee
; BE-NEXT:    nop
; BE-NEXT:    clrldi r3, r24, 48
; BE-NEXT:    fmr f31, f1
; BE-NEXT:    bl __gnu_h2f_ieee
; BE-NEXT:    nop
; BE-NEXT:    clrldi r3, r25, 48
; BE-NEXT:    fmr f30, f1
; BE-NEXT:    bl __gnu_h2f_ieee
; BE-NEXT:    nop
; BE-NEXT:    clrldi r3, r26, 48
; BE-NEXT:    fmr f29, f1
; BE-NEXT:    bl __gnu_h2f_ieee
; BE-NEXT:    nop
; BE-NEXT:    clrldi r3, r27, 48
; BE-NEXT:    fmr f28, f1
; BE-NEXT:    bl __gnu_h2f_ieee
; BE-NEXT:    nop
; BE-NEXT:    clrldi r3, r28, 48
; BE-NEXT:    fmr f27, f1
; BE-NEXT:    bl __gnu_h2f_ieee
; BE-NEXT:    nop
; BE-NEXT:    clrldi r3, r29, 48
; BE-NEXT:    fmr f26, f1
; BE-NEXT:    bl __gnu_h2f_ieee
; BE-NEXT:    nop
; BE-NEXT:    clrldi r3, r30, 48
; BE-NEXT:    fmr f25, f1
; BE-NEXT:    bl __gnu_h2f_ieee
; BE-NEXT:    nop
; BE-NEXT:    bl lrintf
; BE-NEXT:    nop
; BE-NEXT:    fmr f1, f25
; BE-NEXT:    std r3, 120(r1)
; BE-NEXT:    bl lrintf
; BE-NEXT:    nop
; BE-NEXT:    fmr f1, f26
; BE-NEXT:    std r3, 112(r1)
; BE-NEXT:    bl lrintf
; BE-NEXT:    nop
; BE-NEXT:    fmr f1, f27
; BE-NEXT:    std r3, 136(r1)
; BE-NEXT:    bl lrintf
; BE-NEXT:    nop
; BE-NEXT:    fmr f1, f28
; BE-NEXT:    std r3, 128(r1)
; BE-NEXT:    bl lrintf
; BE-NEXT:    nop
; BE-NEXT:    fmr f1, f29
; BE-NEXT:    std r3, 152(r1)
; BE-NEXT:    bl lrintf
; BE-NEXT:    nop
; BE-NEXT:    fmr f1, f30
; BE-NEXT:    std r3, 144(r1)
; BE-NEXT:    bl lrintf
; BE-NEXT:    nop
; BE-NEXT:    fmr f1, f31
; BE-NEXT:    std r3, 168(r1)
; BE-NEXT:    bl lrintf
; BE-NEXT:    nop
; BE-NEXT:    std r3, 160(r1)
; BE-NEXT:    addi r3, r1, 112
; BE-NEXT:    ld r30, 232(r1) # 8-byte Folded Reload
; BE-NEXT:    lfd f31, 296(r1) # 8-byte Folded Reload
; BE-NEXT:    lfd f30, 288(r1) # 8-byte Folded Reload
; BE-NEXT:    lfd f29, 280(r1) # 8-byte Folded Reload
; BE-NEXT:    lxvd2x v2, 0, r3
; BE-NEXT:    addi r3, r1, 128
; BE-NEXT:    lfd f28, 272(r1) # 8-byte Folded Reload
; BE-NEXT:    lfd f27, 264(r1) # 8-byte Folded Reload
; BE-NEXT:    lfd f26, 256(r1) # 8-byte Folded Reload
; BE-NEXT:    ld r29, 224(r1) # 8-byte Folded Reload
; BE-NEXT:    ld r28, 216(r1) # 8-byte Folded Reload
; BE-NEXT:    lxvd2x v3, 0, r3
; BE-NEXT:    addi r3, r1, 144
; BE-NEXT:    lfd f25, 248(r1) # 8-byte Folded Reload
; BE-NEXT:    ld r27, 208(r1) # 8-byte Folded Reload
; BE-NEXT:    ld r26, 200(r1) # 8-byte Folded Reload
; BE-NEXT:    ld r25, 192(r1) # 8-byte Folded Reload
; BE-NEXT:    ld r24, 184(r1) # 8-byte Folded Reload
; BE-NEXT:    lxvd2x v4, 0, r3
; BE-NEXT:    addi r3, r1, 160
; BE-NEXT:    lxvd2x v5, 0, r3
; BE-NEXT:    addi r1, r1, 304
; BE-NEXT:    ld r0, 16(r1)
; BE-NEXT:    mtlr r0
; BE-NEXT:    blr
;
; CHECK-LABEL: lrint_v8f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    mflr r0
; CHECK-NEXT:    stdu r1, -240(r1)
; CHECK-NEXT:    std r0, 256(r1)
; CHECK-NEXT:    .cfi_def_cfa_offset 240
; CHECK-NEXT:    .cfi_offset lr, 16
; CHECK-NEXT:    .cfi_offset r24, -120
; CHECK-NEXT:    .cfi_offset r25, -112
; CHECK-NEXT:    .cfi_offset r26, -104
; CHECK-NEXT:    .cfi_offset r27, -96
; CHECK-NEXT:    .cfi_offset r28, -88
; CHECK-NEXT:    .cfi_offset r29, -80
; CHECK-NEXT:    .cfi_offset r30, -72
; CHECK-NEXT:    .cfi_offset f25, -56
; CHECK-NEXT:    .cfi_offset f26, -48
; CHECK-NEXT:    .cfi_offset f27, -40
; CHECK-NEXT:    .cfi_offset f28, -32
; CHECK-NEXT:    .cfi_offset f29, -24
; CHECK-NEXT:    .cfi_offset f30, -16
; CHECK-NEXT:    .cfi_offset f31, -8
; CHECK-NEXT:    .cfi_offset v28, -192
; CHECK-NEXT:    .cfi_offset v29, -176
; CHECK-NEXT:    .cfi_offset v30, -160
; CHECK-NEXT:    .cfi_offset v31, -144
; CHECK-NEXT:    li r3, 48
; CHECK-NEXT:    std r24, 120(r1) # 8-byte Folded Spill
; CHECK-NEXT:    std r25, 128(r1) # 8-byte Folded Spill
; CHECK-NEXT:    std r26, 136(r1) # 8-byte Folded Spill
; CHECK-NEXT:    std r27, 144(r1) # 8-byte Folded Spill
; CHECK-NEXT:    std r28, 152(r1) # 8-byte Folded Spill
; CHECK-NEXT:    std r29, 160(r1) # 8-byte Folded Spill
; CHECK-NEXT:    std r30, 168(r1) # 8-byte Folded Spill
; CHECK-NEXT:    stvx v28, r1, r3 # 16-byte Folded Spill
; CHECK-NEXT:    li r3, 64
; CHECK-NEXT:    stfd f25, 184(r1) # 8-byte Folded Spill
; CHECK-NEXT:    fmr f25, f2
; CHECK-NEXT:    stfd f26, 192(r1) # 8-byte Folded Spill
; CHECK-NEXT:    fmr f26, f3
; CHECK-NEXT:    stfd f27, 200(r1) # 8-byte Folded Spill
; CHECK-NEXT:    fmr f27, f4
; CHECK-NEXT:    stvx v29, r1, r3 # 16-byte Folded Spill
; CHECK-NEXT:    li r3, 80
; CHECK-NEXT:    stfd f28, 208(r1) # 8-byte Folded Spill
; CHECK-NEXT:    fmr f28, f5
; CHECK-NEXT:    stfd f29, 216(r1) # 8-byte Folded Spill
; CHECK-NEXT:    fmr f29, f6
; CHECK-NEXT:    stfd f30, 224(r1) # 8-byte Folded Spill
; CHECK-NEXT:    fmr f30, f7
; CHECK-NEXT:    stvx v30, r1, r3 # 16-byte Folded Spill
; CHECK-NEXT:    li r3, 96
; CHECK-NEXT:    stfd f31, 232(r1) # 8-byte Folded Spill
; CHECK-NEXT:    fmr f31, f8
; CHECK-NEXT:    stvx v31, r1, r3 # 16-byte Folded Spill
; CHECK-NEXT:    bl __gnu_f2h_ieee
; CHECK-NEXT:    nop
; CHECK-NEXT:    fmr f1, f25
; CHECK-NEXT:    mr r30, r3
; CHECK-NEXT:    bl __gnu_f2h_ieee
; CHECK-NEXT:    nop
; CHECK-NEXT:    fmr f1, f26
; CHECK-NEXT:    mr r29, r3
; CHECK-NEXT:    bl __gnu_f2h_ieee
; CHECK-NEXT:    nop
; CHECK-NEXT:    fmr f1, f27
; CHECK-NEXT:    mr r28, r3
; CHECK-NEXT:    bl __gnu_f2h_ieee
; CHECK-NEXT:    nop
; CHECK-NEXT:    fmr f1, f28
; CHECK-NEXT:    mr r27, r3
; CHECK-NEXT:    bl __gnu_f2h_ieee
; CHECK-NEXT:    nop
; CHECK-NEXT:    fmr f1, f29
; CHECK-NEXT:    mr r26, r3
; CHECK-NEXT:    bl __gnu_f2h_ieee
; CHECK-NEXT:    nop
; CHECK-NEXT:    fmr f1, f30
; CHECK-NEXT:    mr r25, r3
; CHECK-NEXT:    bl __gnu_f2h_ieee
; CHECK-NEXT:    nop
; CHECK-NEXT:    fmr f1, f31
; CHECK-NEXT:    mr r24, r3
; CHECK-NEXT:    bl __gnu_f2h_ieee
; CHECK-NEXT:    nop
; CHECK-NEXT:    clrldi r3, r3, 48
; CHECK-NEXT:    bl __gnu_h2f_ieee
; CHECK-NEXT:    nop
; CHECK-NEXT:    clrldi r3, r24, 48
; CHECK-NEXT:    fmr f31, f1
; CHECK-NEXT:    bl __gnu_h2f_ieee
; CHECK-NEXT:    nop
; CHECK-NEXT:    clrldi r3, r25, 48
; CHECK-NEXT:    fmr f30, f1
; CHECK-NEXT:    bl __gnu_h2f_ieee
; CHECK-NEXT:    nop
; CHECK-NEXT:    clrldi r3, r26, 48
; CHECK-NEXT:    fmr f29, f1
; CHECK-NEXT:    bl __gnu_h2f_ieee
; CHECK-NEXT:    nop
; CHECK-NEXT:    clrldi r3, r27, 48
; CHECK-NEXT:    fmr f28, f1
; CHECK-NEXT:    bl __gnu_h2f_ieee
; CHECK-NEXT:    nop
; CHECK-NEXT:    clrldi r3, r28, 48
; CHECK-NEXT:    fmr f27, f1
; CHECK-NEXT:    bl __gnu_h2f_ieee
; CHECK-NEXT:    nop
; CHECK-NEXT:    clrldi r3, r29, 48
; CHECK-NEXT:    fmr f26, f1
; CHECK-NEXT:    bl __gnu_h2f_ieee
; CHECK-NEXT:    nop
; CHECK-NEXT:    clrldi r3, r30, 48
; CHECK-NEXT:    fmr f25, f1
; CHECK-NEXT:    bl __gnu_h2f_ieee
; CHECK-NEXT:    nop
; CHECK-NEXT:    bl lrintf
; CHECK-NEXT:    nop
; CHECK-NEXT:    fmr f1, f25
; CHECK-NEXT:    mtvsrd v31, r3
; CHECK-NEXT:    bl lrintf
; CHECK-NEXT:    nop
; CHECK-NEXT:    fmr f1, f26
; CHECK-NEXT:    mtfprd f0, r3
; CHECK-NEXT:    xxmrghd v31, vs0, v31
; CHECK-NEXT:    bl lrintf
; CHECK-NEXT:    nop
; CHECK-NEXT:    fmr f1, f27
; CHECK-NEXT:    mtvsrd v30, r3
; CHECK-NEXT:    bl lrintf
; CHECK-NEXT:    nop
; CHECK-NEXT:    fmr f1, f28
; CHECK-NEXT:    mtfprd f0, r3
; CHECK-NEXT:    xxmrghd v30, vs0, v30
; CHECK-NEXT:    bl lrintf
; CHECK-NEXT:    nop
; CHECK-NEXT:    fmr f1, f29
; CHECK-NEXT:    mtvsrd v29, r3
; CHECK-NEXT:    bl lrintf
; CHECK-NEXT:    nop
; CHECK-NEXT:    fmr f1, f30
; CHECK-NEXT:    mtfprd f0, r3
; CHECK-NEXT:    xxmrghd v29, vs0, v29
; CHECK-NEXT:    bl lrintf
; CHECK-NEXT:    nop
; CHECK-NEXT:    fmr f1, f31
; CHECK-NEXT:    mtvsrd v28, r3
; CHECK-NEXT:    bl lrintf
; CHECK-NEXT:    nop
; CHECK-NEXT:    mtfprd f0, r3
; CHECK-NEXT:    li r3, 96
; CHECK-NEXT:    vmr v2, v31
; CHECK-NEXT:    lfd f31, 232(r1) # 8-byte Folded Reload
; CHECK-NEXT:    vmr v3, v30
; CHECK-NEXT:    vmr v4, v29
; CHECK-NEXT:    lfd f30, 224(r1) # 8-byte Folded Reload
; CHECK-NEXT:    lfd f29, 216(r1) # 8-byte Folded Reload
; CHECK-NEXT:    lvx v31, r1, r3 # 16-byte Folded Reload
; CHECK-NEXT:    li r3, 80
; CHECK-NEXT:    lfd f28, 208(r1) # 8-byte Folded Reload
; CHECK-NEXT:    lfd f27, 200(r1) # 8-byte Folded Reload
; CHECK-NEXT:    lfd f26, 192(r1) # 8-byte Folded Reload
; CHECK-NEXT:    lfd f25, 184(r1) # 8-byte Folded Reload
; CHECK-NEXT:    ld r30, 168(r1) # 8-byte Folded Reload
; CHECK-NEXT:    ld r29, 160(r1) # 8-byte Folded Reload
; CHECK-NEXT:    lvx v30, r1, r3 # 16-byte Folded Reload
; CHECK-NEXT:    li r3, 64
; CHECK-NEXT:    ld r28, 152(r1) # 8-byte Folded Reload
; CHECK-NEXT:    ld r27, 144(r1) # 8-byte Folded Reload
; CHECK-NEXT:    xxmrghd v5, vs0, v28
; CHECK-NEXT:    ld r26, 136(r1) # 8-byte Folded Reload
; CHECK-NEXT:    ld r25, 128(r1) # 8-byte Folded Reload
; CHECK-NEXT:    ld r24, 120(r1) # 8-byte Folded Reload
; CHECK-NEXT:    lvx v29, r1, r3 # 16-byte Folded Reload
; CHECK-NEXT:    li r3, 48
; CHECK-NEXT:    lvx v28, r1, r3 # 16-byte Folded Reload
; CHECK-NEXT:    addi r1, r1, 240
; CHECK-NEXT:    ld r0, 16(r1)
; CHECK-NEXT:    mtlr r0
; CHECK-NEXT:    blr
;
; FAST-LABEL: lrint_v8f16:
; FAST:       # %bb.0:
; FAST-NEXT:    mflr r0
; FAST-NEXT:    .cfi_def_cfa_offset 96
; FAST-NEXT:    .cfi_offset lr, 16
; FAST-NEXT:    .cfi_offset f24, -64
; FAST-NEXT:    .cfi_offset f25, -56
; FAST-NEXT:    .cfi_offset f26, -48
; FAST-NEXT:    .cfi_offset f27, -40
; FAST-NEXT:    .cfi_offset f28, -32
; FAST-NEXT:    .cfi_offset f29, -24
; FAST-NEXT:    .cfi_offset f30, -16
; FAST-NEXT:    .cfi_offset f31, -8
; FAST-NEXT:    stfd f24, -64(r1) # 8-byte Folded Spill
; FAST-NEXT:    stfd f25, -56(r1) # 8-byte Folded Spill
; FAST-NEXT:    stfd f26, -48(r1) # 8-byte Folded Spill
; FAST-NEXT:    stfd f27, -40(r1) # 8-byte Folded Spill
; FAST-NEXT:    stfd f28, -32(r1) # 8-byte Folded Spill
; FAST-NEXT:    stfd f29, -24(r1) # 8-byte Folded Spill
; FAST-NEXT:    stfd f30, -16(r1) # 8-byte Folded Spill
; FAST-NEXT:    stfd f31, -8(r1) # 8-byte Folded Spill
; FAST-NEXT:    stdu r1, -96(r1)
; FAST-NEXT:    fmr f24, f1
; FAST-NEXT:    fmr f1, f8
; FAST-NEXT:    std r0, 112(r1)
; FAST-NEXT:    fmr f30, f7
; FAST-NEXT:    fmr f29, f6
; FAST-NEXT:    fmr f28, f5
; FAST-NEXT:    fmr f27, f4
; FAST-NEXT:    fmr f26, f3
; FAST-NEXT:    fmr f25, f2
; FAST-NEXT:    bl __gnu_f2h_ieee
; FAST-NEXT:    nop
; FAST-NEXT:    clrldi r3, r3, 48
; FAST-NEXT:    bl __gnu_h2f_ieee
; FAST-NEXT:    nop
; FAST-NEXT:    fmr f31, f1
; FAST-NEXT:    fmr f1, f30
; FAST-NEXT:    bl __gnu_f2h_ieee
; FAST-NEXT:    nop
; FAST-NEXT:    clrldi r3, r3, 48
; FAST-NEXT:    bl __gnu_h2f_ieee
; FAST-NEXT:    nop
; FAST-NEXT:    fmr f30, f1
; FAST-NEXT:    fmr f1, f29
; FAST-NEXT:    bl __gnu_f2h_ieee
; FAST-NEXT:    nop
; FAST-NEXT:    clrldi r3, r3, 48
; FAST-NEXT:    bl __gnu_h2f_ieee
; FAST-NEXT:    nop
; FAST-NEXT:    fmr f29, f1
; FAST-NEXT:    fmr f1, f28
; FAST-NEXT:    bl __gnu_f2h_ieee
; FAST-NEXT:    nop
; FAST-NEXT:    clrldi r3, r3, 48
; FAST-NEXT:    bl __gnu_h2f_ieee
; FAST-NEXT:    nop
; FAST-NEXT:    fmr f28, f1
; FAST-NEXT:    fmr f1, f27
; FAST-NEXT:    bl __gnu_f2h_ieee
; FAST-NEXT:    nop
; FAST-NEXT:    clrldi r3, r3, 48
; FAST-NEXT:    bl __gnu_h2f_ieee
; FAST-NEXT:    nop
; FAST-NEXT:    fmr f27, f1
; FAST-NEXT:    fmr f1, f26
; FAST-NEXT:    bl __gnu_f2h_ieee
; FAST-NEXT:    nop
; FAST-NEXT:    clrldi r3, r3, 48
; FAST-NEXT:    bl __gnu_h2f_ieee
; FAST-NEXT:    nop
; FAST-NEXT:    fmr f26, f1
; FAST-NEXT:    fmr f1, f25
; FAST-NEXT:    bl __gnu_f2h_ieee
; FAST-NEXT:    nop
; FAST-NEXT:    clrldi r3, r3, 48
; FAST-NEXT:    bl __gnu_h2f_ieee
; FAST-NEXT:    nop
; FAST-NEXT:    fmr f25, f1
; FAST-NEXT:    fmr f1, f24
; FAST-NEXT:    bl __gnu_f2h_ieee
; FAST-NEXT:    nop
; FAST-NEXT:    clrldi r3, r3, 48
; FAST-NEXT:    bl __gnu_h2f_ieee
; FAST-NEXT:    nop
; FAST-NEXT:    fctid f0, f25
; FAST-NEXT:    fctid f2, f26
; FAST-NEXT:    mffprd r3, f0
; FAST-NEXT:    fctid f3, f27
; FAST-NEXT:    fctid f4, f28
; FAST-NEXT:    fctid f5, f29
; FAST-NEXT:    fctid f6, f30
; FAST-NEXT:    fctid f1, f1
; FAST-NEXT:    mtfprd f0, r3
; FAST-NEXT:    mffprd r3, f2
; FAST-NEXT:    mtfprd f2, r3
; FAST-NEXT:    mffprd r3, f3
; FAST-NEXT:    mtfprd f3, r3
; FAST-NEXT:    mffprd r3, f4
; FAST-NEXT:    mtfprd f4, r3
; FAST-NEXT:    mffprd r3, f5
; FAST-NEXT:    mtfprd f5, r3
; FAST-NEXT:    mffprd r3, f6
; FAST-NEXT:    mtfprd f6, r3
; FAST-NEXT:    mffprd r3, f1
; FAST-NEXT:    mtfprd f1, r3
; FAST-NEXT:    xxmrghd v3, vs3, vs2
; FAST-NEXT:    xxmrghd v4, vs5, vs4
; FAST-NEXT:    xxmrghd v2, vs0, vs1
; FAST-NEXT:    fctid f0, f31
; FAST-NEXT:    mffprd r3, f0
; FAST-NEXT:    mtfprd f0, r3
; FAST-NEXT:    xxmrghd v5, vs0, vs6
; FAST-NEXT:    addi r1, r1, 96
; FAST-NEXT:    ld r0, 16(r1)
; FAST-NEXT:    lfd f31, -8(r1) # 8-byte Folded Reload
; FAST-NEXT:    lfd f30, -16(r1) # 8-byte Folded Reload
; FAST-NEXT:    mtlr r0
; FAST-NEXT:    lfd f29, -24(r1) # 8-byte Folded Reload
; FAST-NEXT:    lfd f28, -32(r1) # 8-byte Folded Reload
; FAST-NEXT:    lfd f27, -40(r1) # 8-byte Folded Reload
; FAST-NEXT:    lfd f26, -48(r1) # 8-byte Folded Reload
; FAST-NEXT:    lfd f25, -56(r1) # 8-byte Folded Reload
; FAST-NEXT:    lfd f24, -64(r1) # 8-byte Folded Reload
; FAST-NEXT:    blr
  %a = call <8 x i64> @llvm.lrint.v8i64.v8f16(<8 x half> %x)
  ret <8 x i64> %a
}
declare <8 x i64> @llvm.lrint.v8i64.v8f16(<8 x half>)

define <16 x i64> @lrint_v16i64_v16f16(<16 x half> %x) {
; BE-LABEL: lrint_v16i64_v16f16:
; BE:       # %bb.0:
; BE-NEXT:    mflr r0
; BE-NEXT:    stdu r1, -496(r1)
; BE-NEXT:    std r0, 512(r1)
; BE-NEXT:    .cfi_def_cfa_offset 496
; BE-NEXT:    .cfi_offset lr, 16
; BE-NEXT:    .cfi_offset r16, -248
; BE-NEXT:    .cfi_offset r17, -240
; BE-NEXT:    .cfi_offset r18, -232
; BE-NEXT:    .cfi_offset r19, -224
; BE-NEXT:    .cfi_offset r20, -216
; BE-NEXT:    .cfi_offset r21, -208
; BE-NEXT:    .cfi_offset r22, -200
; BE-NEXT:    .cfi_offset r23, -192
; BE-NEXT:    .cfi_offset r24, -184
; BE-NEXT:    .cfi_offset r25, -176
; BE-NEXT:    .cfi_offset r26, -168
; BE-NEXT:    .cfi_offset r27, -160
; BE-NEXT:    .cfi_offset r28, -152
; BE-NEXT:    .cfi_offset r29, -144
; BE-NEXT:    .cfi_offset r30, -136
; BE-NEXT:    .cfi_offset f17, -120
; BE-NEXT:    .cfi_offset f18, -112
; BE-NEXT:    .cfi_offset f19, -104
; BE-NEXT:    .cfi_offset f20, -96
; BE-NEXT:    .cfi_offset f21, -88
; BE-NEXT:    .cfi_offset f22, -80
; BE-NEXT:    .cfi_offset f23, -72
; BE-NEXT:    .cfi_offset f24, -64
; BE-NEXT:    .cfi_offset f25, -56
; BE-NEXT:    .cfi_offset f26, -48
; BE-NEXT:    .cfi_offset f27, -40
; BE-NEXT:    .cfi_offset f28, -32
; BE-NEXT:    .cfi_offset f29, -24
; BE-NEXT:    .cfi_offset f30, -16
; BE-NEXT:    .cfi_offset f31, -8
; BE-NEXT:    stfd f20, 400(r1) # 8-byte Folded Spill
; BE-NEXT:    fmr f20, f1
; BE-NEXT:    fmr f1, f2
; BE-NEXT:    std r16, 248(r1) # 8-byte Folded Spill
; BE-NEXT:    std r17, 256(r1) # 8-byte Folded Spill
; BE-NEXT:    std r18, 264(r1) # 8-byte Folded Spill
; BE-NEXT:    std r19, 272(r1) # 8-byte Folded Spill
; BE-NEXT:    std r20, 280(r1) # 8-byte Folded Spill
; BE-NEXT:    std r21, 288(r1) # 8-byte Folded Spill
; BE-NEXT:    std r22, 296(r1) # 8-byte Folded Spill
; BE-NEXT:    std r23, 304(r1) # 8-byte Folded Spill
; BE-NEXT:    std r24, 312(r1) # 8-byte Folded Spill
; BE-NEXT:    std r25, 320(r1) # 8-byte Folded Spill
; BE-NEXT:    std r26, 328(r1) # 8-byte Folded Spill
; BE-NEXT:    std r27, 336(r1) # 8-byte Folded Spill
; BE-NEXT:    std r28, 344(r1) # 8-byte Folded Spill
; BE-NEXT:    std r29, 352(r1) # 8-byte Folded Spill
; BE-NEXT:    std r30, 360(r1) # 8-byte Folded Spill
; BE-NEXT:    stfd f17, 376(r1) # 8-byte Folded Spill
; BE-NEXT:    stfd f18, 384(r1) # 8-byte Folded Spill
; BE-NEXT:    stfd f19, 392(r1) # 8-byte Folded Spill
; BE-NEXT:    stfd f21, 408(r1) # 8-byte Folded Spill
; BE-NEXT:    stfd f22, 416(r1) # 8-byte Folded Spill
; BE-NEXT:    stfd f23, 424(r1) # 8-byte Folded Spill
; BE-NEXT:    stfd f24, 432(r1) # 8-byte Folded Spill
; BE-NEXT:    stfd f25, 440(r1) # 8-byte Folded Spill
; BE-NEXT:    stfd f26, 448(r1) # 8-byte Folded Spill
; BE-NEXT:    stfd f27, 456(r1) # 8-byte Folded Spill
; BE-NEXT:    stfd f28, 464(r1) # 8-byte Folded Spill
; BE-NEXT:    stfd f29, 472(r1) # 8-byte Folded Spill
; BE-NEXT:    stfd f30, 480(r1) # 8-byte Folded Spill
; BE-NEXT:    stfd f31, 488(r1) # 8-byte Folded Spill
; BE-NEXT:    fmr f31, f13
; BE-NEXT:    fmr f29, f12
; BE-NEXT:    fmr f30, f11
; BE-NEXT:    fmr f28, f10
; BE-NEXT:    fmr f27, f9
; BE-NEXT:    fmr f26, f8
; BE-NEXT:    fmr f25, f7
; BE-NEXT:    fmr f24, f6
; BE-NEXT:    fmr f23, f5
; BE-NEXT:    fmr f22, f4
; BE-NEXT:    fmr f21, f3
; BE-NEXT:    bl __gnu_f2h_ieee
; BE-NEXT:    nop
; BE-NEXT:    fmr f1, f20
; BE-NEXT:    mr r30, r3
; BE-NEXT:    bl __gnu_f2h_ieee
; BE-NEXT:    nop
; BE-NEXT:    fmr f1, f22
; BE-NEXT:    mr r29, r3
; BE-NEXT:    bl __gnu_f2h_ieee
; BE-NEXT:    nop
; BE-NEXT:    fmr f1, f21
; BE-NEXT:    mr r28, r3
; BE-NEXT:    bl __gnu_f2h_ieee
; BE-NEXT:    nop
; BE-NEXT:    fmr f1, f24
; BE-NEXT:    mr r27, r3
; BE-NEXT:    bl __gnu_f2h_ieee
; BE-NEXT:    nop
; BE-NEXT:    fmr f1, f23
; BE-NEXT:    mr r26, r3
; BE-NEXT:    bl __gnu_f2h_ieee
; BE-NEXT:    nop
; BE-NEXT:    fmr f1, f26
; BE-NEXT:    mr r25, r3
; BE-NEXT:    bl __gnu_f2h_ieee
; BE-NEXT:    nop
; BE-NEXT:    fmr f1, f25
; BE-NEXT:    mr r24, r3
; BE-NEXT:    bl __gnu_f2h_ieee
; BE-NEXT:    nop
; BE-NEXT:    fmr f1, f28
; BE-NEXT:    mr r23, r3
; BE-NEXT:    bl __gnu_f2h_ieee
; BE-NEXT:    nop
; BE-NEXT:    fmr f1, f27
; BE-NEXT:    mr r22, r3
; BE-NEXT:    bl __gnu_f2h_ieee
; BE-NEXT:    nop
; BE-NEXT:    fmr f1, f29
; BE-NEXT:    mr r21, r3
; BE-NEXT:    bl __gnu_f2h_ieee
; BE-NEXT:    nop
; BE-NEXT:    fmr f1, f30
; BE-NEXT:    mr r20, r3
; BE-NEXT:    bl __gnu_f2h_ieee
; BE-NEXT:    nop
; BE-NEXT:    lfs f1, 652(r1)
; BE-NEXT:    mr r19, r3
; BE-NEXT:    bl __gnu_f2h_ieee
; BE-NEXT:    nop
; BE-NEXT:    fmr f1, f31
; BE-NEXT:    mr r18, r3
; BE-NEXT:    bl __gnu_f2h_ieee
; BE-NEXT:    nop
; BE-NEXT:    lfs f1, 668(r1)
; BE-NEXT:    mr r17, r3
; BE-NEXT:    bl __gnu_f2h_ieee
; BE-NEXT:    nop
; BE-NEXT:    lfs f1, 660(r1)
; BE-NEXT:    mr r16, r3
; BE-NEXT:    bl __gnu_f2h_ieee
; BE-NEXT:    nop
; BE-NEXT:    clrldi r3, r3, 48
; BE-NEXT:    bl __gnu_h2f_ieee
; BE-NEXT:    nop
; BE-NEXT:    clrldi r3, r16, 48
; BE-NEXT:    fmr f31, f1
; BE-NEXT:    bl __gnu_h2f_ieee
; BE-NEXT:    nop
; BE-NEXT:    clrldi r3, r17, 48
; BE-NEXT:    fmr f30, f1
; BE-NEXT:    bl __gnu_h2f_ieee
; BE-NEXT:    nop
; BE-NEXT:    clrldi r3, r18, 48
; BE-NEXT:    fmr f29, f1
; BE-NEXT:    bl __gnu_h2f_ieee
; BE-NEXT:    nop
; BE-NEXT:    clrldi r3, r19, 48
; BE-NEXT:    fmr f28, f1
; BE-NEXT:    bl __gnu_h2f_ieee
; BE-NEXT:    nop
; BE-NEXT:    clrldi r3, r20, 48
; BE-NEXT:    fmr f27, f1
; BE-NEXT:    bl __gnu_h2f_ieee
; BE-NEXT:    nop
; BE-NEXT:    clrldi r3, r21, 48
; BE-NEXT:    fmr f26, f1
; BE-NEXT:    bl __gnu_h2f_ieee
; BE-NEXT:    nop
; BE-NEXT:    clrldi r3, r22, 48
; BE-NEXT:    fmr f25, f1
; BE-NEXT:    bl __gnu_h2f_ieee
; BE-NEXT:    nop
; BE-NEXT:    clrldi r3, r23, 48
; BE-NEXT:    fmr f24, f1
; BE-NEXT:    bl __gnu_h2f_ieee
; BE-NEXT:    nop
; BE-NEXT:    clrldi r3, r24, 48
; BE-NEXT:    fmr f23, f1
; BE-NEXT:    bl __gnu_h2f_ieee
; BE-NEXT:    nop
; BE-NEXT:    clrldi r3, r25, 48
; BE-NEXT:    fmr f22, f1
; BE-NEXT:    bl __gnu_h2f_ieee
; BE-NEXT:    nop
; BE-NEXT:    clrldi r3, r26, 48
; BE-NEXT:    fmr f21, f1
; BE-NEXT:    bl __gnu_h2f_ieee
; BE-NEXT:    nop
; BE-NEXT:    clrldi r3, r27, 48
; BE-NEXT:    fmr f20, f1
; BE-NEXT:    bl __gnu_h2f_ieee
; BE-NEXT:    nop
; BE-NEXT:    clrldi r3, r28, 48
; BE-NEXT:    fmr f19, f1
; BE-NEXT:    bl __gnu_h2f_ieee
; BE-NEXT:    nop
; BE-NEXT:    clrldi r3, r29, 48
; BE-NEXT:    fmr f18, f1
; BE-NEXT:    bl __gnu_h2f_ieee
; BE-NEXT:    nop
; BE-NEXT:    clrldi r3, r30, 48
; BE-NEXT:    fmr f17, f1
; BE-NEXT:    bl __gnu_h2f_ieee
; BE-NEXT:    nop
; BE-NEXT:    bl lrintf
; BE-NEXT:    nop
; BE-NEXT:    fmr f1, f17
; BE-NEXT:    std r3, 120(r1)
; BE-NEXT:    bl lrintf
; BE-NEXT:    nop
; BE-NEXT:    fmr f1, f18
; BE-NEXT:    std r3, 112(r1)
; BE-NEXT:    bl lrintf
; BE-NEXT:    nop
; BE-NEXT:    fmr f1, f19
; BE-NEXT:    std r3, 136(r1)
; BE-NEXT:    bl lrintf
; BE-NEXT:    nop
; BE-NEXT:    fmr f1, f20
; BE-NEXT:    std r3, 128(r1)
; BE-NEXT:    bl lrintf
; BE-NEXT:    nop
; BE-NEXT:    fmr f1, f21
; BE-NEXT:    std r3, 152(r1)
; BE-NEXT:    bl lrintf
; BE-NEXT:    nop
; BE-NEXT:    fmr f1, f22
; BE-NEXT:    std r3, 144(r1)
; BE-NEXT:    bl lrintf
; BE-NEXT:    nop
; BE-NEXT:    fmr f1, f23
; BE-NEXT:    std r3, 168(r1)
; BE-NEXT:    bl lrintf
; BE-NEXT:    nop
; BE-NEXT:    fmr f1, f24
; BE-NEXT:    std r3, 160(r1)
; BE-NEXT:    bl lrintf
; BE-NEXT:    nop
; BE-NEXT:    fmr f1, f25
; BE-NEXT:    std r3, 184(r1)
; BE-NEXT:    bl lrintf
; BE-NEXT:    nop
; BE-NEXT:    fmr f1, f26
; BE-NEXT:    std r3, 176(r1)
; BE-NEXT:    bl lrintf
; BE-NEXT:    nop
; BE-NEXT:    fmr f1, f27
; BE-NEXT:    std r3, 200(r1)
; BE-NEXT:    bl lrintf
; BE-NEXT:    nop
; BE-NEXT:    fmr f1, f28
; BE-NEXT:    std r3, 192(r1)
; BE-NEXT:    bl lrintf
; BE-NEXT:    nop
; BE-NEXT:    fmr f1, f29
; BE-NEXT:    std r3, 216(r1)
; BE-NEXT:    bl lrintf
; BE-NEXT:    nop
; BE-NEXT:    fmr f1, f30
; BE-NEXT:    std r3, 208(r1)
; BE-NEXT:    bl lrintf
; BE-NEXT:    nop
; BE-NEXT:    fmr f1, f31
; BE-NEXT:    std r3, 232(r1)
; BE-NEXT:    bl lrintf
; BE-NEXT:    nop
; BE-NEXT:    std r3, 224(r1)
; BE-NEXT:    addi r3, r1, 112
; BE-NEXT:    ld r30, 360(r1) # 8-byte Folded Reload
; BE-NEXT:    lfd f31, 488(r1) # 8-byte Folded Reload
; BE-NEXT:    lfd f30, 480(r1) # 8-byte Folded Reload
; BE-NEXT:    lfd f29, 472(r1) # 8-byte Folded Reload
; BE-NEXT:    lxvd2x v2, 0, r3
; BE-NEXT:    addi r3, r1, 128
; BE-NEXT:    lfd f28, 464(r1) # 8-byte Folded Reload
; BE-NEXT:    lfd f27, 456(r1) # 8-byte Folded Reload
; BE-NEXT:    lfd f26, 448(r1) # 8-byte Folded Reload
; BE-NEXT:    ld r29, 352(r1) # 8-byte Folded Reload
; BE-NEXT:    ld r28, 344(r1) # 8-byte Folded Reload
; BE-NEXT:    lxvd2x v3, 0, r3
; BE-NEXT:    addi r3, r1, 144
; BE-NEXT:    lfd f25, 440(r1) # 8-byte Folded Reload
; BE-NEXT:    lfd f24, 432(r1) # 8-byte Folded Reload
; BE-NEXT:    lfd f23, 424(r1) # 8-byte Folded Reload
; BE-NEXT:    ld r27, 336(r1) # 8-byte Folded Reload
; BE-NEXT:    ld r26, 328(r1) # 8-byte Folded Reload
; BE-NEXT:    lxvd2x v4, 0, r3
; BE-NEXT:    addi r3, r1, 160
; BE-NEXT:    lfd f22, 416(r1) # 8-byte Folded Reload
; BE-NEXT:    lfd f21, 408(r1) # 8-byte Folded Reload
; BE-NEXT:    lfd f20, 400(r1) # 8-byte Folded Reload
; BE-NEXT:    ld r25, 320(r1) # 8-byte Folded Reload
; BE-NEXT:    ld r24, 312(r1) # 8-byte Folded Reload
; BE-NEXT:    lxvd2x v5, 0, r3
; BE-NEXT:    addi r3, r1, 176
; BE-NEXT:    lfd f19, 392(r1) # 8-byte Folded Reload
; BE-NEXT:    lfd f18, 384(r1) # 8-byte Folded Reload
; BE-NEXT:    lfd f17, 376(r1) # 8-byte Folded Reload
; BE-NEXT:    ld r23, 304(r1) # 8-byte Folded Reload
; BE-NEXT:    ld r22, 296(r1) # 8-byte Folded Reload
; BE-NEXT:    lxvd2x v6, 0, r3
; BE-NEXT:    addi r3, r1, 192
; BE-NEXT:    ld r21, 288(r1) # 8-byte Folded Reload
; BE-NEXT:    ld r20, 280(r1) # 8-byte Folded Reload
; BE-NEXT:    ld r19, 272(r1) # 8-byte Folded Reload
; BE-NEXT:    ld r18, 264(r1) # 8-byte Folded Reload
; BE-NEXT:    ld r17, 256(r1) # 8-byte Folded Reload
; BE-NEXT:    ld r16, 248(r1) # 8-byte Folded Reload
; BE-NEXT:    lxvd2x v7, 0, r3
; BE-NEXT:    addi r3, r1, 208
; BE-NEXT:    lxvd2x v8, 0, r3
; BE-NEXT:    addi r3, r1, 224
; BE-NEXT:    lxvd2x v9, 0, r3
; BE-NEXT:    addi r1, r1, 496
; BE-NEXT:    ld r0, 16(r1)
; BE-NEXT:    mtlr r0
; BE-NEXT:    blr
;
; CHECK-LABEL: lrint_v16i64_v16f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    mflr r0
; CHECK-NEXT:    stdu r1, -432(r1)
; CHECK-NEXT:    std r0, 448(r1)
; CHECK-NEXT:    .cfi_def_cfa_offset 432
; CHECK-NEXT:    .cfi_offset lr, 16
; CHECK-NEXT:    .cfi_offset r16, -248
; CHECK-NEXT:    .cfi_offset r17, -240
; CHECK-NEXT:    .cfi_offset r18, -232
; CHECK-NEXT:    .cfi_offset r19, -224
; CHECK-NEXT:    .cfi_offset r20, -216
; CHECK-NEXT:    .cfi_offset r21, -208
; CHECK-NEXT:    .cfi_offset r22, -200
; CHECK-NEXT:    .cfi_offset r23, -192
; CHECK-NEXT:    .cfi_offset r24, -184
; CHECK-NEXT:    .cfi_offset r25, -176
; CHECK-NEXT:    .cfi_offset r26, -168
; CHECK-NEXT:    .cfi_offset r27, -160
; CHECK-NEXT:    .cfi_offset r28, -152
; CHECK-NEXT:    .cfi_offset r29, -144
; CHECK-NEXT:    .cfi_offset r30, -136
; CHECK-NEXT:    .cfi_offset f17, -120
; CHECK-NEXT:    .cfi_offset f18, -112
; CHECK-NEXT:    .cfi_offset f19, -104
; CHECK-NEXT:    .cfi_offset f20, -96
; CHECK-NEXT:    .cfi_offset f21, -88
; CHECK-NEXT:    .cfi_offset f22, -80
; CHECK-NEXT:    .cfi_offset f23, -72
; CHECK-NEXT:    .cfi_offset f24, -64
; CHECK-NEXT:    .cfi_offset f25, -56
; CHECK-NEXT:    .cfi_offset f26, -48
; CHECK-NEXT:    .cfi_offset f27, -40
; CHECK-NEXT:    .cfi_offset f28, -32
; CHECK-NEXT:    .cfi_offset f29, -24
; CHECK-NEXT:    .cfi_offset f30, -16
; CHECK-NEXT:    .cfi_offset f31, -8
; CHECK-NEXT:    .cfi_offset v24, -384
; CHECK-NEXT:    .cfi_offset v25, -368
; CHECK-NEXT:    .cfi_offset v26, -352
; CHECK-NEXT:    .cfi_offset v27, -336
; CHECK-NEXT:    .cfi_offset v28, -320
; CHECK-NEXT:    .cfi_offset v29, -304
; CHECK-NEXT:    .cfi_offset v30, -288
; CHECK-NEXT:    .cfi_offset v31, -272
; CHECK-NEXT:    li r3, 48
; CHECK-NEXT:    std r16, 184(r1) # 8-byte Folded Spill
; CHECK-NEXT:    std r17, 192(r1) # 8-byte Folded Spill
; CHECK-NEXT:    std r18, 200(r1) # 8-byte Folded Spill
; CHECK-NEXT:    std r19, 208(r1) # 8-byte Folded Spill
; CHECK-NEXT:    std r20, 216(r1) # 8-byte Folded Spill
; CHECK-NEXT:    std r21, 224(r1) # 8-byte Folded Spill
; CHECK-NEXT:    std r22, 232(r1) # 8-byte Folded Spill
; CHECK-NEXT:    stvx v24, r1, r3 # 16-byte Folded Spill
; CHECK-NEXT:    li r3, 64
; CHECK-NEXT:    std r23, 240(r1) # 8-byte Folded Spill
; CHECK-NEXT:    std r24, 248(r1) # 8-byte Folded Spill
; CHECK-NEXT:    std r25, 256(r1) # 8-byte Folded Spill
; CHECK-NEXT:    std r26, 264(r1) # 8-byte Folded Spill
; CHECK-NEXT:    std r27, 272(r1) # 8-byte Folded Spill
; CHECK-NEXT:    std r28, 280(r1) # 8-byte Folded Spill
; CHECK-NEXT:    stvx v25, r1, r3 # 16-byte Folded Spill
; CHECK-NEXT:    li r3, 80
; CHECK-NEXT:    std r29, 288(r1) # 8-byte Folded Spill
; CHECK-NEXT:    std r30, 296(r1) # 8-byte Folded Spill
; CHECK-NEXT:    stfd f17, 312(r1) # 8-byte Folded Spill
; CHECK-NEXT:    stfd f18, 320(r1) # 8-byte Folded Spill
; CHECK-NEXT:    stfd f19, 328(r1) # 8-byte Folded Spill
; CHECK-NEXT:    stfd f20, 336(r1) # 8-byte Folded Spill
; CHECK-NEXT:    fmr f20, f2
; CHECK-NEXT:    stvx v26, r1, r3 # 16-byte Folded Spill
; CHECK-NEXT:    li r3, 96
; CHECK-NEXT:    stfd f21, 344(r1) # 8-byte Folded Spill
; CHECK-NEXT:    fmr f21, f3
; CHECK-NEXT:    stfd f22, 352(r1) # 8-byte Folded Spill
; CHECK-NEXT:    fmr f22, f4
; CHECK-NEXT:    stfd f23, 360(r1) # 8-byte Folded Spill
; CHECK-NEXT:    fmr f23, f5
; CHECK-NEXT:    stvx v27, r1, r3 # 16-byte Folded Spill
; CHECK-NEXT:    li r3, 112
; CHECK-NEXT:    stfd f24, 368(r1) # 8-byte Folded Spill
; CHECK-NEXT:    fmr f24, f6
; CHECK-NEXT:    stfd f25, 376(r1) # 8-byte Folded Spill
; CHECK-NEXT:    fmr f25, f7
; CHECK-NEXT:    stfd f26, 384(r1) # 8-byte Folded Spill
; CHECK-NEXT:    fmr f26, f8
; CHECK-NEXT:    stvx v28, r1, r3 # 16-byte Folded Spill
; CHECK-NEXT:    li r3, 128
; CHECK-NEXT:    stfd f27, 392(r1) # 8-byte Folded Spill
; CHECK-NEXT:    fmr f27, f9
; CHECK-NEXT:    stfd f28, 400(r1) # 8-byte Folded Spill
; CHECK-NEXT:    fmr f28, f10
; CHECK-NEXT:    stfd f29, 408(r1) # 8-byte Folded Spill
; CHECK-NEXT:    fmr f29, f11
; CHECK-NEXT:    stvx v29, r1, r3 # 16-byte Folded Spill
; CHECK-NEXT:    li r3, 144
; CHECK-NEXT:    stfd f30, 416(r1) # 8-byte Folded Spill
; CHECK-NEXT:    fmr f30, f12
; CHECK-NEXT:    stfd f31, 424(r1) # 8-byte Folded Spill
; CHECK-NEXT:    fmr f31, f13
; CHECK-NEXT:    stvx v30, r1, r3 # 16-byte Folded Spill
; CHECK-NEXT:    li r3, 160
; CHECK-NEXT:    stvx v31, r1, r3 # 16-byte Folded Spill
; CHECK-NEXT:    bl __gnu_f2h_ieee
; CHECK-NEXT:    nop
; CHECK-NEXT:    fmr f1, f20
; CHECK-NEXT:    mr r30, r3
; CHECK-NEXT:    bl __gnu_f2h_ieee
; CHECK-NEXT:    nop
; CHECK-NEXT:    fmr f1, f21
; CHECK-NEXT:    mr r29, r3
; CHECK-NEXT:    bl __gnu_f2h_ieee
; CHECK-NEXT:    nop
; CHECK-NEXT:    fmr f1, f22
; CHECK-NEXT:    mr r28, r3
; CHECK-NEXT:    bl __gnu_f2h_ieee
; CHECK-NEXT:    nop
; CHECK-NEXT:    fmr f1, f23
; CHECK-NEXT:    mr r27, r3
; CHECK-NEXT:    bl __gnu_f2h_ieee
; CHECK-NEXT:    nop
; CHECK-NEXT:    fmr f1, f24
; CHECK-NEXT:    mr r26, r3
; CHECK-NEXT:    bl __gnu_f2h_ieee
; CHECK-NEXT:    nop
; CHECK-NEXT:    fmr f1, f25
; CHECK-NEXT:    mr r25, r3
; CHECK-NEXT:    bl __gnu_f2h_ieee
; CHECK-NEXT:    nop
; CHECK-NEXT:    fmr f1, f26
; CHECK-NEXT:    mr r24, r3
; CHECK-NEXT:    bl __gnu_f2h_ieee
; CHECK-NEXT:    nop
; CHECK-NEXT:    fmr f1, f27
; CHECK-NEXT:    mr r23, r3
; CHECK-NEXT:    bl __gnu_f2h_ieee
; CHECK-NEXT:    nop
; CHECK-NEXT:    fmr f1, f28
; CHECK-NEXT:    mr r22, r3
; CHECK-NEXT:    bl __gnu_f2h_ieee
; CHECK-NEXT:    nop
; CHECK-NEXT:    fmr f1, f29
; CHECK-NEXT:    mr r21, r3
; CHECK-NEXT:    bl __gnu_f2h_ieee
; CHECK-NEXT:    nop
; CHECK-NEXT:    fmr f1, f30
; CHECK-NEXT:    mr r20, r3
; CHECK-NEXT:    bl __gnu_f2h_ieee
; CHECK-NEXT:    nop
; CHECK-NEXT:    fmr f1, f31
; CHECK-NEXT:    mr r19, r3
; CHECK-NEXT:    bl __gnu_f2h_ieee
; CHECK-NEXT:    nop
; CHECK-NEXT:    lfs f1, 568(r1)
; CHECK-NEXT:    mr r18, r3
; CHECK-NEXT:    bl __gnu_f2h_ieee
; CHECK-NEXT:    nop
; CHECK-NEXT:    lfs f1, 576(r1)
; CHECK-NEXT:    mr r17, r3
; CHECK-NEXT:    bl __gnu_f2h_ieee
; CHECK-NEXT:    nop
; CHECK-NEXT:    lfs f1, 584(r1)
; CHECK-NEXT:    mr r16, r3
; CHECK-NEXT:    bl __gnu_f2h_ieee
; CHECK-NEXT:    nop
; CHECK-NEXT:    clrldi r3, r3, 48
; CHECK-NEXT:    bl __gnu_h2f_ieee
; CHECK-NEXT:    nop
; CHECK-NEXT:    clrldi r3, r16, 48
; CHECK-NEXT:    fmr f31, f1
; CHECK-NEXT:    bl __gnu_h2f_ieee
; CHECK-NEXT:    nop
; CHECK-NEXT:    clrldi r3, r17, 48
; CHECK-NEXT:    fmr f30, f1
; CHECK-NEXT:    bl __gnu_h2f_ieee
; CHECK-NEXT:    nop
; CHECK-NEXT:    clrldi r3, r18, 48
; CHECK-NEXT:    fmr f29, f1
; CHECK-NEXT:    bl __gnu_h2f_ieee
; CHECK-NEXT:    nop
; CHECK-NEXT:    clrldi r3, r19, 48
; CHECK-NEXT:    fmr f28, f1
; CHECK-NEXT:    bl __gnu_h2f_ieee
; CHECK-NEXT:    nop
; CHECK-NEXT:    clrldi r3, r20, 48
; CHECK-NEXT:    fmr f27, f1
; CHECK-NEXT:    bl __gnu_h2f_ieee
; CHECK-NEXT:    nop
; CHECK-NEXT:    clrldi r3, r21, 48
; CHECK-NEXT:    fmr f26, f1
; CHECK-NEXT:    bl __gnu_h2f_ieee
; CHECK-NEXT:    nop
; CHECK-NEXT:    clrldi r3, r22, 48
; CHECK-NEXT:    fmr f25, f1
; CHECK-NEXT:    bl __gnu_h2f_ieee
; CHECK-NEXT:    nop
; CHECK-NEXT:    clrldi r3, r23, 48
; CHECK-NEXT:    fmr f24, f1
; CHECK-NEXT:    bl __gnu_h2f_ieee
; CHECK-NEXT:    nop
; CHECK-NEXT:    clrldi r3, r24, 48
; CHECK-NEXT:    fmr f23, f1
; CHECK-NEXT:    bl __gnu_h2f_ieee
; CHECK-NEXT:    nop
; CHECK-NEXT:    clrldi r3, r25, 48
; CHECK-NEXT:    fmr f22, f1
; CHECK-NEXT:    bl __gnu_h2f_ieee
; CHECK-NEXT:    nop
; CHECK-NEXT:    clrldi r3, r26, 48
; CHECK-NEXT:    fmr f21, f1
; CHECK-NEXT:    bl __gnu_h2f_ieee
; CHECK-NEXT:    nop
; CHECK-NEXT:    clrldi r3, r27, 48
; CHECK-NEXT:    fmr f20, f1
; CHECK-NEXT:    bl __gnu_h2f_ieee
; CHECK-NEXT:    nop
; CHECK-NEXT:    clrldi r3, r28, 48
; CHECK-NEXT:    fmr f19, f1
; CHECK-NEXT:    bl __gnu_h2f_ieee
; CHECK-NEXT:    nop
; CHECK-NEXT:    clrldi r3, r29, 48
; CHECK-NEXT:    fmr f18, f1
; CHECK-NEXT:    bl __gnu_h2f_ieee
; CHECK-NEXT:    nop
; CHECK-NEXT:    clrldi r3, r30, 48
; CHECK-NEXT:    fmr f17, f1
; CHECK-NEXT:    bl __gnu_h2f_ieee
; CHECK-NEXT:    nop
; CHECK-NEXT:    bl lrintf
; CHECK-NEXT:    nop
; CHECK-NEXT:    fmr f1, f17
; CHECK-NEXT:    mtvsrd v31, r3
; CHECK-NEXT:    bl lrintf
; CHECK-NEXT:    nop
; CHECK-NEXT:    fmr f1, f18
; CHECK-NEXT:    mtfprd f0, r3
; CHECK-NEXT:    xxmrghd v31, vs0, v31
; CHECK-NEXT:    bl lrintf
; CHECK-NEXT:    nop
; CHECK-NEXT:    fmr f1, f19
; CHECK-NEXT:    mtvsrd v30, r3
; CHECK-NEXT:    bl lrintf
; CHECK-NEXT:    nop
; CHECK-NEXT:    fmr f1, f20
; CHECK-NEXT:    mtfprd f0, r3
; CHECK-NEXT:    xxmrghd v30, vs0, v30
; CHECK-NEXT:    bl lrintf
; CHECK-NEXT:    nop
; CHECK-NEXT:    fmr f1, f21
; CHECK-NEXT:    mtvsrd v29, r3
; CHECK-NEXT:    bl lrintf
; CHECK-NEXT:    nop
; CHECK-NEXT:    fmr f1, f22
; CHECK-NEXT:    mtfprd f0, r3
; CHECK-NEXT:    xxmrghd v29, vs0, v29
; CHECK-NEXT:    bl lrintf
; CHECK-NEXT:    nop
; CHECK-NEXT:    fmr f1, f23
; CHECK-NEXT:    mtvsrd v28, r3
; CHECK-NEXT:    bl lrintf
; CHECK-NEXT:    nop
; CHECK-NEXT:    fmr f1, f24
; CHECK-NEXT:    mtfprd f0, r3
; CHECK-NEXT:    xxmrghd v28, vs0, v28
; CHECK-NEXT:    bl lrintf
; CHECK-NEXT:    nop
; CHECK-NEXT:    fmr f1, f25
; CHECK-NEXT:    mtvsrd v27, r3
; CHECK-NEXT:    bl lrintf
; CHECK-NEXT:    nop
; CHECK-NEXT:    fmr f1, f26
; CHECK-NEXT:    mtfprd f0, r3
; CHECK-NEXT:    xxmrghd v27, vs0, v27
; CHECK-NEXT:    bl lrintf
; CHECK-NEXT:    nop
; CHECK-NEXT:    fmr f1, f27
; CHECK-NEXT:    mtvsrd v26, r3
; CHECK-NEXT:    bl lrintf
; CHECK-NEXT:    nop
; CHECK-NEXT:    fmr f1, f28
; CHECK-NEXT:    mtfprd f0, r3
; CHECK-NEXT:    xxmrghd v26, vs0, v26
; CHECK-NEXT:    bl lrintf
; CHECK-NEXT:    nop
; CHECK-NEXT:    fmr f1, f29
; CHECK-NEXT:    mtvsrd v25, r3
; CHECK-NEXT:    bl lrintf
; CHECK-NEXT:    nop
; CHECK-NEXT:    fmr f1, f30
; CHECK-NEXT:    mtfprd f0, r3
; CHECK-NEXT:    xxmrghd v25, vs0, v25
; CHECK-NEXT:    bl lrintf
; CHECK-NEXT:    nop
; CHECK-NEXT:    fmr f1, f31
; CHECK-NEXT:    mtvsrd v24, r3
; CHECK-NEXT:    bl lrintf
; CHECK-NEXT:    nop
; CHECK-NEXT:    mtfprd f0, r3
; CHECK-NEXT:    li r3, 160
; CHECK-NEXT:    vmr v2, v31
; CHECK-NEXT:    lfd f31, 424(r1) # 8-byte Folded Reload
; CHECK-NEXT:    vmr v3, v30
; CHECK-NEXT:    vmr v4, v29
; CHECK-NEXT:    lfd f30, 416(r1) # 8-byte Folded Reload
; CHECK-NEXT:    lfd f29, 408(r1) # 8-byte Folded Reload
; CHECK-NEXT:    lvx v31, r1, r3 # 16-byte Folded Reload
; CHECK-NEXT:    li r3, 144
; CHECK-NEXT:    vmr v5, v28
; CHECK-NEXT:    vmr v6, v27
; CHECK-NEXT:    vmr v7, v26
; CHECK-NEXT:    vmr v8, v25
; CHECK-NEXT:    lfd f28, 400(r1) # 8-byte Folded Reload
; CHECK-NEXT:    lfd f27, 392(r1) # 8-byte Folded Reload
; CHECK-NEXT:    lvx v30, r1, r3 # 16-byte Folded Reload
; CHECK-NEXT:    li r3, 128
; CHECK-NEXT:    lfd f26, 384(r1) # 8-byte Folded Reload
; CHECK-NEXT:    lfd f25, 376(r1) # 8-byte Folded Reload
; CHECK-NEXT:    xxmrghd v9, vs0, v24
; CHECK-NEXT:    lfd f24, 368(r1) # 8-byte Folded Reload
; CHECK-NEXT:    lfd f23, 360(r1) # 8-byte Folded Reload
; CHECK-NEXT:    lfd f22, 352(r1) # 8-byte Folded Reload
; CHECK-NEXT:    lvx v29, r1, r3 # 16-byte Folded Reload
; CHECK-NEXT:    li r3, 112
; CHECK-NEXT:    lfd f21, 344(r1) # 8-byte Folded Reload
; CHECK-NEXT:    ld r30, 296(r1) # 8-byte Folded Reload
; CHECK-NEXT:    lfd f20, 336(r1) # 8-byte Folded Reload
; CHECK-NEXT:    lfd f19, 328(r1) # 8-byte Folded Reload
; CHECK-NEXT:    ld r29, 288(r1) # 8-byte Folded Reload
; CHECK-NEXT:    ld r28, 280(r1) # 8-byte Folded Reload
; CHECK-NEXT:    lvx v28, r1, r3 # 16-byte Folded Reload
; CHECK-NEXT:    li r3, 96
; CHECK-NEXT:    lfd f18, 320(r1) # 8-byte Folded Reload
; CHECK-NEXT:    ld r27, 272(r1) # 8-byte Folded Reload
; CHECK-NEXT:    lfd f17, 312(r1) # 8-byte Folded Reload
; CHECK-NEXT:    ld r26, 264(r1) # 8-byte Folded Reload
; CHECK-NEXT:    ld r25, 256(r1) # 8-byte Folded Reload
; CHECK-NEXT:    ld r24, 248(r1) # 8-byte Folded Reload
; CHECK-NEXT:    lvx v27, r1, r3 # 16-byte Folded Reload
; CHECK-NEXT:    li r3, 80
; CHECK-NEXT:    ld r23, 240(r1) # 8-byte Folded Reload
; CHECK-NEXT:    ld r22, 232(r1) # 8-byte Folded Reload
; CHECK-NEXT:    ld r21, 224(r1) # 8-byte Folded Reload
; CHECK-NEXT:    ld r20, 216(r1) # 8-byte Folded Reload
; CHECK-NEXT:    ld r19, 208(r1) # 8-byte Folded Reload
; CHECK-NEXT:    ld r18, 200(r1) # 8-byte Folded Reload
; CHECK-NEXT:    lvx v26, r1, r3 # 16-byte Folded Reload
; CHECK-NEXT:    li r3, 64
; CHECK-NEXT:    ld r17, 192(r1) # 8-byte Folded Reload
; CHECK-NEXT:    ld r16, 184(r1) # 8-byte Folded Reload
; CHECK-NEXT:    lvx v25, r1, r3 # 16-byte Folded Reload
; CHECK-NEXT:    li r3, 48
; CHECK-NEXT:    lvx v24, r1, r3 # 16-byte Folded Reload
; CHECK-NEXT:    addi r1, r1, 432
; CHECK-NEXT:    ld r0, 16(r1)
; CHECK-NEXT:    mtlr r0
; CHECK-NEXT:    blr
;
; FAST-LABEL: lrint_v16i64_v16f16:
; FAST:       # %bb.0:
; FAST-NEXT:    mflr r0
; FAST-NEXT:    .cfi_def_cfa_offset 160
; FAST-NEXT:    .cfi_offset lr, 16
; FAST-NEXT:    .cfi_offset f16, -128
; FAST-NEXT:    .cfi_offset f17, -120
; FAST-NEXT:    .cfi_offset f18, -112
; FAST-NEXT:    .cfi_offset f19, -104
; FAST-NEXT:    .cfi_offset f20, -96
; FAST-NEXT:    .cfi_offset f21, -88
; FAST-NEXT:    .cfi_offset f22, -80
; FAST-NEXT:    .cfi_offset f23, -72
; FAST-NEXT:    .cfi_offset f24, -64
; FAST-NEXT:    .cfi_offset f25, -56
; FAST-NEXT:    .cfi_offset f26, -48
; FAST-NEXT:    .cfi_offset f27, -40
; FAST-NEXT:    .cfi_offset f28, -32
; FAST-NEXT:    .cfi_offset f29, -24
; FAST-NEXT:    .cfi_offset f30, -16
; FAST-NEXT:    .cfi_offset f31, -8
; FAST-NEXT:    stfd f16, -128(r1) # 8-byte Folded Spill
; FAST-NEXT:    stfd f17, -120(r1) # 8-byte Folded Spill
; FAST-NEXT:    stfd f18, -112(r1) # 8-byte Folded Spill
; FAST-NEXT:    stfd f19, -104(r1) # 8-byte Folded Spill
; FAST-NEXT:    stfd f20, -96(r1) # 8-byte Folded Spill
; FAST-NEXT:    stfd f21, -88(r1) # 8-byte Folded Spill
; FAST-NEXT:    stfd f22, -80(r1) # 8-byte Folded Spill
; FAST-NEXT:    stfd f23, -72(r1) # 8-byte Folded Spill
; FAST-NEXT:    stfd f24, -64(r1) # 8-byte Folded Spill
; FAST-NEXT:    stfd f25, -56(r1) # 8-byte Folded Spill
; FAST-NEXT:    stfd f26, -48(r1) # 8-byte Folded Spill
; FAST-NEXT:    stfd f27, -40(r1) # 8-byte Folded Spill
; FAST-NEXT:    stfd f28, -32(r1) # 8-byte Folded Spill
; FAST-NEXT:    stfd f29, -24(r1) # 8-byte Folded Spill
; FAST-NEXT:    stfd f30, -16(r1) # 8-byte Folded Spill
; FAST-NEXT:    stfd f31, -8(r1) # 8-byte Folded Spill
; FAST-NEXT:    stdu r1, -160(r1)
; FAST-NEXT:    fmr f26, f1
; FAST-NEXT:    lfs f1, 312(r1)
; FAST-NEXT:    std r0, 176(r1)
; FAST-NEXT:    fmr f28, f13
; FAST-NEXT:    fmr f27, f12
; FAST-NEXT:    fmr f24, f11
; FAST-NEXT:    fmr f21, f10
; FAST-NEXT:    fmr f19, f9
; FAST-NEXT:    fmr f18, f8
; FAST-NEXT:    fmr f17, f7
; FAST-NEXT:    fmr f16, f6
; FAST-NEXT:    fmr f20, f5
; FAST-NEXT:    fmr f22, f4
; FAST-NEXT:    fmr f23, f3
; FAST-NEXT:    fmr f25, f2
; FAST-NEXT:    bl __gnu_f2h_ieee
; FAST-NEXT:    nop
; FAST-NEXT:    clrldi r3, r3, 48
; FAST-NEXT:    bl __gnu_h2f_ieee
; FAST-NEXT:    nop
; FAST-NEXT:    fmr f31, f1
; FAST-NEXT:    lfs f1, 304(r1)
; FAST-NEXT:    bl __gnu_f2h_ieee
; FAST-NEXT:    nop
; FAST-NEXT:    clrldi r3, r3, 48
; FAST-NEXT:    bl __gnu_h2f_ieee
; FAST-NEXT:    nop
; FAST-NEXT:    fmr f30, f1
; FAST-NEXT:    lfs f1, 296(r1)
; FAST-NEXT:    bl __gnu_f2h_ieee
; FAST-NEXT:    nop
; FAST-NEXT:    clrldi r3, r3, 48
; FAST-NEXT:    bl __gnu_h2f_ieee
; FAST-NEXT:    nop
; FAST-NEXT:    fmr f29, f1
; FAST-NEXT:    fmr f1, f28
; FAST-NEXT:    bl __gnu_f2h_ieee
; FAST-NEXT:    nop
; FAST-NEXT:    clrldi r3, r3, 48
; FAST-NEXT:    bl __gnu_h2f_ieee
; FAST-NEXT:    nop
; FAST-NEXT:    fmr f28, f1
; FAST-NEXT:    fmr f1, f27
; FAST-NEXT:    bl __gnu_f2h_ieee
; FAST-NEXT:    nop
; FAST-NEXT:    clrldi r3, r3, 48
; FAST-NEXT:    bl __gnu_h2f_ieee
; FAST-NEXT:    nop
; FAST-NEXT:    fmr f27, f1
; FAST-NEXT:    fmr f1, f24
; FAST-NEXT:    bl __gnu_f2h_ieee
; FAST-NEXT:    nop
; FAST-NEXT:    clrldi r3, r3, 48
; FAST-NEXT:    bl __gnu_h2f_ieee
; FAST-NEXT:    nop
; FAST-NEXT:    fmr f24, f1
; FAST-NEXT:    fmr f1, f21
; FAST-NEXT:    bl __gnu_f2h_ieee
; FAST-NEXT:    nop
; FAST-NEXT:    clrldi r3, r3, 48
; FAST-NEXT:    bl __gnu_h2f_ieee
; FAST-NEXT:    nop
; FAST-NEXT:    fmr f21, f1
; FAST-NEXT:    fmr f1, f19
; FAST-NEXT:    bl __gnu_f2h_ieee
; FAST-NEXT:    nop
; FAST-NEXT:    clrldi r3, r3, 48
; FAST-NEXT:    bl __gnu_h2f_ieee
; FAST-NEXT:    nop
; FAST-NEXT:    fmr f19, f1
; FAST-NEXT:    fmr f1, f18
; FAST-NEXT:    bl __gnu_f2h_ieee
; FAST-NEXT:    nop
; FAST-NEXT:    clrldi r3, r3, 48
; FAST-NEXT:    bl __gnu_h2f_ieee
; FAST-NEXT:    nop
; FAST-NEXT:    fmr f18, f1
; FAST-NEXT:    fmr f1, f17
; FAST-NEXT:    bl __gnu_f2h_ieee
; FAST-NEXT:    nop
; FAST-NEXT:    clrldi r3, r3, 48
; FAST-NEXT:    bl __gnu_h2f_ieee
; FAST-NEXT:    nop
; FAST-NEXT:    fmr f17, f1
; FAST-NEXT:    fmr f1, f16
; FAST-NEXT:    bl __gnu_f2h_ieee
; FAST-NEXT:    nop
; FAST-NEXT:    clrldi r3, r3, 48
; FAST-NEXT:    bl __gnu_h2f_ieee
; FAST-NEXT:    nop
; FAST-NEXT:    fmr f16, f1
; FAST-NEXT:    fmr f1, f20
; FAST-NEXT:    bl __gnu_f2h_ieee
; FAST-NEXT:    nop
; FAST-NEXT:    clrldi r3, r3, 48
; FAST-NEXT:    bl __gnu_h2f_ieee
; FAST-NEXT:    nop
; FAST-NEXT:    fmr f20, f1
; FAST-NEXT:    fmr f1, f22
; FAST-NEXT:    bl __gnu_f2h_ieee
; FAST-NEXT:    nop
; FAST-NEXT:    clrldi r3, r3, 48
; FAST-NEXT:    bl __gnu_h2f_ieee
; FAST-NEXT:    nop
; FAST-NEXT:    fmr f22, f1
; FAST-NEXT:    fmr f1, f23
; FAST-NEXT:    bl __gnu_f2h_ieee
; FAST-NEXT:    nop
; FAST-NEXT:    clrldi r3, r3, 48
; FAST-NEXT:    bl __gnu_h2f_ieee
; FAST-NEXT:    nop
; FAST-NEXT:    fmr f23, f1
; FAST-NEXT:    fmr f1, f25
; FAST-NEXT:    bl __gnu_f2h_ieee
; FAST-NEXT:    nop
; FAST-NEXT:    clrldi r3, r3, 48
; FAST-NEXT:    bl __gnu_h2f_ieee
; FAST-NEXT:    nop
; FAST-NEXT:    fmr f25, f1
; FAST-NEXT:    fmr f1, f26
; FAST-NEXT:    bl __gnu_f2h_ieee
; FAST-NEXT:    nop
; FAST-NEXT:    clrldi r3, r3, 48
; FAST-NEXT:    bl __gnu_h2f_ieee
; FAST-NEXT:    nop
; FAST-NEXT:    fctid f0, f25
; FAST-NEXT:    fctid f2, f23
; FAST-NEXT:    mffprd r3, f0
; FAST-NEXT:    fctid f3, f22
; FAST-NEXT:    fctid f4, f20
; FAST-NEXT:    fctid f5, f16
; FAST-NEXT:    fctid f6, f17
; FAST-NEXT:    fctid f7, f18
; FAST-NEXT:    fctid f8, f19
; FAST-NEXT:    fctid f9, f21
; FAST-NEXT:    fctid f10, f24
; FAST-NEXT:    fctid f1, f1
; FAST-NEXT:    mtfprd f0, r3
; FAST-NEXT:    mffprd r3, f2
; FAST-NEXT:    mtfprd f2, r3
; FAST-NEXT:    mffprd r3, f3
; FAST-NEXT:    mtfprd f3, r3
; FAST-NEXT:    mffprd r3, f4
; FAST-NEXT:    mtfprd f4, r3
; FAST-NEXT:    mffprd r3, f5
; FAST-NEXT:    mtfprd f5, r3
; FAST-NEXT:    mffprd r3, f6
; FAST-NEXT:    mtfprd f6, r3
; FAST-NEXT:    mffprd r3, f7
; FAST-NEXT:    mtfprd f7, r3
; FAST-NEXT:    mffprd r3, f8
; FAST-NEXT:    mtfprd f8, r3
; FAST-NEXT:    mffprd r3, f9
; FAST-NEXT:    mtfprd f9, r3
; FAST-NEXT:    mffprd r3, f10
; FAST-NEXT:    mtfprd f10, r3
; FAST-NEXT:    mffprd r3, f1
; FAST-NEXT:    mtfprd f1, r3
; FAST-NEXT:    xxmrghd v3, vs3, vs2
; FAST-NEXT:    xxmrghd v4, vs5, vs4
; FAST-NEXT:    xxmrghd v5, vs7, vs6
; FAST-NEXT:    xxmrghd v6, vs9, vs8
; FAST-NEXT:    xxmrghd v2, vs0, vs1
; FAST-NEXT:    fctid f0, f27
; FAST-NEXT:    fctid f1, f29
; FAST-NEXT:    mffprd r3, f0
; FAST-NEXT:    mtfprd f0, r3
; FAST-NEXT:    xxmrghd v7, vs0, vs10
; FAST-NEXT:    fctid f0, f28
; FAST-NEXT:    mffprd r3, f0
; FAST-NEXT:    mtfprd f0, r3
; FAST-NEXT:    mffprd r3, f1
; FAST-NEXT:    mtfprd f1, r3
; FAST-NEXT:    xxmrghd v8, vs1, vs0
; FAST-NEXT:    fctid f0, f30
; FAST-NEXT:    fctid f1, f31
; FAST-NEXT:    mffprd r3, f0
; FAST-NEXT:    mtfprd f0, r3
; FAST-NEXT:    mffprd r3, f1
; FAST-NEXT:    mtfprd f1, r3
; FAST-NEXT:    xxmrghd v9, vs1, vs0
; FAST-NEXT:    addi r1, r1, 160
; FAST-NEXT:    ld r0, 16(r1)
; FAST-NEXT:    lfd f31, -8(r1) # 8-byte Folded Reload
; FAST-NEXT:    lfd f30, -16(r1) # 8-byte Folded Reload
; FAST-NEXT:    mtlr r0
; FAST-NEXT:    lfd f29, -24(r1) # 8-byte Folded Reload
; FAST-NEXT:    lfd f28, -32(r1) # 8-byte Folded Reload
; FAST-NEXT:    lfd f27, -40(r1) # 8-byte Folded Reload
; FAST-NEXT:    lfd f26, -48(r1) # 8-byte Folded Reload
; FAST-NEXT:    lfd f25, -56(r1) # 8-byte Folded Reload
; FAST-NEXT:    lfd f24, -64(r1) # 8-byte Folded Reload
; FAST-NEXT:    lfd f23, -72(r1) # 8-byte Folded Reload
; FAST-NEXT:    lfd f22, -80(r1) # 8-byte Folded Reload
; FAST-NEXT:    lfd f21, -88(r1) # 8-byte Folded Reload
; FAST-NEXT:    lfd f20, -96(r1) # 8-byte Folded Reload
; FAST-NEXT:    lfd f19, -104(r1) # 8-byte Folded Reload
; FAST-NEXT:    lfd f18, -112(r1) # 8-byte Folded Reload
; FAST-NEXT:    lfd f17, -120(r1) # 8-byte Folded Reload
; FAST-NEXT:    lfd f16, -128(r1) # 8-byte Folded Reload
; FAST-NEXT:    blr
  %a = call <16 x i64> @llvm.lrint.v16i64.v16f16(<16 x half> %x)
  ret <16 x i64> %a
}
declare <16 x i64> @llvm.lrint.v16i64.v16f16(<16 x half>)

define <32 x i64> @lrint_v32i64_v32f16(<32 x half> %x) {
; BE-LABEL: lrint_v32i64_v32f16:
; BE:       # %bb.0:
; BE-NEXT:    mflr r0
; BE-NEXT:    stdu r1, -864(r1)
; BE-NEXT:    std r0, 880(r1)
; BE-NEXT:    .cfi_def_cfa_offset 864
; BE-NEXT:    .cfi_offset lr, 16
; BE-NEXT:    .cfi_offset r14, -288
; BE-NEXT:    .cfi_offset r15, -280
; BE-NEXT:    .cfi_offset r16, -272
; BE-NEXT:    .cfi_offset r17, -264
; BE-NEXT:    .cfi_offset r18, -256
; BE-NEXT:    .cfi_offset r19, -248
; BE-NEXT:    .cfi_offset r20, -240
; BE-NEXT:    .cfi_offset r21, -232
; BE-NEXT:    .cfi_offset r22, -224
; BE-NEXT:    .cfi_offset r23, -216
; BE-NEXT:    .cfi_offset r24, -208
; BE-NEXT:    .cfi_offset r25, -200
; BE-NEXT:    .cfi_offset r26, -192
; BE-NEXT:    .cfi_offset r27, -184
; BE-NEXT:    .cfi_offset r28, -176
; BE-NEXT:    .cfi_offset r29, -168
; BE-NEXT:    .cfi_offset r30, -160
; BE-NEXT:    .cfi_offset r31, -152
; BE-NEXT:    .cfi_offset f14, -144
; BE-NEXT:    .cfi_offset f15, -136
; BE-NEXT:    .cfi_offset f16, -128
; BE-NEXT:    .cfi_offset f17, -120
; BE-NEXT:    .cfi_offset f18, -112
; BE-NEXT:    .cfi_offset f19, -104
; BE-NEXT:    .cfi_offset f20, -96
; BE-NEXT:    .cfi_offset f21, -88
; BE-NEXT:    .cfi_offset f22, -80
; BE-NEXT:    .cfi_offset f23, -72
; BE-NEXT:    .cfi_offset f24, -64
; BE-NEXT:    .cfi_offset f25, -56
; BE-NEXT:    .cfi_offset f26, -48
; BE-NEXT:    .cfi_offset f27, -40
; BE-NEXT:    .cfi_offset f28, -32
; BE-NEXT:    .cfi_offset f29, -24
; BE-NEXT:    .cfi_offset f30, -16
; BE-NEXT:    .cfi_offset f31, -8
; BE-NEXT:    stfd f20, 768(r1) # 8-byte Folded Spill
; BE-NEXT:    fmr f20, f1
; BE-NEXT:    fmr f1, f2
; BE-NEXT:    std r14, 576(r1) # 8-byte Folded Spill
; BE-NEXT:    std r15, 584(r1) # 8-byte Folded Spill
; BE-NEXT:    std r16, 592(r1) # 8-byte Folded Spill
; BE-NEXT:    std r17, 600(r1) # 8-byte Folded Spill
; BE-NEXT:    std r18, 608(r1) # 8-byte Folded Spill
; BE-NEXT:    std r19, 616(r1) # 8-byte Folded Spill
; BE-NEXT:    std r20, 624(r1) # 8-byte Folded Spill
; BE-NEXT:    std r21, 632(r1) # 8-byte Folded Spill
; BE-NEXT:    std r22, 640(r1) # 8-byte Folded Spill
; BE-NEXT:    std r23, 648(r1) # 8-byte Folded Spill
; BE-NEXT:    std r24, 656(r1) # 8-byte Folded Spill
; BE-NEXT:    std r25, 664(r1) # 8-byte Folded Spill
; BE-NEXT:    std r26, 672(r1) # 8-byte Folded Spill
; BE-NEXT:    std r27, 680(r1) # 8-byte Folded Spill
; BE-NEXT:    std r28, 688(r1) # 8-byte Folded Spill
; BE-NEXT:    std r29, 696(r1) # 8-byte Folded Spill
; BE-NEXT:    std r30, 704(r1) # 8-byte Folded Spill
; BE-NEXT:    std r31, 712(r1) # 8-byte Folded Spill
; BE-NEXT:    stfd f14, 720(r1) # 8-byte Folded Spill
; BE-NEXT:    stfd f15, 728(r1) # 8-byte Folded Spill
; BE-NEXT:    stfd f16, 736(r1) # 8-byte Folded Spill
; BE-NEXT:    stfd f17, 744(r1) # 8-byte Folded Spill
; BE-NEXT:    stfd f18, 752(r1) # 8-byte Folded Spill
; BE-NEXT:    stfd f19, 760(r1) # 8-byte Folded Spill
; BE-NEXT:    stfd f21, 776(r1) # 8-byte Folded Spill
; BE-NEXT:    stfd f22, 784(r1) # 8-byte Folded Spill
; BE-NEXT:    stfd f23, 792(r1) # 8-byte Folded Spill
; BE-NEXT:    stfd f24, 800(r1) # 8-byte Folded Spill
; BE-NEXT:    stfd f25, 808(r1) # 8-byte Folded Spill
; BE-NEXT:    stfd f26, 816(r1) # 8-byte Folded Spill
; BE-NEXT:    stfd f27, 824(r1) # 8-byte Folded Spill
; BE-NEXT:    stfd f28, 832(r1) # 8-byte Folded Spill
; BE-NEXT:    stfd f29, 840(r1) # 8-byte Folded Spill
; BE-NEXT:    stfd f30, 848(r1) # 8-byte Folded Spill
; BE-NEXT:    stfd f31, 856(r1) # 8-byte Folded Spill
; BE-NEXT:    fmr f31, f13
; BE-NEXT:    fmr f29, f12
; BE-NEXT:    fmr f30, f11
; BE-NEXT:    fmr f28, f10
; BE-NEXT:    fmr f27, f9
; BE-NEXT:    fmr f26, f8
; BE-NEXT:    fmr f25, f7
; BE-NEXT:    fmr f24, f6
; BE-NEXT:    fmr f23, f5
; BE-NEXT:    fmr f22, f4
; BE-NEXT:    fmr f21, f3
; BE-NEXT:    mr r30, r3
; BE-NEXT:    bl __gnu_f2h_ieee
; BE-NEXT:    nop
; BE-NEXT:    fmr f1, f20
; BE-NEXT:    std r3, 304(r1) # 8-byte Folded Spill
; BE-NEXT:    bl __gnu_f2h_ieee
; BE-NEXT:    nop
; BE-NEXT:    fmr f1, f22
; BE-NEXT:    std r3, 296(r1) # 8-byte Folded Spill
; BE-NEXT:    bl __gnu_f2h_ieee
; BE-NEXT:    nop
; BE-NEXT:    fmr f1, f21
; BE-NEXT:    std r3, 280(r1) # 8-byte Folded Spill
; BE-NEXT:    bl __gnu_f2h_ieee
; BE-NEXT:    nop
; BE-NEXT:    fmr f1, f24
; BE-NEXT:    std r3, 264(r1) # 8-byte Folded Spill
; BE-NEXT:    bl __gnu_f2h_ieee
; BE-NEXT:    nop
; BE-NEXT:    fmr f1, f23
; BE-NEXT:    std r3, 248(r1) # 8-byte Folded Spill
; BE-NEXT:    bl __gnu_f2h_ieee
; BE-NEXT:    nop
; BE-NEXT:    fmr f1, f26
; BE-NEXT:    std r3, 232(r1) # 8-byte Folded Spill
; BE-NEXT:    bl __gnu_f2h_ieee
; BE-NEXT:    nop
; BE-NEXT:    fmr f1, f25
; BE-NEXT:    std r3, 216(r1) # 8-byte Folded Spill
; BE-NEXT:    bl __gnu_f2h_ieee
; BE-NEXT:    nop
; BE-NEXT:    fmr f1, f28
; BE-NEXT:    std r3, 200(r1) # 8-byte Folded Spill
; BE-NEXT:    bl __gnu_f2h_ieee
; BE-NEXT:    nop
; BE-NEXT:    fmr f1, f27
; BE-NEXT:    std r3, 184(r1) # 8-byte Folded Spill
; BE-NEXT:    bl __gnu_f2h_ieee
; BE-NEXT:    nop
; BE-NEXT:    fmr f1, f29
; BE-NEXT:    std r3, 168(r1) # 8-byte Folded Spill
; BE-NEXT:    bl __gnu_f2h_ieee
; BE-NEXT:    nop
; BE-NEXT:    fmr f1, f30
; BE-NEXT:    std r3, 152(r1) # 8-byte Folded Spill
; BE-NEXT:    bl __gnu_f2h_ieee
; BE-NEXT:    nop
; BE-NEXT:    lfs f1, 1028(r1)
; BE-NEXT:    std r3, 136(r1) # 8-byte Folded Spill
; BE-NEXT:    bl __gnu_f2h_ieee
; BE-NEXT:    nop
; BE-NEXT:    fmr f1, f31
; BE-NEXT:    std r3, 120(r1) # 8-byte Folded Spill
; BE-NEXT:    bl __gnu_f2h_ieee
; BE-NEXT:    nop
; BE-NEXT:    lfs f1, 1044(r1)
; BE-NEXT:    std r3, 112(r1) # 8-byte Folded Spill
; BE-NEXT:    bl __gnu_f2h_ieee
; BE-NEXT:    nop
; BE-NEXT:    lfs f1, 1036(r1)
; BE-NEXT:    mr r15, r3
; BE-NEXT:    bl __gnu_f2h_ieee
; BE-NEXT:    nop
; BE-NEXT:    lfs f1, 1060(r1)
; BE-NEXT:    mr r14, r3
; BE-NEXT:    bl __gnu_f2h_ieee
; BE-NEXT:    nop
; BE-NEXT:    lfs f1, 1052(r1)
; BE-NEXT:    mr r31, r3
; BE-NEXT:    bl __gnu_f2h_ieee
; BE-NEXT:    nop
; BE-NEXT:    lfs f1, 1076(r1)
; BE-NEXT:    mr r29, r3
; BE-NEXT:    bl __gnu_f2h_ieee
; BE-NEXT:    nop
; BE-NEXT:    lfs f1, 1068(r1)
; BE-NEXT:    mr r28, r3
; BE-NEXT:    bl __gnu_f2h_ieee
; BE-NEXT:    nop
; BE-NEXT:    lfs f1, 1092(r1)
; BE-NEXT:    mr r27, r3
; BE-NEXT:    bl __gnu_f2h_ieee
; BE-NEXT:    nop
; BE-NEXT:    lfs f1, 1084(r1)
; BE-NEXT:    mr r26, r3
; BE-NEXT:    bl __gnu_f2h_ieee
; BE-NEXT:    nop
; BE-NEXT:    lfs f1, 1108(r1)
; BE-NEXT:    mr r25, r3
; BE-NEXT:    bl __gnu_f2h_ieee
; BE-NEXT:    nop
; BE-NEXT:    lfs f1, 1100(r1)
; BE-NEXT:    mr r24, r3
; BE-NEXT:    bl __gnu_f2h_ieee
; BE-NEXT:    nop
; BE-NEXT:    lfs f1, 1124(r1)
; BE-NEXT:    mr r23, r3
; BE-NEXT:    bl __gnu_f2h_ieee
; BE-NEXT:    nop
; BE-NEXT:    lfs f1, 1116(r1)
; BE-NEXT:    mr r22, r3
; BE-NEXT:    bl __gnu_f2h_ieee
; BE-NEXT:    nop
; BE-NEXT:    lfs f1, 1140(r1)
; BE-NEXT:    mr r21, r3
; BE-NEXT:    bl __gnu_f2h_ieee
; BE-NEXT:    nop
; BE-NEXT:    lfs f1, 1132(r1)
; BE-NEXT:    mr r20, r3
; BE-NEXT:    bl __gnu_f2h_ieee
; BE-NEXT:    nop
; BE-NEXT:    lfs f1, 1156(r1)
; BE-NEXT:    mr r19, r3
; BE-NEXT:    bl __gnu_f2h_ieee
; BE-NEXT:    nop
; BE-NEXT:    lfs f1, 1148(r1)
; BE-NEXT:    mr r18, r3
; BE-NEXT:    bl __gnu_f2h_ieee
; BE-NEXT:    nop
; BE-NEXT:    lfs f1, 1172(r1)
; BE-NEXT:    mr r17, r3
; BE-NEXT:    bl __gnu_f2h_ieee
; BE-NEXT:    nop
; BE-NEXT:    lfs f1, 1164(r1)
; BE-NEXT:    mr r16, r3
; BE-NEXT:    bl __gnu_f2h_ieee
; BE-NEXT:    nop
; BE-NEXT:    clrldi r3, r3, 48
; BE-NEXT:    bl __gnu_h2f_ieee
; BE-NEXT:    nop
; BE-NEXT:    clrldi r3, r16, 48
; BE-NEXT:    stfs f1, 316(r1) # 4-byte Folded Spill
; BE-NEXT:    bl __gnu_h2f_ieee
; BE-NEXT:    nop
; BE-NEXT:    clrldi r3, r17, 48
; BE-NEXT:    stfs f1, 312(r1) # 4-byte Folded Spill
; BE-NEXT:    bl __gnu_h2f_ieee
; BE-NEXT:    nop
; BE-NEXT:    clrldi r3, r18, 48
; BE-NEXT:    stfs f1, 292(r1) # 4-byte Folded Spill
; BE-NEXT:    bl __gnu_h2f_ieee
; BE-NEXT:    nop
; BE-NEXT:    clrldi r3, r19, 48
; BE-NEXT:    stfs f1, 276(r1) # 4-byte Folded Spill
; BE-NEXT:    bl __gnu_h2f_ieee
; BE-NEXT:    nop
; BE-NEXT:    clrldi r3, r20, 48
; BE-NEXT:    stfs f1, 260(r1) # 4-byte Folded Spill
; BE-NEXT:    bl __gnu_h2f_ieee
; BE-NEXT:    nop
; BE-NEXT:    clrldi r3, r21, 48
; BE-NEXT:    stfs f1, 244(r1) # 4-byte Folded Spill
; BE-NEXT:    bl __gnu_h2f_ieee
; BE-NEXT:    nop
; BE-NEXT:    clrldi r3, r22, 48
; BE-NEXT:    stfs f1, 228(r1) # 4-byte Folded Spill
; BE-NEXT:    bl __gnu_h2f_ieee
; BE-NEXT:    nop
; BE-NEXT:    clrldi r3, r23, 48
; BE-NEXT:    stfs f1, 212(r1) # 4-byte Folded Spill
; BE-NEXT:    bl __gnu_h2f_ieee
; BE-NEXT:    nop
; BE-NEXT:    clrldi r3, r24, 48
; BE-NEXT:    stfs f1, 196(r1) # 4-byte Folded Spill
; BE-NEXT:    bl __gnu_h2f_ieee
; BE-NEXT:    nop
; BE-NEXT:    clrldi r3, r25, 48
; BE-NEXT:    stfs f1, 180(r1) # 4-byte Folded Spill
; BE-NEXT:    bl __gnu_h2f_ieee
; BE-NEXT:    nop
; BE-NEXT:    clrldi r3, r26, 48
; BE-NEXT:    stfs f1, 164(r1) # 4-byte Folded Spill
; BE-NEXT:    bl __gnu_h2f_ieee
; BE-NEXT:    nop
; BE-NEXT:    clrldi r3, r27, 48
; BE-NEXT:    stfs f1, 148(r1) # 4-byte Folded Spill
; BE-NEXT:    bl __gnu_h2f_ieee
; BE-NEXT:    nop
; BE-NEXT:    clrldi r3, r28, 48
; BE-NEXT:    stfs f1, 132(r1) # 4-byte Folded Spill
; BE-NEXT:    bl __gnu_h2f_ieee
; BE-NEXT:    nop
; BE-NEXT:    clrldi r3, r29, 48
; BE-NEXT:    fmr f18, f1
; BE-NEXT:    bl __gnu_h2f_ieee
; BE-NEXT:    nop
; BE-NEXT:    clrldi r3, r31, 48
; BE-NEXT:    fmr f17, f1
; BE-NEXT:    bl __gnu_h2f_ieee
; BE-NEXT:    nop
; BE-NEXT:    clrldi r3, r14, 48
; BE-NEXT:    fmr f16, f1
; BE-NEXT:    bl __gnu_h2f_ieee
; BE-NEXT:    nop
; BE-NEXT:    clrldi r3, r15, 48
; BE-NEXT:    fmr f15, f1
; BE-NEXT:    bl __gnu_h2f_ieee
; BE-NEXT:    nop
; BE-NEXT:    ld r3, 112(r1) # 8-byte Folded Reload
; BE-NEXT:    fmr f14, f1
; BE-NEXT:    clrldi r3, r3, 48
; BE-NEXT:    bl __gnu_h2f_ieee
; BE-NEXT:    nop
; BE-NEXT:    ld r3, 120(r1) # 8-byte Folded Reload
; BE-NEXT:    fmr f31, f1
; BE-NEXT:    clrldi r3, r3, 48
; BE-NEXT:    bl __gnu_h2f_ieee
; BE-NEXT:    nop
; BE-NEXT:    ld r3, 136(r1) # 8-byte Folded Reload
; BE-NEXT:    fmr f30, f1
; BE-NEXT:    clrldi r3, r3, 48
; BE-NEXT:    bl __gnu_h2f_ieee
; BE-NEXT:    nop
; BE-NEXT:    ld r3, 152(r1) # 8-byte Folded Reload
; BE-NEXT:    fmr f29, f1
; BE-NEXT:    clrldi r3, r3, 48
; BE-NEXT:    bl __gnu_h2f_ieee
; BE-NEXT:    nop
; BE-NEXT:    ld r3, 168(r1) # 8-byte Folded Reload
; BE-NEXT:    fmr f28, f1
; BE-NEXT:    clrldi r3, r3, 48
; BE-NEXT:    bl __gnu_h2f_ieee
; BE-NEXT:    nop
; BE-NEXT:    ld r3, 184(r1) # 8-byte Folded Reload
; BE-NEXT:    fmr f27, f1
; BE-NEXT:    clrldi r3, r3, 48
; BE-NEXT:    bl __gnu_h2f_ieee
; BE-NEXT:    nop
; BE-NEXT:    ld r3, 200(r1) # 8-byte Folded Reload
; BE-NEXT:    fmr f26, f1
; BE-NEXT:    clrldi r3, r3, 48
; BE-NEXT:    bl __gnu_h2f_ieee
; BE-NEXT:    nop
; BE-NEXT:    ld r3, 216(r1) # 8-byte Folded Reload
; BE-NEXT:    fmr f25, f1
; BE-NEXT:    clrldi r3, r3, 48
; BE-NEXT:    bl __gnu_h2f_ieee
; BE-NEXT:    nop
; BE-NEXT:    ld r3, 232(r1) # 8-byte Folded Reload
; BE-NEXT:    fmr f24, f1
; BE-NEXT:    clrldi r3, r3, 48
; BE-NEXT:    bl __gnu_h2f_ieee
; BE-NEXT:    nop
; BE-NEXT:    ld r3, 248(r1) # 8-byte Folded Reload
; BE-NEXT:    fmr f23, f1
; BE-NEXT:    clrldi r3, r3, 48
; BE-NEXT:    bl __gnu_h2f_ieee
; BE-NEXT:    nop
; BE-NEXT:    ld r3, 264(r1) # 8-byte Folded Reload
; BE-NEXT:    fmr f22, f1
; BE-NEXT:    clrldi r3, r3, 48
; BE-NEXT:    bl __gnu_h2f_ieee
; BE-NEXT:    nop
; BE-NEXT:    ld r3, 280(r1) # 8-byte Folded Reload
; BE-NEXT:    fmr f21, f1
; BE-NEXT:    clrldi r3, r3, 48
; BE-NEXT:    bl __gnu_h2f_ieee
; BE-NEXT:    nop
; BE-NEXT:    ld r3, 296(r1) # 8-byte Folded Reload
; BE-NEXT:    fmr f20, f1
; BE-NEXT:    clrldi r3, r3, 48
; BE-NEXT:    bl __gnu_h2f_ieee
; BE-NEXT:    nop
; BE-NEXT:    ld r3, 304(r1) # 8-byte Folded Reload
; BE-NEXT:    fmr f19, f1
; BE-NEXT:    clrldi r3, r3, 48
; BE-NEXT:    bl __gnu_h2f_ieee
; BE-NEXT:    nop
; BE-NEXT:    bl lrintf
; BE-NEXT:    nop
; BE-NEXT:    fmr f1, f19
; BE-NEXT:    std r3, 328(r1)
; BE-NEXT:    bl lrintf
; BE-NEXT:    nop
; BE-NEXT:    fmr f1, f20
; BE-NEXT:    std r3, 320(r1)
; BE-NEXT:    bl lrintf
; BE-NEXT:    nop
; BE-NEXT:    fmr f1, f21
; BE-NEXT:    std r3, 344(r1)
; BE-NEXT:    bl lrintf
; BE-NEXT:    nop
; BE-NEXT:    fmr f1, f22
; BE-NEXT:    std r3, 336(r1)
; BE-NEXT:    bl lrintf
; BE-NEXT:    nop
; BE-NEXT:    fmr f1, f23
; BE-NEXT:    std r3, 360(r1)
; BE-NEXT:    bl lrintf
; BE-NEXT:    nop
; BE-NEXT:    fmr f1, f24
; BE-NEXT:    std r3, 352(r1)
; BE-NEXT:    bl lrintf
; BE-NEXT:    nop
; BE-NEXT:    fmr f1, f25
; BE-NEXT:    std r3, 376(r1)
; BE-NEXT:    bl lrintf
; BE-NEXT:    nop
; BE-NEXT:    fmr f1, f26
; BE-NEXT:    std r3, 368(r1)
; BE-NEXT:    bl lrintf
; BE-NEXT:    nop
; BE-NEXT:    fmr f1, f27
; BE-NEXT:    std r3, 392(r1)
; BE-NEXT:    bl lrintf
; BE-NEXT:    nop
; BE-NEXT:    fmr f1, f28
; BE-NEXT:    std r3, 384(r1)
; BE-NEXT:    bl lrintf
; BE-NEXT:    nop
; BE-NEXT:    fmr f1, f29
; BE-NEXT:    std r3, 408(r1)
; BE-NEXT:    bl lrintf
; BE-NEXT:    nop
; BE-NEXT:    fmr f1, f30
; BE-NEXT:    std r3, 400(r1)
; BE-NEXT:    bl lrintf
; BE-NEXT:    nop
; BE-NEXT:    fmr f1, f31
; BE-NEXT:    std r3, 424(r1)
; BE-NEXT:    bl lrintf
; BE-NEXT:    nop
; BE-NEXT:    fmr f1, f14
; BE-NEXT:    std r3, 416(r1)
; BE-NEXT:    bl lrintf
; BE-NEXT:    nop
; BE-NEXT:    fmr f1, f15
; BE-NEXT:    std r3, 440(r1)
; BE-NEXT:    bl lrintf
; BE-NEXT:    nop
; BE-NEXT:    fmr f1, f16
; BE-NEXT:    std r3, 432(r1)
; BE-NEXT:    bl lrintf
; BE-NEXT:    nop
; BE-NEXT:    fmr f1, f17
; BE-NEXT:    std r3, 456(r1)
; BE-NEXT:    bl lrintf
; BE-NEXT:    nop
; BE-NEXT:    fmr f1, f18
; BE-NEXT:    std r3, 448(r1)
; BE-NEXT:    bl lrintf
; BE-NEXT:    nop
; BE-NEXT:    lfs f1, 132(r1) # 4-byte Folded Reload
; BE-NEXT:    std r3, 472(r1)
; BE-NEXT:    bl lrintf
; BE-NEXT:    nop
; BE-NEXT:    lfs f1, 148(r1) # 4-byte Folded Reload
; BE-NEXT:    std r3, 464(r1)
; BE-NEXT:    bl lrintf
; BE-NEXT:    nop
; BE-NEXT:    lfs f1, 164(r1) # 4-byte Folded Reload
; BE-NEXT:    std r3, 488(r1)
; BE-NEXT:    bl lrintf
; BE-NEXT:    nop
; BE-NEXT:    lfs f1, 180(r1) # 4-byte Folded Reload
; BE-NEXT:    std r3, 480(r1)
; BE-NEXT:    bl lrintf
; BE-NEXT:    nop
; BE-NEXT:    lfs f1, 196(r1) # 4-byte Folded Reload
; BE-NEXT:    std r3, 504(r1)
; BE-NEXT:    bl lrintf
; BE-NEXT:    nop
; BE-NEXT:    lfs f1, 212(r1) # 4-byte Folded Reload
; BE-NEXT:    std r3, 496(r1)
; BE-NEXT:    bl lrintf
; BE-NEXT:    nop
; BE-NEXT:    lfs f1, 228(r1) # 4-byte Folded Reload
; BE-NEXT:    std r3, 520(r1)
; BE-NEXT:    bl lrintf
; BE-NEXT:    nop
; BE-NEXT:    lfs f1, 244(r1) # 4-byte Folded Reload
; BE-NEXT:    std r3, 512(r1)
; BE-NEXT:    bl lrintf
; BE-NEXT:    nop
; BE-NEXT:    lfs f1, 260(r1) # 4-byte Folded Reload
; BE-NEXT:    std r3, 536(r1)
; BE-NEXT:    bl lrintf
; BE-NEXT:    nop
; BE-NEXT:    lfs f1, 276(r1) # 4-byte Folded Reload
; BE-NEXT:    std r3, 528(r1)
; BE-NEXT:    bl lrintf
; BE-NEXT:    nop
; BE-NEXT:    lfs f1, 292(r1) # 4-byte Folded Reload
; BE-NEXT:    std r3, 552(r1)
; BE-NEXT:    bl lrintf
; BE-NEXT:    nop
; BE-NEXT:    lfs f1, 312(r1) # 4-byte Folded Reload
; BE-NEXT:    std r3, 544(r1)
; BE-NEXT:    bl lrintf
; BE-NEXT:    nop
; BE-NEXT:    lfs f1, 316(r1) # 4-byte Folded Reload
; BE-NEXT:    std r3, 568(r1)
; BE-NEXT:    bl lrintf
; BE-NEXT:    nop
; BE-NEXT:    std r3, 560(r1)
; BE-NEXT:    addi r3, r1, 320
; BE-NEXT:    lxvd2x vs0, 0, r3
; BE-NEXT:    addi r3, r1, 336
; BE-NEXT:    lxvd2x vs1, 0, r3
; BE-NEXT:    addi r3, r1, 352
; BE-NEXT:    lxvd2x vs2, 0, r3
; BE-NEXT:    addi r3, r1, 368
; BE-NEXT:    lxvd2x vs3, 0, r3
; BE-NEXT:    addi r3, r1, 384
; BE-NEXT:    lxvd2x vs4, 0, r3
; BE-NEXT:    addi r3, r1, 400
; BE-NEXT:    lxvd2x vs5, 0, r3
; BE-NEXT:    addi r3, r1, 416
; BE-NEXT:    lxvd2x vs6, 0, r3
; BE-NEXT:    addi r3, r1, 432
; BE-NEXT:    lxvd2x vs7, 0, r3
; BE-NEXT:    addi r3, r1, 448
; BE-NEXT:    lxvd2x vs8, 0, r3
; BE-NEXT:    addi r3, r1, 464
; BE-NEXT:    lxvd2x vs9, 0, r3
; BE-NEXT:    addi r3, r1, 480
; BE-NEXT:    lxvd2x vs10, 0, r3
; BE-NEXT:    addi r3, r1, 496
; BE-NEXT:    lxvd2x vs11, 0, r3
; BE-NEXT:    addi r3, r1, 512
; BE-NEXT:    lxvd2x vs12, 0, r3
; BE-NEXT:    addi r3, r1, 528
; BE-NEXT:    lxvd2x vs13, 0, r3
; BE-NEXT:    addi r3, r1, 544
; BE-NEXT:    lxvd2x v2, 0, r3
; BE-NEXT:    addi r3, r1, 560
; BE-NEXT:    lxvd2x v3, 0, r3
; BE-NEXT:    li r3, 240
; BE-NEXT:    stxvd2x v3, r30, r3
; BE-NEXT:    li r3, 224
; BE-NEXT:    stxvd2x v2, r30, r3
; BE-NEXT:    li r3, 208
; BE-NEXT:    stxvd2x vs13, r30, r3
; BE-NEXT:    li r3, 192
; BE-NEXT:    stxvd2x vs12, r30, r3
; BE-NEXT:    li r3, 176
; BE-NEXT:    stxvd2x vs11, r30, r3
; BE-NEXT:    li r3, 160
; BE-NEXT:    stxvd2x vs10, r30, r3
; BE-NEXT:    li r3, 144
; BE-NEXT:    stxvd2x vs9, r30, r3
; BE-NEXT:    li r3, 128
; BE-NEXT:    stxvd2x vs8, r30, r3
; BE-NEXT:    li r3, 112
; BE-NEXT:    stxvd2x vs7, r30, r3
; BE-NEXT:    li r3, 96
; BE-NEXT:    stxvd2x vs6, r30, r3
; BE-NEXT:    li r3, 80
; BE-NEXT:    stxvd2x vs5, r30, r3
; BE-NEXT:    li r3, 64
; BE-NEXT:    stxvd2x vs4, r30, r3
; BE-NEXT:    li r3, 48
; BE-NEXT:    stxvd2x vs3, r30, r3
; BE-NEXT:    li r3, 32
; BE-NEXT:    stxvd2x vs2, r30, r3
; BE-NEXT:    li r3, 16
; BE-NEXT:    stxvd2x vs1, r30, r3
; BE-NEXT:    stxvd2x vs0, 0, r30
; BE-NEXT:    lfd f31, 856(r1) # 8-byte Folded Reload
; BE-NEXT:    lfd f30, 848(r1) # 8-byte Folded Reload
; BE-NEXT:    lfd f29, 840(r1) # 8-byte Folded Reload
; BE-NEXT:    lfd f28, 832(r1) # 8-byte Folded Reload
; BE-NEXT:    lfd f27, 824(r1) # 8-byte Folded Reload
; BE-NEXT:    lfd f26, 816(r1) # 8-byte Folded Reload
; BE-NEXT:    lfd f25, 808(r1) # 8-byte Folded Reload
; BE-NEXT:    lfd f24, 800(r1) # 8-byte Folded Reload
; BE-NEXT:    lfd f23, 792(r1) # 8-byte Folded Reload
; BE-NEXT:    lfd f22, 784(r1) # 8-byte Folded Reload
; BE-NEXT:    lfd f21, 776(r1) # 8-byte Folded Reload
; BE-NEXT:    lfd f20, 768(r1) # 8-byte Folded Reload
; BE-NEXT:    lfd f19, 760(r1) # 8-byte Folded Reload
; BE-NEXT:    lfd f18, 752(r1) # 8-byte Folded Reload
; BE-NEXT:    lfd f17, 744(r1) # 8-byte Folded Reload
; BE-NEXT:    lfd f16, 736(r1) # 8-byte Folded Reload
; BE-NEXT:    lfd f15, 728(r1) # 8-byte Folded Reload
; BE-NEXT:    lfd f14, 720(r1) # 8-byte Folded Reload
; BE-NEXT:    ld r31, 712(r1) # 8-byte Folded Reload
; BE-NEXT:    ld r30, 704(r1) # 8-byte Folded Reload
; BE-NEXT:    ld r29, 696(r1) # 8-byte Folded Reload
; BE-NEXT:    ld r28, 688(r1) # 8-byte Folded Reload
; BE-NEXT:    ld r27, 680(r1) # 8-byte Folded Reload
; BE-NEXT:    ld r26, 672(r1) # 8-byte Folded Reload
; BE-NEXT:    ld r25, 664(r1) # 8-byte Folded Reload
; BE-NEXT:    ld r24, 656(r1) # 8-byte Folded Reload
; BE-NEXT:    ld r23, 648(r1) # 8-byte Folded Reload
; BE-NEXT:    ld r22, 640(r1) # 8-byte Folded Reload
; BE-NEXT:    ld r21, 632(r1) # 8-byte Folded Reload
; BE-NEXT:    ld r20, 624(r1) # 8-byte Folded Reload
; BE-NEXT:    ld r19, 616(r1) # 8-byte Folded Reload
; BE-NEXT:    ld r18, 608(r1) # 8-byte Folded Reload
; BE-NEXT:    ld r17, 600(r1) # 8-byte Folded Reload
; BE-NEXT:    ld r16, 592(r1) # 8-byte Folded Reload
; BE-NEXT:    ld r15, 584(r1) # 8-byte Folded Reload
; BE-NEXT:    ld r14, 576(r1) # 8-byte Folded Reload
; BE-NEXT:    addi r1, r1, 864
; BE-NEXT:    ld r0, 16(r1)
; BE-NEXT:    mtlr r0
; BE-NEXT:    blr
;
; CHECK-LABEL: lrint_v32i64_v32f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    mflr r0
; CHECK-NEXT:    stdu r1, -688(r1)
; CHECK-NEXT:    std r0, 704(r1)
; CHECK-NEXT:    .cfi_def_cfa_offset 688
; CHECK-NEXT:    .cfi_offset lr, 16
; CHECK-NEXT:    .cfi_offset r14, -288
; CHECK-NEXT:    .cfi_offset r15, -280
; CHECK-NEXT:    .cfi_offset r16, -272
; CHECK-NEXT:    .cfi_offset r17, -264
; CHECK-NEXT:    .cfi_offset r18, -256
; CHECK-NEXT:    .cfi_offset r19, -248
; CHECK-NEXT:    .cfi_offset r20, -240
; CHECK-NEXT:    .cfi_offset r21, -232
; CHECK-NEXT:    .cfi_offset r22, -224
; CHECK-NEXT:    .cfi_offset r23, -216
; CHECK-NEXT:    .cfi_offset r24, -208
; CHECK-NEXT:    .cfi_offset r25, -200
; CHECK-NEXT:    .cfi_offset r26, -192
; CHECK-NEXT:    .cfi_offset r27, -184
; CHECK-NEXT:    .cfi_offset r28, -176
; CHECK-NEXT:    .cfi_offset r29, -168
; CHECK-NEXT:    .cfi_offset r30, -160
; CHECK-NEXT:    .cfi_offset r31, -152
; CHECK-NEXT:    .cfi_offset f14, -144
; CHECK-NEXT:    .cfi_offset f15, -136
; CHECK-NEXT:    .cfi_offset f16, -128
; CHECK-NEXT:    .cfi_offset f17, -120
; CHECK-NEXT:    .cfi_offset f18, -112
; CHECK-NEXT:    .cfi_offset f19, -104
; CHECK-NEXT:    .cfi_offset f20, -96
; CHECK-NEXT:    .cfi_offset f21, -88
; CHECK-NEXT:    .cfi_offset f22, -80
; CHECK-NEXT:    .cfi_offset f23, -72
; CHECK-NEXT:    .cfi_offset f24, -64
; CHECK-NEXT:    .cfi_offset f25, -56
; CHECK-NEXT:    .cfi_offset f26, -48
; CHECK-NEXT:    .cfi_offset f27, -40
; CHECK-NEXT:    .cfi_offset f28, -32
; CHECK-NEXT:    .cfi_offset f29, -24
; CHECK-NEXT:    .cfi_offset f30, -16
; CHECK-NEXT:    .cfi_offset f31, -8
; CHECK-NEXT:    .cfi_offset v20, -480
; CHECK-NEXT:    .cfi_offset v21, -464
; CHECK-NEXT:    .cfi_offset v22, -448
; CHECK-NEXT:    .cfi_offset v23, -432
; CHECK-NEXT:    .cfi_offset v24, -416
; CHECK-NEXT:    .cfi_offset v25, -400
; CHECK-NEXT:    .cfi_offset v26, -384
; CHECK-NEXT:    .cfi_offset v27, -368
; CHECK-NEXT:    .cfi_offset v28, -352
; CHECK-NEXT:    .cfi_offset v29, -336
; CHECK-NEXT:    .cfi_offset v30, -320
; CHECK-NEXT:    .cfi_offset v31, -304
; CHECK-NEXT:    li r4, 208
; CHECK-NEXT:    std r14, 400(r1) # 8-byte Folded Spill
; CHECK-NEXT:    std r15, 408(r1) # 8-byte Folded Spill
; CHECK-NEXT:    std r16, 416(r1) # 8-byte Folded Spill
; CHECK-NEXT:    std r17, 424(r1) # 8-byte Folded Spill
; CHECK-NEXT:    std r18, 432(r1) # 8-byte Folded Spill
; CHECK-NEXT:    std r19, 440(r1) # 8-byte Folded Spill
; CHECK-NEXT:    std r20, 448(r1) # 8-byte Folded Spill
; CHECK-NEXT:    stvx v20, r1, r4 # 16-byte Folded Spill
; CHECK-NEXT:    li r4, 224
; CHECK-NEXT:    std r21, 456(r1) # 8-byte Folded Spill
; CHECK-NEXT:    std r22, 464(r1) # 8-byte Folded Spill
; CHECK-NEXT:    std r23, 472(r1) # 8-byte Folded Spill
; CHECK-NEXT:    std r24, 480(r1) # 8-byte Folded Spill
; CHECK-NEXT:    std r25, 488(r1) # 8-byte Folded Spill
; CHECK-NEXT:    std r26, 496(r1) # 8-byte Folded Spill
; CHECK-NEXT:    stvx v21, r1, r4 # 16-byte Folded Spill
; CHECK-NEXT:    li r4, 240
; CHECK-NEXT:    std r27, 504(r1) # 8-byte Folded Spill
; CHECK-NEXT:    std r28, 512(r1) # 8-byte Folded Spill
; CHECK-NEXT:    std r29, 520(r1) # 8-byte Folded Spill
; CHECK-NEXT:    std r30, 528(r1) # 8-byte Folded Spill
; CHECK-NEXT:    mr r30, r3
; CHECK-NEXT:    std r31, 536(r1) # 8-byte Folded Spill
; CHECK-NEXT:    stvx v22, r1, r4 # 16-byte Folded Spill
; CHECK-NEXT:    li r4, 256
; CHECK-NEXT:    stfd f14, 544(r1) # 8-byte Folded Spill
; CHECK-NEXT:    stfd f15, 552(r1) # 8-byte Folded Spill
; CHECK-NEXT:    stfd f16, 560(r1) # 8-byte Folded Spill
; CHECK-NEXT:    stfd f17, 568(r1) # 8-byte Folded Spill
; CHECK-NEXT:    stfd f18, 576(r1) # 8-byte Folded Spill
; CHECK-NEXT:    stfd f19, 584(r1) # 8-byte Folded Spill
; CHECK-NEXT:    stvx v23, r1, r4 # 16-byte Folded Spill
; CHECK-NEXT:    li r4, 272
; CHECK-NEXT:    stfd f20, 592(r1) # 8-byte Folded Spill
; CHECK-NEXT:    fmr f20, f2
; CHECK-NEXT:    stfd f21, 600(r1) # 8-byte Folded Spill
; CHECK-NEXT:    fmr f21, f3
; CHECK-NEXT:    stfd f22, 608(r1) # 8-byte Folded Spill
; CHECK-NEXT:    fmr f22, f4
; CHECK-NEXT:    stvx v24, r1, r4 # 16-byte Folded Spill
; CHECK-NEXT:    li r4, 288
; CHECK-NEXT:    stfd f23, 616(r1) # 8-byte Folded Spill
; CHECK-NEXT:    fmr f23, f5
; CHECK-NEXT:    stfd f24, 624(r1) # 8-byte Folded Spill
; CHECK-NEXT:    fmr f24, f6
; CHECK-NEXT:    stfd f25, 632(r1) # 8-byte Folded Spill
; CHECK-NEXT:    fmr f25, f7
; CHECK-NEXT:    stvx v25, r1, r4 # 16-byte Folded Spill
; CHECK-NEXT:    li r4, 304
; CHECK-NEXT:    stfd f26, 640(r1) # 8-byte Folded Spill
; CHECK-NEXT:    fmr f26, f8
; CHECK-NEXT:    stfd f27, 648(r1) # 8-byte Folded Spill
; CHECK-NEXT:    fmr f27, f9
; CHECK-NEXT:    stfd f28, 656(r1) # 8-byte Folded Spill
; CHECK-NEXT:    fmr f28, f10
; CHECK-NEXT:    stvx v26, r1, r4 # 16-byte Folded Spill
; CHECK-NEXT:    li r4, 320
; CHECK-NEXT:    stfd f29, 664(r1) # 8-byte Folded Spill
; CHECK-NEXT:    fmr f29, f11
; CHECK-NEXT:    stfd f30, 672(r1) # 8-byte Folded Spill
; CHECK-NEXT:    fmr f30, f12
; CHECK-NEXT:    stfd f31, 680(r1) # 8-byte Folded Spill
; CHECK-NEXT:    fmr f31, f13
; CHECK-NEXT:    stvx v27, r1, r4 # 16-byte Folded Spill
; CHECK-NEXT:    li r4, 336
; CHECK-NEXT:    stvx v28, r1, r4 # 16-byte Folded Spill
; CHECK-NEXT:    li r4, 352
; CHECK-NEXT:    stvx v29, r1, r4 # 16-byte Folded Spill
; CHECK-NEXT:    li r4, 368
; CHECK-NEXT:    stvx v30, r1, r4 # 16-byte Folded Spill
; CHECK-NEXT:    li r4, 384
; CHECK-NEXT:    stvx v31, r1, r4 # 16-byte Folded Spill
; CHECK-NEXT:    bl __gnu_f2h_ieee
; CHECK-NEXT:    nop
; CHECK-NEXT:    fmr f1, f20
; CHECK-NEXT:    std r3, 176(r1) # 8-byte Folded Spill
; CHECK-NEXT:    bl __gnu_f2h_ieee
; CHECK-NEXT:    nop
; CHECK-NEXT:    fmr f1, f21
; CHECK-NEXT:    std r3, 160(r1) # 8-byte Folded Spill
; CHECK-NEXT:    bl __gnu_f2h_ieee
; CHECK-NEXT:    nop
; CHECK-NEXT:    fmr f1, f22
; CHECK-NEXT:    std r3, 144(r1) # 8-byte Folded Spill
; CHECK-NEXT:    bl __gnu_f2h_ieee
; CHECK-NEXT:    nop
; CHECK-NEXT:    fmr f1, f23
; CHECK-NEXT:    std r3, 128(r1) # 8-byte Folded Spill
; CHECK-NEXT:    bl __gnu_f2h_ieee
; CHECK-NEXT:    nop
; CHECK-NEXT:    fmr f1, f24
; CHECK-NEXT:    std r3, 120(r1) # 8-byte Folded Spill
; CHECK-NEXT:    bl __gnu_f2h_ieee
; CHECK-NEXT:    nop
; CHECK-NEXT:    fmr f1, f25
; CHECK-NEXT:    std r3, 112(r1) # 8-byte Folded Spill
; CHECK-NEXT:    bl __gnu_f2h_ieee
; CHECK-NEXT:    nop
; CHECK-NEXT:    fmr f1, f26
; CHECK-NEXT:    std r3, 104(r1) # 8-byte Folded Spill
; CHECK-NEXT:    bl __gnu_f2h_ieee
; CHECK-NEXT:    nop
; CHECK-NEXT:    fmr f1, f27
; CHECK-NEXT:    std r3, 96(r1) # 8-byte Folded Spill
; CHECK-NEXT:    bl __gnu_f2h_ieee
; CHECK-NEXT:    nop
; CHECK-NEXT:    fmr f1, f28
; CHECK-NEXT:    std r3, 88(r1) # 8-byte Folded Spill
; CHECK-NEXT:    bl __gnu_f2h_ieee
; CHECK-NEXT:    nop
; CHECK-NEXT:    fmr f1, f29
; CHECK-NEXT:    std r3, 80(r1) # 8-byte Folded Spill
; CHECK-NEXT:    bl __gnu_f2h_ieee
; CHECK-NEXT:    nop
; CHECK-NEXT:    fmr f1, f30
; CHECK-NEXT:    std r3, 72(r1) # 8-byte Folded Spill
; CHECK-NEXT:    bl __gnu_f2h_ieee
; CHECK-NEXT:    nop
; CHECK-NEXT:    fmr f1, f31
; CHECK-NEXT:    std r3, 64(r1) # 8-byte Folded Spill
; CHECK-NEXT:    bl __gnu_f2h_ieee
; CHECK-NEXT:    nop
; CHECK-NEXT:    lfs f1, 832(r1)
; CHECK-NEXT:    std r3, 56(r1) # 8-byte Folded Spill
; CHECK-NEXT:    bl __gnu_f2h_ieee
; CHECK-NEXT:    nop
; CHECK-NEXT:    lfs f1, 840(r1)
; CHECK-NEXT:    std r3, 48(r1) # 8-byte Folded Spill
; CHECK-NEXT:    bl __gnu_f2h_ieee
; CHECK-NEXT:    nop
; CHECK-NEXT:    lfs f1, 848(r1)
; CHECK-NEXT:    mr r15, r3
; CHECK-NEXT:    bl __gnu_f2h_ieee
; CHECK-NEXT:    nop
; CHECK-NEXT:    lfs f1, 856(r1)
; CHECK-NEXT:    mr r14, r3
; CHECK-NEXT:    bl __gnu_f2h_ieee
; CHECK-NEXT:    nop
; CHECK-NEXT:    lfs f1, 864(r1)
; CHECK-NEXT:    mr r31, r3
; CHECK-NEXT:    bl __gnu_f2h_ieee
; CHECK-NEXT:    nop
; CHECK-NEXT:    lfs f1, 872(r1)
; CHECK-NEXT:    mr r29, r3
; CHECK-NEXT:    bl __gnu_f2h_ieee
; CHECK-NEXT:    nop
; CHECK-NEXT:    lfs f1, 880(r1)
; CHECK-NEXT:    mr r28, r3
; CHECK-NEXT:    bl __gnu_f2h_ieee
; CHECK-NEXT:    nop
; CHECK-NEXT:    lfs f1, 888(r1)
; CHECK-NEXT:    mr r27, r3
; CHECK-NEXT:    bl __gnu_f2h_ieee
; CHECK-NEXT:    nop
; CHECK-NEXT:    lfs f1, 896(r1)
; CHECK-NEXT:    mr r26, r3
; CHECK-NEXT:    bl __gnu_f2h_ieee
; CHECK-NEXT:    nop
; CHECK-NEXT:    lfs f1, 904(r1)
; CHECK-NEXT:    mr r25, r3
; CHECK-NEXT:    bl __gnu_f2h_ieee
; CHECK-NEXT:    nop
; CHECK-NEXT:    lfs f1, 912(r1)
; CHECK-NEXT:    mr r24, r3
; CHECK-NEXT:    bl __gnu_f2h_ieee
; CHECK-NEXT:    nop
; CHECK-NEXT:    lfs f1, 920(r1)
; CHECK-NEXT:    mr r23, r3
; CHECK-NEXT:    bl __gnu_f2h_ieee
; CHECK-NEXT:    nop
; CHECK-NEXT:    lfs f1, 928(r1)
; CHECK-NEXT:    mr r22, r3
; CHECK-NEXT:    bl __gnu_f2h_ieee
; CHECK-NEXT:    nop
; CHECK-NEXT:    lfs f1, 936(r1)
; CHECK-NEXT:    mr r21, r3
; CHECK-NEXT:    bl __gnu_f2h_ieee
; CHECK-NEXT:    nop
; CHECK-NEXT:    lfs f1, 944(r1)
; CHECK-NEXT:    mr r20, r3
; CHECK-NEXT:    bl __gnu_f2h_ieee
; CHECK-NEXT:    nop
; CHECK-NEXT:    lfs f1, 952(r1)
; CHECK-NEXT:    mr r19, r3
; CHECK-NEXT:    bl __gnu_f2h_ieee
; CHECK-NEXT:    nop
; CHECK-NEXT:    lfs f1, 960(r1)
; CHECK-NEXT:    mr r18, r3
; CHECK-NEXT:    bl __gnu_f2h_ieee
; CHECK-NEXT:    nop
; CHECK-NEXT:    lfs f1, 968(r1)
; CHECK-NEXT:    mr r17, r3
; CHECK-NEXT:    bl __gnu_f2h_ieee
; CHECK-NEXT:    nop
; CHECK-NEXT:    lfs f1, 976(r1)
; CHECK-NEXT:    mr r16, r3
; CHECK-NEXT:    bl __gnu_f2h_ieee
; CHECK-NEXT:    nop
; CHECK-NEXT:    clrldi r3, r3, 48
; CHECK-NEXT:    bl __gnu_h2f_ieee
; CHECK-NEXT:    nop
; CHECK-NEXT:    li r3, 204
; CHECK-NEXT:    stxsspx f1, r1, r3 # 4-byte Folded Spill
; CHECK-NEXT:    clrldi r3, r16, 48
; CHECK-NEXT:    bl __gnu_h2f_ieee
; CHECK-NEXT:    nop
; CHECK-NEXT:    li r3, 200
; CHECK-NEXT:    stxsspx f1, r1, r3 # 4-byte Folded Spill
; CHECK-NEXT:    clrldi r3, r17, 48
; CHECK-NEXT:    bl __gnu_h2f_ieee
; CHECK-NEXT:    nop
; CHECK-NEXT:    clrldi r3, r18, 48
; CHECK-NEXT:    fmr f29, f1
; CHECK-NEXT:    bl __gnu_h2f_ieee
; CHECK-NEXT:    nop
; CHECK-NEXT:    clrldi r3, r19, 48
; CHECK-NEXT:    fmr f28, f1
; CHECK-NEXT:    bl __gnu_h2f_ieee
; CHECK-NEXT:    nop
; CHECK-NEXT:    clrldi r3, r20, 48
; CHECK-NEXT:    fmr f27, f1
; CHECK-NEXT:    bl __gnu_h2f_ieee
; CHECK-NEXT:    nop
; CHECK-NEXT:    clrldi r3, r21, 48
; CHECK-NEXT:    fmr f26, f1
; CHECK-NEXT:    bl __gnu_h2f_ieee
; CHECK-NEXT:    nop
; CHECK-NEXT:    clrldi r3, r22, 48
; CHECK-NEXT:    fmr f25, f1
; CHECK-NEXT:    bl __gnu_h2f_ieee
; CHECK-NEXT:    nop
; CHECK-NEXT:    clrldi r3, r23, 48
; CHECK-NEXT:    fmr f24, f1
; CHECK-NEXT:    bl __gnu_h2f_ieee
; CHECK-NEXT:    nop
; CHECK-NEXT:    clrldi r3, r24, 48
; CHECK-NEXT:    fmr f23, f1
; CHECK-NEXT:    bl __gnu_h2f_ieee
; CHECK-NEXT:    nop
; CHECK-NEXT:    clrldi r3, r25, 48
; CHECK-NEXT:    fmr f22, f1
; CHECK-NEXT:    bl __gnu_h2f_ieee
; CHECK-NEXT:    nop
; CHECK-NEXT:    clrldi r3, r26, 48
; CHECK-NEXT:    fmr f21, f1
; CHECK-NEXT:    bl __gnu_h2f_ieee
; CHECK-NEXT:    nop
; CHECK-NEXT:    clrldi r3, r27, 48
; CHECK-NEXT:    fmr f20, f1
; CHECK-NEXT:    bl __gnu_h2f_ieee
; CHECK-NEXT:    nop
; CHECK-NEXT:    clrldi r3, r28, 48
; CHECK-NEXT:    fmr f19, f1
; CHECK-NEXT:    bl __gnu_h2f_ieee
; CHECK-NEXT:    nop
; CHECK-NEXT:    clrldi r3, r29, 48
; CHECK-NEXT:    fmr f18, f1
; CHECK-NEXT:    bl __gnu_h2f_ieee
; CHECK-NEXT:    nop
; CHECK-NEXT:    clrldi r3, r31, 48
; CHECK-NEXT:    fmr f17, f1
; CHECK-NEXT:    bl __gnu_h2f_ieee
; CHECK-NEXT:    nop
; CHECK-NEXT:    clrldi r3, r14, 48
; CHECK-NEXT:    fmr f16, f1
; CHECK-NEXT:    bl __gnu_h2f_ieee
; CHECK-NEXT:    nop
; CHECK-NEXT:    clrldi r3, r15, 48
; CHECK-NEXT:    fmr f15, f1
; CHECK-NEXT:    bl __gnu_h2f_ieee
; CHECK-NEXT:    nop
; CHECK-NEXT:    ld r3, 48(r1) # 8-byte Folded Reload
; CHECK-NEXT:    fmr f14, f1
; CHECK-NEXT:    clrldi r3, r3, 48
; CHECK-NEXT:    bl __gnu_h2f_ieee
; CHECK-NEXT:    nop
; CHECK-NEXT:    ld r3, 56(r1) # 8-byte Folded Reload
; CHECK-NEXT:    fmr f30, f1
; CHECK-NEXT:    clrldi r3, r3, 48
; CHECK-NEXT:    bl __gnu_h2f_ieee
; CHECK-NEXT:    nop
; CHECK-NEXT:    ld r3, 64(r1) # 8-byte Folded Reload
; CHECK-NEXT:    xxlor v30, f1, f1
; CHECK-NEXT:    clrldi r3, r3, 48
; CHECK-NEXT:    bl __gnu_h2f_ieee
; CHECK-NEXT:    nop
; CHECK-NEXT:    ld r3, 72(r1) # 8-byte Folded Reload
; CHECK-NEXT:    xxlor v29, f1, f1
; CHECK-NEXT:    clrldi r3, r3, 48
; CHECK-NEXT:    bl __gnu_h2f_ieee
; CHECK-NEXT:    nop
; CHECK-NEXT:    ld r3, 80(r1) # 8-byte Folded Reload
; CHECK-NEXT:    xxlor v28, f1, f1
; CHECK-NEXT:    clrldi r3, r3, 48
; CHECK-NEXT:    bl __gnu_h2f_ieee
; CHECK-NEXT:    nop
; CHECK-NEXT:    ld r3, 88(r1) # 8-byte Folded Reload
; CHECK-NEXT:    xxlor v27, f1, f1
; CHECK-NEXT:    clrldi r3, r3, 48
; CHECK-NEXT:    bl __gnu_h2f_ieee
; CHECK-NEXT:    nop
; CHECK-NEXT:    ld r3, 96(r1) # 8-byte Folded Reload
; CHECK-NEXT:    xxlor v26, f1, f1
; CHECK-NEXT:    clrldi r3, r3, 48
; CHECK-NEXT:    bl __gnu_h2f_ieee
; CHECK-NEXT:    nop
; CHECK-NEXT:    ld r3, 104(r1) # 8-byte Folded Reload
; CHECK-NEXT:    xxlor v25, f1, f1
; CHECK-NEXT:    clrldi r3, r3, 48
; CHECK-NEXT:    bl __gnu_h2f_ieee
; CHECK-NEXT:    nop
; CHECK-NEXT:    ld r3, 112(r1) # 8-byte Folded Reload
; CHECK-NEXT:    xxlor v24, f1, f1
; CHECK-NEXT:    clrldi r3, r3, 48
; CHECK-NEXT:    bl __gnu_h2f_ieee
; CHECK-NEXT:    nop
; CHECK-NEXT:    ld r3, 120(r1) # 8-byte Folded Reload
; CHECK-NEXT:    xxlor v23, f1, f1
; CHECK-NEXT:    clrldi r3, r3, 48
; CHECK-NEXT:    bl __gnu_h2f_ieee
; CHECK-NEXT:    nop
; CHECK-NEXT:    ld r3, 128(r1) # 8-byte Folded Reload
; CHECK-NEXT:    xxlor v22, f1, f1
; CHECK-NEXT:    clrldi r3, r3, 48
; CHECK-NEXT:    bl __gnu_h2f_ieee
; CHECK-NEXT:    nop
; CHECK-NEXT:    ld r3, 144(r1) # 8-byte Folded Reload
; CHECK-NEXT:    xxlor v21, f1, f1
; CHECK-NEXT:    clrldi r3, r3, 48
; CHECK-NEXT:    bl __gnu_h2f_ieee
; CHECK-NEXT:    nop
; CHECK-NEXT:    ld r3, 160(r1) # 8-byte Folded Reload
; CHECK-NEXT:    xxlor v20, f1, f1
; CHECK-NEXT:    clrldi r3, r3, 48
; CHECK-NEXT:    bl __gnu_h2f_ieee
; CHECK-NEXT:    nop
; CHECK-NEXT:    ld r3, 176(r1) # 8-byte Folded Reload
; CHECK-NEXT:    fmr f31, f1
; CHECK-NEXT:    clrldi r3, r3, 48
; CHECK-NEXT:    bl __gnu_h2f_ieee
; CHECK-NEXT:    nop
; CHECK-NEXT:    bl lrintf
; CHECK-NEXT:    nop
; CHECK-NEXT:    fmr f1, f31
; CHECK-NEXT:    mtvsrd v31, r3
; CHECK-NEXT:    bl lrintf
; CHECK-NEXT:    nop
; CHECK-NEXT:    mtfprd f0, r3
; CHECK-NEXT:    li r3, 176
; CHECK-NEXT:    xxlor f1, v20, v20
; CHECK-NEXT:    xxmrghd vs0, vs0, v31
; CHECK-NEXT:    stxvd2x vs0, r1, r3 # 16-byte Folded Spill
; CHECK-NEXT:    bl lrintf
; CHECK-NEXT:    nop
; CHECK-NEXT:    xxlor f1, v21, v21
; CHECK-NEXT:    mtvsrd v31, r3
; CHECK-NEXT:    bl lrintf
; CHECK-NEXT:    nop
; CHECK-NEXT:    mtfprd f0, r3
; CHECK-NEXT:    li r3, 160
; CHECK-NEXT:    xxlor f1, v22, v22
; CHECK-NEXT:    xxmrghd vs0, vs0, v31
; CHECK-NEXT:    stxvd2x vs0, r1, r3 # 16-byte Folded Spill
; CHECK-NEXT:    bl lrintf
; CHECK-NEXT:    nop
; CHECK-NEXT:    xxlor f1, v23, v23
; CHECK-NEXT:    mtvsrd v31, r3
; CHECK-NEXT:    bl lrintf
; CHECK-NEXT:    nop
; CHECK-NEXT:    mtfprd f0, r3
; CHECK-NEXT:    li r3, 144
; CHECK-NEXT:    xxlor f1, v24, v24
; CHECK-NEXT:    xxmrghd vs0, vs0, v31
; CHECK-NEXT:    stxvd2x vs0, r1, r3 # 16-byte Folded Spill
; CHECK-NEXT:    bl lrintf
; CHECK-NEXT:    nop
; CHECK-NEXT:    xxlor f1, v25, v25
; CHECK-NEXT:    mtvsrd v31, r3
; CHECK-NEXT:    bl lrintf
; CHECK-NEXT:    nop
; CHECK-NEXT:    mtfprd f0, r3
; CHECK-NEXT:    li r3, 128
; CHECK-NEXT:    xxlor f1, v26, v26
; CHECK-NEXT:    xxmrghd vs0, vs0, v31
; CHECK-NEXT:    stxvd2x vs0, r1, r3 # 16-byte Folded Spill
; CHECK-NEXT:    bl lrintf
; CHECK-NEXT:    nop
; CHECK-NEXT:    xxlor f1, v27, v27
; CHECK-NEXT:    mtvsrd v31, r3
; CHECK-NEXT:    bl lrintf
; CHECK-NEXT:    nop
; CHECK-NEXT:    mtfprd f0, r3
; CHECK-NEXT:    xxlor f1, v28, v28
; CHECK-NEXT:    xxmrghd v27, vs0, v31
; CHECK-NEXT:    bl lrintf
; CHECK-NEXT:    nop
; CHECK-NEXT:    xxlor f1, v29, v29
; CHECK-NEXT:    mtvsrd v31, r3
; CHECK-NEXT:    bl lrintf
; CHECK-NEXT:    nop
; CHECK-NEXT:    mtfprd f0, r3
; CHECK-NEXT:    xxlor f1, v30, v30
; CHECK-NEXT:    xxmrghd v29, vs0, v31
; CHECK-NEXT:    bl lrintf
; CHECK-NEXT:    nop
; CHECK-NEXT:    fmr f1, f30
; CHECK-NEXT:    mtvsrd v31, r3
; CHECK-NEXT:    bl lrintf
; CHECK-NEXT:    nop
; CHECK-NEXT:    fmr f1, f14
; CHECK-NEXT:    mtfprd f0, r3
; CHECK-NEXT:    xxmrghd v31, vs0, v31
; CHECK-NEXT:    bl lrintf
; CHECK-NEXT:    nop
; CHECK-NEXT:    fmr f1, f15
; CHECK-NEXT:    mtvsrd v30, r3
; CHECK-NEXT:    bl lrintf
; CHECK-NEXT:    nop
; CHECK-NEXT:    fmr f1, f16
; CHECK-NEXT:    mtfprd f0, r3
; CHECK-NEXT:    xxmrghd v30, vs0, v30
; CHECK-NEXT:    bl lrintf
; CHECK-NEXT:    nop
; CHECK-NEXT:    fmr f1, f17
; CHECK-NEXT:    mtvsrd v28, r3
; CHECK-NEXT:    bl lrintf
; CHECK-NEXT:    nop
; CHECK-NEXT:    fmr f1, f18
; CHECK-NEXT:    mtfprd f0, r3
; CHECK-NEXT:    xxmrghd v28, vs0, v28
; CHECK-NEXT:    bl lrintf
; CHECK-NEXT:    nop
; CHECK-NEXT:    fmr f1, f19
; CHECK-NEXT:    mtvsrd v26, r3
; CHECK-NEXT:    bl lrintf
; CHECK-NEXT:    nop
; CHECK-NEXT:    fmr f1, f20
; CHECK-NEXT:    mtfprd f0, r3
; CHECK-NEXT:    xxmrghd v26, vs0, v26
; CHECK-NEXT:    bl lrintf
; CHECK-NEXT:    nop
; CHECK-NEXT:    fmr f1, f21
; CHECK-NEXT:    mtvsrd v24, r3
; CHECK-NEXT:    bl lrintf
; CHECK-NEXT:    nop
; CHECK-NEXT:    fmr f1, f22
; CHECK-NEXT:    mtfprd f0, r3
; CHECK-NEXT:    xxmrghd v24, vs0, v24
; CHECK-NEXT:    bl lrintf
; CHECK-NEXT:    nop
; CHECK-NEXT:    fmr f1, f23
; CHECK-NEXT:    mtvsrd v22, r3
; CHECK-NEXT:    bl lrintf
; CHECK-NEXT:    nop
; CHECK-NEXT:    fmr f1, f24
; CHECK-NEXT:    mtfprd f0, r3
; CHECK-NEXT:    xxmrghd v22, vs0, v22
; CHECK-NEXT:    bl lrintf
; CHECK-NEXT:    nop
; CHECK-NEXT:    fmr f1, f25
; CHECK-NEXT:    mtvsrd v20, r3
; CHECK-NEXT:    bl lrintf
; CHECK-NEXT:    nop
; CHECK-NEXT:    fmr f1, f26
; CHECK-NEXT:    mtfprd f0, r3
; CHECK-NEXT:    xxmrghd v20, vs0, v20
; CHECK-NEXT:    bl lrintf
; CHECK-NEXT:    nop
; CHECK-NEXT:    fmr f1, f27
; CHECK-NEXT:    mtvsrd v21, r3
; CHECK-NEXT:    bl lrintf
; CHECK-NEXT:    nop
; CHECK-NEXT:    fmr f1, f28
; CHECK-NEXT:    mtfprd f0, r3
; CHECK-NEXT:    xxmrghd v21, vs0, v21
; CHECK-NEXT:    bl lrintf
; CHECK-NEXT:    nop
; CHECK-NEXT:    fmr f1, f29
; CHECK-NEXT:    mtvsrd v23, r3
; CHECK-NEXT:    bl lrintf
; CHECK-NEXT:    nop
; CHECK-NEXT:    mtfprd f0, r3
; CHECK-NEXT:    li r3, 200
; CHECK-NEXT:    lxsspx f1, r1, r3 # 4-byte Folded Reload
; CHECK-NEXT:    xxmrghd v23, vs0, v23
; CHECK-NEXT:    bl lrintf
; CHECK-NEXT:    nop
; CHECK-NEXT:    mtvsrd v25, r3
; CHECK-NEXT:    li r3, 204
; CHECK-NEXT:    lxsspx f1, r1, r3 # 4-byte Folded Reload
; CHECK-NEXT:    bl lrintf
; CHECK-NEXT:    nop
; CHECK-NEXT:    mtfprd f0, r3
; CHECK-NEXT:    li r3, 240
; CHECK-NEXT:    xxswapd vs1, v23
; CHECK-NEXT:    li r4, 128
; CHECK-NEXT:    xxswapd vs2, v21
; CHECK-NEXT:    xxswapd vs3, v31
; CHECK-NEXT:    xxmrghd v2, vs0, v25
; CHECK-NEXT:    xxswapd vs0, v2
; CHECK-NEXT:    stxvd2x vs0, r30, r3
; CHECK-NEXT:    li r3, 224
; CHECK-NEXT:    stxvd2x vs1, r30, r3
; CHECK-NEXT:    li r3, 208
; CHECK-NEXT:    stxvd2x vs2, r30, r3
; CHECK-NEXT:    li r3, 192
; CHECK-NEXT:    xxswapd vs0, v20
; CHECK-NEXT:    stxvd2x vs0, r30, r3
; CHECK-NEXT:    li r3, 176
; CHECK-NEXT:    xxswapd vs1, v22
; CHECK-NEXT:    stxvd2x vs1, r30, r3
; CHECK-NEXT:    li r3, 160
; CHECK-NEXT:    xxswapd vs2, v28
; CHECK-NEXT:    xxswapd vs0, v24
; CHECK-NEXT:    stxvd2x vs0, r30, r3
; CHECK-NEXT:    li r3, 144
; CHECK-NEXT:    xxswapd vs1, v26
; CHECK-NEXT:    stxvd2x vs1, r30, r3
; CHECK-NEXT:    li r3, 128
; CHECK-NEXT:    stxvd2x vs2, r30, r3
; CHECK-NEXT:    li r3, 112
; CHECK-NEXT:    xxswapd vs0, v30
; CHECK-NEXT:    stxvd2x vs0, r30, r3
; CHECK-NEXT:    li r3, 96
; CHECK-NEXT:    stxvd2x vs3, r30, r3
; CHECK-NEXT:    li r3, 80
; CHECK-NEXT:    lxvd2x vs2, r1, r4 # 16-byte Folded Reload
; CHECK-NEXT:    li r4, 144
; CHECK-NEXT:    xxswapd vs1, v29
; CHECK-NEXT:    stxvd2x vs1, r30, r3
; CHECK-NEXT:    li r3, 64
; CHECK-NEXT:    lxvd2x vs1, r1, r4 # 16-byte Folded Reload
; CHECK-NEXT:    li r4, 160
; CHECK-NEXT:    lxvd2x vs3, r1, r4 # 16-byte Folded Reload
; CHECK-NEXT:    li r4, 176
; CHECK-NEXT:    lxvd2x vs4, r1, r4 # 16-byte Folded Reload
; CHECK-NEXT:    xxswapd vs0, v27
; CHECK-NEXT:    stxvd2x vs0, r30, r3
; CHECK-NEXT:    li r3, 48
; CHECK-NEXT:    xxswapd vs2, vs2
; CHECK-NEXT:    stxvd2x vs2, r30, r3
; CHECK-NEXT:    li r3, 32
; CHECK-NEXT:    xxswapd vs1, vs1
; CHECK-NEXT:    stxvd2x vs1, r30, r3
; CHECK-NEXT:    li r3, 16
; CHECK-NEXT:    xxswapd vs3, vs3
; CHECK-NEXT:    stxvd2x vs3, r30, r3
; CHECK-NEXT:    li r3, 384
; CHECK-NEXT:    xxswapd vs4, vs4
; CHECK-NEXT:    stxvd2x vs4, 0, r30
; CHECK-NEXT:    lvx v31, r1, r3 # 16-byte Folded Reload
; CHECK-NEXT:    li r3, 368
; CHECK-NEXT:    lfd f31, 680(r1) # 8-byte Folded Reload
; CHECK-NEXT:    lfd f30, 672(r1) # 8-byte Folded Reload
; CHECK-NEXT:    lfd f29, 664(r1) # 8-byte Folded Reload
; CHECK-NEXT:    lfd f28, 656(r1) # 8-byte Folded Reload
; CHECK-NEXT:    lfd f27, 648(r1) # 8-byte Folded Reload
; CHECK-NEXT:    lfd f26, 640(r1) # 8-byte Folded Reload
; CHECK-NEXT:    lfd f25, 632(r1) # 8-byte Folded Reload
; CHECK-NEXT:    lfd f24, 624(r1) # 8-byte Folded Reload
; CHECK-NEXT:    lfd f23, 616(r1) # 8-byte Folded Reload
; CHECK-NEXT:    lfd f22, 608(r1) # 8-byte Folded Reload
; CHECK-NEXT:    lfd f21, 600(r1) # 8-byte Folded Reload
; CHECK-NEXT:    lfd f20, 592(r1) # 8-byte Folded Reload
; CHECK-NEXT:    lfd f19, 584(r1) # 8-byte Folded Reload
; CHECK-NEXT:    lfd f18, 576(r1) # 8-byte Folded Reload
; CHECK-NEXT:    lfd f17, 568(r1) # 8-byte Folded Reload
; CHECK-NEXT:    lfd f16, 560(r1) # 8-byte Folded Reload
; CHECK-NEXT:    lvx v30, r1, r3 # 16-byte Folded Reload
; CHECK-NEXT:    li r3, 352
; CHECK-NEXT:    lfd f15, 552(r1) # 8-byte Folded Reload
; CHECK-NEXT:    lfd f14, 544(r1) # 8-byte Folded Reload
; CHECK-NEXT:    ld r31, 536(r1) # 8-byte Folded Reload
; CHECK-NEXT:    ld r30, 528(r1) # 8-byte Folded Reload
; CHECK-NEXT:    ld r29, 520(r1) # 8-byte Folded Reload
; CHECK-NEXT:    ld r28, 512(r1) # 8-byte Folded Reload
; CHECK-NEXT:    lvx v29, r1, r3 # 16-byte Folded Reload
; CHECK-NEXT:    li r3, 336
; CHECK-NEXT:    ld r27, 504(r1) # 8-byte Folded Reload
; CHECK-NEXT:    ld r26, 496(r1) # 8-byte Folded Reload
; CHECK-NEXT:    ld r25, 488(r1) # 8-byte Folded Reload
; CHECK-NEXT:    ld r24, 480(r1) # 8-byte Folded Reload
; CHECK-NEXT:    ld r23, 472(r1) # 8-byte Folded Reload
; CHECK-NEXT:    ld r22, 464(r1) # 8-byte Folded Reload
; CHECK-NEXT:    lvx v28, r1, r3 # 16-byte Folded Reload
; CHECK-NEXT:    li r3, 320
; CHECK-NEXT:    ld r21, 456(r1) # 8-byte Folded Reload
; CHECK-NEXT:    ld r20, 448(r1) # 8-byte Folded Reload
; CHECK-NEXT:    ld r19, 440(r1) # 8-byte Folded Reload
; CHECK-NEXT:    ld r18, 432(r1) # 8-byte Folded Reload
; CHECK-NEXT:    ld r17, 424(r1) # 8-byte Folded Reload
; CHECK-NEXT:    ld r16, 416(r1) # 8-byte Folded Reload
; CHECK-NEXT:    lvx v27, r1, r3 # 16-byte Folded Reload
; CHECK-NEXT:    li r3, 304
; CHECK-NEXT:    ld r15, 408(r1) # 8-byte Folded Reload
; CHECK-NEXT:    ld r14, 400(r1) # 8-byte Folded Reload
; CHECK-NEXT:    lvx v26, r1, r3 # 16-byte Folded Reload
; CHECK-NEXT:    li r3, 288
; CHECK-NEXT:    lvx v25, r1, r3 # 16-byte Folded Reload
; CHECK-NEXT:    li r3, 272
; CHECK-NEXT:    lvx v24, r1, r3 # 16-byte Folded Reload
; CHECK-NEXT:    li r3, 256
; CHECK-NEXT:    lvx v23, r1, r3 # 16-byte Folded Reload
; CHECK-NEXT:    li r3, 240
; CHECK-NEXT:    lvx v22, r1, r3 # 16-byte Folded Reload
; CHECK-NEXT:    li r3, 224
; CHECK-NEXT:    lvx v21, r1, r3 # 16-byte Folded Reload
; CHECK-NEXT:    li r3, 208
; CHECK-NEXT:    lvx v20, r1, r3 # 16-byte Folded Reload
; CHECK-NEXT:    addi r1, r1, 688
; CHECK-NEXT:    ld r0, 16(r1)
; CHECK-NEXT:    mtlr r0
; CHECK-NEXT:    blr
;
; FAST-LABEL: lrint_v32i64_v32f16:
; FAST:       # %bb.0:
; FAST-NEXT:    mflr r0
; FAST-NEXT:    stdu r1, -480(r1)
; FAST-NEXT:    std r0, 496(r1)
; FAST-NEXT:    .cfi_def_cfa_offset 480
; FAST-NEXT:    .cfi_offset lr, 16
; FAST-NEXT:    .cfi_offset r30, -160
; FAST-NEXT:    .cfi_offset f14, -144
; FAST-NEXT:    .cfi_offset f15, -136
; FAST-NEXT:    .cfi_offset f16, -128
; FAST-NEXT:    .cfi_offset f17, -120
; FAST-NEXT:    .cfi_offset f18, -112
; FAST-NEXT:    .cfi_offset f19, -104
; FAST-NEXT:    .cfi_offset f20, -96
; FAST-NEXT:    .cfi_offset f21, -88
; FAST-NEXT:    .cfi_offset f22, -80
; FAST-NEXT:    .cfi_offset f23, -72
; FAST-NEXT:    .cfi_offset f24, -64
; FAST-NEXT:    .cfi_offset f25, -56
; FAST-NEXT:    .cfi_offset f26, -48
; FAST-NEXT:    .cfi_offset f27, -40
; FAST-NEXT:    .cfi_offset f28, -32
; FAST-NEXT:    .cfi_offset f29, -24
; FAST-NEXT:    .cfi_offset f30, -16
; FAST-NEXT:    .cfi_offset f31, -8
; FAST-NEXT:    .cfi_offset v20, -352
; FAST-NEXT:    .cfi_offset v21, -336
; FAST-NEXT:    .cfi_offset v22, -320
; FAST-NEXT:    .cfi_offset v23, -304
; FAST-NEXT:    .cfi_offset v24, -288
; FAST-NEXT:    .cfi_offset v25, -272
; FAST-NEXT:    .cfi_offset v26, -256
; FAST-NEXT:    .cfi_offset v27, -240
; FAST-NEXT:    .cfi_offset v28, -224
; FAST-NEXT:    .cfi_offset v29, -208
; FAST-NEXT:    .cfi_offset v30, -192
; FAST-NEXT:    .cfi_offset v31, -176
; FAST-NEXT:    li r4, 128
; FAST-NEXT:    std r30, 320(r1) # 8-byte Folded Spill
; FAST-NEXT:    stfd f14, 336(r1) # 8-byte Folded Spill
; FAST-NEXT:    fmr f14, f5
; FAST-NEXT:    stfd f15, 344(r1) # 8-byte Folded Spill
; FAST-NEXT:    stfd f16, 352(r1) # 8-byte Folded Spill
; FAST-NEXT:    fmr f16, f4
; FAST-NEXT:    mr r30, r3
; FAST-NEXT:    stvx v20, r1, r4 # 16-byte Folded Spill
; FAST-NEXT:    li r4, 144
; FAST-NEXT:    stfd f17, 360(r1) # 8-byte Folded Spill
; FAST-NEXT:    stfd f18, 368(r1) # 8-byte Folded Spill
; FAST-NEXT:    stfd f19, 376(r1) # 8-byte Folded Spill
; FAST-NEXT:    stfd f20, 384(r1) # 8-byte Folded Spill
; FAST-NEXT:    stfd f21, 392(r1) # 8-byte Folded Spill
; FAST-NEXT:    stfd f22, 400(r1) # 8-byte Folded Spill
; FAST-NEXT:    stvx v21, r1, r4 # 16-byte Folded Spill
; FAST-NEXT:    li r4, 160
; FAST-NEXT:    stfd f23, 408(r1) # 8-byte Folded Spill
; FAST-NEXT:    stfd f24, 416(r1) # 8-byte Folded Spill
; FAST-NEXT:    stfd f25, 424(r1) # 8-byte Folded Spill
; FAST-NEXT:    stfd f26, 432(r1) # 8-byte Folded Spill
; FAST-NEXT:    stfd f27, 440(r1) # 8-byte Folded Spill
; FAST-NEXT:    stfd f28, 448(r1) # 8-byte Folded Spill
; FAST-NEXT:    stvx v22, r1, r4 # 16-byte Folded Spill
; FAST-NEXT:    li r4, 176
; FAST-NEXT:    xxlor v22, f3, f3
; FAST-NEXT:    stfd f29, 456(r1) # 8-byte Folded Spill
; FAST-NEXT:    fmr f29, f9
; FAST-NEXT:    stfd f30, 464(r1) # 8-byte Folded Spill
; FAST-NEXT:    stfd f31, 472(r1) # 8-byte Folded Spill
; FAST-NEXT:    stvx v23, r1, r4 # 16-byte Folded Spill
; FAST-NEXT:    li r4, 192
; FAST-NEXT:    xxlor v23, f2, f2
; FAST-NEXT:    stvx v24, r1, r4 # 16-byte Folded Spill
; FAST-NEXT:    li r4, 208
; FAST-NEXT:    stvx v25, r1, r4 # 16-byte Folded Spill
; FAST-NEXT:    li r4, 224
; FAST-NEXT:    xxlor v25, f13, f13
; FAST-NEXT:    stvx v26, r1, r4 # 16-byte Folded Spill
; FAST-NEXT:    li r4, 240
; FAST-NEXT:    xxlor v26, f12, f12
; FAST-NEXT:    stvx v27, r1, r4 # 16-byte Folded Spill
; FAST-NEXT:    li r4, 256
; FAST-NEXT:    xxlor v27, f11, f11
; FAST-NEXT:    stvx v28, r1, r4 # 16-byte Folded Spill
; FAST-NEXT:    li r4, 272
; FAST-NEXT:    xxlor v28, f10, f10
; FAST-NEXT:    stvx v29, r1, r4 # 16-byte Folded Spill
; FAST-NEXT:    li r4, 288
; FAST-NEXT:    xxlor v29, f8, f8
; FAST-NEXT:    stvx v30, r1, r4 # 16-byte Folded Spill
; FAST-NEXT:    li r4, 304
; FAST-NEXT:    xxlor v30, f7, f7
; FAST-NEXT:    stvx v31, r1, r4 # 16-byte Folded Spill
; FAST-NEXT:    li r4, 44
; FAST-NEXT:    xxlor v31, f6, f6
; FAST-NEXT:    stxsspx f1, r1, r4 # 4-byte Folded Spill
; FAST-NEXT:    lfs f1, 768(r1)
; FAST-NEXT:    bl __gnu_f2h_ieee
; FAST-NEXT:    nop
; FAST-NEXT:    clrldi r3, r3, 48
; FAST-NEXT:    bl __gnu_h2f_ieee
; FAST-NEXT:    nop
; FAST-NEXT:    li r3, 120
; FAST-NEXT:    stxsdx f1, r1, r3 # 8-byte Folded Spill
; FAST-NEXT:    lfs f1, 760(r1)
; FAST-NEXT:    bl __gnu_f2h_ieee
; FAST-NEXT:    nop
; FAST-NEXT:    clrldi r3, r3, 48
; FAST-NEXT:    bl __gnu_h2f_ieee
; FAST-NEXT:    nop
; FAST-NEXT:    li r3, 112
; FAST-NEXT:    stxsdx f1, r1, r3 # 8-byte Folded Spill
; FAST-NEXT:    lfs f1, 752(r1)
; FAST-NEXT:    bl __gnu_f2h_ieee
; FAST-NEXT:    nop
; FAST-NEXT:    clrldi r3, r3, 48
; FAST-NEXT:    bl __gnu_h2f_ieee
; FAST-NEXT:    nop
; FAST-NEXT:    li r3, 104
; FAST-NEXT:    stxsdx f1, r1, r3 # 8-byte Folded Spill
; FAST-NEXT:    lfs f1, 744(r1)
; FAST-NEXT:    bl __gnu_f2h_ieee
; FAST-NEXT:    nop
; FAST-NEXT:    clrldi r3, r3, 48
; FAST-NEXT:    bl __gnu_h2f_ieee
; FAST-NEXT:    nop
; FAST-NEXT:    li r3, 96
; FAST-NEXT:    stxsdx f1, r1, r3 # 8-byte Folded Spill
; FAST-NEXT:    lfs f1, 736(r1)
; FAST-NEXT:    bl __gnu_f2h_ieee
; FAST-NEXT:    nop
; FAST-NEXT:    clrldi r3, r3, 48
; FAST-NEXT:    bl __gnu_h2f_ieee
; FAST-NEXT:    nop
; FAST-NEXT:    li r3, 88
; FAST-NEXT:    stxsdx f1, r1, r3 # 8-byte Folded Spill
; FAST-NEXT:    lfs f1, 728(r1)
; FAST-NEXT:    bl __gnu_f2h_ieee
; FAST-NEXT:    nop
; FAST-NEXT:    clrldi r3, r3, 48
; FAST-NEXT:    bl __gnu_h2f_ieee
; FAST-NEXT:    nop
; FAST-NEXT:    li r3, 80
; FAST-NEXT:    stxsdx f1, r1, r3 # 8-byte Folded Spill
; FAST-NEXT:    lfs f1, 720(r1)
; FAST-NEXT:    bl __gnu_f2h_ieee
; FAST-NEXT:    nop
; FAST-NEXT:    clrldi r3, r3, 48
; FAST-NEXT:    bl __gnu_h2f_ieee
; FAST-NEXT:    nop
; FAST-NEXT:    li r3, 72
; FAST-NEXT:    stxsdx f1, r1, r3 # 8-byte Folded Spill
; FAST-NEXT:    lfs f1, 712(r1)
; FAST-NEXT:    bl __gnu_f2h_ieee
; FAST-NEXT:    nop
; FAST-NEXT:    clrldi r3, r3, 48
; FAST-NEXT:    bl __gnu_h2f_ieee
; FAST-NEXT:    nop
; FAST-NEXT:    li r3, 64
; FAST-NEXT:    stxsdx f1, r1, r3 # 8-byte Folded Spill
; FAST-NEXT:    lfs f1, 704(r1)
; FAST-NEXT:    bl __gnu_f2h_ieee
; FAST-NEXT:    nop
; FAST-NEXT:    clrldi r3, r3, 48
; FAST-NEXT:    bl __gnu_h2f_ieee
; FAST-NEXT:    nop
; FAST-NEXT:    li r3, 56
; FAST-NEXT:    stxsdx f1, r1, r3 # 8-byte Folded Spill
; FAST-NEXT:    lfs f1, 696(r1)
; FAST-NEXT:    bl __gnu_f2h_ieee
; FAST-NEXT:    nop
; FAST-NEXT:    clrldi r3, r3, 48
; FAST-NEXT:    bl __gnu_h2f_ieee
; FAST-NEXT:    nop
; FAST-NEXT:    li r3, 48
; FAST-NEXT:    stxsdx f1, r1, r3 # 8-byte Folded Spill
; FAST-NEXT:    lfs f1, 688(r1)
; FAST-NEXT:    bl __gnu_f2h_ieee
; FAST-NEXT:    nop
; FAST-NEXT:    clrldi r3, r3, 48
; FAST-NEXT:    bl __gnu_h2f_ieee
; FAST-NEXT:    nop
; FAST-NEXT:    xxlor v21, f1, f1
; FAST-NEXT:    lfs f1, 680(r1)
; FAST-NEXT:    bl __gnu_f2h_ieee
; FAST-NEXT:    nop
; FAST-NEXT:    clrldi r3, r3, 48
; FAST-NEXT:    bl __gnu_h2f_ieee
; FAST-NEXT:    nop
; FAST-NEXT:    xxlor v20, f1, f1
; FAST-NEXT:    lfs f1, 672(r1)
; FAST-NEXT:    bl __gnu_f2h_ieee
; FAST-NEXT:    nop
; FAST-NEXT:    clrldi r3, r3, 48
; FAST-NEXT:    bl __gnu_h2f_ieee
; FAST-NEXT:    nop
; FAST-NEXT:    xxlor v24, f1, f1
; FAST-NEXT:    lfs f1, 664(r1)
; FAST-NEXT:    bl __gnu_f2h_ieee
; FAST-NEXT:    nop
; FAST-NEXT:    clrldi r3, r3, 48
; FAST-NEXT:    bl __gnu_h2f_ieee
; FAST-NEXT:    nop
; FAST-NEXT:    fmr f31, f1
; FAST-NEXT:    lfs f1, 656(r1)
; FAST-NEXT:    bl __gnu_f2h_ieee
; FAST-NEXT:    nop
; FAST-NEXT:    clrldi r3, r3, 48
; FAST-NEXT:    bl __gnu_h2f_ieee
; FAST-NEXT:    nop
; FAST-NEXT:    fmr f30, f1
; FAST-NEXT:    lfs f1, 648(r1)
; FAST-NEXT:    bl __gnu_f2h_ieee
; FAST-NEXT:    nop
; FAST-NEXT:    clrldi r3, r3, 48
; FAST-NEXT:    bl __gnu_h2f_ieee
; FAST-NEXT:    nop
; FAST-NEXT:    fmr f28, f1
; FAST-NEXT:    lfs f1, 640(r1)
; FAST-NEXT:    bl __gnu_f2h_ieee
; FAST-NEXT:    nop
; FAST-NEXT:    clrldi r3, r3, 48
; FAST-NEXT:    bl __gnu_h2f_ieee
; FAST-NEXT:    nop
; FAST-NEXT:    fmr f27, f1
; FAST-NEXT:    lfs f1, 632(r1)
; FAST-NEXT:    bl __gnu_f2h_ieee
; FAST-NEXT:    nop
; FAST-NEXT:    clrldi r3, r3, 48
; FAST-NEXT:    bl __gnu_h2f_ieee
; FAST-NEXT:    nop
; FAST-NEXT:    fmr f26, f1
; FAST-NEXT:    lfs f1, 624(r1)
; FAST-NEXT:    bl __gnu_f2h_ieee
; FAST-NEXT:    nop
; FAST-NEXT:    clrldi r3, r3, 48
; FAST-NEXT:    bl __gnu_h2f_ieee
; FAST-NEXT:    nop
; FAST-NEXT:    fmr f25, f1
; FAST-NEXT:    xxlor f1, v25, v25
; FAST-NEXT:    bl __gnu_f2h_ieee
; FAST-NEXT:    nop
; FAST-NEXT:    clrldi r3, r3, 48
; FAST-NEXT:    bl __gnu_h2f_ieee
; FAST-NEXT:    nop
; FAST-NEXT:    fmr f24, f1
; FAST-NEXT:    xxlor f1, v26, v26
; FAST-NEXT:    bl __gnu_f2h_ieee
; FAST-NEXT:    nop
; FAST-NEXT:    clrldi r3, r3, 48
; FAST-NEXT:    bl __gnu_h2f_ieee
; FAST-NEXT:    nop
; FAST-NEXT:    fmr f23, f1
; FAST-NEXT:    xxlor f1, v27, v27
; FAST-NEXT:    bl __gnu_f2h_ieee
; FAST-NEXT:    nop
; FAST-NEXT:    clrldi r3, r3, 48
; FAST-NEXT:    bl __gnu_h2f_ieee
; FAST-NEXT:    nop
; FAST-NEXT:    fmr f22, f1
; FAST-NEXT:    xxlor f1, v28, v28
; FAST-NEXT:    bl __gnu_f2h_ieee
; FAST-NEXT:    nop
; FAST-NEXT:    clrldi r3, r3, 48
; FAST-NEXT:    bl __gnu_h2f_ieee
; FAST-NEXT:    nop
; FAST-NEXT:    fmr f21, f1
; FAST-NEXT:    fmr f1, f29
; FAST-NEXT:    bl __gnu_f2h_ieee
; FAST-NEXT:    nop
; FAST-NEXT:    clrldi r3, r3, 48
; FAST-NEXT:    bl __gnu_h2f_ieee
; FAST-NEXT:    nop
; FAST-NEXT:    fmr f20, f1
; FAST-NEXT:    xxlor f1, v29, v29
; FAST-NEXT:    bl __gnu_f2h_ieee
; FAST-NEXT:    nop
; FAST-NEXT:    clrldi r3, r3, 48
; FAST-NEXT:    bl __gnu_h2f_ieee
; FAST-NEXT:    nop
; FAST-NEXT:    fmr f19, f1
; FAST-NEXT:    xxlor f1, v30, v30
; FAST-NEXT:    bl __gnu_f2h_ieee
; FAST-NEXT:    nop
; FAST-NEXT:    clrldi r3, r3, 48
; FAST-NEXT:    bl __gnu_h2f_ieee
; FAST-NEXT:    nop
; FAST-NEXT:    fmr f18, f1
; FAST-NEXT:    xxlor f1, v31, v31
; FAST-NEXT:    bl __gnu_f2h_ieee
; FAST-NEXT:    nop
; FAST-NEXT:    clrldi r3, r3, 48
; FAST-NEXT:    bl __gnu_h2f_ieee
; FAST-NEXT:    nop
; FAST-NEXT:    fmr f29, f1
; FAST-NEXT:    fmr f1, f14
; FAST-NEXT:    bl __gnu_f2h_ieee
; FAST-NEXT:    nop
; FAST-NEXT:    clrldi r3, r3, 48
; FAST-NEXT:    bl __gnu_h2f_ieee
; FAST-NEXT:    nop
; FAST-NEXT:    fmr f14, f1
; FAST-NEXT:    fmr f1, f16
; FAST-NEXT:    bl __gnu_f2h_ieee
; FAST-NEXT:    nop
; FAST-NEXT:    clrldi r3, r3, 48
; FAST-NEXT:    bl __gnu_h2f_ieee
; FAST-NEXT:    nop
; FAST-NEXT:    fmr f16, f1
; FAST-NEXT:    xxlor f1, v22, v22
; FAST-NEXT:    bl __gnu_f2h_ieee
; FAST-NEXT:    nop
; FAST-NEXT:    clrldi r3, r3, 48
; FAST-NEXT:    bl __gnu_h2f_ieee
; FAST-NEXT:    nop
; FAST-NEXT:    fmr f17, f1
; FAST-NEXT:    xxlor f1, v23, v23
; FAST-NEXT:    bl __gnu_f2h_ieee
; FAST-NEXT:    nop
; FAST-NEXT:    clrldi r3, r3, 48
; FAST-NEXT:    bl __gnu_h2f_ieee
; FAST-NEXT:    nop
; FAST-NEXT:    li r3, 44
; FAST-NEXT:    fmr f15, f1
; FAST-NEXT:    lxsspx f1, r1, r3 # 4-byte Folded Reload
; FAST-NEXT:    bl __gnu_f2h_ieee
; FAST-NEXT:    nop
; FAST-NEXT:    clrldi r3, r3, 48
; FAST-NEXT:    bl __gnu_h2f_ieee
; FAST-NEXT:    nop
; FAST-NEXT:    fctid f3, f15
; FAST-NEXT:    fctid f4, f17
; FAST-NEXT:    mffprd r3, f3
; FAST-NEXT:    fctid f5, f16
; FAST-NEXT:    fctid f6, f14
; FAST-NEXT:    fctid f7, f18
; FAST-NEXT:    fctid f8, f19
; FAST-NEXT:    fctid f13, f1
; FAST-NEXT:    fctid f9, f20
; FAST-NEXT:    fctid f10, f22
; FAST-NEXT:    fctid f11, f24
; FAST-NEXT:    fctid f12, f25
; FAST-NEXT:    fctid f2, f23
; FAST-NEXT:    fctid f0, f21
; FAST-NEXT:    mtvsrd v2, r3
; FAST-NEXT:    mffprd r3, f4
; FAST-NEXT:    mtvsrd v3, r3
; FAST-NEXT:    mffprd r3, f5
; FAST-NEXT:    mtfprd f5, r3
; FAST-NEXT:    mffprd r3, f6
; FAST-NEXT:    mtfprd f1, r3
; FAST-NEXT:    mffprd r3, f7
; FAST-NEXT:    mtfprd f6, r3
; FAST-NEXT:    mffprd r3, f8
; FAST-NEXT:    mtfprd f7, r3
; FAST-NEXT:    mffprd r3, f9
; FAST-NEXT:    mtfprd f3, r3
; FAST-NEXT:    mffprd r3, f10
; FAST-NEXT:    mtfprd f4, r3
; FAST-NEXT:    mffprd r3, f11
; FAST-NEXT:    fctid f11, f31
; FAST-NEXT:    lfd f31, 56(r1) # 8-byte Folded Reload
; FAST-NEXT:    mtfprd f8, r3
; FAST-NEXT:    mffprd r3, f12
; FAST-NEXT:    xxlor f12, v24, v24
; FAST-NEXT:    fctid f31, f31
; FAST-NEXT:    fctid f12, f12
; FAST-NEXT:    mtfprd f9, r3
; FAST-NEXT:    mffprd r3, f13
; FAST-NEXT:    lfd f13, 48(r1) # 8-byte Folded Reload
; FAST-NEXT:    mtfprd f10, r3
; FAST-NEXT:    fctid f13, f13
; FAST-NEXT:    xxmrghd v3, vs5, v3
; FAST-NEXT:    fctid f5, f26
; FAST-NEXT:    mffprd r3, f5
; FAST-NEXT:    mtfprd f5, r3
; FAST-NEXT:    xxmrghd v4, vs7, vs6
; FAST-NEXT:    fctid f6, f27
; FAST-NEXT:    fctid f7, f28
; FAST-NEXT:    mffprd r3, f6
; FAST-NEXT:    lfd f28, 96(r1) # 8-byte Folded Reload
; FAST-NEXT:    fctid f28, f28
; FAST-NEXT:    mtfprd f6, r3
; FAST-NEXT:    mffprd r3, f7
; FAST-NEXT:    mtfprd f7, r3
; FAST-NEXT:    xxmrghd v2, v2, vs10
; FAST-NEXT:    fctid f10, f30
; FAST-NEXT:    mffprd r3, f10
; FAST-NEXT:    lfd f30, 80(r1) # 8-byte Folded Reload
; FAST-NEXT:    fctid f30, f30
; FAST-NEXT:    mtfprd f10, r3
; FAST-NEXT:    mffprd r3, f11
; FAST-NEXT:    mtfprd f11, r3
; FAST-NEXT:    mffprd r3, f12
; FAST-NEXT:    mtfprd f12, r3
; FAST-NEXT:    xxmrghd v5, vs12, vs11
; FAST-NEXT:    xxlor f11, v20, v20
; FAST-NEXT:    xxlor f12, v21, v21
; FAST-NEXT:    fctid f11, f11
; FAST-NEXT:    fctid f12, f12
; FAST-NEXT:    mffprd r3, f11
; FAST-NEXT:    mtfprd f11, r3
; FAST-NEXT:    mffprd r3, f12
; FAST-NEXT:    mtfprd f12, r3
; FAST-NEXT:    mffprd r3, f13
; FAST-NEXT:    mtfprd f13, r3
; FAST-NEXT:    mffprd r3, f31
; FAST-NEXT:    lfd f31, 64(r1) # 8-byte Folded Reload
; FAST-NEXT:    fctid f31, f31
; FAST-NEXT:    mtvsrd v0, r3
; FAST-NEXT:    mffprd r3, f31
; FAST-NEXT:    lfd f31, 72(r1) # 8-byte Folded Reload
; FAST-NEXT:    mtvsrd v1, r3
; FAST-NEXT:    mffprd r3, f30
; FAST-NEXT:    lfd f30, 88(r1) # 8-byte Folded Reload
; FAST-NEXT:    fctid f31, f31
; FAST-NEXT:    mtvsrd v6, r3
; FAST-NEXT:    mffprd r3, f28
; FAST-NEXT:    lfd f28, 104(r1) # 8-byte Folded Reload
; FAST-NEXT:    fctid f30, f30
; FAST-NEXT:    fctid f28, f28
; FAST-NEXT:    mtvsrd v7, r3
; FAST-NEXT:    mffprd r3, f28
; FAST-NEXT:    lfd f28, 112(r1) # 8-byte Folded Reload
; FAST-NEXT:    fctid f28, f28
; FAST-NEXT:    mtvsrd v8, r3
; FAST-NEXT:    mffprd r3, f28
; FAST-NEXT:    lfd f28, 120(r1) # 8-byte Folded Reload
; FAST-NEXT:    fctid f28, f28
; FAST-NEXT:    xxmrghd v10, vs12, vs11
; FAST-NEXT:    xxmrghd v0, v0, vs13
; FAST-NEXT:    xxswapd vs12, v0
; FAST-NEXT:    xxmrghd v0, vs9, vs8
; FAST-NEXT:    xxmrghd v7, v8, v7
; FAST-NEXT:    mtvsrd v8, r3
; FAST-NEXT:    mffprd r3, f28
; FAST-NEXT:    mtvsrd v9, r3
; FAST-NEXT:    mffprd r3, f30
; FAST-NEXT:    xxswapd v7, v7
; FAST-NEXT:    xxmrghd v8, v9, v8
; FAST-NEXT:    mtvsrd v9, r3
; FAST-NEXT:    mffprd r3, f31
; FAST-NEXT:    xxswapd v8, v8
; FAST-NEXT:    xxmrghd v6, v9, v6
; FAST-NEXT:    mtvsrd v9, r3
; FAST-NEXT:    li r3, 240
; FAST-NEXT:    stxvd2x v8, r30, r3
; FAST-NEXT:    li r3, 224
; FAST-NEXT:    stxvd2x v7, r30, r3
; FAST-NEXT:    li r3, 208
; FAST-NEXT:    xxswapd vs11, v6
; FAST-NEXT:    xxmrghd v6, vs10, vs7
; FAST-NEXT:    stxvd2x vs11, r30, r3
; FAST-NEXT:    li r3, 192
; FAST-NEXT:    xxmrghd v1, v9, v1
; FAST-NEXT:    xxswapd vs11, v1
; FAST-NEXT:    xxmrghd v1, vs6, vs5
; FAST-NEXT:    xxswapd vs5, v10
; FAST-NEXT:    xxswapd vs6, v5
; FAST-NEXT:    stxvd2x vs11, r30, r3
; FAST-NEXT:    li r3, 176
; FAST-NEXT:    stxvd2x vs12, r30, r3
; FAST-NEXT:    li r3, 160
; FAST-NEXT:    stxvd2x vs5, r30, r3
; FAST-NEXT:    li r3, 144
; FAST-NEXT:    stxvd2x vs6, r30, r3
; FAST-NEXT:    mffprd r3, f2
; FAST-NEXT:    mtfprd f7, r3
; FAST-NEXT:    li r3, 128
; FAST-NEXT:    xxswapd vs5, v6
; FAST-NEXT:    stxvd2x vs5, r30, r3
; FAST-NEXT:    li r3, 112
; FAST-NEXT:    xxswapd vs2, v1
; FAST-NEXT:    xxswapd vs6, v0
; FAST-NEXT:    stxvd2x vs2, r30, r3
; FAST-NEXT:    li r3, 96
; FAST-NEXT:    fctid f2, f29
; FAST-NEXT:    stxvd2x vs6, r30, r3
; FAST-NEXT:    mffprd r3, f0
; FAST-NEXT:    mtfprd f0, r3
; FAST-NEXT:    mffprd r3, f2
; FAST-NEXT:    mtfprd f2, r3
; FAST-NEXT:    li r3, 80
; FAST-NEXT:    xxmrghd v5, vs7, vs4
; FAST-NEXT:    xxswapd vs4, v2
; FAST-NEXT:    xxmrghd v0, vs0, vs3
; FAST-NEXT:    xxswapd vs0, v5
; FAST-NEXT:    xxswapd vs3, v3
; FAST-NEXT:    stxvd2x vs0, r30, r3
; FAST-NEXT:    li r3, 64
; FAST-NEXT:    xxswapd vs0, v0
; FAST-NEXT:    stxvd2x vs0, r30, r3
; FAST-NEXT:    li r3, 48
; FAST-NEXT:    xxmrghd v5, vs2, vs1
; FAST-NEXT:    xxswapd vs1, v4
; FAST-NEXT:    stxvd2x vs1, r30, r3
; FAST-NEXT:    li r3, 32
; FAST-NEXT:    xxswapd vs2, v5
; FAST-NEXT:    stxvd2x vs2, r30, r3
; FAST-NEXT:    li r3, 16
; FAST-NEXT:    stxvd2x vs3, r30, r3
; FAST-NEXT:    li r3, 304
; FAST-NEXT:    stxvd2x vs4, 0, r30
; FAST-NEXT:    lfd f31, 472(r1) # 8-byte Folded Reload
; FAST-NEXT:    lfd f30, 464(r1) # 8-byte Folded Reload
; FAST-NEXT:    lfd f29, 456(r1) # 8-byte Folded Reload
; FAST-NEXT:    lfd f28, 448(r1) # 8-byte Folded Reload
; FAST-NEXT:    lfd f27, 440(r1) # 8-byte Folded Reload
; FAST-NEXT:    lfd f26, 432(r1) # 8-byte Folded Reload
; FAST-NEXT:    lfd f25, 424(r1) # 8-byte Folded Reload
; FAST-NEXT:    lfd f24, 416(r1) # 8-byte Folded Reload
; FAST-NEXT:    lfd f23, 408(r1) # 8-byte Folded Reload
; FAST-NEXT:    lfd f22, 400(r1) # 8-byte Folded Reload
; FAST-NEXT:    lfd f21, 392(r1) # 8-byte Folded Reload
; FAST-NEXT:    lfd f20, 384(r1) # 8-byte Folded Reload
; FAST-NEXT:    lfd f19, 376(r1) # 8-byte Folded Reload
; FAST-NEXT:    lfd f18, 368(r1) # 8-byte Folded Reload
; FAST-NEXT:    lfd f17, 360(r1) # 8-byte Folded Reload
; FAST-NEXT:    lfd f16, 352(r1) # 8-byte Folded Reload
; FAST-NEXT:    lfd f15, 344(r1) # 8-byte Folded Reload
; FAST-NEXT:    lfd f14, 336(r1) # 8-byte Folded Reload
; FAST-NEXT:    lvx v31, r1, r3 # 16-byte Folded Reload
; FAST-NEXT:    li r3, 288
; FAST-NEXT:    ld r30, 320(r1) # 8-byte Folded Reload
; FAST-NEXT:    lvx v30, r1, r3 # 16-byte Folded Reload
; FAST-NEXT:    li r3, 272
; FAST-NEXT:    lvx v29, r1, r3 # 16-byte Folded Reload
; FAST-NEXT:    li r3, 256
; FAST-NEXT:    lvx v28, r1, r3 # 16-byte Folded Reload
; FAST-NEXT:    li r3, 240
; FAST-NEXT:    lvx v27, r1, r3 # 16-byte Folded Reload
; FAST-NEXT:    li r3, 224
; FAST-NEXT:    lvx v26, r1, r3 # 16-byte Folded Reload
; FAST-NEXT:    li r3, 208
; FAST-NEXT:    lvx v25, r1, r3 # 16-byte Folded Reload
; FAST-NEXT:    li r3, 192
; FAST-NEXT:    lvx v24, r1, r3 # 16-byte Folded Reload
; FAST-NEXT:    li r3, 176
; FAST-NEXT:    lvx v23, r1, r3 # 16-byte Folded Reload
; FAST-NEXT:    li r3, 160
; FAST-NEXT:    lvx v22, r1, r3 # 16-byte Folded Reload
; FAST-NEXT:    li r3, 144
; FAST-NEXT:    lvx v21, r1, r3 # 16-byte Folded Reload
; FAST-NEXT:    li r3, 128
; FAST-NEXT:    lvx v20, r1, r3 # 16-byte Folded Reload
; FAST-NEXT:    addi r1, r1, 480
; FAST-NEXT:    ld r0, 16(r1)
; FAST-NEXT:    mtlr r0
; FAST-NEXT:    blr
  %a = call <32 x i64> @llvm.lrint.v32i64.v32f16(<32 x half> %x)
  ret <32 x i64> %a
}
declare <32 x i64> @llvm.lrint.v32i64.v32f16(<32 x half>)

define <1 x i64> @lrint_v1f32(<1 x float> %x) {
; BE-LABEL: lrint_v1f32:
; BE:       # %bb.0:
; BE-NEXT:    mflr r0
; BE-NEXT:    stdu r1, -112(r1)
; BE-NEXT:    std r0, 128(r1)
; BE-NEXT:    .cfi_def_cfa_offset 112
; BE-NEXT:    .cfi_offset lr, 16
; BE-NEXT:    bl lrintf
; BE-NEXT:    nop
; BE-NEXT:    addi r1, r1, 112
; BE-NEXT:    ld r0, 16(r1)
; BE-NEXT:    mtlr r0
; BE-NEXT:    blr
;
; CHECK-LABEL: lrint_v1f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    mflr r0
; CHECK-NEXT:    stdu r1, -32(r1)
; CHECK-NEXT:    std r0, 48(r1)
; CHECK-NEXT:    .cfi_def_cfa_offset 32
; CHECK-NEXT:    .cfi_offset lr, 16
; CHECK-NEXT:    bl lrintf
; CHECK-NEXT:    nop
; CHECK-NEXT:    addi r1, r1, 32
; CHECK-NEXT:    ld r0, 16(r1)
; CHECK-NEXT:    mtlr r0
; CHECK-NEXT:    blr
;
; FAST-LABEL: lrint_v1f32:
; FAST:       # %bb.0:
; FAST-NEXT:    fctid f0, f1
; FAST-NEXT:    mffprd r3, f0
; FAST-NEXT:    blr
  %a = call <1 x i64> @llvm.lrint.v1i64.v1f32(<1 x float> %x)
  ret <1 x i64> %a
}
declare <1 x i64> @llvm.lrint.v1i64.v1f32(<1 x float>)

define <2 x i64> @lrint_v2f32(<2 x float> %x) {
; BE-LABEL: lrint_v2f32:
; BE:       # %bb.0:
; BE-NEXT:    mflr r0
; BE-NEXT:    stdu r1, -144(r1)
; BE-NEXT:    std r0, 160(r1)
; BE-NEXT:    .cfi_def_cfa_offset 144
; BE-NEXT:    .cfi_offset lr, 16
; BE-NEXT:    addi r3, r1, 112
; BE-NEXT:    stxvw4x v2, 0, r3
; BE-NEXT:    lfs f1, 116(r1)
; BE-NEXT:    bl lrintf
; BE-NEXT:    nop
; BE-NEXT:    lfs f1, 112(r1)
; BE-NEXT:    std r3, 136(r1)
; BE-NEXT:    bl lrintf
; BE-NEXT:    nop
; BE-NEXT:    std r3, 128(r1)
; BE-NEXT:    addi r3, r1, 128
; BE-NEXT:    lxvd2x v2, 0, r3
; BE-NEXT:    addi r1, r1, 144
; BE-NEXT:    ld r0, 16(r1)
; BE-NEXT:    mtlr r0
; BE-NEXT:    blr
;
; CHECK-LABEL: lrint_v2f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    mflr r0
; CHECK-NEXT:    stdu r1, -64(r1)
; CHECK-NEXT:    std r0, 80(r1)
; CHECK-NEXT:    .cfi_def_cfa_offset 64
; CHECK-NEXT:    .cfi_offset lr, 16
; CHECK-NEXT:    .cfi_offset v31, -16
; CHECK-NEXT:    xxsldwi vs0, v2, v2, 3
; CHECK-NEXT:    li r3, 48
; CHECK-NEXT:    xscvspdpn f1, vs0
; CHECK-NEXT:    stvx v31, r1, r3 # 16-byte Folded Spill
; CHECK-NEXT:    vmr v31, v2
; CHECK-NEXT:    bl lrintf
; CHECK-NEXT:    nop
; CHECK-NEXT:    xxswapd vs0, v31
; CHECK-NEXT:    mtvsrd v31, r3
; CHECK-NEXT:    xscvspdpn f1, vs0
; CHECK-NEXT:    bl lrintf
; CHECK-NEXT:    nop
; CHECK-NEXT:    mtfprd f0, r3
; CHECK-NEXT:    li r3, 48
; CHECK-NEXT:    xxmrghd v2, vs0, v31
; CHECK-NEXT:    lvx v31, r1, r3 # 16-byte Folded Reload
; CHECK-NEXT:    addi r1, r1, 64
; CHECK-NEXT:    ld r0, 16(r1)
; CHECK-NEXT:    mtlr r0
; CHECK-NEXT:    blr
;
; FAST-LABEL: lrint_v2f32:
; FAST:       # %bb.0:
; FAST-NEXT:    xxsldwi vs0, v2, v2, 3
; FAST-NEXT:    xxswapd vs1, v2
; FAST-NEXT:    xscvspdpn f0, vs0
; FAST-NEXT:    xscvspdpn f1, vs1
; FAST-NEXT:    fctid f0, f0
; FAST-NEXT:    fctid f1, f1
; FAST-NEXT:    mffprd r3, f0
; FAST-NEXT:    mtfprd f0, r3
; FAST-NEXT:    mffprd r3, f1
; FAST-NEXT:    mtfprd f1, r3
; FAST-NEXT:    xxmrghd v2, vs1, vs0
; FAST-NEXT:    blr
  %a = call <2 x i64> @llvm.lrint.v2i64.v2f32(<2 x float> %x)
  ret <2 x i64> %a
}
declare <2 x i64> @llvm.lrint.v2i64.v2f32(<2 x float>)

define <4 x i64> @lrint_v4f32(<4 x float> %x) {
; BE-LABEL: lrint_v4f32:
; BE:       # %bb.0:
; BE-NEXT:    mflr r0
; BE-NEXT:    stdu r1, -160(r1)
; BE-NEXT:    std r0, 176(r1)
; BE-NEXT:    .cfi_def_cfa_offset 160
; BE-NEXT:    .cfi_offset lr, 16
; BE-NEXT:    addi r3, r1, 112
; BE-NEXT:    stxvw4x v2, 0, r3
; BE-NEXT:    lfs f1, 116(r1)
; BE-NEXT:    bl lrintf
; BE-NEXT:    nop
; BE-NEXT:    lfs f1, 112(r1)
; BE-NEXT:    std r3, 136(r1)
; BE-NEXT:    bl lrintf
; BE-NEXT:    nop
; BE-NEXT:    lfs f1, 124(r1)
; BE-NEXT:    std r3, 128(r1)
; BE-NEXT:    bl lrintf
; BE-NEXT:    nop
; BE-NEXT:    lfs f1, 120(r1)
; BE-NEXT:    std r3, 152(r1)
; BE-NEXT:    bl lrintf
; BE-NEXT:    nop
; BE-NEXT:    std r3, 144(r1)
; BE-NEXT:    addi r3, r1, 128
; BE-NEXT:    lxvd2x v2, 0, r3
; BE-NEXT:    addi r3, r1, 144
; BE-NEXT:    lxvd2x v3, 0, r3
; BE-NEXT:    addi r1, r1, 160
; BE-NEXT:    ld r0, 16(r1)
; BE-NEXT:    mtlr r0
; BE-NEXT:    blr
;
; CHECK-LABEL: lrint_v4f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    mflr r0
; CHECK-NEXT:    stdu r1, -80(r1)
; CHECK-NEXT:    std r0, 96(r1)
; CHECK-NEXT:    .cfi_def_cfa_offset 80
; CHECK-NEXT:    .cfi_offset lr, 16
; CHECK-NEXT:    .cfi_offset v30, -32
; CHECK-NEXT:    .cfi_offset v31, -16
; CHECK-NEXT:    xxsldwi vs0, v2, v2, 3
; CHECK-NEXT:    li r3, 48
; CHECK-NEXT:    xscvspdpn f1, vs0
; CHECK-NEXT:    stvx v30, r1, r3 # 16-byte Folded Spill
; CHECK-NEXT:    li r3, 64
; CHECK-NEXT:    stvx v31, r1, r3 # 16-byte Folded Spill
; CHECK-NEXT:    vmr v31, v2
; CHECK-NEXT:    bl lrintf
; CHECK-NEXT:    nop
; CHECK-NEXT:    xxswapd vs0, v31
; CHECK-NEXT:    mtvsrd v30, r3
; CHECK-NEXT:    xscvspdpn f1, vs0
; CHECK-NEXT:    bl lrintf
; CHECK-NEXT:    nop
; CHECK-NEXT:    xscvspdpn f1, v31
; CHECK-NEXT:    mtfprd f0, r3
; CHECK-NEXT:    xxmrghd v30, vs0, v30
; CHECK-NEXT:    bl lrintf
; CHECK-NEXT:    nop
; CHECK-NEXT:    xxsldwi vs0, v31, v31, 1
; CHECK-NEXT:    mtvsrd v31, r3
; CHECK-NEXT:    xscvspdpn f1, vs0
; CHECK-NEXT:    bl lrintf
; CHECK-NEXT:    nop
; CHECK-NEXT:    mtfprd f0, r3
; CHECK-NEXT:    li r3, 64
; CHECK-NEXT:    vmr v2, v30
; CHECK-NEXT:    xxmrghd v3, v31, vs0
; CHECK-NEXT:    lvx v31, r1, r3 # 16-byte Folded Reload
; CHECK-NEXT:    li r3, 48
; CHECK-NEXT:    lvx v30, r1, r3 # 16-byte Folded Reload
; CHECK-NEXT:    addi r1, r1, 80
; CHECK-NEXT:    ld r0, 16(r1)
; CHECK-NEXT:    mtlr r0
; CHECK-NEXT:    blr
;
; FAST-LABEL: lrint_v4f32:
; FAST:       # %bb.0:
; FAST-NEXT:    xxsldwi vs0, v2, v2, 3
; FAST-NEXT:    xxswapd vs1, v2
; FAST-NEXT:    xscvspdpn f0, vs0
; FAST-NEXT:    xxsldwi vs2, v2, v2, 1
; FAST-NEXT:    fctid f0, f0
; FAST-NEXT:    mffprd r3, f0
; FAST-NEXT:    xscvspdpn f0, vs1
; FAST-NEXT:    mtfprd f1, r3
; FAST-NEXT:    fctid f0, f0
; FAST-NEXT:    mffprd r3, f0
; FAST-NEXT:    mtfprd f0, r3
; FAST-NEXT:    xxmrghd v4, vs0, vs1
; FAST-NEXT:    xscvspdpn f0, v2
; FAST-NEXT:    vmr v2, v4
; FAST-NEXT:    fctid f0, f0
; FAST-NEXT:    mffprd r3, f0
; FAST-NEXT:    xscvspdpn f0, vs2
; FAST-NEXT:    mtfprd f1, r3
; FAST-NEXT:    fctid f0, f0
; FAST-NEXT:    mffprd r3, f0
; FAST-NEXT:    mtfprd f0, r3
; FAST-NEXT:    xxmrghd v3, vs1, vs0
; FAST-NEXT:    blr
  %a = call <4 x i64> @llvm.lrint.v4i64.v4f32(<4 x float> %x)
  ret <4 x i64> %a
}
declare <4 x i64> @llvm.lrint.v4i64.v4f32(<4 x float>)

define <8 x i64> @lrint_v8f32(<8 x float> %x) {
; BE-LABEL: lrint_v8f32:
; BE:       # %bb.0:
; BE-NEXT:    mflr r0
; BE-NEXT:    stdu r1, -208(r1)
; BE-NEXT:    std r0, 224(r1)
; BE-NEXT:    .cfi_def_cfa_offset 208
; BE-NEXT:    .cfi_offset lr, 16
; BE-NEXT:    addi r3, r1, 112
; BE-NEXT:    stxvw4x v2, 0, r3
; BE-NEXT:    addi r3, r1, 128
; BE-NEXT:    stxvw4x v3, 0, r3
; BE-NEXT:    lfs f1, 116(r1)
; BE-NEXT:    bl lrintf
; BE-NEXT:    nop
; BE-NEXT:    lfs f1, 112(r1)
; BE-NEXT:    std r3, 152(r1)
; BE-NEXT:    bl lrintf
; BE-NEXT:    nop
; BE-NEXT:    lfs f1, 124(r1)
; BE-NEXT:    std r3, 144(r1)
; BE-NEXT:    bl lrintf
; BE-NEXT:    nop
; BE-NEXT:    lfs f1, 120(r1)
; BE-NEXT:    std r3, 168(r1)
; BE-NEXT:    bl lrintf
; BE-NEXT:    nop
; BE-NEXT:    lfs f1, 132(r1)
; BE-NEXT:    std r3, 160(r1)
; BE-NEXT:    bl lrintf
; BE-NEXT:    nop
; BE-NEXT:    lfs f1, 128(r1)
; BE-NEXT:    std r3, 184(r1)
; BE-NEXT:    bl lrintf
; BE-NEXT:    nop
; BE-NEXT:    lfs f1, 140(r1)
; BE-NEXT:    std r3, 176(r1)
; BE-NEXT:    bl lrintf
; BE-NEXT:    nop
; BE-NEXT:    lfs f1, 136(r1)
; BE-NEXT:    std r3, 200(r1)
; BE-NEXT:    bl lrintf
; BE-NEXT:    nop
; BE-NEXT:    std r3, 192(r1)
; BE-NEXT:    addi r3, r1, 144
; BE-NEXT:    lxvd2x v2, 0, r3
; BE-NEXT:    addi r3, r1, 160
; BE-NEXT:    lxvd2x v3, 0, r3
; BE-NEXT:    addi r3, r1, 176
; BE-NEXT:    lxvd2x v4, 0, r3
; BE-NEXT:    addi r3, r1, 192
; BE-NEXT:    lxvd2x v5, 0, r3
; BE-NEXT:    addi r1, r1, 208
; BE-NEXT:    ld r0, 16(r1)
; BE-NEXT:    mtlr r0
; BE-NEXT:    blr
;
; CHECK-LABEL: lrint_v8f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    mflr r0
; CHECK-NEXT:    stdu r1, -112(r1)
; CHECK-NEXT:    std r0, 128(r1)
; CHECK-NEXT:    .cfi_def_cfa_offset 112
; CHECK-NEXT:    .cfi_offset lr, 16
; CHECK-NEXT:    .cfi_offset v28, -64
; CHECK-NEXT:    .cfi_offset v29, -48
; CHECK-NEXT:    .cfi_offset v30, -32
; CHECK-NEXT:    .cfi_offset v31, -16
; CHECK-NEXT:    li r3, 48
; CHECK-NEXT:    xxsldwi vs0, v2, v2, 3
; CHECK-NEXT:    stvx v28, r1, r3 # 16-byte Folded Spill
; CHECK-NEXT:    li r3, 64
; CHECK-NEXT:    xscvspdpn f1, vs0
; CHECK-NEXT:    stvx v29, r1, r3 # 16-byte Folded Spill
; CHECK-NEXT:    li r3, 80
; CHECK-NEXT:    stvx v30, r1, r3 # 16-byte Folded Spill
; CHECK-NEXT:    li r3, 96
; CHECK-NEXT:    vmr v30, v2
; CHECK-NEXT:    stvx v31, r1, r3 # 16-byte Folded Spill
; CHECK-NEXT:    vmr v31, v3
; CHECK-NEXT:    bl lrintf
; CHECK-NEXT:    nop
; CHECK-NEXT:    xxswapd vs0, v30
; CHECK-NEXT:    mtvsrd v29, r3
; CHECK-NEXT:    xscvspdpn f1, vs0
; CHECK-NEXT:    bl lrintf
; CHECK-NEXT:    nop
; CHECK-NEXT:    xscvspdpn f1, v30
; CHECK-NEXT:    mtfprd f0, r3
; CHECK-NEXT:    xxmrghd v29, vs0, v29
; CHECK-NEXT:    bl lrintf
; CHECK-NEXT:    nop
; CHECK-NEXT:    xxsldwi vs0, v30, v30, 1
; CHECK-NEXT:    mtvsrd v30, r3
; CHECK-NEXT:    xscvspdpn f1, vs0
; CHECK-NEXT:    bl lrintf
; CHECK-NEXT:    nop
; CHECK-NEXT:    mtfprd f0, r3
; CHECK-NEXT:    xxmrghd v30, v30, vs0
; CHECK-NEXT:    xxsldwi vs0, v31, v31, 3
; CHECK-NEXT:    xscvspdpn f1, vs0
; CHECK-NEXT:    bl lrintf
; CHECK-NEXT:    nop
; CHECK-NEXT:    xxswapd vs0, v31
; CHECK-NEXT:    mtvsrd v28, r3
; CHECK-NEXT:    xscvspdpn f1, vs0
; CHECK-NEXT:    bl lrintf
; CHECK-NEXT:    nop
; CHECK-NEXT:    xscvspdpn f1, v31
; CHECK-NEXT:    mtfprd f0, r3
; CHECK-NEXT:    xxmrghd v28, vs0, v28
; CHECK-NEXT:    bl lrintf
; CHECK-NEXT:    nop
; CHECK-NEXT:    xxsldwi vs0, v31, v31, 1
; CHECK-NEXT:    mtvsrd v31, r3
; CHECK-NEXT:    xscvspdpn f1, vs0
; CHECK-NEXT:    bl lrintf
; CHECK-NEXT:    nop
; CHECK-NEXT:    mtfprd f0, r3
; CHECK-NEXT:    li r3, 96
; CHECK-NEXT:    vmr v3, v30
; CHECK-NEXT:    vmr v2, v29
; CHECK-NEXT:    vmr v4, v28
; CHECK-NEXT:    xxmrghd v5, v31, vs0
; CHECK-NEXT:    lvx v31, r1, r3 # 16-byte Folded Reload
; CHECK-NEXT:    li r3, 80
; CHECK-NEXT:    lvx v30, r1, r3 # 16-byte Folded Reload
; CHECK-NEXT:    li r3, 64
; CHECK-NEXT:    lvx v29, r1, r3 # 16-byte Folded Reload
; CHECK-NEXT:    li r3, 48
; CHECK-NEXT:    lvx v28, r1, r3 # 16-byte Folded Reload
; CHECK-NEXT:    addi r1, r1, 112
; CHECK-NEXT:    ld r0, 16(r1)
; CHECK-NEXT:    mtlr r0
; CHECK-NEXT:    blr
;
; FAST-LABEL: lrint_v8f32:
; FAST:       # %bb.0:
; FAST-NEXT:    xxsldwi vs0, v2, v2, 3
; FAST-NEXT:    xxswapd vs1, v2
; FAST-NEXT:    xscvspdpn f0, vs0
; FAST-NEXT:    xxsldwi vs2, v2, v2, 1
; FAST-NEXT:    xxsldwi vs3, v3, v3, 3
; FAST-NEXT:    xxswapd vs4, v3
; FAST-NEXT:    xxsldwi vs5, v3, v3, 1
; FAST-NEXT:    fctid f0, f0
; FAST-NEXT:    mffprd r3, f0
; FAST-NEXT:    xscvspdpn f0, vs1
; FAST-NEXT:    mtfprd f1, r3
; FAST-NEXT:    fctid f0, f0
; FAST-NEXT:    mffprd r3, f0
; FAST-NEXT:    mtfprd f0, r3
; FAST-NEXT:    xxmrghd v0, vs0, vs1
; FAST-NEXT:    xscvspdpn f0, v2
; FAST-NEXT:    vmr v2, v0
; FAST-NEXT:    fctid f0, f0
; FAST-NEXT:    mffprd r3, f0
; FAST-NEXT:    xscvspdpn f0, vs2
; FAST-NEXT:    mtfprd f1, r3
; FAST-NEXT:    fctid f0, f0
; FAST-NEXT:    mffprd r3, f0
; FAST-NEXT:    mtfprd f0, r3
; FAST-NEXT:    xxmrghd v1, vs1, vs0
; FAST-NEXT:    xscvspdpn f0, vs3
; FAST-NEXT:    fctid f0, f0
; FAST-NEXT:    mffprd r3, f0
; FAST-NEXT:    xscvspdpn f0, vs4
; FAST-NEXT:    mtfprd f1, r3
; FAST-NEXT:    fctid f0, f0
; FAST-NEXT:    mffprd r3, f0
; FAST-NEXT:    mtfprd f0, r3
; FAST-NEXT:    xxmrghd v4, vs0, vs1
; FAST-NEXT:    xscvspdpn f0, v3
; FAST-NEXT:    vmr v3, v1
; FAST-NEXT:    fctid f0, f0
; FAST-NEXT:    mffprd r3, f0
; FAST-NEXT:    xscvspdpn f0, vs5
; FAST-NEXT:    mtfprd f1, r3
; FAST-NEXT:    fctid f0, f0
; FAST-NEXT:    mffprd r3, f0
; FAST-NEXT:    mtfprd f0, r3
; FAST-NEXT:    xxmrghd v5, vs1, vs0
; FAST-NEXT:    blr
  %a = call <8 x i64> @llvm.lrint.v8i64.v8f32(<8 x float> %x)
  ret <8 x i64> %a
}
declare <8 x i64> @llvm.lrint.v8i64.v8f32(<8 x float>)

define <16 x i64> @lrint_v16i64_v16f32(<16 x float> %x) {
; BE-LABEL: lrint_v16i64_v16f32:
; BE:       # %bb.0:
; BE-NEXT:    mflr r0
; BE-NEXT:    stdu r1, -304(r1)
; BE-NEXT:    std r0, 320(r1)
; BE-NEXT:    .cfi_def_cfa_offset 304
; BE-NEXT:    .cfi_offset lr, 16
; BE-NEXT:    addi r3, r1, 112
; BE-NEXT:    stxvw4x v2, 0, r3
; BE-NEXT:    addi r3, r1, 128
; BE-NEXT:    stxvw4x v3, 0, r3
; BE-NEXT:    addi r3, r1, 144
; BE-NEXT:    stxvw4x v4, 0, r3
; BE-NEXT:    addi r3, r1, 160
; BE-NEXT:    stxvw4x v5, 0, r3
; BE-NEXT:    lfs f1, 116(r1)
; BE-NEXT:    bl lrintf
; BE-NEXT:    nop
; BE-NEXT:    lfs f1, 112(r1)
; BE-NEXT:    std r3, 184(r1)
; BE-NEXT:    bl lrintf
; BE-NEXT:    nop
; BE-NEXT:    lfs f1, 124(r1)
; BE-NEXT:    std r3, 176(r1)
; BE-NEXT:    bl lrintf
; BE-NEXT:    nop
; BE-NEXT:    lfs f1, 120(r1)
; BE-NEXT:    std r3, 200(r1)
; BE-NEXT:    bl lrintf
; BE-NEXT:    nop
; BE-NEXT:    lfs f1, 132(r1)
; BE-NEXT:    std r3, 192(r1)
; BE-NEXT:    bl lrintf
; BE-NEXT:    nop
; BE-NEXT:    lfs f1, 128(r1)
; BE-NEXT:    std r3, 216(r1)
; BE-NEXT:    bl lrintf
; BE-NEXT:    nop
; BE-NEXT:    lfs f1, 140(r1)
; BE-NEXT:    std r3, 208(r1)
; BE-NEXT:    bl lrintf
; BE-NEXT:    nop
; BE-NEXT:    lfs f1, 136(r1)
; BE-NEXT:    std r3, 232(r1)
; BE-NEXT:    bl lrintf
; BE-NEXT:    nop
; BE-NEXT:    lfs f1, 148(r1)
; BE-NEXT:    std r3, 224(r1)
; BE-NEXT:    bl lrintf
; BE-NEXT:    nop
; BE-NEXT:    lfs f1, 144(r1)
; BE-NEXT:    std r3, 248(r1)
; BE-NEXT:    bl lrintf
; BE-NEXT:    nop
; BE-NEXT:    lfs f1, 156(r1)
; BE-NEXT:    std r3, 240(r1)
; BE-NEXT:    bl lrintf
; BE-NEXT:    nop
; BE-NEXT:    lfs f1, 152(r1)
; BE-NEXT:    std r3, 264(r1)
; BE-NEXT:    bl lrintf
; BE-NEXT:    nop
; BE-NEXT:    lfs f1, 164(r1)
; BE-NEXT:    std r3, 256(r1)
; BE-NEXT:    bl lrintf
; BE-NEXT:    nop
; BE-NEXT:    lfs f1, 160(r1)
; BE-NEXT:    std r3, 280(r1)
; BE-NEXT:    bl lrintf
; BE-NEXT:    nop
; BE-NEXT:    lfs f1, 172(r1)
; BE-NEXT:    std r3, 272(r1)
; BE-NEXT:    bl lrintf
; BE-NEXT:    nop
; BE-NEXT:    lfs f1, 168(r1)
; BE-NEXT:    std r3, 296(r1)
; BE-NEXT:    bl lrintf
; BE-NEXT:    nop
; BE-NEXT:    std r3, 288(r1)
; BE-NEXT:    addi r3, r1, 176
; BE-NEXT:    lxvd2x v2, 0, r3
; BE-NEXT:    addi r3, r1, 192
; BE-NEXT:    lxvd2x v3, 0, r3
; BE-NEXT:    addi r3, r1, 208
; BE-NEXT:    lxvd2x v4, 0, r3
; BE-NEXT:    addi r3, r1, 224
; BE-NEXT:    lxvd2x v5, 0, r3
; BE-NEXT:    addi r3, r1, 240
; BE-NEXT:    lxvd2x v6, 0, r3
; BE-NEXT:    addi r3, r1, 256
; BE-NEXT:    lxvd2x v7, 0, r3
; BE-NEXT:    addi r3, r1, 272
; BE-NEXT:    lxvd2x v8, 0, r3
; BE-NEXT:    addi r3, r1, 288
; BE-NEXT:    lxvd2x v9, 0, r3
; BE-NEXT:    addi r1, r1, 304
; BE-NEXT:    ld r0, 16(r1)
; BE-NEXT:    mtlr r0
; BE-NEXT:    blr
;
; CHECK-LABEL: lrint_v16i64_v16f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    mflr r0
; CHECK-NEXT:    stdu r1, -176(r1)
; CHECK-NEXT:    std r0, 192(r1)
; CHECK-NEXT:    .cfi_def_cfa_offset 176
; CHECK-NEXT:    .cfi_offset lr, 16
; CHECK-NEXT:    .cfi_offset v24, -128
; CHECK-NEXT:    .cfi_offset v25, -112
; CHECK-NEXT:    .cfi_offset v26, -96
; CHECK-NEXT:    .cfi_offset v27, -80
; CHECK-NEXT:    .cfi_offset v28, -64
; CHECK-NEXT:    .cfi_offset v29, -48
; CHECK-NEXT:    .cfi_offset v30, -32
; CHECK-NEXT:    .cfi_offset v31, -16
; CHECK-NEXT:    li r3, 48
; CHECK-NEXT:    xxsldwi vs0, v2, v2, 3
; CHECK-NEXT:    stvx v24, r1, r3 # 16-byte Folded Spill
; CHECK-NEXT:    li r3, 64
; CHECK-NEXT:    xscvspdpn f1, vs0
; CHECK-NEXT:    stvx v25, r1, r3 # 16-byte Folded Spill
; CHECK-NEXT:    li r3, 80
; CHECK-NEXT:    stvx v26, r1, r3 # 16-byte Folded Spill
; CHECK-NEXT:    li r3, 96
; CHECK-NEXT:    vmr v26, v3
; CHECK-NEXT:    stvx v27, r1, r3 # 16-byte Folded Spill
; CHECK-NEXT:    li r3, 112
; CHECK-NEXT:    stvx v28, r1, r3 # 16-byte Folded Spill
; CHECK-NEXT:    li r3, 128
; CHECK-NEXT:    vmr v28, v4
; CHECK-NEXT:    stvx v29, r1, r3 # 16-byte Folded Spill
; CHECK-NEXT:    li r3, 144
; CHECK-NEXT:    vmr v29, v2
; CHECK-NEXT:    stvx v30, r1, r3 # 16-byte Folded Spill
; CHECK-NEXT:    li r3, 160
; CHECK-NEXT:    stvx v31, r1, r3 # 16-byte Folded Spill
; CHECK-NEXT:    vmr v31, v5
; CHECK-NEXT:    bl lrintf
; CHECK-NEXT:    nop
; CHECK-NEXT:    xxswapd vs0, v29
; CHECK-NEXT:    mtvsrd v30, r3
; CHECK-NEXT:    xscvspdpn f1, vs0
; CHECK-NEXT:    bl lrintf
; CHECK-NEXT:    nop
; CHECK-NEXT:    xscvspdpn f1, v29
; CHECK-NEXT:    mtfprd f0, r3
; CHECK-NEXT:    xxmrghd v30, vs0, v30
; CHECK-NEXT:    bl lrintf
; CHECK-NEXT:    nop
; CHECK-NEXT:    xxsldwi vs0, v29, v29, 1
; CHECK-NEXT:    mtvsrd v29, r3
; CHECK-NEXT:    xscvspdpn f1, vs0
; CHECK-NEXT:    bl lrintf
; CHECK-NEXT:    nop
; CHECK-NEXT:    mtfprd f0, r3
; CHECK-NEXT:    xxmrghd v29, v29, vs0
; CHECK-NEXT:    xxsldwi vs0, v26, v26, 3
; CHECK-NEXT:    xscvspdpn f1, vs0
; CHECK-NEXT:    bl lrintf
; CHECK-NEXT:    nop
; CHECK-NEXT:    xxswapd vs0, v26
; CHECK-NEXT:    mtvsrd v27, r3
; CHECK-NEXT:    xscvspdpn f1, vs0
; CHECK-NEXT:    bl lrintf
; CHECK-NEXT:    nop
; CHECK-NEXT:    xscvspdpn f1, v26
; CHECK-NEXT:    mtfprd f0, r3
; CHECK-NEXT:    xxmrghd v27, vs0, v27
; CHECK-NEXT:    bl lrintf
; CHECK-NEXT:    nop
; CHECK-NEXT:    xxsldwi vs0, v26, v26, 1
; CHECK-NEXT:    mtvsrd v26, r3
; CHECK-NEXT:    xscvspdpn f1, vs0
; CHECK-NEXT:    bl lrintf
; CHECK-NEXT:    nop
; CHECK-NEXT:    mtfprd f0, r3
; CHECK-NEXT:    xxmrghd v26, v26, vs0
; CHECK-NEXT:    xxsldwi vs0, v28, v28, 3
; CHECK-NEXT:    xscvspdpn f1, vs0
; CHECK-NEXT:    bl lrintf
; CHECK-NEXT:    nop
; CHECK-NEXT:    xxswapd vs0, v28
; CHECK-NEXT:    mtvsrd v25, r3
; CHECK-NEXT:    xscvspdpn f1, vs0
; CHECK-NEXT:    bl lrintf
; CHECK-NEXT:    nop
; CHECK-NEXT:    xscvspdpn f1, v28
; CHECK-NEXT:    mtfprd f0, r3
; CHECK-NEXT:    xxmrghd v25, vs0, v25
; CHECK-NEXT:    bl lrintf
; CHECK-NEXT:    nop
; CHECK-NEXT:    xxsldwi vs0, v28, v28, 1
; CHECK-NEXT:    mtvsrd v28, r3
; CHECK-NEXT:    xscvspdpn f1, vs0
; CHECK-NEXT:    bl lrintf
; CHECK-NEXT:    nop
; CHECK-NEXT:    mtfprd f0, r3
; CHECK-NEXT:    xxmrghd v28, v28, vs0
; CHECK-NEXT:    xxsldwi vs0, v31, v31, 3
; CHECK-NEXT:    xscvspdpn f1, vs0
; CHECK-NEXT:    bl lrintf
; CHECK-NEXT:    nop
; CHECK-NEXT:    xxswapd vs0, v31
; CHECK-NEXT:    mtvsrd v24, r3
; CHECK-NEXT:    xscvspdpn f1, vs0
; CHECK-NEXT:    bl lrintf
; CHECK-NEXT:    nop
; CHECK-NEXT:    xscvspdpn f1, v31
; CHECK-NEXT:    mtfprd f0, r3
; CHECK-NEXT:    xxmrghd v24, vs0, v24
; CHECK-NEXT:    bl lrintf
; CHECK-NEXT:    nop
; CHECK-NEXT:    xxsldwi vs0, v31, v31, 1
; CHECK-NEXT:    mtvsrd v31, r3
; CHECK-NEXT:    xscvspdpn f1, vs0
; CHECK-NEXT:    bl lrintf
; CHECK-NEXT:    nop
; CHECK-NEXT:    mtfprd f0, r3
; CHECK-NEXT:    li r3, 160
; CHECK-NEXT:    vmr v2, v30
; CHECK-NEXT:    vmr v3, v29
; CHECK-NEXT:    vmr v7, v28
; CHECK-NEXT:    vmr v4, v27
; CHECK-NEXT:    vmr v5, v26
; CHECK-NEXT:    vmr v6, v25
; CHECK-NEXT:    vmr v8, v24
; CHECK-NEXT:    xxmrghd v9, v31, vs0
; CHECK-NEXT:    lvx v31, r1, r3 # 16-byte Folded Reload
; CHECK-NEXT:    li r3, 144
; CHECK-NEXT:    lvx v30, r1, r3 # 16-byte Folded Reload
; CHECK-NEXT:    li r3, 128
; CHECK-NEXT:    lvx v29, r1, r3 # 16-byte Folded Reload
; CHECK-NEXT:    li r3, 112
; CHECK-NEXT:    lvx v28, r1, r3 # 16-byte Folded Reload
; CHECK-NEXT:    li r3, 96
; CHECK-NEXT:    lvx v27, r1, r3 # 16-byte Folded Reload
; CHECK-NEXT:    li r3, 80
; CHECK-NEXT:    lvx v26, r1, r3 # 16-byte Folded Reload
; CHECK-NEXT:    li r3, 64
; CHECK-NEXT:    lvx v25, r1, r3 # 16-byte Folded Reload
; CHECK-NEXT:    li r3, 48
; CHECK-NEXT:    lvx v24, r1, r3 # 16-byte Folded Reload
; CHECK-NEXT:    addi r1, r1, 176
; CHECK-NEXT:    ld r0, 16(r1)
; CHECK-NEXT:    mtlr r0
; CHECK-NEXT:    blr
;
; FAST-LABEL: lrint_v16i64_v16f32:
; FAST:       # %bb.0:
; FAST-NEXT:    xxsldwi vs0, v2, v2, 3
; FAST-NEXT:    xxswapd vs1, v2
; FAST-NEXT:    xscvspdpn f0, vs0
; FAST-NEXT:    xxsldwi vs2, v2, v2, 1
; FAST-NEXT:    xxsldwi vs3, v3, v3, 3
; FAST-NEXT:    xxswapd vs4, v3
; FAST-NEXT:    xxsldwi vs5, v3, v3, 1
; FAST-NEXT:    xxsldwi vs6, v4, v4, 3
; FAST-NEXT:    xxswapd vs7, v4
; FAST-NEXT:    xxsldwi vs8, v4, v4, 1
; FAST-NEXT:    xxsldwi vs9, v5, v5, 3
; FAST-NEXT:    xxswapd vs10, v5
; FAST-NEXT:    xxsldwi vs11, v5, v5, 1
; FAST-NEXT:    fctid f0, f0
; FAST-NEXT:    mffprd r3, f0
; FAST-NEXT:    xscvspdpn f0, vs1
; FAST-NEXT:    mtfprd f1, r3
; FAST-NEXT:    fctid f0, f0
; FAST-NEXT:    mffprd r3, f0
; FAST-NEXT:    mtfprd f0, r3
; FAST-NEXT:    xxmrghd v0, vs0, vs1
; FAST-NEXT:    xscvspdpn f0, v2
; FAST-NEXT:    vmr v2, v0
; FAST-NEXT:    fctid f0, f0
; FAST-NEXT:    mffprd r3, f0
; FAST-NEXT:    xscvspdpn f0, vs2
; FAST-NEXT:    mtfprd f1, r3
; FAST-NEXT:    fctid f0, f0
; FAST-NEXT:    mffprd r3, f0
; FAST-NEXT:    mtfprd f0, r3
; FAST-NEXT:    xxmrghd v1, vs1, vs0
; FAST-NEXT:    xscvspdpn f0, vs3
; FAST-NEXT:    fctid f0, f0
; FAST-NEXT:    mffprd r3, f0
; FAST-NEXT:    xscvspdpn f0, vs4
; FAST-NEXT:    mtfprd f1, r3
; FAST-NEXT:    fctid f0, f0
; FAST-NEXT:    mffprd r3, f0
; FAST-NEXT:    mtfprd f0, r3
; FAST-NEXT:    xxmrghd v10, vs0, vs1
; FAST-NEXT:    xscvspdpn f0, v3
; FAST-NEXT:    vmr v3, v1
; FAST-NEXT:    fctid f0, f0
; FAST-NEXT:    mffprd r3, f0
; FAST-NEXT:    xscvspdpn f0, vs5
; FAST-NEXT:    mtfprd f1, r3
; FAST-NEXT:    fctid f0, f0
; FAST-NEXT:    mffprd r3, f0
; FAST-NEXT:    mtfprd f0, r3
; FAST-NEXT:    xxmrghd v11, vs1, vs0
; FAST-NEXT:    xscvspdpn f0, vs6
; FAST-NEXT:    fctid f0, f0
; FAST-NEXT:    mffprd r3, f0
; FAST-NEXT:    xscvspdpn f0, vs7
; FAST-NEXT:    mtfprd f1, r3
; FAST-NEXT:    fctid f0, f0
; FAST-NEXT:    mffprd r3, f0
; FAST-NEXT:    mtfprd f0, r3
; FAST-NEXT:    xxmrghd v6, vs0, vs1
; FAST-NEXT:    xscvspdpn f0, v4
; FAST-NEXT:    xscvspdpn f1, vs8
; FAST-NEXT:    vmr v4, v10
; FAST-NEXT:    fctid f0, f0
; FAST-NEXT:    fctid f1, f1
; FAST-NEXT:    mffprd r3, f0
; FAST-NEXT:    mtfprd f0, r3
; FAST-NEXT:    mffprd r3, f1
; FAST-NEXT:    mtfprd f1, r3
; FAST-NEXT:    xxmrghd v7, vs0, vs1
; FAST-NEXT:    xscvspdpn f0, vs9
; FAST-NEXT:    xscvspdpn f1, vs10
; FAST-NEXT:    fctid f0, f0
; FAST-NEXT:    fctid f1, f1
; FAST-NEXT:    mffprd r3, f0
; FAST-NEXT:    mtfprd f0, r3
; FAST-NEXT:    mffprd r3, f1
; FAST-NEXT:    mtfprd f1, r3
; FAST-NEXT:    xxmrghd v8, vs1, vs0
; FAST-NEXT:    xscvspdpn f0, v5
; FAST-NEXT:    xscvspdpn f1, vs11
; FAST-NEXT:    vmr v5, v11
; FAST-NEXT:    fctid f0, f0
; FAST-NEXT:    fctid f1, f1
; FAST-NEXT:    mffprd r3, f0
; FAST-NEXT:    mtfprd f0, r3
; FAST-NEXT:    mffprd r3, f1
; FAST-NEXT:    mtfprd f1, r3
; FAST-NEXT:    xxmrghd v9, vs0, vs1
; FAST-NEXT:    blr
  %a = call <16 x i64> @llvm.lrint.v16i64.v16f32(<16 x float> %x)
  ret <16 x i64> %a
}
declare <16 x i64> @llvm.lrint.v16i64.v16f32(<16 x float>)

define <1 x i64> @lrint_v1f64(<1 x double> %x) {
; BE-LABEL: lrint_v1f64:
; BE:       # %bb.0:
; BE-NEXT:    mflr r0
; BE-NEXT:    stdu r1, -112(r1)
; BE-NEXT:    std r0, 128(r1)
; BE-NEXT:    .cfi_def_cfa_offset 112
; BE-NEXT:    .cfi_offset lr, 16
; BE-NEXT:    bl lrint
; BE-NEXT:    nop
; BE-NEXT:    addi r1, r1, 112
; BE-NEXT:    ld r0, 16(r1)
; BE-NEXT:    mtlr r0
; BE-NEXT:    blr
;
; CHECK-LABEL: lrint_v1f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    mflr r0
; CHECK-NEXT:    stdu r1, -32(r1)
; CHECK-NEXT:    std r0, 48(r1)
; CHECK-NEXT:    .cfi_def_cfa_offset 32
; CHECK-NEXT:    .cfi_offset lr, 16
; CHECK-NEXT:    bl lrint
; CHECK-NEXT:    nop
; CHECK-NEXT:    addi r1, r1, 32
; CHECK-NEXT:    ld r0, 16(r1)
; CHECK-NEXT:    mtlr r0
; CHECK-NEXT:    blr
;
; FAST-LABEL: lrint_v1f64:
; FAST:       # %bb.0:
; FAST-NEXT:    fctid f0, f1
; FAST-NEXT:    mffprd r3, f0
; FAST-NEXT:    blr
  %a = call <1 x i64> @llvm.lrint.v1i64.v1f64(<1 x double> %x)
  ret <1 x i64> %a
}
declare <1 x i64> @llvm.lrint.v1i64.v1f64(<1 x double>)

define <2 x i64> @lrint_v2f64(<2 x double> %x) {
; BE-LABEL: lrint_v2f64:
; BE:       # %bb.0:
; BE-NEXT:    mflr r0
; BE-NEXT:    stdu r1, -160(r1)
; BE-NEXT:    std r0, 176(r1)
; BE-NEXT:    .cfi_def_cfa_offset 160
; BE-NEXT:    .cfi_offset lr, 16
; BE-NEXT:    .cfi_offset v31, -16
; BE-NEXT:    li r3, 144
; BE-NEXT:    stxvd2x v31, r1, r3 # 16-byte Folded Spill
; BE-NEXT:    vmr v31, v2
; BE-NEXT:    xxlor f1, v31, v31
; BE-NEXT:    bl lrint
; BE-NEXT:    nop
; BE-NEXT:    xxswapd vs1, v31
; BE-NEXT:    std r3, 128(r1)
; BE-NEXT:    bl lrint
; BE-NEXT:    nop
; BE-NEXT:    std r3, 136(r1)
; BE-NEXT:    addi r3, r1, 128
; BE-NEXT:    lxvd2x v2, 0, r3
; BE-NEXT:    li r3, 144
; BE-NEXT:    lxvd2x v31, r1, r3 # 16-byte Folded Reload
; BE-NEXT:    addi r1, r1, 160
; BE-NEXT:    ld r0, 16(r1)
; BE-NEXT:    mtlr r0
; BE-NEXT:    blr
;
; CHECK-LABEL: lrint_v2f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    mflr r0
; CHECK-NEXT:    stdu r1, -64(r1)
; CHECK-NEXT:    std r0, 80(r1)
; CHECK-NEXT:    .cfi_def_cfa_offset 64
; CHECK-NEXT:    .cfi_offset lr, 16
; CHECK-NEXT:    .cfi_offset v31, -16
; CHECK-NEXT:    li r3, 48
; CHECK-NEXT:    stvx v31, r1, r3 # 16-byte Folded Spill
; CHECK-NEXT:    vmr v31, v2
; CHECK-NEXT:    xxlor f1, v31, v31
; CHECK-NEXT:    bl lrint
; CHECK-NEXT:    nop
; CHECK-NEXT:    xxswapd vs1, v31
; CHECK-NEXT:    mtvsrd v31, r3
; CHECK-NEXT:    bl lrint
; CHECK-NEXT:    nop
; CHECK-NEXT:    mtfprd f0, r3
; CHECK-NEXT:    li r3, 48
; CHECK-NEXT:    xxmrghd v2, v31, vs0
; CHECK-NEXT:    lvx v31, r1, r3 # 16-byte Folded Reload
; CHECK-NEXT:    addi r1, r1, 64
; CHECK-NEXT:    ld r0, 16(r1)
; CHECK-NEXT:    mtlr r0
; CHECK-NEXT:    blr
;
; FAST-LABEL: lrint_v2f64:
; FAST:       # %bb.0:
; FAST-NEXT:    xxlor f1, v2, v2
; FAST-NEXT:    xxswapd vs0, v2
; FAST-NEXT:    fctid f1, f1
; FAST-NEXT:    fctid f0, f0
; FAST-NEXT:    mffprd r3, f1
; FAST-NEXT:    mtfprd f1, r3
; FAST-NEXT:    mffprd r3, f0
; FAST-NEXT:    mtfprd f0, r3
; FAST-NEXT:    xxmrghd v2, vs1, vs0
; FAST-NEXT:    blr
  %a = call <2 x i64> @llvm.lrint.v2i64.v2f64(<2 x double> %x)
  ret <2 x i64> %a
}
declare <2 x i64> @llvm.lrint.v2i64.v2f64(<2 x double>)

define <4 x i64> @lrint_v4f64(<4 x double> %x) {
; BE-LABEL: lrint_v4f64:
; BE:       # %bb.0:
; BE-NEXT:    mflr r0
; BE-NEXT:    stdu r1, -192(r1)
; BE-NEXT:    std r0, 208(r1)
; BE-NEXT:    .cfi_def_cfa_offset 192
; BE-NEXT:    .cfi_offset lr, 16
; BE-NEXT:    .cfi_offset v30, -32
; BE-NEXT:    .cfi_offset v31, -16
; BE-NEXT:    li r3, 160
; BE-NEXT:    stxvd2x v30, r1, r3 # 16-byte Folded Spill
; BE-NEXT:    vmr v30, v2
; BE-NEXT:    li r3, 176
; BE-NEXT:    xxlor f1, v30, v30
; BE-NEXT:    stxvd2x v31, r1, r3 # 16-byte Folded Spill
; BE-NEXT:    vmr v31, v3
; BE-NEXT:    bl lrint
; BE-NEXT:    nop
; BE-NEXT:    xxswapd vs1, v30
; BE-NEXT:    std r3, 128(r1)
; BE-NEXT:    bl lrint
; BE-NEXT:    nop
; BE-NEXT:    xxlor f1, v31, v31
; BE-NEXT:    std r3, 136(r1)
; BE-NEXT:    bl lrint
; BE-NEXT:    nop
; BE-NEXT:    xxswapd vs1, v31
; BE-NEXT:    std r3, 144(r1)
; BE-NEXT:    bl lrint
; BE-NEXT:    nop
; BE-NEXT:    std r3, 152(r1)
; BE-NEXT:    addi r3, r1, 128
; BE-NEXT:    lxvd2x v2, 0, r3
; BE-NEXT:    addi r3, r1, 144
; BE-NEXT:    lxvd2x v3, 0, r3
; BE-NEXT:    li r3, 176
; BE-NEXT:    lxvd2x v31, r1, r3 # 16-byte Folded Reload
; BE-NEXT:    li r3, 160
; BE-NEXT:    lxvd2x v30, r1, r3 # 16-byte Folded Reload
; BE-NEXT:    addi r1, r1, 192
; BE-NEXT:    ld r0, 16(r1)
; BE-NEXT:    mtlr r0
; BE-NEXT:    blr
;
; CHECK-LABEL: lrint_v4f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    mflr r0
; CHECK-NEXT:    stdu r1, -80(r1)
; CHECK-NEXT:    std r0, 96(r1)
; CHECK-NEXT:    .cfi_def_cfa_offset 80
; CHECK-NEXT:    .cfi_offset lr, 16
; CHECK-NEXT:    .cfi_offset v30, -32
; CHECK-NEXT:    .cfi_offset v31, -16
; CHECK-NEXT:    li r3, 48
; CHECK-NEXT:    stvx v30, r1, r3 # 16-byte Folded Spill
; CHECK-NEXT:    vmr v30, v2
; CHECK-NEXT:    li r3, 64
; CHECK-NEXT:    xxlor f1, v30, v30
; CHECK-NEXT:    stvx v31, r1, r3 # 16-byte Folded Spill
; CHECK-NEXT:    vmr v31, v3
; CHECK-NEXT:    bl lrint
; CHECK-NEXT:    nop
; CHECK-NEXT:    xxswapd vs1, v30
; CHECK-NEXT:    mtvsrd v30, r3
; CHECK-NEXT:    bl lrint
; CHECK-NEXT:    nop
; CHECK-NEXT:    mtfprd f0, r3
; CHECK-NEXT:    xxlor f1, v31, v31
; CHECK-NEXT:    xxmrghd v30, v30, vs0
; CHECK-NEXT:    bl lrint
; CHECK-NEXT:    nop
; CHECK-NEXT:    xxswapd vs1, v31
; CHECK-NEXT:    mtvsrd v31, r3
; CHECK-NEXT:    bl lrint
; CHECK-NEXT:    nop
; CHECK-NEXT:    mtfprd f0, r3
; CHECK-NEXT:    li r3, 64
; CHECK-NEXT:    vmr v2, v30
; CHECK-NEXT:    xxmrghd v3, v31, vs0
; CHECK-NEXT:    lvx v31, r1, r3 # 16-byte Folded Reload
; CHECK-NEXT:    li r3, 48
; CHECK-NEXT:    lvx v30, r1, r3 # 16-byte Folded Reload
; CHECK-NEXT:    addi r1, r1, 80
; CHECK-NEXT:    ld r0, 16(r1)
; CHECK-NEXT:    mtlr r0
; CHECK-NEXT:    blr
;
; FAST-LABEL: lrint_v4f64:
; FAST:       # %bb.0:
; FAST-NEXT:    xxswapd vs0, v2
; FAST-NEXT:    xxlor f2, v2, v2
; FAST-NEXT:    xxswapd vs1, v3
; FAST-NEXT:    fctid f0, f0
; FAST-NEXT:    fctid f2, f2
; FAST-NEXT:    fctid f1, f1
; FAST-NEXT:    mffprd r4, f0
; FAST-NEXT:    xxlor f0, v3, v3
; FAST-NEXT:    mffprd r3, f2
; FAST-NEXT:    fctid f0, f0
; FAST-NEXT:    mtfprd f2, r4
; FAST-NEXT:    mffprd r5, f0
; FAST-NEXT:    mtfprd f0, r3
; FAST-NEXT:    mffprd r3, f1
; FAST-NEXT:    mtfprd f1, r3
; FAST-NEXT:    xxmrghd v2, vs0, vs2
; FAST-NEXT:    mtfprd f0, r5
; FAST-NEXT:    xxmrghd v3, vs0, vs1
; FAST-NEXT:    blr
  %a = call <4 x i64> @llvm.lrint.v4i64.v4f64(<4 x double> %x)
  ret <4 x i64> %a
}
declare <4 x i64> @llvm.lrint.v4i64.v4f64(<4 x double>)

define <8 x i64> @lrint_v8f64(<8 x double> %x) {
; BE-LABEL: lrint_v8f64:
; BE:       # %bb.0:
; BE-NEXT:    mflr r0
; BE-NEXT:    stdu r1, -256(r1)
; BE-NEXT:    std r0, 272(r1)
; BE-NEXT:    .cfi_def_cfa_offset 256
; BE-NEXT:    .cfi_offset lr, 16
; BE-NEXT:    .cfi_offset v28, -64
; BE-NEXT:    .cfi_offset v29, -48
; BE-NEXT:    .cfi_offset v30, -32
; BE-NEXT:    .cfi_offset v31, -16
; BE-NEXT:    li r3, 192
; BE-NEXT:    stxvd2x v28, r1, r3 # 16-byte Folded Spill
; BE-NEXT:    li r3, 208
; BE-NEXT:    vmr v28, v2
; BE-NEXT:    xxlor f1, v28, v28
; BE-NEXT:    stxvd2x v29, r1, r3 # 16-byte Folded Spill
; BE-NEXT:    li r3, 224
; BE-NEXT:    vmr v29, v3
; BE-NEXT:    stxvd2x v30, r1, r3 # 16-byte Folded Spill
; BE-NEXT:    li r3, 240
; BE-NEXT:    vmr v30, v4
; BE-NEXT:    stxvd2x v31, r1, r3 # 16-byte Folded Spill
; BE-NEXT:    vmr v31, v5
; BE-NEXT:    bl lrint
; BE-NEXT:    nop
; BE-NEXT:    xxswapd vs1, v28
; BE-NEXT:    std r3, 128(r1)
; BE-NEXT:    bl lrint
; BE-NEXT:    nop
; BE-NEXT:    xxlor f1, v29, v29
; BE-NEXT:    std r3, 136(r1)
; BE-NEXT:    bl lrint
; BE-NEXT:    nop
; BE-NEXT:    xxswapd vs1, v29
; BE-NEXT:    std r3, 144(r1)
; BE-NEXT:    bl lrint
; BE-NEXT:    nop
; BE-NEXT:    xxlor f1, v30, v30
; BE-NEXT:    std r3, 152(r1)
; BE-NEXT:    bl lrint
; BE-NEXT:    nop
; BE-NEXT:    xxswapd vs1, v30
; BE-NEXT:    std r3, 160(r1)
; BE-NEXT:    bl lrint
; BE-NEXT:    nop
; BE-NEXT:    xxlor f1, v31, v31
; BE-NEXT:    std r3, 168(r1)
; BE-NEXT:    bl lrint
; BE-NEXT:    nop
; BE-NEXT:    xxswapd vs1, v31
; BE-NEXT:    std r3, 176(r1)
; BE-NEXT:    bl lrint
; BE-NEXT:    nop
; BE-NEXT:    std r3, 184(r1)
; BE-NEXT:    addi r3, r1, 128
; BE-NEXT:    lxvd2x v2, 0, r3
; BE-NEXT:    addi r3, r1, 144
; BE-NEXT:    lxvd2x v3, 0, r3
; BE-NEXT:    addi r3, r1, 160
; BE-NEXT:    lxvd2x v4, 0, r3
; BE-NEXT:    addi r3, r1, 176
; BE-NEXT:    lxvd2x v5, 0, r3
; BE-NEXT:    li r3, 240
; BE-NEXT:    lxvd2x v31, r1, r3 # 16-byte Folded Reload
; BE-NEXT:    li r3, 224
; BE-NEXT:    lxvd2x v30, r1, r3 # 16-byte Folded Reload
; BE-NEXT:    li r3, 208
; BE-NEXT:    lxvd2x v29, r1, r3 # 16-byte Folded Reload
; BE-NEXT:    li r3, 192
; BE-NEXT:    lxvd2x v28, r1, r3 # 16-byte Folded Reload
; BE-NEXT:    addi r1, r1, 256
; BE-NEXT:    ld r0, 16(r1)
; BE-NEXT:    mtlr r0
; BE-NEXT:    blr
;
; CHECK-LABEL: lrint_v8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    mflr r0
; CHECK-NEXT:    stdu r1, -112(r1)
; CHECK-NEXT:    std r0, 128(r1)
; CHECK-NEXT:    .cfi_def_cfa_offset 112
; CHECK-NEXT:    .cfi_offset lr, 16
; CHECK-NEXT:    .cfi_offset v28, -64
; CHECK-NEXT:    .cfi_offset v29, -48
; CHECK-NEXT:    .cfi_offset v30, -32
; CHECK-NEXT:    .cfi_offset v31, -16
; CHECK-NEXT:    li r3, 48
; CHECK-NEXT:    stvx v28, r1, r3 # 16-byte Folded Spill
; CHECK-NEXT:    li r3, 64
; CHECK-NEXT:    vmr v28, v2
; CHECK-NEXT:    stvx v29, r1, r3 # 16-byte Folded Spill
; CHECK-NEXT:    li r3, 80
; CHECK-NEXT:    xxlor f1, v28, v28
; CHECK-NEXT:    vmr v29, v3
; CHECK-NEXT:    stvx v30, r1, r3 # 16-byte Folded Spill
; CHECK-NEXT:    li r3, 96
; CHECK-NEXT:    vmr v30, v4
; CHECK-NEXT:    stvx v31, r1, r3 # 16-byte Folded Spill
; CHECK-NEXT:    vmr v31, v5
; CHECK-NEXT:    bl lrint
; CHECK-NEXT:    nop
; CHECK-NEXT:    xxswapd vs1, v28
; CHECK-NEXT:    mtvsrd v28, r3
; CHECK-NEXT:    bl lrint
; CHECK-NEXT:    nop
; CHECK-NEXT:    mtfprd f0, r3
; CHECK-NEXT:    xxlor f1, v29, v29
; CHECK-NEXT:    xxmrghd v28, v28, vs0
; CHECK-NEXT:    bl lrint
; CHECK-NEXT:    nop
; CHECK-NEXT:    xxswapd vs1, v29
; CHECK-NEXT:    mtvsrd v29, r3
; CHECK-NEXT:    bl lrint
; CHECK-NEXT:    nop
; CHECK-NEXT:    mtfprd f0, r3
; CHECK-NEXT:    xxlor f1, v30, v30
; CHECK-NEXT:    xxmrghd v29, v29, vs0
; CHECK-NEXT:    bl lrint
; CHECK-NEXT:    nop
; CHECK-NEXT:    xxswapd vs1, v30
; CHECK-NEXT:    mtvsrd v30, r3
; CHECK-NEXT:    bl lrint
; CHECK-NEXT:    nop
; CHECK-NEXT:    mtfprd f0, r3
; CHECK-NEXT:    xxlor f1, v31, v31
; CHECK-NEXT:    xxmrghd v30, v30, vs0
; CHECK-NEXT:    bl lrint
; CHECK-NEXT:    nop
; CHECK-NEXT:    xxswapd vs1, v31
; CHECK-NEXT:    mtvsrd v31, r3
; CHECK-NEXT:    bl lrint
; CHECK-NEXT:    nop
; CHECK-NEXT:    mtfprd f0, r3
; CHECK-NEXT:    li r3, 96
; CHECK-NEXT:    vmr v4, v30
; CHECK-NEXT:    vmr v3, v29
; CHECK-NEXT:    vmr v2, v28
; CHECK-NEXT:    xxmrghd v5, v31, vs0
; CHECK-NEXT:    lvx v31, r1, r3 # 16-byte Folded Reload
; CHECK-NEXT:    li r3, 80
; CHECK-NEXT:    lvx v30, r1, r3 # 16-byte Folded Reload
; CHECK-NEXT:    li r3, 64
; CHECK-NEXT:    lvx v29, r1, r3 # 16-byte Folded Reload
; CHECK-NEXT:    li r3, 48
; CHECK-NEXT:    lvx v28, r1, r3 # 16-byte Folded Reload
; CHECK-NEXT:    addi r1, r1, 112
; CHECK-NEXT:    ld r0, 16(r1)
; CHECK-NEXT:    mtlr r0
; CHECK-NEXT:    blr
;
; FAST-LABEL: lrint_v8f64:
; FAST:       # %bb.0:
; FAST-NEXT:    xxswapd vs0, v2
; FAST-NEXT:    xxswapd vs1, v3
; FAST-NEXT:    xxlor f4, v2, v2
; FAST-NEXT:    xxswapd vs2, v4
; FAST-NEXT:    xxswapd vs3, v5
; FAST-NEXT:    fctid f0, f0
; FAST-NEXT:    fctid f4, f4
; FAST-NEXT:    mffprd r4, f0
; FAST-NEXT:    xxlor f0, v3, v3
; FAST-NEXT:    mffprd r3, f4
; FAST-NEXT:    fctid f0, f0
; FAST-NEXT:    mffprd r5, f0
; FAST-NEXT:    fctid f0, f1
; FAST-NEXT:    mtfprd f1, r4
; FAST-NEXT:    mffprd r6, f0
; FAST-NEXT:    xxlor f0, v4, v4
; FAST-NEXT:    fctid f0, f0
; FAST-NEXT:    mtfprd f4, r6
; FAST-NEXT:    mffprd r7, f0
; FAST-NEXT:    fctid f0, f2
; FAST-NEXT:    mtfprd f2, r5
; FAST-NEXT:    mtfprd f5, r7
; FAST-NEXT:    mffprd r8, f0
; FAST-NEXT:    xxlor f0, v5, v5
; FAST-NEXT:    fctid f0, f0
; FAST-NEXT:    mtfprd f6, r8
; FAST-NEXT:    mffprd r9, f0
; FAST-NEXT:    mtfprd f0, r3
; FAST-NEXT:    xxmrghd v3, vs2, vs4
; FAST-NEXT:    xxmrghd v4, vs5, vs6
; FAST-NEXT:    xxmrghd v2, vs0, vs1
; FAST-NEXT:    fctid f1, f3
; FAST-NEXT:    mtfprd f0, r9
; FAST-NEXT:    mffprd r3, f1
; FAST-NEXT:    mtfprd f1, r3
; FAST-NEXT:    xxmrghd v5, vs0, vs1
; FAST-NEXT:    blr
  %a = call <8 x i64> @llvm.lrint.v8i64.v8f64(<8 x double> %x)
  ret <8 x i64> %a
}
declare <8 x i64> @llvm.lrint.v8i64.v8f64(<8 x double>)
