; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 5
; RUN: llc -mtriple=amdgcn-amd-amdhsa -mcpu=gfx900 < %s | FileCheck -check-prefixes=GFX9,GFX900 %s
; RUN: llc -mtriple=amdgcn-amd-amdhsa -mcpu=gfx90a < %s | FileCheck -check-prefixes=GFX9,GFX90APLUS,GFX90A %s
; RUN: llc -mtriple=amdgcn-amd-amdhsa -mcpu=gfx940 < %s | FileCheck -check-prefixes=GFX9,GFX90APLUS,GFX940 %s


define void @v_shuffle_v2p3_v4p3__u_u(ptr addrspace(1) inreg %ptr) {
; GFX9-LABEL: v_shuffle_v2p3_v4p3__u_u:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x ptr addrspace(3)> asm "; def $0", "=v"()
  %shuf = shufflevector <4 x ptr addrspace(3)> %vec0, <4 x ptr addrspace(3)> poison, <2 x i32> poison
  store <2 x ptr addrspace(3)> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2p3_v4p3__0_u(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2p3_v4p3__0_u:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    v_mov_b32_e32 v4, 0
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:3]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    global_store_dwordx2 v4, v[0:1], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2p3_v4p3__0_u:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    v_mov_b32_e32 v4, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:3]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    global_store_dwordx2 v4, v[0:1], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: v_shuffle_v2p3_v4p3__0_u:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    v_mov_b32_e32 v4, 0
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def v[0:3]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    global_store_dwordx2 v4, v[0:1], s[0:1] sc0 sc1
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x ptr addrspace(3)> asm "; def $0", "=v"()
  %shuf = shufflevector <4 x ptr addrspace(3)> %vec0, <4 x ptr addrspace(3)> poison, <2 x i32> <i32 0, i32 poison>
  store <2 x ptr addrspace(3)> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2p3_v4p3__1_u(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2p3_v4p3__1_u:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    v_mov_b32_e32 v4, 0
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:3]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    global_store_dwordx2 v4, v[1:2], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2p3_v4p3__1_u:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:3]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v4, 0
; GFX90A-NEXT:    v_mov_b32_e32 v0, v1
; GFX90A-NEXT:    global_store_dwordx2 v4, v[0:1], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: v_shuffle_v2p3_v4p3__1_u:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def v[0:3]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    v_mov_b32_e32 v4, 0
; GFX940-NEXT:    v_mov_b32_e32 v0, v1
; GFX940-NEXT:    global_store_dwordx2 v4, v[0:1], s[0:1] sc0 sc1
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x ptr addrspace(3)> asm "; def $0", "=v"()
  %shuf = shufflevector <4 x ptr addrspace(3)> %vec0, <4 x ptr addrspace(3)> poison, <2 x i32> <i32 1, i32 poison>
  store <2 x ptr addrspace(3)> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2p3_v4p3__2_u(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2p3_v4p3__2_u:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    v_mov_b32_e32 v4, 0
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:3]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    global_store_dwordx2 v4, v[2:3], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2p3_v4p3__2_u:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    v_mov_b32_e32 v4, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:3]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    global_store_dwordx2 v4, v[2:3], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: v_shuffle_v2p3_v4p3__2_u:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    v_mov_b32_e32 v4, 0
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def v[0:3]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    global_store_dwordx2 v4, v[2:3], s[0:1] sc0 sc1
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x ptr addrspace(3)> asm "; def $0", "=v"()
  %shuf = shufflevector <4 x ptr addrspace(3)> %vec0, <4 x ptr addrspace(3)> poison, <2 x i32> <i32 2, i32 poison>
  store <2 x ptr addrspace(3)> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2p3_v4p3__3_u(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2p3_v4p3__3_u:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:3]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v4, 0
; GFX900-NEXT:    v_mov_b32_e32 v0, v3
; GFX900-NEXT:    global_store_dwordx2 v4, v[0:1], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2p3_v4p3__3_u:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:3]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v4, 0
; GFX90A-NEXT:    v_mov_b32_e32 v0, v3
; GFX90A-NEXT:    global_store_dwordx2 v4, v[0:1], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: v_shuffle_v2p3_v4p3__3_u:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def v[0:3]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    v_mov_b32_e32 v4, 0
; GFX940-NEXT:    v_mov_b32_e32 v0, v3
; GFX940-NEXT:    global_store_dwordx2 v4, v[0:1], s[0:1] sc0 sc1
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x ptr addrspace(3)> asm "; def $0", "=v"()
  %shuf = shufflevector <4 x ptr addrspace(3)> %vec0, <4 x ptr addrspace(3)> poison, <2 x i32> <i32 3, i32 poison>
  store <2 x ptr addrspace(3)> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2p3_v4p3__4_u(ptr addrspace(1) inreg %ptr) {
; GFX9-LABEL: v_shuffle_v2p3_v4p3__4_u:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x ptr addrspace(3)> asm "; def $0", "=v"()
  %shuf = shufflevector <4 x ptr addrspace(3)> %vec0, <4 x ptr addrspace(3)> poison, <2 x i32> <i32 4, i32 poison>
  store <2 x ptr addrspace(3)> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2p3_v4p3__5_u(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2p3_v4p3__5_u:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    v_mov_b32_e32 v4, 0
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:3]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    global_store_dwordx2 v4, v[1:2], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2p3_v4p3__5_u:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:3]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v4, 0
; GFX90A-NEXT:    v_mov_b32_e32 v0, v1
; GFX90A-NEXT:    global_store_dwordx2 v4, v[0:1], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: v_shuffle_v2p3_v4p3__5_u:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def v[0:3]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    v_mov_b32_e32 v4, 0
; GFX940-NEXT:    v_mov_b32_e32 v0, v1
; GFX940-NEXT:    global_store_dwordx2 v4, v[0:1], s[0:1] sc0 sc1
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x ptr addrspace(3)> asm "; def $0", "=v"()
  %vec1 = call <4 x ptr addrspace(3)> asm "; def $0", "=v"()
  %shuf = shufflevector <4 x ptr addrspace(3)> %vec0, <4 x ptr addrspace(3)> %vec1, <2 x i32> <i32 5, i32 poison>
  store <2 x ptr addrspace(3)> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2p3_v4p3__6_u(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2p3_v4p3__6_u:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    v_mov_b32_e32 v4, 0
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:3]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    global_store_dwordx2 v4, v[2:3], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2p3_v4p3__6_u:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    v_mov_b32_e32 v4, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:3]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    global_store_dwordx2 v4, v[2:3], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: v_shuffle_v2p3_v4p3__6_u:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    v_mov_b32_e32 v4, 0
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def v[0:3]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    global_store_dwordx2 v4, v[2:3], s[0:1] sc0 sc1
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x ptr addrspace(3)> asm "; def $0", "=v"()
  %vec1 = call <4 x ptr addrspace(3)> asm "; def $0", "=v"()
  %shuf = shufflevector <4 x ptr addrspace(3)> %vec0, <4 x ptr addrspace(3)> %vec1, <2 x i32> <i32 6, i32 poison>
  store <2 x ptr addrspace(3)> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2p3_v4p3__7_u(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2p3_v4p3__7_u:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:3]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v4, 0
; GFX900-NEXT:    v_mov_b32_e32 v0, v3
; GFX900-NEXT:    global_store_dwordx2 v4, v[0:1], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2p3_v4p3__7_u:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:3]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v4, 0
; GFX90A-NEXT:    v_mov_b32_e32 v0, v3
; GFX90A-NEXT:    global_store_dwordx2 v4, v[0:1], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: v_shuffle_v2p3_v4p3__7_u:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def v[0:3]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    v_mov_b32_e32 v4, 0
; GFX940-NEXT:    v_mov_b32_e32 v0, v3
; GFX940-NEXT:    global_store_dwordx2 v4, v[0:1], s[0:1] sc0 sc1
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x ptr addrspace(3)> asm "; def $0", "=v"()
  %vec1 = call <4 x ptr addrspace(3)> asm "; def $0", "=v"()
  %shuf = shufflevector <4 x ptr addrspace(3)> %vec0, <4 x ptr addrspace(3)> %vec1, <2 x i32> <i32 7, i32 poison>
  store <2 x ptr addrspace(3)> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2p3_v4p3__7_0(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2p3_v4p3__7_0:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:3]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[1:4]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v5, 0
; GFX900-NEXT:    v_mov_b32_e32 v1, v4
; GFX900-NEXT:    v_mov_b32_e32 v2, v0
; GFX900-NEXT:    global_store_dwordx2 v5, v[1:2], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2p3_v4p3__7_0:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:3]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v6, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[2:5]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_pk_mov_b32 v[0:1], v[4:5], v[0:1] op_sel:[1,0]
; GFX90A-NEXT:    global_store_dwordx2 v6, v[0:1], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: v_shuffle_v2p3_v4p3__7_0:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def v[0:3]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    v_mov_b32_e32 v6, 0
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def v[2:5]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_nop 0
; GFX940-NEXT:    v_pk_mov_b32 v[0:1], v[4:5], v[0:1] op_sel:[1,0]
; GFX940-NEXT:    global_store_dwordx2 v6, v[0:1], s[0:1] sc0 sc1
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x ptr addrspace(3)> asm "; def $0", "=v"()
  %vec1 = call <4 x ptr addrspace(3)> asm "; def $0", "=v"()
  %shuf = shufflevector <4 x ptr addrspace(3)> %vec0, <4 x ptr addrspace(3)> %vec1, <2 x i32> <i32 7, i32 0>
  store <2 x ptr addrspace(3)> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2p3_v4p3__7_1(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2p3_v4p3__7_1:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:3]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v6, 0
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[2:5]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v0, v5
; GFX900-NEXT:    global_store_dwordx2 v6, v[0:1], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2p3_v4p3__7_1:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:3]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v6, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[2:5]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v0, v5
; GFX90A-NEXT:    global_store_dwordx2 v6, v[0:1], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: v_shuffle_v2p3_v4p3__7_1:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def v[0:3]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    v_mov_b32_e32 v6, 0
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def v[2:5]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_nop 0
; GFX940-NEXT:    v_mov_b32_e32 v0, v5
; GFX940-NEXT:    global_store_dwordx2 v6, v[0:1], s[0:1] sc0 sc1
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x ptr addrspace(3)> asm "; def $0", "=v"()
  %vec1 = call <4 x ptr addrspace(3)> asm "; def $0", "=v"()
  %shuf = shufflevector <4 x ptr addrspace(3)> %vec0, <4 x ptr addrspace(3)> %vec1, <2 x i32> <i32 7, i32 1>
  store <2 x ptr addrspace(3)> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2p3_v4p3__7_2(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2p3_v4p3__7_2:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:3]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v7, 0
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[3:6]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v1, v6
; GFX900-NEXT:    global_store_dwordx2 v7, v[1:2], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2p3_v4p3__7_2:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:3]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v8, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[4:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_pk_mov_b32 v[0:1], v[6:7], v[2:3] op_sel:[1,0]
; GFX90A-NEXT:    global_store_dwordx2 v8, v[0:1], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: v_shuffle_v2p3_v4p3__7_2:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def v[0:3]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    v_mov_b32_e32 v8, 0
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def v[4:7]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_nop 0
; GFX940-NEXT:    v_pk_mov_b32 v[0:1], v[6:7], v[2:3] op_sel:[1,0]
; GFX940-NEXT:    global_store_dwordx2 v8, v[0:1], s[0:1] sc0 sc1
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x ptr addrspace(3)> asm "; def $0", "=v"()
  %vec1 = call <4 x ptr addrspace(3)> asm "; def $0", "=v"()
  %shuf = shufflevector <4 x ptr addrspace(3)> %vec0, <4 x ptr addrspace(3)> %vec1, <2 x i32> <i32 7, i32 2>
  store <2 x ptr addrspace(3)> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2p3_v4p3__7_3(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2p3_v4p3__7_3:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:3]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v8, 0
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[4:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v2, v7
; GFX900-NEXT:    global_store_dwordx2 v8, v[2:3], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2p3_v4p3__7_3:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:3]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v8, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[4:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v2, v7
; GFX90A-NEXT:    global_store_dwordx2 v8, v[2:3], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: v_shuffle_v2p3_v4p3__7_3:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def v[0:3]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    v_mov_b32_e32 v8, 0
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def v[4:7]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_nop 0
; GFX940-NEXT:    v_mov_b32_e32 v2, v7
; GFX940-NEXT:    global_store_dwordx2 v8, v[2:3], s[0:1] sc0 sc1
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x ptr addrspace(3)> asm "; def $0", "=v"()
  %vec1 = call <4 x ptr addrspace(3)> asm "; def $0", "=v"()
  %shuf = shufflevector <4 x ptr addrspace(3)> %vec0, <4 x ptr addrspace(3)> %vec1, <2 x i32> <i32 7, i32 3>
  store <2 x ptr addrspace(3)> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2p3_v4p3__7_4(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2p3_v4p3__7_4:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:3]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v4, 0
; GFX900-NEXT:    v_mov_b32_e32 v1, v3
; GFX900-NEXT:    v_mov_b32_e32 v2, v0
; GFX900-NEXT:    global_store_dwordx2 v4, v[1:2], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2p3_v4p3__7_4:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:3]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v4, 0
; GFX90A-NEXT:    v_mov_b32_e32 v2, v3
; GFX90A-NEXT:    v_mov_b32_e32 v3, v0
; GFX90A-NEXT:    global_store_dwordx2 v4, v[2:3], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: v_shuffle_v2p3_v4p3__7_4:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def v[0:3]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    v_mov_b32_e32 v4, 0
; GFX940-NEXT:    v_mov_b32_e32 v2, v3
; GFX940-NEXT:    v_mov_b32_e32 v3, v0
; GFX940-NEXT:    global_store_dwordx2 v4, v[2:3], s[0:1] sc0 sc1
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x ptr addrspace(3)> asm "; def $0", "=v"()
  %vec1 = call <4 x ptr addrspace(3)> asm "; def $0", "=v"()
  %shuf = shufflevector <4 x ptr addrspace(3)> %vec0, <4 x ptr addrspace(3)> %vec1, <2 x i32> <i32 7, i32 4>
  store <2 x ptr addrspace(3)> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2p3_v4p3__7_5(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2p3_v4p3__7_5:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:3]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v4, 0
; GFX900-NEXT:    v_mov_b32_e32 v0, v3
; GFX900-NEXT:    global_store_dwordx2 v4, v[0:1], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2p3_v4p3__7_5:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:3]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v4, 0
; GFX90A-NEXT:    v_mov_b32_e32 v0, v3
; GFX90A-NEXT:    global_store_dwordx2 v4, v[0:1], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: v_shuffle_v2p3_v4p3__7_5:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def v[0:3]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    v_mov_b32_e32 v4, 0
; GFX940-NEXT:    v_mov_b32_e32 v0, v3
; GFX940-NEXT:    global_store_dwordx2 v4, v[0:1], s[0:1] sc0 sc1
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x ptr addrspace(3)> asm "; def $0", "=v"()
  %vec1 = call <4 x ptr addrspace(3)> asm "; def $0", "=v"()
  %shuf = shufflevector <4 x ptr addrspace(3)> %vec0, <4 x ptr addrspace(3)> %vec1, <2 x i32> <i32 7, i32 5>
  store <2 x ptr addrspace(3)> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2p3_v4p3__7_6(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2p3_v4p3__7_6:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:3]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v4, 0
; GFX900-NEXT:    v_mov_b32_e32 v1, v3
; GFX900-NEXT:    global_store_dwordx2 v4, v[1:2], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2p3_v4p3__7_6:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:3]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v4, 0
; GFX90A-NEXT:    v_pk_mov_b32 v[0:1], v[2:3], v[2:3] op_sel:[1,0]
; GFX90A-NEXT:    global_store_dwordx2 v4, v[0:1], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: v_shuffle_v2p3_v4p3__7_6:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def v[0:3]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    v_mov_b32_e32 v4, 0
; GFX940-NEXT:    v_pk_mov_b32 v[0:1], v[2:3], v[2:3] op_sel:[1,0]
; GFX940-NEXT:    global_store_dwordx2 v4, v[0:1], s[0:1] sc0 sc1
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x ptr addrspace(3)> asm "; def $0", "=v"()
  %vec1 = call <4 x ptr addrspace(3)> asm "; def $0", "=v"()
  %shuf = shufflevector <4 x ptr addrspace(3)> %vec0, <4 x ptr addrspace(3)> %vec1, <2 x i32> <i32 7, i32 6>
  store <2 x ptr addrspace(3)> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2p3_v4p3__7_7(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2p3_v4p3__7_7:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:3]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v4, 0
; GFX900-NEXT:    v_mov_b32_e32 v2, v3
; GFX900-NEXT:    global_store_dwordx2 v4, v[2:3], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2p3_v4p3__7_7:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:3]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v4, 0
; GFX90A-NEXT:    v_mov_b32_e32 v2, v3
; GFX90A-NEXT:    global_store_dwordx2 v4, v[2:3], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: v_shuffle_v2p3_v4p3__7_7:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def v[0:3]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    v_mov_b32_e32 v4, 0
; GFX940-NEXT:    v_mov_b32_e32 v2, v3
; GFX940-NEXT:    global_store_dwordx2 v4, v[2:3], s[0:1] sc0 sc1
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x ptr addrspace(3)> asm "; def $0", "=v"()
  %vec1 = call <4 x ptr addrspace(3)> asm "; def $0", "=v"()
  %shuf = shufflevector <4 x ptr addrspace(3)> %vec0, <4 x ptr addrspace(3)> %vec1, <2 x i32> <i32 7, i32 7>
  store <2 x ptr addrspace(3)> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2p3_v4p3__u_0(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2p3_v4p3__u_0:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:3]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v4, 0
; GFX900-NEXT:    v_mov_b32_e32 v1, v0
; GFX900-NEXT:    global_store_dwordx2 v4, v[0:1], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2p3_v4p3__u_0:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:3]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v4, 0
; GFX90A-NEXT:    v_mov_b32_e32 v1, v0
; GFX90A-NEXT:    global_store_dwordx2 v4, v[0:1], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: v_shuffle_v2p3_v4p3__u_0:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def v[0:3]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    v_mov_b32_e32 v4, 0
; GFX940-NEXT:    v_mov_b32_e32 v1, v0
; GFX940-NEXT:    global_store_dwordx2 v4, v[0:1], s[0:1] sc0 sc1
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x ptr addrspace(3)> asm "; def $0", "=v"()
  %shuf = shufflevector <4 x ptr addrspace(3)> %vec0, <4 x ptr addrspace(3)> poison, <2 x i32> <i32 poison, i32 0>
  store <2 x ptr addrspace(3)> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2p3_v4p3__0_0(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2p3_v4p3__0_0:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:3]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v4, 0
; GFX900-NEXT:    v_mov_b32_e32 v1, v0
; GFX900-NEXT:    global_store_dwordx2 v4, v[0:1], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2p3_v4p3__0_0:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:3]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v4, 0
; GFX90A-NEXT:    v_mov_b32_e32 v1, v0
; GFX90A-NEXT:    global_store_dwordx2 v4, v[0:1], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: v_shuffle_v2p3_v4p3__0_0:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def v[0:3]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    v_mov_b32_e32 v4, 0
; GFX940-NEXT:    v_mov_b32_e32 v1, v0
; GFX940-NEXT:    global_store_dwordx2 v4, v[0:1], s[0:1] sc0 sc1
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x ptr addrspace(3)> asm "; def $0", "=v"()
  %shuf = shufflevector <4 x ptr addrspace(3)> %vec0, <4 x ptr addrspace(3)> poison, <2 x i32> zeroinitializer
  store <2 x ptr addrspace(3)> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2p3_v4p3__1_0(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2p3_v4p3__1_0:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:3]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v4, 0
; GFX900-NEXT:    v_mov_b32_e32 v2, v0
; GFX900-NEXT:    global_store_dwordx2 v4, v[1:2], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2p3_v4p3__1_0:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:3]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v4, 0
; GFX90A-NEXT:    v_pk_mov_b32 v[0:1], v[0:1], v[0:1] op_sel:[1,0]
; GFX90A-NEXT:    global_store_dwordx2 v4, v[0:1], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: v_shuffle_v2p3_v4p3__1_0:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def v[0:3]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    v_mov_b32_e32 v4, 0
; GFX940-NEXT:    v_pk_mov_b32 v[0:1], v[0:1], v[0:1] op_sel:[1,0]
; GFX940-NEXT:    global_store_dwordx2 v4, v[0:1], s[0:1] sc0 sc1
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x ptr addrspace(3)> asm "; def $0", "=v"()
  %shuf = shufflevector <4 x ptr addrspace(3)> %vec0, <4 x ptr addrspace(3)> poison, <2 x i32> <i32 1, i32 0>
  store <2 x ptr addrspace(3)> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2p3_v4p3__2_0(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2p3_v4p3__2_0:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:3]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v4, 0
; GFX900-NEXT:    v_mov_b32_e32 v3, v0
; GFX900-NEXT:    global_store_dwordx2 v4, v[2:3], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2p3_v4p3__2_0:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:3]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v4, 0
; GFX90A-NEXT:    v_mov_b32_e32 v3, v0
; GFX90A-NEXT:    global_store_dwordx2 v4, v[2:3], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: v_shuffle_v2p3_v4p3__2_0:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def v[0:3]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    v_mov_b32_e32 v4, 0
; GFX940-NEXT:    v_mov_b32_e32 v3, v0
; GFX940-NEXT:    global_store_dwordx2 v4, v[2:3], s[0:1] sc0 sc1
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x ptr addrspace(3)> asm "; def $0", "=v"()
  %shuf = shufflevector <4 x ptr addrspace(3)> %vec0, <4 x ptr addrspace(3)> poison, <2 x i32> <i32 2, i32 0>
  store <2 x ptr addrspace(3)> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2p3_v4p3__3_0(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2p3_v4p3__3_0:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:3]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v4, 0
; GFX900-NEXT:    v_mov_b32_e32 v1, v3
; GFX900-NEXT:    v_mov_b32_e32 v2, v0
; GFX900-NEXT:    global_store_dwordx2 v4, v[1:2], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2p3_v4p3__3_0:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:3]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v4, 0
; GFX90A-NEXT:    v_mov_b32_e32 v2, v3
; GFX90A-NEXT:    v_mov_b32_e32 v3, v0
; GFX90A-NEXT:    global_store_dwordx2 v4, v[2:3], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: v_shuffle_v2p3_v4p3__3_0:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def v[0:3]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    v_mov_b32_e32 v4, 0
; GFX940-NEXT:    v_mov_b32_e32 v2, v3
; GFX940-NEXT:    v_mov_b32_e32 v3, v0
; GFX940-NEXT:    global_store_dwordx2 v4, v[2:3], s[0:1] sc0 sc1
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x ptr addrspace(3)> asm "; def $0", "=v"()
  %shuf = shufflevector <4 x ptr addrspace(3)> %vec0, <4 x ptr addrspace(3)> poison, <2 x i32> <i32 3, i32 0>
  store <2 x ptr addrspace(3)> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2p3_v4p3__4_0(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2p3_v4p3__4_0:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:3]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v4, 0
; GFX900-NEXT:    v_mov_b32_e32 v1, v0
; GFX900-NEXT:    global_store_dwordx2 v4, v[0:1], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2p3_v4p3__4_0:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:3]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v4, 0
; GFX90A-NEXT:    v_mov_b32_e32 v1, v0
; GFX90A-NEXT:    global_store_dwordx2 v4, v[0:1], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: v_shuffle_v2p3_v4p3__4_0:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def v[0:3]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    v_mov_b32_e32 v4, 0
; GFX940-NEXT:    v_mov_b32_e32 v1, v0
; GFX940-NEXT:    global_store_dwordx2 v4, v[0:1], s[0:1] sc0 sc1
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x ptr addrspace(3)> asm "; def $0", "=v"()
  %shuf = shufflevector <4 x ptr addrspace(3)> %vec0, <4 x ptr addrspace(3)> poison, <2 x i32> <i32 4, i32 0>
  store <2 x ptr addrspace(3)> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2p3_v4p3__5_0(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2p3_v4p3__5_0:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:3]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[1:4]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v5, 0
; GFX900-NEXT:    v_mov_b32_e32 v3, v0
; GFX900-NEXT:    global_store_dwordx2 v5, v[2:3], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2p3_v4p3__5_0:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:3]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v6, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[2:5]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_pk_mov_b32 v[0:1], v[2:3], v[0:1] op_sel:[1,0]
; GFX90A-NEXT:    global_store_dwordx2 v6, v[0:1], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: v_shuffle_v2p3_v4p3__5_0:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def v[0:3]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    v_mov_b32_e32 v6, 0
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def v[2:5]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_nop 0
; GFX940-NEXT:    v_pk_mov_b32 v[0:1], v[2:3], v[0:1] op_sel:[1,0]
; GFX940-NEXT:    global_store_dwordx2 v6, v[0:1], s[0:1] sc0 sc1
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x ptr addrspace(3)> asm "; def $0", "=v"()
  %vec1 = call <4 x ptr addrspace(3)> asm "; def $0", "=v"()
  %shuf = shufflevector <4 x ptr addrspace(3)> %vec0, <4 x ptr addrspace(3)> %vec1, <2 x i32> <i32 5, i32 0>
  store <2 x ptr addrspace(3)> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2p3_v4p3__6_0(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2p3_v4p3__6_0:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:3]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[1:4]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v5, 0
; GFX900-NEXT:    v_mov_b32_e32 v4, v0
; GFX900-NEXT:    global_store_dwordx2 v5, v[3:4], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2p3_v4p3__6_0:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:3]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[2:5]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v6, 0
; GFX90A-NEXT:    v_mov_b32_e32 v5, v0
; GFX90A-NEXT:    global_store_dwordx2 v6, v[4:5], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: v_shuffle_v2p3_v4p3__6_0:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def v[0:3]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    v_mov_b32_e32 v6, 0
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def v[2:5]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_nop 0
; GFX940-NEXT:    v_mov_b32_e32 v5, v0
; GFX940-NEXT:    global_store_dwordx2 v6, v[4:5], s[0:1] sc0 sc1
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x ptr addrspace(3)> asm "; def $0", "=v"()
  %vec1 = call <4 x ptr addrspace(3)> asm "; def $0", "=v"()
  %shuf = shufflevector <4 x ptr addrspace(3)> %vec0, <4 x ptr addrspace(3)> %vec1, <2 x i32> <i32 6, i32 0>
  store <2 x ptr addrspace(3)> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2p3_v4p3__u_1(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2p3_v4p3__u_1:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    v_mov_b32_e32 v4, 0
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:3]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    global_store_dwordx2 v4, v[0:1], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2p3_v4p3__u_1:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    v_mov_b32_e32 v4, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:3]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    global_store_dwordx2 v4, v[0:1], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: v_shuffle_v2p3_v4p3__u_1:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    v_mov_b32_e32 v4, 0
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def v[0:3]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    global_store_dwordx2 v4, v[0:1], s[0:1] sc0 sc1
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x ptr addrspace(3)> asm "; def $0", "=v"()
  %shuf = shufflevector <4 x ptr addrspace(3)> %vec0, <4 x ptr addrspace(3)> poison, <2 x i32> <i32 poison, i32 1>
  store <2 x ptr addrspace(3)> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2p3_v4p3__0_1(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2p3_v4p3__0_1:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    v_mov_b32_e32 v4, 0
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:3]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    global_store_dwordx2 v4, v[0:1], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2p3_v4p3__0_1:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    v_mov_b32_e32 v4, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:3]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    global_store_dwordx2 v4, v[0:1], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: v_shuffle_v2p3_v4p3__0_1:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    v_mov_b32_e32 v4, 0
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def v[0:3]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    global_store_dwordx2 v4, v[0:1], s[0:1] sc0 sc1
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x ptr addrspace(3)> asm "; def $0", "=v"()
  %shuf = shufflevector <4 x ptr addrspace(3)> %vec0, <4 x ptr addrspace(3)> poison, <2 x i32> <i32 0, i32 1>
  store <2 x ptr addrspace(3)> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2p3_v4p3__1_1(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2p3_v4p3__1_1:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:3]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v4, 0
; GFX900-NEXT:    v_mov_b32_e32 v2, v1
; GFX900-NEXT:    global_store_dwordx2 v4, v[1:2], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2p3_v4p3__1_1:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:3]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v4, 0
; GFX90A-NEXT:    v_mov_b32_e32 v0, v1
; GFX90A-NEXT:    global_store_dwordx2 v4, v[0:1], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: v_shuffle_v2p3_v4p3__1_1:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def v[0:3]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    v_mov_b32_e32 v4, 0
; GFX940-NEXT:    v_mov_b32_e32 v0, v1
; GFX940-NEXT:    global_store_dwordx2 v4, v[0:1], s[0:1] sc0 sc1
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x ptr addrspace(3)> asm "; def $0", "=v"()
  %shuf = shufflevector <4 x ptr addrspace(3)> %vec0, <4 x ptr addrspace(3)> poison, <2 x i32> <i32 1, i32 1>
  store <2 x ptr addrspace(3)> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2p3_v4p3__2_1(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2p3_v4p3__2_1:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:3]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v4, 0
; GFX900-NEXT:    v_mov_b32_e32 v3, v1
; GFX900-NEXT:    global_store_dwordx2 v4, v[2:3], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2p3_v4p3__2_1:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:3]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v4, 0
; GFX90A-NEXT:    v_mov_b32_e32 v3, v1
; GFX90A-NEXT:    global_store_dwordx2 v4, v[2:3], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: v_shuffle_v2p3_v4p3__2_1:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def v[0:3]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    v_mov_b32_e32 v4, 0
; GFX940-NEXT:    v_mov_b32_e32 v3, v1
; GFX940-NEXT:    global_store_dwordx2 v4, v[2:3], s[0:1] sc0 sc1
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x ptr addrspace(3)> asm "; def $0", "=v"()
  %shuf = shufflevector <4 x ptr addrspace(3)> %vec0, <4 x ptr addrspace(3)> poison, <2 x i32> <i32 2, i32 1>
  store <2 x ptr addrspace(3)> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2p3_v4p3__3_1(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2p3_v4p3__3_1:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:3]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v4, 0
; GFX900-NEXT:    v_mov_b32_e32 v0, v3
; GFX900-NEXT:    global_store_dwordx2 v4, v[0:1], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2p3_v4p3__3_1:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:3]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v4, 0
; GFX90A-NEXT:    v_mov_b32_e32 v0, v3
; GFX90A-NEXT:    global_store_dwordx2 v4, v[0:1], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: v_shuffle_v2p3_v4p3__3_1:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def v[0:3]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    v_mov_b32_e32 v4, 0
; GFX940-NEXT:    v_mov_b32_e32 v0, v3
; GFX940-NEXT:    global_store_dwordx2 v4, v[0:1], s[0:1] sc0 sc1
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x ptr addrspace(3)> asm "; def $0", "=v"()
  %shuf = shufflevector <4 x ptr addrspace(3)> %vec0, <4 x ptr addrspace(3)> poison, <2 x i32> <i32 3, i32 1>
  store <2 x ptr addrspace(3)> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2p3_v4p3__4_1(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2p3_v4p3__4_1:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    v_mov_b32_e32 v4, 0
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:3]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    global_store_dwordx2 v4, v[0:1], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2p3_v4p3__4_1:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    v_mov_b32_e32 v4, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:3]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    global_store_dwordx2 v4, v[0:1], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: v_shuffle_v2p3_v4p3__4_1:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    v_mov_b32_e32 v4, 0
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def v[0:3]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    global_store_dwordx2 v4, v[0:1], s[0:1] sc0 sc1
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x ptr addrspace(3)> asm "; def $0", "=v"()
  %shuf = shufflevector <4 x ptr addrspace(3)> %vec0, <4 x ptr addrspace(3)> poison, <2 x i32> <i32 4, i32 1>
  store <2 x ptr addrspace(3)> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2p3_v4p3__5_1(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2p3_v4p3__5_1:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:3]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[2:5]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v6, 0
; GFX900-NEXT:    v_mov_b32_e32 v4, v1
; GFX900-NEXT:    global_store_dwordx2 v6, v[3:4], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2p3_v4p3__5_1:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:3]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v6, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[2:5]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v0, v3
; GFX90A-NEXT:    global_store_dwordx2 v6, v[0:1], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: v_shuffle_v2p3_v4p3__5_1:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def v[0:3]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    v_mov_b32_e32 v6, 0
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def v[2:5]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_nop 0
; GFX940-NEXT:    v_mov_b32_e32 v0, v3
; GFX940-NEXT:    global_store_dwordx2 v6, v[0:1], s[0:1] sc0 sc1
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x ptr addrspace(3)> asm "; def $0", "=v"()
  %vec1 = call <4 x ptr addrspace(3)> asm "; def $0", "=v"()
  %shuf = shufflevector <4 x ptr addrspace(3)> %vec0, <4 x ptr addrspace(3)> %vec1, <2 x i32> <i32 5, i32 1>
  store <2 x ptr addrspace(3)> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2p3_v4p3__6_1(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2p3_v4p3__6_1:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:3]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[2:5]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v6, 0
; GFX900-NEXT:    v_mov_b32_e32 v5, v1
; GFX900-NEXT:    global_store_dwordx2 v6, v[4:5], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2p3_v4p3__6_1:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:3]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[2:5]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v6, 0
; GFX90A-NEXT:    v_mov_b32_e32 v5, v1
; GFX90A-NEXT:    global_store_dwordx2 v6, v[4:5], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: v_shuffle_v2p3_v4p3__6_1:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def v[0:3]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    v_mov_b32_e32 v6, 0
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def v[2:5]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_nop 0
; GFX940-NEXT:    v_mov_b32_e32 v5, v1
; GFX940-NEXT:    global_store_dwordx2 v6, v[4:5], s[0:1] sc0 sc1
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x ptr addrspace(3)> asm "; def $0", "=v"()
  %vec1 = call <4 x ptr addrspace(3)> asm "; def $0", "=v"()
  %shuf = shufflevector <4 x ptr addrspace(3)> %vec0, <4 x ptr addrspace(3)> %vec1, <2 x i32> <i32 6, i32 1>
  store <2 x ptr addrspace(3)> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2p3_v4p3__u_2(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2p3_v4p3__u_2:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    v_mov_b32_e32 v4, 0
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:3]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    global_store_dwordx2 v4, v[1:2], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2p3_v4p3__u_2:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:3]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v4, 0
; GFX90A-NEXT:    v_mov_b32_e32 v1, v2
; GFX90A-NEXT:    global_store_dwordx2 v4, v[0:1], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: v_shuffle_v2p3_v4p3__u_2:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def v[0:3]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    v_mov_b32_e32 v4, 0
; GFX940-NEXT:    v_mov_b32_e32 v1, v2
; GFX940-NEXT:    global_store_dwordx2 v4, v[0:1], s[0:1] sc0 sc1
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x ptr addrspace(3)> asm "; def $0", "=v"()
  %shuf = shufflevector <4 x ptr addrspace(3)> %vec0, <4 x ptr addrspace(3)> poison, <2 x i32> <i32 poison, i32 2>
  store <2 x ptr addrspace(3)> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2p3_v4p3__0_2(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2p3_v4p3__0_2:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:3]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v4, 0
; GFX900-NEXT:    v_mov_b32_e32 v1, v2
; GFX900-NEXT:    global_store_dwordx2 v4, v[0:1], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2p3_v4p3__0_2:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:3]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v4, 0
; GFX90A-NEXT:    v_mov_b32_e32 v1, v2
; GFX90A-NEXT:    global_store_dwordx2 v4, v[0:1], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: v_shuffle_v2p3_v4p3__0_2:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def v[0:3]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    v_mov_b32_e32 v4, 0
; GFX940-NEXT:    v_mov_b32_e32 v1, v2
; GFX940-NEXT:    global_store_dwordx2 v4, v[0:1], s[0:1] sc0 sc1
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x ptr addrspace(3)> asm "; def $0", "=v"()
  %shuf = shufflevector <4 x ptr addrspace(3)> %vec0, <4 x ptr addrspace(3)> poison, <2 x i32> <i32 0, i32 2>
  store <2 x ptr addrspace(3)> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2p3_v4p3__1_2(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2p3_v4p3__1_2:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    v_mov_b32_e32 v4, 0
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:3]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    global_store_dwordx2 v4, v[1:2], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2p3_v4p3__1_2:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:3]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v4, 0
; GFX90A-NEXT:    v_mov_b32_e32 v0, v1
; GFX90A-NEXT:    v_mov_b32_e32 v1, v2
; GFX90A-NEXT:    global_store_dwordx2 v4, v[0:1], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: v_shuffle_v2p3_v4p3__1_2:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def v[0:3]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    v_mov_b32_e32 v4, 0
; GFX940-NEXT:    v_mov_b32_e32 v0, v1
; GFX940-NEXT:    v_mov_b32_e32 v1, v2
; GFX940-NEXT:    global_store_dwordx2 v4, v[0:1], s[0:1] sc0 sc1
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x ptr addrspace(3)> asm "; def $0", "=v"()
  %shuf = shufflevector <4 x ptr addrspace(3)> %vec0, <4 x ptr addrspace(3)> poison, <2 x i32> <i32 1, i32 2>
  store <2 x ptr addrspace(3)> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2p3_v4p3__2_2(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2p3_v4p3__2_2:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:3]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v4, 0
; GFX900-NEXT:    v_mov_b32_e32 v3, v2
; GFX900-NEXT:    global_store_dwordx2 v4, v[2:3], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2p3_v4p3__2_2:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:3]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v4, 0
; GFX90A-NEXT:    v_mov_b32_e32 v3, v2
; GFX90A-NEXT:    global_store_dwordx2 v4, v[2:3], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: v_shuffle_v2p3_v4p3__2_2:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def v[0:3]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    v_mov_b32_e32 v4, 0
; GFX940-NEXT:    v_mov_b32_e32 v3, v2
; GFX940-NEXT:    global_store_dwordx2 v4, v[2:3], s[0:1] sc0 sc1
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x ptr addrspace(3)> asm "; def $0", "=v"()
  %shuf = shufflevector <4 x ptr addrspace(3)> %vec0, <4 x ptr addrspace(3)> poison, <2 x i32> <i32 2, i32 2>
  store <2 x ptr addrspace(3)> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2p3_v4p3__3_2(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2p3_v4p3__3_2:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:3]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v4, 0
; GFX900-NEXT:    v_mov_b32_e32 v1, v3
; GFX900-NEXT:    global_store_dwordx2 v4, v[1:2], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2p3_v4p3__3_2:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:3]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v4, 0
; GFX90A-NEXT:    v_pk_mov_b32 v[0:1], v[2:3], v[2:3] op_sel:[1,0]
; GFX90A-NEXT:    global_store_dwordx2 v4, v[0:1], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: v_shuffle_v2p3_v4p3__3_2:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def v[0:3]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    v_mov_b32_e32 v4, 0
; GFX940-NEXT:    v_pk_mov_b32 v[0:1], v[2:3], v[2:3] op_sel:[1,0]
; GFX940-NEXT:    global_store_dwordx2 v4, v[0:1], s[0:1] sc0 sc1
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x ptr addrspace(3)> asm "; def $0", "=v"()
  %shuf = shufflevector <4 x ptr addrspace(3)> %vec0, <4 x ptr addrspace(3)> poison, <2 x i32> <i32 3, i32 2>
  store <2 x ptr addrspace(3)> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2p3_v4p3__4_2(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2p3_v4p3__4_2:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    v_mov_b32_e32 v4, 0
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:3]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    global_store_dwordx2 v4, v[1:2], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2p3_v4p3__4_2:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:3]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v4, 0
; GFX90A-NEXT:    v_mov_b32_e32 v1, v2
; GFX90A-NEXT:    global_store_dwordx2 v4, v[0:1], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: v_shuffle_v2p3_v4p3__4_2:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def v[0:3]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    v_mov_b32_e32 v4, 0
; GFX940-NEXT:    v_mov_b32_e32 v1, v2
; GFX940-NEXT:    global_store_dwordx2 v4, v[0:1], s[0:1] sc0 sc1
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x ptr addrspace(3)> asm "; def $0", "=v"()
  %shuf = shufflevector <4 x ptr addrspace(3)> %vec0, <4 x ptr addrspace(3)> poison, <2 x i32> <i32 4, i32 2>
  store <2 x ptr addrspace(3)> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2p3_v4p3__5_2(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2p3_v4p3__5_2:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:3]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[3:6]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v7, 0
; GFX900-NEXT:    v_mov_b32_e32 v5, v2
; GFX900-NEXT:    global_store_dwordx2 v7, v[4:5], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2p3_v4p3__5_2:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:3]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v8, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[4:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_pk_mov_b32 v[0:1], v[4:5], v[2:3] op_sel:[1,0]
; GFX90A-NEXT:    global_store_dwordx2 v8, v[0:1], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: v_shuffle_v2p3_v4p3__5_2:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def v[0:3]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    v_mov_b32_e32 v8, 0
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def v[4:7]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_nop 0
; GFX940-NEXT:    v_pk_mov_b32 v[0:1], v[4:5], v[2:3] op_sel:[1,0]
; GFX940-NEXT:    global_store_dwordx2 v8, v[0:1], s[0:1] sc0 sc1
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x ptr addrspace(3)> asm "; def $0", "=v"()
  %vec1 = call <4 x ptr addrspace(3)> asm "; def $0", "=v"()
  %shuf = shufflevector <4 x ptr addrspace(3)> %vec0, <4 x ptr addrspace(3)> %vec1, <2 x i32> <i32 5, i32 2>
  store <2 x ptr addrspace(3)> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2p3_v4p3__6_2(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2p3_v4p3__6_2:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:3]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[3:6]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v7, 0
; GFX900-NEXT:    v_mov_b32_e32 v6, v2
; GFX900-NEXT:    global_store_dwordx2 v7, v[5:6], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2p3_v4p3__6_2:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[4:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v8, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:3]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v7, v2
; GFX90A-NEXT:    global_store_dwordx2 v8, v[6:7], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: v_shuffle_v2p3_v4p3__6_2:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def v[4:7]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    v_mov_b32_e32 v8, 0
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def v[0:3]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_nop 0
; GFX940-NEXT:    v_mov_b32_e32 v7, v2
; GFX940-NEXT:    global_store_dwordx2 v8, v[6:7], s[0:1] sc0 sc1
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x ptr addrspace(3)> asm "; def $0", "=v"()
  %vec1 = call <4 x ptr addrspace(3)> asm "; def $0", "=v"()
  %shuf = shufflevector <4 x ptr addrspace(3)> %vec0, <4 x ptr addrspace(3)> %vec1, <2 x i32> <i32 6, i32 2>
  store <2 x ptr addrspace(3)> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2p3_v4p3__u_3(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2p3_v4p3__u_3:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    v_mov_b32_e32 v4, 0
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:3]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    global_store_dwordx2 v4, v[2:3], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2p3_v4p3__u_3:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    v_mov_b32_e32 v4, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:3]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    global_store_dwordx2 v4, v[2:3], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: v_shuffle_v2p3_v4p3__u_3:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    v_mov_b32_e32 v4, 0
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def v[0:3]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    global_store_dwordx2 v4, v[2:3], s[0:1] sc0 sc1
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x ptr addrspace(3)> asm "; def $0", "=v"()
  %shuf = shufflevector <4 x ptr addrspace(3)> %vec0, <4 x ptr addrspace(3)> poison, <2 x i32> <i32 poison, i32 3>
  store <2 x ptr addrspace(3)> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2p3_v4p3__0_3(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2p3_v4p3__0_3:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:3]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v4, 0
; GFX900-NEXT:    v_mov_b32_e32 v1, v3
; GFX900-NEXT:    global_store_dwordx2 v4, v[0:1], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2p3_v4p3__0_3:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:3]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v4, 0
; GFX90A-NEXT:    v_mov_b32_e32 v1, v3
; GFX90A-NEXT:    global_store_dwordx2 v4, v[0:1], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: v_shuffle_v2p3_v4p3__0_3:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def v[0:3]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    v_mov_b32_e32 v4, 0
; GFX940-NEXT:    v_mov_b32_e32 v1, v3
; GFX940-NEXT:    global_store_dwordx2 v4, v[0:1], s[0:1] sc0 sc1
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x ptr addrspace(3)> asm "; def $0", "=v"()
  %shuf = shufflevector <4 x ptr addrspace(3)> %vec0, <4 x ptr addrspace(3)> poison, <2 x i32> <i32 0, i32 3>
  store <2 x ptr addrspace(3)> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2p3_v4p3__1_3(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2p3_v4p3__1_3:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:3]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v4, 0
; GFX900-NEXT:    v_mov_b32_e32 v2, v3
; GFX900-NEXT:    global_store_dwordx2 v4, v[1:2], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2p3_v4p3__1_3:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:3]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v4, 0
; GFX90A-NEXT:    v_mov_b32_e32 v2, v1
; GFX90A-NEXT:    global_store_dwordx2 v4, v[2:3], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: v_shuffle_v2p3_v4p3__1_3:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def v[0:3]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    v_mov_b32_e32 v4, 0
; GFX940-NEXT:    v_mov_b32_e32 v2, v1
; GFX940-NEXT:    global_store_dwordx2 v4, v[2:3], s[0:1] sc0 sc1
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x ptr addrspace(3)> asm "; def $0", "=v"()
  %shuf = shufflevector <4 x ptr addrspace(3)> %vec0, <4 x ptr addrspace(3)> poison, <2 x i32> <i32 1, i32 3>
  store <2 x ptr addrspace(3)> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2p3_v4p3__2_3(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2p3_v4p3__2_3:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    v_mov_b32_e32 v4, 0
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:3]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    global_store_dwordx2 v4, v[2:3], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2p3_v4p3__2_3:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    v_mov_b32_e32 v4, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:3]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    global_store_dwordx2 v4, v[2:3], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: v_shuffle_v2p3_v4p3__2_3:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    v_mov_b32_e32 v4, 0
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def v[0:3]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    global_store_dwordx2 v4, v[2:3], s[0:1] sc0 sc1
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x ptr addrspace(3)> asm "; def $0", "=v"()
  %shuf = shufflevector <4 x ptr addrspace(3)> %vec0, <4 x ptr addrspace(3)> poison, <2 x i32> <i32 2, i32 3>
  store <2 x ptr addrspace(3)> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2p3_v4p3__3_3(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2p3_v4p3__3_3:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:3]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v4, 0
; GFX900-NEXT:    v_mov_b32_e32 v2, v3
; GFX900-NEXT:    global_store_dwordx2 v4, v[2:3], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2p3_v4p3__3_3:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:3]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v4, 0
; GFX90A-NEXT:    v_mov_b32_e32 v2, v3
; GFX90A-NEXT:    global_store_dwordx2 v4, v[2:3], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: v_shuffle_v2p3_v4p3__3_3:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def v[0:3]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    v_mov_b32_e32 v4, 0
; GFX940-NEXT:    v_mov_b32_e32 v2, v3
; GFX940-NEXT:    global_store_dwordx2 v4, v[2:3], s[0:1] sc0 sc1
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x ptr addrspace(3)> asm "; def $0", "=v"()
  %shuf = shufflevector <4 x ptr addrspace(3)> %vec0, <4 x ptr addrspace(3)> poison, <2 x i32> <i32 3, i32 3>
  store <2 x ptr addrspace(3)> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2p3_v4p3__4_3(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2p3_v4p3__4_3:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    v_mov_b32_e32 v4, 0
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:3]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    global_store_dwordx2 v4, v[2:3], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2p3_v4p3__4_3:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    v_mov_b32_e32 v4, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:3]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    global_store_dwordx2 v4, v[2:3], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: v_shuffle_v2p3_v4p3__4_3:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    v_mov_b32_e32 v4, 0
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def v[0:3]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    global_store_dwordx2 v4, v[2:3], s[0:1] sc0 sc1
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x ptr addrspace(3)> asm "; def $0", "=v"()
  %shuf = shufflevector <4 x ptr addrspace(3)> %vec0, <4 x ptr addrspace(3)> poison, <2 x i32> <i32 4, i32 3>
  store <2 x ptr addrspace(3)> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2p3_v4p3__5_3(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2p3_v4p3__5_3:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[4:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v8, 0
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:3]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v6, v3
; GFX900-NEXT:    global_store_dwordx2 v8, v[5:6], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2p3_v4p3__5_3:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:3]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v8, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[4:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v2, v5
; GFX90A-NEXT:    global_store_dwordx2 v8, v[2:3], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: v_shuffle_v2p3_v4p3__5_3:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def v[0:3]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    v_mov_b32_e32 v8, 0
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def v[4:7]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_nop 0
; GFX940-NEXT:    v_mov_b32_e32 v2, v5
; GFX940-NEXT:    global_store_dwordx2 v8, v[2:3], s[0:1] sc0 sc1
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x ptr addrspace(3)> asm "; def $0", "=v"()
  %vec1 = call <4 x ptr addrspace(3)> asm "; def $0", "=v"()
  %shuf = shufflevector <4 x ptr addrspace(3)> %vec0, <4 x ptr addrspace(3)> %vec1, <2 x i32> <i32 5, i32 3>
  store <2 x ptr addrspace(3)> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2p3_v4p3__6_3(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2p3_v4p3__6_3:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[4:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v8, 0
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:3]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v7, v3
; GFX900-NEXT:    global_store_dwordx2 v8, v[6:7], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2p3_v4p3__6_3:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[4:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v8, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:3]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v7, v3
; GFX90A-NEXT:    global_store_dwordx2 v8, v[6:7], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: v_shuffle_v2p3_v4p3__6_3:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def v[4:7]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    v_mov_b32_e32 v8, 0
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def v[0:3]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_nop 0
; GFX940-NEXT:    v_mov_b32_e32 v7, v3
; GFX940-NEXT:    global_store_dwordx2 v8, v[6:7], s[0:1] sc0 sc1
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x ptr addrspace(3)> asm "; def $0", "=v"()
  %vec1 = call <4 x ptr addrspace(3)> asm "; def $0", "=v"()
  %shuf = shufflevector <4 x ptr addrspace(3)> %vec0, <4 x ptr addrspace(3)> %vec1, <2 x i32> <i32 6, i32 3>
  store <2 x ptr addrspace(3)> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2p3_v4p3__u_4(ptr addrspace(1) inreg %ptr) {
; GFX9-LABEL: v_shuffle_v2p3_v4p3__u_4:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x ptr addrspace(3)> asm "; def $0", "=v"()
  %shuf = shufflevector <4 x ptr addrspace(3)> %vec0, <4 x ptr addrspace(3)> poison, <2 x i32> <i32 poison, i32 4>
  store <2 x ptr addrspace(3)> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2p3_v4p3__0_4(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2p3_v4p3__0_4:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    v_mov_b32_e32 v4, 0
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:3]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    global_store_dwordx2 v4, v[0:1], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2p3_v4p3__0_4:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    v_mov_b32_e32 v4, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:3]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    global_store_dwordx2 v4, v[0:1], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: v_shuffle_v2p3_v4p3__0_4:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    v_mov_b32_e32 v4, 0
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def v[0:3]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    global_store_dwordx2 v4, v[0:1], s[0:1] sc0 sc1
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x ptr addrspace(3)> asm "; def $0", "=v"()
  %shuf = shufflevector <4 x ptr addrspace(3)> %vec0, <4 x ptr addrspace(3)> poison, <2 x i32> <i32 0, i32 4>
  store <2 x ptr addrspace(3)> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2p3_v4p3__1_4(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2p3_v4p3__1_4:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    v_mov_b32_e32 v4, 0
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:3]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    global_store_dwordx2 v4, v[1:2], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2p3_v4p3__1_4:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:3]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v4, 0
; GFX90A-NEXT:    v_mov_b32_e32 v0, v1
; GFX90A-NEXT:    global_store_dwordx2 v4, v[0:1], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: v_shuffle_v2p3_v4p3__1_4:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def v[0:3]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    v_mov_b32_e32 v4, 0
; GFX940-NEXT:    v_mov_b32_e32 v0, v1
; GFX940-NEXT:    global_store_dwordx2 v4, v[0:1], s[0:1] sc0 sc1
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x ptr addrspace(3)> asm "; def $0", "=v"()
  %shuf = shufflevector <4 x ptr addrspace(3)> %vec0, <4 x ptr addrspace(3)> poison, <2 x i32> <i32 1, i32 4>
  store <2 x ptr addrspace(3)> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2p3_v4p3__2_4(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2p3_v4p3__2_4:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    v_mov_b32_e32 v4, 0
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:3]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    global_store_dwordx2 v4, v[2:3], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2p3_v4p3__2_4:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    v_mov_b32_e32 v4, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:3]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    global_store_dwordx2 v4, v[2:3], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: v_shuffle_v2p3_v4p3__2_4:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    v_mov_b32_e32 v4, 0
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def v[0:3]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    global_store_dwordx2 v4, v[2:3], s[0:1] sc0 sc1
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x ptr addrspace(3)> asm "; def $0", "=v"()
  %shuf = shufflevector <4 x ptr addrspace(3)> %vec0, <4 x ptr addrspace(3)> poison, <2 x i32> <i32 2, i32 4>
  store <2 x ptr addrspace(3)> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2p3_v4p3__3_4(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2p3_v4p3__3_4:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:3]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v4, 0
; GFX900-NEXT:    v_mov_b32_e32 v0, v3
; GFX900-NEXT:    global_store_dwordx2 v4, v[0:1], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2p3_v4p3__3_4:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:3]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v4, 0
; GFX90A-NEXT:    v_mov_b32_e32 v0, v3
; GFX90A-NEXT:    global_store_dwordx2 v4, v[0:1], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: v_shuffle_v2p3_v4p3__3_4:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def v[0:3]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    v_mov_b32_e32 v4, 0
; GFX940-NEXT:    v_mov_b32_e32 v0, v3
; GFX940-NEXT:    global_store_dwordx2 v4, v[0:1], s[0:1] sc0 sc1
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x ptr addrspace(3)> asm "; def $0", "=v"()
  %shuf = shufflevector <4 x ptr addrspace(3)> %vec0, <4 x ptr addrspace(3)> poison, <2 x i32> <i32 3, i32 4>
  store <2 x ptr addrspace(3)> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2p3_v4p3__4_4(ptr addrspace(1) inreg %ptr) {
; GFX9-LABEL: v_shuffle_v2p3_v4p3__4_4:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x ptr addrspace(3)> asm "; def $0", "=v"()
  %shuf = shufflevector <4 x ptr addrspace(3)> %vec0, <4 x ptr addrspace(3)> poison, <2 x i32> <i32 4, i32 4>
  store <2 x ptr addrspace(3)> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2p3_v4p3__5_4(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2p3_v4p3__5_4:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:3]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v4, 0
; GFX900-NEXT:    v_mov_b32_e32 v2, v0
; GFX900-NEXT:    global_store_dwordx2 v4, v[1:2], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2p3_v4p3__5_4:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:3]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v4, 0
; GFX90A-NEXT:    v_pk_mov_b32 v[0:1], v[0:1], v[0:1] op_sel:[1,0]
; GFX90A-NEXT:    global_store_dwordx2 v4, v[0:1], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: v_shuffle_v2p3_v4p3__5_4:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def v[0:3]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    v_mov_b32_e32 v4, 0
; GFX940-NEXT:    v_pk_mov_b32 v[0:1], v[0:1], v[0:1] op_sel:[1,0]
; GFX940-NEXT:    global_store_dwordx2 v4, v[0:1], s[0:1] sc0 sc1
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x ptr addrspace(3)> asm "; def $0", "=v"()
  %vec1 = call <4 x ptr addrspace(3)> asm "; def $0", "=v"()
  %shuf = shufflevector <4 x ptr addrspace(3)> %vec0, <4 x ptr addrspace(3)> %vec1, <2 x i32> <i32 5, i32 4>
  store <2 x ptr addrspace(3)> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2p3_v4p3__6_4(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2p3_v4p3__6_4:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:3]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v4, 0
; GFX900-NEXT:    v_mov_b32_e32 v3, v0
; GFX900-NEXT:    global_store_dwordx2 v4, v[2:3], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2p3_v4p3__6_4:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:3]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v4, 0
; GFX90A-NEXT:    v_mov_b32_e32 v3, v0
; GFX90A-NEXT:    global_store_dwordx2 v4, v[2:3], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: v_shuffle_v2p3_v4p3__6_4:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def v[0:3]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    v_mov_b32_e32 v4, 0
; GFX940-NEXT:    v_mov_b32_e32 v3, v0
; GFX940-NEXT:    global_store_dwordx2 v4, v[2:3], s[0:1] sc0 sc1
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x ptr addrspace(3)> asm "; def $0", "=v"()
  %vec1 = call <4 x ptr addrspace(3)> asm "; def $0", "=v"()
  %shuf = shufflevector <4 x ptr addrspace(3)> %vec0, <4 x ptr addrspace(3)> %vec1, <2 x i32> <i32 6, i32 4>
  store <2 x ptr addrspace(3)> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2p3_v4p3__u_5(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2p3_v4p3__u_5:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    v_mov_b32_e32 v4, 0
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:3]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    global_store_dwordx2 v4, v[0:1], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2p3_v4p3__u_5:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    v_mov_b32_e32 v4, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:3]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    global_store_dwordx2 v4, v[0:1], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: v_shuffle_v2p3_v4p3__u_5:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    v_mov_b32_e32 v4, 0
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def v[0:3]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    global_store_dwordx2 v4, v[0:1], s[0:1] sc0 sc1
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x ptr addrspace(3)> asm "; def $0", "=v"()
  %vec1 = call <4 x ptr addrspace(3)> asm "; def $0", "=v"()
  %shuf = shufflevector <4 x ptr addrspace(3)> %vec0, <4 x ptr addrspace(3)> %vec1, <2 x i32> <i32 poison, i32 5>
  store <2 x ptr addrspace(3)> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2p3_v4p3__0_5(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2p3_v4p3__0_5:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:3]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[1:4]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v5, 0
; GFX900-NEXT:    v_mov_b32_e32 v1, v2
; GFX900-NEXT:    global_store_dwordx2 v5, v[0:1], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2p3_v4p3__0_5:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:3]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v6, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[2:5]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v1, v3
; GFX90A-NEXT:    global_store_dwordx2 v6, v[0:1], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: v_shuffle_v2p3_v4p3__0_5:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def v[0:3]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    v_mov_b32_e32 v6, 0
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def v[2:5]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_nop 0
; GFX940-NEXT:    v_mov_b32_e32 v1, v3
; GFX940-NEXT:    global_store_dwordx2 v6, v[0:1], s[0:1] sc0 sc1
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x ptr addrspace(3)> asm "; def $0", "=v"()
  %vec1 = call <4 x ptr addrspace(3)> asm "; def $0", "=v"()
  %shuf = shufflevector <4 x ptr addrspace(3)> %vec0, <4 x ptr addrspace(3)> %vec1, <2 x i32> <i32 0, i32 5>
  store <2 x ptr addrspace(3)> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2p3_v4p3__1_5(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2p3_v4p3__1_5:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:3]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[2:5]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v6, 0
; GFX900-NEXT:    v_mov_b32_e32 v2, v3
; GFX900-NEXT:    global_store_dwordx2 v6, v[1:2], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2p3_v4p3__1_5:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:3]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[2:5]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v6, 0
; GFX90A-NEXT:    v_mov_b32_e32 v2, v1
; GFX90A-NEXT:    global_store_dwordx2 v6, v[2:3], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: v_shuffle_v2p3_v4p3__1_5:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def v[0:3]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    v_mov_b32_e32 v6, 0
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def v[2:5]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_nop 0
; GFX940-NEXT:    v_mov_b32_e32 v2, v1
; GFX940-NEXT:    global_store_dwordx2 v6, v[2:3], s[0:1] sc0 sc1
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x ptr addrspace(3)> asm "; def $0", "=v"()
  %vec1 = call <4 x ptr addrspace(3)> asm "; def $0", "=v"()
  %shuf = shufflevector <4 x ptr addrspace(3)> %vec0, <4 x ptr addrspace(3)> %vec1, <2 x i32> <i32 1, i32 5>
  store <2 x ptr addrspace(3)> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2p3_v4p3__2_5(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2p3_v4p3__2_5:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:3]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[3:6]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v7, 0
; GFX900-NEXT:    v_mov_b32_e32 v3, v4
; GFX900-NEXT:    global_store_dwordx2 v7, v[2:3], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2p3_v4p3__2_5:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:3]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v8, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[4:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v3, v5
; GFX90A-NEXT:    global_store_dwordx2 v8, v[2:3], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: v_shuffle_v2p3_v4p3__2_5:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def v[0:3]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    v_mov_b32_e32 v8, 0
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def v[4:7]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_nop 0
; GFX940-NEXT:    v_mov_b32_e32 v3, v5
; GFX940-NEXT:    global_store_dwordx2 v8, v[2:3], s[0:1] sc0 sc1
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x ptr addrspace(3)> asm "; def $0", "=v"()
  %vec1 = call <4 x ptr addrspace(3)> asm "; def $0", "=v"()
  %shuf = shufflevector <4 x ptr addrspace(3)> %vec0, <4 x ptr addrspace(3)> %vec1, <2 x i32> <i32 2, i32 5>
  store <2 x ptr addrspace(3)> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2p3_v4p3__3_5(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2p3_v4p3__3_5:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[4:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v8, 0
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:3]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v4, v3
; GFX900-NEXT:    global_store_dwordx2 v8, v[4:5], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2p3_v4p3__3_5:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[4:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v8, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:3]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v4, v3
; GFX90A-NEXT:    global_store_dwordx2 v8, v[4:5], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: v_shuffle_v2p3_v4p3__3_5:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def v[4:7]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    v_mov_b32_e32 v8, 0
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def v[0:3]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_nop 0
; GFX940-NEXT:    v_mov_b32_e32 v4, v3
; GFX940-NEXT:    global_store_dwordx2 v8, v[4:5], s[0:1] sc0 sc1
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x ptr addrspace(3)> asm "; def $0", "=v"()
  %vec1 = call <4 x ptr addrspace(3)> asm "; def $0", "=v"()
  %shuf = shufflevector <4 x ptr addrspace(3)> %vec0, <4 x ptr addrspace(3)> %vec1, <2 x i32> <i32 3, i32 5>
  store <2 x ptr addrspace(3)> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2p3_v4p3__4_5(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2p3_v4p3__4_5:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    v_mov_b32_e32 v4, 0
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:3]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    global_store_dwordx2 v4, v[0:1], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2p3_v4p3__4_5:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    v_mov_b32_e32 v4, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:3]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    global_store_dwordx2 v4, v[0:1], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: v_shuffle_v2p3_v4p3__4_5:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    v_mov_b32_e32 v4, 0
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def v[0:3]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    global_store_dwordx2 v4, v[0:1], s[0:1] sc0 sc1
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x ptr addrspace(3)> asm "; def $0", "=v"()
  %vec1 = call <4 x ptr addrspace(3)> asm "; def $0", "=v"()
  %shuf = shufflevector <4 x ptr addrspace(3)> %vec0, <4 x ptr addrspace(3)> %vec1, <2 x i32> <i32 4, i32 5>
  store <2 x ptr addrspace(3)> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2p3_v4p3__5_5(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2p3_v4p3__5_5:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:3]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v4, 0
; GFX900-NEXT:    v_mov_b32_e32 v2, v1
; GFX900-NEXT:    global_store_dwordx2 v4, v[1:2], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2p3_v4p3__5_5:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:3]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v4, 0
; GFX90A-NEXT:    v_mov_b32_e32 v0, v1
; GFX90A-NEXT:    global_store_dwordx2 v4, v[0:1], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: v_shuffle_v2p3_v4p3__5_5:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def v[0:3]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    v_mov_b32_e32 v4, 0
; GFX940-NEXT:    v_mov_b32_e32 v0, v1
; GFX940-NEXT:    global_store_dwordx2 v4, v[0:1], s[0:1] sc0 sc1
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x ptr addrspace(3)> asm "; def $0", "=v"()
  %vec1 = call <4 x ptr addrspace(3)> asm "; def $0", "=v"()
  %shuf = shufflevector <4 x ptr addrspace(3)> %vec0, <4 x ptr addrspace(3)> %vec1, <2 x i32> <i32 5, i32 5>
  store <2 x ptr addrspace(3)> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2p3_v4p3__6_5(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2p3_v4p3__6_5:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:3]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v4, 0
; GFX900-NEXT:    v_mov_b32_e32 v3, v1
; GFX900-NEXT:    global_store_dwordx2 v4, v[2:3], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2p3_v4p3__6_5:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:3]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v4, 0
; GFX90A-NEXT:    v_mov_b32_e32 v3, v1
; GFX90A-NEXT:    global_store_dwordx2 v4, v[2:3], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: v_shuffle_v2p3_v4p3__6_5:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def v[0:3]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    v_mov_b32_e32 v4, 0
; GFX940-NEXT:    v_mov_b32_e32 v3, v1
; GFX940-NEXT:    global_store_dwordx2 v4, v[2:3], s[0:1] sc0 sc1
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x ptr addrspace(3)> asm "; def $0", "=v"()
  %vec1 = call <4 x ptr addrspace(3)> asm "; def $0", "=v"()
  %shuf = shufflevector <4 x ptr addrspace(3)> %vec0, <4 x ptr addrspace(3)> %vec1, <2 x i32> <i32 6, i32 5>
  store <2 x ptr addrspace(3)> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2p3_v4p3__u_6(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2p3_v4p3__u_6:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    v_mov_b32_e32 v4, 0
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:3]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    global_store_dwordx2 v4, v[1:2], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2p3_v4p3__u_6:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:3]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v4, 0
; GFX90A-NEXT:    v_mov_b32_e32 v1, v2
; GFX90A-NEXT:    global_store_dwordx2 v4, v[0:1], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: v_shuffle_v2p3_v4p3__u_6:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def v[0:3]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    v_mov_b32_e32 v4, 0
; GFX940-NEXT:    v_mov_b32_e32 v1, v2
; GFX940-NEXT:    global_store_dwordx2 v4, v[0:1], s[0:1] sc0 sc1
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x ptr addrspace(3)> asm "; def $0", "=v"()
  %vec1 = call <4 x ptr addrspace(3)> asm "; def $0", "=v"()
  %shuf = shufflevector <4 x ptr addrspace(3)> %vec0, <4 x ptr addrspace(3)> %vec1, <2 x i32> <i32 poison, i32 6>
  store <2 x ptr addrspace(3)> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2p3_v4p3__0_6(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2p3_v4p3__0_6:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:3]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[1:4]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v5, 0
; GFX900-NEXT:    v_mov_b32_e32 v1, v3
; GFX900-NEXT:    global_store_dwordx2 v5, v[0:1], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2p3_v4p3__0_6:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:3]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v6, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[2:5]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v1, v4
; GFX90A-NEXT:    global_store_dwordx2 v6, v[0:1], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: v_shuffle_v2p3_v4p3__0_6:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def v[0:3]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    v_mov_b32_e32 v6, 0
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def v[2:5]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_nop 0
; GFX940-NEXT:    v_mov_b32_e32 v1, v4
; GFX940-NEXT:    global_store_dwordx2 v6, v[0:1], s[0:1] sc0 sc1
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x ptr addrspace(3)> asm "; def $0", "=v"()
  %vec1 = call <4 x ptr addrspace(3)> asm "; def $0", "=v"()
  %shuf = shufflevector <4 x ptr addrspace(3)> %vec0, <4 x ptr addrspace(3)> %vec1, <2 x i32> <i32 0, i32 6>
  store <2 x ptr addrspace(3)> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2p3_v4p3__1_6(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2p3_v4p3__1_6:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:3]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[2:5]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v6, 0
; GFX900-NEXT:    v_mov_b32_e32 v2, v4
; GFX900-NEXT:    global_store_dwordx2 v6, v[1:2], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2p3_v4p3__1_6:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:3]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v6, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[2:5]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_pk_mov_b32 v[0:1], v[0:1], v[4:5] op_sel:[1,0]
; GFX90A-NEXT:    global_store_dwordx2 v6, v[0:1], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: v_shuffle_v2p3_v4p3__1_6:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def v[0:3]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    v_mov_b32_e32 v6, 0
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def v[2:5]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_nop 0
; GFX940-NEXT:    v_pk_mov_b32 v[0:1], v[0:1], v[4:5] op_sel:[1,0]
; GFX940-NEXT:    global_store_dwordx2 v6, v[0:1], s[0:1] sc0 sc1
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x ptr addrspace(3)> asm "; def $0", "=v"()
  %vec1 = call <4 x ptr addrspace(3)> asm "; def $0", "=v"()
  %shuf = shufflevector <4 x ptr addrspace(3)> %vec0, <4 x ptr addrspace(3)> %vec1, <2 x i32> <i32 1, i32 6>
  store <2 x ptr addrspace(3)> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2p3_v4p3__2_6(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2p3_v4p3__2_6:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:3]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[3:6]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v7, 0
; GFX900-NEXT:    v_mov_b32_e32 v3, v5
; GFX900-NEXT:    global_store_dwordx2 v7, v[2:3], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2p3_v4p3__2_6:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:3]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v8, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[4:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v3, v6
; GFX90A-NEXT:    global_store_dwordx2 v8, v[2:3], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: v_shuffle_v2p3_v4p3__2_6:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def v[0:3]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    v_mov_b32_e32 v8, 0
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def v[4:7]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_nop 0
; GFX940-NEXT:    v_mov_b32_e32 v3, v6
; GFX940-NEXT:    global_store_dwordx2 v8, v[2:3], s[0:1] sc0 sc1
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x ptr addrspace(3)> asm "; def $0", "=v"()
  %vec1 = call <4 x ptr addrspace(3)> asm "; def $0", "=v"()
  %shuf = shufflevector <4 x ptr addrspace(3)> %vec0, <4 x ptr addrspace(3)> %vec1, <2 x i32> <i32 2, i32 6>
  store <2 x ptr addrspace(3)> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2p3_v4p3__3_6(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2p3_v4p3__3_6:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[4:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v8, 0
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:3]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v5, v3
; GFX900-NEXT:    global_store_dwordx2 v8, v[5:6], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2p3_v4p3__3_6:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:3]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v8, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[4:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_pk_mov_b32 v[0:1], v[2:3], v[6:7] op_sel:[1,0]
; GFX90A-NEXT:    global_store_dwordx2 v8, v[0:1], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: v_shuffle_v2p3_v4p3__3_6:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def v[0:3]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    v_mov_b32_e32 v8, 0
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def v[4:7]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_nop 0
; GFX940-NEXT:    v_pk_mov_b32 v[0:1], v[2:3], v[6:7] op_sel:[1,0]
; GFX940-NEXT:    global_store_dwordx2 v8, v[0:1], s[0:1] sc0 sc1
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x ptr addrspace(3)> asm "; def $0", "=v"()
  %vec1 = call <4 x ptr addrspace(3)> asm "; def $0", "=v"()
  %shuf = shufflevector <4 x ptr addrspace(3)> %vec0, <4 x ptr addrspace(3)> %vec1, <2 x i32> <i32 3, i32 6>
  store <2 x ptr addrspace(3)> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2p3_v4p3__4_6(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2p3_v4p3__4_6:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:3]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v4, 0
; GFX900-NEXT:    v_mov_b32_e32 v1, v2
; GFX900-NEXT:    global_store_dwordx2 v4, v[0:1], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2p3_v4p3__4_6:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:3]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v4, 0
; GFX90A-NEXT:    v_mov_b32_e32 v1, v2
; GFX90A-NEXT:    global_store_dwordx2 v4, v[0:1], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: v_shuffle_v2p3_v4p3__4_6:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def v[0:3]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    v_mov_b32_e32 v4, 0
; GFX940-NEXT:    v_mov_b32_e32 v1, v2
; GFX940-NEXT:    global_store_dwordx2 v4, v[0:1], s[0:1] sc0 sc1
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x ptr addrspace(3)> asm "; def $0", "=v"()
  %vec1 = call <4 x ptr addrspace(3)> asm "; def $0", "=v"()
  %shuf = shufflevector <4 x ptr addrspace(3)> %vec0, <4 x ptr addrspace(3)> %vec1, <2 x i32> <i32 4, i32 6>
  store <2 x ptr addrspace(3)> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2p3_v4p3__5_6(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2p3_v4p3__5_6:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    v_mov_b32_e32 v4, 0
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:3]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    global_store_dwordx2 v4, v[1:2], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2p3_v4p3__5_6:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:3]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v4, 0
; GFX90A-NEXT:    v_mov_b32_e32 v0, v1
; GFX90A-NEXT:    v_mov_b32_e32 v1, v2
; GFX90A-NEXT:    global_store_dwordx2 v4, v[0:1], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: v_shuffle_v2p3_v4p3__5_6:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def v[0:3]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    v_mov_b32_e32 v4, 0
; GFX940-NEXT:    v_mov_b32_e32 v0, v1
; GFX940-NEXT:    v_mov_b32_e32 v1, v2
; GFX940-NEXT:    global_store_dwordx2 v4, v[0:1], s[0:1] sc0 sc1
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x ptr addrspace(3)> asm "; def $0", "=v"()
  %vec1 = call <4 x ptr addrspace(3)> asm "; def $0", "=v"()
  %shuf = shufflevector <4 x ptr addrspace(3)> %vec0, <4 x ptr addrspace(3)> %vec1, <2 x i32> <i32 5, i32 6>
  store <2 x ptr addrspace(3)> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2p3_v4p3__6_6(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2p3_v4p3__6_6:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:3]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v4, 0
; GFX900-NEXT:    v_mov_b32_e32 v3, v2
; GFX900-NEXT:    global_store_dwordx2 v4, v[2:3], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2p3_v4p3__6_6:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:3]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v4, 0
; GFX90A-NEXT:    v_mov_b32_e32 v3, v2
; GFX90A-NEXT:    global_store_dwordx2 v4, v[2:3], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: v_shuffle_v2p3_v4p3__6_6:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def v[0:3]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    v_mov_b32_e32 v4, 0
; GFX940-NEXT:    v_mov_b32_e32 v3, v2
; GFX940-NEXT:    global_store_dwordx2 v4, v[2:3], s[0:1] sc0 sc1
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x ptr addrspace(3)> asm "; def $0", "=v"()
  %vec1 = call <4 x ptr addrspace(3)> asm "; def $0", "=v"()
  %shuf = shufflevector <4 x ptr addrspace(3)> %vec0, <4 x ptr addrspace(3)> %vec1, <2 x i32> <i32 6, i32 6>
  store <2 x ptr addrspace(3)> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2p3_v4p3__u_7(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2p3_v4p3__u_7:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    v_mov_b32_e32 v4, 0
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:3]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    global_store_dwordx2 v4, v[2:3], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2p3_v4p3__u_7:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    v_mov_b32_e32 v4, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:3]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    global_store_dwordx2 v4, v[2:3], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: v_shuffle_v2p3_v4p3__u_7:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    v_mov_b32_e32 v4, 0
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def v[0:3]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    global_store_dwordx2 v4, v[2:3], s[0:1] sc0 sc1
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x ptr addrspace(3)> asm "; def $0", "=v"()
  %vec1 = call <4 x ptr addrspace(3)> asm "; def $0", "=v"()
  %shuf = shufflevector <4 x ptr addrspace(3)> %vec0, <4 x ptr addrspace(3)> %vec1, <2 x i32> <i32 poison, i32 7>
  store <2 x ptr addrspace(3)> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2p3_v4p3__0_7(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2p3_v4p3__0_7:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:3]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[1:4]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v5, 0
; GFX900-NEXT:    v_mov_b32_e32 v1, v4
; GFX900-NEXT:    global_store_dwordx2 v5, v[0:1], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2p3_v4p3__0_7:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:3]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v6, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[2:5]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v1, v5
; GFX90A-NEXT:    global_store_dwordx2 v6, v[0:1], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: v_shuffle_v2p3_v4p3__0_7:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def v[0:3]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    v_mov_b32_e32 v6, 0
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def v[2:5]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_nop 0
; GFX940-NEXT:    v_mov_b32_e32 v1, v5
; GFX940-NEXT:    global_store_dwordx2 v6, v[0:1], s[0:1] sc0 sc1
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x ptr addrspace(3)> asm "; def $0", "=v"()
  %vec1 = call <4 x ptr addrspace(3)> asm "; def $0", "=v"()
  %shuf = shufflevector <4 x ptr addrspace(3)> %vec0, <4 x ptr addrspace(3)> %vec1, <2 x i32> <i32 0, i32 7>
  store <2 x ptr addrspace(3)> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2p3_v4p3__1_7(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2p3_v4p3__1_7:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:3]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[2:5]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v6, 0
; GFX900-NEXT:    v_mov_b32_e32 v2, v5
; GFX900-NEXT:    global_store_dwordx2 v6, v[1:2], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2p3_v4p3__1_7:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:3]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[2:5]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v6, 0
; GFX90A-NEXT:    v_mov_b32_e32 v4, v1
; GFX90A-NEXT:    global_store_dwordx2 v6, v[4:5], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: v_shuffle_v2p3_v4p3__1_7:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def v[0:3]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    v_mov_b32_e32 v6, 0
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def v[2:5]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_nop 0
; GFX940-NEXT:    v_mov_b32_e32 v4, v1
; GFX940-NEXT:    global_store_dwordx2 v6, v[4:5], s[0:1] sc0 sc1
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x ptr addrspace(3)> asm "; def $0", "=v"()
  %vec1 = call <4 x ptr addrspace(3)> asm "; def $0", "=v"()
  %shuf = shufflevector <4 x ptr addrspace(3)> %vec0, <4 x ptr addrspace(3)> %vec1, <2 x i32> <i32 1, i32 7>
  store <2 x ptr addrspace(3)> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2p3_v4p3__2_7(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2p3_v4p3__2_7:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:3]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[3:6]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v7, 0
; GFX900-NEXT:    v_mov_b32_e32 v3, v6
; GFX900-NEXT:    global_store_dwordx2 v7, v[2:3], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2p3_v4p3__2_7:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:3]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v8, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[4:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v3, v7
; GFX90A-NEXT:    global_store_dwordx2 v8, v[2:3], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: v_shuffle_v2p3_v4p3__2_7:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def v[0:3]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    v_mov_b32_e32 v8, 0
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def v[4:7]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_nop 0
; GFX940-NEXT:    v_mov_b32_e32 v3, v7
; GFX940-NEXT:    global_store_dwordx2 v8, v[2:3], s[0:1] sc0 sc1
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x ptr addrspace(3)> asm "; def $0", "=v"()
  %vec1 = call <4 x ptr addrspace(3)> asm "; def $0", "=v"()
  %shuf = shufflevector <4 x ptr addrspace(3)> %vec0, <4 x ptr addrspace(3)> %vec1, <2 x i32> <i32 2, i32 7>
  store <2 x ptr addrspace(3)> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2p3_v4p3__3_7(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2p3_v4p3__3_7:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[4:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v8, 0
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:3]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v6, v3
; GFX900-NEXT:    global_store_dwordx2 v8, v[6:7], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2p3_v4p3__3_7:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[4:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v8, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:3]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v6, v3
; GFX90A-NEXT:    global_store_dwordx2 v8, v[6:7], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: v_shuffle_v2p3_v4p3__3_7:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def v[4:7]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    v_mov_b32_e32 v8, 0
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def v[0:3]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_nop 0
; GFX940-NEXT:    v_mov_b32_e32 v6, v3
; GFX940-NEXT:    global_store_dwordx2 v8, v[6:7], s[0:1] sc0 sc1
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x ptr addrspace(3)> asm "; def $0", "=v"()
  %vec1 = call <4 x ptr addrspace(3)> asm "; def $0", "=v"()
  %shuf = shufflevector <4 x ptr addrspace(3)> %vec0, <4 x ptr addrspace(3)> %vec1, <2 x i32> <i32 3, i32 7>
  store <2 x ptr addrspace(3)> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2p3_v4p3__4_7(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2p3_v4p3__4_7:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:3]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v4, 0
; GFX900-NEXT:    v_mov_b32_e32 v1, v3
; GFX900-NEXT:    global_store_dwordx2 v4, v[0:1], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2p3_v4p3__4_7:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:3]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v4, 0
; GFX90A-NEXT:    v_mov_b32_e32 v1, v3
; GFX90A-NEXT:    global_store_dwordx2 v4, v[0:1], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: v_shuffle_v2p3_v4p3__4_7:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def v[0:3]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    v_mov_b32_e32 v4, 0
; GFX940-NEXT:    v_mov_b32_e32 v1, v3
; GFX940-NEXT:    global_store_dwordx2 v4, v[0:1], s[0:1] sc0 sc1
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x ptr addrspace(3)> asm "; def $0", "=v"()
  %vec1 = call <4 x ptr addrspace(3)> asm "; def $0", "=v"()
  %shuf = shufflevector <4 x ptr addrspace(3)> %vec0, <4 x ptr addrspace(3)> %vec1, <2 x i32> <i32 4, i32 7>
  store <2 x ptr addrspace(3)> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2p3_v4p3__5_7(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2p3_v4p3__5_7:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:3]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v4, 0
; GFX900-NEXT:    v_mov_b32_e32 v2, v3
; GFX900-NEXT:    global_store_dwordx2 v4, v[1:2], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2p3_v4p3__5_7:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:3]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v4, 0
; GFX90A-NEXT:    v_mov_b32_e32 v2, v1
; GFX90A-NEXT:    global_store_dwordx2 v4, v[2:3], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: v_shuffle_v2p3_v4p3__5_7:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def v[0:3]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    v_mov_b32_e32 v4, 0
; GFX940-NEXT:    v_mov_b32_e32 v2, v1
; GFX940-NEXT:    global_store_dwordx2 v4, v[2:3], s[0:1] sc0 sc1
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x ptr addrspace(3)> asm "; def $0", "=v"()
  %vec1 = call <4 x ptr addrspace(3)> asm "; def $0", "=v"()
  %shuf = shufflevector <4 x ptr addrspace(3)> %vec0, <4 x ptr addrspace(3)> %vec1, <2 x i32> <i32 5, i32 7>
  store <2 x ptr addrspace(3)> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v2p3_v4p3__6_7(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2p3_v4p3__6_7:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    v_mov_b32_e32 v4, 0
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:3]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    global_store_dwordx2 v4, v[2:3], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2p3_v4p3__6_7:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    v_mov_b32_e32 v4, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:3]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    global_store_dwordx2 v4, v[2:3], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: v_shuffle_v2p3_v4p3__6_7:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    v_mov_b32_e32 v4, 0
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def v[0:3]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    global_store_dwordx2 v4, v[2:3], s[0:1] sc0 sc1
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x ptr addrspace(3)> asm "; def $0", "=v"()
  %vec1 = call <4 x ptr addrspace(3)> asm "; def $0", "=v"()
  %shuf = shufflevector <4 x ptr addrspace(3)> %vec0, <4 x ptr addrspace(3)> %vec1, <2 x i32> <i32 6, i32 7>
  store <2 x ptr addrspace(3)> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @s_shuffle_v2p3_v4p3__u_u() {
; GFX9-LABEL: s_shuffle_v2p3_v4p3__u_u:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; use s[8:9]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x ptr addrspace(3)> asm "; def $0", "=s"()
  %shuf = shufflevector <4 x ptr addrspace(3)> %vec0, <4 x ptr addrspace(3)> poison, <2 x i32> poison
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x ptr addrspace(3)> %shuf)
  ret void
}

define void @s_shuffle_v2p3_v4p3__0_u() {
; GFX900-LABEL: s_shuffle_v2p3_v4p3__0_u:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2p3_v4p3__0_u:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: s_shuffle_v2p3_v4p3__0_u:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def s[8:11]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_nop 0
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; use s[8:9]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x ptr addrspace(3)> asm "; def $0", "=s"()
  %shuf = shufflevector <4 x ptr addrspace(3)> %vec0, <4 x ptr addrspace(3)> poison, <2 x i32> <i32 0, i32 poison>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x ptr addrspace(3)> %shuf)
  ret void
}

define void @s_shuffle_v2p3_v4p3__1_u() {
; GFX900-LABEL: s_shuffle_v2p3_v4p3__1_u:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s5
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2p3_v4p3__1_u:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s5
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: s_shuffle_v2p3_v4p3__1_u:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def s[0:3]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_mov_b32 s8, s1
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; use s[8:9]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x ptr addrspace(3)> asm "; def $0", "=s"()
  %shuf = shufflevector <4 x ptr addrspace(3)> %vec0, <4 x ptr addrspace(3)> poison, <2 x i32> <i32 1, i32 poison>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x ptr addrspace(3)> %shuf)
  ret void
}

define void @s_shuffle_v2p3_v4p3__2_u() {
; GFX900-LABEL: s_shuffle_v2p3_v4p3__2_u:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2p3_v4p3__2_u:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: s_shuffle_v2p3_v4p3__2_u:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def s[0:3]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_mov_b64 s[8:9], s[2:3]
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; use s[8:9]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x ptr addrspace(3)> asm "; def $0", "=s"()
  %shuf = shufflevector <4 x ptr addrspace(3)> %vec0, <4 x ptr addrspace(3)> poison, <2 x i32> <i32 2, i32 poison>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x ptr addrspace(3)> %shuf)
  ret void
}

define void @s_shuffle_v2p3_v4p3__3_u() {
; GFX900-LABEL: s_shuffle_v2p3_v4p3__3_u:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s7
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2p3_v4p3__3_u:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s7
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: s_shuffle_v2p3_v4p3__3_u:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def s[0:3]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_mov_b32 s8, s3
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; use s[8:9]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x ptr addrspace(3)> asm "; def $0", "=s"()
  %shuf = shufflevector <4 x ptr addrspace(3)> %vec0, <4 x ptr addrspace(3)> poison, <2 x i32> <i32 3, i32 poison>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x ptr addrspace(3)> %shuf)
  ret void
}

define void @s_shuffle_v2p3_v4p3__4_u() {
; GFX9-LABEL: s_shuffle_v2p3_v4p3__4_u:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; use s[8:9]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x ptr addrspace(3)> asm "; def $0", "=s"()
  %shuf = shufflevector <4 x ptr addrspace(3)> %vec0, <4 x ptr addrspace(3)> poison, <2 x i32> <i32 4, i32 poison>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x ptr addrspace(3)> %shuf)
  ret void
}

define void @s_shuffle_v2p3_v4p3__5_u() {
; GFX900-LABEL: s_shuffle_v2p3_v4p3__5_u:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s5
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2p3_v4p3__5_u:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s5
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: s_shuffle_v2p3_v4p3__5_u:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def s[0:3]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_mov_b32 s8, s1
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; use s[8:9]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x ptr addrspace(3)> asm "; def $0", "=s"()
  %vec1 = call <4 x ptr addrspace(3)> asm "; def $0", "=s"()
  %shuf = shufflevector <4 x ptr addrspace(3)> %vec0, <4 x ptr addrspace(3)> %vec1, <2 x i32> <i32 5, i32 poison>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x ptr addrspace(3)> %shuf)
  ret void
}

define void @s_shuffle_v2p3_v4p3__6_u() {
; GFX900-LABEL: s_shuffle_v2p3_v4p3__6_u:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2p3_v4p3__6_u:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: s_shuffle_v2p3_v4p3__6_u:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def s[0:3]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_mov_b64 s[8:9], s[2:3]
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; use s[8:9]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x ptr addrspace(3)> asm "; def $0", "=s"()
  %vec1 = call <4 x ptr addrspace(3)> asm "; def $0", "=s"()
  %shuf = shufflevector <4 x ptr addrspace(3)> %vec0, <4 x ptr addrspace(3)> %vec1, <2 x i32> <i32 6, i32 poison>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x ptr addrspace(3)> %shuf)
  ret void
}

define void @s_shuffle_v2p3_v4p3__7_u() {
; GFX900-LABEL: s_shuffle_v2p3_v4p3__7_u:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s7
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2p3_v4p3__7_u:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s7
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: s_shuffle_v2p3_v4p3__7_u:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def s[0:3]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_mov_b32 s8, s3
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; use s[8:9]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x ptr addrspace(3)> asm "; def $0", "=s"()
  %vec1 = call <4 x ptr addrspace(3)> asm "; def $0", "=s"()
  %shuf = shufflevector <4 x ptr addrspace(3)> %vec0, <4 x ptr addrspace(3)> %vec1, <2 x i32> <i32 7, i32 poison>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x ptr addrspace(3)> %shuf)
  ret void
}

define void @s_shuffle_v2p3_v4p3__7_0() {
; GFX900-LABEL: s_shuffle_v2p3_v4p3__7_0:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s11
; GFX900-NEXT:    s_mov_b32 s9, s4
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2p3_v4p3__7_0:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s11
; GFX90A-NEXT:    s_mov_b32 s9, s4
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: s_shuffle_v2p3_v4p3__7_0:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def s[0:3]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def s[4:7]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_mov_b32 s8, s7
; GFX940-NEXT:    s_mov_b32 s9, s0
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; use s[8:9]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x ptr addrspace(3)> asm "; def $0", "=s"()
  %vec1 = call <4 x ptr addrspace(3)> asm "; def $0", "=s"()
  %shuf = shufflevector <4 x ptr addrspace(3)> %vec0, <4 x ptr addrspace(3)> %vec1, <2 x i32> <i32 7, i32 0>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x ptr addrspace(3)> %shuf)
  ret void
}

define void @s_shuffle_v2p3_v4p3__7_1() {
; GFX900-LABEL: s_shuffle_v2p3_v4p3__7_1:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s7
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2p3_v4p3__7_1:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s7
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: s_shuffle_v2p3_v4p3__7_1:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def s[8:11]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def s[0:3]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_mov_b32 s8, s3
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; use s[8:9]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x ptr addrspace(3)> asm "; def $0", "=s"()
  %vec1 = call <4 x ptr addrspace(3)> asm "; def $0", "=s"()
  %shuf = shufflevector <4 x ptr addrspace(3)> %vec0, <4 x ptr addrspace(3)> %vec1, <2 x i32> <i32 7, i32 1>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x ptr addrspace(3)> %shuf)
  ret void
}

define void @s_shuffle_v2p3_v4p3__7_2() {
; GFX900-LABEL: s_shuffle_v2p3_v4p3__7_2:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s11
; GFX900-NEXT:    s_mov_b32 s9, s6
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2p3_v4p3__7_2:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s11
; GFX90A-NEXT:    s_mov_b32 s9, s6
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: s_shuffle_v2p3_v4p3__7_2:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def s[0:3]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def s[4:7]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_mov_b32 s8, s7
; GFX940-NEXT:    s_mov_b32 s9, s2
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; use s[8:9]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x ptr addrspace(3)> asm "; def $0", "=s"()
  %vec1 = call <4 x ptr addrspace(3)> asm "; def $0", "=s"()
  %shuf = shufflevector <4 x ptr addrspace(3)> %vec0, <4 x ptr addrspace(3)> %vec1, <2 x i32> <i32 7, i32 2>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x ptr addrspace(3)> %shuf)
  ret void
}

define void @s_shuffle_v2p3_v4p3__7_3() {
; GFX900-LABEL: s_shuffle_v2p3_v4p3__7_3:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s6, s11
; GFX900-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2p3_v4p3__7_3:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s6, s11
; GFX90A-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: s_shuffle_v2p3_v4p3__7_3:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def s[0:3]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def s[4:7]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_mov_b32 s2, s7
; GFX940-NEXT:    s_mov_b64 s[8:9], s[2:3]
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; use s[8:9]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x ptr addrspace(3)> asm "; def $0", "=s"()
  %vec1 = call <4 x ptr addrspace(3)> asm "; def $0", "=s"()
  %shuf = shufflevector <4 x ptr addrspace(3)> %vec0, <4 x ptr addrspace(3)> %vec1, <2 x i32> <i32 7, i32 3>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x ptr addrspace(3)> %shuf)
  ret void
}

define void @s_shuffle_v2p3_v4p3__7_4() {
; GFX900-LABEL: s_shuffle_v2p3_v4p3__7_4:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s7
; GFX900-NEXT:    s_mov_b32 s9, s4
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2p3_v4p3__7_4:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s7
; GFX90A-NEXT:    s_mov_b32 s9, s4
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: s_shuffle_v2p3_v4p3__7_4:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def s[0:3]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_mov_b32 s8, s3
; GFX940-NEXT:    s_mov_b32 s9, s0
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; use s[8:9]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x ptr addrspace(3)> asm "; def $0", "=s"()
  %vec1 = call <4 x ptr addrspace(3)> asm "; def $0", "=s"()
  %shuf = shufflevector <4 x ptr addrspace(3)> %vec0, <4 x ptr addrspace(3)> %vec1, <2 x i32> <i32 7, i32 4>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x ptr addrspace(3)> %shuf)
  ret void
}

define void @s_shuffle_v2p3_v4p3__7_5() {
; GFX9-LABEL: s_shuffle_v2p3_v4p3__7_5:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; def s[8:11]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_mov_b32 s8, s11
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; use s[8:9]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x ptr addrspace(3)> asm "; def $0", "=s"()
  %vec1 = call <4 x ptr addrspace(3)> asm "; def $0", "=s"()
  %shuf = shufflevector <4 x ptr addrspace(3)> %vec0, <4 x ptr addrspace(3)> %vec1, <2 x i32> <i32 7, i32 5>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x ptr addrspace(3)> %shuf)
  ret void
}

define void @s_shuffle_v2p3_v4p3__7_6() {
; GFX900-LABEL: s_shuffle_v2p3_v4p3__7_6:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s7
; GFX900-NEXT:    s_mov_b32 s9, s6
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2p3_v4p3__7_6:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s7
; GFX90A-NEXT:    s_mov_b32 s9, s6
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: s_shuffle_v2p3_v4p3__7_6:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def s[0:3]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_mov_b32 s8, s3
; GFX940-NEXT:    s_mov_b32 s9, s2
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; use s[8:9]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x ptr addrspace(3)> asm "; def $0", "=s"()
  %vec1 = call <4 x ptr addrspace(3)> asm "; def $0", "=s"()
  %shuf = shufflevector <4 x ptr addrspace(3)> %vec0, <4 x ptr addrspace(3)> %vec1, <2 x i32> <i32 7, i32 6>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x ptr addrspace(3)> %shuf)
  ret void
}

define void @s_shuffle_v2p3_v4p3__7_7() {
; GFX900-LABEL: s_shuffle_v2p3_v4p3__7_7:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s6, s7
; GFX900-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2p3_v4p3__7_7:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s6, s7
; GFX90A-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: s_shuffle_v2p3_v4p3__7_7:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def s[0:3]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_mov_b32 s2, s3
; GFX940-NEXT:    s_mov_b64 s[8:9], s[2:3]
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; use s[8:9]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x ptr addrspace(3)> asm "; def $0", "=s"()
  %vec1 = call <4 x ptr addrspace(3)> asm "; def $0", "=s"()
  %shuf = shufflevector <4 x ptr addrspace(3)> %vec0, <4 x ptr addrspace(3)> %vec1, <2 x i32> <i32 7, i32 7>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x ptr addrspace(3)> %shuf)
  ret void
}

define void @s_shuffle_v2p3_v4p3__u_0() {
; GFX900-LABEL: s_shuffle_v2p3_v4p3__u_0:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s9, s4
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2p3_v4p3__u_0:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s9, s4
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: s_shuffle_v2p3_v4p3__u_0:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def s[0:3]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_mov_b32 s9, s0
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; use s[8:9]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x ptr addrspace(3)> asm "; def $0", "=s"()
  %shuf = shufflevector <4 x ptr addrspace(3)> %vec0, <4 x ptr addrspace(3)> poison, <2 x i32> <i32 poison, i32 0>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x ptr addrspace(3)> %shuf)
  ret void
}

define void @s_shuffle_v2p3_v4p3__0_0() {
; GFX9-LABEL: s_shuffle_v2p3_v4p3__0_0:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; def s[8:11]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_mov_b32 s9, s8
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; use s[8:9]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x ptr addrspace(3)> asm "; def $0", "=s"()
  %shuf = shufflevector <4 x ptr addrspace(3)> %vec0, <4 x ptr addrspace(3)> poison, <2 x i32> zeroinitializer
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x ptr addrspace(3)> %shuf)
  ret void
}

define void @s_shuffle_v2p3_v4p3__1_0() {
; GFX900-LABEL: s_shuffle_v2p3_v4p3__1_0:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s5
; GFX900-NEXT:    s_mov_b32 s9, s4
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2p3_v4p3__1_0:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s5
; GFX90A-NEXT:    s_mov_b32 s9, s4
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: s_shuffle_v2p3_v4p3__1_0:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def s[0:3]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_mov_b32 s8, s1
; GFX940-NEXT:    s_mov_b32 s9, s0
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; use s[8:9]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x ptr addrspace(3)> asm "; def $0", "=s"()
  %shuf = shufflevector <4 x ptr addrspace(3)> %vec0, <4 x ptr addrspace(3)> poison, <2 x i32> <i32 1, i32 0>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x ptr addrspace(3)> %shuf)
  ret void
}

define void @s_shuffle_v2p3_v4p3__2_0() {
; GFX900-LABEL: s_shuffle_v2p3_v4p3__2_0:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s7, s4
; GFX900-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2p3_v4p3__2_0:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s7, s4
; GFX90A-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: s_shuffle_v2p3_v4p3__2_0:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def s[0:3]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_mov_b32 s3, s0
; GFX940-NEXT:    s_mov_b64 s[8:9], s[2:3]
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; use s[8:9]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x ptr addrspace(3)> asm "; def $0", "=s"()
  %shuf = shufflevector <4 x ptr addrspace(3)> %vec0, <4 x ptr addrspace(3)> poison, <2 x i32> <i32 2, i32 0>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x ptr addrspace(3)> %shuf)
  ret void
}

define void @s_shuffle_v2p3_v4p3__3_0() {
; GFX900-LABEL: s_shuffle_v2p3_v4p3__3_0:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s7
; GFX900-NEXT:    s_mov_b32 s9, s4
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2p3_v4p3__3_0:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s7
; GFX90A-NEXT:    s_mov_b32 s9, s4
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: s_shuffle_v2p3_v4p3__3_0:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def s[0:3]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_mov_b32 s8, s3
; GFX940-NEXT:    s_mov_b32 s9, s0
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; use s[8:9]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x ptr addrspace(3)> asm "; def $0", "=s"()
  %shuf = shufflevector <4 x ptr addrspace(3)> %vec0, <4 x ptr addrspace(3)> poison, <2 x i32> <i32 3, i32 0>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x ptr addrspace(3)> %shuf)
  ret void
}

define void @s_shuffle_v2p3_v4p3__4_0() {
; GFX900-LABEL: s_shuffle_v2p3_v4p3__4_0:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s9, s4
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2p3_v4p3__4_0:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s9, s4
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: s_shuffle_v2p3_v4p3__4_0:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def s[0:3]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_mov_b32 s9, s0
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; use s[8:9]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x ptr addrspace(3)> asm "; def $0", "=s"()
  %shuf = shufflevector <4 x ptr addrspace(3)> %vec0, <4 x ptr addrspace(3)> poison, <2 x i32> <i32 4, i32 0>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x ptr addrspace(3)> %shuf)
  ret void
}

define void @s_shuffle_v2p3_v4p3__5_0() {
; GFX900-LABEL: s_shuffle_v2p3_v4p3__5_0:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s9
; GFX900-NEXT:    s_mov_b32 s9, s4
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2p3_v4p3__5_0:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s9
; GFX90A-NEXT:    s_mov_b32 s9, s4
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: s_shuffle_v2p3_v4p3__5_0:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def s[0:3]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def s[4:7]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_mov_b32 s8, s5
; GFX940-NEXT:    s_mov_b32 s9, s0
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; use s[8:9]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x ptr addrspace(3)> asm "; def $0", "=s"()
  %vec1 = call <4 x ptr addrspace(3)> asm "; def $0", "=s"()
  %shuf = shufflevector <4 x ptr addrspace(3)> %vec0, <4 x ptr addrspace(3)> %vec1, <2 x i32> <i32 5, i32 0>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x ptr addrspace(3)> %shuf)
  ret void
}

define void @s_shuffle_v2p3_v4p3__6_0() {
; GFX900-LABEL: s_shuffle_v2p3_v4p3__6_0:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s11, s4
; GFX900-NEXT:    s_mov_b64 s[8:9], s[10:11]
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2p3_v4p3__6_0:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s11, s4
; GFX90A-NEXT:    s_mov_b64 s[8:9], s[10:11]
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: s_shuffle_v2p3_v4p3__6_0:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def s[4:7]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def s[0:3]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_mov_b32 s7, s0
; GFX940-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; use s[8:9]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x ptr addrspace(3)> asm "; def $0", "=s"()
  %vec1 = call <4 x ptr addrspace(3)> asm "; def $0", "=s"()
  %shuf = shufflevector <4 x ptr addrspace(3)> %vec0, <4 x ptr addrspace(3)> %vec1, <2 x i32> <i32 6, i32 0>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x ptr addrspace(3)> %shuf)
  ret void
}

define void @s_shuffle_v2p3_v4p3__u_1() {
; GFX900-LABEL: s_shuffle_v2p3_v4p3__u_1:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2p3_v4p3__u_1:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: s_shuffle_v2p3_v4p3__u_1:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def s[8:11]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_nop 0
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; use s[8:9]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x ptr addrspace(3)> asm "; def $0", "=s"()
  %shuf = shufflevector <4 x ptr addrspace(3)> %vec0, <4 x ptr addrspace(3)> poison, <2 x i32> <i32 poison, i32 1>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x ptr addrspace(3)> %shuf)
  ret void
}

define void @s_shuffle_v2p3_v4p3__0_1() {
; GFX900-LABEL: s_shuffle_v2p3_v4p3__0_1:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2p3_v4p3__0_1:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: s_shuffle_v2p3_v4p3__0_1:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def s[8:11]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_nop 0
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; use s[8:9]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x ptr addrspace(3)> asm "; def $0", "=s"()
  %shuf = shufflevector <4 x ptr addrspace(3)> %vec0, <4 x ptr addrspace(3)> poison, <2 x i32> <i32 0, i32 1>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x ptr addrspace(3)> %shuf)
  ret void
}

define void @s_shuffle_v2p3_v4p3__1_1() {
; GFX9-LABEL: s_shuffle_v2p3_v4p3__1_1:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; def s[8:11]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_mov_b32 s8, s9
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; use s[8:9]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x ptr addrspace(3)> asm "; def $0", "=s"()
  %shuf = shufflevector <4 x ptr addrspace(3)> %vec0, <4 x ptr addrspace(3)> poison, <2 x i32> <i32 1, i32 1>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x ptr addrspace(3)> %shuf)
  ret void
}

define void @s_shuffle_v2p3_v4p3__2_1() {
; GFX900-LABEL: s_shuffle_v2p3_v4p3__2_1:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s7, s5
; GFX900-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2p3_v4p3__2_1:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s7, s5
; GFX90A-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: s_shuffle_v2p3_v4p3__2_1:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def s[0:3]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_mov_b32 s3, s1
; GFX940-NEXT:    s_mov_b64 s[8:9], s[2:3]
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; use s[8:9]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x ptr addrspace(3)> asm "; def $0", "=s"()
  %shuf = shufflevector <4 x ptr addrspace(3)> %vec0, <4 x ptr addrspace(3)> poison, <2 x i32> <i32 2, i32 1>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x ptr addrspace(3)> %shuf)
  ret void
}

define void @s_shuffle_v2p3_v4p3__3_1() {
; GFX9-LABEL: s_shuffle_v2p3_v4p3__3_1:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; def s[8:11]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_mov_b32 s8, s11
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; use s[8:9]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x ptr addrspace(3)> asm "; def $0", "=s"()
  %shuf = shufflevector <4 x ptr addrspace(3)> %vec0, <4 x ptr addrspace(3)> poison, <2 x i32> <i32 3, i32 1>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x ptr addrspace(3)> %shuf)
  ret void
}

define void @s_shuffle_v2p3_v4p3__4_1() {
; GFX900-LABEL: s_shuffle_v2p3_v4p3__4_1:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2p3_v4p3__4_1:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: s_shuffle_v2p3_v4p3__4_1:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def s[8:11]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_nop 0
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; use s[8:9]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x ptr addrspace(3)> asm "; def $0", "=s"()
  %shuf = shufflevector <4 x ptr addrspace(3)> %vec0, <4 x ptr addrspace(3)> poison, <2 x i32> <i32 4, i32 1>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x ptr addrspace(3)> %shuf)
  ret void
}

define void @s_shuffle_v2p3_v4p3__5_1() {
; GFX900-LABEL: s_shuffle_v2p3_v4p3__5_1:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s5
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2p3_v4p3__5_1:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s5
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: s_shuffle_v2p3_v4p3__5_1:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def s[8:11]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def s[0:3]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_mov_b32 s8, s1
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; use s[8:9]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x ptr addrspace(3)> asm "; def $0", "=s"()
  %vec1 = call <4 x ptr addrspace(3)> asm "; def $0", "=s"()
  %shuf = shufflevector <4 x ptr addrspace(3)> %vec0, <4 x ptr addrspace(3)> %vec1, <2 x i32> <i32 5, i32 1>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x ptr addrspace(3)> %shuf)
  ret void
}

define void @s_shuffle_v2p3_v4p3__6_1() {
; GFX900-LABEL: s_shuffle_v2p3_v4p3__6_1:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s11, s5
; GFX900-NEXT:    s_mov_b64 s[8:9], s[10:11]
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2p3_v4p3__6_1:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s11, s5
; GFX90A-NEXT:    s_mov_b64 s[8:9], s[10:11]
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: s_shuffle_v2p3_v4p3__6_1:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def s[4:7]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def s[0:3]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_mov_b32 s7, s1
; GFX940-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; use s[8:9]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x ptr addrspace(3)> asm "; def $0", "=s"()
  %vec1 = call <4 x ptr addrspace(3)> asm "; def $0", "=s"()
  %shuf = shufflevector <4 x ptr addrspace(3)> %vec0, <4 x ptr addrspace(3)> %vec1, <2 x i32> <i32 6, i32 1>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x ptr addrspace(3)> %shuf)
  ret void
}

define void @s_shuffle_v2p3_v4p3__u_2() {
; GFX900-LABEL: s_shuffle_v2p3_v4p3__u_2:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s9, s6
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2p3_v4p3__u_2:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s9, s6
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: s_shuffle_v2p3_v4p3__u_2:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def s[0:3]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_mov_b32 s9, s2
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; use s[8:9]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x ptr addrspace(3)> asm "; def $0", "=s"()
  %shuf = shufflevector <4 x ptr addrspace(3)> %vec0, <4 x ptr addrspace(3)> poison, <2 x i32> <i32 poison, i32 2>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x ptr addrspace(3)> %shuf)
  ret void
}

define void @s_shuffle_v2p3_v4p3__0_2() {
; GFX9-LABEL: s_shuffle_v2p3_v4p3__0_2:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; def s[8:11]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_mov_b32 s9, s10
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; use s[8:9]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x ptr addrspace(3)> asm "; def $0", "=s"()
  %shuf = shufflevector <4 x ptr addrspace(3)> %vec0, <4 x ptr addrspace(3)> poison, <2 x i32> <i32 0, i32 2>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x ptr addrspace(3)> %shuf)
  ret void
}

define void @s_shuffle_v2p3_v4p3__1_2() {
; GFX900-LABEL: s_shuffle_v2p3_v4p3__1_2:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s5
; GFX900-NEXT:    s_mov_b32 s9, s6
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2p3_v4p3__1_2:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s5
; GFX90A-NEXT:    s_mov_b32 s9, s6
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: s_shuffle_v2p3_v4p3__1_2:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def s[0:3]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_mov_b32 s8, s1
; GFX940-NEXT:    s_mov_b32 s9, s2
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; use s[8:9]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x ptr addrspace(3)> asm "; def $0", "=s"()
  %shuf = shufflevector <4 x ptr addrspace(3)> %vec0, <4 x ptr addrspace(3)> poison, <2 x i32> <i32 1, i32 2>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x ptr addrspace(3)> %shuf)
  ret void
}

define void @s_shuffle_v2p3_v4p3__2_2() {
; GFX900-LABEL: s_shuffle_v2p3_v4p3__2_2:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s7, s6
; GFX900-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2p3_v4p3__2_2:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s7, s6
; GFX90A-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: s_shuffle_v2p3_v4p3__2_2:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def s[0:3]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_mov_b32 s3, s2
; GFX940-NEXT:    s_mov_b64 s[8:9], s[2:3]
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; use s[8:9]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x ptr addrspace(3)> asm "; def $0", "=s"()
  %shuf = shufflevector <4 x ptr addrspace(3)> %vec0, <4 x ptr addrspace(3)> poison, <2 x i32> <i32 2, i32 2>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x ptr addrspace(3)> %shuf)
  ret void
}

define void @s_shuffle_v2p3_v4p3__3_2() {
; GFX900-LABEL: s_shuffle_v2p3_v4p3__3_2:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s7
; GFX900-NEXT:    s_mov_b32 s9, s6
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2p3_v4p3__3_2:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s7
; GFX90A-NEXT:    s_mov_b32 s9, s6
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: s_shuffle_v2p3_v4p3__3_2:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def s[0:3]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_mov_b32 s8, s3
; GFX940-NEXT:    s_mov_b32 s9, s2
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; use s[8:9]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x ptr addrspace(3)> asm "; def $0", "=s"()
  %shuf = shufflevector <4 x ptr addrspace(3)> %vec0, <4 x ptr addrspace(3)> poison, <2 x i32> <i32 3, i32 2>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x ptr addrspace(3)> %shuf)
  ret void
}

define void @s_shuffle_v2p3_v4p3__4_2() {
; GFX900-LABEL: s_shuffle_v2p3_v4p3__4_2:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s9, s6
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2p3_v4p3__4_2:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s9, s6
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: s_shuffle_v2p3_v4p3__4_2:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def s[0:3]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_mov_b32 s9, s2
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; use s[8:9]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x ptr addrspace(3)> asm "; def $0", "=s"()
  %shuf = shufflevector <4 x ptr addrspace(3)> %vec0, <4 x ptr addrspace(3)> poison, <2 x i32> <i32 4, i32 2>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x ptr addrspace(3)> %shuf)
  ret void
}

define void @s_shuffle_v2p3_v4p3__5_2() {
; GFX900-LABEL: s_shuffle_v2p3_v4p3__5_2:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s9
; GFX900-NEXT:    s_mov_b32 s9, s6
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2p3_v4p3__5_2:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s9
; GFX90A-NEXT:    s_mov_b32 s9, s6
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: s_shuffle_v2p3_v4p3__5_2:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def s[0:3]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def s[4:7]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_mov_b32 s8, s5
; GFX940-NEXT:    s_mov_b32 s9, s2
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; use s[8:9]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x ptr addrspace(3)> asm "; def $0", "=s"()
  %vec1 = call <4 x ptr addrspace(3)> asm "; def $0", "=s"()
  %shuf = shufflevector <4 x ptr addrspace(3)> %vec0, <4 x ptr addrspace(3)> %vec1, <2 x i32> <i32 5, i32 2>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x ptr addrspace(3)> %shuf)
  ret void
}

define void @s_shuffle_v2p3_v4p3__6_2() {
; GFX900-LABEL: s_shuffle_v2p3_v4p3__6_2:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s11, s6
; GFX900-NEXT:    s_mov_b64 s[8:9], s[10:11]
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2p3_v4p3__6_2:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s11, s6
; GFX90A-NEXT:    s_mov_b64 s[8:9], s[10:11]
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: s_shuffle_v2p3_v4p3__6_2:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def s[4:7]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def s[0:3]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_mov_b32 s7, s2
; GFX940-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; use s[8:9]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x ptr addrspace(3)> asm "; def $0", "=s"()
  %vec1 = call <4 x ptr addrspace(3)> asm "; def $0", "=s"()
  %shuf = shufflevector <4 x ptr addrspace(3)> %vec0, <4 x ptr addrspace(3)> %vec1, <2 x i32> <i32 6, i32 2>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x ptr addrspace(3)> %shuf)
  ret void
}

define void @s_shuffle_v2p3_v4p3__u_3() {
; GFX900-LABEL: s_shuffle_v2p3_v4p3__u_3:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2p3_v4p3__u_3:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: s_shuffle_v2p3_v4p3__u_3:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def s[0:3]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_mov_b64 s[8:9], s[2:3]
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; use s[8:9]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x ptr addrspace(3)> asm "; def $0", "=s"()
  %shuf = shufflevector <4 x ptr addrspace(3)> %vec0, <4 x ptr addrspace(3)> poison, <2 x i32> <i32 poison, i32 3>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x ptr addrspace(3)> %shuf)
  ret void
}

define void @s_shuffle_v2p3_v4p3__0_3() {
; GFX9-LABEL: s_shuffle_v2p3_v4p3__0_3:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; def s[8:11]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_mov_b32 s9, s11
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; use s[8:9]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x ptr addrspace(3)> asm "; def $0", "=s"()
  %shuf = shufflevector <4 x ptr addrspace(3)> %vec0, <4 x ptr addrspace(3)> poison, <2 x i32> <i32 0, i32 3>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x ptr addrspace(3)> %shuf)
  ret void
}

define void @s_shuffle_v2p3_v4p3__1_3() {
; GFX900-LABEL: s_shuffle_v2p3_v4p3__1_3:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s6, s5
; GFX900-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2p3_v4p3__1_3:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s6, s5
; GFX90A-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: s_shuffle_v2p3_v4p3__1_3:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def s[0:3]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_mov_b32 s2, s1
; GFX940-NEXT:    s_mov_b64 s[8:9], s[2:3]
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; use s[8:9]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x ptr addrspace(3)> asm "; def $0", "=s"()
  %shuf = shufflevector <4 x ptr addrspace(3)> %vec0, <4 x ptr addrspace(3)> poison, <2 x i32> <i32 1, i32 3>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x ptr addrspace(3)> %shuf)
  ret void
}

define void @s_shuffle_v2p3_v4p3__2_3() {
; GFX900-LABEL: s_shuffle_v2p3_v4p3__2_3:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2p3_v4p3__2_3:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: s_shuffle_v2p3_v4p3__2_3:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def s[0:3]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_mov_b64 s[8:9], s[2:3]
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; use s[8:9]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x ptr addrspace(3)> asm "; def $0", "=s"()
  %shuf = shufflevector <4 x ptr addrspace(3)> %vec0, <4 x ptr addrspace(3)> poison, <2 x i32> <i32 2, i32 3>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x ptr addrspace(3)> %shuf)
  ret void
}

define void @s_shuffle_v2p3_v4p3__3_3() {
; GFX900-LABEL: s_shuffle_v2p3_v4p3__3_3:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s6, s7
; GFX900-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2p3_v4p3__3_3:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s6, s7
; GFX90A-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: s_shuffle_v2p3_v4p3__3_3:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def s[0:3]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_mov_b32 s2, s3
; GFX940-NEXT:    s_mov_b64 s[8:9], s[2:3]
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; use s[8:9]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x ptr addrspace(3)> asm "; def $0", "=s"()
  %shuf = shufflevector <4 x ptr addrspace(3)> %vec0, <4 x ptr addrspace(3)> poison, <2 x i32> <i32 3, i32 3>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x ptr addrspace(3)> %shuf)
  ret void
}

define void @s_shuffle_v2p3_v4p3__4_3() {
; GFX900-LABEL: s_shuffle_v2p3_v4p3__4_3:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2p3_v4p3__4_3:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: s_shuffle_v2p3_v4p3__4_3:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def s[0:3]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_mov_b64 s[8:9], s[2:3]
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; use s[8:9]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x ptr addrspace(3)> asm "; def $0", "=s"()
  %shuf = shufflevector <4 x ptr addrspace(3)> %vec0, <4 x ptr addrspace(3)> poison, <2 x i32> <i32 4, i32 3>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x ptr addrspace(3)> %shuf)
  ret void
}

define void @s_shuffle_v2p3_v4p3__5_3() {
; GFX900-LABEL: s_shuffle_v2p3_v4p3__5_3:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s6, s9
; GFX900-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2p3_v4p3__5_3:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s6, s9
; GFX90A-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: s_shuffle_v2p3_v4p3__5_3:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def s[0:3]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def s[4:7]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_mov_b32 s2, s5
; GFX940-NEXT:    s_mov_b64 s[8:9], s[2:3]
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; use s[8:9]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x ptr addrspace(3)> asm "; def $0", "=s"()
  %vec1 = call <4 x ptr addrspace(3)> asm "; def $0", "=s"()
  %shuf = shufflevector <4 x ptr addrspace(3)> %vec0, <4 x ptr addrspace(3)> %vec1, <2 x i32> <i32 5, i32 3>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x ptr addrspace(3)> %shuf)
  ret void
}

define void @s_shuffle_v2p3_v4p3__6_3() {
; GFX900-LABEL: s_shuffle_v2p3_v4p3__6_3:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s11, s7
; GFX900-NEXT:    s_mov_b64 s[8:9], s[10:11]
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2p3_v4p3__6_3:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s11, s7
; GFX90A-NEXT:    s_mov_b64 s[8:9], s[10:11]
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: s_shuffle_v2p3_v4p3__6_3:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def s[4:7]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def s[0:3]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_mov_b32 s7, s3
; GFX940-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; use s[8:9]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x ptr addrspace(3)> asm "; def $0", "=s"()
  %vec1 = call <4 x ptr addrspace(3)> asm "; def $0", "=s"()
  %shuf = shufflevector <4 x ptr addrspace(3)> %vec0, <4 x ptr addrspace(3)> %vec1, <2 x i32> <i32 6, i32 3>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x ptr addrspace(3)> %shuf)
  ret void
}

define void @s_shuffle_v2p3_v4p3__u_4() {
; GFX9-LABEL: s_shuffle_v2p3_v4p3__u_4:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; use s[8:9]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x ptr addrspace(3)> asm "; def $0", "=s"()
  %shuf = shufflevector <4 x ptr addrspace(3)> %vec0, <4 x ptr addrspace(3)> poison, <2 x i32> <i32 poison, i32 4>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x ptr addrspace(3)> %shuf)
  ret void
}

define void @s_shuffle_v2p3_v4p3__0_4() {
; GFX900-LABEL: s_shuffle_v2p3_v4p3__0_4:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2p3_v4p3__0_4:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: s_shuffle_v2p3_v4p3__0_4:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def s[8:11]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_nop 0
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; use s[8:9]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x ptr addrspace(3)> asm "; def $0", "=s"()
  %shuf = shufflevector <4 x ptr addrspace(3)> %vec0, <4 x ptr addrspace(3)> poison, <2 x i32> <i32 0, i32 4>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x ptr addrspace(3)> %shuf)
  ret void
}

define void @s_shuffle_v2p3_v4p3__1_4() {
; GFX900-LABEL: s_shuffle_v2p3_v4p3__1_4:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s5
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2p3_v4p3__1_4:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s5
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: s_shuffle_v2p3_v4p3__1_4:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def s[0:3]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_mov_b32 s8, s1
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; use s[8:9]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x ptr addrspace(3)> asm "; def $0", "=s"()
  %shuf = shufflevector <4 x ptr addrspace(3)> %vec0, <4 x ptr addrspace(3)> poison, <2 x i32> <i32 1, i32 4>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x ptr addrspace(3)> %shuf)
  ret void
}

define void @s_shuffle_v2p3_v4p3__2_4() {
; GFX900-LABEL: s_shuffle_v2p3_v4p3__2_4:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2p3_v4p3__2_4:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: s_shuffle_v2p3_v4p3__2_4:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def s[0:3]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_mov_b64 s[8:9], s[2:3]
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; use s[8:9]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x ptr addrspace(3)> asm "; def $0", "=s"()
  %shuf = shufflevector <4 x ptr addrspace(3)> %vec0, <4 x ptr addrspace(3)> poison, <2 x i32> <i32 2, i32 4>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x ptr addrspace(3)> %shuf)
  ret void
}

define void @s_shuffle_v2p3_v4p3__3_4() {
; GFX900-LABEL: s_shuffle_v2p3_v4p3__3_4:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s7
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2p3_v4p3__3_4:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s7
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: s_shuffle_v2p3_v4p3__3_4:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def s[0:3]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_mov_b32 s8, s3
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; use s[8:9]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x ptr addrspace(3)> asm "; def $0", "=s"()
  %shuf = shufflevector <4 x ptr addrspace(3)> %vec0, <4 x ptr addrspace(3)> poison, <2 x i32> <i32 3, i32 4>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x ptr addrspace(3)> %shuf)
  ret void
}

define void @s_shuffle_v2p3_v4p3__4_4() {
; GFX9-LABEL: s_shuffle_v2p3_v4p3__4_4:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; use s[8:9]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x ptr addrspace(3)> asm "; def $0", "=s"()
  %shuf = shufflevector <4 x ptr addrspace(3)> %vec0, <4 x ptr addrspace(3)> poison, <2 x i32> <i32 4, i32 4>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x ptr addrspace(3)> %shuf)
  ret void
}

define void @s_shuffle_v2p3_v4p3__5_4() {
; GFX900-LABEL: s_shuffle_v2p3_v4p3__5_4:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s5
; GFX900-NEXT:    s_mov_b32 s9, s4
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2p3_v4p3__5_4:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s5
; GFX90A-NEXT:    s_mov_b32 s9, s4
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: s_shuffle_v2p3_v4p3__5_4:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def s[0:3]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_mov_b32 s8, s1
; GFX940-NEXT:    s_mov_b32 s9, s0
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; use s[8:9]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x ptr addrspace(3)> asm "; def $0", "=s"()
  %vec1 = call <4 x ptr addrspace(3)> asm "; def $0", "=s"()
  %shuf = shufflevector <4 x ptr addrspace(3)> %vec0, <4 x ptr addrspace(3)> %vec1, <2 x i32> <i32 5, i32 4>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x ptr addrspace(3)> %shuf)
  ret void
}

define void @s_shuffle_v2p3_v4p3__6_4() {
; GFX900-LABEL: s_shuffle_v2p3_v4p3__6_4:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s7, s4
; GFX900-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2p3_v4p3__6_4:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s7, s4
; GFX90A-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: s_shuffle_v2p3_v4p3__6_4:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def s[0:3]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_mov_b32 s3, s0
; GFX940-NEXT:    s_mov_b64 s[8:9], s[2:3]
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; use s[8:9]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x ptr addrspace(3)> asm "; def $0", "=s"()
  %vec1 = call <4 x ptr addrspace(3)> asm "; def $0", "=s"()
  %shuf = shufflevector <4 x ptr addrspace(3)> %vec0, <4 x ptr addrspace(3)> %vec1, <2 x i32> <i32 6, i32 4>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x ptr addrspace(3)> %shuf)
  ret void
}

define void @s_shuffle_v2p3_v4p3__u_5() {
; GFX900-LABEL: s_shuffle_v2p3_v4p3__u_5:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2p3_v4p3__u_5:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: s_shuffle_v2p3_v4p3__u_5:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def s[8:11]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_nop 0
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; use s[8:9]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x ptr addrspace(3)> asm "; def $0", "=s"()
  %vec1 = call <4 x ptr addrspace(3)> asm "; def $0", "=s"()
  %shuf = shufflevector <4 x ptr addrspace(3)> %vec0, <4 x ptr addrspace(3)> %vec1, <2 x i32> <i32 poison, i32 5>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x ptr addrspace(3)> %shuf)
  ret void
}

define void @s_shuffle_v2p3_v4p3__0_5() {
; GFX900-LABEL: s_shuffle_v2p3_v4p3__0_5:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s9, s5
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2p3_v4p3__0_5:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s9, s5
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: s_shuffle_v2p3_v4p3__0_5:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def s[8:11]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def s[0:3]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_mov_b32 s9, s1
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; use s[8:9]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x ptr addrspace(3)> asm "; def $0", "=s"()
  %vec1 = call <4 x ptr addrspace(3)> asm "; def $0", "=s"()
  %shuf = shufflevector <4 x ptr addrspace(3)> %vec0, <4 x ptr addrspace(3)> %vec1, <2 x i32> <i32 0, i32 5>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x ptr addrspace(3)> %shuf)
  ret void
}

define void @s_shuffle_v2p3_v4p3__1_5() {
; GFX900-LABEL: s_shuffle_v2p3_v4p3__1_5:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s5
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2p3_v4p3__1_5:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s5
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: s_shuffle_v2p3_v4p3__1_5:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def s[8:11]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def s[0:3]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_mov_b32 s8, s1
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; use s[8:9]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x ptr addrspace(3)> asm "; def $0", "=s"()
  %vec1 = call <4 x ptr addrspace(3)> asm "; def $0", "=s"()
  %shuf = shufflevector <4 x ptr addrspace(3)> %vec0, <4 x ptr addrspace(3)> %vec1, <2 x i32> <i32 1, i32 5>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x ptr addrspace(3)> %shuf)
  ret void
}

define void @s_shuffle_v2p3_v4p3__2_5() {
; GFX900-LABEL: s_shuffle_v2p3_v4p3__2_5:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s7, s9
; GFX900-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2p3_v4p3__2_5:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s7, s9
; GFX90A-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: s_shuffle_v2p3_v4p3__2_5:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def s[0:3]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def s[4:7]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_mov_b32 s3, s5
; GFX940-NEXT:    s_mov_b64 s[8:9], s[2:3]
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; use s[8:9]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x ptr addrspace(3)> asm "; def $0", "=s"()
  %vec1 = call <4 x ptr addrspace(3)> asm "; def $0", "=s"()
  %shuf = shufflevector <4 x ptr addrspace(3)> %vec0, <4 x ptr addrspace(3)> %vec1, <2 x i32> <i32 2, i32 5>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x ptr addrspace(3)> %shuf)
  ret void
}

define void @s_shuffle_v2p3_v4p3__3_5() {
; GFX900-LABEL: s_shuffle_v2p3_v4p3__3_5:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s7
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2p3_v4p3__3_5:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s7
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: s_shuffle_v2p3_v4p3__3_5:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def s[8:11]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def s[0:3]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_mov_b32 s8, s3
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; use s[8:9]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x ptr addrspace(3)> asm "; def $0", "=s"()
  %vec1 = call <4 x ptr addrspace(3)> asm "; def $0", "=s"()
  %shuf = shufflevector <4 x ptr addrspace(3)> %vec0, <4 x ptr addrspace(3)> %vec1, <2 x i32> <i32 3, i32 5>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x ptr addrspace(3)> %shuf)
  ret void
}

define void @s_shuffle_v2p3_v4p3__4_5() {
; GFX900-LABEL: s_shuffle_v2p3_v4p3__4_5:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2p3_v4p3__4_5:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: s_shuffle_v2p3_v4p3__4_5:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def s[8:11]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_nop 0
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; use s[8:9]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x ptr addrspace(3)> asm "; def $0", "=s"()
  %vec1 = call <4 x ptr addrspace(3)> asm "; def $0", "=s"()
  %shuf = shufflevector <4 x ptr addrspace(3)> %vec0, <4 x ptr addrspace(3)> %vec1, <2 x i32> <i32 4, i32 5>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x ptr addrspace(3)> %shuf)
  ret void
}

define void @s_shuffle_v2p3_v4p3__5_5() {
; GFX9-LABEL: s_shuffle_v2p3_v4p3__5_5:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; def s[8:11]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_mov_b32 s8, s9
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; use s[8:9]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x ptr addrspace(3)> asm "; def $0", "=s"()
  %vec1 = call <4 x ptr addrspace(3)> asm "; def $0", "=s"()
  %shuf = shufflevector <4 x ptr addrspace(3)> %vec0, <4 x ptr addrspace(3)> %vec1, <2 x i32> <i32 5, i32 5>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x ptr addrspace(3)> %shuf)
  ret void
}

define void @s_shuffle_v2p3_v4p3__6_5() {
; GFX900-LABEL: s_shuffle_v2p3_v4p3__6_5:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s7, s5
; GFX900-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2p3_v4p3__6_5:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s7, s5
; GFX90A-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: s_shuffle_v2p3_v4p3__6_5:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def s[0:3]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_mov_b32 s3, s1
; GFX940-NEXT:    s_mov_b64 s[8:9], s[2:3]
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; use s[8:9]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x ptr addrspace(3)> asm "; def $0", "=s"()
  %vec1 = call <4 x ptr addrspace(3)> asm "; def $0", "=s"()
  %shuf = shufflevector <4 x ptr addrspace(3)> %vec0, <4 x ptr addrspace(3)> %vec1, <2 x i32> <i32 6, i32 5>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x ptr addrspace(3)> %shuf)
  ret void
}

define void @s_shuffle_v2p3_v4p3__u_6() {
; GFX900-LABEL: s_shuffle_v2p3_v4p3__u_6:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s9, s6
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2p3_v4p3__u_6:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s9, s6
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: s_shuffle_v2p3_v4p3__u_6:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def s[0:3]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_mov_b32 s9, s2
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; use s[8:9]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x ptr addrspace(3)> asm "; def $0", "=s"()
  %vec1 = call <4 x ptr addrspace(3)> asm "; def $0", "=s"()
  %shuf = shufflevector <4 x ptr addrspace(3)> %vec0, <4 x ptr addrspace(3)> %vec1, <2 x i32> <i32 poison, i32 6>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x ptr addrspace(3)> %shuf)
  ret void
}

define void @s_shuffle_v2p3_v4p3__0_6() {
; GFX900-LABEL: s_shuffle_v2p3_v4p3__0_6:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s9, s6
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2p3_v4p3__0_6:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s9, s6
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: s_shuffle_v2p3_v4p3__0_6:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def s[8:11]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def s[0:3]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_mov_b32 s9, s2
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; use s[8:9]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x ptr addrspace(3)> asm "; def $0", "=s"()
  %vec1 = call <4 x ptr addrspace(3)> asm "; def $0", "=s"()
  %shuf = shufflevector <4 x ptr addrspace(3)> %vec0, <4 x ptr addrspace(3)> %vec1, <2 x i32> <i32 0, i32 6>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x ptr addrspace(3)> %shuf)
  ret void
}

define void @s_shuffle_v2p3_v4p3__1_6() {
; GFX900-LABEL: s_shuffle_v2p3_v4p3__1_6:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s5
; GFX900-NEXT:    s_mov_b32 s9, s10
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2p3_v4p3__1_6:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s5
; GFX90A-NEXT:    s_mov_b32 s9, s10
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: s_shuffle_v2p3_v4p3__1_6:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def s[0:3]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def s[4:7]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_mov_b32 s8, s1
; GFX940-NEXT:    s_mov_b32 s9, s6
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; use s[8:9]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x ptr addrspace(3)> asm "; def $0", "=s"()
  %vec1 = call <4 x ptr addrspace(3)> asm "; def $0", "=s"()
  %shuf = shufflevector <4 x ptr addrspace(3)> %vec0, <4 x ptr addrspace(3)> %vec1, <2 x i32> <i32 1, i32 6>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x ptr addrspace(3)> %shuf)
  ret void
}

define void @s_shuffle_v2p3_v4p3__2_6() {
; GFX900-LABEL: s_shuffle_v2p3_v4p3__2_6:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s7, s10
; GFX900-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2p3_v4p3__2_6:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s7, s10
; GFX90A-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: s_shuffle_v2p3_v4p3__2_6:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def s[0:3]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def s[4:7]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_mov_b32 s3, s6
; GFX940-NEXT:    s_mov_b64 s[8:9], s[2:3]
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; use s[8:9]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x ptr addrspace(3)> asm "; def $0", "=s"()
  %vec1 = call <4 x ptr addrspace(3)> asm "; def $0", "=s"()
  %shuf = shufflevector <4 x ptr addrspace(3)> %vec0, <4 x ptr addrspace(3)> %vec1, <2 x i32> <i32 2, i32 6>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x ptr addrspace(3)> %shuf)
  ret void
}

define void @s_shuffle_v2p3_v4p3__3_6() {
; GFX900-LABEL: s_shuffle_v2p3_v4p3__3_6:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s7
; GFX900-NEXT:    s_mov_b32 s9, s10
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2p3_v4p3__3_6:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s7
; GFX90A-NEXT:    s_mov_b32 s9, s10
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: s_shuffle_v2p3_v4p3__3_6:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def s[0:3]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def s[4:7]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_mov_b32 s8, s3
; GFX940-NEXT:    s_mov_b32 s9, s6
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; use s[8:9]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x ptr addrspace(3)> asm "; def $0", "=s"()
  %vec1 = call <4 x ptr addrspace(3)> asm "; def $0", "=s"()
  %shuf = shufflevector <4 x ptr addrspace(3)> %vec0, <4 x ptr addrspace(3)> %vec1, <2 x i32> <i32 3, i32 6>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x ptr addrspace(3)> %shuf)
  ret void
}

define void @s_shuffle_v2p3_v4p3__4_6() {
; GFX9-LABEL: s_shuffle_v2p3_v4p3__4_6:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; def s[8:11]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_mov_b32 s9, s10
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; use s[8:9]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x ptr addrspace(3)> asm "; def $0", "=s"()
  %vec1 = call <4 x ptr addrspace(3)> asm "; def $0", "=s"()
  %shuf = shufflevector <4 x ptr addrspace(3)> %vec0, <4 x ptr addrspace(3)> %vec1, <2 x i32> <i32 4, i32 6>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x ptr addrspace(3)> %shuf)
  ret void
}

define void @s_shuffle_v2p3_v4p3__5_6() {
; GFX900-LABEL: s_shuffle_v2p3_v4p3__5_6:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s5
; GFX900-NEXT:    s_mov_b32 s9, s6
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2p3_v4p3__5_6:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s5
; GFX90A-NEXT:    s_mov_b32 s9, s6
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: s_shuffle_v2p3_v4p3__5_6:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def s[0:3]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_mov_b32 s8, s1
; GFX940-NEXT:    s_mov_b32 s9, s2
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; use s[8:9]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x ptr addrspace(3)> asm "; def $0", "=s"()
  %vec1 = call <4 x ptr addrspace(3)> asm "; def $0", "=s"()
  %shuf = shufflevector <4 x ptr addrspace(3)> %vec0, <4 x ptr addrspace(3)> %vec1, <2 x i32> <i32 5, i32 6>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x ptr addrspace(3)> %shuf)
  ret void
}

define void @s_shuffle_v2p3_v4p3__6_6() {
; GFX900-LABEL: s_shuffle_v2p3_v4p3__6_6:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s7, s6
; GFX900-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2p3_v4p3__6_6:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s7, s6
; GFX90A-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: s_shuffle_v2p3_v4p3__6_6:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def s[0:3]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_mov_b32 s3, s2
; GFX940-NEXT:    s_mov_b64 s[8:9], s[2:3]
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; use s[8:9]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x ptr addrspace(3)> asm "; def $0", "=s"()
  %vec1 = call <4 x ptr addrspace(3)> asm "; def $0", "=s"()
  %shuf = shufflevector <4 x ptr addrspace(3)> %vec0, <4 x ptr addrspace(3)> %vec1, <2 x i32> <i32 6, i32 6>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x ptr addrspace(3)> %shuf)
  ret void
}

define void @s_shuffle_v2p3_v4p3__u_7() {
; GFX900-LABEL: s_shuffle_v2p3_v4p3__u_7:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2p3_v4p3__u_7:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: s_shuffle_v2p3_v4p3__u_7:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def s[0:3]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_mov_b64 s[8:9], s[2:3]
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; use s[8:9]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x ptr addrspace(3)> asm "; def $0", "=s"()
  %vec1 = call <4 x ptr addrspace(3)> asm "; def $0", "=s"()
  %shuf = shufflevector <4 x ptr addrspace(3)> %vec0, <4 x ptr addrspace(3)> %vec1, <2 x i32> <i32 poison, i32 7>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x ptr addrspace(3)> %shuf)
  ret void
}

define void @s_shuffle_v2p3_v4p3__0_7() {
; GFX900-LABEL: s_shuffle_v2p3_v4p3__0_7:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s9, s7
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2p3_v4p3__0_7:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s9, s7
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: s_shuffle_v2p3_v4p3__0_7:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def s[8:11]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def s[0:3]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_mov_b32 s9, s3
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; use s[8:9]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x ptr addrspace(3)> asm "; def $0", "=s"()
  %vec1 = call <4 x ptr addrspace(3)> asm "; def $0", "=s"()
  %shuf = shufflevector <4 x ptr addrspace(3)> %vec0, <4 x ptr addrspace(3)> %vec1, <2 x i32> <i32 0, i32 7>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x ptr addrspace(3)> %shuf)
  ret void
}

define void @s_shuffle_v2p3_v4p3__1_7() {
; GFX900-LABEL: s_shuffle_v2p3_v4p3__1_7:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s10, s5
; GFX900-NEXT:    s_mov_b64 s[8:9], s[10:11]
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2p3_v4p3__1_7:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s10, s5
; GFX90A-NEXT:    s_mov_b64 s[8:9], s[10:11]
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: s_shuffle_v2p3_v4p3__1_7:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def s[4:7]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def s[0:3]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_mov_b32 s6, s1
; GFX940-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; use s[8:9]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x ptr addrspace(3)> asm "; def $0", "=s"()
  %vec1 = call <4 x ptr addrspace(3)> asm "; def $0", "=s"()
  %shuf = shufflevector <4 x ptr addrspace(3)> %vec0, <4 x ptr addrspace(3)> %vec1, <2 x i32> <i32 1, i32 7>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x ptr addrspace(3)> %shuf)
  ret void
}

define void @s_shuffle_v2p3_v4p3__2_7() {
; GFX900-LABEL: s_shuffle_v2p3_v4p3__2_7:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s7, s11
; GFX900-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2p3_v4p3__2_7:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s7, s11
; GFX90A-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: s_shuffle_v2p3_v4p3__2_7:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def s[0:3]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def s[4:7]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_mov_b32 s3, s7
; GFX940-NEXT:    s_mov_b64 s[8:9], s[2:3]
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; use s[8:9]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x ptr addrspace(3)> asm "; def $0", "=s"()
  %vec1 = call <4 x ptr addrspace(3)> asm "; def $0", "=s"()
  %shuf = shufflevector <4 x ptr addrspace(3)> %vec0, <4 x ptr addrspace(3)> %vec1, <2 x i32> <i32 2, i32 7>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x ptr addrspace(3)> %shuf)
  ret void
}

define void @s_shuffle_v2p3_v4p3__3_7() {
; GFX900-LABEL: s_shuffle_v2p3_v4p3__3_7:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s10, s7
; GFX900-NEXT:    s_mov_b64 s[8:9], s[10:11]
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2p3_v4p3__3_7:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s10, s7
; GFX90A-NEXT:    s_mov_b64 s[8:9], s[10:11]
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: s_shuffle_v2p3_v4p3__3_7:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def s[4:7]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def s[0:3]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_mov_b32 s6, s3
; GFX940-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; use s[8:9]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x ptr addrspace(3)> asm "; def $0", "=s"()
  %vec1 = call <4 x ptr addrspace(3)> asm "; def $0", "=s"()
  %shuf = shufflevector <4 x ptr addrspace(3)> %vec0, <4 x ptr addrspace(3)> %vec1, <2 x i32> <i32 3, i32 7>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x ptr addrspace(3)> %shuf)
  ret void
}

define void @s_shuffle_v2p3_v4p3__4_7() {
; GFX9-LABEL: s_shuffle_v2p3_v4p3__4_7:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; def s[8:11]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_mov_b32 s9, s11
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; use s[8:9]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x ptr addrspace(3)> asm "; def $0", "=s"()
  %vec1 = call <4 x ptr addrspace(3)> asm "; def $0", "=s"()
  %shuf = shufflevector <4 x ptr addrspace(3)> %vec0, <4 x ptr addrspace(3)> %vec1, <2 x i32> <i32 4, i32 7>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x ptr addrspace(3)> %shuf)
  ret void
}

define void @s_shuffle_v2p3_v4p3__5_7() {
; GFX900-LABEL: s_shuffle_v2p3_v4p3__5_7:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s6, s5
; GFX900-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2p3_v4p3__5_7:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s6, s5
; GFX90A-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: s_shuffle_v2p3_v4p3__5_7:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def s[0:3]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_mov_b32 s2, s1
; GFX940-NEXT:    s_mov_b64 s[8:9], s[2:3]
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; use s[8:9]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x ptr addrspace(3)> asm "; def $0", "=s"()
  %vec1 = call <4 x ptr addrspace(3)> asm "; def $0", "=s"()
  %shuf = shufflevector <4 x ptr addrspace(3)> %vec0, <4 x ptr addrspace(3)> %vec1, <2 x i32> <i32 5, i32 7>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x ptr addrspace(3)> %shuf)
  ret void
}

define void @s_shuffle_v2p3_v4p3__6_7() {
; GFX900-LABEL: s_shuffle_v2p3_v4p3__6_7:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2p3_v4p3__6_7:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: s_shuffle_v2p3_v4p3__6_7:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def s[0:3]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_mov_b64 s[8:9], s[2:3]
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; use s[8:9]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x ptr addrspace(3)> asm "; def $0", "=s"()
  %vec1 = call <4 x ptr addrspace(3)> asm "; def $0", "=s"()
  %shuf = shufflevector <4 x ptr addrspace(3)> %vec0, <4 x ptr addrspace(3)> %vec1, <2 x i32> <i32 6, i32 7>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<2 x ptr addrspace(3)> %shuf)
  ret void
}
;; NOTE: These prefixes are unused and the list is autogenerated. Do not add tests below this line:
; GFX90APLUS: {{.*}}
