# twoxtwogame

A LaTeX package for visualizing 2x2 normal-form games. The package builds upon
PGF/TikZ to produce beautiful vector graphic visualizations indented for use in
scientific publications. Commands include producing graphical representations
of 2x2 games, plotting the equilibria in 2x2 games, and game embeddings for 2x2
games.


## Installation

Simply include the `twoxtwogame.sty` file in your working directory.


## Usage

Include in the preamble the `twoxtwogame` package.

```tex
\usepackage{twoxtwogame}
```

In the main document, utilize the commands that the package provides.

```tex
\cyclebrgraph~Matching Pennies has a single mixed Nash equilibrium, while
\coordinationbrgraph~two pure Nash equilibria and a single mixed Nash
equilibrium.
```

For further information, please refer to the included package documentation:
`twoxtwogame_doc.pdf` which can be built from `twoxtwogame_doc.tex`.


## Citing this package

Please use the following citation when using this package:
```
@misc{marris2024_twoxtwogame,
    title={Visualizing 2x2 Normal-Form Games: twoxtwogame LaTeX Package}, 
    author={Luke Marris and Ian Gemp and Siqi Liu and Joel Z. Leibo and Georgios Piliouras},
    year={2024},
    eprint={2402.16985},
    archivePrefix={arXiv},
    primaryClass={cs.GT},
    url={https://arxiv.org/abs/2402.16985},
}
```


## Contributing

If considering contributoing to the package, please read CONTRIBUTING.md.
This package is maintained on
[GitHub](https://github.com/google-deepmind/twoxtwogame) and mirrored on
[CTAN](https://ctan.org/pkg/twoxtwogame).


## License and disclaimer

Copyright 2024 DeepMind Technologies Limited

All software is licensed under the Apache License, Version 2.0 (Apache 2.0);
you may not use this file except in compliance with the Apache 2.0 license.
You may obtain a copy of the Apache 2.0 license at:
https://www.apache.org/licenses/LICENSE-2.0

All other materials are licensed under the Creative Commons Attribution 4.0
International License (CC-BY). You may obtain a copy of the CC-BY license at:
https://creativecommons.org/licenses/by/4.0/legalcode

Unless required by applicable law or agreed to in writing, all software and
materials distributed here under the Apache 2.0 or CC-BY licenses are
distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
either express or implied. See the licenses for the specific language governing
permissions and limitations under those licenses.

This is not an official Google product.
