/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.authenticator.jaspic;

import jakarta.security.auth.message.AuthException;
import jakarta.security.auth.message.AuthStatus;
import jakarta.security.auth.message.MessageInfo;
import jakarta.security.auth.message.config.ServerAuthContext;
import jakarta.security.auth.message.module.ServerAuthModule;
import java.util.List;
import javax.security.auth.Subject;

public class SimpleServerAuthContext
implements ServerAuthContext {
    private final List<ServerAuthModule> modules;

    public SimpleServerAuthContext(List<ServerAuthModule> list) {
        this.modules = list;
    }

    public AuthStatus validateRequest(MessageInfo messageInfo, Subject subject, Subject subject2) throws AuthException {
        for (int i = 0; i < this.modules.size(); ++i) {
            ServerAuthModule serverAuthModule = this.modules.get(i);
            AuthStatus authStatus = serverAuthModule.validateRequest(messageInfo, subject, subject2);
            if (authStatus == AuthStatus.SEND_FAILURE) continue;
            messageInfo.getMap().put("moduleIndex", i);
            return authStatus;
        }
        return AuthStatus.SEND_FAILURE;
    }

    public AuthStatus secureResponse(MessageInfo messageInfo, Subject subject) throws AuthException {
        ServerAuthModule serverAuthModule = this.modules.get((Integer)messageInfo.getMap().get("moduleIndex"));
        return serverAuthModule.secureResponse(messageInfo, subject);
    }

    public void cleanSubject(MessageInfo messageInfo, Subject subject) throws AuthException {
        for (ServerAuthModule serverAuthModule : this.modules) {
            serverAuthModule.cleanSubject(messageInfo, subject);
        }
    }
}

