/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.core.json;

import tools.jackson.core.ErrorReportConfiguration;
import tools.jackson.core.SerializableString;
import tools.jackson.core.StreamReadConstraints;
import tools.jackson.core.StreamWriteConstraints;
import tools.jackson.core.base.DecorableTSFactory;
import tools.jackson.core.io.CharacterEscapes;
import tools.jackson.core.io.SerializedString;
import tools.jackson.core.json.JsonFactory;
import tools.jackson.core.json.JsonReadFeature;
import tools.jackson.core.json.JsonWriteFeature;

public class JsonFactoryBuilder
extends DecorableTSFactory.DecorableTSFBuilder<JsonFactory, JsonFactoryBuilder> {
    protected CharacterEscapes _characterEscapes;
    protected SerializableString _rootValueSeparator;
    protected int _maximumNonEscapedChar;
    protected char _quoteChar = (char)34;

    public JsonFactoryBuilder() {
        super(StreamReadConstraints.defaults(), StreamWriteConstraints.defaults(), ErrorReportConfiguration.defaults(), JsonFactory.DEFAULT_JSON_PARSER_FEATURE_FLAGS, JsonFactory.DEFAULT_JSON_GENERATOR_FEATURE_FLAGS);
        this._rootValueSeparator = JsonFactory.DEFAULT_ROOT_VALUE_SEPARATOR;
        this._maximumNonEscapedChar = 0;
        this._quoteChar = (char)34;
    }

    public JsonFactoryBuilder(JsonFactory base) {
        super(base);
        this._characterEscapes = base._characterEscapes;
        this._rootValueSeparator = base._rootValueSeparator;
        this._maximumNonEscapedChar = base._maximumNonEscapedChar;
        this._quoteChar = base._quoteChar;
    }

    public JsonFactoryBuilder enable(JsonReadFeature f) {
        this._formatReadFeatures |= f.getMask();
        return this;
    }

    public JsonFactoryBuilder enable(JsonReadFeature first, JsonReadFeature ... other) {
        this._formatReadFeatures |= first.getMask();
        for (JsonReadFeature f : other) {
            this._formatReadFeatures |= f.getMask();
        }
        return this;
    }

    public JsonFactoryBuilder disable(JsonReadFeature f) {
        this._formatReadFeatures &= ~f.getMask();
        return this;
    }

    public JsonFactoryBuilder disable(JsonReadFeature first, JsonReadFeature ... other) {
        this._formatReadFeatures &= ~first.getMask();
        for (JsonReadFeature f : other) {
            this._formatReadFeatures &= ~f.getMask();
        }
        return this;
    }

    public JsonFactoryBuilder configure(JsonReadFeature f, boolean state) {
        return state ? this.enable(f) : this.disable(f);
    }

    public JsonFactoryBuilder enable(JsonWriteFeature f) {
        this._formatWriteFeatures |= f.getMask();
        return this;
    }

    public JsonFactoryBuilder enable(JsonWriteFeature first, JsonWriteFeature ... other) {
        this._formatWriteFeatures |= first.getMask();
        for (JsonWriteFeature f : other) {
            this._formatWriteFeatures |= f.getMask();
        }
        return this;
    }

    public JsonFactoryBuilder disable(JsonWriteFeature f) {
        this._formatWriteFeatures &= ~f.getMask();
        return this;
    }

    public JsonFactoryBuilder disable(JsonWriteFeature first, JsonWriteFeature ... other) {
        this._formatWriteFeatures &= ~first.getMask();
        for (JsonWriteFeature f : other) {
            this._formatWriteFeatures &= ~f.getMask();
        }
        return this;
    }

    public JsonFactoryBuilder configure(JsonWriteFeature f, boolean state) {
        return state ? this.enable(f) : this.disable(f);
    }

    @Override
    public JsonFactoryBuilder configureForJackson2() {
        return ((JsonFactoryBuilder)super.configureForJackson2()).disable(JsonWriteFeature.ESCAPE_FORWARD_SLASHES).disable(JsonWriteFeature.COMBINE_UNICODE_SURROGATES_IN_UTF8);
    }

    public JsonFactoryBuilder characterEscapes(CharacterEscapes esc) {
        this._characterEscapes = esc;
        return this;
    }

    public JsonFactoryBuilder rootValueSeparator(String sep) {
        this._rootValueSeparator = sep == null ? null : new SerializedString(sep);
        return this;
    }

    public JsonFactoryBuilder rootValueSeparator(SerializableString sep) {
        this._rootValueSeparator = sep;
        return this;
    }

    public JsonFactoryBuilder highestNonEscapedChar(int maxNonEscaped) {
        this._maximumNonEscapedChar = maxNonEscaped <= 0 ? 0 : Math.max(127, maxNonEscaped);
        return this;
    }

    public JsonFactoryBuilder quoteChar(char ch) {
        if (ch > '\u007f') {
            throw new IllegalArgumentException("Can only use Unicode characters up to 0x7F as quote characters");
        }
        this._quoteChar = ch;
        return this;
    }

    public CharacterEscapes characterEscapes() {
        return this._characterEscapes;
    }

    public SerializableString rootValueSeparator() {
        return this._rootValueSeparator;
    }

    public int highestNonEscapedChar() {
        return this._maximumNonEscapedChar;
    }

    public char quoteChar() {
        return this._quoteChar;
    }

    @Override
    public JsonFactory build() {
        return new JsonFactory(this);
    }
}

