/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.rowset;

import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.Executable;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sql.RowSet;
import javax.sql.RowSetInternal;
import javax.sql.rowset.WebRowSet;
import javax.sql.rowset.spi.SyncProvider;
import oracle.jdbc.driver.ClioSupport;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.logging.runtime.TraceControllerImpl;
import oracle.jdbc.rowset.OracleWebRowSet;
import oracle.jdbc.rowset.OracleWebRowSetXmlWriter;
import oracle.xml.util.XMLUtil;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.ROWSET})
class OracleWebRowSetXmlWriterImpl
implements OracleWebRowSetXmlWriter {
    private Writer xmlWriter;
    private Stack xmlTagStack;
    private static final String WEBROWSET_ELEMENT = "webRowSet";
    private static final String PROPERTIES_ELEMENT = "properties";
    private static final String METADATA_ELEMENT = "metadata";
    private static final String DATA_ELEMENT = "data";
    private static final String PROPERTY_COMMAND = "command";
    private static final String PROPERTY_CONCURRENCY = "concurrency";
    private static final String PROPERTY_DATASOURCE = "datasource";
    private static final String PROPERTY_ESCAPEPROCESSING = "escape-processing";
    private static final String PROPERTY_FETCHDIRECTION = "fetch-direction";
    private static final String PROPERTY_FETCHSIZE = "fetch-size";
    private static final String PROPERTY_ISOLATIONLEVEL = "isolation-level";
    private static final String PROPERTY_KEYCOLUMNS = "key-columns";
    private static final String PROPERTY_MAP = "map";
    private static final String PROPERTY_MAXFIELDSIZE = "max-field-size";
    private static final String PROPERTY_MAXROWS = "max-rows";
    private static final String PROPERTY_QUERYTIMEOUT = "query-timeout";
    private static final String PROPERTY_READONLY = "read-only";
    private static final String PROPERTY_ROWSETTYPE = "rowset-type";
    private static final String PROPERTY_SHOWDELETED = "show-deleted";
    private static final String PROPERTY_TABLENAME = "table-name";
    private static final String PROPERTY_URL = "url";
    private static final String PROPERTY_SYNCPROVIDER = "sync-provider";
    private static final String PROPERTY_NULL = "null";
    private static final String PROPERTY_KC_COLUMN = "column";
    private static final String PROPERTY_MAP_TYPE = "type";
    private static final String PROPERTY_MAP_CLASS = "class";
    private static final String PROPERTY_S_PROVIDERNAME = "sync-provider-name";
    private static final String PROPERTY_S_PROVIDERVENDOR = "sync-provider-vendor";
    private static final String PROPERTY_S_PROVIDERVERSION = "sync-provider-version";
    private static final String PROPERTY_S_PROVIDERGRADE = "sync-provider-grade";
    private static final String PROPERTY_S_DATASOURCELOCK = "data-source-lock";
    private static final String METADATA_COLUMNCOUNT = "column-count";
    private static final String METADATA_COLUMNDEFINITION = "column-definition";
    private static final String METADATA_COLUMNINDEX = "column-index";
    private static final String METADATA_AUTOINCREMENT = "auto-increment";
    private static final String METADATA_CASESENSITIVE = "case-sensitive";
    private static final String METADATA_CURRENCY = "currency";
    private static final String METADATA_NULLABLE = "nullable";
    private static final String METADATA_SIGNED = "signed";
    private static final String METADATA_SEARCHABLE = "searchable";
    private static final String METADATA_COLUMNDISPLAYSIZE = "column-display-size";
    private static final String METADATA_COLUMNLABEL = "column-label";
    private static final String METADATA_COLUMNNAME = "column-name";
    private static final String METADATA_SCHEMANAME = "schema-name";
    private static final String METADATA_COLUMNPRECISION = "column-precision";
    private static final String METADATA_COLUMNSCALE = "column-scale";
    private static final String METADATA_TABLENAME = "table-name";
    private static final String METADATA_CATALOGNAME = "catalog-name";
    private static final String METADATA_COLUMNTYPE = "column-type";
    private static final String METADATA_COLUMNTYPENAME = "column-type-name";
    private static final String METADATA_NULL = "null";
    private static final String DATA_CURRENTROW = "currentRow";
    private static final String DATA_INSERTROW = "insertRow";
    private static final String DATA_DELETEROW = "deleteRow";
    private static final String DATA_MODIFYROW = "modifyRow";
    private static final String DATA_COLUMNVALUE = "columnValue";
    private static final String DATA_UPDATEVALUE = "updateValue";
    private static final String DATA_NULL = "null";
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;
    private static Executable $$$methodRef$$$14;
    private static Logger $$$loggerRef$$$14;
    private static Executable $$$methodRef$$$15;
    private static Logger $$$loggerRef$$$15;
    private static Executable $$$methodRef$$$16;
    private static Logger $$$loggerRef$$$16;
    private static Executable $$$methodRef$$$17;
    private static Logger $$$loggerRef$$$17;
    private static Executable $$$methodRef$$$18;
    private static Logger $$$loggerRef$$$18;
    private static Executable $$$methodRef$$$19;
    private static Logger $$$loggerRef$$$19;
    private static Executable $$$methodRef$$$20;
    private static Logger $$$loggerRef$$$20;
    private static Executable $$$methodRef$$$21;
    private static Logger $$$loggerRef$$$21;
    private static Executable $$$methodRef$$$22;
    private static Logger $$$loggerRef$$$22;
    private static Executable $$$methodRef$$$23;
    private static Logger $$$loggerRef$$$23;
    private static Executable $$$methodRef$$$24;
    private static Logger $$$loggerRef$$$24;
    private static Executable $$$methodRef$$$25;
    private static Logger $$$loggerRef$$$25;
    private static Executable $$$methodRef$$$26;
    private static Logger $$$loggerRef$$$26;
    private static Executable $$$methodRef$$$27;
    private static Logger $$$loggerRef$$$27;
    private static Executable $$$methodRef$$$28;
    private static Logger $$$loggerRef$$$28;
    private static Executable $$$methodRef$$$29;
    private static Logger $$$loggerRef$$$29;
    private static Executable $$$methodRef$$$30;
    private static Logger $$$loggerRef$$$30;
    private static Executable $$$methodRef$$$31;
    private static Logger $$$loggerRef$$$31;
    private static Executable $$$methodRef$$$32;
    private static Logger $$$loggerRef$$$32;

    OracleWebRowSetXmlWriterImpl() {
        boolean bl = (0x1000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$32, Level.FINEST, OracleWebRowSetXmlWriterImpl.class, $$$methodRef$$$32, null, new Object[0]);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$32, Level.FINEST, OracleWebRowSetXmlWriterImpl.class, $$$methodRef$$$32, null);
                ClioSupport.exiting($$$loggerRef$$$32, Level.FINEST, OracleWebRowSetXmlWriterImpl.class, $$$methodRef$$$32, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$32, Level.FINEST, OracleWebRowSetXmlWriterImpl.class, $$$methodRef$$$32, null, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void writeXML(WebRowSet webRowSet, Writer writer) throws SQLException {
        boolean bl = (0x1000000L & TraceControllerImpl.feature) != 0L;
        try {
            void writer2;
            void webrowset;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$0, Level.FINEST, OracleWebRowSetXmlWriterImpl.class, $$$methodRef$$$0, this, webRowSet, writer);
            }
            if (!(webrowset instanceof OracleWebRowSet)) {
                SQLException sQLException = (SQLException)DatabaseError.createSqlException(359).fillInStackTrace();
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$0, Level.FINEST, OracleWebRowSetXmlWriterImpl.class, $$$methodRef$$$0, this, sQLException);
                }
                throw sQLException;
            }
            this.xmlTagStack = new Stack();
            this.xmlWriter = writer2;
            this.writeRowSet((OracleWebRowSet)webrowset);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$0, Level.FINEST, OracleWebRowSetXmlWriterImpl.class, $$$methodRef$$$0, this);
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, OracleWebRowSetXmlWriterImpl.class, $$$methodRef$$$0, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, OracleWebRowSetXmlWriterImpl.class, $$$methodRef$$$0, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public boolean writeData(RowSetInternal rowSetInternal) throws SQLException {
        boolean bl = (0x1000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$1, Level.FINEST, OracleWebRowSetXmlWriterImpl.class, $$$methodRef$$$1, this, rowSetInternal);
            }
            boolean bl2 = false;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$1, Level.FINEST, OracleWebRowSetXmlWriterImpl.class, $$$methodRef$$$1, this, bl2);
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, OracleWebRowSetXmlWriterImpl.class, $$$methodRef$$$1, this, null);
            }
            return false;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, OracleWebRowSetXmlWriterImpl.class, $$$methodRef$$$1, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void writeRowSet(OracleWebRowSet oracleWebRowSet) throws SQLException {
        boolean bl = (0x1000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$2, Level.FINEST, OracleWebRowSetXmlWriterImpl.class, $$$methodRef$$$2, this, oracleWebRowSet);
            }
            try {
                void webrowset;
                this.writeHeaderAndStartWebRowSetElement();
                this.writeProperties((OracleWebRowSet)webrowset);
                this.writeMetaData((OracleWebRowSet)webrowset);
                this.writeData((OracleWebRowSet)webrowset);
                this.endWebRowSetElement();
            }
            catch (IOException ioexception) {
                SQLException sQLException = new SQLException("IOException: " + ioexception.getMessage());
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$2, Level.FINEST, OracleWebRowSetXmlWriterImpl.class, $$$methodRef$$$2, this, sQLException);
                }
                throw sQLException;
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$2, Level.FINEST, OracleWebRowSetXmlWriterImpl.class, $$$methodRef$$$2, this);
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, OracleWebRowSetXmlWriterImpl.class, $$$methodRef$$$2, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, OracleWebRowSetXmlWriterImpl.class, $$$methodRef$$$2, this, throwable2);
            }
            throw throwable;
        }
    }

    private void writeHeaderAndStartWebRowSetElement() throws IOException {
        boolean bl = (0x1000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$3, Level.FINEST, OracleWebRowSetXmlWriterImpl.class, $$$methodRef$$$3, this, new Object[0]);
            }
            this.xmlWriter.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
            this.xmlWriter.write("\n");
            this.setCurrentTag(WEBROWSET_ELEMENT);
            this.xmlWriter.write("<webRowSet xmlns=\"http://java.sun.com/xml/ns/jdbc\"\n");
            this.xmlWriter.write("           xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n");
            this.xmlWriter.write("           xsi:schemaLocation=\"http://java.sun.com/xml/ns/jdbc ");
            this.xmlWriter.write("http://java.sun.com/xml/ns/jdbc/webrowset.xsd");
            this.xmlWriter.write("\">\n");
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$3, Level.FINEST, OracleWebRowSetXmlWriterImpl.class, $$$methodRef$$$3, this);
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, OracleWebRowSetXmlWriterImpl.class, $$$methodRef$$$3, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, OracleWebRowSetXmlWriterImpl.class, $$$methodRef$$$3, this, throwable2);
            }
            throw throwable;
        }
    }

    private void endWebRowSetElement() throws IOException {
        boolean bl = (0x1000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$4, Level.FINEST, OracleWebRowSetXmlWriterImpl.class, $$$methodRef$$$4, this, new Object[0]);
            }
            this.endTag(WEBROWSET_ELEMENT);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$4, Level.FINEST, OracleWebRowSetXmlWriterImpl.class, $$$methodRef$$$4, this);
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, OracleWebRowSetXmlWriterImpl.class, $$$methodRef$$$4, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, OracleWebRowSetXmlWriterImpl.class, $$$methodRef$$$4, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void startElement(String string) throws IOException {
        boolean bl = (0x1000000L & TraceControllerImpl.feature) != 0L;
        try {
            void elementName;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$5, Level.FINEST, OracleWebRowSetXmlWriterImpl.class, $$$methodRef$$$5, this, string);
            }
            this.startTag((String)elementName);
            this.xmlWriter.write("\n");
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$5, Level.FINEST, OracleWebRowSetXmlWriterImpl.class, $$$methodRef$$$5, this);
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, OracleWebRowSetXmlWriterImpl.class, $$$methodRef$$$5, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, OracleWebRowSetXmlWriterImpl.class, $$$methodRef$$$5, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void endElement(String string) throws IOException {
        boolean bl = (0x1000000L & TraceControllerImpl.feature) != 0L;
        try {
            void elementName;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$6, Level.FINEST, OracleWebRowSetXmlWriterImpl.class, $$$methodRef$$$6, this, string);
            }
            this.writeIndent(this.xmlTagStack.size());
            this.endTag((String)elementName);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$6, Level.FINEST, OracleWebRowSetXmlWriterImpl.class, $$$methodRef$$$6, this);
                ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, OracleWebRowSetXmlWriterImpl.class, $$$methodRef$$$6, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, OracleWebRowSetXmlWriterImpl.class, $$$methodRef$$$6, this, throwable2);
            }
            throw throwable;
        }
    }

    private void endElement() throws IOException {
        boolean bl = (0x1000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$7, Level.FINEST, OracleWebRowSetXmlWriterImpl.class, $$$methodRef$$$7, this, new Object[0]);
            }
            this.writeIndent(this.xmlTagStack.size());
            String currentTag = this.getCurrentTag();
            this.xmlWriter.write("</" + currentTag + ">\n");
            this.xmlWriter.flush();
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$7, Level.FINEST, OracleWebRowSetXmlWriterImpl.class, $$$methodRef$$$7, this);
                ClioSupport.exiting($$$loggerRef$$$7, Level.FINEST, OracleWebRowSetXmlWriterImpl.class, $$$methodRef$$$7, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$7, Level.FINEST, OracleWebRowSetXmlWriterImpl.class, $$$methodRef$$$7, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void startTag(String string) throws IOException {
        boolean bl = (0x1000000L & TraceControllerImpl.feature) != 0L;
        try {
            void tag;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$8, Level.FINEST, OracleWebRowSetXmlWriterImpl.class, $$$methodRef$$$8, this, string);
            }
            this.setCurrentTag((String)tag);
            this.writeIndent(this.xmlTagStack.size());
            this.xmlWriter.write("<" + (String)tag + ">");
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$8, Level.FINEST, OracleWebRowSetXmlWriterImpl.class, $$$methodRef$$$8, this);
                ClioSupport.exiting($$$loggerRef$$$8, Level.FINEST, OracleWebRowSetXmlWriterImpl.class, $$$methodRef$$$8, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$8, Level.FINEST, OracleWebRowSetXmlWriterImpl.class, $$$methodRef$$$8, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void endTag(String string) throws IOException {
        boolean bl = (0x1000000L & TraceControllerImpl.feature) != 0L;
        try {
            String currentTag;
            void tag;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$9, Level.FINEST, OracleWebRowSetXmlWriterImpl.class, $$$methodRef$$$9, this, string);
            }
            if (tag.equals(currentTag = this.getCurrentTag())) {
                this.xmlWriter.write("</" + currentTag + ">\n");
            }
            this.xmlWriter.flush();
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$9, Level.FINEST, OracleWebRowSetXmlWriterImpl.class, $$$methodRef$$$9, this);
                ClioSupport.exiting($$$loggerRef$$$9, Level.FINEST, OracleWebRowSetXmlWriterImpl.class, $$$methodRef$$$9, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$9, Level.FINEST, OracleWebRowSetXmlWriterImpl.class, $$$methodRef$$$9, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void setCurrentTag(String string) {
        boolean bl = (0x1000000L & TraceControllerImpl.feature) != 0L;
        try {
            void tag;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$10, Level.FINEST, OracleWebRowSetXmlWriterImpl.class, $$$methodRef$$$10, this, string);
            }
            this.xmlTagStack.push(tag);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$10, Level.FINEST, OracleWebRowSetXmlWriterImpl.class, $$$methodRef$$$10, this);
                ClioSupport.exiting($$$loggerRef$$$10, Level.FINEST, OracleWebRowSetXmlWriterImpl.class, $$$methodRef$$$10, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$10, Level.FINEST, OracleWebRowSetXmlWriterImpl.class, $$$methodRef$$$10, this, throwable2);
            }
            throw throwable;
        }
    }

    private String getCurrentTag() {
        boolean bl = (0x1000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$11, Level.FINEST, OracleWebRowSetXmlWriterImpl.class, $$$methodRef$$$11, this, new Object[0]);
            }
            String string = (String)this.xmlTagStack.pop();
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$11, Level.FINEST, OracleWebRowSetXmlWriterImpl.class, $$$methodRef$$$11, this, string);
                ClioSupport.exiting($$$loggerRef$$$11, Level.FINEST, OracleWebRowSetXmlWriterImpl.class, $$$methodRef$$$11, this, null);
            }
            return string;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$11, Level.FINEST, OracleWebRowSetXmlWriterImpl.class, $$$methodRef$$$11, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void writeEmptyElement(String string) throws IOException {
        boolean bl = (0x1000000L & TraceControllerImpl.feature) != 0L;
        try {
            void elementName;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$12, Level.FINEST, OracleWebRowSetXmlWriterImpl.class, $$$methodRef$$$12, this, string);
            }
            this.xmlWriter.write("<" + (String)elementName + "/>");
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$12, Level.FINEST, OracleWebRowSetXmlWriterImpl.class, $$$methodRef$$$12, this);
                ClioSupport.exiting($$$loggerRef$$$12, Level.FINEST, OracleWebRowSetXmlWriterImpl.class, $$$methodRef$$$12, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$12, Level.FINEST, OracleWebRowSetXmlWriterImpl.class, $$$methodRef$$$12, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void writeProperties(OracleWebRowSet oracleWebRowSet) throws IOException {
        boolean bl = (0x1000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$13, Level.FINEST, OracleWebRowSetXmlWriterImpl.class, $$$methodRef$$$13, this, oracleWebRowSet);
            }
            this.startElement(PROPERTIES_ELEMENT);
            try {
                void webrowset;
                this.writeElementString(PROPERTY_COMMAND, webrowset.getCommand());
                this.writeElementInteger(PROPERTY_CONCURRENCY, webrowset.getConcurrency());
                this.writeElementString(PROPERTY_DATASOURCE, webrowset.getDataSourceName());
                this.writeElementBoolean(PROPERTY_ESCAPEPROCESSING, webrowset.getEscapeProcessing());
                this.writeElementInteger(PROPERTY_FETCHDIRECTION, webrowset.getFetchDirection());
                this.writeElementInteger(PROPERTY_FETCHSIZE, webrowset.getFetchSize());
                this.writeElementInteger(PROPERTY_ISOLATIONLEVEL, webrowset.getTransactionIsolation());
                this.startElement(PROPERTY_KEYCOLUMNS);
                int[] keyColumns = webrowset.getKeyColumns();
                for (int i2 = 0; keyColumns != null && i2 < keyColumns.length; ++i2) {
                    this.writeElementInteger(PROPERTY_KC_COLUMN, keyColumns[i2]);
                }
                this.endElement(PROPERTY_KEYCOLUMNS);
                this.startElement(PROPERTY_MAP);
                Map map = webrowset.getTypeMap();
                if (map != null) {
                    Set entrySet = map.entrySet();
                    for (Map.Entry entry : entrySet) {
                        this.writeElementString(PROPERTY_MAP_TYPE, (String)entry.getKey());
                        this.writeElementString(PROPERTY_MAP_CLASS, ((Class)entry.getValue()).getName());
                    }
                }
                this.endElement(PROPERTY_MAP);
                this.writeElementInteger(PROPERTY_MAXFIELDSIZE, webrowset.getMaxFieldSize());
                this.writeElementInteger(PROPERTY_MAXROWS, webrowset.getMaxRows());
                this.writeElementInteger(PROPERTY_QUERYTIMEOUT, webrowset.getQueryTimeout());
                this.writeElementBoolean(PROPERTY_READONLY, webrowset.isReadOnly());
                this.writeElementInteger(PROPERTY_ROWSETTYPE, webrowset.getType());
                this.writeElementBoolean(PROPERTY_SHOWDELETED, webrowset.getShowDeleted());
                this.writeElementString("table-name", webrowset.getTableName());
                this.writeElementString(PROPERTY_URL, webrowset.getUrl());
                this.startElement(PROPERTY_SYNCPROVIDER);
                SyncProvider syncProvider = webrowset.getSyncProvider();
                this.writeElementString(PROPERTY_S_PROVIDERNAME, syncProvider.getProviderID());
                this.writeElementString(PROPERTY_S_PROVIDERVENDOR, syncProvider.getVendor());
                this.writeElementString(PROPERTY_S_PROVIDERVERSION, syncProvider.getVersion());
                this.writeElementInteger(PROPERTY_S_PROVIDERGRADE, syncProvider.getProviderGrade());
                this.writeElementInteger(PROPERTY_S_DATASOURCELOCK, syncProvider.getDataSourceLock());
                this.endElement(PROPERTY_SYNCPROVIDER);
            }
            catch (SQLException sqlexception) {
                IOException iOException = new IOException("SQLException: " + sqlexception.getMessage());
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$13, Level.FINEST, OracleWebRowSetXmlWriterImpl.class, $$$methodRef$$$13, this, iOException);
                }
                throw iOException;
            }
            this.endElement(PROPERTIES_ELEMENT);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$13, Level.FINEST, OracleWebRowSetXmlWriterImpl.class, $$$methodRef$$$13, this);
                ClioSupport.exiting($$$loggerRef$$$13, Level.FINEST, OracleWebRowSetXmlWriterImpl.class, $$$methodRef$$$13, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$13, Level.FINEST, OracleWebRowSetXmlWriterImpl.class, $$$methodRef$$$13, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void writeMetaData(OracleWebRowSet oracleWebRowSet) throws IOException {
        boolean bl = (0x1000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$14, Level.FINEST, OracleWebRowSetXmlWriterImpl.class, $$$methodRef$$$14, this, oracleWebRowSet);
            }
            this.startElement(METADATA_ELEMENT);
            try {
                void webrowset;
                ResultSetMetaData rsmd = webrowset.getMetaData();
                int columnCount = rsmd.getColumnCount();
                this.writeElementInteger(METADATA_COLUMNCOUNT, columnCount);
                for (int j2 = 1; j2 <= columnCount; ++j2) {
                    this.startElement(METADATA_COLUMNDEFINITION);
                    this.writeElementInteger(METADATA_COLUMNINDEX, j2);
                    this.writeElementBoolean(METADATA_AUTOINCREMENT, rsmd.isAutoIncrement(j2));
                    this.writeElementBoolean(METADATA_CASESENSITIVE, rsmd.isCaseSensitive(j2));
                    this.writeElementBoolean(METADATA_CURRENCY, rsmd.isCurrency(j2));
                    this.writeElementInteger(METADATA_NULLABLE, rsmd.isNullable(j2));
                    this.writeElementBoolean(METADATA_SIGNED, rsmd.isSigned(j2));
                    this.writeElementBoolean(METADATA_SEARCHABLE, rsmd.isSearchable(j2));
                    this.writeElementInteger(METADATA_COLUMNDISPLAYSIZE, rsmd.getColumnDisplaySize(j2));
                    this.writeElementString(METADATA_COLUMNLABEL, rsmd.getColumnLabel(j2));
                    this.writeElementString(METADATA_COLUMNNAME, rsmd.getColumnName(j2));
                    this.writeElementString(METADATA_SCHEMANAME, rsmd.getSchemaName(j2));
                    this.writeElementInteger(METADATA_COLUMNPRECISION, rsmd.getPrecision(j2));
                    this.writeElementInteger(METADATA_COLUMNSCALE, rsmd.getScale(j2));
                    this.writeElementString("table-name", rsmd.getTableName(j2));
                    this.writeElementString(METADATA_CATALOGNAME, rsmd.getCatalogName(j2));
                    this.writeElementInteger(METADATA_COLUMNTYPE, rsmd.getColumnType(j2));
                    this.writeElementString(METADATA_COLUMNTYPENAME, rsmd.getColumnTypeName(j2));
                    this.endElement(METADATA_COLUMNDEFINITION);
                }
            }
            catch (SQLException sqlexception) {
                IOException iOException = new IOException("SQLException: " + sqlexception.getMessage());
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$14, Level.FINEST, OracleWebRowSetXmlWriterImpl.class, $$$methodRef$$$14, this, iOException);
                }
                throw iOException;
            }
            this.endElement(METADATA_ELEMENT);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$14, Level.FINEST, OracleWebRowSetXmlWriterImpl.class, $$$methodRef$$$14, this);
                ClioSupport.exiting($$$loggerRef$$$14, Level.FINEST, OracleWebRowSetXmlWriterImpl.class, $$$methodRef$$$14, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$14, Level.FINEST, OracleWebRowSetXmlWriterImpl.class, $$$methodRef$$$14, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void writeElementBoolean(String string, boolean bl) throws IOException {
        boolean bl2 = (0x1000000L & TraceControllerImpl.feature) != 0L;
        try {
            void flag;
            void elementName;
            if (bl2) {
                ClioSupport.entering($$$loggerRef$$$15, Level.FINEST, OracleWebRowSetXmlWriterImpl.class, $$$methodRef$$$15, this, string, bl);
            }
            this.startTag((String)elementName);
            this.writeBoolean((boolean)flag);
            this.endTag((String)elementName);
            if (bl2) {
                ClioSupport.returning($$$loggerRef$$$15, Level.FINEST, OracleWebRowSetXmlWriterImpl.class, $$$methodRef$$$15, this);
                ClioSupport.exiting($$$loggerRef$$$15, Level.FINEST, OracleWebRowSetXmlWriterImpl.class, $$$methodRef$$$15, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl2) {
                ClioSupport.exiting($$$loggerRef$$$15, Level.FINEST, OracleWebRowSetXmlWriterImpl.class, $$$methodRef$$$15, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void writeElementInteger(String string, int n2) throws IOException {
        boolean bl = (0x1000000L & TraceControllerImpl.feature) != 0L;
        try {
            void i2;
            void elementName;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$16, Level.FINEST, OracleWebRowSetXmlWriterImpl.class, $$$methodRef$$$16, this, string, n2);
            }
            this.startTag((String)elementName);
            this.writeInteger((int)i2);
            this.endTag((String)elementName);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$16, Level.FINEST, OracleWebRowSetXmlWriterImpl.class, $$$methodRef$$$16, this);
                ClioSupport.exiting($$$loggerRef$$$16, Level.FINEST, OracleWebRowSetXmlWriterImpl.class, $$$methodRef$$$16, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$16, Level.FINEST, OracleWebRowSetXmlWriterImpl.class, $$$methodRef$$$16, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void writeElementString(String string, String string2) throws IOException {
        boolean bl = (0x1000000L & TraceControllerImpl.feature) != 0L;
        try {
            void str;
            void elementName;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$17, Level.FINEST, OracleWebRowSetXmlWriterImpl.class, $$$methodRef$$$17, this, string, string2);
            }
            this.startTag((String)elementName);
            this.writeString((String)str);
            this.endTag((String)elementName);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$17, Level.FINEST, OracleWebRowSetXmlWriterImpl.class, $$$methodRef$$$17, this);
                ClioSupport.exiting($$$loggerRef$$$17, Level.FINEST, OracleWebRowSetXmlWriterImpl.class, $$$methodRef$$$17, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$17, Level.FINEST, OracleWebRowSetXmlWriterImpl.class, $$$methodRef$$$17, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void writeData(OracleWebRowSet oracleWebRowSet) throws IOException {
        boolean bl = (0x1000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$18, Level.FINEST, OracleWebRowSetXmlWriterImpl.class, $$$methodRef$$$18, this, oracleWebRowSet);
            }
            try {
                void webrowset;
                ResultSetMetaData rsmd = webrowset.getMetaData();
                int columnCount = rsmd.getColumnCount();
                this.startElement(DATA_ELEMENT);
                webrowset.beforeFirst();
                webrowset.setShowDeleted(true);
                while (webrowset.next()) {
                    if (webrowset.rowDeleted() && webrowset.rowInserted()) {
                        this.startElement(DATA_MODIFYROW);
                    } else if (webrowset.rowDeleted()) {
                        this.startElement(DATA_DELETEROW);
                    } else if (webrowset.rowInserted()) {
                        this.startElement(DATA_INSERTROW);
                    } else {
                        this.startElement(DATA_CURRENTROW);
                    }
                    for (int j2 = 1; j2 <= columnCount; ++j2) {
                        if (webrowset.columnUpdated(j2)) {
                            ResultSet resultset = webrowset.getOriginalRow();
                            resultset.next();
                            this.startTag(DATA_COLUMNVALUE);
                            this.writeValue(j2, (RowSet)resultset);
                            this.endTag(DATA_COLUMNVALUE);
                            this.startTag(DATA_UPDATEVALUE);
                            this.writeValue(j2, (RowSet)webrowset);
                            this.endTag(DATA_UPDATEVALUE);
                            continue;
                        }
                        this.startTag(DATA_COLUMNVALUE);
                        this.writeValue(j2, (RowSet)webrowset);
                        this.endTag(DATA_COLUMNVALUE);
                    }
                    this.endElement();
                }
                this.endElement(DATA_ELEMENT);
            }
            catch (SQLException sqlexception) {
                IOException iOException = new IOException("SQLException: " + sqlexception.getMessage());
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$18, Level.FINEST, OracleWebRowSetXmlWriterImpl.class, $$$methodRef$$$18, this, iOException);
                }
                throw iOException;
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$18, Level.FINEST, OracleWebRowSetXmlWriterImpl.class, $$$methodRef$$$18, this);
                ClioSupport.exiting($$$loggerRef$$$18, Level.FINEST, OracleWebRowSetXmlWriterImpl.class, $$$methodRef$$$18, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$18, Level.FINEST, OracleWebRowSetXmlWriterImpl.class, $$$methodRef$$$18, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void writeBigDecimal(BigDecimal bigDecimal) throws IOException {
        boolean bl = (0x1000000L & TraceControllerImpl.feature) != 0L;
        try {
            void bigdecimal;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$19, Level.FINEST, OracleWebRowSetXmlWriterImpl.class, $$$methodRef$$$19, this, bigDecimal);
            }
            if (bigdecimal != null) {
                this.xmlWriter.write(bigdecimal.toString());
            } else {
                this.writeEmptyElement("null");
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$19, Level.FINEST, OracleWebRowSetXmlWriterImpl.class, $$$methodRef$$$19, this);
                ClioSupport.exiting($$$loggerRef$$$19, Level.FINEST, OracleWebRowSetXmlWriterImpl.class, $$$methodRef$$$19, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$19, Level.FINEST, OracleWebRowSetXmlWriterImpl.class, $$$methodRef$$$19, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void writeBoolean(boolean bl) throws IOException {
        boolean bl2 = (0x1000000L & TraceControllerImpl.feature) != 0L;
        try {
            void flag;
            if (bl2) {
                ClioSupport.entering($$$loggerRef$$$20, Level.FINEST, OracleWebRowSetXmlWriterImpl.class, $$$methodRef$$$20, this, bl);
            }
            this.xmlWriter.write(Boolean.valueOf((boolean)flag).toString());
            if (bl2) {
                ClioSupport.returning($$$loggerRef$$$20, Level.FINEST, OracleWebRowSetXmlWriterImpl.class, $$$methodRef$$$20, this);
                ClioSupport.exiting($$$loggerRef$$$20, Level.FINEST, OracleWebRowSetXmlWriterImpl.class, $$$methodRef$$$20, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl2) {
                ClioSupport.exiting($$$loggerRef$$$20, Level.FINEST, OracleWebRowSetXmlWriterImpl.class, $$$methodRef$$$20, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void writeDouble(double d2) throws IOException {
        boolean bl = (0x1000000L & TraceControllerImpl.feature) != 0L;
        try {
            void d3;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$21, Level.FINEST, OracleWebRowSetXmlWriterImpl.class, $$$methodRef$$$21, this, d2);
            }
            this.xmlWriter.write(Double.toString((double)d3));
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$21, Level.FINEST, OracleWebRowSetXmlWriterImpl.class, $$$methodRef$$$21, this);
                ClioSupport.exiting($$$loggerRef$$$21, Level.FINEST, OracleWebRowSetXmlWriterImpl.class, $$$methodRef$$$21, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$21, Level.FINEST, OracleWebRowSetXmlWriterImpl.class, $$$methodRef$$$21, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void writeFloat(float f2) throws IOException {
        boolean bl = (0x1000000L & TraceControllerImpl.feature) != 0L;
        try {
            void f3;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$22, Level.FINEST, OracleWebRowSetXmlWriterImpl.class, $$$methodRef$$$22, this, Float.valueOf(f2));
            }
            this.xmlWriter.write(Float.toString((float)f3));
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$22, Level.FINEST, OracleWebRowSetXmlWriterImpl.class, $$$methodRef$$$22, this);
                ClioSupport.exiting($$$loggerRef$$$22, Level.FINEST, OracleWebRowSetXmlWriterImpl.class, $$$methodRef$$$22, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$22, Level.FINEST, OracleWebRowSetXmlWriterImpl.class, $$$methodRef$$$22, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void writeInteger(int n2) throws IOException {
        boolean bl = (0x1000000L & TraceControllerImpl.feature) != 0L;
        try {
            void i2;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$23, Level.FINEST, OracleWebRowSetXmlWriterImpl.class, $$$methodRef$$$23, this, n2);
            }
            this.xmlWriter.write(Integer.toString((int)i2));
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$23, Level.FINEST, OracleWebRowSetXmlWriterImpl.class, $$$methodRef$$$23, this);
                ClioSupport.exiting($$$loggerRef$$$23, Level.FINEST, OracleWebRowSetXmlWriterImpl.class, $$$methodRef$$$23, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$23, Level.FINEST, OracleWebRowSetXmlWriterImpl.class, $$$methodRef$$$23, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void writeLong(long l2) throws IOException {
        boolean bl = (0x1000000L & TraceControllerImpl.feature) != 0L;
        try {
            void l3;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$24, Level.FINEST, OracleWebRowSetXmlWriterImpl.class, $$$methodRef$$$24, this, l2);
            }
            this.xmlWriter.write(Long.toString((long)l3));
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$24, Level.FINEST, OracleWebRowSetXmlWriterImpl.class, $$$methodRef$$$24, this);
                ClioSupport.exiting($$$loggerRef$$$24, Level.FINEST, OracleWebRowSetXmlWriterImpl.class, $$$methodRef$$$24, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$24, Level.FINEST, OracleWebRowSetXmlWriterImpl.class, $$$methodRef$$$24, this, throwable2);
            }
            throw throwable;
        }
    }

    private void writeNull() throws IOException {
        boolean bl = (0x1000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$25, Level.FINEST, OracleWebRowSetXmlWriterImpl.class, $$$methodRef$$$25, this, new Object[0]);
            }
            this.writeEmptyElement("null");
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$25, Level.FINEST, OracleWebRowSetXmlWriterImpl.class, $$$methodRef$$$25, this);
                ClioSupport.exiting($$$loggerRef$$$25, Level.FINEST, OracleWebRowSetXmlWriterImpl.class, $$$methodRef$$$25, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$25, Level.FINEST, OracleWebRowSetXmlWriterImpl.class, $$$methodRef$$$25, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void writeShort(short s2) throws IOException {
        boolean bl = (0x1000000L & TraceControllerImpl.feature) != 0L;
        try {
            void shrt;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$26, Level.FINEST, OracleWebRowSetXmlWriterImpl.class, $$$methodRef$$$26, this, s2);
            }
            this.xmlWriter.write(Short.toString((short)shrt));
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$26, Level.FINEST, OracleWebRowSetXmlWriterImpl.class, $$$methodRef$$$26, this);
                ClioSupport.exiting($$$loggerRef$$$26, Level.FINEST, OracleWebRowSetXmlWriterImpl.class, $$$methodRef$$$26, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$26, Level.FINEST, OracleWebRowSetXmlWriterImpl.class, $$$methodRef$$$26, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void writeBytes(byte[] byArray) throws IOException {
        boolean bl = (0x1000000L & TraceControllerImpl.feature) != 0L;
        try {
            void b2;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$27, Level.FINEST, OracleWebRowSetXmlWriterImpl.class, $$$methodRef$$$27, this, new Object[]{byArray});
            }
            String ret = XMLUtil.printBase64Binary((byte[])b2);
            this.xmlWriter.write(ret);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$27, Level.FINEST, OracleWebRowSetXmlWriterImpl.class, $$$methodRef$$$27, this);
                ClioSupport.exiting($$$loggerRef$$$27, Level.FINEST, OracleWebRowSetXmlWriterImpl.class, $$$methodRef$$$27, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$27, Level.FINEST, OracleWebRowSetXmlWriterImpl.class, $$$methodRef$$$27, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void writeString(String string) throws IOException {
        boolean bl = (0x1000000L & TraceControllerImpl.feature) != 0L;
        try {
            void str;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$28, Level.FINEST, OracleWebRowSetXmlWriterImpl.class, $$$methodRef$$$28, this, string);
            }
            if (str != null) {
                this.xmlWriter.write((String)str);
            } else {
                this.xmlWriter.write("");
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$28, Level.FINEST, OracleWebRowSetXmlWriterImpl.class, $$$methodRef$$$28, this);
                ClioSupport.exiting($$$loggerRef$$$28, Level.FINEST, OracleWebRowSetXmlWriterImpl.class, $$$methodRef$$$28, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$28, Level.FINEST, OracleWebRowSetXmlWriterImpl.class, $$$methodRef$$$28, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void writeIndent(int n2) throws IOException {
        boolean bl = (0x1000000L & TraceControllerImpl.feature) != 0L;
        try {
            void indent;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$29, Level.FINEST, OracleWebRowSetXmlWriterImpl.class, $$$methodRef$$$29, this, n2);
            }
            for (int j2 = 1; j2 < indent; ++j2) {
                this.xmlWriter.write("  ");
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$29, Level.FINEST, OracleWebRowSetXmlWriterImpl.class, $$$methodRef$$$29, this);
                ClioSupport.exiting($$$loggerRef$$$29, Level.FINEST, OracleWebRowSetXmlWriterImpl.class, $$$methodRef$$$29, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$29, Level.FINEST, OracleWebRowSetXmlWriterImpl.class, $$$methodRef$$$29, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void writeValue(int n2, RowSet rowSet) throws IOException {
        boolean bl = (0x1000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$30, Level.FINEST, OracleWebRowSetXmlWriterImpl.class, $$$methodRef$$$30, this, n2, rowSet);
            }
            try {
                void columnIndex;
                void rowset;
                int columnType = rowset.getMetaData().getColumnType((int)columnIndex);
                switch (columnType) {
                    case -7: 
                    case 5: {
                        short shrt = rowset.getShort((int)columnIndex);
                        if (rowset.wasNull()) {
                            this.writeNull();
                            break;
                        }
                        this.writeShort(shrt);
                        break;
                    }
                    case 4: {
                        int val = rowset.getInt((int)columnIndex);
                        if (rowset.wasNull()) {
                            this.writeNull();
                            break;
                        }
                        this.writeInteger(val);
                        break;
                    }
                    case -5: {
                        long l2 = rowset.getLong((int)columnIndex);
                        if (rowset.wasNull()) {
                            this.writeNull();
                            break;
                        }
                        this.writeLong(l2);
                        break;
                    }
                    case 6: 
                    case 7: {
                        float f2 = rowset.getFloat((int)columnIndex);
                        if (rowset.wasNull()) {
                            this.writeNull();
                            break;
                        }
                        this.writeFloat(f2);
                        break;
                    }
                    case 8: {
                        double d2 = rowset.getDouble((int)columnIndex);
                        if (rowset.wasNull()) {
                            this.writeNull();
                            break;
                        }
                        this.writeDouble(d2);
                        break;
                    }
                    case 2: 
                    case 3: {
                        BigDecimal bigdec = rowset.getBigDecimal((int)columnIndex);
                        if (rowset.wasNull()) {
                            this.writeNull();
                            break;
                        }
                        this.writeBigDecimal(bigdec);
                        break;
                    }
                    case 91: {
                        Date date = rowset.getDate((int)columnIndex);
                        if (rowset.wasNull()) {
                            this.writeNull();
                            break;
                        }
                        this.writeLong(date.getTime());
                        break;
                    }
                    case 92: {
                        Time time = rowset.getTime((int)columnIndex);
                        if (rowset.wasNull()) {
                            this.writeNull();
                            break;
                        }
                        this.writeLong(time.getTime());
                        break;
                    }
                    case 93: {
                        Timestamp timestamp = rowset.getTimestamp((int)columnIndex);
                        if (rowset.wasNull()) {
                            this.writeNull();
                            break;
                        }
                        this.writeLong(timestamp.getTime());
                        break;
                    }
                    case -4: 
                    case -3: 
                    case -2: 
                    case 2004: {
                        byte[] bytes = rowset.getBytes((int)columnIndex);
                        if (rowset.wasNull()) {
                            this.writeNull();
                            break;
                        }
                        this.writeBytes(bytes);
                        break;
                    }
                    case -15: 
                    case -9: 
                    case -1: 
                    case 1: 
                    case 12: 
                    case 2005: 
                    case 2011: {
                        String str = rowset.getString((int)columnIndex);
                        if (rowset.wasNull()) {
                            this.writeNull();
                            break;
                        }
                        this.writeString(str);
                        break;
                    }
                    default: {
                        SQLException sQLException = new SQLException("The type " + columnType + " is not supported currently.");
                        if (bl) {
                            ClioSupport.throwing($$$loggerRef$$$30, Level.FINEST, OracleWebRowSetXmlWriterImpl.class, $$$methodRef$$$30, this, sQLException);
                        }
                        throw sQLException;
                    }
                }
            }
            catch (SQLException sqlexception) {
                IOException iOException = new IOException("Failed to writeValue: " + sqlexception.getMessage());
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$30, Level.FINEST, OracleWebRowSetXmlWriterImpl.class, $$$methodRef$$$30, this, iOException);
                }
                throw iOException;
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$30, Level.FINEST, OracleWebRowSetXmlWriterImpl.class, $$$methodRef$$$30, this);
                ClioSupport.exiting($$$loggerRef$$$30, Level.FINEST, OracleWebRowSetXmlWriterImpl.class, $$$methodRef$$$30, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$30, Level.FINEST, OracleWebRowSetXmlWriterImpl.class, $$$methodRef$$$30, this, throwable2);
            }
            throw throwable;
        }
    }

    protected OracleConnection getConnectionDuringExceptionHandling() {
        boolean bl = (0x1000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$31, Level.FINEST, OracleWebRowSetXmlWriterImpl.class, $$$methodRef$$$31, this, new Object[0]);
            }
            OracleConnection oracleConnection = null;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$31, Level.FINEST, OracleWebRowSetXmlWriterImpl.class, $$$methodRef$$$31, this, oracleConnection);
                ClioSupport.exiting($$$loggerRef$$$31, Level.FINEST, OracleWebRowSetXmlWriterImpl.class, $$$methodRef$$$31, this, null);
            }
            return null;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$31, Level.FINEST, OracleWebRowSetXmlWriterImpl.class, $$$methodRef$$$31, this, throwable2);
            }
            throw throwable;
        }
    }

    static {
        try {
            $$$methodRef$$$32 = OracleWebRowSetXmlWriterImpl.class.getDeclaredConstructor(new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$32 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$31 = OracleWebRowSetXmlWriterImpl.class.getDeclaredMethod("getConnectionDuringExceptionHandling", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$31 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$30 = OracleWebRowSetXmlWriterImpl.class.getDeclaredMethod("writeValue", Integer.TYPE, RowSet.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$30 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$29 = OracleWebRowSetXmlWriterImpl.class.getDeclaredMethod("writeIndent", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$29 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$28 = OracleWebRowSetXmlWriterImpl.class.getDeclaredMethod("writeString", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$28 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$27 = OracleWebRowSetXmlWriterImpl.class.getDeclaredMethod("writeBytes", byte[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$27 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$26 = OracleWebRowSetXmlWriterImpl.class.getDeclaredMethod("writeShort", Short.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$26 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$25 = OracleWebRowSetXmlWriterImpl.class.getDeclaredMethod("writeNull", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$25 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$24 = OracleWebRowSetXmlWriterImpl.class.getDeclaredMethod("writeLong", Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$24 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$23 = OracleWebRowSetXmlWriterImpl.class.getDeclaredMethod("writeInteger", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$23 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$22 = OracleWebRowSetXmlWriterImpl.class.getDeclaredMethod("writeFloat", Float.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$22 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$21 = OracleWebRowSetXmlWriterImpl.class.getDeclaredMethod("writeDouble", Double.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$21 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$20 = OracleWebRowSetXmlWriterImpl.class.getDeclaredMethod("writeBoolean", Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$20 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$19 = OracleWebRowSetXmlWriterImpl.class.getDeclaredMethod("writeBigDecimal", BigDecimal.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$19 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$18 = OracleWebRowSetXmlWriterImpl.class.getDeclaredMethod("writeData", OracleWebRowSet.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$18 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$17 = OracleWebRowSetXmlWriterImpl.class.getDeclaredMethod("writeElementString", String.class, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$17 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$16 = OracleWebRowSetXmlWriterImpl.class.getDeclaredMethod("writeElementInteger", String.class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$16 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$15 = OracleWebRowSetXmlWriterImpl.class.getDeclaredMethod("writeElementBoolean", String.class, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$15 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$14 = OracleWebRowSetXmlWriterImpl.class.getDeclaredMethod("writeMetaData", OracleWebRowSet.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$13 = OracleWebRowSetXmlWriterImpl.class.getDeclaredMethod("writeProperties", OracleWebRowSet.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$12 = OracleWebRowSetXmlWriterImpl.class.getDeclaredMethod("writeEmptyElement", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$11 = OracleWebRowSetXmlWriterImpl.class.getDeclaredMethod("getCurrentTag", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$10 = OracleWebRowSetXmlWriterImpl.class.getDeclaredMethod("setCurrentTag", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$9 = OracleWebRowSetXmlWriterImpl.class.getDeclaredMethod("endTag", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$8 = OracleWebRowSetXmlWriterImpl.class.getDeclaredMethod("startTag", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$7 = OracleWebRowSetXmlWriterImpl.class.getDeclaredMethod("endElement", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$6 = OracleWebRowSetXmlWriterImpl.class.getDeclaredMethod("endElement", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = OracleWebRowSetXmlWriterImpl.class.getDeclaredMethod("startElement", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = OracleWebRowSetXmlWriterImpl.class.getDeclaredMethod("endWebRowSetElement", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = OracleWebRowSetXmlWriterImpl.class.getDeclaredMethod("writeHeaderAndStartWebRowSetElement", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = OracleWebRowSetXmlWriterImpl.class.getDeclaredMethod("writeRowSet", OracleWebRowSet.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = OracleWebRowSetXmlWriterImpl.class.getDeclaredMethod("writeData", RowSetInternal.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = OracleWebRowSetXmlWriterImpl.class.getDeclaredMethod("writeXML", WebRowSet.class, Writer.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
    }
}

