/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.encryptionsdk.internal;

import com.amazonaws.encryptionsdk.internal.EncryptionContextSerializer;
import com.amazonaws.encryptionsdk.internal.JceKeyCipher;
import com.amazonaws.encryptionsdk.internal.Utils;
import java.nio.ByteBuffer;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.util.Map;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.spec.GCMParameterSpec;

class AesGcmJceKeyCipher
extends JceKeyCipher {
    private static final int NONCE_LENGTH = 12;
    private static final int TAG_LENGTH = 128;
    private static final String TRANSFORMATION = "AES/GCM/NoPadding";
    private static final int SPEC_LENGTH = 20;

    AesGcmJceKeyCipher(SecretKey key) {
        super(key, key);
    }

    private static byte[] specToBytes(GCMParameterSpec spec) {
        byte[] nonce = spec.getIV();
        byte[] result = new byte[20];
        ByteBuffer buffer = ByteBuffer.wrap(result);
        buffer.putInt(spec.getTLen());
        buffer.putInt(nonce.length);
        buffer.put(nonce);
        return result;
    }

    private static GCMParameterSpec bytesToSpec(byte[] data, int offset) throws InvalidKeyException {
        if (data.length - offset != 20) {
            throw new InvalidKeyException("Algorithm specification was an invalid data size");
        }
        ByteBuffer buffer = ByteBuffer.wrap(data, offset, 20);
        int tagLen = buffer.getInt();
        int nonceLen = buffer.getInt();
        if (tagLen != 128) {
            throw new InvalidKeyException(String.format("Authentication tag length must be %s", 128));
        }
        if (nonceLen != 12) {
            throw new InvalidKeyException(String.format("Initialization vector (IV) length must be %s", 12));
        }
        byte[] nonce = new byte[nonceLen];
        buffer.get(nonce);
        return new GCMParameterSpec(tagLen, nonce);
    }

    @Override
    JceKeyCipher.WrappingData buildWrappingCipher(Key key, Map<String, String> encryptionContext) throws GeneralSecurityException {
        byte[] nonce = new byte[12];
        Utils.getSecureRandom().nextBytes(nonce);
        GCMParameterSpec spec = new GCMParameterSpec(128, nonce);
        Cipher cipher = Cipher.getInstance(TRANSFORMATION);
        cipher.init(1, key, spec);
        byte[] aad = EncryptionContextSerializer.serialize(encryptionContext);
        cipher.updateAAD(aad);
        return new JceKeyCipher.WrappingData(cipher, AesGcmJceKeyCipher.specToBytes(spec));
    }

    @Override
    Cipher buildUnwrappingCipher(Key key, byte[] extraInfo, int offset, Map<String, String> encryptionContext) throws GeneralSecurityException {
        GCMParameterSpec spec = AesGcmJceKeyCipher.bytesToSpec(extraInfo, offset);
        Cipher cipher = Cipher.getInstance(TRANSFORMATION);
        cipher.init(2, key, spec);
        byte[] aad = EncryptionContextSerializer.serialize(encryptionContext);
        cipher.updateAAD(aad);
        return cipher;
    }
}

