/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.neuralsearch.highlight.utils;

import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.neuralsearch.highlight.batch.config.HighlightConfig;

public class HighlightValidator {
    @Generated
    private static final Logger log = LogManager.getLogger(HighlightValidator.class);

    public static HighlightConfig validate(HighlightConfig config, SearchResponse response) {
        if (config.getValidationError() != null) {
            return config;
        }
        if (config.getFieldName() == null || config.getFieldName().isEmpty()) {
            return config.toBuilder().validationError("No semantic highlight field specified").build();
        }
        if (config.getModelId() == null || config.getModelId().isEmpty()) {
            return config.toBuilder().validationError("Model ID is required for semantic highlighting").build();
        }
        if (config.getQueryText() == null || config.getQueryText().isEmpty()) {
            return config.toBuilder().validationError("Query text is required for semantic highlighting").build();
        }
        if (response == null || response.getHits() == null || response.getHits().getHits().length == 0) {
            return config.toBuilder().validationError("No search hits to highlight").build();
        }
        if (config.isBatchInference() && config.getMaxBatchSize() <= 0) {
            return config.toBuilder().validationError("Invalid batch size: " + config.getMaxBatchSize()).build();
        }
        return config;
    }

    public static HighlightConfig validateBasic(HighlightConfig config) {
        if (config.getValidationError() != null) {
            return config;
        }
        if (config.getFieldName() == null || config.getFieldName().isEmpty()) {
            return config.toBuilder().validationError("No semantic highlight field specified").build();
        }
        if (config.getModelId() == null || config.getModelId().isEmpty()) {
            return config.toBuilder().validationError("Model ID is required for semantic highlighting").build();
        }
        if (config.getQueryText() == null || config.getQueryText().isEmpty()) {
            return config.toBuilder().validationError("Query text is required for semantic highlighting").build();
        }
        if (config.isBatchInference() && config.getMaxBatchSize() <= 0) {
            return config.toBuilder().validationError("Invalid batch size: " + config.getMaxBatchSize()).build();
        }
        return config;
    }
}

