/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fontbox.util.autodetect;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fontbox.util.autodetect.FontDirFinder;

public abstract class NativeFontDirFinder
implements FontDirFinder {
    private static final Log LOG = LogFactory.getLog(NativeFontDirFinder.class);

    @Override
    public List<File> find() {
        ArrayList<File> fontDirList = new ArrayList<File>();
        String[] searchableDirectories = this.getSearchableDirectories();
        if (searchableDirectories != null) {
            for (String searchableDirectorie : searchableDirectories) {
                File fontDir = new File(searchableDirectorie);
                try {
                    if (!fontDir.exists() || !fontDir.canRead()) continue;
                    fontDirList.add(fontDir);
                }
                catch (SecurityException e) {
                    LOG.debug((Object)"Couldn't get native font directories - ignoring", (Throwable)e);
                }
            }
        }
        return fontDirList;
    }

    protected abstract String[] getSearchableDirectories();
}

