"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "BaseConnectionManager", {
  enumerable: true,
  get: function () {
    return _base_connection_manager.BaseConnectionManager;
  }
});
Object.defineProperty(exports, "Facet", {
  enumerable: true,
  get: function () {
    return _utils.Facet;
  }
});
Object.defineProperty(exports, "FacetProps", {
  enumerable: true,
  get: function () {
    return _utils.FacetProps;
  }
});
Object.defineProperty(exports, "MetricResult", {
  enumerable: true,
  get: function () {
    return _prometheus_manager.MetricResult;
  }
});
Object.defineProperty(exports, "OpenSearchEnhancements", {
  enumerable: true,
  get: function () {
    return _utils.OpenSearchEnhancements;
  }
});
Object.defineProperty(exports, "PromQLQueryParams", {
  enumerable: true,
  get: function () {
    return _prometheus_manager.PromQLQueryParams;
  }
});
Object.defineProperty(exports, "PromQLQueryResponse", {
  enumerable: true,
  get: function () {
    return _prometheus_manager.PromQLQueryResponse;
  }
});
Object.defineProperty(exports, "QueryEnhancementsPluginSetup", {
  enumerable: true,
  get: function () {
    return _types.QueryEnhancementsPluginSetup;
  }
});
Object.defineProperty(exports, "QueryEnhancementsPluginStart", {
  enumerable: true,
  get: function () {
    return _types.QueryEnhancementsPluginStart;
  }
});
Object.defineProperty(exports, "QueryExecutor", {
  enumerable: true,
  get: function () {
    return _base_connection_manager.QueryExecutor;
  }
});
exports.config = void 0;
exports.plugin = plugin;
Object.defineProperty(exports, "shimSchemaRow", {
  enumerable: true,
  get: function () {
    return _utils.shimSchemaRow;
  }
});
Object.defineProperty(exports, "shimStats", {
  enumerable: true,
  get: function () {
    return _utils.shimStats;
  }
});
var _plugin = require("./plugin");
var _config = require("../common/config");
var _utils = require("./utils");
var _types = require("./types");
var _base_connection_manager = require("./connections/managers/base_connection_manager");
var _prometheus_manager = require("./connections/managers/prometheus_manager");
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

const config = exports.config = {
  exposeToBrowser: {
    queryAssist: true
  },
  schema: _config.configSchema
};
function plugin(initializerContext) {
  return new _plugin.QueryEnhancementsPlugin(initializerContext);
}