/*
 * SPDX-FileCopyrightText: Copyright (c) 2003-2025 NVIDIA CORPORATION & AFFILIATES. All rights reserved.
 * SPDX-License-Identifier: MIT
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 */

#ifndef _clcc73_h_
#define _clcc73_h_

#ifdef __cplusplus
extern "C" {
#endif

#define NVCC73_DISP_CAPABILITIES 0xCC73

typedef volatile struct _clcc73_tag0 {
    NvU32 dispCapabilities[0x400];
} _NvCC73DispCapabilities,NvCC73DispCapabilities_Map ;


#define NVCC73_SYS_CAP                                                0x0 /* RW-4R */
#define NVCC73_SYS_CAP_HEAD0_EXISTS                                          0:0 /* RWIVF */
#define NVCC73_SYS_CAP_HEAD0_EXISTS_NO                                0x00000000 /* RW--V */
#define NVCC73_SYS_CAP_HEAD0_EXISTS_YES                               0x00000001 /* RW--V */
#define NVCC73_SYS_CAP_HEAD1_EXISTS                                          1:1 /* RWIVF */
#define NVCC73_SYS_CAP_HEAD1_EXISTS_NO                                0x00000000 /* RW--V */
#define NVCC73_SYS_CAP_HEAD1_EXISTS_YES                               0x00000001 /* RW--V */
#define NVCC73_SYS_CAP_HEAD2_EXISTS                                          2:2 /* RWIVF */
#define NVCC73_SYS_CAP_HEAD2_EXISTS_NO                                0x00000000 /* RW--V */
#define NVCC73_SYS_CAP_HEAD2_EXISTS_YES                               0x00000001 /* RW--V */
#define NVCC73_SYS_CAP_HEAD3_EXISTS                                          3:3 /* RWIVF */
#define NVCC73_SYS_CAP_HEAD3_EXISTS_NO                                0x00000000 /* RW--V */
#define NVCC73_SYS_CAP_HEAD3_EXISTS_YES                               0x00000001 /* RW--V */
#define NVCC73_SYS_CAP_HEAD4_EXISTS                                          4:4 /* RWIVF */
#define NVCC73_SYS_CAP_HEAD4_EXISTS_NO                                0x00000000 /* RW--V */
#define NVCC73_SYS_CAP_HEAD4_EXISTS_YES                               0x00000001 /* RW--V */
#define NVCC73_SYS_CAP_HEAD5_EXISTS                                          5:5 /* RWIVF */
#define NVCC73_SYS_CAP_HEAD5_EXISTS_NO                                0x00000000 /* RW--V */
#define NVCC73_SYS_CAP_HEAD5_EXISTS_YES                               0x00000001 /* RW--V */
#define NVCC73_SYS_CAP_HEAD6_EXISTS                                          6:6 /* RWIVF */
#define NVCC73_SYS_CAP_HEAD6_EXISTS_NO                                0x00000000 /* RW--V */
#define NVCC73_SYS_CAP_HEAD6_EXISTS_YES                               0x00000001 /* RW--V */
#define NVCC73_SYS_CAP_HEAD7_EXISTS                                          7:7 /* RWIVF */
#define NVCC73_SYS_CAP_HEAD7_EXISTS_NO                                0x00000000 /* RW--V */
#define NVCC73_SYS_CAP_HEAD7_EXISTS_YES                               0x00000001 /* RW--V */
#define NVCC73_SYS_CAP_HEAD_EXISTS(i)                            (0+(i)):(0+(i)) /* RWIVF */
#define NVCC73_SYS_CAP_HEAD_EXISTS__SIZE_1                                     8 /*       */
#define NVCC73_SYS_CAP_HEAD_EXISTS_NO                                 0x00000000 /* RW--V */
#define NVCC73_SYS_CAP_HEAD_EXISTS_YES                                0x00000001 /* RW--V */
#define NVCC73_SYS_CAP_SOR0_EXISTS                                           8:8 /* RWIVF */
#define NVCC73_SYS_CAP_SOR0_EXISTS_NO                                 0x00000000 /* RW--V */
#define NVCC73_SYS_CAP_SOR0_EXISTS_YES                                0x00000001 /* RW--V */
#define NVCC73_SYS_CAP_SOR1_EXISTS                                           9:9 /* RWIVF */
#define NVCC73_SYS_CAP_SOR1_EXISTS_NO                                 0x00000000 /* RW--V */
#define NVCC73_SYS_CAP_SOR1_EXISTS_YES                                0x00000001 /* RW--V */
#define NVCC73_SYS_CAP_SOR2_EXISTS                                         10:10 /* RWIVF */
#define NVCC73_SYS_CAP_SOR2_EXISTS_NO                                 0x00000000 /* RW--V */
#define NVCC73_SYS_CAP_SOR2_EXISTS_YES                                0x00000001 /* RW--V */
#define NVCC73_SYS_CAP_SOR3_EXISTS                                         11:11 /* RWIVF */
#define NVCC73_SYS_CAP_SOR3_EXISTS_NO                                 0x00000000 /* RW--V */
#define NVCC73_SYS_CAP_SOR3_EXISTS_YES                                0x00000001 /* RW--V */
#define NVCC73_SYS_CAP_SOR4_EXISTS                                         12:12 /* RWIVF */
#define NVCC73_SYS_CAP_SOR4_EXISTS_NO                                 0x00000000 /* RW--V */
#define NVCC73_SYS_CAP_SOR4_EXISTS_YES                                0x00000001 /* RW--V */
#define NVCC73_SYS_CAP_SOR5_EXISTS                                         13:13 /* RWIVF */
#define NVCC73_SYS_CAP_SOR5_EXISTS_NO                                 0x00000000 /* RW--V */
#define NVCC73_SYS_CAP_SOR5_EXISTS_YES                                0x00000001 /* RW--V */
#define NVCC73_SYS_CAP_SOR6_EXISTS                                         14:14 /* RWIVF */
#define NVCC73_SYS_CAP_SOR6_EXISTS_NO                                 0x00000000 /* RW--V */
#define NVCC73_SYS_CAP_SOR6_EXISTS_YES                                0x00000001 /* RW--V */
#define NVCC73_SYS_CAP_SOR7_EXISTS                                         15:15 /* RWIVF */
#define NVCC73_SYS_CAP_SOR7_EXISTS_NO                                 0x00000000 /* RW--V */
#define NVCC73_SYS_CAP_SOR7_EXISTS_YES                                0x00000001 /* RW--V */
#define NVCC73_SYS_CAP_SOR_EXISTS(i)                             (8+(i)):(8+(i)) /* RWIVF */
#define NVCC73_SYS_CAP_SOR_EXISTS__SIZE_1                                      8 /*       */
#define NVCC73_SYS_CAP_SOR_EXISTS_NO                                  0x00000000 /* RW--V */
#define NVCC73_SYS_CAP_SOR_EXISTS_YES                                 0x00000001 /* RW--V */
#define NVCC73_SYS_CAP_RISCV0_EXISTS                                       16:16 /* RWIVF */
#define NVCC73_SYS_CAP_RISCV0_EXISTS_NO                               0x00000000 /* RW--V */
#define NVCC73_SYS_CAP_RISCV0_EXISTS_YES                              0x00000001 /* RW--V */
#define NVCC73_SYS_CAP_DSI0_EXISTS                                         20:20 /* RWIVF */
#define NVCC73_SYS_CAP_DSI0_EXISTS_NO                                 0x00000000 /* RW--V */
#define NVCC73_SYS_CAP_DSI0_EXISTS_YES                                0x00000001 /* RW--V */
#define NVCC73_SYS_CAP_DSI1_EXISTS                                         21:21 /* RWIVF */
#define NVCC73_SYS_CAP_DSI1_EXISTS_NO                                 0x00000000 /* RW--V */
#define NVCC73_SYS_CAP_DSI1_EXISTS_YES                                0x00000001 /* RW--V */
#define NVCC73_SYS_CAP_DSI2_EXISTS                                         22:22 /* RWIVF */
#define NVCC73_SYS_CAP_DSI2_EXISTS_NO                                 0x00000000 /* RW--V */
#define NVCC73_SYS_CAP_DSI2_EXISTS_YES                                0x00000001 /* RW--V */
#define NVCC73_SYS_CAP_DSI3_EXISTS                                         23:23 /* RWIVF */
#define NVCC73_SYS_CAP_DSI3_EXISTS_NO                                 0x00000000 /* RW--V */
#define NVCC73_SYS_CAP_DSI3_EXISTS_YES                                0x00000001 /* RW--V */
#define NVCC73_SYS_CAP_DSI_EXISTS(i)                           (20+(i)):(20+(i)) /* RWIVF */
#define NVCC73_SYS_CAP_DSI_EXISTS__SIZE_1                                      4 /*       */
#define NVCC73_SYS_CAP_DSI_EXISTS_NO                                  0x00000000 /* RW--V */
#define NVCC73_SYS_CAP_DSI_EXISTS_YES                                 0x00000001 /* RW--V */
#define NVCC73_SYS_CAPB                                                0x4 /* RW-4R */
#define NVCC73_SYS_CAPB_WINDOW0_EXISTS                                        0:0 /* RWIVF */
#define NVCC73_SYS_CAPB_WINDOW0_EXISTS_NO                              0x00000000 /* RW--V */
#define NVCC73_SYS_CAPB_WINDOW0_EXISTS_YES                             0x00000001 /* RW--V */
#define NVCC73_SYS_CAPB_WINDOW1_EXISTS                                        1:1 /* RWIVF */
#define NVCC73_SYS_CAPB_WINDOW1_EXISTS_NO                              0x00000000 /* RW--V */
#define NVCC73_SYS_CAPB_WINDOW1_EXISTS_YES                             0x00000001 /* RW--V */
#define NVCC73_SYS_CAPB_WINDOW2_EXISTS                                        2:2 /* RWIVF */
#define NVCC73_SYS_CAPB_WINDOW2_EXISTS_NO                              0x00000000 /* RW--V */
#define NVCC73_SYS_CAPB_WINDOW2_EXISTS_YES                             0x00000001 /* RW--V */
#define NVCC73_SYS_CAPB_WINDOW3_EXISTS                                        3:3 /* RWIVF */
#define NVCC73_SYS_CAPB_WINDOW3_EXISTS_NO                              0x00000000 /* RW--V */
#define NVCC73_SYS_CAPB_WINDOW3_EXISTS_YES                             0x00000001 /* RW--V */
#define NVCC73_SYS_CAPB_WINDOW4_EXISTS                                        4:4 /* RWIVF */
#define NVCC73_SYS_CAPB_WINDOW4_EXISTS_NO                              0x00000000 /* RW--V */
#define NVCC73_SYS_CAPB_WINDOW4_EXISTS_YES                             0x00000001 /* RW--V */
#define NVCC73_SYS_CAPB_WINDOW5_EXISTS                                        5:5 /* RWIVF */
#define NVCC73_SYS_CAPB_WINDOW5_EXISTS_NO                              0x00000000 /* RW--V */
#define NVCC73_SYS_CAPB_WINDOW5_EXISTS_YES                             0x00000001 /* RW--V */
#define NVCC73_SYS_CAPB_WINDOW6_EXISTS                                        6:6 /* RWIVF */
#define NVCC73_SYS_CAPB_WINDOW6_EXISTS_NO                              0x00000000 /* RW--V */
#define NVCC73_SYS_CAPB_WINDOW6_EXISTS_YES                             0x00000001 /* RW--V */
#define NVCC73_SYS_CAPB_WINDOW7_EXISTS                                        7:7 /* RWIVF */
#define NVCC73_SYS_CAPB_WINDOW7_EXISTS_NO                              0x00000000 /* RW--V */
#define NVCC73_SYS_CAPB_WINDOW7_EXISTS_YES                             0x00000001 /* RW--V */
#define NVCC73_SYS_CAPB_WINDOW8_EXISTS                                        8:8 /* RWIVF */
#define NVCC73_SYS_CAPB_WINDOW8_EXISTS_NO                              0x00000000 /* RW--V */
#define NVCC73_SYS_CAPB_WINDOW8_EXISTS_YES                             0x00000001 /* RW--V */
#define NVCC73_SYS_CAPB_WINDOW9_EXISTS                                        9:9 /* RWIVF */
#define NVCC73_SYS_CAPB_WINDOW9_EXISTS_NO                              0x00000000 /* RW--V */
#define NVCC73_SYS_CAPB_WINDOW9_EXISTS_YES                             0x00000001 /* RW--V */
#define NVCC73_SYS_CAPB_WINDOW10_EXISTS                                     10:10 /* RWIVF */
#define NVCC73_SYS_CAPB_WINDOW10_EXISTS_NO                             0x00000000 /* RW--V */
#define NVCC73_SYS_CAPB_WINDOW10_EXISTS_YES                            0x00000001 /* RW--V */
#define NVCC73_SYS_CAPB_WINDOW11_EXISTS                                     11:11 /* RWIVF */
#define NVCC73_SYS_CAPB_WINDOW11_EXISTS_NO                             0x00000000 /* RW--V */
#define NVCC73_SYS_CAPB_WINDOW11_EXISTS_YES                            0x00000001 /* RW--V */
#define NVCC73_SYS_CAPB_WINDOW12_EXISTS                                     12:12 /* RWIVF */
#define NVCC73_SYS_CAPB_WINDOW12_EXISTS_NO                             0x00000000 /* RW--V */
#define NVCC73_SYS_CAPB_WINDOW12_EXISTS_YES                            0x00000001 /* RW--V */
#define NVCC73_SYS_CAPB_WINDOW13_EXISTS                                     13:13 /* RWIVF */
#define NVCC73_SYS_CAPB_WINDOW13_EXISTS_NO                             0x00000000 /* RW--V */
#define NVCC73_SYS_CAPB_WINDOW13_EXISTS_YES                            0x00000001 /* RW--V */
#define NVCC73_SYS_CAPB_WINDOW14_EXISTS                                     14:14 /* RWIVF */
#define NVCC73_SYS_CAPB_WINDOW14_EXISTS_NO                             0x00000000 /* RW--V */
#define NVCC73_SYS_CAPB_WINDOW14_EXISTS_YES                            0x00000001 /* RW--V */
#define NVCC73_SYS_CAPB_WINDOW15_EXISTS                                     15:15 /* RWIVF */
#define NVCC73_SYS_CAPB_WINDOW15_EXISTS_NO                             0x00000000 /* RW--V */
#define NVCC73_SYS_CAPB_WINDOW15_EXISTS_YES                            0x00000001 /* RW--V */
#define NVCC73_SYS_CAPB_WINDOW16_EXISTS                                     16:16 /* RWIVF */
#define NVCC73_SYS_CAPB_WINDOW16_EXISTS_NO                             0x00000000 /* RW--V */
#define NVCC73_SYS_CAPB_WINDOW16_EXISTS_YES                            0x00000001 /* RW--V */
#define NVCC73_SYS_CAPB_WINDOW17_EXISTS                                     17:17 /* RWIVF */
#define NVCC73_SYS_CAPB_WINDOW17_EXISTS_NO                             0x00000000 /* RW--V */
#define NVCC73_SYS_CAPB_WINDOW17_EXISTS_YES                            0x00000001 /* RW--V */
#define NVCC73_SYS_CAPB_WINDOW18_EXISTS                                     18:18 /* RWIVF */
#define NVCC73_SYS_CAPB_WINDOW18_EXISTS_NO                             0x00000000 /* RW--V */
#define NVCC73_SYS_CAPB_WINDOW18_EXISTS_YES                            0x00000001 /* RW--V */
#define NVCC73_SYS_CAPB_WINDOW19_EXISTS                                     19:19 /* RWIVF */
#define NVCC73_SYS_CAPB_WINDOW19_EXISTS_NO                             0x00000000 /* RW--V */
#define NVCC73_SYS_CAPB_WINDOW19_EXISTS_YES                            0x00000001 /* RW--V */
#define NVCC73_SYS_CAPB_WINDOW20_EXISTS                                     20:20 /* RWIVF */
#define NVCC73_SYS_CAPB_WINDOW20_EXISTS_NO                             0x00000000 /* RW--V */
#define NVCC73_SYS_CAPB_WINDOW20_EXISTS_YES                            0x00000001 /* RW--V */
#define NVCC73_SYS_CAPB_WINDOW21_EXISTS                                     21:21 /* RWIVF */
#define NVCC73_SYS_CAPB_WINDOW21_EXISTS_NO                             0x00000000 /* RW--V */
#define NVCC73_SYS_CAPB_WINDOW21_EXISTS_YES                            0x00000001 /* RW--V */
#define NVCC73_SYS_CAPB_WINDOW22_EXISTS                                     22:22 /* RWIVF */
#define NVCC73_SYS_CAPB_WINDOW22_EXISTS_NO                             0x00000000 /* RW--V */
#define NVCC73_SYS_CAPB_WINDOW22_EXISTS_YES                            0x00000001 /* RW--V */
#define NVCC73_SYS_CAPB_WINDOW23_EXISTS                                     23:23 /* RWIVF */
#define NVCC73_SYS_CAPB_WINDOW23_EXISTS_NO                             0x00000000 /* RW--V */
#define NVCC73_SYS_CAPB_WINDOW23_EXISTS_YES                            0x00000001 /* RW--V */
#define NVCC73_SYS_CAPB_WINDOW24_EXISTS                                     24:24 /* RWIVF */
#define NVCC73_SYS_CAPB_WINDOW24_EXISTS_NO                             0x00000000 /* RW--V */
#define NVCC73_SYS_CAPB_WINDOW24_EXISTS_YES                            0x00000001 /* RW--V */
#define NVCC73_SYS_CAPB_WINDOW25_EXISTS                                     25:25 /* RWIVF */
#define NVCC73_SYS_CAPB_WINDOW25_EXISTS_NO                             0x00000000 /* RW--V */
#define NVCC73_SYS_CAPB_WINDOW25_EXISTS_YES                            0x00000001 /* RW--V */
#define NVCC73_SYS_CAPB_WINDOW26_EXISTS                                     26:26 /* RWIVF */
#define NVCC73_SYS_CAPB_WINDOW26_EXISTS_NO                             0x00000000 /* RW--V */
#define NVCC73_SYS_CAPB_WINDOW26_EXISTS_YES                            0x00000001 /* RW--V */
#define NVCC73_SYS_CAPB_WINDOW27_EXISTS                                     27:27 /* RWIVF */
#define NVCC73_SYS_CAPB_WINDOW27_EXISTS_NO                             0x00000000 /* RW--V */
#define NVCC73_SYS_CAPB_WINDOW27_EXISTS_YES                            0x00000001 /* RW--V */
#define NVCC73_SYS_CAPB_WINDOW28_EXISTS                                     28:28 /* RWIVF */
#define NVCC73_SYS_CAPB_WINDOW28_EXISTS_NO                             0x00000000 /* RW--V */
#define NVCC73_SYS_CAPB_WINDOW28_EXISTS_YES                            0x00000001 /* RW--V */
#define NVCC73_SYS_CAPB_WINDOW29_EXISTS                                     29:29 /* RWIVF */
#define NVCC73_SYS_CAPB_WINDOW29_EXISTS_NO                             0x00000000 /* RW--V */
#define NVCC73_SYS_CAPB_WINDOW29_EXISTS_YES                            0x00000001 /* RW--V */
#define NVCC73_SYS_CAPB_WINDOW30_EXISTS                                     30:30 /* RWIVF */
#define NVCC73_SYS_CAPB_WINDOW30_EXISTS_NO                             0x00000000 /* RW--V */
#define NVCC73_SYS_CAPB_WINDOW30_EXISTS_YES                            0x00000001 /* RW--V */
#define NVCC73_SYS_CAPB_WINDOW31_EXISTS                                     31:31 /* RWIVF */
#define NVCC73_SYS_CAPB_WINDOW31_EXISTS_NO                             0x00000000 /* RW--V */
#define NVCC73_SYS_CAPB_WINDOW31_EXISTS_YES                            0x00000001 /* RW--V */
#define NVCC73_SYS_CAPB_WINDOW_EXISTS(i)                          (0+(i)):(0+(i)) /* RWIVF */
#define NVCC73_SYS_CAPB_WINDOW_EXISTS__SIZE_1                                  32 /*       */
#define NVCC73_SYS_CAPB_WINDOW_EXISTS_NO                               0x00000000 /* RW--V */
#define NVCC73_SYS_CAPB_WINDOW_EXISTS_YES                              0x00000001 /* RW--V */
#define NVCC73_SYS_CAPC                                               0x20 /* RW-4R */
#define NVCC73_SYS_CAPC_TILE0_EXISTS                                         0:0 /* RWIVF */
#define NVCC73_SYS_CAPC_TILE0_EXISTS_NO                               0x00000000 /* RW--V */
#define NVCC73_SYS_CAPC_TILE0_EXISTS_YES                              0x00000001 /* RW--V */
#define NVCC73_SYS_CAPC_TILE1_EXISTS                                         1:1 /* RWIVF */
#define NVCC73_SYS_CAPC_TILE1_EXISTS_NO                               0x00000000 /* RW--V */
#define NVCC73_SYS_CAPC_TILE1_EXISTS_YES                              0x00000001 /* RW--V */
#define NVCC73_SYS_CAPC_TILE2_EXISTS                                         2:2 /* RWIVF */
#define NVCC73_SYS_CAPC_TILE2_EXISTS_NO                               0x00000000 /* RW--V */
#define NVCC73_SYS_CAPC_TILE2_EXISTS_YES                              0x00000001 /* RW--V */
#define NVCC73_SYS_CAPC_TILE3_EXISTS                                         3:3 /* RWIVF */
#define NVCC73_SYS_CAPC_TILE3_EXISTS_NO                               0x00000000 /* RW--V */
#define NVCC73_SYS_CAPC_TILE3_EXISTS_YES                              0x00000001 /* RW--V */
#define NVCC73_SYS_CAPC_TILE4_EXISTS                                         4:4 /* RWIVF */
#define NVCC73_SYS_CAPC_TILE4_EXISTS_NO                               0x00000000 /* RW--V */
#define NVCC73_SYS_CAPC_TILE4_EXISTS_YES                              0x00000001 /* RW--V */
#define NVCC73_SYS_CAPC_TILE5_EXISTS                                         5:5 /* RWIVF */
#define NVCC73_SYS_CAPC_TILE5_EXISTS_NO                               0x00000000 /* RW--V */
#define NVCC73_SYS_CAPC_TILE5_EXISTS_YES                              0x00000001 /* RW--V */
#define NVCC73_SYS_CAPC_TILE6_EXISTS                                         6:6 /* RWIVF */
#define NVCC73_SYS_CAPC_TILE6_EXISTS_NO                               0x00000000 /* RW--V */
#define NVCC73_SYS_CAPC_TILE6_EXISTS_YES                              0x00000001 /* RW--V */
#define NVCC73_SYS_CAPC_TILE7_EXISTS                                         7:7 /* RWIVF */
#define NVCC73_SYS_CAPC_TILE7_EXISTS_NO                               0x00000000 /* RW--V */
#define NVCC73_SYS_CAPC_TILE7_EXISTS_YES                              0x00000001 /* RW--V */
#define NVCC73_SYS_CAPC_TILE_EXISTS(i)                           (0+(i)):(0+(i)) /* RWIVF */
#define NVCC73_SYS_CAPC_TILE_EXISTS__SIZE_1                                    8 /*       */
#define NVCC73_SYS_CAPC_TILE_EXISTS_NO                                0x00000000 /* RW--V */
#define NVCC73_SYS_CAPC_TILE_EXISTS_YES                               0x00000001 /* RW--V */
#define NVCC73_SYS_CAPC_TILE0_SUPPORT_MULTI_TILE                             8:8 /* RWIVF */
#define NVCC73_SYS_CAPC_TILE0_SUPPORT_MULTI_TILE_NO                   0x00000000 /* RW--V */
#define NVCC73_SYS_CAPC_TILE0_SUPPORT_MULTI_TILE_YES                  0x00000001 /* RW--V */
#define NVCC73_SYS_CAPC_TILE1_SUPPORT_MULTI_TILE                             9:9 /* RWIVF */
#define NVCC73_SYS_CAPC_TILE1_SUPPORT_MULTI_TILE_NO                   0x00000000 /* RW--V */
#define NVCC73_SYS_CAPC_TILE1_SUPPORT_MULTI_TILE_YES                  0x00000001 /* RW--V */
#define NVCC73_SYS_CAPC_TILE2_SUPPORT_MULTI_TILE                           10:10 /* RWIVF */
#define NVCC73_SYS_CAPC_TILE2_SUPPORT_MULTI_TILE_NO                   0x00000000 /* RW--V */
#define NVCC73_SYS_CAPC_TILE2_SUPPORT_MULTI_TILE_YES                  0x00000001 /* RW--V */
#define NVCC73_SYS_CAPC_TILE3_SUPPORT_MULTI_TILE                           11:11 /* RWIVF */
#define NVCC73_SYS_CAPC_TILE3_SUPPORT_MULTI_TILE_NO                   0x00000000 /* RW--V */
#define NVCC73_SYS_CAPC_TILE3_SUPPORT_MULTI_TILE_YES                  0x00000001 /* RW--V */
#define NVCC73_SYS_CAPC_TILE4_SUPPORT_MULTI_TILE                           12:12 /* RWIVF */
#define NVCC73_SYS_CAPC_TILE4_SUPPORT_MULTI_TILE_NO                   0x00000000 /* RW--V */
#define NVCC73_SYS_CAPC_TILE4_SUPPORT_MULTI_TILE_YES                  0x00000001 /* RW--V */
#define NVCC73_SYS_CAPC_TILE5_SUPPORT_MULTI_TILE                           13:13 /* RWIVF */
#define NVCC73_SYS_CAPC_TILE5_SUPPORT_MULTI_TILE_NO                   0x00000000 /* RW--V */
#define NVCC73_SYS_CAPC_TILE5_SUPPORT_MULTI_TILE_YES                  0x00000001 /* RW--V */
#define NVCC73_SYS_CAPC_TILE6_SUPPORT_MULTI_TILE                           14:14 /* RWIVF */
#define NVCC73_SYS_CAPC_TILE6_SUPPORT_MULTI_TILE_NO                   0x00000000 /* RW--V */
#define NVCC73_SYS_CAPC_TILE6_SUPPORT_MULTI_TILE_YES                  0x00000001 /* RW--V */
#define NVCC73_SYS_CAPC_TILE7_SUPPORT_MULTI_TILE                           15:15 /* RWIVF */
#define NVCC73_SYS_CAPC_TILE7_SUPPORT_MULTI_TILE_NO                   0x00000000 /* RW--V */
#define NVCC73_SYS_CAPC_TILE7_SUPPORT_MULTI_TILE_YES                  0x00000001 /* RW--V */
#define NVCC73_SYS_CAPC_TILE_SUPPORT_MULTI_TILE(i)               (8+(i)):(8+(i)) /* RWIVF */
#define NVCC73_SYS_CAPC_TILE_SUPPORT_MULTI_TILE__SIZE_1                        8 /*       */
#define NVCC73_SYS_CAPC_TILE_SUPPORT_MULTI_TILE_NO                    0x00000000 /* RW--V */
#define NVCC73_SYS_CAPC_TILE_SUPPORT_MULTI_TILE_YES                   0x00000001 /* RW--V */
#define NVCC73_SYS_CAPC_MERGER_TILE_BUFFER_SIZE                            31:16 /* RWIUF */
#define NVCC73_SYS_CAPD                                               0x2c /* RW-4R */
#define NVCC73_SYS_CAPD_NUM_TELLTALE_REGIONS                                 4:0 /* RWIUF */
#define NVCC73_SYS_CAPD_NUM_FROZEN_FRAME_REGIONS                            12:8 /* RWIUF */
#define NVCC73_SYS_CAPD_NUM_ROI                                            20:16 /* RWIUF */
#define NVCC73_SYS_CAPD_AE_SDP_EXISTS                                      30:30 /* RWIVF */
#define NVCC73_SYS_CAPD_AE_SDP_EXISTS_NO                              0x00000000 /* RW--V */
#define NVCC73_SYS_CAPD_AE_SDP_EXISTS_YES                             0x00000001 /* RW--V */
#define NVCC73_SYS_CAPD_AMSS_EXISTS                                        31:31 /* RWIVF */
#define NVCC73_SYS_CAPD_AMSS_EXISTS_NO                                0x00000000 /* RW--V */
#define NVCC73_SYS_CAPD_AMSS_EXISTS_YES                               0x00000001 /* RW--V */
#define NVCC73_SYS_CAPE                                                0x34 /* RW-4R */
#define NVCC73_SYS_CAPE_VIRWIN0_EXISTS                                        0:0 /* RWIVF */
#define NVCC73_SYS_CAPE_VIRWIN0_EXISTS_NO                              0x00000000 /* RW--V */
#define NVCC73_SYS_CAPE_VIRWIN0_EXISTS_YES                             0x00000001 /* RW--V */
#define NVCC73_SYS_CAPE_VIRWIN1_EXISTS                                        1:1 /* RWIVF */
#define NVCC73_SYS_CAPE_VIRWIN1_EXISTS_NO                              0x00000000 /* RW--V */
#define NVCC73_SYS_CAPE_VIRWIN1_EXISTS_YES                             0x00000001 /* RW--V */
#define NVCC73_SYS_CAPE_VIRWIN2_EXISTS                                        2:2 /* RWIVF */
#define NVCC73_SYS_CAPE_VIRWIN2_EXISTS_NO                              0x00000000 /* RW--V */
#define NVCC73_SYS_CAPE_VIRWIN2_EXISTS_YES                             0x00000001 /* RW--V */
#define NVCC73_SYS_CAPE_VIRWIN3_EXISTS                                        3:3 /* RWIVF */
#define NVCC73_SYS_CAPE_VIRWIN3_EXISTS_NO                              0x00000000 /* RW--V */
#define NVCC73_SYS_CAPE_VIRWIN3_EXISTS_YES                             0x00000001 /* RW--V */
#define NVCC73_SYS_CAPE_VIRWIN4_EXISTS                                        4:4 /* RWIVF */
#define NVCC73_SYS_CAPE_VIRWIN4_EXISTS_NO                              0x00000000 /* RW--V */
#define NVCC73_SYS_CAPE_VIRWIN4_EXISTS_YES                             0x00000001 /* RW--V */
#define NVCC73_SYS_CAPE_VIRWIN5_EXISTS                                        5:5 /* RWIVF */
#define NVCC73_SYS_CAPE_VIRWIN5_EXISTS_NO                              0x00000000 /* RW--V */
#define NVCC73_SYS_CAPE_VIRWIN5_EXISTS_YES                             0x00000001 /* RW--V */
#define NVCC73_SYS_CAPE_VIRWIN6_EXISTS                                        6:6 /* RWIVF */
#define NVCC73_SYS_CAPE_VIRWIN6_EXISTS_NO                              0x00000000 /* RW--V */
#define NVCC73_SYS_CAPE_VIRWIN6_EXISTS_YES                             0x00000001 /* RW--V */
#define NVCC73_SYS_CAPE_VIRWIN7_EXISTS                                        7:7 /* RWIVF */
#define NVCC73_SYS_CAPE_VIRWIN7_EXISTS_NO                              0x00000000 /* RW--V */
#define NVCC73_SYS_CAPE_VIRWIN7_EXISTS_YES                             0x00000001 /* RW--V */
#define NVCC73_SYS_CAPE_VIRWIN8_EXISTS                                        8:8 /* RWIVF */
#define NVCC73_SYS_CAPE_VIRWIN8_EXISTS_NO                              0x00000000 /* RW--V */
#define NVCC73_SYS_CAPE_VIRWIN8_EXISTS_YES                             0x00000001 /* RW--V */
#define NVCC73_SYS_CAPE_VIRWIN9_EXISTS                                        9:9 /* RWIVF */
#define NVCC73_SYS_CAPE_VIRWIN9_EXISTS_NO                              0x00000000 /* RW--V */
#define NVCC73_SYS_CAPE_VIRWIN9_EXISTS_YES                             0x00000001 /* RW--V */
#define NVCC73_SYS_CAPE_VIRWIN10_EXISTS                                     10:10 /* RWIVF */
#define NVCC73_SYS_CAPE_VIRWIN10_EXISTS_NO                             0x00000000 /* RW--V */
#define NVCC73_SYS_CAPE_VIRWIN10_EXISTS_YES                            0x00000001 /* RW--V */
#define NVCC73_SYS_CAPE_VIRWIN11_EXISTS                                     11:11 /* RWIVF */
#define NVCC73_SYS_CAPE_VIRWIN11_EXISTS_NO                             0x00000000 /* RW--V */
#define NVCC73_SYS_CAPE_VIRWIN11_EXISTS_YES                            0x00000001 /* RW--V */
#define NVCC73_SYS_CAPE_VIRWIN12_EXISTS                                     12:12 /* RWIVF */
#define NVCC73_SYS_CAPE_VIRWIN12_EXISTS_NO                             0x00000000 /* RW--V */
#define NVCC73_SYS_CAPE_VIRWIN12_EXISTS_YES                            0x00000001 /* RW--V */
#define NVCC73_SYS_CAPE_VIRWIN13_EXISTS                                     13:13 /* RWIVF */
#define NVCC73_SYS_CAPE_VIRWIN13_EXISTS_NO                             0x00000000 /* RW--V */
#define NVCC73_SYS_CAPE_VIRWIN13_EXISTS_YES                            0x00000001 /* RW--V */
#define NVCC73_SYS_CAPE_VIRWIN14_EXISTS                                     14:14 /* RWIVF */
#define NVCC73_SYS_CAPE_VIRWIN14_EXISTS_NO                             0x00000000 /* RW--V */
#define NVCC73_SYS_CAPE_VIRWIN14_EXISTS_YES                            0x00000001 /* RW--V */
#define NVCC73_SYS_CAPE_VIRWIN15_EXISTS                                     15:15 /* RWIVF */
#define NVCC73_SYS_CAPE_VIRWIN15_EXISTS_NO                             0x00000000 /* RW--V */
#define NVCC73_SYS_CAPE_VIRWIN15_EXISTS_YES                            0x00000001 /* RW--V */
#define NVCC73_SYS_CAPE_VIRWIN16_EXISTS                                     16:16 /* RWIVF */
#define NVCC73_SYS_CAPE_VIRWIN16_EXISTS_NO                             0x00000000 /* RW--V */
#define NVCC73_SYS_CAPE_VIRWIN16_EXISTS_YES                            0x00000001 /* RW--V */
#define NVCC73_SYS_CAPE_VIRWIN17_EXISTS                                     17:17 /* RWIVF */
#define NVCC73_SYS_CAPE_VIRWIN17_EXISTS_NO                             0x00000000 /* RW--V */
#define NVCC73_SYS_CAPE_VIRWIN17_EXISTS_YES                            0x00000001 /* RW--V */
#define NVCC73_SYS_CAPE_VIRWIN18_EXISTS                                     18:18 /* RWIVF */
#define NVCC73_SYS_CAPE_VIRWIN18_EXISTS_NO                             0x00000000 /* RW--V */
#define NVCC73_SYS_CAPE_VIRWIN18_EXISTS_YES                            0x00000001 /* RW--V */
#define NVCC73_SYS_CAPE_VIRWIN19_EXISTS                                     19:19 /* RWIVF */
#define NVCC73_SYS_CAPE_VIRWIN19_EXISTS_NO                             0x00000000 /* RW--V */
#define NVCC73_SYS_CAPE_VIRWIN19_EXISTS_YES                            0x00000001 /* RW--V */
#define NVCC73_SYS_CAPE_VIRWIN20_EXISTS                                     20:20 /* RWIVF */
#define NVCC73_SYS_CAPE_VIRWIN20_EXISTS_NO                             0x00000000 /* RW--V */
#define NVCC73_SYS_CAPE_VIRWIN20_EXISTS_YES                            0x00000001 /* RW--V */
#define NVCC73_SYS_CAPE_VIRWIN21_EXISTS                                     21:21 /* RWIVF */
#define NVCC73_SYS_CAPE_VIRWIN21_EXISTS_NO                             0x00000000 /* RW--V */
#define NVCC73_SYS_CAPE_VIRWIN21_EXISTS_YES                            0x00000001 /* RW--V */
#define NVCC73_SYS_CAPE_VIRWIN22_EXISTS                                     22:22 /* RWIVF */
#define NVCC73_SYS_CAPE_VIRWIN22_EXISTS_NO                             0x00000000 /* RW--V */
#define NVCC73_SYS_CAPE_VIRWIN22_EXISTS_YES                            0x00000001 /* RW--V */
#define NVCC73_SYS_CAPE_VIRWIN23_EXISTS                                     23:23 /* RWIVF */
#define NVCC73_SYS_CAPE_VIRWIN23_EXISTS_NO                             0x00000000 /* RW--V */
#define NVCC73_SYS_CAPE_VIRWIN23_EXISTS_YES                            0x00000001 /* RW--V */
#define NVCC73_SYS_CAPE_VIRWIN24_EXISTS                                     24:24 /* RWIVF */
#define NVCC73_SYS_CAPE_VIRWIN24_EXISTS_NO                             0x00000000 /* RW--V */
#define NVCC73_SYS_CAPE_VIRWIN24_EXISTS_YES                            0x00000001 /* RW--V */
#define NVCC73_SYS_CAPE_VIRWIN25_EXISTS                                     25:25 /* RWIVF */
#define NVCC73_SYS_CAPE_VIRWIN25_EXISTS_NO                             0x00000000 /* RW--V */
#define NVCC73_SYS_CAPE_VIRWIN25_EXISTS_YES                            0x00000001 /* RW--V */
#define NVCC73_SYS_CAPE_VIRWIN26_EXISTS                                     26:26 /* RWIVF */
#define NVCC73_SYS_CAPE_VIRWIN26_EXISTS_NO                             0x00000000 /* RW--V */
#define NVCC73_SYS_CAPE_VIRWIN26_EXISTS_YES                            0x00000001 /* RW--V */
#define NVCC73_SYS_CAPE_VIRWIN27_EXISTS                                     27:27 /* RWIVF */
#define NVCC73_SYS_CAPE_VIRWIN27_EXISTS_NO                             0x00000000 /* RW--V */
#define NVCC73_SYS_CAPE_VIRWIN27_EXISTS_YES                            0x00000001 /* RW--V */
#define NVCC73_SYS_CAPE_VIRWIN28_EXISTS                                     28:28 /* RWIVF */
#define NVCC73_SYS_CAPE_VIRWIN28_EXISTS_NO                             0x00000000 /* RW--V */
#define NVCC73_SYS_CAPE_VIRWIN28_EXISTS_YES                            0x00000001 /* RW--V */
#define NVCC73_SYS_CAPE_VIRWIN29_EXISTS                                     29:29 /* RWIVF */
#define NVCC73_SYS_CAPE_VIRWIN29_EXISTS_NO                             0x00000000 /* RW--V */
#define NVCC73_SYS_CAPE_VIRWIN29_EXISTS_YES                            0x00000001 /* RW--V */
#define NVCC73_SYS_CAPE_VIRWIN30_EXISTS                                     30:30 /* RWIVF */
#define NVCC73_SYS_CAPE_VIRWIN30_EXISTS_NO                             0x00000000 /* RW--V */
#define NVCC73_SYS_CAPE_VIRWIN30_EXISTS_YES                            0x00000001 /* RW--V */
#define NVCC73_SYS_CAPE_VIRWIN31_EXISTS                                     31:31 /* RWIVF */
#define NVCC73_SYS_CAPE_VIRWIN31_EXISTS_NO                             0x00000000 /* RW--V */
#define NVCC73_SYS_CAPE_VIRWIN31_EXISTS_YES                            0x00000001 /* RW--V */
#define NVCC73_SYS_CAPE_VIRWIN_EXISTS(i)                          (0+(i)):(0+(i)) /* RWIVF */
#define NVCC73_SYS_CAPE_VIRWIN_EXISTS__SIZE_1                                  32 /*       */
#define NVCC73_SYS_CAPE_VIRWIN_EXISTS_NO                               0x00000000 /* RW--V */
#define NVCC73_SYS_CAPE_VIRWIN_EXISTS_YES                              0x00000001 /* RW--V */
#define NVCC73_MISC_CAPA_NUM_VMS                                           17:13 /* RWIUF */
#define NVCC73_LINK_CAP                                                0x30 /* RW-4R */
#define NVCC73_LINK_CAP_PHYCTRL0_EXISTS                                        0:0 /* RWIVF */
#define NVCC73_LINK_CAP_PHYCTRL0_EXISTS_NO                              0x00000000 /* RW--V */
#define NVCC73_LINK_CAP_PHYCTRL0_EXISTS_YES                             0x00000001 /* RW--V */
#define NVCC73_LINK_CAP_PHYCTRL1_EXISTS                                        1:1 /* RWIVF */
#define NVCC73_LINK_CAP_PHYCTRL1_EXISTS_NO                              0x00000000 /* RW--V */
#define NVCC73_LINK_CAP_PHYCTRL1_EXISTS_YES                             0x00000001 /* RW--V */
#define NVCC73_LINK_CAP_PHYCTRL2_EXISTS                                        2:2 /* RWIVF */
#define NVCC73_LINK_CAP_PHYCTRL2_EXISTS_NO                              0x00000000 /* RW--V */
#define NVCC73_LINK_CAP_PHYCTRL2_EXISTS_YES                             0x00000001 /* RW--V */
#define NVCC73_LINK_CAP_PHYCTRL3_EXISTS                                        3:3 /* RWIVF */
#define NVCC73_LINK_CAP_PHYCTRL3_EXISTS_NO                              0x00000000 /* RW--V */
#define NVCC73_LINK_CAP_PHYCTRL3_EXISTS_YES                             0x00000001 /* RW--V */
#define NVCC73_LINK_CAP_PHYCTRL4_EXISTS                                        4:4 /* RWIVF */
#define NVCC73_LINK_CAP_PHYCTRL4_EXISTS_NO                              0x00000000 /* RW--V */
#define NVCC73_LINK_CAP_PHYCTRL4_EXISTS_YES                             0x00000001 /* RW--V */
#define NVCC73_LINK_CAP_PHYCTRL5_EXISTS                                        5:5 /* RWIVF */
#define NVCC73_LINK_CAP_PHYCTRL5_EXISTS_NO                              0x00000000 /* RW--V */
#define NVCC73_LINK_CAP_PHYCTRL5_EXISTS_YES                             0x00000001 /* RW--V */
#define NVCC73_LINK_CAP_PHYCTRL6_EXISTS                                        6:6 /* RWIVF */
#define NVCC73_LINK_CAP_PHYCTRL6_EXISTS_NO                              0x00000000 /* RW--V */
#define NVCC73_LINK_CAP_PHYCTRL6_EXISTS_YES                             0x00000001 /* RW--V */
#define NVCC73_LINK_CAP_PHYCTRL7_EXISTS                                        7:7 /* RWIVF */
#define NVCC73_LINK_CAP_PHYCTRL7_EXISTS_NO                              0x00000000 /* RW--V */
#define NVCC73_LINK_CAP_PHYCTRL7_EXISTS_YES                             0x00000001 /* RW--V */
#define NVCC73_LINK_CAP_PHYCTRL8_EXISTS                                        8:8 /* RWIVF */
#define NVCC73_LINK_CAP_PHYCTRL8_EXISTS_NO                              0x00000000 /* RW--V */
#define NVCC73_LINK_CAP_PHYCTRL8_EXISTS_YES                             0x00000001 /* RW--V */
#define NVCC73_LINK_CAP_PHYCTRL9_EXISTS                                        9:9 /* RWIVF */
#define NVCC73_LINK_CAP_PHYCTRL9_EXISTS_NO                              0x00000000 /* RW--V */
#define NVCC73_LINK_CAP_PHYCTRL9_EXISTS_YES                             0x00000001 /* RW--V */
#define NVCC73_LINK_CAP_PHYCTRL10_EXISTS                                     10:10 /* RWIVF */
#define NVCC73_LINK_CAP_PHYCTRL10_EXISTS_NO                             0x00000000 /* RW--V */
#define NVCC73_LINK_CAP_PHYCTRL10_EXISTS_YES                            0x00000001 /* RW--V */
#define NVCC73_LINK_CAP_PHYCTRL11_EXISTS                                     11:11 /* RWIVF */
#define NVCC73_LINK_CAP_PHYCTRL11_EXISTS_NO                             0x00000000 /* RW--V */
#define NVCC73_LINK_CAP_PHYCTRL11_EXISTS_YES                            0x00000001 /* RW--V */
#define NVCC73_LINK_CAP_PHYCTRL12_EXISTS                                     12:12 /* RWIVF */
#define NVCC73_LINK_CAP_PHYCTRL12_EXISTS_NO                             0x00000000 /* RW--V */
#define NVCC73_LINK_CAP_PHYCTRL12_EXISTS_YES                            0x00000001 /* RW--V */
#define NVCC73_LINK_CAP_PHYCTRL13_EXISTS                                     13:13 /* RWIVF */
#define NVCC73_LINK_CAP_PHYCTRL13_EXISTS_NO                             0x00000000 /* RW--V */
#define NVCC73_LINK_CAP_PHYCTRL13_EXISTS_YES                            0x00000001 /* RW--V */
#define NVCC73_LINK_CAP_PHYCTRL14_EXISTS                                     14:14 /* RWIVF */
#define NVCC73_LINK_CAP_PHYCTRL14_EXISTS_NO                             0x00000000 /* RW--V */
#define NVCC73_LINK_CAP_PHYCTRL14_EXISTS_YES                            0x00000001 /* RW--V */
#define NVCC73_LINK_CAP_PHYCTRL15_EXISTS                                     15:15 /* RWIVF */
#define NVCC73_LINK_CAP_PHYCTRL15_EXISTS_NO                             0x00000000 /* RW--V */
#define NVCC73_LINK_CAP_PHYCTRL15_EXISTS_YES                            0x00000001 /* RW--V */
#define NVCC73_LINK_CAP_PHYCTRL16_EXISTS                                     16:16 /* RWIVF */
#define NVCC73_LINK_CAP_PHYCTRL16_EXISTS_NO                             0x00000000 /* RW--V */
#define NVCC73_LINK_CAP_PHYCTRL16_EXISTS_YES                            0x00000001 /* RW--V */
#define NVCC73_LINK_CAP_PHYCTRL17_EXISTS                                     17:17 /* RWIVF */
#define NVCC73_LINK_CAP_PHYCTRL17_EXISTS_NO                             0x00000000 /* RW--V */
#define NVCC73_LINK_CAP_PHYCTRL17_EXISTS_YES                            0x00000001 /* RW--V */
#define NVCC73_LINK_CAP_PHYCTRL18_EXISTS                                     18:18 /* RWIVF */
#define NVCC73_LINK_CAP_PHYCTRL18_EXISTS_NO                             0x00000000 /* RW--V */
#define NVCC73_LINK_CAP_PHYCTRL18_EXISTS_YES                            0x00000001 /* RW--V */
#define NVCC73_LINK_CAP_PHYCTRL19_EXISTS                                     19:19 /* RWIVF */
#define NVCC73_LINK_CAP_PHYCTRL19_EXISTS_NO                             0x00000000 /* RW--V */
#define NVCC73_LINK_CAP_PHYCTRL19_EXISTS_YES                            0x00000001 /* RW--V */
#define NVCC73_LINK_CAP_PHYCTRL20_EXISTS                                     20:20 /* RWIVF */
#define NVCC73_LINK_CAP_PHYCTRL20_EXISTS_NO                             0x00000000 /* RW--V */
#define NVCC73_LINK_CAP_PHYCTRL20_EXISTS_YES                            0x00000001 /* RW--V */
#define NVCC73_LINK_CAP_PHYCTRL21_EXISTS                                     21:21 /* RWIVF */
#define NVCC73_LINK_CAP_PHYCTRL21_EXISTS_NO                             0x00000000 /* RW--V */
#define NVCC73_LINK_CAP_PHYCTRL21_EXISTS_YES                            0x00000001 /* RW--V */
#define NVCC73_LINK_CAP_PHYCTRL22_EXISTS                                     22:22 /* RWIVF */
#define NVCC73_LINK_CAP_PHYCTRL22_EXISTS_NO                             0x00000000 /* RW--V */
#define NVCC73_LINK_CAP_PHYCTRL22_EXISTS_YES                            0x00000001 /* RW--V */
#define NVCC73_LINK_CAP_PHYCTRL23_EXISTS                                     23:23 /* RWIVF */
#define NVCC73_LINK_CAP_PHYCTRL23_EXISTS_NO                             0x00000000 /* RW--V */
#define NVCC73_LINK_CAP_PHYCTRL23_EXISTS_YES                            0x00000001 /* RW--V */
#define NVCC73_LINK_CAP_PHYCTRL24_EXISTS                                     24:24 /* RWIVF */
#define NVCC73_LINK_CAP_PHYCTRL24_EXISTS_NO                             0x00000000 /* RW--V */
#define NVCC73_LINK_CAP_PHYCTRL24_EXISTS_YES                            0x00000001 /* RW--V */
#define NVCC73_LINK_CAP_PHYCTRL25_EXISTS                                     25:25 /* RWIVF */
#define NVCC73_LINK_CAP_PHYCTRL25_EXISTS_NO                             0x00000000 /* RW--V */
#define NVCC73_LINK_CAP_PHYCTRL25_EXISTS_YES                            0x00000001 /* RW--V */
#define NVCC73_LINK_CAP_PHYCTRL26_EXISTS                                     26:26 /* RWIVF */
#define NVCC73_LINK_CAP_PHYCTRL26_EXISTS_NO                             0x00000000 /* RW--V */
#define NVCC73_LINK_CAP_PHYCTRL26_EXISTS_YES                            0x00000001 /* RW--V */
#define NVCC73_LINK_CAP_PHYCTRL27_EXISTS                                     27:27 /* RWIVF */
#define NVCC73_LINK_CAP_PHYCTRL27_EXISTS_NO                             0x00000000 /* RW--V */
#define NVCC73_LINK_CAP_PHYCTRL27_EXISTS_YES                            0x00000001 /* RW--V */
#define NVCC73_LINK_CAP_PHYCTRL28_EXISTS                                     28:28 /* RWIVF */
#define NVCC73_LINK_CAP_PHYCTRL28_EXISTS_NO                             0x00000000 /* RW--V */
#define NVCC73_LINK_CAP_PHYCTRL28_EXISTS_YES                            0x00000001 /* RW--V */
#define NVCC73_LINK_CAP_PHYCTRL29_EXISTS                                     29:29 /* RWIVF */
#define NVCC73_LINK_CAP_PHYCTRL29_EXISTS_NO                             0x00000000 /* RW--V */
#define NVCC73_LINK_CAP_PHYCTRL29_EXISTS_YES                            0x00000001 /* RW--V */
#define NVCC73_LINK_CAP_PHYCTRL30_EXISTS                                     30:30 /* RWIVF */
#define NVCC73_LINK_CAP_PHYCTRL30_EXISTS_NO                             0x00000000 /* RW--V */
#define NVCC73_LINK_CAP_PHYCTRL30_EXISTS_YES                            0x00000001 /* RW--V */
#define NVCC73_LINK_CAP_PHYCTRL31_EXISTS                                     31:31 /* RWIVF */
#define NVCC73_LINK_CAP_PHYCTRL31_EXISTS_NO                             0x00000000 /* RW--V */
#define NVCC73_LINK_CAP_PHYCTRL31_EXISTS_YES                            0x00000001 /* RW--V */
#define NVCC73_LINK_CAP_PHYCTRL_EXISTS(i)                          (0+(i)):(0+(i)) /* RWIVF */
#define NVCC73_LINK_CAP_PHYCTRL_EXISTS__SIZE_1                                  32 /*       */
#define NVCC73_LINK_CAP_PHYCTRL_EXISTS_NO                               0x00000000 /* RW--V */
#define NVCC73_LINK_CAP_PHYCTRL_EXISTS_YES                              0x00000001 /* RW--V */
#define NVCC73_IHUB_COMMON_CAPA                                       0x10 /* RW-4R */
#define NVCC73_IHUB_COMMON_CAPA_MEMPOOL_ENTRIES                             15:0 /* RWIUF */
#define NVCC73_IHUB_COMMON_CAPA_MEMPOOL_ENTRY_WIDTH                        17:16 /* RWIVF */
#define NVCC73_IHUB_COMMON_CAPA_MEMPOOL_ENTRY_WIDTH_32B               0x00000000 /* RW--V */
#define NVCC73_IHUB_COMMON_CAPA_MEMPOOL_ENTRY_WIDTH_64B               0x00000001 /* RW--V */
#define NVCC73_IHUB_COMMON_CAPA_MEMPOOL_ENTRY_WIDTH_128B              0x00000002 /* RW--V */
#define NVCC73_IHUB_COMMON_CAPA_MEMPOOL_ENTRY_WIDTH_256B              0x00000003 /* RW--V */
#define NVCC73_IHUB_COMMON_CAPA_SUPPORT_ROTATION                           18:18 /* RWIVF */
#define NVCC73_IHUB_COMMON_CAPA_SUPPORT_ROTATION_FALSE                0x00000000 /* RW--V */
#define NVCC73_IHUB_COMMON_CAPA_SUPPORT_ROTATION_TRUE                 0x00000001 /* RW--V */
#define NVCC73_IHUB_COMMON_CAPA_SUPPORT_PLANAR                             19:19 /* RWIVF */
#define NVCC73_IHUB_COMMON_CAPA_SUPPORT_PLANAR_FALSE                  0x00000000 /* RW--V */
#define NVCC73_IHUB_COMMON_CAPA_SUPPORT_PLANAR_TRUE                   0x00000001 /* RW--V */
#define NVCC73_IHUB_COMMON_CAPA_SUPPORT_VGA                                20:20 /* RWIVF */
#define NVCC73_IHUB_COMMON_CAPA_SUPPORT_VGA_FALSE                     0x00000000 /* RW--V */
#define NVCC73_IHUB_COMMON_CAPA_SUPPORT_VGA_TRUE                      0x00000001 /* RW--V */
#define NVCC73_IHUB_COMMON_CAPA_SUPPORT_MEMPOOL_COMPRESSION                21:21 /* RWIVF */
#define NVCC73_IHUB_COMMON_CAPA_SUPPORT_MEMPOOL_COMPRESSION_FALSE     0x00000000 /* RW--V */
#define NVCC73_IHUB_COMMON_CAPA_SUPPORT_MEMPOOL_COMPRESSION_TRUE      0x00000001 /* RW--V */
#define NVCC73_IHUB_COMMON_CAPA_SUPPORT_MSCG                               22:22 /* RWIVF */
#define NVCC73_IHUB_COMMON_CAPA_SUPPORT_MSCG_FALSE                    0x00000000 /* RW--V */
#define NVCC73_IHUB_COMMON_CAPA_SUPPORT_MSCG_TRUE                     0x00000001 /* RW--V */
#define NVCC73_IHUB_COMMON_CAPA_SUPPORT_MCLK_SWITCH                        23:23 /* RWIVF */
#define NVCC73_IHUB_COMMON_CAPA_SUPPORT_MCLK_SWITCH_FALSE             0x00000000 /* RW--V */
#define NVCC73_IHUB_COMMON_CAPA_SUPPORT_MCLK_SWITCH_TRUE              0x00000001 /* RW--V */
#define NVCC73_IHUB_COMMON_CAPA_SUPPORT_MSCG_LPS                           26:26 /* RWIVF */
#define NVCC73_IHUB_COMMON_CAPA_SUPPORT_MSCG_LPS_FALSE                0x00000000 /* RW--V */
#define NVCC73_IHUB_COMMON_CAPA_SUPPORT_MSCG_LPS_TRUE                 0x00000001 /* RW--V */
#define NVCC73_IHUB_COMMON_CAPA_REQUEST_SIZE_PER_LINE_NON_ROTATION         31:30 /* RWIVF */
#define NVCC73_IHUB_COMMON_CAPA_REQUEST_SIZE_PER_LINE_NON_ROTATION_32B 0x00000000 /* RW--V */
#define NVCC73_IHUB_COMMON_CAPA_REQUEST_SIZE_PER_LINE_NON_ROTATION_64B 0x00000001 /* RW--V */
#define NVCC73_IHUB_COMMON_CAPA_REQUEST_SIZE_PER_LINE_NON_ROTATION_128B 0x00000002 /* RW--V */
#define NVCC73_IHUB_COMMON_CAPA_REQUEST_SIZE_PER_LINE_NON_ROTATION_256B 0x00000003 /* RW--V */
#define NVCC73_IHUB_COMMON_CAPC                                       0x18 /* RW-4R */
#define NVCC73_IHUB_COMMON_CAPC_PITCH_REQUEST_SIZE                           1:0 /* RWIVF */
#define NVCC73_IHUB_COMMON_CAPC_PITCH_REQUEST_SIZE_32B                0x00000000 /* RW--V */
#define NVCC73_IHUB_COMMON_CAPC_PITCH_REQUEST_SIZE_64B                0x00000001 /* RW--V */
#define NVCC73_IHUB_COMMON_CAPC_PITCH_REQUEST_SIZE_128B               0x00000002 /* RW--V */
#define NVCC73_IHUB_COMMON_CAPC_PITCH_REQUEST_SIZE_256B               0x00000003 /* RW--V */
#define NVCC73_IHUB_COMMON_CAPC_MAX_LINES_BUFFERED                           6:4 /* RWIVF */
#define NVCC73_IHUB_COMMON_CAPC_MAX_LINES_BUFFERED_NONE               0x00000000 /* RW--V */
#define NVCC73_IHUB_COMMON_CAPC_MAX_LINES_BUFFERED_TWO                0x00000001 /* RW--V */
#define NVCC73_IHUB_COMMON_CAPC_MAX_LINES_BUFFERED_FOUR               0x00000002 /* RW--V */
#define NVCC73_IHUB_COMMON_CAPC_MAX_LINES_BUFFERED_EIGHT              0x00000003 /* RW--V */
#define NVCC73_IHUB_COMMON_CAPC_MAX_LINES_BUFFERED_SIXTEEN            0x00000004 /* RW--V */
#define NVCC73_IHUB_COMMON_CAPC_SUPPORT_SEMI_PLANAR                        11:11 /* RWIVF */
#define NVCC73_IHUB_COMMON_CAPC_SUPPORT_SEMI_PLANAR_FALSE             0x00000000 /* RWI-V */
#define NVCC73_IHUB_COMMON_CAPC_SUPPORT_SEMI_PLANAR_TRUE              0x00000001 /* RW--V */
#define NVCC73_IHUB_COMMON_CAPC_SUPPORT_HOR_VER_FLIP                       12:12 /* RWIVF */
#define NVCC73_IHUB_COMMON_CAPC_SUPPORT_HOR_VER_FLIP_FALSE            0x00000000 /* RWI-V */
#define NVCC73_IHUB_COMMON_CAPC_SUPPORT_HOR_VER_FLIP_TRUE             0x00000001 /* RW--V */
#define NVCC73_IHUB_COMMON_CAPC_SUPPORT_MEMPOOL_YUV_COMPRESSION            13:13 /* RWIVF */
#define NVCC73_IHUB_COMMON_CAPC_SUPPORT_MEMPOOL_YUV_COMPRESSION_FALSE 0x00000000 /* RW--V */
#define NVCC73_IHUB_COMMON_CAPC_SUPPORT_MEMPOOL_YUV_COMPRESSION_TRUE  0x00000001 /* RWI-V */
#define NVCC73_IHUB_COMMON_CAPE                                       0x24 /* RW-4R */
#define NVCC73_IHUB_COMMON_CAPE_PHYWIN_BUFFER_SIZE                          15:0 /* RWIUF */
#define NVCC73_IHUB_COMMON_CAPF                                       0x28 /* RW-4R */
#define NVCC73_IHUB_COMMON_CAPF_PHYWIN0_SUPPORT_MULTI_TILE                   0:0 /* RWIVF */
#define NVCC73_IHUB_COMMON_CAPF_PHYWIN0_SUPPORT_MULTI_TILE_NO         0x00000000 /* RW--V */
#define NVCC73_IHUB_COMMON_CAPF_PHYWIN0_SUPPORT_MULTI_TILE_YES        0x00000001 /* RW--V */
#define NVCC73_IHUB_COMMON_CAPF_PHYWIN1_SUPPORT_MULTI_TILE                   1:1 /* RWIVF */
#define NVCC73_IHUB_COMMON_CAPF_PHYWIN1_SUPPORT_MULTI_TILE_NO         0x00000000 /* RW--V */
#define NVCC73_IHUB_COMMON_CAPF_PHYWIN1_SUPPORT_MULTI_TILE_YES        0x00000001 /* RW--V */
#define NVCC73_IHUB_COMMON_CAPF_PHYWIN2_SUPPORT_MULTI_TILE                   2:2 /* RWIVF */
#define NVCC73_IHUB_COMMON_CAPF_PHYWIN2_SUPPORT_MULTI_TILE_NO         0x00000000 /* RW--V */
#define NVCC73_IHUB_COMMON_CAPF_PHYWIN2_SUPPORT_MULTI_TILE_YES        0x00000001 /* RW--V */
#define NVCC73_IHUB_COMMON_CAPF_PHYWIN3_SUPPORT_MULTI_TILE                   3:3 /* RWIVF */
#define NVCC73_IHUB_COMMON_CAPF_PHYWIN3_SUPPORT_MULTI_TILE_NO         0x00000000 /* RW--V */
#define NVCC73_IHUB_COMMON_CAPF_PHYWIN3_SUPPORT_MULTI_TILE_YES        0x00000001 /* RW--V */
#define NVCC73_IHUB_COMMON_CAPF_PHYWIN4_SUPPORT_MULTI_TILE                   4:4 /* RWIVF */
#define NVCC73_IHUB_COMMON_CAPF_PHYWIN4_SUPPORT_MULTI_TILE_NO         0x00000000 /* RW--V */
#define NVCC73_IHUB_COMMON_CAPF_PHYWIN4_SUPPORT_MULTI_TILE_YES        0x00000001 /* RW--V */
#define NVCC73_IHUB_COMMON_CAPF_PHYWIN5_SUPPORT_MULTI_TILE                   5:5 /* RWIVF */
#define NVCC73_IHUB_COMMON_CAPF_PHYWIN5_SUPPORT_MULTI_TILE_NO         0x00000000 /* RW--V */
#define NVCC73_IHUB_COMMON_CAPF_PHYWIN5_SUPPORT_MULTI_TILE_YES        0x00000001 /* RW--V */
#define NVCC73_IHUB_COMMON_CAPF_PHYWIN6_SUPPORT_MULTI_TILE                   6:6 /* RWIVF */
#define NVCC73_IHUB_COMMON_CAPF_PHYWIN6_SUPPORT_MULTI_TILE_NO         0x00000000 /* RW--V */
#define NVCC73_IHUB_COMMON_CAPF_PHYWIN6_SUPPORT_MULTI_TILE_YES        0x00000001 /* RW--V */
#define NVCC73_IHUB_COMMON_CAPF_PHYWIN7_SUPPORT_MULTI_TILE                   7:7 /* RWIVF */
#define NVCC73_IHUB_COMMON_CAPF_PHYWIN7_SUPPORT_MULTI_TILE_NO         0x00000000 /* RW--V */
#define NVCC73_IHUB_COMMON_CAPF_PHYWIN7_SUPPORT_MULTI_TILE_YES        0x00000001 /* RW--V */
#define NVCC73_IHUB_COMMON_CAPF_PHYWIN8_SUPPORT_MULTI_TILE                   8:8 /* RWIVF */
#define NVCC73_IHUB_COMMON_CAPF_PHYWIN8_SUPPORT_MULTI_TILE_NO         0x00000000 /* RW--V */
#define NVCC73_IHUB_COMMON_CAPF_PHYWIN8_SUPPORT_MULTI_TILE_YES        0x00000001 /* RW--V */
#define NVCC73_IHUB_COMMON_CAPF_PHYWIN9_SUPPORT_MULTI_TILE                   9:9 /* RWIVF */
#define NVCC73_IHUB_COMMON_CAPF_PHYWIN9_SUPPORT_MULTI_TILE_NO         0x00000000 /* RW--V */
#define NVCC73_IHUB_COMMON_CAPF_PHYWIN9_SUPPORT_MULTI_TILE_YES        0x00000001 /* RW--V */
#define NVCC73_IHUB_COMMON_CAPF_PHYWIN10_SUPPORT_MULTI_TILE                10:10 /* RWIVF */
#define NVCC73_IHUB_COMMON_CAPF_PHYWIN10_SUPPORT_MULTI_TILE_NO        0x00000000 /* RW--V */
#define NVCC73_IHUB_COMMON_CAPF_PHYWIN10_SUPPORT_MULTI_TILE_YES       0x00000001 /* RW--V */
#define NVCC73_IHUB_COMMON_CAPF_PHYWIN11_SUPPORT_MULTI_TILE                11:11 /* RWIVF */
#define NVCC73_IHUB_COMMON_CAPF_PHYWIN11_SUPPORT_MULTI_TILE_NO        0x00000000 /* RW--V */
#define NVCC73_IHUB_COMMON_CAPF_PHYWIN11_SUPPORT_MULTI_TILE_YES       0x00000001 /* RW--V */
#define NVCC73_IHUB_COMMON_CAPF_PHYWIN12_SUPPORT_MULTI_TILE                12:12 /* RWIVF */
#define NVCC73_IHUB_COMMON_CAPF_PHYWIN12_SUPPORT_MULTI_TILE_NO        0x00000000 /* RW--V */
#define NVCC73_IHUB_COMMON_CAPF_PHYWIN12_SUPPORT_MULTI_TILE_YES       0x00000001 /* RW--V */
#define NVCC73_IHUB_COMMON_CAPF_PHYWIN13_SUPPORT_MULTI_TILE                13:13 /* RWIVF */
#define NVCC73_IHUB_COMMON_CAPF_PHYWIN13_SUPPORT_MULTI_TILE_NO        0x00000000 /* RW--V */
#define NVCC73_IHUB_COMMON_CAPF_PHYWIN13_SUPPORT_MULTI_TILE_YES       0x00000001 /* RW--V */
#define NVCC73_IHUB_COMMON_CAPF_PHYWIN14_SUPPORT_MULTI_TILE                14:14 /* RWIVF */
#define NVCC73_IHUB_COMMON_CAPF_PHYWIN14_SUPPORT_MULTI_TILE_NO        0x00000000 /* RW--V */
#define NVCC73_IHUB_COMMON_CAPF_PHYWIN14_SUPPORT_MULTI_TILE_YES       0x00000001 /* RW--V */
#define NVCC73_IHUB_COMMON_CAPF_PHYWIN15_SUPPORT_MULTI_TILE                15:15 /* RWIVF */
#define NVCC73_IHUB_COMMON_CAPF_PHYWIN15_SUPPORT_MULTI_TILE_NO        0x00000000 /* RW--V */
#define NVCC73_IHUB_COMMON_CAPF_PHYWIN15_SUPPORT_MULTI_TILE_YES       0x00000001 /* RW--V */
#define NVCC73_IHUB_COMMON_CAPF_PHYWIN16_SUPPORT_MULTI_TILE                16:16 /* RWIVF */
#define NVCC73_IHUB_COMMON_CAPF_PHYWIN16_SUPPORT_MULTI_TILE_NO        0x00000000 /* RW--V */
#define NVCC73_IHUB_COMMON_CAPF_PHYWIN16_SUPPORT_MULTI_TILE_YES       0x00000001 /* RW--V */
#define NVCC73_IHUB_COMMON_CAPF_PHYWIN17_SUPPORT_MULTI_TILE                17:17 /* RWIVF */
#define NVCC73_IHUB_COMMON_CAPF_PHYWIN17_SUPPORT_MULTI_TILE_NO        0x00000000 /* RW--V */
#define NVCC73_IHUB_COMMON_CAPF_PHYWIN17_SUPPORT_MULTI_TILE_YES       0x00000001 /* RW--V */
#define NVCC73_IHUB_COMMON_CAPF_PHYWIN18_SUPPORT_MULTI_TILE                18:18 /* RWIVF */
#define NVCC73_IHUB_COMMON_CAPF_PHYWIN18_SUPPORT_MULTI_TILE_NO        0x00000000 /* RW--V */
#define NVCC73_IHUB_COMMON_CAPF_PHYWIN18_SUPPORT_MULTI_TILE_YES       0x00000001 /* RW--V */
#define NVCC73_IHUB_COMMON_CAPF_PHYWIN19_SUPPORT_MULTI_TILE                19:19 /* RWIVF */
#define NVCC73_IHUB_COMMON_CAPF_PHYWIN19_SUPPORT_MULTI_TILE_NO        0x00000000 /* RW--V */
#define NVCC73_IHUB_COMMON_CAPF_PHYWIN19_SUPPORT_MULTI_TILE_YES       0x00000001 /* RW--V */
#define NVCC73_IHUB_COMMON_CAPF_PHYWIN20_SUPPORT_MULTI_TILE                20:20 /* RWIVF */
#define NVCC73_IHUB_COMMON_CAPF_PHYWIN20_SUPPORT_MULTI_TILE_NO        0x00000000 /* RW--V */
#define NVCC73_IHUB_COMMON_CAPF_PHYWIN20_SUPPORT_MULTI_TILE_YES       0x00000001 /* RW--V */
#define NVCC73_IHUB_COMMON_CAPF_PHYWIN21_SUPPORT_MULTI_TILE                21:21 /* RWIVF */
#define NVCC73_IHUB_COMMON_CAPF_PHYWIN21_SUPPORT_MULTI_TILE_NO        0x00000000 /* RW--V */
#define NVCC73_IHUB_COMMON_CAPF_PHYWIN21_SUPPORT_MULTI_TILE_YES       0x00000001 /* RW--V */
#define NVCC73_IHUB_COMMON_CAPF_PHYWIN22_SUPPORT_MULTI_TILE                22:22 /* RWIVF */
#define NVCC73_IHUB_COMMON_CAPF_PHYWIN22_SUPPORT_MULTI_TILE_NO        0x00000000 /* RW--V */
#define NVCC73_IHUB_COMMON_CAPF_PHYWIN22_SUPPORT_MULTI_TILE_YES       0x00000001 /* RW--V */
#define NVCC73_IHUB_COMMON_CAPF_PHYWIN23_SUPPORT_MULTI_TILE                23:23 /* RWIVF */
#define NVCC73_IHUB_COMMON_CAPF_PHYWIN23_SUPPORT_MULTI_TILE_NO        0x00000000 /* RW--V */
#define NVCC73_IHUB_COMMON_CAPF_PHYWIN23_SUPPORT_MULTI_TILE_YES       0x00000001 /* RW--V */
#define NVCC73_IHUB_COMMON_CAPF_PHYWIN24_SUPPORT_MULTI_TILE                24:24 /* RWIVF */
#define NVCC73_IHUB_COMMON_CAPF_PHYWIN24_SUPPORT_MULTI_TILE_NO        0x00000000 /* RW--V */
#define NVCC73_IHUB_COMMON_CAPF_PHYWIN24_SUPPORT_MULTI_TILE_YES       0x00000001 /* RW--V */
#define NVCC73_IHUB_COMMON_CAPF_PHYWIN25_SUPPORT_MULTI_TILE                25:25 /* RWIVF */
#define NVCC73_IHUB_COMMON_CAPF_PHYWIN25_SUPPORT_MULTI_TILE_NO        0x00000000 /* RW--V */
#define NVCC73_IHUB_COMMON_CAPF_PHYWIN25_SUPPORT_MULTI_TILE_YES       0x00000001 /* RW--V */
#define NVCC73_IHUB_COMMON_CAPF_PHYWIN26_SUPPORT_MULTI_TILE                26:26 /* RWIVF */
#define NVCC73_IHUB_COMMON_CAPF_PHYWIN26_SUPPORT_MULTI_TILE_NO        0x00000000 /* RW--V */
#define NVCC73_IHUB_COMMON_CAPF_PHYWIN26_SUPPORT_MULTI_TILE_YES       0x00000001 /* RW--V */
#define NVCC73_IHUB_COMMON_CAPF_PHYWIN27_SUPPORT_MULTI_TILE                27:27 /* RWIVF */
#define NVCC73_IHUB_COMMON_CAPF_PHYWIN27_SUPPORT_MULTI_TILE_NO        0x00000000 /* RW--V */
#define NVCC73_IHUB_COMMON_CAPF_PHYWIN27_SUPPORT_MULTI_TILE_YES       0x00000001 /* RW--V */
#define NVCC73_IHUB_COMMON_CAPF_PHYWIN28_SUPPORT_MULTI_TILE                28:28 /* RWIVF */
#define NVCC73_IHUB_COMMON_CAPF_PHYWIN28_SUPPORT_MULTI_TILE_NO        0x00000000 /* RW--V */
#define NVCC73_IHUB_COMMON_CAPF_PHYWIN28_SUPPORT_MULTI_TILE_YES       0x00000001 /* RW--V */
#define NVCC73_IHUB_COMMON_CAPF_PHYWIN29_SUPPORT_MULTI_TILE                29:29 /* RWIVF */
#define NVCC73_IHUB_COMMON_CAPF_PHYWIN29_SUPPORT_MULTI_TILE_NO        0x00000000 /* RW--V */
#define NVCC73_IHUB_COMMON_CAPF_PHYWIN29_SUPPORT_MULTI_TILE_YES       0x00000001 /* RW--V */
#define NVCC73_IHUB_COMMON_CAPF_PHYWIN30_SUPPORT_MULTI_TILE                30:30 /* RWIVF */
#define NVCC73_IHUB_COMMON_CAPF_PHYWIN30_SUPPORT_MULTI_TILE_NO        0x00000000 /* RW--V */
#define NVCC73_IHUB_COMMON_CAPF_PHYWIN30_SUPPORT_MULTI_TILE_YES       0x00000001 /* RW--V */
#define NVCC73_IHUB_COMMON_CAPF_PHYWIN31_SUPPORT_MULTI_TILE                31:31 /* RWIVF */
#define NVCC73_IHUB_COMMON_CAPF_PHYWIN31_SUPPORT_MULTI_TILE_NO        0x00000000 /* RW--V */
#define NVCC73_IHUB_COMMON_CAPF_PHYWIN31_SUPPORT_MULTI_TILE_YES       0x00000001 /* RW--V */
#define NVCC73_IHUB_COMMON_CAPF_PHYWIN_SUPPORT_MULTI_TILE(i)     (0+(i)):(0+(i)) /* RWIVF */
#define NVCC73_IHUB_COMMON_CAPF_PHYWIN_SUPPORT_MULTI_TILE__SIZE_1             32 /*       */
#define NVCC73_IHUB_COMMON_CAPF_PHYWIN_SUPPORT_MULTI_TILE_NO          0x00000000 /* RW--V */
#define NVCC73_IHUB_COMMON_CAPF_PHYWIN_SUPPORT_MULTI_TILE_YES         0x00000001 /* RW--V */
#define NVCC73_POSTCOMP_HDR_CAPA(i)                                      (0x680+(i)*32) /* RW-4A */
#define NVCC73_POSTCOMP_HDR_CAPA__SIZE_1                                                   8 /*       */
#define NVCC73_POSTCOMP_HDR_CAPA_FULL_WIDTH                                              4:0 /* RWIVF */
#define NVCC73_POSTCOMP_HDR_CAPA_UNIT_WIDTH                                              9:5 /* RWIVF */
#define NVCC73_POSTCOMP_HDR_CAPA_OCSC0_PRESENT                                         16:16 /* RWIVF */
#define NVCC73_POSTCOMP_HDR_CAPA_OCSC0_PRESENT_TRUE                               0x00000001 /* RW--V */
#define NVCC73_POSTCOMP_HDR_CAPA_OCSC0_PRESENT_FALSE                              0x00000000 /* RW--V */
#define NVCC73_POSTCOMP_HDR_CAPA_OCSC1_PRESENT                                         17:17 /* RWIVF */
#define NVCC73_POSTCOMP_HDR_CAPA_OCSC1_PRESENT_TRUE                               0x00000001 /* RW--V */
#define NVCC73_POSTCOMP_HDR_CAPA_OCSC1_PRESENT_FALSE                              0x00000000 /* RW--V */
#define NVCC73_POSTCOMP_HDR_CAPA_SCLR_PRESENT                                          18:18 /* RWIVF */
#define NVCC73_POSTCOMP_HDR_CAPA_SCLR_PRESENT_TRUE                                0x00000001 /* RW--V */
#define NVCC73_POSTCOMP_HDR_CAPA_SCLR_PRESENT_FALSE                               0x00000000 /* RW--V */
#define NVCC73_POSTCOMP_HDR_CAPA_HCLPF_PRESENT                                         19:19 /* RWIVF */
#define NVCC73_POSTCOMP_HDR_CAPA_HCLPF_PRESENT_TRUE                               0x00000001 /* RW--V */
#define NVCC73_POSTCOMP_HDR_CAPA_HCLPF_PRESENT_FALSE                              0x00000000 /* RW--V */
#define NVCC73_POSTCOMP_HDR_CAPA_DTH_PRESENT                                           20:20 /* RWIVF */
#define NVCC73_POSTCOMP_HDR_CAPA_DTH_PRESENT_TRUE                                 0x00000001 /* RW--V */
#define NVCC73_POSTCOMP_HDR_CAPA_DTH_PRESENT_FALSE                                0x00000000 /* RW--V */
#define NVCC73_POSTCOMP_HDR_CAPA_OSCAN_PRESENT                                         21:21 /* RWIVF */
#define NVCC73_POSTCOMP_HDR_CAPA_OSCAN_PRESENT_TRUE                               0x00000001 /* RW--V */
#define NVCC73_POSTCOMP_HDR_CAPA_OSCAN_PRESENT_FALSE                              0x00000000 /* RW--V */
#define NVCC73_POSTCOMP_HDR_CAPA_DSC_PRESENT                                           22:22 /* RWIVF */
#define NVCC73_POSTCOMP_HDR_CAPA_DSC_PRESENT_TRUE                                 0x00000001 /* RW--V */
#define NVCC73_POSTCOMP_HDR_CAPA_DSC_PRESENT_FALSE                                0x00000000 /* RW--V */
#define NVCC73_POSTCOMP_HDR_CAPA_VFILTER_PRESENT                                       23:23 /* RWIVF */
#define NVCC73_POSTCOMP_HDR_CAPA_VFILTER_PRESENT_TRUE                             0x00000001 /* RW--V */
#define NVCC73_POSTCOMP_HDR_CAPA_VFILTER_PRESENT_FALSE                            0x00000000 /* RW--V */
#define NVCC73_POSTCOMP_HDR_CAPA_LTM_PRESENT                                           25:25 /* RWIVF */
#define NVCC73_POSTCOMP_HDR_CAPA_LTM_PRESENT_TRUE                                 0x00000001 /* RW--V */
#define NVCC73_POSTCOMP_HDR_CAPA_LTM_PRESENT_FALSE                                0x00000000 /* RW--V */
#define NVCC73_POSTCOMP_HDR_CAPB(i)                                      (0x684+(i)*32) /* RW-4A */
#define NVCC73_POSTCOMP_HDR_CAPB__SIZE_1                                                   8 /*       */
#define NVCC73_POSTCOMP_HDR_CAPB_VGA                                                     0:0 /* RWIVF */
#define NVCC73_POSTCOMP_HDR_CAPB_VGA_TRUE                                         0x00000001 /* RW--V */
#define NVCC73_POSTCOMP_HDR_CAPB_VGA_FALSE                                        0x00000000 /* RW--V */
#define NVCC73_POSTCOMP_HDR_CAPB_OLUT_SZ                                                12:1 /* RWIVF */
#define NVCC73_POSTCOMP_HDR_CAPB_OLUT_LOGNR                                            15:13 /* RWIVF */
#define NVCC73_POSTCOMP_HDR_CAPB_OLUT_SFCLOAD                                          17:17 /* RWIVF */
#define NVCC73_POSTCOMP_HDR_CAPB_OLUT_SFCLOAD_TRUE                                0x00000001 /* RW--V */
#define NVCC73_POSTCOMP_HDR_CAPB_OLUT_SFCLOAD_FALSE                               0x00000000 /* RW--V */
#define NVCC73_POSTCOMP_HDR_CAPB_OLUT_DIRECT                                           18:18 /* RWIVF */
#define NVCC73_POSTCOMP_HDR_CAPB_OLUT_DIRECT_TRUE                                 0x00000001 /* RW--V */
#define NVCC73_POSTCOMP_HDR_CAPB_OLUT_DIRECT_FALSE                                0x00000000 /* RW--V */
#define NVCC73_POSTCOMP_HDR_CAPC(i)                                      (0x688+(i)*32) /* RW-4A */
#define NVCC73_POSTCOMP_HDR_CAPC__SIZE_1                                                   8 /*       */
#define NVCC73_POSTCOMP_HDR_CAPC_OCSC0_PRECISION                                         4:0 /* RWIVF */
#define NVCC73_POSTCOMP_HDR_CAPC_OCSC0_UNITY_CLAMP                                       5:5 /* RWIVF */
#define NVCC73_POSTCOMP_HDR_CAPC_OCSC0_UNITY_CLAMP_TRUE                           0x00000001 /* RW--V */
#define NVCC73_POSTCOMP_HDR_CAPC_OCSC0_UNITY_CLAMP_FALSE                          0x00000000 /* RW--V */
#define NVCC73_POSTCOMP_HDR_CAPC_OCSC1_PRECISION                                        12:8 /* RWIVF */
#define NVCC73_POSTCOMP_HDR_CAPC_OCSC1_UNITY_CLAMP                                     13:13 /* RWIVF */
#define NVCC73_POSTCOMP_HDR_CAPC_OCSC1_UNITY_CLAMP_TRUE                           0x00000001 /* RW--V */
#define NVCC73_POSTCOMP_HDR_CAPC_OCSC1_UNITY_CLAMP_FALSE                          0x00000000 /* RW--V */
#define NVCC73_POSTCOMP_HDR_CAPC_SCLR_SF_PRECISION                                     20:16 /* RWIVF */
#define NVCC73_POSTCOMP_HDR_CAPC_SCLR_CI_PRECISION                                     24:21 /* RWIVF */
#define NVCC73_POSTCOMP_HDR_CAPC_SCLR_VS_EXT_RGB                                       25:25 /* RWIVF */
#define NVCC73_POSTCOMP_HDR_CAPC_SCLR_VS_EXT_RGB_TRUE                             0x00000001 /* RW--V */
#define NVCC73_POSTCOMP_HDR_CAPC_SCLR_VS_EXT_RGB_FALSE                            0x00000000 /* RW--V */
#define NVCC73_POSTCOMP_HDR_CAPC_SCLR_VS_MAX_SCALE_FACTOR                              28:28 /* RWIVF */
#define NVCC73_POSTCOMP_HDR_CAPC_SCLR_VS_MAX_SCALE_FACTOR_2X                      0x00000000 /* RW--V */
#define NVCC73_POSTCOMP_HDR_CAPC_SCLR_VS_MAX_SCALE_FACTOR_4X                      0x00000001 /* RW--V */
#define NVCC73_POSTCOMP_HDR_CAPC_SCLR_HS_MAX_SCALE_FACTOR                              30:30 /* RWIVF */
#define NVCC73_POSTCOMP_HDR_CAPC_SCLR_HS_MAX_SCALE_FACTOR_2X                      0x00000000 /* RW--V */
#define NVCC73_POSTCOMP_HDR_CAPC_SCLR_HS_MAX_SCALE_FACTOR_4X                      0x00000001 /* RW--V */
#define NVCC73_POSTCOMP_HDR_CAPD(i)                                      (0x68c+(i)*32) /* RW-4A */
#define NVCC73_POSTCOMP_HDR_CAPD__SIZE_1                                                   8 /*       */
#define NVCC73_POSTCOMP_HDR_CAPD_VSCLR_MAX_PIXELS_2TAP                                  15:0 /* RWIVF */
#define NVCC73_POSTCOMP_HDR_CAPD_VSCLR_MAX_PIXELS_5TAP                                 31:16 /* RWIVF */
#define NVCC73_POSTCOMP_HDR_CAPE(i)                                      (0x690+(i)*32) /* RW-4A */
#define NVCC73_POSTCOMP_HDR_CAPE__SIZE_1                                                   8 /*       */
#define NVCC73_POSTCOMP_HDR_CAPE_DSC_MAXLINEWIDTH                                       15:0 /* RWIUF */
#define NVCC73_POSTCOMP_HDR_CAPE_DSC_NATIVE422                                         16:16 /* RWIVF */
#define NVCC73_POSTCOMP_HDR_CAPE_DSC_NATIVE422_TRUE                               0x00000001 /* RW--V */
#define NVCC73_POSTCOMP_HDR_CAPE_DSC_NATIVE422_FALSE                              0x00000000 /* RW--V */
#define NVCC73_POSTCOMP_HDR_CAPE_DSC_NATIVE420                                         17:17 /* RWIVF */
#define NVCC73_POSTCOMP_HDR_CAPE_DSC_NATIVE420_TRUE                               0x00000001 /* RW--V */
#define NVCC73_POSTCOMP_HDR_CAPE_DSC_NATIVE420_FALSE                              0x00000000 /* RW--V */
#define NVCC73_POSTCOMP_HDR_CAPE_3DLUT_PRESENT                                         18:18 /* RWIVF */
#define NVCC73_POSTCOMP_HDR_CAPE_3DLUT_PRESENT_TRUE                               0x00000001 /* RW--V */
#define NVCC73_POSTCOMP_HDR_CAPE_3DLUT_PRESENT_FALSE                              0x00000000 /* RW--V */
#define NVCC73_POSTCOMP_HDR_CAPE_3DLUT_MAX_SIZE                                        21:19 /* RWIVF */
#define NVCC73_POSTCOMP_HDR_CAPE_3DLUT_MAX_SIZE_9x9x9                             0x00000000 /* RW--V */
#define NVCC73_POSTCOMP_HDR_CAPE_3DLUT_MAX_SIZE_17x17x17                          0x00000001 /* RW--V */
#define NVCC73_POSTCOMP_HDR_CAPE_3DLUT_MAX_SIZE_25x25x25                          0x00000002 /* RW--V */
#define NVCC73_POSTCOMP_HDR_CAPE_3DLUT_MAX_SIZE_33x33x33                          0x00000003 /* RW--V */
#define NVCC73_POSTCOMP_HDR_CAPE_3DLUT_MAX_SIZE_RESERVED_4                        0x00000004 /* RW--V */
#define NVCC73_POSTCOMP_HDR_CAPE_3DLUT_MAX_SIZE_RESERVED_5                        0x00000005 /* RW--V */
#define NVCC73_POSTCOMP_HDR_CAPE_3DLUT_MAX_SIZE_RESERVED_6                        0x00000006 /* RW--V */
#define NVCC73_POSTCOMP_HDR_CAPE_3DLUT_MAX_SIZE_RESERVED_7                        0x00000007 /* RW--V */
#define NVCC73_POSTCOMP_HDR_CAPE_3DLUT_NUM_CURVES                                      23:22 /* RWIUF */
#define NVCC73_POSTCOMP_HDR_CAPF(i)                                      (0x694+(i)*32) /* RW-4A */
#define NVCC73_POSTCOMP_HDR_CAPF__SIZE_1                                                   8 /*       */
#define NVCC73_POSTCOMP_HDR_CAPF_VFILTER_MAX_PIXELS                                     15:0 /* RWIVF */
#define NVCC73_POSTCOMP_HDR_CAPF_LTM_MAX_PIXELS                                        31:16 /* RWIVF */
#define NVCC73_POSTCOMP_HDR_CAPG(i)                                      (0x698+(i)*32) /* RW-4A */
#define NVCC73_POSTCOMP_HDR_CAPG__SIZE_1                                                   8 /*       */
#define NVCC73_POSTCOMP_HDR_CAPG_CMI_SZ                                                 11:0 /* RWIUF */
#define NVCC73_POSTCOMP_HDR_CAPG_CMI_LOGNR                                             14:12 /* RWIUF */
#define NVCC73_POSTCOMP_HDR_CAPG_CMO_SZ                                                26:15 /* RWIUF */
#define NVCC73_POSTCOMP_HDR_CAPG_CMO_LOGNR                                             29:27 /* RWIUF */
#define NVCC73_SOR_CAP(i)                                     (0x144+(i)*8) /* RW-4A */
#define NVCC73_SOR_CAP__SIZE_1                                                 8 /*       */
#define NVCC73_SOR_CAP_SINGLE_LVDS_18                                        0:0 /* RWIVF */
#define NVCC73_SOR_CAP_SINGLE_LVDS_18_FALSE                           0x00000000 /* RW--V */
#define NVCC73_SOR_CAP_SINGLE_LVDS_18_TRUE                            0x00000001 /* RW--V */
#define NVCC73_SOR_CAP_SINGLE_LVDS_24                                        1:1 /* RWIVF */
#define NVCC73_SOR_CAP_SINGLE_LVDS_24_FALSE                           0x00000000 /* RW--V */
#define NVCC73_SOR_CAP_SINGLE_LVDS_24_TRUE                            0x00000001 /* RW--V */
#define NVCC73_SOR_CAP_DUAL_LVDS_18                                          2:2 /* RWIVF */
#define NVCC73_SOR_CAP_DUAL_LVDS_18_FALSE                             0x00000000 /* RW--V */
#define NVCC73_SOR_CAP_DUAL_LVDS_18_TRUE                              0x00000001 /* RW--V */
#define NVCC73_SOR_CAP_DUAL_LVDS_24                                          3:3 /* RWIVF */
#define NVCC73_SOR_CAP_DUAL_LVDS_24_FALSE                             0x00000000 /* RW--V */
#define NVCC73_SOR_CAP_DUAL_LVDS_24_TRUE                              0x00000001 /* RW--V */
#define NVCC73_SOR_CAP_DP_DUAL_MODE                                          4:4 /* RWIVF */
#define NVCC73_SOR_CAP_DP_DUAL_MODE_FALSE                             0x00000000 /* RW--V */
#define NVCC73_SOR_CAP_DP_DUAL_MODE_TRUE                              0x00000001 /* RW--V */
#define NVCC73_SOR_CAP_SINGLE_TMDS_A                                         8:8 /* RWIVF */
#define NVCC73_SOR_CAP_SINGLE_TMDS_A_FALSE                            0x00000000 /* RW--V */
#define NVCC73_SOR_CAP_SINGLE_TMDS_A_TRUE                             0x00000001 /* RW--V */
#define NVCC73_SOR_CAP_SINGLE_TMDS_B                                         9:9 /* RWIVF */
#define NVCC73_SOR_CAP_SINGLE_TMDS_B_FALSE                            0x00000000 /* RW--V */
#define NVCC73_SOR_CAP_SINGLE_TMDS_B_TRUE                             0x00000001 /* RW--V */
#define NVCC73_SOR_CAP_DUAL_TMDS                                           11:11 /* RWIVF */
#define NVCC73_SOR_CAP_DUAL_TMDS_FALSE                                0x00000000 /* RW--V */
#define NVCC73_SOR_CAP_DUAL_TMDS_TRUE                                 0x00000001 /* RW--V */
#define NVCC73_SOR_CAP_DISPLAY_OVER_PCIE                                   13:13 /* RWIVF */
#define NVCC73_SOR_CAP_DISPLAY_OVER_PCIE_FALSE                        0x00000000 /* RW--V */
#define NVCC73_SOR_CAP_DISPLAY_OVER_PCIE_TRUE                         0x00000001 /* RW--V */
#define NVCC73_SOR_CAP_DP_TUNNELING_OVER_USB4                              15:15 /* RWIVF */
#define NVCC73_SOR_CAP_DP_TUNNELING_OVER_USB4_FALSE                   0x00000000 /* RW--V */
#define NVCC73_SOR_CAP_DP_TUNNELING_OVER_USB4_TRUE                    0x00000001 /* RW--V */
#define NVCC73_SOR_CAP_SDI                                                 16:16 /* RWIVF */
#define NVCC73_SOR_CAP_SDI_FALSE                                      0x00000000 /* RW--V */
#define NVCC73_SOR_CAP_SDI_TRUE                                       0x00000001 /* RW--V */
#define NVCC73_SOR_CAP_DP_DUAL_MST                                         23:23 /* RWIVF */
#define NVCC73_SOR_CAP_DP_DUAL_MST_FALSE                              0x00000000 /* RW--V */
#define NVCC73_SOR_CAP_DP_DUAL_MST_TRUE                               0x00000001 /* RW--V */
#define NVCC73_SOR_CAP_DP_A                                                24:24 /* RWIVF */
#define NVCC73_SOR_CAP_DP_A_FALSE                                     0x00000000 /* RW--V */
#define NVCC73_SOR_CAP_DP_A_TRUE                                      0x00000001 /* RW--V */
#define NVCC73_SOR_CAP_DP_B                                                25:25 /* RWIVF */
#define NVCC73_SOR_CAP_DP_B_FALSE                                     0x00000000 /* RW--V */
#define NVCC73_SOR_CAP_DP_B_TRUE                                      0x00000001 /* RW--V */
#define NVCC73_SOR_CAP_DP_INTERLACE                                        26:26 /* RWIVF */
#define NVCC73_SOR_CAP_DP_INTERLACE_FALSE                             0x00000000 /* RW--V */
#define NVCC73_SOR_CAP_DP_INTERLACE_TRUE                              0x00000001 /* RW--V */
#define NVCC73_SOR_CAP_DP_8_LANES                                          27:27 /* RWIVF */
#define NVCC73_SOR_CAP_DP_8_LANES_FALSE                               0x00000000 /* RW--V */
#define NVCC73_SOR_CAP_DP_8_LANES_TRUE                                0x00000001 /* RW--V */
#define NVCC73_SOR_CAP_HDMI_FRL                                            28:28 /* RWIVF */
#define NVCC73_SOR_CAP_HDMI_FRL_FALSE                                 0x00000000 /* RW--V */
#define NVCC73_SOR_CAP_HDMI_FRL_TRUE                                  0x00000001 /* RW--V */
#define NVCC73_SOR_CAP_HDMI_FRL_YUV422                                     29:29 /* RWIVF */
#define NVCC73_SOR_CAP_HDMI_FRL_YUV422_FALSE                          0x00000000 /* RW--V */
#define NVCC73_SOR_CAP_HDMI_FRL_YUV422_TRUE                           0x00000001 /* RW--V */
#define NVCC73_SOR_CAP_DP_128B132B                                         30:30 /* RWIVF */
#define NVCC73_SOR_CAP_DP_128B132B_FALSE                              0x00000000 /* RW--V */
#define NVCC73_SOR_CAP_DP_128B132B_TRUE                               0x00000001 /* RW--V */
#define NVCC73_PRECOMP_WIN_PIPE_HDR_CAPA(i)                              (0x780+(i)*32) /* RW-4A */
#define NVCC73_PRECOMP_WIN_PIPE_HDR_CAPA__SIZE_1                                          32 /*       */
#define NVCC73_PRECOMP_WIN_PIPE_HDR_CAPA_FULL_WIDTH                                      4:0 /* RWIVF */
#define NVCC73_PRECOMP_WIN_PIPE_HDR_CAPA_UNIT_WIDTH                                      9:5 /* RWIVF */
#define NVCC73_PRECOMP_WIN_PIPE_HDR_CAPA_ALPHA_WIDTH                                   13:10 /* RWIVF */
#define NVCC73_PRECOMP_WIN_PIPE_HDR_CAPA_CSC00_PRESENT                                 16:16 /* RWIVF */
#define NVCC73_PRECOMP_WIN_PIPE_HDR_CAPA_CSC00_PRESENT_TRUE                       0x00000001 /* RW--V */
#define NVCC73_PRECOMP_WIN_PIPE_HDR_CAPA_CSC00_PRESENT_FALSE                      0x00000000 /* RW--V */
#define NVCC73_PRECOMP_WIN_PIPE_HDR_CAPA_CSC0LUT_PRESENT                               17:17 /* RWIVF */
#define NVCC73_PRECOMP_WIN_PIPE_HDR_CAPA_CSC0LUT_PRESENT_TRUE                     0x00000001 /* RW--V */
#define NVCC73_PRECOMP_WIN_PIPE_HDR_CAPA_CSC0LUT_PRESENT_FALSE                    0x00000000 /* RW--V */
#define NVCC73_PRECOMP_WIN_PIPE_HDR_CAPA_CSC01_PRESENT                                 18:18 /* RWIVF */
#define NVCC73_PRECOMP_WIN_PIPE_HDR_CAPA_CSC01_PRESENT_TRUE                       0x00000001 /* RW--V */
#define NVCC73_PRECOMP_WIN_PIPE_HDR_CAPA_CSC01_PRESENT_FALSE                      0x00000000 /* RW--V */
#define NVCC73_PRECOMP_WIN_PIPE_HDR_CAPA_SCLR_PRESENT                                  19:19 /* RWIVF */
#define NVCC73_PRECOMP_WIN_PIPE_HDR_CAPA_SCLR_PRESENT_TRUE                        0x00000001 /* RW--V */
#define NVCC73_PRECOMP_WIN_PIPE_HDR_CAPA_SCLR_PRESENT_FALSE                       0x00000000 /* RW--V */
#define NVCC73_PRECOMP_WIN_PIPE_HDR_CAPA_TMO_PRESENT                                   20:20 /* RWIVF */
#define NVCC73_PRECOMP_WIN_PIPE_HDR_CAPA_TMO_PRESENT_TRUE                         0x00000001 /* RW--V */
#define NVCC73_PRECOMP_WIN_PIPE_HDR_CAPA_TMO_PRESENT_FALSE                        0x00000000 /* RW--V */
#define NVCC73_PRECOMP_WIN_PIPE_HDR_CAPA_GMA_PRESENT                                   21:21 /* RWIVF */
#define NVCC73_PRECOMP_WIN_PIPE_HDR_CAPA_GMA_PRESENT_TRUE                         0x00000001 /* RW--V */
#define NVCC73_PRECOMP_WIN_PIPE_HDR_CAPA_GMA_PRESENT_FALSE                        0x00000000 /* RW--V */
#define NVCC73_PRECOMP_WIN_PIPE_HDR_CAPA_CSC10_PRESENT                                 22:22 /* RWIVF */
#define NVCC73_PRECOMP_WIN_PIPE_HDR_CAPA_CSC10_PRESENT_TRUE                       0x00000001 /* RW--V */
#define NVCC73_PRECOMP_WIN_PIPE_HDR_CAPA_CSC10_PRESENT_FALSE                      0x00000000 /* RW--V */
#define NVCC73_PRECOMP_WIN_PIPE_HDR_CAPA_CSC1LUT_PRESENT                               23:23 /* RWIVF */
#define NVCC73_PRECOMP_WIN_PIPE_HDR_CAPA_CSC1LUT_PRESENT_TRUE                     0x00000001 /* RW--V */
#define NVCC73_PRECOMP_WIN_PIPE_HDR_CAPA_CSC1LUT_PRESENT_FALSE                    0x00000000 /* RW--V */
#define NVCC73_PRECOMP_WIN_PIPE_HDR_CAPA_CSC11_PRESENT                                 24:24 /* RWIVF */
#define NVCC73_PRECOMP_WIN_PIPE_HDR_CAPA_CSC11_PRESENT_TRUE                       0x00000001 /* RW--V */
#define NVCC73_PRECOMP_WIN_PIPE_HDR_CAPA_CSC11_PRESENT_FALSE                      0x00000000 /* RW--V */
#define NVCC73_PRECOMP_WIN_PIPE_HDR_CAPB(i)                              (0x784+(i)*32) /* RW-4A */
#define NVCC73_PRECOMP_WIN_PIPE_HDR_CAPB__SIZE_1                                          32 /*       */
#define NVCC73_PRECOMP_WIN_PIPE_HDR_CAPB_FMT_PRECISION                                   4:0 /* RWIVF */
#define NVCC73_PRECOMP_WIN_PIPE_HDR_CAPB_ILUT_LOGSZ                                      9:6 /* RWIVF */
#define NVCC73_PRECOMP_WIN_PIPE_HDR_CAPB_ILUT_LOGNR                                    12:10 /* RWIVF */
#define NVCC73_PRECOMP_WIN_PIPE_HDR_CAPB_ILUT_SFCLOAD                                  14:14 /* RWIVF */
#define NVCC73_PRECOMP_WIN_PIPE_HDR_CAPB_ILUT_SFCLOAD_TRUE                        0x00000001 /* RW--V */
#define NVCC73_PRECOMP_WIN_PIPE_HDR_CAPB_ILUT_SFCLOAD_FALSE                       0x00000000 /* RW--V */
#define NVCC73_PRECOMP_WIN_PIPE_HDR_CAPB_ILUT_DIRECT                                   15:15 /* RWIVF */
#define NVCC73_PRECOMP_WIN_PIPE_HDR_CAPB_ILUT_DIRECT_TRUE                         0x00000001 /* RW--V */
#define NVCC73_PRECOMP_WIN_PIPE_HDR_CAPB_ILUT_DIRECT_FALSE                        0x00000000 /* RW--V */
#define NVCC73_PRECOMP_WIN_PIPE_HDR_CAPC(i)                              (0x788+(i)*32) /* RW-4A */
#define NVCC73_PRECOMP_WIN_PIPE_HDR_CAPC__SIZE_1                                          32 /*       */
#define NVCC73_PRECOMP_WIN_PIPE_HDR_CAPC_CSC00_PRECISION                                 4:0 /* RWIVF */
#define NVCC73_PRECOMP_WIN_PIPE_HDR_CAPC_CSC00_UNITY_CLAMP                               5:5 /* RWIVF */
#define NVCC73_PRECOMP_WIN_PIPE_HDR_CAPC_CSC00_UNITY_CLAMP_TRUE                   0x00000001 /* RW--V */
#define NVCC73_PRECOMP_WIN_PIPE_HDR_CAPC_CSC00_UNITY_CLAMP_FALSE                  0x00000000 /* RW--V */
#define NVCC73_PRECOMP_WIN_PIPE_HDR_CAPC_CSC0LUT_FVLUT                                 13:13 /* RWIVF */
#define NVCC73_PRECOMP_WIN_PIPE_HDR_CAPC_CSC0LUT_FVLUT_TRUE                       0x00000001 /* RW--V */
#define NVCC73_PRECOMP_WIN_PIPE_HDR_CAPC_CSC0LUT_FVLUT_FALSE                      0x00000000 /* RW--V */
#define NVCC73_PRECOMP_WIN_PIPE_HDR_CAPC_CSC0LUT_DIRECT                                15:15 /* RWIVF */
#define NVCC73_PRECOMP_WIN_PIPE_HDR_CAPC_CSC0LUT_DIRECT_TRUE                      0x00000001 /* RW--V */
#define NVCC73_PRECOMP_WIN_PIPE_HDR_CAPC_CSC0LUT_DIRECT_FALSE                     0x00000000 /* RW--V */
#define NVCC73_PRECOMP_WIN_PIPE_HDR_CAPC_CSC01_PRECISION                               20:16 /* RWIVF */
#define NVCC73_PRECOMP_WIN_PIPE_HDR_CAPC_CSC01_UNITY_CLAMP                             21:21 /* RWIVF */
#define NVCC73_PRECOMP_WIN_PIPE_HDR_CAPC_CSC01_UNITY_CLAMP_TRUE                   0x00000001 /* RW--V */
#define NVCC73_PRECOMP_WIN_PIPE_HDR_CAPC_CSC01_UNITY_CLAMP_FALSE                  0x00000000 /* RW--V */
#define NVCC73_PRECOMP_WIN_PIPE_HDR_CAPD(i)                              (0x78c+(i)*32) /* RW-4A */
#define NVCC73_PRECOMP_WIN_PIPE_HDR_CAPD__SIZE_1                                          32 /*       */
#define NVCC73_PRECOMP_WIN_PIPE_HDR_CAPD_TMO_LOGSZ                                       3:0 /* RWIVF */
#define NVCC73_PRECOMP_WIN_PIPE_HDR_CAPD_TMO_LOGNR                                       6:4 /* RWIVF */
#define NVCC73_PRECOMP_WIN_PIPE_HDR_CAPD_TMO_SFCLOAD                                     8:8 /* RWIVF */
#define NVCC73_PRECOMP_WIN_PIPE_HDR_CAPD_TMO_SFCLOAD_TRUE                         0x00000001 /* RW--V */
#define NVCC73_PRECOMP_WIN_PIPE_HDR_CAPD_TMO_SFCLOAD_FALSE                        0x00000000 /* RW--V */
#define NVCC73_PRECOMP_WIN_PIPE_HDR_CAPD_TMO_DIRECT                                      9:9 /* RWIVF */
#define NVCC73_PRECOMP_WIN_PIPE_HDR_CAPD_TMO_DIRECT_TRUE                          0x00000001 /* RW--V */
#define NVCC73_PRECOMP_WIN_PIPE_HDR_CAPD_TMO_DIRECT_FALSE                         0x00000000 /* RW--V */
#define NVCC73_PRECOMP_WIN_PIPE_HDR_CAPD_SCLR_SF_PRECISION                             16:12 /* RWIVF */
#define NVCC73_PRECOMP_WIN_PIPE_HDR_CAPD_SCLR_CI_PRECISION                             20:17 /* RWIVF */
#define NVCC73_PRECOMP_WIN_PIPE_HDR_CAPD_SCLR_VS_EXT_RGB                               21:21 /* RWIVF */
#define NVCC73_PRECOMP_WIN_PIPE_HDR_CAPD_SCLR_VS_EXT_RGB_TRUE                     0x00000001 /* RW--V */
#define NVCC73_PRECOMP_WIN_PIPE_HDR_CAPD_SCLR_VS_EXT_RGB_FALSE                    0x00000000 /* RW--V */
#define NVCC73_PRECOMP_WIN_PIPE_HDR_CAPD_SCLR_EXT_ALPHA                                22:22 /* RWIVF */
#define NVCC73_PRECOMP_WIN_PIPE_HDR_CAPD_SCLR_EXT_ALPHA_TRUE                      0x00000001 /* RW--V */
#define NVCC73_PRECOMP_WIN_PIPE_HDR_CAPD_SCLR_EXT_ALPHA_FALSE                     0x00000000 /* RW--V */
#define NVCC73_PRECOMP_WIN_PIPE_HDR_CAPD_SCLR_VS_MAX_SCALE_FACTOR                      28:28 /* RWIVF */
#define NVCC73_PRECOMP_WIN_PIPE_HDR_CAPD_SCLR_VS_MAX_SCALE_FACTOR_2X              0x00000000 /* RW--V */
#define NVCC73_PRECOMP_WIN_PIPE_HDR_CAPD_SCLR_VS_MAX_SCALE_FACTOR_4X              0x00000001 /* RW--V */
#define NVCC73_PRECOMP_WIN_PIPE_HDR_CAPD_SCLR_HS_MAX_SCALE_FACTOR                      30:30 /* RWIVF */
#define NVCC73_PRECOMP_WIN_PIPE_HDR_CAPD_SCLR_HS_MAX_SCALE_FACTOR_2X              0x00000000 /* RW--V */
#define NVCC73_PRECOMP_WIN_PIPE_HDR_CAPD_SCLR_HS_MAX_SCALE_FACTOR_4X              0x00000001 /* RW--V */
#define NVCC73_PRECOMP_WIN_PIPE_HDR_CAPE(i)                              (0x790+(i)*32) /* RW-4A */
#define NVCC73_PRECOMP_WIN_PIPE_HDR_CAPE__SIZE_1                                          32 /*       */
#define NVCC73_PRECOMP_WIN_PIPE_HDR_CAPE_CSC10_PRECISION                                 4:0 /* RWIVF */
#define NVCC73_PRECOMP_WIN_PIPE_HDR_CAPE_CSC10_UNITY_CLAMP                               5:5 /* RWIVF */
#define NVCC73_PRECOMP_WIN_PIPE_HDR_CAPE_CSC10_UNITY_CLAMP_TRUE                   0x00000001 /* RW--V */
#define NVCC73_PRECOMP_WIN_PIPE_HDR_CAPE_CSC10_UNITY_CLAMP_FALSE                  0x00000000 /* RW--V */
#define NVCC73_PRECOMP_WIN_PIPE_HDR_CAPE_CSC1LUT_FVLUT                                 13:13 /* RWIVF */
#define NVCC73_PRECOMP_WIN_PIPE_HDR_CAPE_CSC1LUT_FVLUT_TRUE                       0x00000001 /* RW--V */
#define NVCC73_PRECOMP_WIN_PIPE_HDR_CAPE_CSC1LUT_FVLUT_FALSE                      0x00000000 /* RW--V */
#define NVCC73_PRECOMP_WIN_PIPE_HDR_CAPE_CSC1LUT_DIRECT                                15:15 /* RWIVF */
#define NVCC73_PRECOMP_WIN_PIPE_HDR_CAPE_CSC1LUT_DIRECT_TRUE                      0x00000001 /* RW--V */
#define NVCC73_PRECOMP_WIN_PIPE_HDR_CAPE_CSC1LUT_DIRECT_FALSE                     0x00000000 /* RW--V */
#define NVCC73_PRECOMP_WIN_PIPE_HDR_CAPE_CSC11_PRECISION                               20:16 /* RWIVF */
#define NVCC73_PRECOMP_WIN_PIPE_HDR_CAPE_CSC11_UNITY_CLAMP                             21:21 /* RWIVF */
#define NVCC73_PRECOMP_WIN_PIPE_HDR_CAPE_CSC11_UNITY_CLAMP_TRUE                   0x00000001 /* RW--V */
#define NVCC73_PRECOMP_WIN_PIPE_HDR_CAPE_CSC11_UNITY_CLAMP_FALSE                  0x00000000 /* RW--V */
#define NVCC73_PRECOMP_WIN_PIPE_HDR_CAPF(i)                              (0x794+(i)*32) /* RW-4A */
#define NVCC73_PRECOMP_WIN_PIPE_HDR_CAPF__SIZE_1                                          32 /*       */
#define NVCC73_PRECOMP_WIN_PIPE_HDR_CAPF_VSCLR_MAX_PIXELS_2TAP                          15:0 /* RWIVF */
#define NVCC73_PRECOMP_WIN_PIPE_HDR_CAPF_VSCLR_MAX_PIXELS_5TAP                         31:16 /* RWIVF */
#define NVCC73_SOR_CLK_CAP(i)                                 (0x608+(i)*4) /* RW-4A */
#define NVCC73_SOR_CLK_CAP__SIZE_1                                             8 /*       */
#define NVCC73_SOR_CLK_CAP_DP_MAX                                            7:0 /* RWIUF */
#define NVCC73_SOR_CLK_CAP_TMDS_MAX                                        23:16 /* RWIUF */
#define NVCC73_SOR_CLK_CAP_LVDS_MAX                                        31:24 /* RWIUF */

#ifdef __cplusplus
};
#endif /* extern C */
#endif //_clcc73_h_
