/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.oid4vc.issuance.signing;

import java.time.Instant;
import java.util.Base64;
import java.util.Date;
import java.util.Objects;
import java.util.Optional;
import org.jboss.logging.Logger;
import org.keycloak.crypto.SignatureSignerContext;
import org.keycloak.models.KeycloakSession;
import org.keycloak.protocol.oid4vc.issuance.TimeProvider;
import org.keycloak.protocol.oid4vc.issuance.credentialbuilder.CredentialBody;
import org.keycloak.protocol.oid4vc.issuance.credentialbuilder.LDCredentialBody;
import org.keycloak.protocol.oid4vc.issuance.signing.AbstractCredentialSigner;
import org.keycloak.protocol.oid4vc.issuance.signing.CredentialSignerException;
import org.keycloak.protocol.oid4vc.issuance.signing.vcdm.Ed255192018Suite;
import org.keycloak.protocol.oid4vc.issuance.signing.vcdm.LinkedDataCryptographicSuite;
import org.keycloak.protocol.oid4vc.model.CredentialBuildConfig;
import org.keycloak.protocol.oid4vc.model.VerifiableCredential;
import org.keycloak.protocol.oid4vc.model.vcdm.LdProof;

public class LDCredentialSigner
extends AbstractCredentialSigner<VerifiableCredential> {
    private static final Logger LOGGER = Logger.getLogger(LDCredentialSigner.class);
    public static final String PROOF_PURPOSE_ASSERTION = "assertionMethod";
    public static final String PROOF_KEY = "proof";
    private final TimeProvider timeProvider;

    public LDCredentialSigner(KeycloakSession keycloakSession, TimeProvider timeProvider) {
        super(keycloakSession);
        this.timeProvider = timeProvider;
    }

    @Override
    public VerifiableCredential signCredential(CredentialBody credentialBody, CredentialBuildConfig credentialBuildConfig) throws CredentialSignerException {
        if (!(credentialBody instanceof LDCredentialBody)) {
            throw new CredentialSignerException("Credential body unexpectedly not of type LDCredentialBody");
        }
        LDCredentialBody ldCredentialBody = (LDCredentialBody)credentialBody;
        LOGGER.debugf("Sign credentials to ldp-vc format.", new Object[0]);
        return this.addProof(ldCredentialBody.getVerifiableCredential(), credentialBuildConfig);
    }

    private LinkedDataCryptographicSuite getLinkedDataCryptographicSuite(CredentialBuildConfig credentialBuildConfig) {
        String ldpProofType = credentialBuildConfig.getLdpProofType();
        SignatureSignerContext signer = this.getSigner(credentialBuildConfig);
        if (Objects.equals(ldpProofType, "Ed25519Signature2018")) {
            return new Ed255192018Suite(signer);
        }
        throw new CredentialSignerException(String.format("Proof Type %s is not supported.", ldpProofType));
    }

    private VerifiableCredential addProof(VerifiableCredential verifiableCredential, CredentialBuildConfig credentialBuildConfig) {
        String keyId = Optional.ofNullable(credentialBuildConfig.getOverrideKeyId()).orElse(credentialBuildConfig.getSigningKeyId());
        LinkedDataCryptographicSuite suite = this.getLinkedDataCryptographicSuite(credentialBuildConfig);
        byte[] signature = suite.getSignature(verifiableCredential);
        LdProof ldProof = new LdProof();
        ldProof.setProofPurpose(PROOF_PURPOSE_ASSERTION);
        ldProof.setType(suite.getProofType());
        ldProof.setCreated(Date.from(Instant.ofEpochSecond(this.timeProvider.currentTimeSeconds())));
        ldProof.setVerificationMethod(keyId);
        try {
            String proofValue = Base64.getUrlEncoder().encodeToString(signature);
            ldProof.setProofValue(proofValue);
            verifiableCredential.setAdditionalProperties(PROOF_KEY, ldProof);
            return verifiableCredential;
        }
        catch (IllegalArgumentException e) {
            throw new CredentialSignerException("Was not able to encode the signature.", e);
        }
    }
}

