/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.resource.jdbc.internal;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.sql.Connection;
import java.sql.SQLException;
import org.hibernate.ConnectionAcquisitionMode;
import org.hibernate.ConnectionReleaseMode;
import org.hibernate.ResourceClosedException;
import org.hibernate.engine.jdbc.JdbcLogging;
import org.hibernate.engine.jdbc.connections.spi.JdbcConnectionAccess;
import org.hibernate.engine.jdbc.spi.SqlExceptionHelper;
import org.hibernate.resource.jdbc.ResourceRegistry;
import org.hibernate.resource.jdbc.internal.AbstractLogicalConnectionImplementor;
import org.hibernate.resource.jdbc.internal.ResourceRegistryStandardImpl;
import org.hibernate.resource.jdbc.spi.JdbcEventHandler;
import org.hibernate.resource.jdbc.spi.JdbcSessionContext;
import org.hibernate.resource.jdbc.spi.JdbcSessionOwner;
import org.hibernate.resource.jdbc.spi.PhysicalConnectionHandlingMode;

public class LogicalConnectionManagedImpl
extends AbstractLogicalConnectionImplementor {
    private final transient JdbcSessionOwner jdbcSessionOwner;
    private final transient PhysicalConnectionHandlingMode connectionHandlingMode;
    private transient Connection physicalConnection;
    private boolean closed;
    boolean initiallyAutoCommit;

    public LogicalConnectionManagedImpl(JdbcSessionOwner sessionOwner, ResourceRegistry resourceRegistry) {
        this.jdbcSessionOwner = sessionOwner;
        this.resourceRegistry = resourceRegistry;
        this.connectionHandlingMode = this.determineConnectionHandlingMode(sessionOwner);
        if (this.connectionHandlingMode.getAcquisitionMode() == ConnectionAcquisitionMode.IMMEDIATELY) {
            this.acquireConnectionIfNeeded();
        }
        if (sessionOwner.getJdbcSessionContext().doesConnectionProviderDisableAutoCommit()) {
            JdbcLogging.JDBC_MESSAGE_LOGGER.connectionProviderDisablesAutoCommitEnabled();
        }
    }

    private PhysicalConnectionHandlingMode determineConnectionHandlingMode(JdbcSessionOwner sessionOwner) {
        PhysicalConnectionHandlingMode connectionHandlingMode = sessionOwner.getJdbcSessionContext().getPhysicalConnectionHandlingMode();
        return connectionHandlingMode.getReleaseMode() == ConnectionReleaseMode.AFTER_STATEMENT && !sessionOwner.getJdbcConnectionAccess().supportsAggressiveRelease() ? PhysicalConnectionHandlingMode.DELAYED_ACQUISITION_AND_RELEASE_AFTER_TRANSACTION : connectionHandlingMode;
    }

    private LogicalConnectionManagedImpl(JdbcSessionOwner owner, boolean closed) {
        this(owner, new ResourceRegistryStandardImpl());
        this.closed = closed;
    }

    private JdbcSessionContext getJdbcSessionContext() {
        return this.jdbcSessionOwner.getJdbcSessionContext();
    }

    private JdbcConnectionAccess getJdbcConnectionAccess() {
        return this.jdbcSessionOwner.getJdbcConnectionAccess();
    }

    private SqlExceptionHelper getExceptionHelper() {
        return this.jdbcSessionOwner.getSqlExceptionHelper();
    }

    private Connection acquireConnectionIfNeeded() {
        if (this.physicalConnection == null) {
            this.physicalConnection = this.acquire();
            this.afterAcquire();
        }
        return this.physicalConnection;
    }

    private void releaseConnectionIfNeeded() {
        Connection connection = this.physicalConnection;
        if (connection != null) {
            this.beforeRelease();
            this.physicalConnection = null;
            this.release(connection);
        }
    }

    @Override
    public boolean isOpen() {
        return !this.closed;
    }

    @Override
    public PhysicalConnectionHandlingMode getConnectionHandlingMode() {
        return this.connectionHandlingMode;
    }

    @Override
    public boolean isPhysicallyConnected() {
        return this.physicalConnection != null;
    }

    @Override
    public Connection getPhysicalConnection() {
        this.errorIfClosed();
        return this.acquireConnectionIfNeeded();
    }

    @Override
    public void afterStatement() {
        super.afterStatement();
        if (this.connectionHandlingMode.getReleaseMode() == ConnectionReleaseMode.AFTER_STATEMENT) {
            if (this.getResourceRegistry().hasRegisteredResources()) {
                JdbcLogging.JDBC_MESSAGE_LOGGER.skipConnectionReleaseAfterStatementDueToResources(this.hashCode());
            } else {
                JdbcLogging.JDBC_MESSAGE_LOGGER.initiatingConnectionReleaseAfterStatement(this.hashCode());
                this.releaseConnectionIfNeeded();
            }
        }
    }

    @Override
    public void beforeTransactionCompletion() {
        super.beforeTransactionCompletion();
        if (this.connectionHandlingMode.getReleaseMode() == ConnectionReleaseMode.BEFORE_TRANSACTION_COMPLETION) {
            JdbcLogging.JDBC_MESSAGE_LOGGER.initiatingConnectionReleaseBeforeTransactionCompletion(this.hashCode());
            this.releaseConnectionIfNeeded();
        }
    }

    @Override
    public void afterTransaction() {
        super.afterTransaction();
        if (this.connectionHandlingMode.getReleaseMode() != ConnectionReleaseMode.ON_CLOSE) {
            JdbcLogging.JDBC_MESSAGE_LOGGER.initiatingConnectionReleaseAfterTransaction(this.hashCode());
            this.releaseConnectionIfNeeded();
        }
    }

    @Override
    public Connection manualDisconnect() {
        if (this.closed) {
            throw new ResourceClosedException("Logical connection is closed");
        }
        Connection connection = this.physicalConnection;
        this.releaseConnectionIfNeeded();
        return connection;
    }

    @Override
    public void manualReconnect(Connection suppliedConnection) {
        if (this.closed) {
            throw new ResourceClosedException("Logical connection is closed");
        }
        throw new IllegalStateException("Cannot manually reconnect unless Connection was originally supplied by user");
    }

    private Connection acquire() {
        JdbcEventHandler eventHandler = this.getJdbcSessionContext().getEventHandler();
        eventHandler.jdbcConnectionAcquisitionStart();
        try {
            Connection connection = this.getJdbcConnectionAccess().obtainConnection();
            return connection;
        }
        catch (SQLException e) {
            throw this.getExceptionHelper().convert(e, "Unable to acquire JDBC Connection");
        }
        finally {
            eventHandler.jdbcConnectionAcquisitionEnd(this.physicalConnection);
        }
    }

    private void release(Connection connection) {
        JdbcEventHandler eventHandler = this.getJdbcSessionContext().getEventHandler();
        try {
            try {
                this.getResourceRegistry().releaseResources();
                if (!connection.isClosed()) {
                    this.getExceptionHelper().logAndClearWarnings(connection);
                }
            }
            finally {
                eventHandler.jdbcConnectionReleaseStart();
                this.getJdbcConnectionAccess().releaseConnection(connection);
            }
        }
        catch (SQLException e) {
            throw this.getExceptionHelper().convert(e, "Unable to release JDBC Connection");
        }
        finally {
            eventHandler.jdbcConnectionReleaseEnd();
        }
    }

    private void afterAcquire() {
        try {
            this.jdbcSessionOwner.afterObtainConnection(this.physicalConnection);
        }
        catch (SQLException e) {
            try {
                this.getJdbcConnectionAccess().releaseConnection(this.physicalConnection);
            }
            catch (SQLException re) {
                e.addSuppressed(re);
            }
            throw this.getExceptionHelper().convert(e, "Error after acquiring JDBC Connection");
        }
    }

    private void beforeRelease() {
        try {
            this.jdbcSessionOwner.beforeReleaseConnection(this.physicalConnection);
        }
        catch (SQLException e) {
            JdbcLogging.JDBC_MESSAGE_LOGGER.errorBeforeReleasingJdbcConnection(this.hashCode(), e);
        }
    }

    @Override
    public void serialize(ObjectOutputStream oos) throws IOException {
        oos.writeBoolean(this.closed);
    }

    public static LogicalConnectionManagedImpl deserialize(ObjectInputStream ois, JdbcSessionOwner owner) throws IOException {
        return new LogicalConnectionManagedImpl(owner, ois.readBoolean());
    }

    @Override
    public Connection close() {
        if (!this.closed) {
            this.getResourceRegistry().releaseResources();
            JdbcLogging.JDBC_MESSAGE_LOGGER.closingLogicalConnection(this.hashCode());
            try {
                this.releaseConnectionIfNeeded();
            }
            finally {
                this.closed = true;
                JdbcLogging.JDBC_MESSAGE_LOGGER.logicalConnectionClosed(this.hashCode());
            }
        }
        return null;
    }

    @Override
    protected Connection getConnectionForTransactionManagement() {
        return this.getPhysicalConnection();
    }

    @Override
    public void begin() {
        this.initiallyAutoCommit = !this.doConnectionsFromProviderHaveAutoCommitDisabled() && LogicalConnectionManagedImpl.determineInitialAutoCommitMode(this.getConnectionForTransactionManagement());
        super.begin();
    }

    @Override
    protected void afterCompletion() {
        this.resetConnection(this.initiallyAutoCommit);
        this.initiallyAutoCommit = false;
        this.afterTransaction();
    }

    @Override
    protected boolean doConnectionsFromProviderHaveAutoCommitDisabled() {
        return this.getJdbcSessionContext().doesConnectionProviderDisableAutoCommit();
    }
}

