/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.resource.beans.spi;

import java.util.Collection;
import java.util.Map;
import org.hibernate.InstantiationException;
import org.hibernate.boot.registry.StandardServiceInitiator;
import org.hibernate.boot.registry.classloading.spi.ClassLoaderService;
import org.hibernate.boot.registry.classloading.spi.ClassLoadingException;
import org.hibernate.boot.registry.selector.spi.StrategySelector;
import org.hibernate.engine.config.spi.ConfigurationService;
import org.hibernate.resource.beans.container.internal.CdiBeanContainerBuilder;
import org.hibernate.resource.beans.container.spi.BeanContainer;
import org.hibernate.resource.beans.internal.BeansMessageLogger;
import org.hibernate.resource.beans.internal.ManagedBeanRegistryImpl;
import org.hibernate.resource.beans.spi.ManagedBeanRegistry;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.service.spi.ServiceException;
import org.hibernate.service.spi.ServiceRegistryImplementor;

public class ManagedBeanRegistryInitiator
implements StandardServiceInitiator<ManagedBeanRegistry> {
    public static final ManagedBeanRegistryInitiator INSTANCE = new ManagedBeanRegistryInitiator();

    @Override
    public Class<ManagedBeanRegistry> getServiceInitiated() {
        return ManagedBeanRegistry.class;
    }

    @Override
    public ManagedBeanRegistry initiateService(Map<String, Object> configurationValues, ServiceRegistryImplementor serviceRegistry) {
        return new ManagedBeanRegistryImpl(this.resolveBeanContainer(configurationValues, serviceRegistry));
    }

    private BeanContainer resolveBeanContainer(Map<?, ?> configurationValues, ServiceRegistry serviceRegistry) {
        Object explicitBeanContainer = configurationValues.get("hibernate.resource.beans.container");
        return explicitBeanContainer == null ? ManagedBeanRegistryInitiator.interpretImplicitBeanContainer(serviceRegistry) : this.interpretExplicitBeanContainer(explicitBeanContainer, serviceRegistry);
    }

    private static BeanContainer interpretImplicitBeanContainer(ServiceRegistry serviceRegistry) {
        Collection<BeanContainer> beanContainers = serviceRegistry.requireService(ClassLoaderService.class).loadJavaServices(BeanContainer.class);
        return switch (beanContainers.size()) {
            case 1 -> beanContainers.iterator().next();
            case 0 -> ManagedBeanRegistryInitiator.interpretImplicitCdiBeanContainer(serviceRegistry);
            default -> throw new ServiceException("Multiple BeanContainer service implementations found (set 'hibernate.resource.beans.container' explicitly)");
        };
    }

    private static BeanContainer interpretImplicitCdiBeanContainer(ServiceRegistry serviceRegistry) {
        Object beanManager = ManagedBeanRegistryInitiator.getConfiguredBeanManager(serviceRegistry);
        boolean isCdiAvailable = ManagedBeanRegistryInitiator.isCdiAvailable(serviceRegistry);
        if (beanManager != null) {
            if (!isCdiAvailable) {
                throw new ServiceException("A bean manager was provided via 'jakarta.persistence.bean.manager' but CDI is not available on the Hibernate class loader");
            }
            return CdiBeanContainerBuilder.fromBeanManagerReference(beanManager, serviceRegistry);
        }
        if (isCdiAvailable) {
            BeansMessageLogger.BEANS_MSG_LOGGER.noBeanManagerButCdiAvailable();
        }
        return null;
    }

    private static Object getConfiguredBeanManager(ServiceRegistry serviceRegistry) {
        Map<String, Object> settings = serviceRegistry.requireService(ConfigurationService.class).getSettings();
        Object beanManager = settings.get("jakarta.persistence.bean.manager");
        return beanManager != null ? beanManager : settings.get("javax.persistence.bean.manager");
    }

    private BeanContainer interpretExplicitBeanContainer(Object explicitSetting, ServiceRegistry serviceRegistry) {
        if (explicitSetting == null) {
            return null;
        }
        if (explicitSetting instanceof BeanContainer) {
            BeanContainer beanContainer = (BeanContainer)explicitSetting;
            return beanContainer;
        }
        Class<?> containerClass = ManagedBeanRegistryInitiator.containerClass(explicitSetting, serviceRegistry);
        try {
            return (BeanContainer)containerClass.newInstance();
        }
        catch (Exception e) {
            throw new InstantiationException("Unable to instantiate specified BeanContainer", containerClass, e);
        }
    }

    private static Class<?> containerClass(Object explicitSetting, ServiceRegistry serviceRegistry) {
        if (explicitSetting instanceof Class) {
            Class clazz = (Class)explicitSetting;
            return clazz;
        }
        String name = explicitSetting.toString();
        Class<BeanContainer> selected = serviceRegistry.requireService(StrategySelector.class).selectStrategyImplementor(BeanContainer.class, name);
        return selected == null ? serviceRegistry.requireService(ClassLoaderService.class).classForName(name) : selected;
    }

    private static boolean isCdiAvailable(ServiceRegistry serviceRegistry) {
        try {
            serviceRegistry.requireService(ClassLoaderService.class).classForName("jakarta.enterprise.inject.spi.BeanManager");
            return true;
        }
        catch (ClassLoadingException e) {
            return false;
        }
    }
}

