/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.util.Disposer;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.impl.JavaPsiFacadeEx;
import com.intellij.testFramework.IdeaTestUtil;
import com.intellij.testFramework.LightPlatformCodeInsightTestCase;
import com.intellij.testFramework.LightPlatformTestCase;
import com.intellij.testFramework.LightProjectDescriptor;
import com.intellij.testFramework.TestDataPath;
import com.intellij.testFramework.fixtures.DefaultLightProjectDescriptor;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

@TestDataPath(value="$CONTENT_ROOT/testData")
public abstract class LightJavaCodeInsightTestCase
extends LightPlatformCodeInsightTestCase {
    private static final Pattern JDK_SELECT_PATTERN = Pattern.compile("Java([\\d.]+)(Preview)?(\\.java)?$");
    private final Disposable myBeforeParentDisposeDisposable = Disposer.newDisposable();

    public JavaPsiFacadeEx getJavaFacade() {
        return JavaPsiFacadeEx.getInstanceEx((Project)this.getProject());
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.setLanguageLevel(this.getLanguageLevel());
    }

    @Override
    protected void tearDown() throws Exception {
        try {
            Disposer.dispose((Disposable)this.myBeforeParentDisposeDisposable);
        }
        catch (Throwable e) {
            this.addSuppressedException(e);
        }
        finally {
            super.tearDown();
        }
    }

    protected LanguageLevel getLanguageLevel() {
        LanguageLevel level;
        Matcher matcher = JDK_SELECT_PATTERN.matcher(this.getTestName(false));
        if (matcher.find() && (level = LanguageLevel.parse((String)matcher.group(1))) != null) {
            String group = matcher.group(2);
            if (group != null) {
                level = LanguageLevel.valueOf((String)(String.valueOf(level) + "_PREVIEW"));
            }
            return level;
        }
        return this.getDefaultLanguageLevel();
    }

    protected LanguageLevel getDefaultLanguageLevel() {
        return LanguageLevel.HIGHEST;
    }

    protected void setLanguageLevel(@NotNull LanguageLevel level) {
        if (level == null) {
            LightJavaCodeInsightTestCase.$$$reportNull$$$0(0);
        }
        IdeaTestUtil.setProjectLanguageLevel(this.getProject(), level, this.myBeforeParentDisposeDisposable);
    }

    @Override
    protected Sdk getProjectJDK() {
        return IdeaTestUtil.getMockJdk18();
    }

    @Override
    @NotNull
    protected LightProjectDescriptor getProjectDescriptor() {
        final LanguageLevel languageLevel = this.getLanguageLevel();
        return new LightPlatformTestCase.SimpleLightProjectDescriptor(this.getModuleTypeId(), this.getProjectJDK()){

            @Override
            protected void configureModule(@NotNull Module module2, @NotNull ModifiableRootModel model, @NotNull ContentEntry contentEntry) {
                if (module2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (model == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (contentEntry == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (languageLevel.isAtLeast(LanguageLevel.JDK_1_8)) {
                    DefaultLightProjectDescriptor.addJetBrainsAnnotationsWithTypeUse(model);
                } else {
                    DefaultLightProjectDescriptor.addJetBrainsAnnotations(model);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "module";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "model";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[0] = "contentEntry";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/testFramework/LightJavaCodeInsightTestCase$1";
                objectArray[2] = "configureModule";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    @Override
    @NotNull
    protected String getModuleTypeId() {
        return "JAVA_MODULE";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "level", "com/intellij/testFramework/LightJavaCodeInsightTestCase", "setLanguageLevel"));
    }
}

