/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.maven.server.m40.utils;

import com.intellij.maven.server.m40.utils.Maven40TransferListenerAdapter;
import com.intellij.maven.server.m40.utils.Maven40WorkspaceMapReader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.function.Consumer;
import org.apache.maven.execution.MavenExecutionRequest;
import org.apache.maven.resolver.RepositorySystemSessionFactory;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.repository.WorkspaceReader;
import org.eclipse.aether.transfer.TransferListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.model.MavenWorkspaceMap;
import org.jetbrains.idea.maven.server.MavenServerConsoleIndicatorImpl;

public class Maven40RepositorySystemSessionFactory
implements RepositorySystemSessionFactory {
    private final RepositorySystemSessionFactory mySystemSessionFactory;
    private final MavenWorkspaceMap myWorkspaceMap;
    private final MavenServerConsoleIndicatorImpl myIndicator;
    private final Consumer<RepositorySystemSession.SessionBuilder> myModifier;

    public Maven40RepositorySystemSessionFactory(RepositorySystemSessionFactory systemSessionFactory, MavenWorkspaceMap map, MavenServerConsoleIndicatorImpl indicator, @NotNull Consumer<RepositorySystemSession.SessionBuilder> builderModifier) {
        if (builderModifier == null) {
            Maven40RepositorySystemSessionFactory.$$$reportNull$$$0(0);
        }
        this.mySystemSessionFactory = systemSessionFactory;
        this.myWorkspaceMap = map;
        this.myIndicator = indicator;
        this.myModifier = builderModifier;
    }

    public RepositorySystemSession.SessionBuilder newRepositorySessionBuilder(MavenExecutionRequest request) {
        RepositorySystemSession.SessionBuilder builder = this.mySystemSessionFactory.newRepositorySessionBuilder(request);
        builder.setWorkspaceReader((WorkspaceReader)new Maven40WorkspaceMapReader(this.myWorkspaceMap)).setTransferListener((TransferListener)new Maven40TransferListenerAdapter(this.myIndicator)).setConfigProperty("aether.conflictResolver.verbose", (Object)true).setConfigProperty("aether.dependencyManager.verbose", (Object)true).setConfigProperty("aether.transport.http.userAgent", (Object)this.getUserAgent(builder));
        this.myModifier.accept(builder);
        return builder;
    }

    private String getUserAgent(RepositorySystemSession.SessionBuilder builder) {
        String mavenUA = this.tryToGetMavenUserAgent();
        String version = System.getProperty("idea.version");
        StringBuilder result = new StringBuilder();
        if (mavenUA != null) {
            result.append(mavenUA).append(";");
        }
        if (version != null) {
            result.append("Intellij IDEA (").append(version).append(")");
        } else {
            result.append("Intellij IDEA");
        }
        return result.toString();
    }

    @Nullable
    private String tryToGetMavenUserAgent() {
        try {
            Method m = this.mySystemSessionFactory.getClass().getDeclaredMethod("getUserAgent", new Class[0]);
            m.setAccessible(true);
            Object invoke = m.invoke((Object)this.mySystemSessionFactory, new Object[0]);
            if (invoke instanceof String) {
                return (String)invoke;
            }
            return null;
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException ignore) {
            return null;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builderModifier", "com/intellij/maven/server/m40/utils/Maven40RepositorySystemSessionFactory", "<init>"));
    }
}

