/*
 * Decompiled with CFR 0.152.
 */
package git4idea.util;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.SimpleListCellRenderer;
import git4idea.GitLocalBranch;
import git4idea.GitUtil;
import git4idea.i18n.GitBundle;
import git4idea.repo.GitRepository;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GitUIUtil {
    private GitUIUtil() {
    }

    public static JTextField getTextField(JComboBox comboBox) {
        return (JTextField)comboBox.getEditor().getEditorComponent();
    }

    public static void setupRootChooser(final @NotNull Project project, @NotNull List<? extends VirtualFile> roots, @Nullable VirtualFile defaultRoot, final @NotNull JComboBox gitRootChooser, final @Nullable JLabel currentBranchLabel) {
        if (project == null) {
            GitUIUtil.$$$reportNull$$$0(0);
        }
        if (roots == null) {
            GitUIUtil.$$$reportNull$$$0(1);
        }
        if (gitRootChooser == null) {
            GitUIUtil.$$$reportNull$$$0(2);
        }
        for (VirtualFile virtualFile : roots) {
            gitRootChooser.addItem(virtualFile);
        }
        gitRootChooser.setRenderer(SimpleListCellRenderer.create((String)GitBundle.message("combobox.item.file.invalid", new Object[0]), VirtualFile::getPresentableUrl));
        gitRootChooser.setSelectedItem(defaultRoot != null ? defaultRoot : roots.get(0));
        if (currentBranchLabel != null) {
            ActionListener listener2 = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    VirtualFile root = (VirtualFile)gitRootChooser.getSelectedItem();
                    assert (root != null) : "The root must not be null";
                    GitRepository repo2 = (GitRepository)GitUtil.getRepositoryManager(project).getRepositoryForRootQuick(root);
                    assert (repo2 != null) : "The repository must not be null";
                    GitLocalBranch current = repo2.getCurrentBranch();
                    if (current == null) {
                        currentBranchLabel.setText(GitUIUtil.getNoCurrentBranch());
                    } else {
                        currentBranchLabel.setText(current.getName());
                    }
                }
            };
            listener2.actionPerformed(null);
            gitRootChooser.addActionListener(listener2);
        }
    }

    public static void showOperationError(Project project, VcsException ex, @Nls @NotNull String operation) {
        if (operation == null) {
            GitUIUtil.$$$reportNull$$$0(3);
        }
        GitUIUtil.showOperationError(project, operation, ex.getMessage());
    }

    public static void showOperationErrors(Project project, Collection<? extends VcsException> exs, @Nls @NotNull String operation) {
        if (operation == null) {
            GitUIUtil.$$$reportNull$$$0(4);
        }
        if (exs.size() == 1) {
            GitUIUtil.showOperationError(project, operation, exs.iterator().next().getMessage());
        } else if (exs.size() > 1) {
            StringBuilder b = new StringBuilder();
            for (VcsException vcsException : exs) {
                b.append(GitBundle.message("errors.message.item", vcsException.getMessage()));
            }
            GitUIUtil.showOperationError(project, operation, GitBundle.message("errors.message", b.toString()));
        }
    }

    public static void showOperationError(Project project, String operation, @Nls String message) {
        Messages.showErrorDialog((Project)project, (String)message, (String)GitBundle.message("error.occurred.during", operation));
    }

    public static void exclusive(final JCheckBox first, final boolean firstState, final JCheckBox second, final boolean secondState) {
        ActionListener l = new ActionListener(){

            private static void check(JCheckBox checked, boolean checkedState, JCheckBox changed, boolean impliedState) {
                if (checked.isSelected() == checkedState) {
                    changed.setSelected(impliedState);
                    changed.setEnabled(false);
                } else {
                    changed.setEnabled(true);
                }
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                2.check(first, firstState, second, !secondState);
                2.check(second, secondState, first, !firstState);
            }
        };
        first.addActionListener(l);
        second.addActionListener(l);
        l.actionPerformed(null);
    }

    public static String bold(String s) {
        return GitUIUtil.surround(s, "b");
    }

    public static String code(String s) {
        return GitUIUtil.surround(s, "code");
    }

    private static String surround(String s, String tag) {
        return String.format("<%2$s>%1$s</%2$s>", s, tag);
    }

    @Nls
    public static String getNoCurrentBranch() {
        return GitBundle.message("common.no.active.branch", new Object[0]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "roots";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gitRootChooser";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "operation";
                break;
            }
        }
        objectArray2[1] = "git4idea/util/GitUIUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "setupRootChooser";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "showOperationError";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "showOperationErrors";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

