/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.plugin.codeexplorer.map;

import java.awt.event.ActionEvent;
import java.util.Set;
import org.freeplane.core.ui.AFreeplaneAction;
import org.freeplane.core.ui.components.UITools;
import org.freeplane.core.util.TextUtils;
import org.freeplane.features.map.IMapSelection;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.mode.Controller;
import org.freeplane.plugin.codeexplorer.map.CodeNode;
import org.freeplane.plugin.codeexplorer.map.SelectedNodeDependencies;

class SelectCyclesAction
extends AFreeplaneAction {
    public SelectCyclesAction() {
        super("code.SelectCyclesAction");
    }

    public void actionPerformed(ActionEvent e) {
        IMapSelection selection = Controller.getCurrentController().getSelection();
        CodeNode node = (CodeNode)selection.getSelected();
        Set<CodeNode> cycleNodes = node.findCyclicDependencies();
        if (!cycleNodes.isEmpty()) {
            SelectedNodeDependencies selectedNodeDependencies = new SelectedNodeDependencies(selection);
            NodeModel[] newSelection = (CodeNode[])cycleNodes.stream().map(selectedNodeDependencies::findVisibleAncestorOrSelf).toArray(CodeNode[]::new);
            selection.replaceSelection(newSelection);
        } else {
            UITools.informationMessage((Object)TextUtils.getRawText((String)"code.no_cycles_found"));
        }
    }
}

