/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.impl;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.connection.DBPConnectionBootstrap;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.DBCExecutionContextDefaults;
import org.jkiss.dbeaver.model.exec.DBCExecutionPurpose;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.DBCStatement;
import org.jkiss.dbeaver.model.exec.DBCStatementType;
import org.jkiss.dbeaver.model.qm.QMUtils;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSInstance;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.utils.CommonUtils;

public abstract class AbstractExecutionContext<DATASOURCE extends DBPDataSource, INSTANCE extends DBSInstance>
implements DBCExecutionContext {
    private static final Log log = Log.getLog(AbstractExecutionContext.class);
    private static long idSequence = 0L;
    @NotNull
    protected INSTANCE instance;
    @NotNull
    protected final DATASOURCE dataSource;
    protected final String purpose;
    protected final long id;
    private final Map<String, Object> contextAttributes = new LinkedHashMap<String, Object>();

    public AbstractExecutionContext(@NotNull INSTANCE instance, String purpose) {
        this.instance = instance;
        this.dataSource = instance.getDataSource();
        this.purpose = purpose;
        this.id = AbstractExecutionContext.generateContextId();
        log.debug("Execution context opened (" + this.dataSource.getName() + "; " + purpose + "; " + this.id + ")");
        QMUtils.getDefaultHandler().handleContextOpen(this, false);
    }

    public static synchronized long generateContextId() {
        return idSequence++;
    }

    @NotNull
    public INSTANCE getOwnerInstance() {
        return this.instance;
    }

    protected void setOwnerInstance(@NotNull INSTANCE instance) {
        this.instance = instance;
    }

    @Override
    public long getContextId() {
        return this.id;
    }

    @Override
    @NotNull
    public String getContextName() {
        return this.purpose;
    }

    @NotNull
    public DATASOURCE getDataSource() {
        return this.dataSource;
    }

    @Override
    @Nullable
    public DBCExecutionContextDefaults getContextDefaults() {
        return null;
    }

    @NotNull
    protected DBPConnectionBootstrap getBootstrapSettings() {
        return this.getDataSource().getContainer().getActualConnectionConfiguration().getBootstrap();
    }

    protected boolean initContextBootstrap(@NotNull DBRProgressMonitor monitor, boolean autoCommit) throws DBException {
        QMUtils.getDefaultHandler().handleContextUpdate(this, !autoCommit);
        DBPConnectionBootstrap bootstrap = this.getBootstrapSettings();
        List<String> initQueries = bootstrap.getInitQueries();
        if (!CommonUtils.isEmpty(initQueries)) {
            monitor.subTask("Run bootstrap queries");
            Throwable throwable = null;
            Object var6_7 = null;
            try (DBCSession session = this.openSession(monitor, DBCExecutionPurpose.UTIL, "Run bootstrap queries");){
                for (String query : initQueries) {
                    query = GeneralUtils.replaceVariables(query, this.getDataSource().getContainer().getVariablesResolver(true));
                    try {
                        Throwable throwable2 = null;
                        Object var11_15 = null;
                        try (DBCStatement dbStat = session.prepareStatement(DBCStatementType.SCRIPT, query, false, false, false);){
                            dbStat.executeStatement();
                        }
                        catch (Throwable throwable3) {
                            if (throwable2 == null) {
                                throwable2 = throwable3;
                            } else if (throwable2 != throwable3) {
                                throwable2.addSuppressed(throwable3);
                            }
                            throw throwable2;
                        }
                    }
                    catch (Exception e) {
                        String message = "Error executing bootstrap query: " + query;
                        if (bootstrap.isIgnoreErrors()) {
                            log.warn(message);
                            continue;
                        }
                        throw new DBCException(message, (Throwable)e, this);
                    }
                }
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
            return true;
        }
        return false;
    }

    protected void closeContext() {
        QMUtils.getDefaultHandler().handleContextClose(this);
        log.debug("Execution context closed (" + this.dataSource.getName() + ", " + this.id + ")");
    }

    @Override
    @NotNull
    public Map<String, ?> getContextAttributes() {
        return new LinkedHashMap<String, Object>(this.contextAttributes);
    }

    @Override
    public <T> T getContextAttribute(@NotNull String attributeName) {
        return (T)this.contextAttributes.get(attributeName);
    }

    @Override
    public <T> void setContextAttribute(@NotNull String attributeName, @Nullable T attributeValue) {
        this.contextAttributes.put(attributeName, attributeValue);
    }

    @Override
    public void removeContextAttribute(@NotNull String attributeName) {
        this.contextAttributes.remove(attributeName);
    }

    public String toString() {
        return this.dataSource.getName() + " - " + this.purpose;
    }
}

