/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.db2.model.security;

import java.sql.ResultSet;
import java.sql.SQLException;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.db2.model.DB2DataSource;
import org.jkiss.dbeaver.ext.db2.model.security.DB2AuthIDType;
import org.jkiss.dbeaver.ext.db2.model.security.DB2Grantee;
import org.jkiss.dbeaver.ext.db2.model.security.DB2Group;
import org.jkiss.dbeaver.ext.db2.model.security.DB2User;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCStatement;
import org.jkiss.dbeaver.model.impl.jdbc.cache.JDBCObjectCache;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;

public final class DB2GranteeCache
extends JDBCObjectCache<DB2DataSource, DB2Grantee> {
    private DB2AuthIDType authIdType;
    private String authIdTypeName;

    public DB2GranteeCache(DB2AuthIDType authIdType) {
        this.authIdType = authIdType;
        this.authIdTypeName = authIdType.name();
    }

    @NotNull
    protected JDBCStatement prepareObjectsStatement(@NotNull JDBCSession session, @NotNull DB2DataSource db2DataSource) throws SQLException {
        JDBCPreparedStatement dbStat = session.prepareStatement(this.getSQLStatement(db2DataSource));
        dbStat.setString(1, this.authIdTypeName);
        dbStat.setString(2, this.authIdTypeName);
        dbStat.setString(3, this.authIdTypeName);
        dbStat.setString(4, this.authIdTypeName);
        dbStat.setString(5, this.authIdTypeName);
        dbStat.setString(6, this.authIdTypeName);
        dbStat.setString(7, this.authIdTypeName);
        dbStat.setString(8, this.authIdTypeName);
        dbStat.setString(9, this.authIdTypeName);
        dbStat.setString(10, this.authIdTypeName);
        if (db2DataSource.isAtLeastV9_5()) {
            dbStat.setString(11, this.authIdTypeName);
        }
        if (db2DataSource.isAtLeastV9_7()) {
            dbStat.setString(12, this.authIdTypeName);
        }
        return dbStat;
    }

    protected DB2Grantee fetchObject(@NotNull JDBCSession session, @NotNull DB2DataSource db2DataSource, @NotNull JDBCResultSet resultSet) throws SQLException, DBException {
        DBRProgressMonitor monitor = session.getProgressMonitor();
        switch (this.authIdType) {
            case G: {
                return new DB2Group(monitor, db2DataSource, (ResultSet)resultSet);
            }
            case U: {
                return new DB2User(monitor, db2DataSource, (ResultSet)resultSet);
            }
        }
        throw new DBException("Structural problem. " + String.valueOf((Object)this.authIdType) + " type not implemented");
    }

    private String getSQLStatement(DB2DataSource db2DataSource) {
        StringBuilder sb = new StringBuilder(1536);
        sb.append("SELECT DISTINCT GRANTEE");
        sb.append("  FROM SYSCAT.TABAUTH");
        sb.append(" WHERE GRANTEETYPE = ?");
        sb.append(" UNION ");
        sb.append("SELECT DISTINCT GRANTEE");
        sb.append("  FROM SYSCAT.INDEXAUTH");
        sb.append(" WHERE GRANTEETYPE = ?");
        sb.append(" UNION ");
        sb.append("SELECT DISTINCT GRANTEE");
        sb.append("  FROM SYSCAT.SEQUENCEAUTH");
        sb.append(" WHERE GRANTEETYPE = ?");
        sb.append(" UNION ");
        sb.append("SELECT DISTINCT GRANTEE");
        sb.append("  FROM SYSCAT.TBSPACEAUTH");
        sb.append(" WHERE GRANTEETYPE = ?");
        sb.append(" UNION ");
        sb.append("SELECT DISTINCT GRANTEE");
        sb.append("  FROM SYSCAT.SCHEMAAUTH");
        sb.append(" WHERE GRANTEETYPE = ?");
        sb.append(" UNION ");
        sb.append("SELECT DISTINCT GRANTEE");
        sb.append("  FROM SYSCAT.PACKAGEAUTH");
        sb.append(" WHERE GRANTEETYPE = ?");
        sb.append(" UNION ");
        sb.append("SELECT DISTINCT GRANTEE");
        sb.append("  FROM SYSCAT.COLAUTH");
        sb.append(" WHERE GRANTEETYPE = ?");
        sb.append(" UNION ");
        sb.append("SELECT DISTINCT GRANTEE");
        sb.append("  FROM SYSCAT.ROUTINEAUTH");
        sb.append(" WHERE GRANTEETYPE = ?");
        sb.append(" UNION ");
        sb.append("SELECT DISTINCT GRANTEE");
        sb.append("  FROM SYSCAT.DBAUTH");
        sb.append(" WHERE GRANTEETYPE = ?");
        sb.append(" UNION ");
        sb.append("SELECT DISTINCT GRANTEE");
        sb.append("  FROM SYSCAT.XSROBJECTAUTH");
        sb.append(" WHERE GRANTEETYPE = ?");
        if (db2DataSource.isAtLeastV9_5()) {
            sb.append(" UNION ");
            sb.append("SELECT DISTINCT GRANTEE");
            sb.append("  FROM SYSCAT.ROLEAUTH");
            sb.append(" WHERE GRANTEETYPE = ?");
        }
        if (db2DataSource.isAtLeastV9_7()) {
            sb.append(" UNION ");
            sb.append("SELECT DISTINCT GRANTEE");
            sb.append("  FROM SYSCAT.MODULEAUTH");
            sb.append(" WHERE GRANTEETYPE = ?");
        }
        sb.append(" ORDER BY GRANTEE");
        sb.append(" WITH UR");
        return sb.toString();
    }
}

