/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.scan;

import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.zaproxy.zap.scan.ScanStartOptions;

public abstract class BaseScannerThread<StartOptions extends ScanStartOptions>
extends Thread {
    private StartOptions startOptions;
    private int progress = 0;
    private int maximumProgress = 100;
    private boolean paused;
    private boolean running;
    private ReentrantLock pauseLock = new ReentrantLock();
    private Condition pausedCondition = this.pauseLock.newCondition();

    public StartOptions getStartOptions() {
        return this.startOptions;
    }

    public void setStartOptions(StartOptions startOptions) {
        this.startOptions = startOptions;
    }

    public int getScanProgress() {
        return this.progress;
    }

    public void setScanProgress(int progress) {
        this.progress = progress;
    }

    public void setScanMaximumProgress(int maximumProgress) {
        this.maximumProgress = maximumProgress;
    }

    public int getScanMaximumProgress() {
        return this.maximumProgress;
    }

    public boolean isPaused() {
        return this.paused;
    }

    public boolean isRunning() {
        return this.running;
    }

    public void setPaused(boolean paused) {
        this.pauseLock.lock();
        this.paused = paused;
        if (!this.paused) {
            this.pausedCondition.signalAll();
        }
        this.pauseLock.unlock();
    }

    protected void checkPausedAndWait() {
        this.pauseLock.lock();
        while (this.paused) {
            try {
                this.pausedCondition.await();
            }
            catch (InterruptedException interruptedException) {}
        }
        this.pauseLock.unlock();
    }

    public void setRunningState(boolean running) {
        this.running = running;
    }

    public boolean hasRun() {
        return this.getState() != Thread.State.NEW;
    }

    @Override
    public void run() {
        this.startScan();
    }

    public void pauseScan() {
        this.setPaused(true);
    }

    public void resumeScan() {
        this.setPaused(false);
    }

    public void stopScan() {
        this.setPaused(false);
        this.setRunningState(false);
    }

    public void startScan() {
        this.setRunningState(true);
        this.scan();
    }

    @Override
    public synchronized void start() {
        if (this.startOptions == null) {
            throw new IllegalStateException("No scan start options have been set for the Scanner thread.");
        }
        super.start();
    }

    protected abstract void scan();
}

