/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.analytics.function.reduction;

import java.util.function.UnaryOperator;
import org.apache.solr.analytics.ExpressionFactory;
import org.apache.solr.analytics.function.ReductionFunction;
import org.apache.solr.analytics.function.reduction.data.ReductionDataCollector;
import org.apache.solr.analytics.function.reduction.data.SumCollector;
import org.apache.solr.analytics.value.AnalyticsValueStream;
import org.apache.solr.analytics.value.DoubleValue;
import org.apache.solr.analytics.value.DoubleValueStream;
import org.apache.solr.common.SolrException;

public class SumFunction
extends DoubleValue.AbstractDoubleValue
implements ReductionFunction {
    private SumCollector collector;
    public static final String name = "sum";
    private final String exprStr;
    public static final ExpressionFactory.CreatorFunction creatorFunction = params -> {
        DoubleValueStream casted;
        if (params.length != 1) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "The sum function requires 1 paramater, " + params.length + " found.");
        }
        try {
            casted = (DoubleValueStream)params[0];
        }
        catch (ClassCastException e) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "The sum function requires numeric parameter. Incorrect parameter: " + params[0].getExpressionStr());
        }
        return new SumFunction(casted);
    };

    public SumFunction(DoubleValueStream param) {
        this.collector = new SumCollector(param);
        this.exprStr = AnalyticsValueStream.createExpressionString(name, param);
    }

    @Override
    public double getDouble() {
        return this.collector.sum();
    }

    @Override
    public boolean exists() {
        return this.collector.exists();
    }

    @Override
    public void synchronizeDataCollectors(UnaryOperator<ReductionDataCollector<?>> sync) {
        this.collector = (SumCollector)sync.apply(this.collector);
    }

    @Override
    public String getExpressionStr() {
        return this.exprStr;
    }

    @Override
    public String getName() {
        return name;
    }

    @Override
    public AnalyticsValueStream.ExpressionType getExpressionType() {
        return AnalyticsValueStream.ExpressionType.REDUCTION;
    }
}

