/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.common.luke;

public enum FieldFlag {
    INDEXED('I', "Indexed"),
    TOKENIZED('T', "Tokenized"),
    STORED('S', "Stored"),
    DOC_VALUES('D', "DocValues"),
    UNINVERTIBLE('U', "UnInvertible"),
    MULTI_VALUED('M', "Multivalued"),
    TERM_VECTOR_STORED('V', "TermVector Stored"),
    TERM_VECTOR_OFFSET('o', "Store Offset With TermVector"),
    TERM_VECTOR_POSITION('p', "Store Position With TermVector"),
    TERM_VECTOR_PAYLOADS('y', "Store Payloads With TermVector"),
    OMIT_NORMS('O', "Omit Norms"),
    OMIT_TF('F', "Omit Term Frequencies & Positions"),
    OMIT_POSITIONS('P', "Omit Positions"),
    STORE_OFFSETS_WITH_POSITIONS('H', "Store Offsets with Positions"),
    LAZY('L', "Lazy"),
    BINARY('B', "Binary"),
    SORT_MISSING_FIRST('f', "Sort Missing First"),
    SORT_MISSING_LAST('l', "Sort Missing Last");

    private final char abbreviation;
    private final String display;

    private FieldFlag(char abbreviation, String display) {
        this.abbreviation = abbreviation;
        this.display = display.intern();
    }

    public static FieldFlag getFlag(char abbrev) {
        FieldFlag result = null;
        FieldFlag[] vals = FieldFlag.values();
        for (int i = 0; i < vals.length; ++i) {
            if (vals[i].getAbbreviation() != abbrev) continue;
            result = vals[i];
            break;
        }
        return result;
    }

    public char getAbbreviation() {
        return this.abbreviation;
    }

    public String getDisplay() {
        return this.display;
    }

    public String toString() {
        return this.abbreviation + " - " + this.display;
    }
}

