/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.crossdc.common;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.solr.common.util.CollectionUtil;
import org.apache.solr.crossdc.common.ConfigProperty;
import org.apache.solr.crossdc.common.CrossDcConf;
import org.apache.solr.crossdc.common.SensitivePropRedactionUtils;

public class KafkaCrossDcConf
extends CrossDcConf {
    public static final String DEFAULT_BATCH_SIZE_BYTES = "2097152";
    public static final String DEFAULT_BUFFER_MEMORY_BYTES = "536870912";
    public static final String DEFAULT_LINGER_MS = "30";
    public static final String DEFAULT_REQUEST_TIMEOUT = "60000";
    public static final String DEFAULT_MAX_REQUEST_SIZE = "5242880";
    public static final String DEFAULT_ENABLE_DATA_COMPRESSION = "none";
    private static final String DEFAULT_INDEX_UNMIRRORABLE_DOCS = "false";
    public static final String DEFAULT_SLOW_SEND_THRESHOLD = "1000";
    public static final String DEFAULT_NUM_RETRIES = null;
    private static final String DEFAULT_RETRY_BACKOFF_MS = "500";
    private static final String DEFAULT_CONSUMER_PROCESSING_THREADS = "5";
    private static final String DEFAULT_DELIVERY_TIMEOUT_MS = "120000";
    public static final String DEFAULT_MAX_POLL_RECORDS = "500";
    private static final String DEFAULT_FETCH_MIN_BYTES = "1";
    private static final String DEFAULT_FETCH_MAX_WAIT_MS = "500";
    public static final String DEFAULT_FETCH_MAX_BYTES = "100663296";
    public static final String DEFAULT_MAX_PARTITION_FETCH_BYTES = "1048576";
    public static final String DEFAULT_MAX_POLL_INTERVAL_MS = "90000";
    public static final String DEFAULT_SESSION_TIMEOUT_MS = "10000";
    public static final String DEFAULT_PORT = "8090";
    private static final String DEFAULT_GROUP_ID = "SolrCrossDCManager";
    private static final String DEFAULT_MIRROR_COLLECTIONS = "";
    private static final String DEFAULT_MIRROR_COMMITS = "false";
    private static final String DEFAULT_EXPAND_DBQ = CrossDcConf.ExpandDbq.EXPAND.name();
    private static final String DEFAULT_COLLAPSE_UPDATES = CrossDcConf.CollapseUpdates.PARTIAL.name();
    private static final String DEFAULT_MAX_COLLAPSE_RECORDS = "500";
    public static final String TOPIC_NAME = "solr.crossdc.topicName";
    public static final String DLQ_TOPIC_NAME = "solr.crossdc.dlqTopicName";
    public static final String MAX_ATTEMPTS = "solr.crossdc.maxAttempts";
    public static final String BOOTSTRAP_SERVERS = "solr.crossdc.bootstrapServers";
    public static final String BATCH_SIZE_BYTES = "solr.crossdc.batchSizeBytes";
    public static final String BUFFER_MEMORY_BYTES = "solr.crossdc.bufferMemoryBytes";
    public static final String LINGER_MS = "solr.crossdc.lingerMs";
    public static final String REQUEST_TIMEOUT_MS = "solr.crossdc.requestTimeoutMS";
    public static final String MAX_REQUEST_SIZE_BYTES = "solr.crossdc.maxRequestSizeBytes";
    public static final String ENABLE_DATA_COMPRESSION = "solr.crossdc.enableDataCompression";
    public static final String INDEX_UNMIRRORABLE_DOCS = "solr.crossdc.indexUnmirrorableDocs";
    public static final String SLOW_SUBMIT_THRESHOLD_MS = "solr.crossdc.slowSubmitThresholdMs";
    public static final String NUM_RETRIES = "solr.crossdc.numRetries";
    public static final String RETRY_BACKOFF_MS = "solr.crossdc.retryBackoffMs";
    public static final String CONSUMER_PROCESSING_THREADS = "solr.crossdc.consumerProcessingThreads";
    public static final String DELIVERY_TIMEOUT_MS = "solr.crossdc.deliveryTimeoutMS";
    public static final String FETCH_MIN_BYTES = "solr.crossdc.fetchMinBytes";
    public static final String FETCH_MAX_WAIT_MS = "solr.crossdc.fetchMaxWaitMS";
    public static final String MAX_POLL_RECORDS = "solr.crossdc.maxPollRecords";
    public static final String FETCH_MAX_BYTES = "solr.crossdc.fetchMaxBytes";
    public static final String MAX_POLL_INTERVAL_MS = "solr.crossdc.maxPollIntervalMs";
    public static final String SESSION_TIMEOUT_MS = "solr.crossdc.sessionTimeoutMs";
    public static final String MAX_PARTITION_FETCH_BYTES = "solr.crossdc.maxPartitionFetchBytes";
    public static final String ZK_CONNECT_STRING = "solr.crossdc.zkConnectString";
    public static final String MIRROR_COLLECTIONS = "solr.crossdc.mirrorCollections";
    public static final String MIRROR_COMMITS = "solr.crossdc.mirrorCommits";
    public static final List<ConfigProperty> CONFIG_PROPERTIES;
    private static final Map<String, ConfigProperty> CONFIG_PROPERTIES_MAP;
    public static final List<ConfigProperty> SECURITY_CONFIG_PROPERTIES;
    public static final String PORT = "solr.crossdc.manager.port";
    public static final String GROUP_ID = "solr.crossdc.groupId";
    private final Map<String, Object> properties;

    public KafkaCrossDcConf(Map<String, Object> properties) {
        ArrayList nullValueKeys = new ArrayList();
        properties.forEach((k, v) -> {
            if (v == null) {
                nullValueKeys.add(k);
            }
        });
        nullValueKeys.forEach(properties::remove);
        this.properties = properties;
    }

    public static void addSecurityProps(KafkaCrossDcConf conf, Properties kafkaConsumerProps) {
        for (ConfigProperty property : SECURITY_CONFIG_PROPERTIES) {
            String val = conf.get(property.getKey());
            if (val == null) continue;
            kafkaConsumerProps.put(property.getKey(), val);
        }
    }

    public String get(String property) {
        return CONFIG_PROPERTIES_MAP.get(property).getValue(this.properties);
    }

    public Integer getInt(String property) {
        ConfigProperty prop = CONFIG_PROPERTIES_MAP.get(property);
        if (prop == null) {
            throw new IllegalArgumentException("Property not found key=" + property);
        }
        return prop.getValueAsInt(this.properties);
    }

    public Boolean getBool(String property) {
        ConfigProperty prop = CONFIG_PROPERTIES_MAP.get(property);
        if (prop == null) {
            throw new IllegalArgumentException("Property not found key=" + property);
        }
        return prop.getValueAsBoolean(this.properties);
    }

    public Map<String, Object> getAdditionalProperties() {
        HashMap<String, Object> additional = new HashMap<String, Object>(this.properties);
        for (ConfigProperty configProperty : CONFIG_PROPERTIES) {
            additional.remove(configProperty.getKey());
        }
        HashMap integerProperties = new HashMap();
        additional.forEach((key, v) -> {
            try {
                int intVal = Integer.parseInt((String)v);
                integerProperties.put(key.toString(), intVal);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        });
        additional.putAll(integerProperties);
        return additional;
    }

    public static void readZkProps(Map<String, Object> properties, Properties zkProps) {
        HashMap<Object, Object> zkPropsUnprocessed = new HashMap<Object, Object>(zkProps);
        for (ConfigProperty configKey : CONFIG_PROPERTIES) {
            if (properties.get(configKey.getKey()) != null && !((String)properties.get(configKey.getKey())).isBlank()) continue;
            properties.put(configKey.getKey(), zkProps.getProperty(configKey.getKey()));
            zkPropsUnprocessed.remove(configKey.getKey());
        }
        zkPropsUnprocessed.forEach((key, val) -> {
            if (properties.get(key) == null) {
                properties.put((String)key, val);
            }
        });
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(128);
        for (ConfigProperty configProperty : CONFIG_PROPERTIES) {
            if (this.properties.get(configProperty.getKey()) == null) continue;
            String printablePropertyValue = SensitivePropRedactionUtils.redactPropertyIfNecessary(configProperty.getKey(), String.valueOf(this.properties.get(configProperty.getKey())));
            sb.append(configProperty.getKey()).append("=").append(printablePropertyValue).append(",");
        }
        if (sb.length() > 0) {
            sb.setLength(sb.length() - 1);
        }
        return "KafkaCrossDcConf{" + String.valueOf(sb) + "}";
    }

    static {
        ArrayList<ConfigProperty> configProperties = new ArrayList<ConfigProperty>(List.of(new ConfigProperty(TOPIC_NAME), new ConfigProperty(DLQ_TOPIC_NAME), new ConfigProperty(MAX_ATTEMPTS, "3"), new ConfigProperty(BOOTSTRAP_SERVERS), new ConfigProperty(BATCH_SIZE_BYTES, DEFAULT_BATCH_SIZE_BYTES), new ConfigProperty(BUFFER_MEMORY_BYTES, DEFAULT_BUFFER_MEMORY_BYTES), new ConfigProperty(LINGER_MS, DEFAULT_LINGER_MS), new ConfigProperty(REQUEST_TIMEOUT_MS, DEFAULT_REQUEST_TIMEOUT), new ConfigProperty(MAX_REQUEST_SIZE_BYTES, DEFAULT_MAX_REQUEST_SIZE), new ConfigProperty(ENABLE_DATA_COMPRESSION, DEFAULT_ENABLE_DATA_COMPRESSION), new ConfigProperty(INDEX_UNMIRRORABLE_DOCS, "false"), new ConfigProperty(SLOW_SUBMIT_THRESHOLD_MS, DEFAULT_SLOW_SEND_THRESHOLD), new ConfigProperty(NUM_RETRIES, DEFAULT_NUM_RETRIES), new ConfigProperty(RETRY_BACKOFF_MS, "500"), new ConfigProperty(DELIVERY_TIMEOUT_MS, DEFAULT_DELIVERY_TIMEOUT_MS), new ConfigProperty(ZK_CONNECT_STRING, null), new ConfigProperty(FETCH_MIN_BYTES, DEFAULT_FETCH_MIN_BYTES), new ConfigProperty(FETCH_MAX_BYTES, DEFAULT_FETCH_MAX_BYTES), new ConfigProperty(FETCH_MAX_WAIT_MS, "500"), new ConfigProperty(CONSUMER_PROCESSING_THREADS, DEFAULT_CONSUMER_PROCESSING_THREADS), new ConfigProperty(MAX_POLL_INTERVAL_MS, DEFAULT_MAX_POLL_INTERVAL_MS), new ConfigProperty(SESSION_TIMEOUT_MS, DEFAULT_SESSION_TIMEOUT_MS), new ConfigProperty(MIRROR_COLLECTIONS, DEFAULT_MIRROR_COLLECTIONS), new ConfigProperty(MIRROR_COMMITS, "false"), new ConfigProperty("solr.crossdc.expandDbq", DEFAULT_EXPAND_DBQ), new ConfigProperty("solr.crossdc.collapseUpdates", DEFAULT_COLLAPSE_UPDATES), new ConfigProperty("solr.crossdc.maxCollapseRecords", "500"), new ConfigProperty(MAX_PARTITION_FETCH_BYTES, DEFAULT_MAX_PARTITION_FETCH_BYTES), new ConfigProperty(MAX_POLL_RECORDS, "500"), new ConfigProperty(PORT, DEFAULT_PORT), new ConfigProperty(GROUP_ID, DEFAULT_GROUP_ID)));
        SECURITY_CONFIG_PROPERTIES = List.of(new ConfigProperty("ssl.protocol"), new ConfigProperty("ssl.provider"), new ConfigProperty("ssl.cipher.suites"), new ConfigProperty("ssl.enabled.protocols"), new ConfigProperty("ssl.keystore.type"), new ConfigProperty("ssl.keystore.location"), new ConfigProperty("ssl.keystore.password"), new ConfigProperty("ssl.key.password"), new ConfigProperty("ssl.keystore.key"), new ConfigProperty("ssl.keystore.certificate.chain"), new ConfigProperty("ssl.truststore.certificates"), new ConfigProperty("ssl.truststore.type"), new ConfigProperty("ssl.truststore.location"), new ConfigProperty("ssl.truststore.password"), new ConfigProperty("ssl.keymanager.algorithm"), new ConfigProperty("ssl.trustmanager.algorithm"), new ConfigProperty("ssl.endpoint.identification.algorithm"), new ConfigProperty("ssl.secure.random.implementation"), new ConfigProperty("ssl.client.auth"), new ConfigProperty("security.protocol"), new ConfigProperty("security.providers"));
        configProperties.addAll(SECURITY_CONFIG_PROPERTIES);
        CONFIG_PROPERTIES = Collections.unmodifiableList(configProperties);
        HashMap configPropertiesMap = CollectionUtil.newHashMap((int)CONFIG_PROPERTIES.size());
        for (ConfigProperty prop : CONFIG_PROPERTIES) {
            configPropertiesMap.put(prop.getKey(), prop);
        }
        CONFIG_PROPERTIES_MAP = configPropertiesMap;
    }
}

