/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.servlet;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.Map;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.request.beans.RateLimiterPayload;
import org.apache.solr.common.cloud.SolrZkClient;
import org.apache.solr.common.util.Utils;
import org.apache.solr.core.RateLimiterConfig;
import org.apache.solr.servlet.RequestRateLimiter;
import org.apache.solr.util.SolrJacksonAnnotationInspector;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.data.Stat;

public class QueryRateLimiter
extends RequestRateLimiter {
    private static final ObjectMapper mapper = SolrJacksonAnnotationInspector.createObjectMapper();

    public QueryRateLimiter(SolrZkClient solrZkClient) {
        super(QueryRateLimiter.constructQueryRateLimiterConfig(solrZkClient));
    }

    public QueryRateLimiter(RateLimiterConfig config) {
        super(config);
    }

    public static RateLimiterConfig processConfigChange(SolrRequest.SolrRequestType requestType, RateLimiterConfig rateLimiterConfig, Map<String, Object> properties) throws IOException {
        byte[] configInput = Utils.toJSON((Object)properties.get("rate-limiters"));
        RateLimiterPayload rateLimiterMeta = configInput == null || configInput.length == 0 ? null : (RateLimiterPayload)mapper.readValue(configInput, RateLimiterPayload.class);
        if (rateLimiterConfig == null || rateLimiterConfig.shouldUpdate(rateLimiterMeta)) {
            return new RateLimiterConfig(requestType, rateLimiterMeta);
        }
        return null;
    }

    private static RateLimiterConfig constructQueryRateLimiterConfig(SolrZkClient zkClient) {
        try {
            if (zkClient == null) {
                return new RateLimiterConfig(SolrRequest.SolrRequestType.QUERY);
            }
            Map clusterPropsJson = (Map)Utils.fromJSON((byte[])zkClient.getData("/clusterprops.json", null, new Stat(), true));
            byte[] configInput = Utils.toJSON(clusterPropsJson.get("rate-limiters"));
            if (configInput.length == 0) {
                return new RateLimiterConfig(SolrRequest.SolrRequestType.QUERY);
            }
            RateLimiterPayload rateLimiterMeta = (RateLimiterPayload)mapper.readValue(configInput, RateLimiterPayload.class);
            return new RateLimiterConfig(SolrRequest.SolrRequestType.QUERY, rateLimiterMeta);
        }
        catch (KeeperException.NoNodeException e) {
            return new RateLimiterConfig(SolrRequest.SolrRequestType.QUERY);
        }
        catch (InterruptedException | KeeperException e) {
            throw new RuntimeException("Error reading cluster property", SolrZkClient.checkInterrupted((Throwable)e));
        }
        catch (IOException e) {
            throw new RuntimeException("Encountered an IOException " + e.getMessage());
        }
    }
}

