/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.databind.ser.std;

import java.util.function.UnaryOperator;
import tools.jackson.databind.BeanProperty;
import tools.jackson.databind.JavaType;
import tools.jackson.databind.SerializationContext;
import tools.jackson.databind.ValueSerializer;
import tools.jackson.databind.jsontype.TypeSerializer;
import tools.jackson.databind.ser.impl.PropertySerializerMap;
import tools.jackson.databind.ser.std.StdSerializer;

public abstract class StdDynamicSerializer<T>
extends StdSerializer<T> {
    protected final BeanProperty _property;
    protected final TypeSerializer _valueTypeSerializer;
    protected final ValueSerializer<Object> _valueSerializer;
    protected PropertySerializerMap _dynamicValueSerializers = PropertySerializerMap.emptyForProperties();

    protected StdDynamicSerializer(JavaType type, BeanProperty prop, TypeSerializer vts, ValueSerializer<?> valueSer) {
        super(type);
        this._property = prop;
        this._valueTypeSerializer = vts;
        this._valueSerializer = valueSer;
    }

    protected StdDynamicSerializer(StdDynamicSerializer<?> src, BeanProperty prop) {
        super(src);
        this._property = prop;
        this._valueTypeSerializer = src._valueTypeSerializer;
        this._valueSerializer = src._valueSerializer;
    }

    protected StdDynamicSerializer(StdDynamicSerializer<?> src, BeanProperty prop, TypeSerializer vts, ValueSerializer<?> valueSer) {
        super(src);
        this._property = prop;
        this._valueTypeSerializer = vts;
        this._valueSerializer = valueSer;
    }

    protected final ValueSerializer<Object> _findAndAddDynamic(SerializationContext ctxt, Class<?> type) {
        PropertySerializerMap map = this._dynamicValueSerializers;
        PropertySerializerMap.SerializerAndMapResult result = map.findAndAddSecondarySerializer(type, ctxt, this._property);
        if (map != result.map) {
            this._dynamicValueSerializers = result.map;
        }
        return result.serializer;
    }

    protected final ValueSerializer<Object> _findAndAddDynamic(SerializationContext ctxt, Class<?> type, UnaryOperator<ValueSerializer<Object>> serTransformer) {
        PropertySerializerMap map = this._dynamicValueSerializers;
        PropertySerializerMap.SerializerAndMapResult result = map.findAndAddSecondarySerializer(type, ctxt, this._property, serTransformer);
        if (map != result.map) {
            this._dynamicValueSerializers = result.map;
        }
        return result.serializer;
    }

    protected final ValueSerializer<Object> _findAndAddDynamic(SerializationContext ctxt, JavaType type) {
        PropertySerializerMap map = this._dynamicValueSerializers;
        PropertySerializerMap.SerializerAndMapResult result = map.findAndAddSecondarySerializer(type, ctxt, this._property);
        if (map != result.map) {
            this._dynamicValueSerializers = result.map;
        }
        return result.serializer;
    }

    protected final ValueSerializer<Object> _findAndAddDynamic(SerializationContext ctxt, JavaType type, UnaryOperator<ValueSerializer<Object>> serTransformer) {
        PropertySerializerMap map = this._dynamicValueSerializers;
        PropertySerializerMap.SerializerAndMapResult result = map.findAndAddSecondarySerializer(type, ctxt, this._property, serTransformer);
        if (map != result.map) {
            this._dynamicValueSerializers = result.map;
        }
        return result.serializer;
    }
}

