/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.regex.charset;

import com.oracle.truffle.regex.charset.ClassSetContents;
import com.oracle.truffle.regex.charset.CodePointSet;
import com.oracle.truffle.regex.charset.CodePointSetAccumulator;
import com.oracle.truffle.regex.tregex.string.Encodings;
import org.graalvm.collections.EconomicSet;

public class ClassSetContentsAccumulator {
    private final CodePointSetAccumulator codePointSet = new CodePointSetAccumulator();
    private final EconomicSet<String> strings = EconomicSet.create();
    private boolean mayContainStrings = false;

    public void addAll(ClassSetContents classSet) {
        this.codePointSet.addSet(classSet.getCodePointSet());
        this.strings.addAll(classSet.getStrings());
        this.mayContainStrings |= classSet.mayContainStrings();
    }

    public void retainAll(ClassSetContents classSet) {
        this.codePointSet.intersectWith(classSet.getCodePointSet());
        this.strings.retainAll(classSet.getStrings());
        this.mayContainStrings = this.mayContainStrings && classSet.mayContainStrings();
    }

    public void removeAll(ClassSetContents classSet, Encodings.Encoding encoding) {
        this.codePointSet.subtract(classSet.getCodePointSet(), encoding);
        this.strings.removeAll(classSet.getStrings());
    }

    public CodePointSet getCodePointSet() {
        return this.codePointSet.toCodePointSet();
    }

    public EconomicSet<String> getStrings() {
        return this.strings;
    }

    public boolean isCodePointSetOnly() {
        return this.strings.isEmpty();
    }

    public boolean mayContainStrings() {
        return this.mayContainStrings;
    }

    public void clear() {
        this.codePointSet.clear();
        this.strings.clear();
    }
}

