/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.jcc.dbpool;

import com.ibm.db2.jcc.DB2ConnectionPoolDataSource;
import com.ibm.db2.jcc.DB2Driver;
import com.ibm.db2.jcc.DB2PooledConnection;
import com.ibm.db2.jcc.DB2SimpleDataSource;
import com.ibm.db2.jcc.am.Connection;
import com.ibm.db2.jcc.am.ErrorKey;
import com.ibm.db2.jcc.am.b5;
import com.ibm.db2.jcc.am.c8;
import com.ibm.db2.jcc.am.kr;
import com.ibm.db2.jcc.dbpool.DB2BaseConnectionPool;
import com.ibm.db2.jcc.dbpool.b;
import com.ibm.db2.jcc.dbpool.c;
import com.ibm.db2.jcc.dbpool.d;
import java.lang.reflect.Field;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Properties;

public final class DB2ConnectionPool
extends DB2BaseConnectionPool {
    private b connectionEventHandler;
    private c poolInfo = new c(this);

    public DB2ConnectionPool() {
        this.connectionEventHandler = new b(this);
    }

    public DB2ConnectionPool(DB2SimpleDataSource dB2SimpleDataSource) throws SQLException {
        this.connectionEventHandler = new b(this);
        this.initializePooolableDataSource(dB2SimpleDataSource);
        Properties properties = dB2SimpleDataSource.getProperties(true);
        d d10 = new d(this.sds, this);
        d10.a(properties);
        this.createPool();
    }

    public DB2ConnectionPool(DB2ConnectionPoolDataSource dB2ConnectionPoolDataSource) throws SQLException {
        this.connectionEventHandler = new b(this);
        this.initializePooolableDataSource(dB2ConnectionPoolDataSource);
        this.createPool();
    }

    public DB2ConnectionPool(String string, Properties properties) throws SQLException {
        this.connectionEventHandler = new b(this);
        if (properties == null) {
            properties = new Properties();
        }
        properties.put("JCC_INTERNAL_KEY_TO_GET_INTERNAL_DATASOURCE_dbpoolcrt_", "JCC_INTERNAL_KEY_TO_GET_INTERNAL_DATASOURCE_dbpoolcrt_");
        new DB2Driver().connect(string, properties);
        DB2SimpleDataSource dB2SimpleDataSource = (DB2SimpleDataSource)properties.remove("JCC_INTERNAL_KEY_TO_GET_INTERNAL_DATASOURCE_dbpoolcrt_");
        Properties properties2 = dB2SimpleDataSource.getProperties();
        this.initializePooolableDataSource(dB2SimpleDataSource);
        d d10 = new d(this.sds, this);
        d10.a(properties2);
        this.createPool();
    }

    @Override
    public String getPoolStats() {
        if (this.poolInfo != null) {
            return this.poolInfo.e();
        }
        return "pool not intitalized";
    }

    @Override
    protected void onExit(StringBuilder stringBuilder) {
        this.poolInfo.a("OnExit close:" + this.poolInfo.e());
    }

    /*
     * Loose catch block
     */
    private java.sql.Connection getNewConn() throws SQLException {
        int n2 = 1;
        int n3 = 0;
        while (n3 < this.getAcquireRetryAttempts()) {
            try {
                c8 c82;
                block15: {
                    block16: {
                        DB2PooledConnection dB2PooledConnection = this.createPool();
                        this.poolInfo.b(dB2PooledConnection);
                        c82 = (c8)dB2PooledConnection.getConnection();
                        if (!this.testConnectionOnCheckin) break block15;
                        if (c82.getDB2Object() == null) break block15;
                        break block16;
                        catch (SQLException sQLException) {
                            throw DB2ConnectionPool.b(sQLException);
                        }
                    }
                    try {
                        block17: {
                            if (((Connection)c82.getDB2Object()).isSysplexWLBEnabled_) break block15;
                            break block17;
                            catch (SQLException sQLException) {
                                throw DB2ConnectionPool.b(sQLException);
                            }
                        }
                        this.testCheckedOutConnection(c82);
                    }
                    catch (SQLException sQLException) {
                        throw DB2ConnectionPool.b(sQLException);
                    }
                }
                return c82;
            }
            catch (SQLException sQLException) {
                try {
                    if (n2 >= this.getAcquireRetryAttempts()) {
                        throw sQLException;
                    }
                }
                catch (SQLException sQLException2) {
                    throw DB2ConnectionPool.b(sQLException2);
                }
                try {
                    if (this.getAcquireRetryDelay() > 0) {
                        this.sleep(this.getAcquireRetryDelay());
                    }
                }
                catch (SQLException sQLException3) {
                    throw DB2ConnectionPool.b(sQLException3);
                }
                ++n2;
                ++n2;
            }
        }
        return null;
    }

    public java.sql.Connection getConnection() throws SQLException {
        DB2PooledConnection dB2PooledConnection = this.poolInfo.c();
        if (dB2PooledConnection != null) {
            c8 c82 = (c8)dB2PooledConnection.getConnection();
            return c82;
        }
        int n2 = this.poolInfo.a();
        if (n2 >= this.maxPoolSize) {
            SQLException sQLException = b5.a(DB2ConnectionPool.class, null, ErrorKey.EXCEEDED_MAX_CONNECTION_POOL_SIZE, null, "14263", null);
            throw sQLException;
        }
        return this.getNewConn();
    }

    public int getUsedConnectionsCount() {
        return this.poolInfo.a();
    }

    public int getFreeConnectionsCount() {
        return this.maxPoolSize - this.poolInfo.a();
    }

    public int getTotalConnections() {
        return this.maxPoolSize;
    }

    public void testConnection() throws SQLException {
        java.sql.Connection connection = this.getConnection();
        kr kr2 = (kr)connection.createStatement();
        ResultSet resultSet = kr2.executeQuery(this.preferredTestQuery);
        if (resultSet.next()) {
            Date date = resultSet.getDate(1);
        }
        resultSet.close();
        kr2.close();
        connection.close();
    }

    private void testCheckedOutConnection(java.sql.Connection connection) throws SQLException {
        kr kr2 = (kr)connection.createStatement();
        ResultSet resultSet = kr2.executeQuery(this.preferredTestQuery);
        if (resultSet.next()) {
            Date date = resultSet.getDate(1);
        }
        resultSet.close();
        kr2.close();
    }

    synchronized DB2PooledConnection createPool() throws SQLException {
        DB2PooledConnection dB2PooledConnection = (DB2PooledConnection)this.sds.getPooledConnection(this.sds.getUser(), this.retrievePassword());
        dB2PooledConnection.addConnectionEventListener(this.connectionEventHandler);
        return dB2PooledConnection;
    }

    private String retrievePassword() {
        block5: {
            block4: {
                String string = "";
                try {
                    if (this.password != null && this.password.length() > 1) break block4;
                }
                catch (Exception exception) {
                    throw DB2ConnectionPool.b(exception);
                }
                try {
                    Field field = this.sds.getClass().getDeclaredField("password");
                    field.setAccessible(true);
                    string = field.get(this.sds) + "";
                    return string;
                }
                catch (Exception exception) {
                    this.logPoolInfo("exception while getting password", exception.toString());
                }
                break block5;
            }
            return this.password;
        }
        return "";
    }

    static c access$000(DB2ConnectionPool dB2ConnectionPool) {
        return dB2ConnectionPool.poolInfo;
    }

    static b access$100(DB2ConnectionPool dB2ConnectionPool) {
        return dB2ConnectionPool.connectionEventHandler;
    }

    private static Exception b(Exception exception) {
        return exception;
    }
}

