/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.nodes.arrow;

import com.oracle.graal.python.builtins.objects.cext.common.NativePointer;
import com.oracle.graal.python.nodes.PNodeWithContext;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.graal.python.runtime.arrow.ArrowUtil;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.nfi.api.SignatureLibrary;

@GenerateCached
@GenerateInline(inlineByDefault=true)
@GenerateUncached
public abstract class InvokeArrowReleaseCallbackNode
extends PNodeWithContext {
    public abstract void execute(Node var1, long var2, long var4);

    public final void executeCached(long releaseCallback, long baseStructure) {
        this.execute(this, releaseCallback, baseStructure);
    }

    @Specialization
    static void doIt(Node inliningTarget, long releaseCallback, long baseStructure, @Bind(value="getContext(inliningTarget)") PythonContext ctx, @Cached(value="createReleaseCallbackSignature(ctx)", allowUncached=true) Object callbackSignature, @CachedLibrary(limit="1") SignatureLibrary signatureLibrary) {
        try {
            signatureLibrary.call(callbackSignature, (Object)new NativePointer(releaseCallback), new Object[]{baseStructure});
        }
        catch (Exception e) {
            throw CompilerDirectives.shouldNotReachHere((String)"Unable to call release callback. Error:", (Throwable)e);
        }
    }

    @NeverDefault
    static Object createReleaseCallbackSignature(PythonContext context) {
        return ArrowUtil.createNfiSignature("(UINT64):VOID", context);
    }

    @GenerateCached(value=false)
    @GenerateInline
    @GenerateUncached
    public static abstract class Lazy
    extends Node {
        public final InvokeArrowReleaseCallbackNode get(Node inliningTarget) {
            return this.execute(inliningTarget);
        }

        abstract InvokeArrowReleaseCallbackNode execute(Node var1);

        @Specialization
        static InvokeArrowReleaseCallbackNode doIt(@Cached(inline=false) InvokeArrowReleaseCallbackNode node) {
            return node;
        }
    }
}

