/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.core.base;

import java.io.DataInput;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import tools.jackson.core.ErrorReportConfiguration;
import tools.jackson.core.JacksonException;
import tools.jackson.core.JsonGenerator;
import tools.jackson.core.StreamReadConstraints;
import tools.jackson.core.StreamWriteConstraints;
import tools.jackson.core.TSFBuilder;
import tools.jackson.core.TokenStreamFactory;
import tools.jackson.core.io.IOContext;
import tools.jackson.core.io.InputDecorator;
import tools.jackson.core.io.OutputDecorator;
import tools.jackson.core.util.JsonGeneratorDecorator;

public abstract class DecorableTSFactory
extends TokenStreamFactory
implements Serializable {
    private static final long serialVersionUID = 3L;
    protected final InputDecorator _inputDecorator;
    protected final OutputDecorator _outputDecorator;
    protected List<JsonGeneratorDecorator> _generatorDecorators;

    protected DecorableTSFactory(StreamReadConstraints src, StreamWriteConstraints swc, ErrorReportConfiguration erc, int formatPF, int formatGF) {
        super(src, swc, erc, formatPF, formatGF);
        this._inputDecorator = null;
        this._outputDecorator = null;
        this._generatorDecorators = null;
    }

    protected DecorableTSFactory(DecorableTSFBuilder<?, ?> baseBuilder) {
        super(baseBuilder);
        this._inputDecorator = baseBuilder.inputDecorator();
        this._outputDecorator = baseBuilder.outputDecorator();
        this._generatorDecorators = DecorableTSFactory._copy(baseBuilder.generatorDecorators());
    }

    protected DecorableTSFactory(DecorableTSFactory src) {
        super(src);
        this._inputDecorator = src.getInputDecorator();
        this._outputDecorator = src.getOutputDecorator();
        this._generatorDecorators = DecorableTSFactory._copy(src._generatorDecorators);
    }

    protected static <T> List<T> _copy(List<T> src) {
        if (src == null) {
            return src;
        }
        return new ArrayList<T>(src);
    }

    public OutputDecorator getOutputDecorator() {
        return this._outputDecorator;
    }

    public InputDecorator getInputDecorator() {
        return this._inputDecorator;
    }

    public List<JsonGeneratorDecorator> getGeneratorDecorators() {
        return DecorableTSFactory._copy(this._generatorDecorators);
    }

    protected InputStream _decorate(IOContext ioCtxt, InputStream in) throws JacksonException {
        InputStream in2;
        if (this._inputDecorator != null && (in2 = this._inputDecorator.decorate(ioCtxt, in)) != null) {
            return in2;
        }
        return in;
    }

    protected Reader _decorate(IOContext ioCtxt, Reader in) throws JacksonException {
        Reader in2;
        if (this._inputDecorator != null && (in2 = this._inputDecorator.decorate(ioCtxt, in)) != null) {
            return in2;
        }
        return in;
    }

    protected DataInput _decorate(IOContext ioCtxt, DataInput in) throws JacksonException {
        DataInput in2;
        if (this._inputDecorator != null && (in2 = this._inputDecorator.decorate(ioCtxt, in)) != null) {
            return in2;
        }
        return in;
    }

    protected OutputStream _decorate(IOContext ioCtxt, OutputStream out) throws JacksonException {
        OutputStream out2;
        if (this._outputDecorator != null && (out2 = this._outputDecorator.decorate(ioCtxt, out)) != null) {
            return out2;
        }
        return out;
    }

    protected Writer _decorate(IOContext ioCtxt, Writer out) throws JacksonException {
        Writer out2;
        if (this._outputDecorator != null && (out2 = this._outputDecorator.decorate(ioCtxt, out)) != null) {
            return out2;
        }
        return out;
    }

    protected JsonGenerator _decorate(JsonGenerator result) {
        if (this._generatorDecorators != null) {
            for (JsonGeneratorDecorator decorator : this._generatorDecorators) {
                result = decorator.decorate(this, result);
            }
        }
        return result;
    }

    public static abstract class DecorableTSFBuilder<F extends TokenStreamFactory, T extends TSFBuilder<F, T>>
    extends TSFBuilder<F, T> {
        protected InputDecorator _inputDecorator;
        protected OutputDecorator _outputDecorator;
        protected List<JsonGeneratorDecorator> _generatorDecorators;

        protected DecorableTSFBuilder(StreamReadConstraints src, StreamWriteConstraints swc, ErrorReportConfiguration erc, int formatPF, int formatGF) {
            super(src, swc, erc, formatPF, formatGF);
            this._inputDecorator = null;
            this._outputDecorator = null;
            this._generatorDecorators = null;
        }

        protected DecorableTSFBuilder(DecorableTSFactory base) {
            super(base);
            this._inputDecorator = base.getInputDecorator();
            this._outputDecorator = base.getOutputDecorator();
            this._generatorDecorators = base.getGeneratorDecorators();
        }

        public InputDecorator inputDecorator() {
            return this._inputDecorator;
        }

        public OutputDecorator outputDecorator() {
            return this._outputDecorator;
        }

        public List<JsonGeneratorDecorator> generatorDecorators() {
            return this._generatorDecorators;
        }

        public T inputDecorator(InputDecorator dec) {
            this._inputDecorator = dec;
            return (T)this._this();
        }

        public T outputDecorator(OutputDecorator dec) {
            this._outputDecorator = dec;
            return (T)this._this();
        }

        public T addDecorator(JsonGeneratorDecorator dec) {
            if (this._generatorDecorators == null) {
                this._generatorDecorators = new ArrayList<JsonGeneratorDecorator>();
            }
            this._generatorDecorators.add(dec);
            return (T)this._this();
        }
    }
}

