/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.assembler;

import com.strobel.core.IFreezable;
import com.strobel.core.VerifyArgument;
import java.util.AbstractList;
import java.util.ArrayList;

public class Collection<E>
extends AbstractList<E>
implements IFreezable {
    private final ArrayList<E> _items = new ArrayList();
    private boolean _isFrozen;

    @Override
    public final int size() {
        return this._items.size();
    }

    @Override
    public final E get(int index) {
        return this._items.get(index);
    }

    @Override
    public final boolean add(E e) {
        this.verifyNotFrozen();
        this.add(this.size(), e);
        return true;
    }

    @Override
    public final E set(int index, E element) {
        this.verifyNotFrozen();
        VerifyArgument.notNull(element, "element");
        this.beforeSet(index, element);
        return this._items.set(index, element);
    }

    @Override
    public void add(int index, E element) {
        this.verifyNotFrozen();
        VerifyArgument.notNull(element, "element");
        this.addCore(index, element);
    }

    protected final void addCore(int index, E element) {
        boolean append = index == this.size();
        this._items.add(index, element);
        this.afterAdd(index, element, append);
    }

    @Override
    public final E remove(int index) {
        this.verifyNotFrozen();
        E e = this._items.remove(index);
        if (e != null) {
            this.afterRemove(index, e);
        }
        return e;
    }

    @Override
    public final void clear() {
        this.verifyNotFrozen();
        this.beforeClear();
        this._items.clear();
    }

    @Override
    public final boolean remove(Object o) {
        this.verifyNotFrozen();
        int index = this._items.indexOf(o);
        return index >= 0 && this.remove(index) != null;
    }

    protected void afterAdd(int index, E e, boolean appended) {
    }

    protected void beforeSet(int index, E e) {
    }

    protected void afterRemove(int index, E e) {
    }

    protected void beforeClear() {
    }

    @Override
    public boolean canFreeze() {
        return !this.isFrozen();
    }

    @Override
    public final boolean isFrozen() {
        return this._isFrozen;
    }

    @Override
    public final void freeze() {
        this.freeze(true);
    }

    public final void freeze(boolean freezeContents) {
        if (!this.canFreeze()) {
            throw new IllegalStateException("Collection cannot be frozen.  Be sure to check canFreeze() before calling freeze(), or use the tryFreeze() method instead.");
        }
        this.freezeCore(freezeContents);
        this._isFrozen = true;
    }

    protected void freezeCore(boolean freezeContents) {
        if (freezeContents) {
            for (E item : this._items) {
                if (!(item instanceof IFreezable)) continue;
                ((IFreezable)item).freezeIfUnfrozen();
            }
        }
    }

    protected final void verifyNotFrozen() {
        if (this.isFrozen()) {
            throw new IllegalStateException("Frozen collections cannot be modified.");
        }
    }

    protected final void verifyFrozen() {
        if (!this.isFrozen()) {
            throw new IllegalStateException("Collection must be frozen before performing this operation.");
        }
    }

    @Override
    public final boolean tryFreeze() {
        if (!this.canFreeze()) {
            return false;
        }
        try {
            this.freeze();
            return true;
        }
        catch (Throwable t) {
            return false;
        }
    }

    @Override
    public final void freezeIfUnfrozen() throws IllegalStateException {
        if (this.isFrozen()) {
            return;
        }
        this.freeze();
    }
}

