/*
 * Decompiled with CFR 0.152.
 */
package io.jsonwebtoken.impl.security;

import io.jsonwebtoken.impl.io.Streams;
import io.jsonwebtoken.impl.lang.Nameable;
import io.jsonwebtoken.impl.lang.Parameter;
import io.jsonwebtoken.impl.lang.ParameterReadable;
import io.jsonwebtoken.impl.lang.Parameters;
import io.jsonwebtoken.impl.security.DefaultJwkThumbprint;
import io.jsonwebtoken.impl.security.DefaultRequest;
import io.jsonwebtoken.impl.security.JwkContext;
import io.jsonwebtoken.impl.security.KeyOperationConverter;
import io.jsonwebtoken.lang.Arrays;
import io.jsonwebtoken.lang.Assert;
import io.jsonwebtoken.lang.Collections;
import io.jsonwebtoken.lang.Objects;
import io.jsonwebtoken.lang.Strings;
import io.jsonwebtoken.lang.Supplier;
import io.jsonwebtoken.security.HashAlgorithm;
import io.jsonwebtoken.security.Jwk;
import io.jsonwebtoken.security.JwkThumbprint;
import io.jsonwebtoken.security.Jwks;
import io.jsonwebtoken.security.KeyOperation;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class AbstractJwk<K extends Key>
implements Jwk<K>,
ParameterReadable,
Nameable {
    static final Parameter<String> ALG = Parameters.string("alg", "Algorithm");
    public static final Parameter<String> KID = Parameters.string("kid", "Key ID");
    static final Parameter<Set<KeyOperation>> KEY_OPS = (Parameter)Parameters.builder(KeyOperation.class).setConverter(KeyOperationConverter.DEFAULT).set().setId("key_ops").setName("Key Operations").build();
    static final Parameter<String> KTY = Parameters.string("kty", "Key Type");
    static final Set<Parameter<?>> PARAMS = Collections.setOf((Object[])new Parameter[]{ALG, KID, KEY_OPS, KTY});
    public static final String IMMUTABLE_MSG = "JWKs are immutable and may not be modified.";
    protected final JwkContext<K> context;
    private final List<Parameter<?>> THUMBPRINT_PARAMS;
    private final int hashCode;

    AbstractJwk(JwkContext<K> ctx, List<Parameter<?>> thumbprintParams) {
        this.context = (JwkContext)Assert.notNull(ctx, (String)"JwkContext cannot be null.");
        Assert.isTrue((!ctx.isEmpty() ? 1 : 0) != 0, (String)"JwkContext cannot be empty.");
        Assert.hasText((CharSequence)ctx.getType(), (String)"JwkContext type cannot be null or empty.");
        Assert.notNull(ctx.getKey(), (String)"JwkContext key cannot be null.");
        this.THUMBPRINT_PARAMS = (List)Assert.notEmpty(thumbprintParams, (String)"JWK Thumbprint parameters cannot be null or empty.");
        HashAlgorithm idThumbprintAlg = ctx.getIdThumbprintAlgorithm();
        if (!Strings.hasText((String)this.getId()) && idThumbprintAlg != null) {
            JwkThumbprint thumbprint = this.thumbprint(idThumbprintAlg);
            String kid = thumbprint.toString();
            ctx.setId(kid);
        }
        this.hashCode = this.computeHashCode();
    }

    private int computeHashCode() {
        ArrayList<Object> list = new ArrayList<Object>(this.THUMBPRINT_PARAMS.size() + 1);
        Key key = (Key)Assert.notNull(this.toKey(), (String)"JWK toKey() value cannot be null.");
        if (key instanceof PublicKey) {
            list.add("Public");
        } else if (key instanceof PrivateKey) {
            list.add("Private");
        }
        for (Parameter<?> param : this.THUMBPRINT_PARAMS) {
            Object val = Assert.notNull(this.get(param), (String)"computeHashCode: Parameter idiomatic value cannot be null.");
            list.add(val);
        }
        return Objects.nullSafeHashCode((Object[])list.toArray());
    }

    private String getRequiredThumbprintValue(Parameter<?> param) {
        Object value = this.get(param.getId());
        if (value instanceof Supplier) {
            value = ((Supplier)value).get();
        }
        return (String)Assert.isInstanceOf(String.class, (Object)value, (String)"Parameter canonical value is not a String.");
    }

    private String toThumbprintJson() {
        StringBuilder sb = new StringBuilder().append('{');
        Iterator<Parameter<?>> i = this.THUMBPRINT_PARAMS.iterator();
        while (i.hasNext()) {
            Parameter<?> param = i.next();
            String value = this.getRequiredThumbprintValue(param);
            sb.append('\"').append(param.getId()).append("\":\"").append(value).append('\"');
            if (!i.hasNext()) continue;
            sb.append(",");
        }
        sb.append('}');
        return sb.toString();
    }

    public JwkThumbprint thumbprint() {
        return this.thumbprint(Jwks.HASH.SHA256);
    }

    public JwkThumbprint thumbprint(HashAlgorithm alg) {
        String json = this.toThumbprintJson();
        Assert.hasText((CharSequence)json, (String)"Canonical JWK Thumbprint JSON cannot be null or empty.");
        byte[] bytes = json.getBytes(StandardCharsets.UTF_8);
        InputStream in = Streams.of(bytes);
        byte[] digest = alg.digest(new DefaultRequest<InputStream>(in, this.context.getProvider(), this.context.getRandom()));
        return new DefaultJwkThumbprint(digest, alg);
    }

    public String getType() {
        return this.context.getType();
    }

    @Override
    public String getName() {
        return this.context.getName();
    }

    public Set<KeyOperation> getOperations() {
        return Collections.immutable(this.context.getOperations());
    }

    public String getAlgorithm() {
        return this.context.getAlgorithm();
    }

    public String getId() {
        return this.context.getId();
    }

    public K toKey() {
        return this.context.getKey();
    }

    public int size() {
        return this.context.size();
    }

    public boolean isEmpty() {
        return this.context.isEmpty();
    }

    public boolean containsKey(Object key) {
        return this.context.containsKey(key);
    }

    public boolean containsValue(Object value) {
        return this.context.containsValue(value);
    }

    public Object get(Object key) {
        Object val = this.context.get(key);
        if (val instanceof Map) {
            return Collections.immutable((Map)((Map)val));
        }
        if (val instanceof Collection) {
            return Collections.immutable((Collection)((Collection)val));
        }
        if (Objects.isArray((Object)val)) {
            return Arrays.copy((Object)val);
        }
        return val;
    }

    @Override
    public <T> T get(Parameter<T> param) {
        return (T)this.context.get(param);
    }

    public Set<String> keySet() {
        return Collections.immutable((Set)this.context.keySet());
    }

    public Collection<Object> values() {
        return Collections.immutable((Collection)this.context.values());
    }

    public Set<Map.Entry<String, Object>> entrySet() {
        return Collections.immutable((Set)this.context.entrySet());
    }

    private static Object immutable() {
        throw new UnsupportedOperationException(IMMUTABLE_MSG);
    }

    public Object put(String s, Object o) {
        return AbstractJwk.immutable();
    }

    public Object remove(Object o) {
        return AbstractJwk.immutable();
    }

    public void putAll(Map<? extends String, ?> m) {
        AbstractJwk.immutable();
    }

    public void clear() {
        AbstractJwk.immutable();
    }

    public String toString() {
        return this.context.toString();
    }

    public final int hashCode() {
        return this.hashCode;
    }

    public final boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof Jwk) {
            Jwk other = (Jwk)obj;
            return this.getType().equals(other.getType()) && this.equals(other);
        }
        return false;
    }

    protected abstract boolean equals(Jwk<?> var1);
}

