/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.core.criterion;

import javax.annotation.Nonnull;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.StringSupport;
import net.shibboleth.shared.resolver.Criterion;

public final class EntityIdCriterion
implements Criterion {
    @Nonnull
    @NotEmpty
    private final String id;

    public EntityIdCriterion(@Nonnull @NotEmpty String entityId) {
        this.id = Constraint.isNotNull(StringSupport.trimOrNull(entityId), "Entity ID cannot be null or empty");
    }

    @Nonnull
    @NotEmpty
    public String getEntityId() {
        return this.id;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("EntityIdCriterion [id=");
        builder.append(this.id);
        builder.append("]");
        return builder.toString();
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof EntityIdCriterion) {
            return this.id.equals(((EntityIdCriterion)obj).id);
        }
        return false;
    }
}

