/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.common.ssl;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.X509ExtendedKeyManager;
import org.bouncycastle.pkcs.PKCSException;
import org.opensearch.common.ssl.KeyStoreUtil;
import org.opensearch.common.ssl.PemUtils;
import org.opensearch.common.ssl.SslConfigException;
import org.opensearch.common.ssl.SslKeyConfig;

public final class PemKeyConfig
implements SslKeyConfig {
    private final Path certificate;
    private final Path key;
    private final char[] keyPassword;

    public PemKeyConfig(Path certificate, Path key, char[] keyPassword) {
        this.certificate = Objects.requireNonNull(certificate, "Certificate cannot be null");
        this.key = Objects.requireNonNull(key, "Key cannot be null");
        this.keyPassword = Objects.requireNonNull(keyPassword, "Key password cannot be null (but may be empty)");
    }

    @Override
    public Collection<Path> getDependentFiles() {
        return Arrays.asList(this.certificate, this.key);
    }

    @Override
    public X509ExtendedKeyManager createKeyManager() {
        PrivateKey privateKey = this.getPrivateKey();
        List<Certificate> certificates = this.getCertificates();
        try {
            KeyStore keyStore = KeyStoreUtil.buildKeyStore(certificates, privateKey, this.keyPassword);
            return KeyStoreUtil.createKeyManager(keyStore, this.keyPassword, KeyManagerFactory.getDefaultAlgorithm());
        }
        catch (GeneralSecurityException e) {
            throw new SslConfigException("failed to load a KeyManager for certificate/key pair [" + String.valueOf(this.certificate) + "], [" + String.valueOf(this.key) + "]", e);
        }
    }

    private PrivateKey getPrivateKey() {
        try {
            PrivateKey privateKey = PemUtils.readPrivateKey(this.key, () -> this.keyPassword);
            if (privateKey == null) {
                throw new SslConfigException("could not load ssl private key file [" + String.valueOf(this.key) + "]");
            }
            return privateKey;
        }
        catch (FileNotFoundException | NoSuchFileException e) {
            throw new SslConfigException("the configured ssl private key file [" + String.valueOf(this.key.toAbsolutePath()) + "] does not exist", e);
        }
        catch (IOException e) {
            throw new SslConfigException("the configured ssl private key file [" + String.valueOf(this.key.toAbsolutePath()) + "] cannot be read", e);
        }
        catch (PKCSException e) {
            throw new SslConfigException("cannot load ssl private key file [" + String.valueOf(this.key.toAbsolutePath()) + "]", (Exception)((Object)e));
        }
    }

    private List<Certificate> getCertificates() {
        try {
            return PemUtils.readCertificates(Collections.singleton(this.certificate));
        }
        catch (FileNotFoundException | NoSuchFileException e) {
            throw new SslConfigException("the configured ssl certificate file [" + String.valueOf(this.certificate.toAbsolutePath()) + "] does not exist", e);
        }
        catch (IOException e) {
            throw new SslConfigException("the configured ssl certificate file [" + String.valueOf(this.certificate.toAbsolutePath()) + "] cannot be read", e);
        }
        catch (GeneralSecurityException e) {
            throw new SslConfigException("cannot load ssl certificate from [" + String.valueOf(this.certificate.toAbsolutePath()) + "]", e);
        }
    }

    public String toString() {
        return "PEM-key-config{cert=" + String.valueOf(this.certificate.toAbsolutePath()) + " key=" + String.valueOf(this.key.toAbsolutePath()) + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PemKeyConfig that = (PemKeyConfig)o;
        return Objects.equals(this.certificate, that.certificate) && Objects.equals(this.key, that.key) && Arrays.equals(this.keyPassword, that.keyPassword);
    }

    public int hashCode() {
        int result = Objects.hash(this.certificate, this.key);
        result = 31 * result + Arrays.hashCode(this.keyPassword);
        return result;
    }
}

