#!/usr/bin/env ruby

# Copyright (C) 2008 Rapid7, Inc.

#
# This script extracts the forms from the main page of each
# web site in a list. The output of this can be used with
# Metasploit (and other tools) to obtain the saved form data
# of these domains.
#

require 'rubygems'  # install rubygems
require 'hpricot'   # gem install hpricot
require 'timeout'

def usage
  $stderr.puts "#{$0} [site list] [output-dir]"
  exit(0)
end

input = ARGV.shift() || usage()

res = ""
doc = Hpricot(File.open(input))
doc.search("//form").each do |form|

  # Extract the form
  res = "<form"
  form.attributes.each do |attr|
    res << " #{attr[0]}='#{attr[1].gsub("'", "")}'"
  end
  res << "> "

  # Strip out the value
  form.search("//input") do |inp|

    inp.attributes.keys.each do |ikey|
      if (ikey.downcase == "value")
        inp[ikey] = ""
        next
      end

      if(inp.attributes[ikey] =~ /^http/i)
        inp[ikey] = ""
        next
      end

    end

    res << inp.to_html
  end
  res << "</form>"
end

$stdout.puts res
